"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.TextEditorContext = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _atom = require("atom");

var _eventKit = require("event-kit");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const editorUpdateProps = {
  mini: _propTypes["default"].bool,
  readOnly: _propTypes["default"].bool,
  placeholderText: _propTypes["default"].string,
  lineNumberGutterVisible: _propTypes["default"].bool,
  autoHeight: _propTypes["default"].bool,
  autoWidth: _propTypes["default"].bool,
  softWrapped: _propTypes["default"].bool
};

const editorCreationProps = _objectSpread2({
  buffer: _propTypes["default"].object
}, editorUpdateProps);

const EMPTY_CLASS = 'github-AtomTextEditor-empty';

const TextEditorContext = _react["default"].createContext();

exports.TextEditorContext = TextEditorContext;

class AtomTextEditor extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "observeSelections", selection => {
      const selectionSubs = new _eventKit.CompositeDisposable(selection.onDidChangeRange(this.props.didChangeSelectionRange), selection.onDidDestroy(() => {
        selectionSubs.dispose();
        this.subs.remove(selectionSubs);
        this.props.didDestroySelection(selection);
      }));
      this.subs.add(selectionSubs);
      this.props.didAddSelection(selection);
    });

    _defineProperty(this, "observeEmptiness", () => {
      this.getRefModel().map(editor => {
        if (editor.isEmpty() && this.props.hideEmptiness) {
          this.refElement.map(element => element.classList.add(EMPTY_CLASS));
        } else {
          this.refElement.map(element => element.classList.remove(EMPTY_CLASS));
        }

        return null;
      });
    });

    this.subs = new _eventKit.CompositeDisposable();
    this.refParent = new _refHolder["default"]();
    this.refElement = new _refHolder["default"]();
    this.refModel = null;
  }

  render() {
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("div", {
      className: "github-AtomTextEditor-container",
      ref: this.refParent.setter
    }), _react["default"].createElement(TextEditorContext.Provider, {
      value: this.getRefModel()
    }, this.props.children));
  }

  componentDidMount() {
    const modelProps = (0, _helpers.extractProps)(this.props, editorCreationProps);
    this.refParent.map(element => {
      const editor = new _atom.TextEditor(modelProps);
      editor.getElement().tabIndex = this.props.tabIndex;

      if (this.props.className) {
        editor.getElement().classList.add(this.props.className);
      }

      if (this.props.preselect) {
        editor.selectAll();
      }

      element.appendChild(editor.getElement());
      this.getRefModel().setter(editor);
      this.refElement.setter(editor.getElement());
      this.subs.add(editor.onDidChangeCursorPosition(this.props.didChangeCursorPosition), editor.observeSelections(this.observeSelections), editor.onDidChange(this.observeEmptiness));

      if (editor.isEmpty() && this.props.hideEmptiness) {
        editor.getElement().classList.add(EMPTY_CLASS);
      }

      return null;
    });
  }

  componentDidUpdate() {
    const modelProps = (0, _helpers.extractProps)(this.props, editorUpdateProps);
    this.getRefModel().map(editor => editor.update(modelProps)); // When you look into the abyss, the abyss also looks into you

    this.observeEmptiness();
  }

  componentWillUnmount() {
    this.getRefModel().map(editor => editor.destroy());
    this.subs.dispose();
  }

  contains(element) {
    return this.refElement.map(e => e.contains(element)).getOr(false);
  }

  focus() {
    this.refElement.map(e => e.focus());
  }

  getRefModel() {
    if (this.props.refModel) {
      return this.props.refModel;
    }

    if (!this.refModel) {
      this.refModel = new _refHolder["default"]();
    }

    return this.refModel;
  }

  getModel() {
    return this.getRefModel().getOr(undefined);
  }

}

exports["default"] = AtomTextEditor;

_defineProperty(AtomTextEditor, "propTypes", _objectSpread2({}, editorCreationProps, {
  didChangeCursorPosition: _propTypes["default"].func,
  didAddSelection: _propTypes["default"].func,
  didChangeSelectionRange: _propTypes["default"].func,
  didDestroySelection: _propTypes["default"].func,
  hideEmptiness: _propTypes["default"].bool,
  preselect: _propTypes["default"].bool,
  className: _propTypes["default"].string,
  tabIndex: _propTypes["default"].number,
  refModel: _propTypes2.RefHolderPropType,
  children: _propTypes["default"].node
}));

_defineProperty(AtomTextEditor, "defaultProps", {
  didChangeCursorPosition: () => {},
  didAddSelection: () => {},
  didChangeSelectionRange: () => {},
  didDestroySelection: () => {},
  hideEmptiness: false,
  preselect: false,
  tabIndex: 0
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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