Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/** @babel */

var _atom = require('atom');

var Bookmarks = (function () {
  _createClass(Bookmarks, null, [{
    key: "deserialize",
    value: function deserialize(editor, state) {
      return new Bookmarks(editor, editor.getMarkerLayer(state.markerLayerId));
    }
  }]);

  function Bookmarks(editor, markerLayer) {
    _classCallCheck(this, Bookmarks);

    this.editor = editor;
    this.markerLayer = markerLayer || this.editor.addMarkerLayer({ persistent: true });
    this.decorationLayer = this.editor.decorateMarkerLayer(this.markerLayer, { type: "line-number", "class": "bookmarked" });
    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.commands.add(atom.views.getView(this.editor), {
      "bookmarks:toggle-bookmark": this.toggleBookmark.bind(this),
      "bookmarks:jump-to-next-bookmark": this.jumpToNextBookmark.bind(this),
      "bookmarks:jump-to-previous-bookmark": this.jumpToPreviousBookmark.bind(this),
      "bookmarks:select-to-next-bookmark": this.selectToNextBookmark.bind(this),
      "bookmarks:select-to-previous-bookmark": this.selectToPreviousBookmark.bind(this),
      "bookmarks:clear-bookmarks": this.clearBookmarks.bind(this)
    }));
    this.disposables.add(this.editor.onDidDestroy(this.destroy.bind(this)));
  }

  _createClass(Bookmarks, [{
    key: "destroy",
    value: function destroy() {
      this.deactivate();
      this.markerLayer.destroy();
    }
  }, {
    key: "deactivate",
    value: function deactivate() {
      this.decorationLayer.destroy();
      this.disposables.dispose();
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return { markerLayerId: this.markerLayer.id };
    }
  }, {
    key: "toggleBookmark",
    value: function toggleBookmark() {
      var _this = this;

      for (var range of this.editor.getSelectedBufferRanges()) {
        var bookmarks = this.markerLayer.findMarkers({ intersectsRowRange: [range.start.row, range.end.row] });
        if (bookmarks && bookmarks.length > 0) {
          for (var bookmark of bookmarks) {
            bookmark.destroy();
          }
        } else {
          (function () {
            var bookmark = _this.markerLayer.markBufferRange(range, { invalidate: "surround", exclusive: true });
            _this.disposables.add(bookmark.onDidChange(function (_ref) {
              var isValid = _ref.isValid;

              if (!isValid) {
                bookmark.destroy();
              }
            }));
          })();
        }
      }
    }
  }, {
    key: "clearBookmarks",
    value: function clearBookmarks() {
      for (var bookmark of this.markerLayer.getMarkers()) {
        bookmark.destroy();
      }
    }
  }, {
    key: "jumpToNextBookmark",
    value: function jumpToNextBookmark() {
      var _this2 = this;

      if (this.markerLayer.getMarkerCount() > 0) {
        (function () {
          var bufferRow = _this2.editor.getLastCursor().getMarker().getStartBufferPosition().row;
          var markers = _this2.markerLayer.getMarkers().sort(function (a, b) {
            return a.compare(b);
          });
          var bookmarkMarker = markers.find(function (marker) {
            return marker.getBufferRange().start.row > bufferRow;
          }) || markers[0];
          _this2.editor.setSelectedBufferRange(bookmarkMarker.getBufferRange(), { autoscroll: false });
          _this2.editor.scrollToCursorPosition();
        })();
      } else {
        atom.beep();
      }
    }
  }, {
    key: "jumpToPreviousBookmark",
    value: function jumpToPreviousBookmark() {
      var _this3 = this;

      if (this.markerLayer.getMarkerCount() > 0) {
        (function () {
          var bufferRow = _this3.editor.getLastCursor().getMarker().getStartBufferPosition().row;
          var markers = _this3.markerLayer.getMarkers().sort(function (a, b) {
            return b.compare(a);
          });
          var bookmarkMarker = markers.find(function (marker) {
            return marker.getBufferRange().start.row < bufferRow;
          }) || markers[0];
          _this3.editor.setSelectedBufferRange(bookmarkMarker.getBufferRange(), { autoscroll: false });
          _this3.editor.scrollToCursorPosition();
        })();
      } else {
        atom.beep();
      }
    }
  }, {
    key: "selectToNextBookmark",
    value: function selectToNextBookmark() {
      var _this4 = this;

      if (this.markerLayer.getMarkerCount() > 0) {
        (function () {
          var bufferRow = _this4.editor.getLastCursor().getMarker().getStartBufferPosition().row;
          var markers = _this4.markerLayer.getMarkers().sort(function (a, b) {
            return a.compare(b);
          });
          var bookmarkMarker = markers.find(function (marker) {
            return marker.getBufferRange().start.row > bufferRow;
          }) || markers[0];
          if (!bookmarkMarker) {
            atom.beep();
          } else {
            _this4.editor.setSelectedBufferRange([bookmarkMarker.getHeadBufferPosition(), _this4.editor.getCursorBufferPosition()], { autoscroll: false });
          }
        })();
      } else {
        atom.beep();
      }
    }
  }, {
    key: "selectToPreviousBookmark",
    value: function selectToPreviousBookmark() {
      var _this5 = this;

      if (this.markerLayer.getMarkerCount() > 0) {
        (function () {
          var bufferRow = _this5.editor.getLastCursor().getMarker().getStartBufferPosition().row;
          var markers = _this5.markerLayer.getMarkers().sort(function (a, b) {
            return b.compare(a);
          });
          var bookmarkMarker = markers.find(function (marker) {
            return marker.getBufferRange().start.row < bufferRow;
          }) || markers[0];
          if (!bookmarkMarker) {
            atom.beep();
          } else {
            _this5.editor.setSelectedBufferRange([_this5.editor.getCursorBufferPosition(), bookmarkMarker.getHeadBufferPosition()], { autoscroll: false });
          }
        })();
      } else {
        atom.beep();
      }
    }
  }]);

  return Bookmarks;
})();

exports["default"] = Bookmarks;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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