(function() {
  var PropertiesURL, fetchPropertyDescriptions, fs, path, propertiesPromise, propertyDescriptionsPromise, request;

  path = require('path');

  fs = require('fs');

  request = require('request');

  fetchPropertyDescriptions = require('./fetch-property-docs');

  PropertiesURL = 'https://raw.githubusercontent.com/adobe/brackets/master/src/extensions/default/CSSCodeHints/CSSProperties.json';

  propertiesPromise = new Promise(function(resolve) {
    return request({
      json: true,
      url: PropertiesURL
    }, function(error, response, properties) {
      if (error != null) {
        console.error(error.message);
        resolve(null);
      }
      if (response.statusCode !== 200) {
        console.error("Request for CSSProperties.json failed: " + response.statusCode);
        resolve(null);
      }
      return resolve(properties);
    });
  });

  propertyDescriptionsPromise = fetchPropertyDescriptions();

  Promise.all([propertiesPromise, propertyDescriptionsPromise]).then(function(values) {
    var completions, i, len, metadata, properties, propertiesRaw, propertyDescriptions, propertyName, pseudoSelectors, sortedPropertyNames, tags;
    properties = {};
    propertiesRaw = values[0];
    propertyDescriptions = values[1];
    sortedPropertyNames = JSON.parse(fs.readFileSync(path.join(__dirname, 'sorted-property-names.json')));
    for (i = 0, len = sortedPropertyNames.length; i < len; i++) {
      propertyName = sortedPropertyNames[i];
      if (!(metadata = propertiesRaw[propertyName])) {
        continue;
      }
      metadata.description = propertyDescriptions[propertyName];
      properties[propertyName] = metadata;
      if (propertyDescriptions[propertyName] == null) {
        console.warn("No description for property " + propertyName);
      }
    }
    for (propertyName in propertiesRaw) {
      if (sortedPropertyNames.indexOf(propertyName) < 0) {
        console.warn("Ignoring " + propertyName + "; not in sorted-property-names.json");
      }
    }
    tags = JSON.parse(fs.readFileSync(path.join(__dirname, 'html-tags.json')));
    pseudoSelectors = JSON.parse(fs.readFileSync(path.join(__dirname, 'pseudo-selectors.json')));
    completions = {
      tags: tags,
      properties: properties,
      pseudoSelectors: pseudoSelectors
    };
    return fs.writeFileSync(path.join(__dirname, 'completions.json'), (JSON.stringify(completions, null, '  ')) + "\n");
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
