Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _humanizePlus = require('humanize-plus');

var _humanizePlus2 = _interopRequireDefault(_humanizePlus);

var _lsArchive = require('ls-archive');

var _lsArchive2 = _interopRequireDefault(_lsArchive);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _fileView = require('./file-view');

var _fileView2 = _interopRequireDefault(_fileView);

var _directoryView = require('./directory-view');

var _directoryView2 = _interopRequireDefault(_directoryView);

var ArchiveEditorView = (function () {
  function ArchiveEditorView(archivePath) {
    var _this = this;

    _classCallCheck(this, ArchiveEditorView);

    this.disposables = new _atom.CompositeDisposable();
    this.emitter = new _atom.Emitter();
    this.path = archivePath;
    this.file = new _atom.File(this.path);
    this.entries = [];
    _etch2['default'].initialize(this);

    this.refresh();

    this.disposables.add(this.file.onDidChange(function () {
      return _this.refresh();
    }));
    this.disposables.add(this.file.onDidRename(function () {
      return _this.refresh();
    }));
    this.disposables.add(this.file.onDidDelete(function () {
      return _this.destroy();
    }));

    var focusHandler = function focusHandler() {
      return _this.focusSelectedFile();
    };

    this.element.addEventListener('focus', focusHandler);
    this.disposables.add(new _atom.Disposable(function () {
      return _this.element.removeEventListener('focus', focusHandler);
    }));
  }

  _createClass(ArchiveEditorView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'archive-editor', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'archive-container' },
          _etch2['default'].dom(
            'div',
            { ref: 'loadingMessage', className: 'padded icon icon-hourglass text-info' },
            'Loading archive…'
          ),
          _etch2['default'].dom('div', { ref: 'errorMessage', className: 'padded icon icon-alert text-error' }),
          _etch2['default'].dom(
            'div',
            { className: 'inset-panel' },
            _etch2['default'].dom('div', { ref: 'summary', className: 'panel-heading' }),
            _etch2['default'].dom('ol', { ref: 'tree', className: 'archive-tree padded list-tree has-collapsable-children' })
          )
        )
      );
    }
  }, {
    key: 'copy',
    value: function copy() {
      return new ArchiveEditorView(this.path);
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      while (this.entries.length > 0) {
        this.entries.pop().destroy();
      }
      this.disposables.dispose();
      this.emitter.emit('did-destroy');
      _etch2['default'].destroy(this);
    }
  }, {
    key: 'onDidDestroy',
    value: function onDidDestroy(callback) {
      return this.emitter.on('did-destroy', callback);
    }
  }, {
    key: 'onDidChangeTitle',
    value: function onDidChangeTitle(callback) {
      return this.emitter.on('did-change-title', callback);
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: this.constructor.name,
        path: this.path
      };
    }
  }, {
    key: 'getPath',
    value: function getPath() {
      return this.file.getPath();
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return this.path ? this.file.getBaseName() : 'untitled';
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.path;
    }
  }, {
    key: 'refresh',
    value: function refresh() {
      var _this2 = this;

      this.refs.summary.style.display = 'none';
      this.refs.tree.style.display = 'none';
      this.refs.loadingMessage.style.display = '';
      this.refs.errorMessage.style.display = 'none';

      if (this.path !== this.getPath()) {
        this.path = this.getPath();
        this.emitter.emit('did-change-title');
      }

      var originalPath = this.path;
      _lsArchive2['default'].list(this.path, { tree: true }, function (error, entries) {
        if (originalPath !== _this2.path) {
          return;
        }

        if (error != null) {
          var message = 'Reading the archive file failed';
          if (error.message) {
            message += ': ' + error.message;
          }
          _this2.refs.errorMessage.style.display = '';
          _this2.refs.errorMessage.textContent = message;
        } else {
          _this2.createTreeEntries(entries);
          _this2.updateSummary();
        }

        // We hide the loading message _after_ creating the archive tree
        // to avoid forced reflows.
        _this2.refs.loadingMessage.style.display = 'none';
      });
    }
  }, {
    key: 'createTreeEntries',
    value: function createTreeEntries(entries) {
      while (this.entries.length > 0) {
        this.entries.pop().destroy();
      }

      var index = 0;
      for (var entry of entries) {
        if (entry.isDirectory()) {
          var entryView = new _directoryView2['default'](this, index, this.path, entry);
          this.entries.push(entryView);
        } else {
          var entryView = new _fileView2['default'](this, index, this.path, entry);
          this.entries.push(entryView);
        }
        index++;
      }

      this.selectFileAfterIndex(-1);

      // Wait until selecting (focusing) the first file before appending the entries
      // to avoid a double-forced reflow when focusing.
      for (var entry of this.entries) {
        this.refs.tree.appendChild(entry.element);
      }

      this.refs.tree.style.display = '';
    }
  }, {
    key: 'updateSummary',
    value: function updateSummary() {
      var fileCount = this.entries.filter(function (entry) {
        return entry instanceof _fileView2['default'];
      }).length;
      var fileLabel = fileCount === 1 ? '1 file' : _humanizePlus2['default'].intComma(fileCount) + ' files';

      var directoryCount = this.entries.filter(function (entry) {
        return entry instanceof _directoryView2['default'];
      }).length;
      var directoryLabel = directoryCount === 1 ? '1 folder' : _humanizePlus2['default'].intComma(directoryCount) + ' folders';

      this.refs.summary.style.display = '';
      this.refs.summary.textContent = _humanizePlus2['default'].fileSize(_fsPlus2['default'].getSizeSync(this.path)) + ' with ' + fileLabel + ' and ' + directoryLabel;
    }
  }, {
    key: 'focusSelectedFile',
    value: function focusSelectedFile() {
      var selectedFile = this.refs.tree.querySelector('.selected');
      if (selectedFile) {
        selectedFile.focus();
      }
    }
  }, {
    key: 'selectFileBeforeIndex',
    value: function selectFileBeforeIndex(index) {
      for (var i = index - 1; i >= 0; i--) {
        var previousEntry = this.entries[i];
        if (previousEntry instanceof _fileView2['default']) {
          previousEntry.select();
          break;
        } else {
          if (previousEntry.selectLastFile()) {
            break;
          }
        }
      }
    }
  }, {
    key: 'selectFileAfterIndex',
    value: function selectFileAfterIndex(index) {
      for (var i = index + 1; i < this.entries.length; i++) {
        var nextEntry = this.entries[i];
        if (nextEntry instanceof _fileView2['default']) {
          nextEntry.select();
          break;
        } else {
          if (nextEntry.selectFirstFile()) {
            break;
          }
        }
      }
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.focusSelectedFile();
    }
  }]);

  return ArchiveEditorView;
})();

exports['default'] = ArchiveEditorView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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