var index = [{"name":"Advanced Usage","link":"AdvancedUsage.html","text":"Advanced Usage Advanced Usage Advanced Usage On this page we collect information on a number of classes that the normal user would not encounter. There are cases where the information is essential, however, for instance to Advanced Usage implement your own showers. Advanced Usage The subsystems One aspect that complicates administration is that an event can contain several subsystems, each consisting of either 1) one MPI and its associated ISR and FSR or 2) one decaying resonance and its associated FSR. To first approximation these systems are assumed to evolve independently, but to second they are connected by the interleaved evolution, and potentially by colour-reconnection or rescattering effects. The partons of a given subsystem therefore do not have to be stored consecutively. Advanced Usage The Advanced Usage PartonSystems class is primarily used to keep track of the current positions of all partons belonging to each system, represented by the index Advanced Usage iPos for a parton stored in the event-record slot Advanced Usage event[iPos]. With 'all' we mean the current set of outgoing partons, as well as the currently defined two incoming partons that system (for 2&rarr;n processes) or one incoming parton in the case of a decay (1&rarr;n) process. No intermediate-state (off-shell) ISR or FSR partons are present. That is, the parton system stores all partons that could be subject to some action in the next step of the combined MPI/ISR/FSR/BR description. As a special case, an outgoing parton is stored even if it undergoes a rescattering, and thus no longer belongs to the final state proper. Advanced Usage Note also that an unstable (decaying) resonance will normally appear in two different systems; once, as an outgoing parton in the system that produced it (a hard process or the decay system of a previous resonance decay), and once as an incoming parton in its own decay system. Advanced Usage The Advanced Usage partonSystems instance of Advanced Usage PartonSystems class is a public member of the Advanced Usage Pythia top-level class, but is also available as a pointer Advanced Usage partonSystemsPtr in various Advanced Usage PartonLevel classes, e.g. inside the current instances of the Advanced Usage TimeShower and Advanced Usage SpaceShower classes. Advanced Usage A number of Advanced Usage PartonSystems methods can be used to set or get information on the subsystems: Advanced Usage Advanced Usage Advanced Usage clear() resets all the contents in preparation for the next event. Advanced Usage Advanced Usage addSys() add a new (initially empty) subsystem to the current list and return its index Advanced Usage iSys in the list, where index 0 is the hardest subcollision and so on. Advanced Usage Advanced Usage sizeSys() the number of separate subsystems. Advanced Usage Advanced Usage setInA(iSys, iPos), setInB(iSys, iPos) store position Advanced Usage iPos of the incoming parton from beam A or beam B to the Advanced Usage iSys 'th subcollision. These values are 0 initially, and should so remain if there are no beams, such as in resonance decays. Advanced Usage Advanced Usage setInRes(iSys, iPos) stores position Advanced Usage iPos of the incoming (decaying) resonance whose decay produced the outgoing partons for the Advanced Usage iSys 'th system. This value is 0 initially and should so remain for systems that are not produced by the decay of a resonance, such as 2&rarr;n subcollision systems. Advanced Usage Advanced Usage addOut(iSys, iPos) store position Advanced Usage iPos of a new outgoing parton in the Advanced Usage iSys 'th subcollision, by appending it at the end of the current vector, with beginning in slot 0. Advanced Usage Advanced Usage setOut(iSys, iMem, iPos) store position Advanced Usage iPos in the Advanced Usage iMem 'th slot in the vector of outgoing partons in the Advanced Usage iSys 'th subcollision. Here Advanced Usage iMem must be in the range already constructed by Advanced Usage addOut calls. Advanced Usage Advanced Usage replace(iSys, iPosOld, iPosNew) replace the existing incoming or outgoing parton position Advanced Usage iPosOld by Advanced Usage iPosNew in the Advanced Usage iSys 'th subcollision. Advanced Usage Advanced Usage setSHat(iSys, sHat) set the invariant squared mass Advanced Usage sHat of the Advanced Usage iSys 'th subcollision. Advanced Usage Advanced Usage hasInAB(iSys) true if an incoming parton has been set for beam A or beam B (and hence should have been set for both) in the Advanced Usage iSys 'th subcollision, else false. Advanced Usage Advanced Usage getInA(iSys), getInB(iSys) the position Advanced Usage iPos of the incoming parton from beam A or beam B to the Advanced Usage iSys 'th subcollision. Advanced Usage Advanced Usage hasInRes(iSys) true if an incoming (decaying) resonance has been set for the Advanced Usage iSys 'th parton system, else false. Advanced Usage Advanced Usage sizeOut(iSys) the number of outgoing partons in the Advanced Usage iSys 'th subcollision. Advanced Usage Advanced Usage getOut(iSys, iMem) the position Advanced Usage iPos of an outgoing parton in the Advanced Usage iSys 'th subcollision, with the Advanced Usage iMem range limited by Advanced Usage sizeOut(iSys). These partons are not guaranteed to appear in any particular order. Advanced Usage Advanced Usage sizeAll(iSys) the total number of incoming and outgoing partons in the Advanced Usage iSys 'th subcollision. Advanced Usage Advanced Usage getAll(iSys, iMem) the position Advanced Usage iPos of an incoming or outgoing parton in the Advanced Usage iSys 'th subcollision. In case there are beams it gives same as Advanced Usage getInA(iSys) and Advanced Usage getInB(iSys) for indices 0 and 1, and thereafter agrees with Advanced Usage getOut(iSys, iMem) offset two positions. In case there is an incoming (decaying) resonance set for the system, it gives the same as Advanced Usage getInRes(iSys) for index 0, and thereafter agrees with Advanced Usage getOut(iSys, iMem) offset one position. If there are neither beams nor an incoming resonance set for the system, it is identical with Advanced Usage getOut(iSys, iMem). Advanced Usage Advanced Usage getSystemOf(iPos, alsoIn) returns the system ( Advanced Usage iSys ) of the parton specified by Advanced Usage iPos. If the parton is outgoing in one system and incoming in another (eg a decaying resonance), the system in which it is incoming will be returned if Advanced Usage alsoIn == true , else the system in which it is outgoing will be returned. The default is Advanced Usage alsoIn = false. Advanced Usage Advanced Usage getSHat(iSys) the invariant squared mass Advanced Usage sHat of the Advanced Usage iSys 'th subcollision. Advanced Usage Advanced Usage list() print a listing of all the system information, except for the Advanced Usage sHat values. Advanced Usage New systems are created from the hard process, from resonance decays, and by the MPI, not from  any of the other components. Both FSR and ISR modify the position of partons, however. Since an FSR or ISR branching typically implies a new state with one more parton than before, an outgoing parton must be added to the system. Furthermore, in a branching, several existing partons may also be moved to new slots, including the incoming beam ones. In a FSR Advanced Usage 1 &rarr; 2 branching it is irrelevant which parton position you let overwrite the existing slot and which is added to the end of the system. Advanced Usage The system information must be kept up-to-date. Both the MPI, ISR, FSR and BR descriptions make extensive use of the existing information. As an example, the introduction of primordial Advanced Usage kT in the beam remnants will fail if the information on which final-state partons belong to which system is out-of-date. The introduction of rescattering as part of the MPI framework adds further complications, where an outgoing parton of one subsystem may be the incoming one of another system. This part of the code is still under development. Advanced Usage Currently the system information is kept throughout the continued history of the event. Specifically, resonance decays create new systems, appended to the existing ones. This could be useful during the hadronization stage, to collect the partons that belong to a resonance with preserved mass when a small string collapses to one particle, but is not yet used for that. Advanced Usage The beams The different subsystems are tied together by them sharing the same initial beam particles, and thereby being restricted by energy-momentum and flavour conservation issues. The information stored in the two beam particles, here called Advanced Usage beamA and Advanced Usage beamB , is therefore as crucial to keep correct as the above subsystem list. Advanced Usage Both beam objects are of the Advanced Usage BeamParticle class. Each such object contains a vector with the partons extracted from it. The number of such partons, Advanced Usage beamX.size() (X = A or B), of course is the same as the above number of subsystems in the event record. (The two diverge at the BR step, where further beam remnants are added to the beams without corresponding to new subsystems.) The individual partons are accessed by an overloaded indexing operator to a vector of Advanced Usage ResolvedParton objects. The Advanced Usage iPos() property corresponds to the Advanced Usage iPos one above, i.e. providing the position in the main event record of a parton. In particular, Advanced Usage beamA[iSys].iPos() = partonSystemsPtr->getInA(iSys) and Advanced Usage beamB[iSys].iPos() = partonSystemsPtr->getInB(iSys). Whereas thus the indices of the two incoming partons to a subsystem are stored in two places, the ones of the outgoing partons only appear in the system part of the Advanced Usage PartonSystems class. Advanced Usage Just as the subsystems in Advanced Usage PartonSystems must be updated, so must the information in the two Advanced Usage BeamParticle 's, e.g. with methods Advanced Usage beamX[iSys].iPos( iPosIn) when an incoming parton is replaced by a new one in line Advanced Usage iPosIn. Furthermore the new parton identity should be set by Advanced Usage beamX[iSys].id( idIn) and the new Advanced Usage x energy-momentum fraction by Advanced Usage beamX[iSys].x( xIn). The three can be combined in one go by Advanced Usage beamX[iSys].update( iPosIn, idIn, xIn). Advanced Usage To be specific, it is assumed that, at each step, the two incoming partons are moving along the Advanced Usage +-z axis and are massless. Since the event is constructed in the c.m. frame of the incoming beams this implies that Advanced Usage x = 2 E / E_cm. If the Advanced Usage x values are not defined accordingly or not kept up-to-date the BR treatment will not conserve energy-momentum. Advanced Usage In return, the Advanced Usage BeamParticle objects give access to some useful methods. The Advanced Usage beamX.xf( id, x, Q2) returns the standard PDF weight Advanced Usage x f_id(x, Q^2). More interestingly, Advanced Usage beamX.xfISR( iSys, id, x, Q2) returns the modified weight required when several subsystems have to share the energy and flavours. Thus Advanced Usage iSys is added as an extra argument, and the momentum already assigned to the other subsystems is not available for evolution, i.e. the maximal Advanced Usage x is correspondingly smaller than unity. Also flavour issues are handled in a similar spirit. Advanced Usage An additional complication is that a parton can be either valence or sea, and in the latter case the BR treatment also distinguishes companion quarks, i.e. quark-antiquark pairs that are assumed to come from the same original Advanced Usage g &rarr; q qbar branching, whether perturbative or not. This can be queried either with the Advanced Usage beamX[iSys].companion() method, for detailed information, or with the Advanced Usage beamX[iSys].isValence() , Advanced Usage beamX[iSys].isUnmatched() and Advanced Usage beamX[iSys].isCompanion() methods for yes/no answers whether a parton is valence, unmatched sea or matched sea. This choice should affect the ISR evolution; e.g., a valence quark cannot be constructed back to come from a gluon. Advanced Usage To keep this info up-to-date, the Advanced Usage beamX.pickValSeaComp() method should be called whenever a parton of a new flavour has been picked in the ISR backwards evolution, but not if the flavour has not been changed, since then one should not be allowed to switch back and forth between the same quark being considered as valence or as sea. Since the Advanced Usage pickValSeaComp() method makes use of the current parton-density values, it should be preceded by a call to Advanced Usage beamX.xfISR( iSys, id, x, Q2) , where the values in the call are the now finally accepted ones for the newly-found mother. (Such a call is likely to have been made before, during the evolution, but is not likely to be the most recent one, i.e. still in memory, and therefore had better be redone.)"},{"name":"ALPGEN Event Interface","link":"AlpgenEventInterface.html","text":"ALPGEN Event Interface ALPGEN Event Interface ALPGEN Event Interface This manual page describes the ALPGEN ALPGEN Event Interface Man03 event interface for PYTHIA8.  While future versions of ALPGEN will be able to write out events in LHEF format, previous versions always output events in an ALPGEN native format (a combination of a '.unw' and a '_unw.par' file). The ALPGEN component of this code contains a reader for this native format (for unweighted events), as well as parameter reading for both ALPGEN native and LHE file formats. The reader was designed to work together with an implementation of the ALPGEN-style parton-jet matching ALPGEN Event Interface JetMatchingAlpgen described on the ALPGEN Event Interface Jet Matching page. However, it will also work with a implementation of the Madgraph-style ALPGEN Event Interface Alw11 parton-jet matching ALPGEN Event Interface JetMatchingMadgraph also described on the ALPGEN Event Interface Jet Matching page. A sensible choice of ALPGEN Event Interface JetMatching parameters is needed when using ALPGEN files with Madgraph-style matching and vice versa. ALPGEN Event Interface It should be noted that all the functionality described here is provided through external routines, and therefore the presence of these features is dependent on the main program being used. This structure allows for the easy extensibility of the merging scheme. The files of interest are located in the ALPGEN Event Interface include/Pythia8Plugins/ subdirectory: ALPGEN Event Interface ALPGEN Event Interface ALPGEN Event Interface GeneratorInput.h : provides three classes for the reading of ALPGEN event and parameter files. ALPGEN Event Interface LHAupAlpgen is an ALPGEN Event Interface ALPGEN Event Interface LHAup derived class for reading in ALPGEN native format event files. ALPGEN Event Interface AlpgenPar is a class for the parsing of ALPGEN parameter files, making the information available through a simple interface. ALPGEN Event Interface AlpgenHooks is a ALPGEN Event Interface ALPGEN Event Interface UserHooks derived class that provides the ALPGEN Event Interface Alpgen:* options, described below. Further technical details of these classes are given at the end of this manual page. ALPGEN Event Interface ALPGEN Event Interface main32.cc, main32.cmnd : a sample main program and card file showing the usage of previous file and an MLM ALPGEN Event Interface UserHooks class. In combination, it reads in a sample ALPGEN (or Madgraph) event file while performing the MLM merging procedure as implemented in ALPGEN (or as in Madgraph). Some commented-out sets of options are provided in the card file, which can be activated to try different merging setups. ALPGEN Event Interface ALPGEN Event Interface main32.unw, main32_unw.par : an ALPGEN format event and parameter file containing 100 W + 3 jet events. It is not feasible to package large event files with the PYTHIA distribution, but this sample is enough to show the different components in action. ALPGEN Event Interface ALPGEN main options These following options are provided by the AlpgenHooks class, which must be loaded for this functionality to be present ALPGEN Event Interface ALPGEN event files that have been written out in LHEF format should be read in through the normal LHEF machinery (see ALPGEN Event Interface Beam Parameters ). Files in ALPGEN's native format, instead, may be processed using the ALPGEN Event Interface Alpgen:file option below. When using this option, the ALPGEN parameter file is stored in the PYTHIA Info object under the key ALPGEN Event Interface AlpgenPar , see the 'Header information' section of the ALPGEN Event Interface Event Information manual page for more details. Processes not implemented by the PYTHIA 6 interface supplied with ALPGEN are also not implemented here. ALPGEN Event Interface When reading in ALPGEN native event files, some momenta are shifted by the file reader to ensure energy-momentum conservation. The magnitude of these shifts should be small (around the MeV level in the worst case) and warnings will be produced if they are above a set threshold. A large number of warnings may signify unexpected behaviour and should potentially be investigated. It is also known that certain event classes, for example an event with both light and heavy ALPGEN Event Interface b quarks may give rise to these warnings. ALPGEN Event Interface The ALPGEN file reader supports the reading of the event and parameter files in gzip format with file extensions '.unw.gz' and '_unw.par.gz' respectively. This requires the use of external libraries, however, and the ALPGEN Event Interface README file in the main directory contains instructions on how to enable this. ALPGEN Event Interface All other ALPGEN Event Interface Alpgen:* options apply to both LHE and native file formats, and include options to guide the MLM merging procedure based on the parameters that are read in with the events file. ALPGEN Event Interface Class information Some more technical information about the different classes is given below. For clarity, some limited information on certain private methods is provided. ALPGEN Event Interface LHAupAlpgen This class is derived from the ALPGEN Event Interface ALPGEN Event Interface LHAup base class, and uses the standard machinery to pass initialisation and event data to PYTHIA. These standard functions are not documented here. The complete parameter file is stored in the PYTHIA Info object, if given, under the key ALPGEN Event Interface AlpgenPar. ALPGEN Event Interface AlpgenPar This class parses an ALPGEN parameter file and makes the information available through a simple interface. The information is stored internally in key/value (string/double) format. All lines prior to: ALPGEN Event Interface ************** run parameters are ignored, and in the general case, a line e.g. ALPGEN Event Interface 10  3.00000000000000     ! njets would be stored with key 'njets' and value '3.0'. The following lines are special cases where the line may be split or the key translated: ALPGEN Event Interface 3! hard process code  0.000  4.700 174.300  80.419  91.188 120.000! mc,mb,mt,mw,mz,mh  912.905 0.0914176  ! Crosssection +- error (pb)  100 29787.4 ! unwtd events, lum (pb-1) Njob= 2 In the first line, the key 'hard process code' is translated to 'hpc'. In the second, the mass values are split and each given an entry in the internal store. In the third, the cross section and cross section error are stored under the keys 'xsecup' and 'xerrup' respectively. Finally, the number of events and luminosity are stored under the keys 'nevent' and 'lum' respectively. In the event that a duplicate key is present, with differing values, the stored value is overwritten and a warning given. ALPGEN Event Interface AlpgenHooks This ALPGEN Event Interface ALPGEN Event Interface UserHooks derived class provides all the ALPGEN Event Interface Alpgen:* options. It is provided as a UserHooks class such that the code works regardless of whether ALPGEN native or LHE file formats are used. It is declared with virtual inheritance so that it may be combine with other UserHooks classes, see the 'Combining UserHooks' section below."},{"name":"aMC\@NLO Matching","link":"aMCatNLOMatching.html","text":"aMC\\@NLO Matching aMC\\@NLO Matching aMC\@NLO Matching The aMC\@NLO package aMC\\@NLO Matching Fri02 attempts to automate the MC\@NLO matching procedure aMC\\@NLO Matching Fri02. MC\@NLO interprets the parton shower as NLO subtraction method, and removes unwanted parton-shower contributions by extending the subtraction scheme used to generate NLO fixed-order results. Upon showering, an NLO accurate prediction for inclusive observables is achieved. This makes MC\@NLO a convenient NLO+PS matching scheme. A consistent extended subtraction in the NLO fixed-order result makes analytic knowledge of the shower emission probability necessary. Once this is known, interfacing the (parton-shower specific) NLO calculation with the shower is straightforward. aMC\\@NLO Matching To allow for a fast, automatic generation of shower subtractions that are used in the fixed-order calculation, Pythia allows to generate emissions with a 'global' recoil scheme, in which the recoil of an emission is shared among all final state particles. When using aMC\@NLO, this global recoil must be switched on. Please see aMC\\@NLO Matching Timelike Showers for details and options. aMC\\@NLO Matching A minimal set of settings necessary for a consistent treatment of aMC\@NLO inputs is aMC\\@NLO Matching &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; aMC\\@NLO Matching SpaceShower:pTmaxMatch = 1 aMC\\@NLO Matching &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; aMC\\@NLO Matching SpaceShower:pTmaxFudge = 1. aMC\\@NLO Matching &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; aMC\\@NLO Matching TimeShower:pTmaxMatch = 1 aMC\\@NLO Matching &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; aMC\\@NLO Matching TimeShower:pTmaxFudge = 1. aMC\\@NLO Matching &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; aMC\\@NLO Matching SpaceShower:MEcorrections = off aMC\\@NLO Matching &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; aMC\\@NLO Matching TimeShower:MEcorrections = off aMC\\@NLO Matching &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; aMC\\@NLO Matching TimeShower:globalRecoil = on aMC\\@NLO Matching &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; aMC\\@NLO Matching TimeShower:weightGluonToQuark = 1 aMC\\@NLO Matching and further (process-specific) settings related global recoils. aMC\\@NLO Matching Some comments are in order. The settings aMC\\@NLO Matching SpaceShower:pTmaxMatch = 1 , aMC\\@NLO Matching SpaceShower:pTmaxFudge = 1. , aMC\\@NLO Matching TimeShower:pTmaxMatch = 1 , aMC\\@NLO Matching TimeShower:pTmaxFudge = 1. are included to ensure that the correct parton shower starting scale (i.e. the scale set when generating the subtractions in MC\@NLO) is used within Pythia. Note that the last three options are default in Pythia8, and that the first option differs from the default only if the input state does not contain final state partons. aMC\\@NLO Matching Matrix element corrections to the parton shower splitting kernels have to be switched off by aMC\\@NLO Matching SpaceShower:MEcorrections = off and aMC\\@NLO Matching TimeShower:MEcorrections = off. This is necessary because the matrix element corrections are not suitable for showers in the global recoil scheme, and because it is not viable to include process-specific shower probabilities in an automatic framewrok like aMC\@NLO. aMC\\@NLO Matching aMC\\@NLO Matching TimeShower:globalRecoil = on is necessary. Formally, it is allowed to switch back to a local recoil treatment beyond the first proposed emission of any of the hard scattering partons in Born-type events. Pythia offers three choices at which stage the global recoil is dropped in favour of a local strategy. It is necessary to supplement the setting aMC\\@NLO Matching TimeShower:globalRecoil = on by additional settings specifying which global recoil strategy should be used. As these choices are up to the user, please consult aMC\\@NLO Matching Timelike Showers for details on these options. aMC\\@NLO Matching aMC\\@NLO Matching Finally, aMC\\@NLO Matching TimeShower:weightGluonToQuark = 1 is not default any longer, but was it at the time the subtractions were first implemented, and so is required  for consistency until further notice."},{"name":"Automated Variations of Shower Parameters","link":"Variations.html","text":"Automated Variations of Shower Parameters Automated Variations of Shower Parameters Automated Variations of Shower Parameters for Uncertainty Bands While a number of different central 'tunes' of the Pythia parameters are provided, it is often desired  to study how event properties change when some of the parameters (such as those describing the parton showers) are varied.  Pythia8 now has the ability to provide a series of weights to reflect the change in probability for a particular final state to occur when a subset of parton-shower parameters are varied.  Details on the implementation and interpretation of these weights can be found in Automated Variations of Shower Parameters Mre16. Currently, the list of available automated variations (see Automated Variations of Shower Parameters full list below ) includes: Automated Variations of Shower Parameters Automated Variations of Shower Parameters The renormalization scale for QCD emissions in FSR; Automated Variations of Shower Parameters The renormalization scale for QCD emissions in ISR; Automated Variations of Shower Parameters The inclusion of non-singular terms in QCD emissions in FSR; Automated Variations of Shower Parameters The inclusion of non-singular terms in QCD emissions in ISR. Automated Variations of Shower Parameters The PDF members of a PDF family in LHAPDF6. Automated Variations of Shower Parameters Individual PDF members of a PDF family in LHAPDF6. Similar variations would be possible for QED emissions, but these have not yet been implemented. Automated Variations of Shower Parameters Since the computation of the uncertainty variations takes additional CPU time (albeit much less than would be required for independent runs with the equivalent variations), the automated uncertainty variations are switched off by default. Automated Variations of Shower Parameters The main intended purpose of these variations is to estimate perturbative uncertainties associated with the parton showers. Due to the pole at LambdaQCD, however, branchings near the perturbative cutoff can nominally result in very large reweighting factors, which is unwanted for typical applications. We therefore enable to limit the absolute (plus/minus) magnitude by which alphaS is allowed to vary by Automated Variations of Shower Parameters Likewise, non-singular-term variations are mainly intended to capture uncertainties related to missing higher-order tree-level matrix elements and are hence normally uninteresting for very soft branchings. The following parameter allows to switch off the variations of non-singular terms below a fixed perturbative threshold: Automated Variations of Shower Parameters By default, the automated shower uncertainty variations are enabled for the showers off the hardest interaction (and associated resonance decays), but not for the showers off MPI systems which would be more properly labeled as underlying-event uncertainties. If desired, the variations can be applied also to showers off MPI systems via the following switch: Automated Variations of Shower Parameters The following parameters allow one to switch off all variations below a fixed threshold.  It is specified in terms of a multiplier for the Automated Variations of Shower Parameters TimeShower:pTmin squared (FSR) or Automated Variations of Shower Parameters SpaceShower:pT0Ref squared (ISR). A separate cutoff can be specified for ISR or FSR: Automated Variations of Shower Parameters To ensure coverage of the phase space for the variations, the overestimate of the Sudakov used in the veto algorithm is artifically increased, which is compensated in the rejection factor. A larger factor reduces fluctuations at the cost of a longer generation time. The default parameters chosen are a compromise between time and fluctuations. Automated Variations of Shower Parameters The user can control whether the variations are calculated in all or specific stages of the event generation: Automated Variations of Shower Parameters Automated Variations of Shower Parameters UserHooks Warning: the calculation of uncertainty variations will only be consistent in the absence of any external modifications to the shower branching probabilities via the Automated Variations of Shower Parameters UserHooks framework. It is therefore strongly advised to avoid combining the automated uncertainty calculations with any such UserHooks modifications. Automated Variations of Shower Parameters Automated Variations of Shower Parameters Merging Warning: in multi-jet merging approaches, trial showers are used to generate missing Sudakov factor corrections to the hard matrix elements. Currently that framework is not consistently combined with the variations introduced here, so the two should not be used simultaneously. This restriction will be lifted in a future release. Automated Variations of Shower Parameters Specifying the Variations When Automated Variations of Shower Parameters UncertaintyBands:doVariations is switched on, the user can define an arbitrary number of (combinations of) uncertainty variations to perform. Each variation is defined by a string with the following generic format: Automated Variations of Shower Parameters Label keyword1=value keyword2=value ... where the user has complete freedom to specify the label, and each keyword must be selected from the Automated Variations of Shower Parameters list of currently recognised keywords below. Instead of an equal sign it is also possible to leave a blank between a keyword and its value. Automated Variations of Shower Parameters To exemplify, an uncertainty variation corresponding to simultaneously increasing both the ISR and FSR renormalisation scales by a factor of two would be defined as follows Automated Variations of Shower Parameters myVariation1 fsr:muRfac=2.0 isr:muRfac=2.0 Automated Variations of Shower Parameters Staying within the context of this example, the user might also want to check what a variation of the two scales independently of each other would produce. This can be achieved within the same run by adding two further variations, as follows: Automated Variations of Shower Parameters myVariation2 fsr:muRfac=2.0    myVariation3 isr:muRfac=2.0 Different histograms can then be filled with each set of weights as desired (see Automated Variations of Shower Parameters accessing the uncertainty weights below). Variations by smaller or larger factors can obviously also be added in the same way, again within one and the same run. Automated Variations of Shower Parameters Once a list of variations defined as above has been decided on, the whole list should be passed to Pythia in the form of a single Automated Variations of Shower Parameters 'vector of strings' , defined as follows: Automated Variations of Shower Parameters For completeness, we note that a command-file specification equivalent to the above default variations could look as follows: Automated Variations of Shower Parameters UncertaintyBands:List = {      alphaShi fsr:muRfac=0.5 isr:muRfac=0.5,      alphaSlo fsr:muRfac=2.0 isr:muRfac=2.0,      hardHi fsr:cNS=2.0 isr:cNS=2.0,      hardLo fsr:cNS=-2.0 isr:cNS=-2.0    } Note that each of the individual uncertainty-variation definitions (the elements of the vector) are separated by commas and that keywords separated only by spaces are interpreted as belonging to a single combined variation. Note also that the beginning and end of the vector is marked by curly braces. Automated Variations of Shower Parameters Accessing the Uncertainty Weights During the event generation, uncertainty weights will be calculated for each variation defined above, via the method described in Automated Variations of Shower Parameters Mre16. The resulting alternative weights for the event are accessible through the Automated Variations of Shower Parameters Pythia::info.weight(int iWeight=0) method. Automated Variations of Shower Parameters The baseline weight for each event (normally unity for an ordinary unweighted event sample) is not modified and corresponds to Automated Variations of Shower Parameters iWeight = 0. The uncertainty-variation weights are thus enumerated starting from Automated Variations of Shower Parameters iWeight = 1 for the first variation up to Automated Variations of Shower Parameters N for the last variation, in the order they were specified in Automated Variations of Shower Parameters UncertaintyBands:List. Automated Variations of Shower Parameters The total number of variations that have been defined, Automated Variations of Shower Parameters N , can be queried using Automated Variations of Shower Parameters Pythia::info.nWeights(). Automated Variations of Shower Parameters NLO Compensation Term for Renormalisation-Scale Variations Additionally, there is a run-time parameter: Automated Variations of Shower Parameters List of Recognised Keywords for Uncertainty Variations The following keywords adjust the renormalisation scales and non-singular terms for all FSR and ISR branchings, respectively: Automated Variations of Shower Parameters Automated Variations of Shower Parameters Automated Variations of Shower Parameters fsr:muRfac : multiplicative factor applied to the renormalization scale for FSR branchings. Automated Variations of Shower Parameters Automated Variations of Shower Parameters isr:muRfac : multiplicative factor applied to the renormalization scale for ISR branchings. Automated Variations of Shower Parameters Automated Variations of Shower Parameters fsr:cNS : additive non-singular ('finite') term in the FSR splitting functions. Automated Variations of Shower Parameters Automated Variations of Shower Parameters isr:cNS : additive non-singular ('finite') term in the ISR splitting functions. Note that the Automated Variations of Shower Parameters muRfac parameters are applied linearly to the renormalisation scale, hence &mu; Automated Variations of Shower Parameters 2 &rarr; ( Automated Variations of Shower Parameters muRfac ) Automated Variations of Shower Parameters 2 *&mu; Automated Variations of Shower Parameters 2. Automated Variations of Shower Parameters The keywords for PDF variations (plus and minus) is: Automated Variations of Shower Parameters Automated Variations of Shower Parameters Automated Variations of Shower Parameters isr:PDF:plus : any number Automated Variations of Shower Parameters Automated Variations of Shower Parameters isr:PDF:minus : any number The number is not used, but is there for syntactical consistency. Note, this uses the formula from the LHAPDF6 library to calculate the variation. Automated Variations of Shower Parameters Alternatively, the variation from the default to any other individual PDF member is calculated using the following syntax: Automated Variations of Shower Parameters Automated Variations of Shower Parameters Automated Variations of Shower Parameters isr:PDF:member : member number To force the calculation for ALL members of the PDF family, then use: Automated Variations of Shower Parameters Automated Variations of Shower Parameters Automated Variations of Shower Parameters isr:PDF:family : any number The number is not used. Automated Variations of Shower Parameters Optionally, a further level of detail can be accessed by specifying variations for specific types of branchings, with the global keywords above corresponding to setting the same value for all branchings. Using the Automated Variations of Shower Parameters fsr:muRfac parameter for illustration, the individual branching types that can be specified are: Automated Variations of Shower Parameters Automated Variations of Shower Parameters Automated Variations of Shower Parameters fsr:G2GG:muRfac : variation for g&rarr;gg branchings. Automated Variations of Shower Parameters Automated Variations of Shower Parameters fsr:Q2QG:muRfac : variation for q&rarr;qg branchings. Automated Variations of Shower Parameters Automated Variations of Shower Parameters fsr:G2QQ:muRfac : variation for g&rarr;qqbar branchings. Automated Variations of Shower Parameters Automated Variations of Shower Parameters fsr:X2XG:muRfac : variation for gluon bremsstrahlung off other types of particles (such as coloured new-physics particles). For the distinction between Automated Variations of Shower Parameters Q2QG and Automated Variations of Shower Parameters X2XG , the following switch can be used to control whether Automated Variations of Shower Parameters b and Automated Variations of Shower Parameters t quarks are considered to be Automated Variations of Shower Parameters Q or Automated Variations of Shower Parameters X particles (e.g. providing a simple way to control top-quark or bottom-quark radiation independently of the rest of the shower uncertainties):"},{"name":"Beam Parameters","link":"BeamParameters.html","text":"Beam Parameters Beam Parameters Beam Parameters The settings on this page relate to the beam identities and energies, to a beam momentum spread and to a beam interaction spot. As always, momenta and energies are to be given in units of GeV, and of space and time in mm. Beam Parameters Incoming beams The identities and energies of the two incoming beam particles should be specified using the settings in this section. Note that, if nothing is done, you will default to LHC at 14 TeV. Beam Parameters Currently the beam particles must be either a hadron pair, a lepton pair, a photon pair, a lepton and a hadron or a photon and a hadron. In the first category Beam Parameters p p and Beam Parameters pbar p combinations dominate, but it is also possible to combine with Beam Parameters pi^+ , Beam Parameters pi^- and Beam Parameters pi^0. In the second Beam Parameters e^+ e^- and Beam Parameters mu^+ mu^- would be the most useful combinations, but also others should work if combined with an appropriate hard process. Beam Parameters Variable collision energy There are two different machineries that can provide an event-by-event spread of collision energies. The one in this section is intended to allow for very large variations in collision energy, more-or-less from threshold to the highest LHC/FCC/cosmic-ray energies. This is made possible by interpolation in a grid of CM energies. Such a strategy requires the processes to have a smooth and well-understood energy dependence. In practice this limits us to the soft QCD processes betweeen two incoming hadrons. Thus the framework is convenient e.g. for studies of cosmic-ray cascades, or for secondary collisions in general. Beam Parameters The core extension in this option is that the multiparticle interactions (MPI) machinery is initialized over a (logarithmically spaced) grid of collision energies, from the maximal energy provided at the initialization down to a lower cutoff (see Beam Parameters eMinPert below). For each new event, with a new CM energy, a suitable interpolation is then performed among the generation coefficients determined at initialization. The MPI framework is what is needed to simulate hadronic nondiffractive events ( Beam Parameters SoftQCD:nonDiffractive ). Pretty much the same strategy is already used for diffraction, to handle MPIs inside the variable-mass diffractive systems. Thus all the Beam Parameters Soft QCD processes can be used within this framework. It is not possible to generate other processes with this framework, however, and the program will abort if you try. Beam Parameters The initalization of involves setting up optimal coefficients for the kinematics selection in the subsequent MPI generation, and finding the associated maximum of the differentialcross section. At a fixed energy this typically takes less than a second, and so normally is not noticeable.It is a major fraction of the full PYTHIA initialization time, however. Thus the initialization over a grid of energies raises the total initialization time appreciable, to the order of ten seconds. Initialization of diffraction contributes comparable numbers, when switched on. You should therefore not be surprised that the startup time is longer than usual. The subsequent event generation should not become noticeably slower, however. Beam Parameters There are three main settings in this framework. Beam Parameters To input the variable energy, the normal argument-less Beam Parameters Pythia::next() method has three siblings that take relevent arguments as required by the Beam Parameters Beams:frameType. Beam Parameters Beam momentum spread This framework currently is intended for a modest beam spread, such as experienced at hadron colliders. Thus it can be safely assumed that the physics does not change over the CM energy range probed, so that the parameters of the physics initialization at the nominal energy can be used as is. Therefore it can be used for all processes implemented in PYTHIA. It can Beam Parameters not be used for the more extensive energy spread, however, e.g. as expected at linear Beam Parameters e^+ e^- colliders. Also, any attempt to combine it with external Les Houches input of parton-level events is at own risk. This option cannot be combined with the variable-collision-energy option above, but will be switced off in such a case. Beam Parameters On this page you can set the momentum spread according to a simple Gaussian distribution. If you instead want a more sophisticated parametrization, you can write and link your own Beam Parameters Beam Parameters BeamShape class. Beam Parameters Beam interaction vertex On this page you can set the spread of the interaction vertex according to a simple Gaussian distribution. If you instead want a more sophisticated parametrization, you can write and link your own Beam Parameters Beam Parameters BeamShape class. Beam Parameters The distributions above are all centered at the origin. It is also possible to shift the above distributions to be centered around another nominal position. You must have Beam Parameters Beams:allowVertexSpread = on to use this possibility."},{"name":"Beam Remnants","link":"BeamRemnants.html","text":"Beam Remnants Beam Remnants Beam Remnants Beam Remnants Introduction The Beam Remnants BeamParticle class contains information on all partons extracted from a beam (so far). As each consecutive multiparton interaction defines its respective incoming parton to the hard scattering a new slot is added to the list. This information is modified when the backwards evolution of the spacelike shower defines a new initiator parton. It is used, both for the multiparton interactions and the spacelike showers, to define rescaled parton densities based on the Beam Remnants x and flavours already extracted, and to distinguish between valence, sea and companion quarks. Once the perturbative evolution is finished, further beam remnants are added to obtain a consistent set of flavours. The current physics framework is further described in Beam Remnants Sjo04. Beam Remnants The introduction of Beam Remnants rescattering in the multiparton interactions framework further complicates the processing of events. Specifically, when combined with showers, the momentum of an individual parton is no longer uniquely associated with one single subcollision. Nevertheless the parton is classified with one system, owing to the technical and administrative complications of more complete classifications. Therefore the addition of primordial Beam Remnants kT to the subsystem initiator partons does not automatically guarantee overall Beam Remnants pT conservation. Various tricks are used to minimize the mismatch, with a brute force shift of all parton Beam Remnants pT 's as a final step. Beam Remnants Much of the above information is stored in a vector of Beam Remnants ResolvedParton objects, which each contains flavour and momentum information, as well as valence/companion information and more. The Beam Remnants BeamParticle method Beam Remnants list() shows the contents of this vector, mainly for debug purposes. Beam Remnants The Beam Remnants BeamRemnants class takes over for the final step of adding primordial Beam Remnants kT to the initiators and remnants, assigning the relative longitudinal momentum sharing among the remnants, and constructing the overall kinematics and colour flow. This step couples the two sides of an event, and could therefore not be covered in the Beam Remnants BeamParticle class, which only considers one beam at a time. Beam Remnants The methods of these classes are not intended for general use, and so are not described here. Beam Remnants In addition to the parameters described on this page, note that the choice of Beam Remnants parton densities is made in the Beam Remnants Pythia class. Then pointers to the pdf's are handed on to Beam Remnants BeamParticle at initialization, for all subsequent usage. Beam Remnants Primordial Beam Remnants kT The primordial Beam Remnants kT of initiators of hard-scattering subsystems are selected according to Gaussian distributions in Beam Remnants p_x and Beam Remnants p_y separately. The widths of these distributions are chosen to be dependent on the hard scale of the central process and on the mass of the whole subsystem defined by the two initiators: Beam Remnants sigma = (sigma_soft * Q_half + sigma_hard * Q) / (Q_half + Q)  * m / (m + m_half * y_damp) Here Beam Remnants Q is the hard-process renormalization scale for the hardest process and the Beam Remnants pT scale for subsequent multiparton interactions, Beam Remnants m the mass of the system, and Beam Remnants sigma_soft , Beam Remnants sigma_hard , Beam Remnants Q_half , Beam Remnants m_half and Beam Remnants y_damp parameters defined below. Furthermore each separately defined beam remnant has a distribution of width Beam Remnants sigma_remn , independently of kinematical variables. Beam Remnants A net Beam Remnants kT imbalance is obtained from the vector sum of the primordial Beam Remnants kT values of all initiators and all beam remnants. This quantity is compensated by a shift shared equally between all partons, except that the dampening factor Beam Remnants m / (m_half + m) is again used to suppress the role of small-mass systems. Beam Remnants Note that the current Beam Remnants sigma definition implies that Beam Remnants <pT^2> = <p_x^2>+ <p_y^2> = 2 sigma^2. It thus cannot be compared directly with the Beam Remnants sigma of nonperturbative hadronization, where each quark-antiquark breakup corresponds to Beam Remnants <pT^2> = sigma^2 and only for hadrons it holds that Beam Remnants <pT^2> = 2 sigma^2. The comparison is further complicated by the reduction of primordial Beam Remnants kT values by the overall compensation mechanism. Beam Remnants Colour flow The colour in the separate subproccsses are tied together via the assignment of colour flow in the beam remnants. The assignment of colour flow is not known from first principles and therefore it is not an unambiguous procedure. Thus two different models have been implemented in Beam Remnants Pythia. These will be referred to as new and old, based on the time of the implementation. Beam Remnants The old model tries to reconstruct the colour flow in a way that a LO PS would produce the beam remnants. The starting point is the junction structure of the beam particle (if it is a baryon). The gluons are attached to a quark line and quark-antiquark pairs are added as if coming from a gluon splittings. Thus this model captures the qualitative behaviour that is expected from leading colour QCD. The model is described in more detail in Beam Remnants Sjo04. Beam Remnants The new model is built on the full SU(3) colour structure of QCD. The starting point is the scattered partons from the MPI. Each of these are initially assumed uncorrelated in colour space, allowing the total outgoing colour configuration to be calculated as an SU(3) product. Since the beam particle is a colour singlet, the beam remnant colour configuration has to be the inverse of the outgoing colour configuration. The minimum amount of gluons are added to the beam remnant in order to obtain this colour configuration. Beam Remnants The above assumption of uncorrelated MPIs in colour space is a good assumption for a few well separated hard MPIs. However if the number of MPIs become large and ISR is included, such that the energy scale becomes lower (and thus distances becomes larger), the assumption loses its validity. This is due to saturation effects. The modelling of saturation is done in crude manner, as an exponential suppresion of high multiplet states. Beam Remnants None of the models above can provide a full description of the colour flow in an event, however. Therefore additional colour reconfiguration is needed. This is referred to as colour reconnection. Several different models for colour reconnection are implemented, see Beam Remnants Colour Reconection. Beam Remnants Further variables Beam Remnants When assigning relative momentum fractions to beam-remnant partons, valence quarks are chosen according to a distribution like Beam Remnants (1 - x)^power / sqrt(x). This Beam Remnants power is given below for quarks in mesons, and separately for Beam Remnants u and Beam Remnants d quarks in the proton, based on the approximate shape of low- Beam Remnants Q^2 parton densities. The power for other baryons is derived from the proton ones, by an appropriate mixing. The Beam Remnants x of a diquark is chosen as the sum of its two constituent Beam Remnants x values, and can thus be above unity. (A common rescaling of all remnant partons and particles will fix that.) An additional enhancement of the diquark momentum is obtained by its Beam Remnants x value being rescaled by the Beam Remnants valenceDiqEnhance factor."},{"name":"Beam Shape","link":"BeamShape.html","text":"Beam Shape Beam Shape Beam Shape The Beam Shape Beam Parameters page explains how you can set a momentum spread of the two incoming beams, and a spread and offset for the location of the interaction vertex. The spread is based on a simple parametrization in terms of independent Gaussians, however, which is likely to be too primitive for realistic applications. Beam Shape It is therefore possible to define your own class, derived from the Beam Shape BeamShape base class, and hand it in to Pythia with the Beam Shape Beam Shape pythia.setBeamShapePtr( BeamShape*) method. Below we describe what such a class has to do. An explicit toy example is shown in Beam Shape main23.cc. Beam Shape The Beam Shape BeamShape base class has a very simple structure. It only has two main virtual methods. The first, Beam Shape init() , is used for initialization. The second, Beam Shape pick() , selects beam momentum and production vertex in the current event."},{"name":"Bose-Einstein Effects","link":"BoseEinsteinEffects.html","text":"Bose-Einstein Effects Bose-Einstein Effects Bose-Einstein Effects The Bose-Einstein Effects BoseEinstein class performs shifts of momenta of identical particles to provide a crude estimate of Bose-Einstein effects. The algorithm is the BE_32 one described in Bose-Einstein Effects Lon95 , with a Gaussian parametrization of the enhancement. We emphasize that this approach is not based on any first-principles quantum mechanical description of interference phenomena; such approaches anyway have many problems to contend with. Instead a cruder but more robust approach is adopted, wherein BE effects are introduced after the event has already been generated, with the exception of the decays of long-lived particles. The trick is that momenta of identical particles are shifted relative to each other so as to provide an enhancement of pairs closely separated, which is compensated by a depletion of pairs in an intermediate region of separation. Bose-Einstein Effects More precisely, the intended target form of the BE correlations in BE_32 is Bose-Einstein Effects f_2(Q) = (1 + lambda * exp(-Q^2 R^2))      * (1 + alpha * lambda * exp(-Q^2 R^2/9) * (1 - exp(-Q^2 R^2/4))) where Bose-Einstein Effects Q^2 = (p_1 + p_2)^2 - (m_1 + m_2)^2. Here the strength Bose-Einstein Effects lambda and effective radius Bose-Einstein Effects R are the two main parameters. The first factor of the equation is implemented by pulling pairs of identical hadrons closer to each other. This is done in such a way that three-momentum is conserved, but at the price of a small but non-negligible negative shift in the energy of the event. The second factor compensates this by pushing particles apart. The negative Bose-Einstein Effects alpha parameter is determined iteratively, separately for each event, so as to restore energy conservation. The effective radius parameter is here Bose-Einstein Effects R/3 , i.e. effects extend further out in Bose-Einstein Effects Q. Without the dampening Bose-Einstein Effects (1 - exp(-Q^2 R^2/4)) in the second factor the value at the origin would become Bose-Einstein Effects f_2(0) = (1 + lambda) * (1 + alpha * lambda) , with it the desired value Bose-Einstein Effects f_2(0) = (1 + lambda) is restored. The end result can be viewed as a poor man's rendering of a rapidly dampened oscillatory behaviour in Bose-Einstein Effects Q. Bose-Einstein Effects Further details can be found in Bose-Einstein Effects Lon95. For instance, the target is implemented under the assumption that the initial distribution in Bose-Einstein Effects Q can be well approximated by pure phase space at small values, and implicitly generates higher-order effects by the way the algorithm is implemented. The algorithm is applied after the decay of short-lived resonances such as the Bose-Einstein Effects rho , but before the decay of longer-lived particles. Bose-Einstein Effects This algorithm is known to do a reasonable job of describing BE phenomena at LEP. It has not been tested against data for hadron colliders, to the best of our knowledge, so one should exercise some judgment before using it. Therefore by default the master switch Bose-Einstein Effects HadronLevel:BoseEinstein is off. Furthermore, the implementation found here is not (yet) as sophisticated as the one used at LEP2, in that no provision is made for particles from separate colour singlet systems, such as Bose-Einstein Effects W 's and Bose-Einstein Effects Z 's, interfering only at a reduced rate. Bose-Einstein Effects Bose-Einstein Effects Warning: The algorithm will create a new copy of each particle with shifted momentum by BE effects, with status code 99, while the original particle with the original momentum at the same time will be marked as decayed. This means that if you e.g. search for all Bose-Einstein Effects pi+- in an event you will often obtain the same particle twice. One way to protect yourself from unwanted doublecounting is to use only particles with a positive status code, i.e. ones for which Bose-Einstein Effects event[i].isFinal() is Bose-Einstein Effects true. Bose-Einstein Effects Main parameters Assuming you have set Bose-Einstein Effects HadronLevel:BoseEinstein = on , you can regulate the detailed behaviour with the following settings."},{"name":"CKKW-L Merging","link":"CKKWLMerging.html","text":"CKKW-L Merging CKKW-L Merging CKKW-L Merging CKKW-L merging CKKW-L Merging Lon01 allows for a consistent combination of tree-level matrix elements containing multiple well-separated partons with each other and with parton showers. The result is a calculation that contains a mix of processes with different number of well-separated jets with fixed-order accuracy, improved by all-order resummation. The algorithm implemented  in PYTHIA is described in CKKW-L Merging Lon11. To perform matrix element merging,  the user has to supply LHE files CKKW-L Merging Alw07 for the hard process and the corresponding process with up to N additional jets. This mix of processes is then internally disentangled to ensure that the inclusive fixed-order inputs can be converted to exclusive cross sections that no longer overlap. Please note that subtleties (and setting scheme) for the EW-improved way of disentangling processes presented in CKKW-L Merging Chr15a is discussed in the section Electroweak Merging below. CKKW-L Merging The usage of the merging procedure is illustrated in a few example main  programs ( CKKW-L Merging main81.cc , CKKW-L Merging main82.cc , CKKW-L Merging main83.cc , CKKW-L Merging main84.cc and CKKW-L Merging main85.cc , together with the input files CKKW-L Merging main81.cmnd , CKKW-L Merging main82.cmnd , CKKW-L Merging main84.cmnd and CKKW-L Merging main85.cmnd ). These examples should of course only serve as  an illustration, and as such will not make use of the merging in all  possible ways. For full generality, the example programs link to LHAPDF,  FastJet and HepMC. Of course the user is welcome to  remove these dependencies. To remove the FastJet dependence, the functions calculating example observables have to be deleted. Removing the LHAPDF  dependence requires changing the cmnd input files to choose an inbuilt PDF,  as outlined in the CKKW-L Merging PDF documentation.  The HepMC dependence can be removed by erasing the code allowing for HepMC output. CKKW-L Merging Please note that a detailed tutorial on merging in Pythia is available from CKKW-L Merging http://home.thep.lu.se/Pythia/pythia8/mergingworksheet8160.pdf. CKKW-L Merging Three very short LHE files ( CKKW-L Merging w+_production_lhc_0.lhe , CKKW-L Merging w+_production_lhc_1.lhe , CKKW-L Merging w+_production_lhc_2.lhe ) are included in the distribution. These files are not intended for physics  studies, but only serve as input for the example main programs. For  realistic studies, the user has to supply LHE files. CKKW-L Merging In the generation of LHE files, the value of the factorisation scale used in  the PDFs is not important, since the cross section will be multiplied by ratios  of PDFs to adjust to the PYTHIA starting scales. The same is true for the  renormalisation scale (and starting value CKKW-L Merging &alpha; CKKW-L Merging s (M CKKW-L Merging Z ) )  used to evaluate CKKW-L Merging &alpha; CKKW-L Merging s. Coupling and scale choices by the user will be transferred to the merging routines. CKKW-L Merging Multi-jet events can suffer from infrared divergences in the calculation. Sensible matrix element generator (MEG) outputs should not contain phase space points in which the calculation is ill-defined, meaning infrared regions need to be removed by cuts. This is most conveniently done by disallowing the MEG to produce partons below a minimal parton-parton separation in a certain jet algorithm. Using dedicated cuts to regularise MEG output is of course possible as well. Any regularisation criterion defines the matrix element region: The parts of phase space in which the fixed order calculation is considered valid and preferable to the parton shower. Matrix element merging is combining MEG events in the matrix element region with parton shower events in regions outside the regularisation cut (often called parton shower region). Because the regularisation cut defines a boundary between the matrix element and parton shower regions, i.e. the regions to be merged into one inclusive sample, it is usually called CKKW-L Merging merging scale. Since many different cut choices may regularise the MEG calculation, many different merging scale definitions are possible. A few standard choices are listed below, as well as documentation on how to use a user-defined cut criterion. In combining matrix element and parton shower regions, the CKKW-L prescription tries to minimise the dependence on the merging scale. This can only be achieved if the combination of MEG events and parton shower populates the whole phase space. Additional cuts on the partons in the LHEF generation should hence be avoided as much as possible, meaning that the merging scale cut should always pose a more stringent cut than all other cuts on the partons. Of course, if the hard process itself is divergent, cuts need to be made. However, this should be chosen in such a way as to not exclude regions that will be available to the matrix elements with additional jets. An example is QCD di-jet production with additional jets: Say the CKKW-L Merging 2 &rarr; 2 process is regularised with a CKKW-L Merging pTmin cut of pTminCut = 100 GeV, and the CKKW-L Merging 2 - >3 sample is regularised with a CKKW-L Merging kTmin -cut of kTminCut = 50 GeV. This would mean that when reclustering the  emission in the 2 &rarr; 3 sample, we could end up with a CKKW-L Merging pT value CKKW-L Merging pTminNow of the 2 &rarr; 2 configuration with CKKW-L Merging pTminCut > pTminNow , which is excluded in the 2 &rarr; 2 sample. Thus, the 2 &rarr; 3 sample will include a Sudakov factor  not included in the 2 &rarr; 2 sample, resulting in merging scale  dependencies. Such dependencies can be avoided if the additional cuts on the hard process are minimal. CKKW-L Merging Of course, additional cuts on electroweak particles are allowed. These  should be the same for all samples with CKKW-L Merging 0 <= n <= N additional partons. CKKW-L Merging If it is not possible to generate LHE files with minimal cuts, the user can choose to use the CKKW-L Merging MergingHooks structures in order to decide how much influence to attribute to parton shower histories in which the reclustered lowest multiplicity process does not pass the matrix element cuts. This is  described below. CKKW-L Merging When generating LHE files, we advise against putting unstable  particles (e.g. massive gauge bosons) in the final state. Rather, specify a  resonance by its decay products, e.g. if Les Houches events for the CKKW-L Merging pp &rarr; Z + jets &rarr; e+e- + jets process are desired, generate the matrix element events with the CKKW-L Merging Z decay included. From a physical  point of view, on-shell final massive gauge bosons should not be considered  part of a hard process, since only the boson decay products will be detectable.  Furthermore, non-narrow-width approximation contributions are not present if  the ME generator only produces on-shell bosons. Interference effects between  different production channels for the decay products would also be neglected.  These points seem an unnecessary restriction on the accuracy of the ME  calculation.  In addition, there is a technical reason for this strategy. Since  some matrix element generators choose to put additional information on  intermediate bosons into Les Houches events, depending on if they pass a certain criterion (e.g. being close to the mass shell), without exact knowledge of this  criterion, the only feasible way of bookkeeping the hard process is by  identifying outgoing decay products. CKKW-L Merging Despite these considerations, (massive) gauge bosons in the final state are allowed in the hard process definition. This is useful particularly for Higgs physics, when different decays of the Higgs boson need to be simulated after the LHEF generation. CKKW-L Merging For all merging purposes, processes with different charge of outgoing leptons are considered different processes. That means e.g. that CKKW-L Merging e+&nu; CKKW-L Merging e + jets and CKKW-L Merging e-&nu;&#772; CKKW-L Merging e + jets are considered independent processes. If the user wishes to generate distributions including effects of more than one  process, merged samples for all independent processes should be generated  separately and added afterwards. Alternatively, to combine simple processes, combined LHE files can be used in conjunction with flexible containers (see below). CKKW-L Merging When the matrix element merging is used to produce HepMC CKKW-L Merging Dob01 files to be analysed  with RIVET CKKW-L Merging Buc10 , special care  needs to taken in how the cross section is read by RIVET (see below). CKKW-L Merging To specify the merging conditions, additionally information on the merging scale value and the functional definition of the merging scale is needed. A few  standard definitions of merging scales are available. We hope this makes the user interface less cumbersome. CKKW-L Merging Different choices intrinsic to the CKKW-L merging procedure might be relevant for the user as well. The base class CKKW-L Merging MergingHooks gives the user the opportunity to define the functional form of the merging scale.  In the following, the usage of the merging machinery to consistently include LHE files with additional jets into PYTHIA  will be discussed. CKKW-L Merging CKKW-L Merging CKKW-L Merging CKKW-L Merging Merging scale definitions CKKW-L Merging The quickest way to include processes with additional jets is to produce LHE files with one of the standard ways to define the merging scale. Three standard ways to define a merging scale (minimal CKKW-L Merging kT , minimal evolution CKKW-L Merging pT and by three cuts) are implemented. All of these prescriptions are equivalent - different definitions have only been introduced for the convenience of users, who might be limited by which cuts can be used in the generation of LHE files. Below, we describe how to switch on and use these different merging scale definitions. CKKW-L Merging Merging with merging scale defined in kT: CKKW-L Merging Currently, the name longitudinally invariant CKKW-L Merging kT is used for a few jet recombination algorithms with slightly different jet measures. A specific form can be chosen by setting the switch CKKW-L Merging If e.g. CKKW-L Merging W + jets merging should be performed, set this to CKKW-L Merging pp>e+ve ( CKKW-L Merging without white spaces or  quotation marks ). This string may contain resonances in the MG/ME notation, e.g. for merging CKKW-L Merging pp&rarr;Z W CKKW-L Merging + &rarr;q q&#772; e+&nu; CKKW-L Merging e + jets , the string CKKW-L Merging pp>(z>jj)(w+>e+ve) would be applicable. CKKW-L Merging A lot more flexible hard process definitions are possible. To not dwell too much on these details here, we will come back to the process string at the end of this section. CKKW-L Merging Merging with merging scale defined in Pythia evolution CKKW-L Merging pT : If the LHE file has been regularised by cutting on the minimal Pythia evolution CKKW-L Merging pT in the state, this can also be used as a merging scale right away. For this, change the switch CKKW-L Merging Merging with merging scale defined by a combination of cuts: It is possible to regularise QCD divergences in a LHE file by applying cuts to the kinematical CKKW-L Merging pT of jets ( CKKW-L Merging pT CKKW-L Merging i ), combined with a cut on CKKW-L Merging &Delta;R CKKW-L Merging ij between jets and a cut on invariant mass CKKW-L Merging Q CKKW-L Merging ij of jet pairs. The combination of these standard cuts can also serve as a merging scale. For this, use this setting CKKW-L Merging The values of the cuts will then be read from CKKW-L Merging With knowledge of these values, and CKKW-L Merging Merging:doCutBasedMerging , Pythia will use these cuts as a separation between matrix element phase space and parton shower region. If e.g. the Les Houches Events have been generated with the cuts CKKW-L Merging &Delta;R CKKW-L Merging ij = 0.1 , CKKW-L Merging pT CKKW-L Merging i = 20 GeV and CKKW-L Merging Q CKKW-L Merging ij = 40 GeV , set CKKW-L Merging Merging:QijMS=40. , CKKW-L Merging Merging:pTjMS=20. , CKKW-L Merging Merging:dRijMS=0.1 to perform a cut-based merging. Of course you will also need to set CKKW-L Merging Merging:Process and the maximal number of additional matrix element jets CKKW-L Merging Merging:nJetMax. CKKW-L Merging Les Houches events outside the matrix element region CKKW-L Merging Before continuing, we would like to point out that in general, the user should make sure that the events in the Les Houches file are actually calculated using the regularisation cut definition and value(s) supplied to Pythia as merging scale definition and value(s). However, if LH files with a large number of events and loose merging scale cuts are available, it might be useful to choose a higher merging scale value, e.g. for merging scale variations as part of uncertainty assessments. If CKKW-L merging is enabled, Pythia will by default check if events read from Les Houches file are in the matrix element region as defined by the merging scale definition and merging scale value. Events outside the matrix element region will be discarded. This will lead to warnings of the form ' CKKW-L Merging Les Houches Event fails merging scale cut. Cut by rejecting event '. These warnings should, in this case, rather be regarded as information. To change the default behaviour, use the flag CKKW-L Merging Defining the hard process To perform CKKW-L matrix element merging, the user has to decide on a hard process, and communicate this choice to Pythia. This is done by setting the input CKKW-L Merging Merging:Process. Note that the EW-improved 'merging of mergings' strategy presented in CKKW-L Merging Chr15a requires a very loose process definition that is discussed in the section Electroweak Merging below. CKKW-L Merging For single processes in the Standard Model or the MSSM a notation similar to MG4/MEis applicable. However, for some purposes, using a single simple process string is not satisfactory. Mixed W CKKW-L Merging + and W CKKW-L Merging - events in a single LHE file is a common example. For this case, it would of course be perfectly allowed to perform twice, once for W CKKW-L Merging + production and once for W CKKW-L Merging - production, and then add the results. Nevertheless, it seems reasonable to alleviate difficulties by allowing for less restrictive hard process definitions. Some generalisations of the process tag are available: Containers, user-defined particle tags and a very rudimentary option to 'guess' the hard process. The syntax of these settings is described below. CKKW-L Merging In case you want multiple processes in a LHE file to be treated on equal footing (e.g. CKKW-L Merging W CKKW-L Merging + + jets and CKKW-L Merging W CKKW-L Merging - + jets ), you should use flexible containers do specify the hard process. So far, we allow the use of the containers CKKW-L Merging LEPTONS , CKKW-L Merging NEUTRINOS , CKKW-L Merging BQUARKS. If you use these containers, the hard process definition is relatively flexible, meaning that Pythia will attempt a merging of QCD jets for each event in the LHE file, and assume that all particles matching one of the containers are products of the hard process. This is best explained by examples. If you want to have both CKKW-L Merging pp &rarr; e+ &nu; CKKW-L Merging e + jets and CKKW-L Merging pp &rarr; e- &nu;&#772; CKKW-L Merging e + jets events in a single file, you can set CKKW-L Merging Merging:Process=pp>LEPTONS,NEUTRINOS as hard process (note that for readability, you are allowed to use commata to separate container names). Combining e.g. the processes CKKW-L Merging pp &rarr; e+ &nu; CKKW-L Merging e and CKKW-L Merging pp &rarr; &mu;+ &nu; CKKW-L Merging &mu; is possible with the hard process definition CKKW-L Merging pp>LEPTONS,NEUTRINOS. CKKW-L Merging For maximal flexibility, the definition of the hard process by these containers does not mean that each Les Houches event needs to contain particles to match each container. It is enough if one container is matched. This means that with the string CKKW-L Merging pp>LEPTONS,NEUTRINOS , you can immediately process CKKW-L Merging pp &rarr; e+ e- events mixed with CKKW-L Merging pp &rarr; e+ &nu; CKKW-L Merging e events, since particles matching at least one container can be found in both cases. Another example for the usage of containers is mixing CKKW-L Merging pp &rarr; e+ &nu; CKKW-L Merging e and CKKW-L Merging pp &rarr; tt&#772; &rarr; e+ &nu; CKKW-L Merging e e- &nu;&#772; CKKW-L Merging e bb&#772;. This can be accommodated by the hard process string CKKW-L Merging Merging:Process=pp>LEPTONS,NEUTRINOS,BQUARKS. CKKW-L Merging There is however a conceptual limitation to containers: The hard process definition is necessary to ensure that when constructing lower multiplicity states (that will be used to calculate the correct merging weight), the structure of the hard process will be preserved. If e.g. we want the hard process to be CKKW-L Merging pp &rarr; Z &rarr; bb&#772; , we should ensure that the lowest multiplicity state contains a colour-singlet bb&#772;-pair. When reconstructing intermediate lower multiplicity states from multi-jet matrix elements, we should thus always be able to find at least one bb&#772;-pair. By mixing different processes in a LHE file, this requirement might already be violated at the level of Les Houches events. Flexible containers cannot give strong conditions which flavours should be preserved in the construction of the hard process. In order to avoid non-sensible results, it is hence CKKW-L Merging assumed that all particles matching any of the containers will be part of the lowest multiplicity process. This implies that if you decide to use the CKKW-L Merging BQUARKS container, all b-quarks in the LHE file will be interpreted as hard process particles, and never as additional radiation. CKKW-L Merging Another way to specify the hard process particles is to explicitly define the particle names and identifiers. This is necessary if the matrix element merging in Pythia does not contain the particles of interest. To make sure that the hard process is still treated correctly, it is possible to define particles in the process string. If you e.g. want the hard process to contain a particle 'zeta~' with PDG identifier '12345', produced in proton collisions, you have to include a user-defined particle tag by setting the process string to CKKW-L Merging pp>{zeta~,12345}. The  user-defined particle is enclosed in curly brackets, with syntax CKKW-L Merging {particle_name,particle_identifier} , where 'particle_name' and 'particle_identifier' are the particle name and particle identifier used for this particle in the input LHE file. User-defined particles are only allowed in the final state. You are free to fix user-defined particles with more common ones, as long as user-defined particles are put before more common particles in the process string. This means that if you e.g. wanted the hard process to contain a graviton in association with a positron and an electron-neutrino, you have to define the hard process as CKKW-L Merging pp>{G,39}e+ve. CKKW-L Merging Below you can find a list of particles predefined in the merging. If you wish to include a hard process with different final state particles, you may use the 'curly bracket notation' outlined above. CKKW-L Merging The set of incoming particles us limited to: CKKW-L Merging e- (electron), CKKW-L Merging e+ (positron), CKKW-L Merging mu- (muon), CKKW-L Merging mu+ (antimuon), CKKW-L Merging p (proton, container to hold all initial state coloured particles), CKKW-L Merging p~ (identical to CKKW-L Merging p container). CKKW-L Merging The following intermediate particles are allowed: CKKW-L Merging a (photon), CKKW-L Merging z (Z boson), CKKW-L Merging w- (W CKKW-L Merging - boson), CKKW-L Merging w+ (W CKKW-L Merging + boson), CKKW-L Merging h (scalar Higgs boson), CKKW-L Merging W (container to hold both W CKKW-L Merging - and W CKKW-L Merging + boson), CKKW-L Merging t (top quark), CKKW-L Merging t~ (anti-top), CKKW-L Merging dl , CKKW-L Merging dl~ , CKKW-L Merging ul , CKKW-L Merging ul~ , CKKW-L Merging sl , CKKW-L Merging sl~ , CKKW-L Merging cl , CKKW-L Merging cl~ , CKKW-L Merging b1 , CKKW-L Merging b1~ , CKKW-L Merging t1 , CKKW-L Merging t1~ , CKKW-L Merging dr , CKKW-L Merging dr~ , CKKW-L Merging ur , CKKW-L Merging ur~ , CKKW-L Merging sr , CKKW-L Merging sr~ , CKKW-L Merging cr , CKKW-L Merging cr~ , CKKW-L Merging b2 , CKKW-L Merging b2~ , CKKW-L Merging t2 , CKKW-L Merging t2~ (all MSSM squarks). CKKW-L Merging We have pre-defined the outgoing particles: CKKW-L Merging e+ , CKKW-L Merging e- , CKKW-L Merging ve~ , CKKW-L Merging ve , CKKW-L Merging mu+ , CKKW-L Merging mu- , CKKW-L Merging vm~ , CKKW-L Merging vm , CKKW-L Merging ta+ , CKKW-L Merging ta- , CKKW-L Merging vt~ , CKKW-L Merging vt (all SM leptons and neutrinos), CKKW-L Merging j~ (container to hold all final state coloured particles), CKKW-L Merging j (container to hold all final state coloured particles), CKKW-L Merging NEUTRINOS (container to hold all final state neutrinos and anti-neutrinos), CKKW-L Merging LEPTONS (container to hold all final state leptons and anti-leptons), CKKW-L Merging BQUARKS (container to hold final state b-quarks), CKKW-L Merging d~ , CKKW-L Merging d , CKKW-L Merging u~ , CKKW-L Merging u , CKKW-L Merging s~ , CKKW-L Merging s , CKKW-L Merging c~ , CKKW-L Merging c , CKKW-L Merging b~ , CKKW-L Merging b , CKKW-L Merging t~ , CKKW-L Merging t (all SM quarks), CKKW-L Merging a , CKKW-L Merging z , CKKW-L Merging w- , CKKW-L Merging w+ (all SM electro-weak bosons), CKKW-L Merging h (scalar Higgs boson), CKKW-L Merging W (container to hold both W CKKW-L Merging - and W CKKW-L Merging + boson), CKKW-L Merging n1 (MSSM neutralino), CKKW-L Merging dl~ , CKKW-L Merging dl , CKKW-L Merging ul~ , CKKW-L Merging ul , CKKW-L Merging sl~ , CKKW-L Merging sl , CKKW-L Merging cl~ , CKKW-L Merging cl , CKKW-L Merging b1~ , CKKW-L Merging b1 , CKKW-L Merging t1~ , CKKW-L Merging t1 , CKKW-L Merging dr~ , CKKW-L Merging dr , CKKW-L Merging ur~ , CKKW-L Merging ur , CKKW-L Merging sr~ , CKKW-L Merging sr , CKKW-L Merging cr~ , CKKW-L Merging cr , CKKW-L Merging b2~ , CKKW-L Merging b2 , CKKW-L Merging t2~ , CKKW-L Merging t2 (all MSSM squarks). Other outgoing particles are possible if you use the 'curly bracket notation' described earlier. CKKW-L Merging Finally, it is worth noting that including the header CKKW-L Merging Pythia8Plugins/aMCatNLOHooks.h (as is e.g. the case in the CKKW-L Merging main89.cc example) allows the user to instruct Pythia to 'guess' the hard process by setting CKKW-L Merging Merging:Process = guess. In this case, the code will inspect the hard process before starting the merging code, and set CKKW-L Merging Merging:Process on an event-by-event basis according to the rules implemented in CKKW-L Merging Pythia8Plugins/aMCatNLOHooks.h. It is instructive to understand these rules before using this feature. At present, the guess feature assumes that any non-colored particle, any particle with PDG ID larger than 21, and any quark not labelled as 'additional parton' through the CKKW-L Merging Merging:nQuarksMerge mode are part of the hard process definition. This e.g. enables usage for simple BSM processes. Please use this feature with caution. CKKW-L Merging CKKW-L Merging CKKW-L Merging CKKW-L Merging Histogramming the events After the event has been processed, histograms for observables of interest need to be filled. In order to achieve good statistical accuracy for all jet multiplicities and all subprocesses contributing to one jet multiplicity, generally a fixed number of unit-weighted events is read from each Les Houches Event file. To then arrive at the correct prediction, for each of these events, histogram bins should be filled with the corresponding cross section, or weighted with unit weight and normalised at the end to the generated cross section for each jet multiplicity separately. CKKW-L Merging Still another, even more important, event weight that has to applied on an  event-by-event basis is the CKKW-L-weight. This corrective weight is the main  outcome of the merging procedure and includes the correct no-emission  probabilities, PDF weights and coupling (&alpha; CKKW-L Merging s or &alpha; CKKW-L Merging em ) factors. This means that the merging implementation will generate weighted events. The CKKW-L-weight can be accessed by the following function: CKKW-L Merging CKKW-L Merging double Info::mergingWeight() &nbsp; CKKW-L Merging Returns the CKKW-L weight for the current event. CKKW-L Merging Note that to avoid confusion, this function does not include the the weight of a phase space point (given by CKKW-L Merging Info::weight() ). This weight will differ from unity when reading in weighted Les Houches events. In this case, the full weight with which to fill histogram bins is CKKW-L Merging Info::mergingWeight() * Info::weight(). CKKW-L Merging Finally, to arrive at a correct relative normalisation of the contributions from different number of additional jets in the matrix element, each histogram should be rescaled with the accepted cross section given by CKKW-L Merging Info::sigmaGen(). The accepted cross section includes the  effect of vetoes generating Sudakov form factors for the matrix elements, and  is in general only known after the run. CKKW-L Merging This final step can of course be skipped if the accepted cross section had been estimated before the histogramming run, and  histogram bins had instead been filled with the weight CKKW-L Merging Info::mergingWeight() * &sigma; CKKW-L Merging est (number of additional jets in current ME sample). This is the way HepMC events should be weighted to produce correct relative weights of events (see below, and particularly examine the example programs CKKW-L Merging main84.cc and CKKW-L Merging main85.cc ). CKKW-L Merging Examples how to use these options are given in CKKW-L Merging main81.cc ( CKKW-L Merging kT merging), CKKW-L Merging main84.cc (automatic MG/ME merging for RIVET usage), and CKKW-L Merging main85.cc (HepMC output for RIVET usage). CKKW-L Merging CKKW-L Merging CKKW-L Merging CKKW-L Merging Merging with user-defined merging scale function CKKW-L Merging For all other merging scale definitions, the procedure is slightly more  complicated, since the user has to write a small piece of code defining the  merging scale. To allow for a user defined procedure, set the input CKKW-L Merging Then, set the CKKW-L Merging Merging:nJetMax , CKKW-L Merging Merging:TMS and CKKW-L Merging Merging:Process input as before. CKKW-L Merging Since during execution, PYTHIA needs to evaluate the merging scale with the  definition of the user, the user interface is designed in a way similar to the CKKW-L Merging UserHooks strategy. The class controlling the merging scale  definition is called CKKW-L Merging MergingHooks. CKKW-L Merging Initialisation CKKW-L Merging To initialise the merging with user-defined merging scale, we should construct a class derived from CKKW-L Merging MergingHooks , with a constructor and destructor CKKW-L Merging CKKW-L Merging For the class to be called during execution, a pointer to an object of the class should be handed in with the CKKW-L Merging CKKW-L Merging CKKW-L Merging Pythia::setMergingHooksPtr( MergingHooks*) method.  An examples of this procedure are given in CKKW-L Merging main82.cc. CKKW-L Merging Defining a merging scale CKKW-L Merging Then, in the spirit of the CKKW-L Merging UserHooks class, the user needs to  supply the process to be merged by defining a methods to evaluate the merging scale variable. CKKW-L Merging The base class CKKW-L Merging MergingHooks contains many functions giving  information on the hard process, to make the definition of the merging scale as easy as possible: CKKW-L Merging Filling output histograms for the event then proceeds along the lines described above in 'Histogramming the events'. CKKW-L Merging The full procedure is outlined in CKKW-L Merging main82.cc. Special care needs to be  taken when the output is stored in the form of HepMC files for RIVET usage. CKKW-L Merging Defining a cut on lowest jet multiplicity events CKKW-L Merging It can sometimes happen that when generating LHE files, a fairly restrictive cut has been used when generating the lowest multiplicity matrix element  configurations. Then, it can happen that states that are (in the generation of a parton shower history) constructed by reclustering from higher multiplicity  configurations, do not pass this matrix element cut. CKKW-L Merging Consider as an example  pure QCD dijet merging, when up to one additional jet should be merged.  Three-jet matrix element configurations for which the reclustered two-jet state does not pass the cuts applied to the two-jet matrix element would never have  been produced by showering the two-jet matrix element. This means that the three-jet matrix element includes regions of phase space that would never have  been populated by the parton shower. Thus, since the matrix element phase space is larger than the shower phase space, merging scale dependencies are expected.  A priori, this is not troublesome, since the aim of matrix element merging is  to include regions of phase space outside the range of the parton shower approximation into the shower. An example is the inclusion of configurations  with only unordered histories. CKKW-L Merging Clearly, if the parton shower phase space is very constrained by applying  stringent cuts to the two-jet matrix element, merging scale dependencies can  become sizable, as was e.g. seen in CKKW-L Merging Lon11 when forcing shower emissions to be ordered both in the evolution variable and in rapidity. To  influence the effect of large phase space differences for shower emissions and matrix element configurations due to LHEF generation cuts, the user has to  write a small piece of code overwriting method CKKW-L Merging Note that this method gives the user access to the lowest multiplicity state,  which ( e.g. in the case of incomplete histories) does not have to be a CKKW-L Merging 2 &rarr; 2 configuration. Also, changing the weight of the current event by  hand is of course a major intervention in the algorithm, and should be  considered very carefully. Generally, if this facility would have to be used extensively, it is certainly preferable to be less restrictive when applying  additional, non-merging-scale-related cuts to the matrix element. CKKW-L Merging An example how to force a cut on lowest multiplicity reclustered states for pure QCD matrix element configurations is given by CKKW-L Merging main83.cc (to be used with e.g. CKKW-L Merging main82.cmnd ). CKKW-L Merging Influencing the construction of all possible histories CKKW-L Merging Even more powerful - and dangerous - is influencing the construction of histories directly. This should only be attempted by expert users. If you believe manipulations completely unavoidable, we advise you to take great care when redefining the following functions. CKKW-L Merging Clearly, these methods are highly intrusive. It could e.g. happen that no history is allowed, which would make merging impossible. One example where this method could be useful is if cuts on the core CKKW-L Merging 2 &rarr; 2 processes have to be checked, and the method CKKW-L Merging MergingHooks::dampenIfFailCuts(const Event& event) is not sufficiently effective. CKKW-L Merging Defining the hard process matrix element CKKW-L Merging The MergingHooks class also allows the expert user to define the matrix element of the hard process, by defining the method CKKW-L Merging The inclusion of the hard process matrix element into the choice of histories becomes relevant when the hard process matrix element has very strong phase space dependencies. QCD dijet cross sections for example strongly depend on the transverse momentum of the jets. So far, the authors have not encountered any changes upon inclusion of the full hard process matrix element, even for the QCD dijet case. CKKW-L Merging CKKW-L Merging CKKW-L Merging CKKW-L Merging Matrix element merging and HepMC output for RIVET Examples how to produce matrix element merged events to be analysed with RIVET are given by CKKW-L Merging main84.cc and CKKW-L Merging main85.cc. CKKW-L Merging The main issue is that the output of separate RIVET runs can not in general be combined. To perform a matrix element merging, we however need to runs over  different LHE files. The solution to this problem (so far) is to only perform  one RIVET run for all matrix elements, i.e. print the events for all ME parton  multiplicities, with the correct weights, to a single HepMC file. Since the correct weight includes the cross section of the different samples after Sudakov vetoes --- which is not a priori known --- the cross sections have to be  estimated in a test run, before the actual production run is performed. Finally, the cross section of the last event in the HepMC file has to be taken as the  full merged cross section CKKW-L Merging sigma_merge = Sum_{i=0}^N Sum_{j=0}*^{nEvents} sigma_est(i)*wckkwl(j). CKKW-L Merging This procedure is outlined in CKKW-L Merging main84.cc.  Input LHE files with only very inclusive cuts pose further difficulties. For such files (which were already addressed under the heading CKKW-L Merging Les Houches events outside the matrix element region ), the cross section after the merging scale cut is not known before the cut is performed. Using Pythia's CKKW-L Merging UserHooks facilities, it is possible to produce a valid estimate of the cross section after cuts. This however entails a careful cut definition by the user, which might become cumbersome for some in-built merging scale definitions. A reasonable alternative is using the switch CKKW-L Merging This switch also relies on knowledge on how many partons a LHE file should contain. This is important for real-emission kinematics in the case of NLO merging. The number of (additional) partons in a LHE file can be set with CKKW-L Merging The usage of these switches to obtain the necessary cross section estimate is illustrated in CKKW-L Merging main85.cc. The example CKKW-L Merging main85.cc program is intended as a 'front-end' for CKKW-L merging in Pythia8, so we will discuss the program briefly. CKKW-L Merging main85.cc should be used together with an input file (like CKKW-L Merging main85.cmnd ). The executable should be invoked with three arguments: the input file, the 'name' of the input LHE files, and the name of the output HepMC event file. To use the LHE files that are shipped with the Pythia distribution, a valid usage would be CKKW-L Merging CKKW-L Merging ./main85.exe ./main85.cmnd ./w_production ./myhepmc.hepmc CKKW-L Merging If you want to use other input LHE files, note that CKKW-L Merging main85.cc assumes the naming convention CKKW-L Merging name_tree_#nAdditionalJets.lhe. All settings can be included though the input file, so that CKKW-L Merging main85.cc does not have to be changed explicitly. CKKW-L Merging main85.cc first switches off showers, multiparton interactions and hadronisation, and estimates the cross sections (after enforcing the merging scale cut) of samples for different numbers of additional jets. Then, showers, MPI and hadronisation are switched on again, and the CKKW-L merging procedure is performed. Events will be read in a decreasing sequence of jet multiplicities, which also means that e.g. events with two additional partons in the LHE file will be printed to the HepMC file before events with one additional parton. CKKW-L Merging CKKW-L Merging CKKW-L Merging CKKW-L Merging Electroweak Merging Merging strategies like CKKW-L usually assume that the description of a (relatively simple) underlying process should be improved by combining with states that contain additional well-separated partons - with 'additional' measured with respect to the underlying process. As discussed in CKKW-L Merging Chr15a , this philosophy is not always sensible, and may lead to an unconvincing physics model. The bias can be greatly reduced by considering that in perturbation theory, corrections to seemingly very different underlying processes mix, so that there is no justification to classify some states as corrections to only one underlying process. Interactions that only contain vertices of only one theory (e.g. QCD) will mix with processes that contain only vertices of another interactions (e.g. QED). Underlying processes with very different coupling structures should thus be considered. This is the main aim of the electroweak merging scheme. The process CKKW-L Merging p p &rarr; W jet jet provides a good example, since it can be interpreted either as double-real-QCD-emission correction to CKKW-L Merging p p &rarr; W or as real-electroweak-emission correction to CKKW-L Merging p p &rarr; jet jet. The distinction is artificial, but the all-order resummation is very different in either case, leading to distinctly different predictions. Thus, a minimally biased method for assigning an underlying process has to be found. CKKW-L Merging The method of CKKW-L Merging Chr15a chooses the underlying process probabilistically for each phase space point based on a product of splitting kernels and full hard process matrix elements, and includes the correct all-order factors after this choice. In our previous example ( CKKW-L Merging p p &rarr; W jet jet ), this would mean that the hard scattering could be CKKW-L Merging p p &rarr; W or CKKW-L Merging p p &rarr; jet jet (or, depending on phase space considerations, also CKKW-L Merging p p &rarr; W jet ). The availability of CKKW-L Merging electro-weak showers in Pythia 8 is crucial for a consistent scheme that removes of double-counting, since double-counting is (in part) removed by applying no-emission probabilities. In order to e.g. ensure that a state in the CKKW-L Merging p p &rarr; jet jet does not, via W-boson emission, evolve into a state overlapping with CKKW-L Merging p p &rarr; W + two QCD emissions, the former has to be reweighted with an all-order no-electroweak-emission probability. As always, a small merging scale dependence is facilitated by accounting for for dynamical PDF evaluation and running couplings. An electroweak merging thus includes a reweighting with &alpha; CKKW-L Merging em ratios that are automatically included in the 'merging weight'. CKKW-L Merging As another consequence of probabilistically assigning the underlying process is the 'merging of mergings': Since purely partonic final states can evolve into jets + electroweak bosons states, it is necessary to treat bosons and partons on equal footing, meaning that well-separated boson states should be corrected with fixed-order inputs, while soft/collinear bosons should be associated with parton showering. Shortly, bosons and partons are treated identically. For our previous example, this means that the 'correct' set of fixed-order corrections that include up to three final state particles is CKKW-L Merging p p &rarr; n Ws + m jets , where any combination of n and m subject to CKKW-L Merging n + m <= 3 has to be included ( CKKW-L Merging p p &rarr; W , CKKW-L Merging p p &rarr; W jet , CKKW-L Merging p p &rarr; W jet jet , CKKW-L Merging p p &rarr; W W , CKKW-L Merging p p &rarr; W W W , CKKW-L Merging p p &rarr; W W jet , CKKW-L Merging p p &rarr; jet jet , CKKW-L Merging p p &rarr; jet jet jet ) For practical purposes, it is sometimes permitted to not combine a complete set of processes. Only the single W-state has been explicitly validated and in addition the weak PS does not include all possible splittings for multiple W emissions, therefore caution has to be taken if using this for multiple W states. CKKW-L Merging The 'merging of mergings' has important consequences for the (interested) user. Below, we give instructions on the usage of the electroweak merging. CKKW-L Merging Fixed-order inputs for electroweak merging The electroweak merging leads to the idea of a 'merging of mergings'. This has to be enforced also at the fixed-order sample generation stage, with two main requirements. CKKW-L Merging A fully consistent treatment requires the generation of samples containing all states with a number of emissions that is less than or equal to the 'maximal possible number of emissions of any type' that should be corrected, cf. the CKKW-L Merging W jet jet example above.  In practise, it is often permitted to disregard some (set of) samples since their impact on an analysis is negligible. If e.g. an analyis always requires missing transverse momentum and a single lepton, and we assume perfect lepton acceptances, then it would be permitted to disregard the multi-W samples in the example. If the collision energy is in addition low (~up to fews of TeVs), then the probability for a pure QCD state to emit W-bosons is often low enough so that the pure jet samples can be neglected. However, you should think very carefully before settling on any shortcuts. CKKW-L Merging Any particle that could count as an emission has to be included in the calculation of the particle separations that define the merging scale. If e.g. W-bosons are considered emissions, then any state with W-bosons that are collinear with another emission should be removed from the fixed-order sample. Such configurations will instead be produced through parton showering. This requirement means that you might have to define your own cut including this condition in your favourite fixed-order matrix element generator. At the risk of losses in efficiency, you can also use samples with very loose cuts and have Pythia enforce the merging scale cut when reading your input events. The latter is only possible if you use the merging scale definition CKKW-L Merging Merging:doPTLundMerging = on. CKKW-L Merging Enabling the electroweak merging The electroweak merging is currently only tested for processes containing W-bosons and jets. For a consistent merging, it is necessary to enable W-boson emissions by using CKKW-L Merging TimeShower:weakShower    = on , CKKW-L Merging TimeShower:weakShowerMode  = 1 , CKKW-L Merging SpaceShower:weakShower    = on , CKKW-L Merging SpaceShower:weakShowerMode = 1 , and CKKW-L Merging WeakShower:externalSetup  = on. CKKW-L Merging To enable the electroweak merging, use the following switch. CKKW-L Merging As explained above, the electroweak (EW) merging treats all shower-producible particles equally. This also means that the merging scale definition must include a separation of W-bosons and partons to define if a state is in the (well-separated) fixed-order region or if it is in the (soft/collinear) parton shower region. Such a cut can be implemented inside the (external) matrix element generator. On the other hand, Pythia 8 allows the usage of samples with very loose cuts and can enforce the correct merging scale cut by rejecting input events that do not pass the cut. This is also possible for the EW merging, albeit only for the merging scale definition that is enabled by using CKKW-L Merging Merging:doPTLundMerging = on. We recommend using this strategy for users that do not wish to implement the cut directly into the ME generation, and who are prepared to accept a loss of efficiency because of Pythia's a-posteriori rejection. CKKW-L Merging Defining the 'inclusive' merging process Since the concept of a single 'hard process' is not suitable for the EW merging, the process should be defined in a rather loose manner. This loose definition is still done by setting the input CKKW-L Merging Merging:Process.  Processes for EW merging should use the containers CKKW-L Merging Jinc , CKKW-L Merging Winc , CKKW-L Merging Ainc and CKKW-L Merging Zinc , which tell the code which particles could be possible 'additional' emissions. No other particle defnitions are allowed, and none of the settings discussed in the 'Defining the hard process' section are relevant here.  Examples of allowed process definitions are CKKW-L Merging CKKW-L Merging Merging:Process = pp > Jinc,Winc meaning that W-bosons and partons are treated on equal footing (i.e. this is the setting applicable to the example used earlier). The merging will then include pure QCD multijet events, W+jets events, multi-W+jets events and pure multi-W events; CKKW-L Merging CKKW-L Merging Merging:Process = pp > Jinc,Zinc meaning that Z-bosons and partons are treated on equal footing; CKKW-L Merging CKKW-L Merging Merging:Process = pp > Jinc,Winc,Zinc meaning that W-bosons, Z-bosons and partons are treated on equal footing. CKKW-L Merging Setting the number of additional particles Since the EW merging probabilistically decides on the 'underlying process', it is a priori not possible to set the maximal number of additional emissions on top of this underlying process. A CKKW-L Merging p p &rarr; W jet jet state would e.g. contain two additional emissions if interpreted as correction to CKKW-L Merging p p &rarr; W , and only one additional emission if interpreted as correction to CKKW-L Merging p p &rarr; jet jet. Pythia 8 consequently decides dynamically how to set the additional number of emissions. CKKW-L Merging The maximal number of emissions, set by using the CKKW-L Merging Merging:nJetMax setting, still has to be defined to allow a sensible treatment of the 'highest-multiplicity' states. We thus redefine the meaning of CKKW-L Merging Merging:nJetMax to 'maximal possible number of emissions of any type'. As an example, CKKW-L Merging Merging:nJetMax = 3 if you want to perform a 'merging of mergins' containing states with up to three partons, or up to two partons and one W-boson, or up to one parton and two W-bosons, or up to three W-bosons. CKKW-L Merging CKKW-L Merging CKKW-L Merging CKKW-L Merging Further variables For more advanced manipulations of the merging machinery, all parameter  changes that were investigated in CKKW-L Merging Lon11 are supplied. Please  check CKKW-L Merging Lon11 for a detailed discussion of the switches. CKKW-L Merging These switches allow enthusiastic users to perform a systematic assessment of the merging prescription. Apart from this, we advise the non-expert user to keep the default values."},{"name":"Colour reconnection","link":"ColourReconnection.html","text":"Colour reconnection Colour reconnection Colour Reconnection The colour flows in the separate subprocesses defined in the multiparton-interactions scenario are tied together via the assignment of colour flow in the beam remnant. This is not an unambiguous procedure, and currently two different methods are implemented. In the first model the colour flow is reconstructed by how a PS could have constructed the configuration. In the second model, the full QCD colour calculation is taken into account, however the dynamical effects are modeled loosely, only an overall saturation is taken into account. The idea is to later account for other dynamical effects through colour reconnections. Colour reconnection A simple 'minimal' procedure of colour flow only via the beam remnants does not result in a scenario in agreement with data, however, notably not a sufficiently steep rise of Colour reconnection <pT>(n_ch). The true origin of this behaviour and the correct mechanism to reproduce it remains one of the big unsolved issues at the borderline between perturbative and nonperturbative QCD. Since no final answer is known, several models are implemented. The different models also rely on the two different colour assignments in the beam remnant. There are two, somewhat motivated, models implemented: the original PYTHIA scheme and a new scheme that tries to incorporate more of the colour knowledge from QCD. Colour reconnection The original PYTHIA scheme relies on the PS-like colour configuration of the beam remnant. This is combined with an additional step, wherein the gluons of a lower- Colour reconnection pT MPI system are merged with the ones in a higher-pT MPI. A more detailed description of the merging can be found below. Relative to the other models it tests fewer reconnection possibilities, and therefore tends to be reasonably fast. Colour reconnection The new scheme Colour reconnection Chr14a relies on the full QCD colour configuration in the beam remnant. This is followed up by a colour reconnection, where the potential string energy is minimized (ie. the Colour reconnection lambda measure is minimized). The QCD colour rules are also incorporated in the colour reconnection, and determine the probability that a reconnection is allowed. The model also allows the creation of junction structures. Colour reconnection In addition to the two models described above, a simple model is implemented, wherein gluons can be moved from one location to another so as to reduce the total string length. This is one out of a range of simple models developed to study potential colour reconnection effects e.g. on top mass Colour reconnection Arg14 , not from the point of view of having the most realistic description, but in order to probe the potential worst-case spread of predictions. All of these models are made available separately in Colour reconnection include/Pythia8Plugins/ColourReconnectionHooks.h , with the setup illustrated in Colour reconnection examples/main29.cc , but only the gluon-move one is sufficiently general and realistic that it has been included among the standard options here. Colour reconnection Finally, the SK I and SK II models Colour reconnection Sjo94 have a smaller range of applicability, originally intended for Colour reconnection e^+ e^- &rarr; W^+ W^- , but in this context offers a more detailed approach. They are not suitable for hadronic collisions, since they would only address CR inside a gauge boson pair, and not CR in the rest of the event. Colour reconnection The MPI-based scheme In this scheme partons are classified by which MPI system they belong to. The colour flow of two such systems can be fused, and if so the partons of the lower- Colour reconnection pT system are added to the strings defined by the higher- Colour reconnection pT system in such a way as to give the smallest total string length. The bulk of these lower- Colour reconnection pT partons are gluons, and this is what the scheme is optimized to handle. Colour reconnection In more detail, an MPI system with a scale Colour reconnection pT of the hard interaction (normally Colour reconnection 2 &rarr; 2 ) can be merged with one of a harder scale with a probability that is Colour reconnection pT0_Rec^2 / (pT0_Rec^2 + pT^2) , where Colour reconnection pT0_Rec is Colour reconnection range times Colour reconnection pT0 , the latter being the same energy-dependent dampening parameter as used for MPIs. Thus it is easy to merge a low- Colour reconnection pT system with any other, but difficult to merge two high- Colour reconnection pT ones with each other. Colour reconnection The reconnection procedure is applied iteratively. Thus first the reconnection probability Colour reconnection P = pT0_Rec^2 / (pT0_Rec^2 + pT^2) of the lowest- Colour reconnection pT system is found, and gives the probability for merger with the second-lowest one. If not merged, it is tested with the third-lowest one, and so on. For the Colour reconnection m 'th higher system the reconnection probability thus becomes Colour reconnection (1 - P)^(m-1) P. That is, there is no explicit dependence on the higher Colour reconnection pT scale, but implicitly there is via the survival probability of not already having been merged with a lower- Colour reconnection pT system. Also note that the total reconnection probability for the lowest- Colour reconnection pT system in an event with Colour reconnection n systems becomes Colour reconnection 1 - (1 - P)^(n-1). Once the fate of the lowest- Colour reconnection pT system has been decided, the second-lowest is considered with respect to the ones above it, then the third-lowest, and so on. Colour reconnection Once it has been decided which systems should be joined, the actual merging is carried out in the opposite direction. That is, first the hardest system is studied, and all colour dipoles in it are found (including to the beam remnants, as defined by the holes of the incoming partons). Next each softer system to be merged is studied in turn. Its gluons are, in decreasing Colour reconnection pT order, inserted on the colour dipole Colour reconnection i,j that gives the smallest Colour reconnection (p_g p_i)(p_g p_j)/(p_i p_j) , i.e. minimizes the 'disturbance' on the existing dipole, in terms of Colour reconnection pT^2 or Colour reconnection Lambda measure (string length). The insertion of the gluon means that the old dipole is replaced by two new ones. Also the (rather few) quark-antiquark pairs that can be traced back to a gluon splitting are treated in close analogy with the gluon case. Quark lines that attach directly to the beam remnants cannot be merged but are left behind. Colour reconnection The joining procedure can be viewed as a more sophisticated variant of the one introduced already in Colour reconnection Sjo87. Clearly it is ad hoc. It hopefully captures some elements of truth. The lower Colour reconnection pT scale a system has the larger its spatial extent and therefore the larger its overlap with other systems. It could be argued that one should classify individual initial-state partons by Colour reconnection pT rather than the system as a whole. However, for final-state radiation, a soft gluon radiated off a hard parton is actually produced at late times and therefore probably less likely to reconnect. In the balance, a classification by system Colour reconnection pT scale appears sensible as a first try. Colour reconnection Note that the reconnection is carried out before resonance decays are considered by default. Colour inside a resonance therefore is not reconnected. The Colour reconnection Colour reconnection PartonLevel:earlyResDec can be switched on to perform resonance decays before colour reconnection, and then the partons from resonance decays could be affected. Ideally the time scales of resonance decays and of colour reconnection should be picked dynamically, but this is not yet the case. Notably the Colour reconnection W , Colour reconnection Z and Colour reconnection t have intermediate decay time scales, somewhat but not much shorter than typical hadronization times, whereas the Colour reconnection H is much more long-lived. Colour reconnection The newer scheme The newer CR scheme builds on the minimization of the string length as well as the colour rules from QCD. A main feature of the new model is the introduction of junction structures. These are possible outcomes of the reconnection in addition to the more common string-string reconnections. The model works by constructing all pair of dipoles that are allowed to reconnect by QCD colour rules and switching if the new pair has a lower string length. Junctions are also allowed to be directly produced from three, and in some special cases, four dipoles. This is done iteratively until no further allowed reconnection lowers the total string length. Colour reconnection According to QCD colour rules, an uncorrelated triplet and anti-triplet are allowed to form a singlet state Colour reconnection 1/9 times. This is reflected in the model by giving each dipole a colour number between 0-8 and only dipoles with the same colour number are allowed to reconnect. The junction probability is given by the product of two triplets, which provides an anti-triplet Colour reconnection 1/3 times. This is achieved in the model by allowing reconnections between dipoles where modulo three of the color numbers agree. In addition to the colour rules, the dipoles also need to be causally connected in order to perform a reconnection. The definition of causally connected dipoles is not exact, and several different options are available. All the time dilation modes introduce a tuneable parameter, which provides a handle on the overall amount of colour reconnection. Colour reconnection When the two strings are allowed to reconnect, they will reconnect if it lowers the total string length. The total string length is in the model defined by an approximation to the Colour reconnection lambda -measure. Several options for different approximations are available. The Colour reconnection lambda -measure is not well understood, especially for junction structures, and a tuneable parameter is introduced to vary the behaviour between junctions and ordinary strings. Colour reconnection To avoid problems with very low mass string and junction structures, these are excluded from participating in the colour reconnections. This is achieved by forming the dipole or junction into a pseudo-particle if the invariant mass is too low. Especially the approximations made in the Colour reconnection lambda -measure provides problems at low invariant masses. Colour reconnection The new CR scheme introduce several tuneable parameters, which all are listed below. In addition to these, other parameters in PYTHIA also need to retuned to account for the new CR. The default values below, together with changing Colour reconnection MultipartonInteractions:pT0Ref = 2.15 and Colour reconnection ColourReconnection:allowDoubleJunRem = off , provides a good starting point. Additional fragmentation variables were also adjusted in the first tune, but these provide a smaller change (see Colour reconnection Chr14a for a complete list). Colour reconnection The gluon-move scheme This approach contains two steps, a first 'move' one and an optional second 'flip' one. Both are intended to reduce the total 'string length' Colour reconnection lambda measure of an event. For multiparton topologies the correct Colour reconnection lambda measure can become quite cumbersome, so here it is approximated by the sum of Colour reconnection lambda contributions from each pair of partons connected by a colour string piece. For two partons Colour reconnection i and Colour reconnection j with invariant mass Colour reconnection m_ij this contribution is defined as Colour reconnection lambda_ij = ln(1 + m^2_ij / m2Lambda). The 1 is added ad hoc to avoid problems in the Colour reconnection m_ij &rarr; 0 limit, problems which mainly comes from the approximate treatment, and Colour reconnection m2Lambda is a parameter set below. Colour reconnection In the move step all final gluons are identified, alternatively only a fraction Colour reconnection fracGluon of them, and also all colour-connected parton pairs. For each gluon and each pair it is calculated how the total Colour reconnection lambda would shift if the gluon would be removed from its current location and inserted in between the pair. The gluon move that gives the largest negative shift, if any, is then carried out. Alternatively, only shifts more negative than Colour reconnection dLambdaCut are considered. The procedure is iterated so long as allowed moves can be found. Colour reconnection There is some fine print. If a colour singlet subsystem consists of two gluons only then it is not allowed to move any of them, since that then would result in in a colour singlet gluon. Also, at most as many moves are made as there are gluons, which normally should be enough. A specific gluon may be moved more than once, however. Finally, a gluon directly connected to a junction cannot be moved, and also no gluon can be inserted between it and the junction. This is entirely for practical reasons, but should not be a problem, since junctions are rare in this model. Colour reconnection The gluon-move steps will not break the connection between string endpoints, in the sense that a quark and an antiquark that are colour-connected via a number of gluons will remain so, only the number and identity of the intermediate gluons may change. Such a scenario may be too restrictive. Therefore an optional second flip step is introduced. In it all such colour chains are identified, omitting closed gluon loops. The lambda change is defined by what happens if the two colour lines are crossed somewhere, e.g. such that two systems Colour reconnection q1 - g1 - qbar1 and Colour reconnection q2 - g2 - qbar2 are flipped to Colour reconnection q1 - g1 - g2 - qbar2 and Colour reconnection q2 - qbar1. The flip that gives the largest Colour reconnection lambda reduction is carried out, again with Colour reconnection dLambdaCut offering a possibility to restrict the options. As with the move step, the procedure is repeated so long as it is allowed. An important restriction is imposed, however, that a given system is only allowed to flip once, and not with itself. The practical reason is that repeated flips could split off closed gluon loops quite easily, which tends to result in bad agreement with data. Colour reconnection As an option, singlet subsystems containing a junction may or may not be allowed to take part in the flip step. Since the number of junction systems is limited in this model the differences are not so important. Colour reconnection The Colour reconnection e^+ e^- colour reconnection schemes The SK I and SK II models Colour reconnection Sjo94 were specifically developed for Colour reconnection e^+ e^- &rarr; W^+ W^- &rarr; q_1 qbar_2 q_3 qbar_4 at LEP 2, and equally well works for Colour reconnection e^+ e^- &rarr; gamma^*/Z^0 gamma^*/Z^0. They are not intended to handle hadronic collisions, except in special contexts. The prime of these is Higgs decays of the same character as above, Colour reconnection H^0 &rarr;  W^+ W^- / Z^0 Z^0 , since the Higgs is sufficiently long-lived that its decay products can be considered separately from the rest of the event. The administrative machinery for this possibility is not yet in place, however. Colour reconnection The labels I and II refer to the colour-confinement strings being modelled either by analogy with type I or type II superconductors. In the former model the strings are viewed as transversely extended 'bags'. The likelihood of reconnection is then related to the integrated space-time overlap of string pieces from the Colour reconnection W^+ with those from the Colour reconnection W^-. In the latter model instead strings are assumed to be analogous with vortex lines, where all the topological information is stored in a thin core region. Reconnection therefore only can occur when these cores pass through each other. Colour reconnection Both of these models are based on a detailed modelling of the space-time separation of the Colour reconnection W^+ and Colour reconnection W^- decay vertices, on the subsequent shower evolution, on the continued space-time evolution of all the string pieces stretched between the showered partons, and on the cutoff provided by the strings disappearing by the hadronization process. As such, they are more sophisticated than any other reconnection models. Unfortunately they would not easily carry over to hadronic collisions, where both the initial and the final states are far more complicated, and the space-time details less well controlled. Colour reconnection The SK II model has few free parameters, giving more predictive power. Conversely, SK I has a a free overall CR strength parameter, making it more convenient for tunes to data. The LEP collaborations have used SK I as a common reference to establish the existence of CR in Colour reconnection W^+ W^- events."},{"name":"Compositeness Processes","link":"CompositenessProcesses.html","text":"Compositeness Processes Compositeness Processes Compositeness Processes Compositeness scenarios may give rise to sharp resonances of excited quarks and leptons. An excited copy of the first generation is implemented, consisting of spin 1/2 particles. The possibility of contact interactions between SM fermions is also implemented in the context of Compositeness Processes 2 &rarr; 2 quark or fermion-lepton scattering. Compositeness Processes Related to excited fermions, the current implementation contains gauge interaction production by quark-gluon fusion or lepton-photon fusion and contact interaction production by quark-quark or quark-antiquark scattering. For both the Compositeness Processes 2 &rarr; 1 and Compositeness Processes 2 &rarr; 2 processes a non-trivial angular dependence is included in the decay, however, only decays into gauge bosons are supported, i.e. not decays through contact interactions. In additions to the compositeness scale and couplings listed below, you are expected to change the excited-fermion masses in accordance with what is desired. See Compositeness Processes Bau90 for conventions. Compositeness Processes The contact interactions are implemented according to Compositeness Processes Eic83. The processes include the SM contributions as well as interference. For this reason the processes below converge toward the SM equivalents when the contact interaction contributions are close to zero, e.g. Compositeness Processes HardQCD:qq2qq and Compositeness Processes HardQCD:qqbar2qqbarNew in the case of quark scattering. Compositeness Processes It should also be noted that the Compositeness Processes gamma*/Z/Z' production process available with Compositeness Processes NewGaugeBoson:ffbar2gmZZprime is prepared for pair-production of excited quarks and leptons, assuming the same gauge couplings as for the non-excited fermions. What is missing is the actual decay channels in the list of Compositeness Processes Z' decay modes, which have to be added by hand, e.g. by Compositeness Processes 32:addChannel = 1 1. 100 4000001 -4000001 Compositeness Processes You can use Compositeness Processes Zprime:gmZmode to decide which gauge boson propagators actually are included in the simulation, and thus e.g. switch off the Compositeness Processes Z' part of the propagator. You may also want to switch off other decay channels and set the minimal mass to be at the threshold for the studied pair production (or suitably below it, if the excited fermions have a non-negligible width). Compositeness Processes Excited fermions, production processes A few different production processes have been implemented, which normally would not overlap and therefore could be run together. Compositeness Processes Excited fermions, parameters The basic couplings of the model are Compositeness Processes Contact interactions, production processes The processes including contact interactions are Compositeness Processes Contact interactions, parameters"},{"name":"Couplings and Scales","link":"CouplingsAndScales.html","text":"Couplings and Scales Couplings and Scales Couplings and Scales Here is collected some possibilities to modify the scale choices of couplings and parton densities for all internally implemented hard processes. This is based on them all being derived from the Couplings and Scales SigmaProcess base class. The matrix-element coding is also used by the multiparton-interactions machinery, but there with a separate choice of Couplings and Scales alpha_strong(M_Z^2) value and running, and separate PDF scale choices. Also, in Couplings and Scales 2 &rarr; 2 and Couplings and Scales 2 &rarr; 3 processes where resonances are produced, their couplings and thereby their Breit-Wigner shapes are always evaluated with the resonance mass as scale, irrespective of the choices below. Couplings and Scales We stress that couplings and scales are set separately from the values on this page for Couplings and Scales multiparton interactions , Couplings and Scales timelike showers , and Couplings and Scales spacelike showers. This allows a bigger flexibility, but also requires a bit more work e.g. if you insist on using the same Couplings and Scales alpha_s everywhere. Couplings and Scales Couplings and K factor The size of QCD cross sections is mainly determined by Couplings and Scales The actual value is then regulated by the running to the Couplings and Scales Q^2 renormalization scale, at which Couplings and Scales alpha_strong is evaluated Couplings and Scales QED interactions are regulated by the Couplings and Scales alpha_electromagnetic value at the Couplings and Scales Q^2 renormalization scale of an interaction. Couplings and Scales In addition there is the possibility of a global rescaling of cross sections (which could not easily be accommodated by a changed Couplings and Scales alpha_strong , since Couplings and Scales alpha_strong runs) Couplings and Scales Renormalization scales The Couplings and Scales Q^2 renormalization scale can be chosen among a few different alternatives, separately for Couplings and Scales 2 &rarr; 1 , Couplings and Scales 2 &rarr; 2 and two different kinds of Couplings and Scales 2 &rarr; 3 processes. In addition a common multiplicative factor may be imposed. Couplings and Scales Factorization scales Corresponding options exist for the Couplings and Scales Q^2 factorization scale used as argument in PDF's. Again there is a choice of form for Couplings and Scales 2 &rarr; 1 , Couplings and Scales 2 &rarr; 2 and Couplings and Scales 2 &rarr; 3 processes separately. For simplicity we have let the numbering of options agree, for each event class separately, between normalization and factorization scales, and the description has therefore been slightly shortened. The default values are Couplings and Scales not necessarily the same, however."},{"name":"Dark Matter Processes","link":"DarkMatterProcesses.html","text":"Dark Matter Processes Dark Matter Processes Dark Matter Processes This page contains the production of Dirac fermion Dark Matter via new Dark Matter Processes s -channel mediators. A summary of the physics scenarios and parameters involved can be found in Dark Matter Processes Des18. Examples how these processes can be run are found in Dark Matter Processes main75.cc and Dark Matter Processes main76.cc. Dark Matter Processes The particles in the scenarios considered here are a mix of established PDG ones (51 - 55) and extensions thereof ( 56 - 59), as follows: Dark Matter Processes Dark Matter Processes Dark Matter Processes 51 Dark Matter Processes Scalar DM (currently unused); Dark Matter Processes Dark Matter Processes 52 Dark Matter Processes Fermionic DM ( Dark Matter Processes chi_1 ); Dark Matter Processes Dark Matter Processes 53 Dark Matter Processes Vector DM (currently unused); Dark Matter Processes Dark Matter Processes 54 Dark Matter Processes Scalar (or pseudoscalar) mediator ( Dark Matter Processes S ); Dark Matter Processes Dark Matter Processes 55 Dark Matter Processes Vector (or axial vector) mediator ( Dark Matter Processes Z' ); Dark Matter Processes Dark Matter Processes 56 Dark Matter Processes Charged scalar partner ( Dark Matter Processes l^~ ); Dark Matter Processes Dark Matter Processes 57 Dark Matter Processes Singly charged partner ( Dark Matter Processes chi^+ ); Dark Matter Processes Dark Matter Processes 58 Dark Matter Processes Neutral partner ( Dark Matter Processes chi_2 ); Dark Matter Processes Dark Matter Processes 59 Dark Matter Processes Doubly charged partner ( Dark Matter Processes chi^++ ). Dark Matter Processes Scalar Mediator Dark Matter Processes Fermion couplings to scalar S are assumed to be proportional to mass of the fermion and couplings are the factor multiplying SM Higgs coupling (i.e. sin(mixing) in case of portal models). Dark Matter Processes Vector Mediator Dark Matter Processes Z' The Vector mediator model assumes a simplified U(1) model with couplings to fermionic Dark Matter.  Both vector and axial couplings are possible.  Interference with Dark Matter Processes gamma/Z is currently not implemented, therefore this should mainly be used when Dark Matter Processes Z' &rarr; X Xbar.  However, a quick check of dijet or dilepton cross sections can be made by setting the mode Dark Matter Processes Zp:decayMode. Dark Matter Processes The vector and axial couplings of fermionic DM to the Dark Matter Processes Z'^0 can be set freely. The couplings of quarks and leptons can either be chosen freely for a new Dark Matter Processes U(1) or be given by kinetic mixing with the SM Dark Matter Processes U(1)_Y. The SM fermion couplings are assumed to be universal, i.e. generation-independent. The choice of fixed axial and vector couplings implies a resonance width that increases linearly with the Dark Matter Processes Z' mass. Also some overall coupling strengths can be chosen freely. Dark Matter Processes Drell-Yan production of charged co-annihilation partners We implement two models of co-annihilating Dark Matter where the co-annihilation partner carries EW charge and therefore can be produced via Drell-Yan production.  The underlying model and production process can be selected by choosing the parameter Dark Matter Processes DM:DYtype. Dark Matter Processes The first model consists of co-annihilation with a scalar with leptonic quantum numbers and which couples to a right-handed SM lepton and a Dirac fermion Dark Matter via Yukawa couplings.  It is possible to choose lepton flavour violating couplings. Dark Matter Processes The next model is a generalisation of the mixed gaugino sector of Supersymmetry parametrised by one SM singlet and one SU(2) N-plet which mix to form Dark matter.  N = 2, 3 and 5 are supported by the code.  The main motivation for this choice is to provide a fully flexible implementation to calculate production of long-lived particles at the LHC.  The resultant spectrum consists of one neutral partner, one singly charged partner, and one doubly charged partner (in the case of the 5-plet).  The only free parameters are masses of the singlet and N-plet and the mixing suppression scale. This determines both production and decay of the particles and can cover a range of signatures including displaced leptons and vertices, long-lived, kinked or disappearing tracks. Dark Matter Processes The Yukawa couplings can be set using Dark Matter Processes The parameters for the singlet-N-plet model can be set via the following:"},{"name":"Deuteron Production","link":"DeuteronProduction.html","text":"Deuteron Production Deuteron Production Deuteron Production After the final state particles of an event are produced, protons and neutrons are selected and combined into pairs which may form deuterons. A generalized version of the model in Deuteron Production Dal15 is implemented here. The cross-sections used to determine if a combination binds into a deuteron are differential in Deuteron Production k &equiv; |p Deuteron Production 1 - p Deuteron Production 2 | where Deuteron Production p Deuteron Production i are the momenta of the binding combination in the center-of-mass frame of the combination. Here all notation is used to specify deuteron production, but anti-deuteron production is also provided where the anti-particles for all relevant particles are used. Deuteron Production To ensure conservation of momentum and energy, the final state for each deuteron production channel is required to have at least two final products, where one product is a deuteron. This is in contrast to the traditional coalescence model of Deuteron Production Scd63 and Deuteron Production Kap80 where typically only a deuteron is produced from a two-body initial state and so momentum and energy are not conserved. Here, a modified coalescence model can be used where the final state can be specified as a deuteron and a photon. Deuteron Production The default deuteron production setup is taken from Deuteron Production Dal15 , where 8 production channels are defined: Deuteron Production Deuteron Production Deuteron Production p+ n0 &rarr; gamma 2H Deuteron Production Deuteron Production p+ n0 &rarr; pi0 2H Deuteron Production Deuteron Production p+ n0 &rarr; pi0 pi0 2H Deuteron Production Deuteron Production p+ n0 &rarr; pi+ pi- 2H Deuteron Production Deuteron Production p+ p+ &rarr; pi+ 2H Deuteron Production Deuteron Production p+ p+ &rarr; pi+ pi0 2H Deuteron Production Deuteron Production n0 n0 &rarr; pi- 2H Deuteron Production Deuteron Production n0 n0 &rarr; pi- pi0 2H These channels, and the models used to calculate their differential cross-sections, can be fully specified by the user as detailed below. The Deuteron Production DeuteronProduction class performs the deuteron production, first building all valid two-particle combinations, then determining whether the combinations bind, and finally performing an isotropic decay of the bound state into the specified final state. Deuteron Production Main parameters Assuming you have set Deuteron Production HadronLevel:DeuteronProduction = on , you can regulate the detailed behaviour with the following settings. Deuteron Production Deuteron Production Warning : changed Deuteron Production mvec and Deuteron Production wvec values must be provided as a comma-separated list enclosed in braces, Deuteron Production {...}. Deuteron Production Technical parameters The maximum cross-section for each deuteron production channel is calculated using an initial grid search followed by the simplex algorithm. Assuming parameters similar to the default parameters above are used, the following technical parameters should not need to be changed. However, if the maximum finding fails for a given configuration, the following can be modified to ensure appropriate determination of the cross-section maximums."},{"name":"Diffraction","link":"Diffraction.html","text":"Diffraction Diffraction Diffraction Diffraction is not well understood, and several alternative approaches have been proposed, both for the cross section of diffractive events and for the particle production in these. For the latter we here follow a fairly conventional Pomeron-based one, in the Ingelman-Schlein spirit Diffraction Ing85 , but integrated to make full use of the standard PYTHIA machinery for multiparton interactions, parton showers and hadronization Diffraction Nav10,Cor10a. This is the approach pioneered in the PomPyt program by Ingelman and collaborators Diffraction Ing97. Diffraction For ease of use (and of modelling), the Pomeron-specific parts of the generation of inclusive ('soft') diffractive events are subdivided into three sets of parameters that are rather independent of each other: Diffraction (i) the total, elastic and diffractive cross sections are parametrized as functions of the CM energy, or can be set by the user to the desired values, see the Diffraction Total Cross Sections page; Diffraction (ii) once it has been decided to have a diffractive process, a Pomeron flux parametrization is used to pick the mass of the diffractive system(s) and the Diffraction t of the exchanged Pomeron, also here see the Diffraction Total Cross Sections page; Diffraction (iii) a diffractive system of a given mass is classified either as low-mass unresolved, which gives a simple low- Diffraction pT string topology, or as high-mass resolved, for which the full machinery of multiparton interactions and parton showers are applied, making use of Diffraction Pomeron PDFs. Diffraction The parameters related to multiparton interactions, parton showers and hadronization are kept the same as for normal nondiffractive events, with only a few exceptions. This may be questioned, especially for the multiparton interactions, but we do not believe that there are currently enough good diffractive data that would allow detailed separate tunes. Diffraction The above subdivision may not represent the way 'physics comes about'. For instance, the total diffractive cross section can be viewed as a convolution of a Pomeron flux with a Pomeron-proton total cross section. Since neither of the two is known from first principles there will be a significant amount of ambiguity in the flux factor. The picture is further complicated by the fact that the possibility of simultaneous further multiparton interactions ('cut Pomerons') will screen the rate of diffractive systems. In the end, our set of parameters refers to the effective description that emerges out of these effects, rather than to the underlying 'bare' parameters. Diffraction In the event record the diffractive system in the case of an excited proton is denoted Diffraction p_diffr , code 9902210, whereas a central diffractive system is denoted Diffraction rho_diffr , code 9900110. Apart from representing the correct charge and baryon numbers, no deeper meaning should be attributed to the names. Diffraction PYTHIA also includes a possibility to select hard diffraction. This machinery relies on the same sets of parameters as described above, for the Pomeron flux and PDFs. The main difference between the hard and the soft diffractive frameworks is that the user can select any PYTHIA hard process in the former case, e.g. diffractive Diffraction Z 's or Diffraction W 's, whereas only QCD processes are generated in the latter. These QCD processes are generated inclusively, which means that mostly they occur in the low- Diffraction pT region, even if a tail stretches to higher Diffraction pT scales, thus overlapping with hard diffraction. Both hard and soft diffractive processes also include the normal PYTHIA machinery, such as MPIs and showers, but for the former the MPI framework can additionally be used to determine whether a hard process survives as a diffractive event or not. The different diffractive types - low mass soft, high mass soft and hard diffraction - are described in more detail below. Diffraction Separation of soft diffraction into low and high masses Preferably one would want to have a perturbative picture of the dynamics of Pomeron-proton collisions, like multiparton interactions provide for proton-proton ones. However, while PYTHIA by default will only allow collisions with a CM energy above 10 GeV, the mass spectrum of diffractive systems will stretch to down to the order of 1.2 GeV. It would not be feasible to attempt a perturbative description there. Therefore we do offer a simpler low-mass description, with only longitudinally stretched strings, with a gradual switch-over to the perturbative picture for higher masses. The probability for the latter picture is parametrized as Diffraction P_pert = P_max ( 1 - exp( (m_diffr - m_min) / m_width ) ) which vanishes for the diffractive system mass Diffraction m_diffr < m_min , and is Diffraction 1 - 1/e = 0.632 for Diffraction m_diffr = m_min + m_width , assuming Diffraction P_max = 1. Diffraction Low-mass soft diffraction When an incoming hadron beam is diffractively excited, it is modeled as if either a valence quark or a gluon is kicked out from the hadron. In the former case this produces a simple string to the leftover remnant, in the latter it gives a hairpin arrangement where a string is stretched from one quark in the remnant, via the gluon, back to the rest of the remnant. The latter ought to dominate at higher mass of the diffractive system. Therefore an approximate behaviour like Diffraction P_q / P_g = N / m^p is assumed. Diffraction When a gluon is kicked out from the hadron, the longitudinal momentum sharing between the the two remnant partons is determined by the same parameters as above. It is plausible that the primordial Diffraction kT may be lower than in perturbative processes, however: Diffraction High-mass soft diffraction The perturbative description need to use parton densities of the Pomeron. The options are described in the page on Diffraction PDF Selection. The standard perturbative multiparton interactions framework then provides cross sections for parton-parton interactions. In order to turn these cross section into probabilities one also needs an ansatz for the Pomeron-proton total cross section. In the literature one often finds low numbers for this, of the order of 2 mb. These, if taken at face value, would give way too much activity per event. There are ways to tame this, e.g. by a larger Diffraction pT0 than in the normal pp framework. Actually, there are many reasons to use a completely different set of parameters for MPI in diffraction than in pp collisions, especially with respect to the impact-parameter picture, see below. A lower number in some frameworks could alternatively be regarded as a consequence of screening, with a larger 'bare' number. Diffraction For now, however, an attempt at the most general solution would carry too far, and instead we patch up the problem by using a larger Pomeron-proton total cross section, such that average activity makes more sense. This should be viewed as the main tunable parameter in the description of high-mass diffraction. It is to be fitted to diffractive event-shape data such as the average charged multiplicity. It would be very closely tied to the choice of Pomeron PDF; we remind that some of these add up to less than unit momentum sum in the Pomeron, a choice that also affect the value one ends up with. Furthermore, like with hadronic cross sections, it is quite plausible that the Pomeron-proton cross section increases with energy, so we have allowed for a power-like dependence on the diffractive mass. Diffraction Also note that, even for a fixed CM energy of events, the diffractive subsystem will range from the abovementioned threshold mass Diffraction m_min to the full CM energy, with a variation of parameters such as Diffraction pT0 along this mass range. Therefore multiparton interactions are initialized for a few different diffractive masses, currently five, and all relevant parameters are interpolated between them to obtain the behaviour at a specific diffractive mass. Furthermore, Diffraction A B &rarr; X B and Diffraction A B &rarr; A X are initialized separately, to allow for different beams or PDF's on the two sides. These two aspects mean that initialization of MPI is appreciably slower when perturbative high-mass diffraction is allowed. Diffraction Diffraction tends to be peripheral, i.e. occur at intermediate impact parameter for the two protons. That aspect is implicit in the selection of diffractive cross section. For the simulation of the Pomeron-proton subcollision it is the impact-parameter distribution of that particular subsystem that should rather be modeled. That is, it also involves the transverse coordinate space of a Pomeron wavefunction. The outcome of the convolution therefore could be a different shape than for nondiffractive events. For simplicity we allow the same kind of options as for nondiffractive events, except that the Diffraction bProfile = 4 option for now is not implemented. Diffraction Hard diffraction When PYTHIA is requested to generate a hard process, by default it is assumed that the full perturbative cross section is associated with nondiffractive topologies. With the options in this section, PYTHIA includes a possibility for creating a perturbative process diffractively, however. This framework is denoted hard diffraction to distiguish it from soft diffraction, but recall that the latter contains a tail of high- Diffraction pT processes that could alternatively be obtained as hard diffraction. The idea behind hard diffraction is similar to soft diffraction, as they are both based on the Pomeron model. The proton is thus modelled as having a Pomeron component, described by the Pomeron fluxes switch Diffraction SigmaDiffractive:PomFlux , see Diffraction here , and the partonic content of the Pomeron is described by the Pomeron PDFs, see Diffraction here. From these components we can evaluate the probability for the chosen hard process to have been coming from a diffractively excited system, based on the ratio of the Pomeron flux convoluted with Pomeron PDF to the inclusive proton PDF. Diffraction If the hard process is likely to have been created inside a diffractively excited system, then we also evaluate the momentum fraction carried by the Pomeron, Diffraction x_Pomeron , and the momentum transfer, Diffraction t , in the process. This information can also be extracted in the main programs, see eg. example Diffraction main61.cc. Diffraction Further, we distiguish between two alternative scenarios for the classification of hard diffraction. The first is based solely on the Pomeron flux and PDF, as described above. In the second an additional requirement is imposed, wherein the MPI machinery is not allowed to generate any extra MPIs at all, since presumably these would destroy the rapidity gap and thereby the diffractive nature. We refer to the former as MPI-unchecked and the latter as MPI-checked hard diffraction. The MPI-checked option is likely to be the more realistic one, but the MPI-unchecked one offers a convenient baseline for the study of MPI effects, which still are poorly understood. Diffraction Recently, a scenario for hard diffraction with Diffraction gamma beams has been introduced. Thus hard diffraction can be evaluated for both Diffraction gamma + gamma and Diffraction gamma + p processes within the usual photoproduction framework. A Pomeron can be taken from a Diffraction gamma beam only if the photon is resolved. Currently this photon is then assumed always to be in a virtual Diffraction rho state, thus leaving behind a physical Diffraction rho beam remnant. If the Pomeron is taken from the proton, in the Diffraction gamma + parton framework, the photon is allowed to interact with the Pomeron with both its resolved and unresolved components. If the Pomeron is taken from the resolved Diffraction gamma , the proton Pomeron flux is used but rescaled by a factor of Diffraction sigma_tot^gamma+p/sigma_tot^pp , as a very first approximation to this unmeasured distribution. Otherwise all options are available as for hard diffraction in Diffraction pp processes, and all limitations and cautions apply as for the photoproduction framework. Diffraction For the selected hard processes, the user can choose whether to generate the inclusive sample of both diffractive and nondiffractive topologies or diffractive only, and in each case with the diffractive ones distinguished either MPI-unchecked or MPI-checked. Diffraction There is also the possibility to select only a specific subset of events in hard diffraction. Diffraction The Pomeron PDFs have not been scaled to unit momentum sum by the H1 Collaboration, but instead they let the PDF normalization float after the flux had been normalized to unity at Diffraction x_Pom=0.03. This means that the H1 Pomeron has a momentum sum that is about a half. It could be brought to unit momentum sum by picking the parameter Diffraction PDF:PomRescale to be around 2. In order not to change the convolution of the flux and the PDFs, the flux then needs to be rescaled by the inverse. This introduces a new rescaling parameter: Diffraction When using the MBR flux, the model requires a renormalization of the Pomeron flux. This suppresses the flux with approximately a factor of ten, thus making it incompatible with the MPI suppression of the hard diffraction framework. We have thus implemented an option to renormalize the flux. If you wish to use the renormalized flux of the MBR model, you must generate the MPI-unchecked samples, otherwise diffractive events will be suppressed twice. Diffraction The transverse matter profile of the Pomeron, relative to that of the proton, is not known. Generally a Pomeron is supposed to be a smaller object in a localized part of the proton, but one should keep an open mind. Therefore below you find three extreme scenarios, which can be compared to gauge the impact of this uncertainty."},{"name":"Dire Expert Settings","link":"DireExpert.html","text":"Dire Expert Settings Dire Expert Settings Dire Expert Settings One purpose of Dire is to have a numerical tool that can be compared to analytic resummation techniques as well as possible. Thus, some settings are available to facilitate theory comparisons. In an experimental production run, these paramaters should not be changed from their default values. Dire Expert Settings Further QCD and QED photon shower settings Dire Expert Settings Further dark photon shower settings Dark photon emissions/splittings in Dire can be enabled with the following switches. It is worth noting that dark-photon radiation is handled very similar to QED/QCD radiation. Dire Expert Settings Dark photon emission rates are govered by several parameters. Dire Expert Settings Matching and merging settings Dire offers some functionality for matrix-element + parton shower merging. The currently most advanced of the available schemes are iterated matrix element corrections in the 'MOPS' scheme. The details of the scheme are goverened by the following settings. Dire Expert Settings Other experimental merging settings Dire Expert Settings The following settings are currently under investigation and not used in the code. Dire Expert Settings Color factors The expert user may also want to change the color factors used by QCD showering. This can be done using the settings Dire Expert Settings Configurable timelike splitting kernels For in-depth theory comparisons, changed splitting kernels can be necessary. Thus, the user can customize the  soft, collinear and finite behavior of timelike splitting probabilities to a large extent by changing the coefficients of mock-up series expansions and by exponential factors. A publication discussing these options is in preparation. Dire Expert Settings Please find below all changeable coefficients."},{"name":"DIRE Parton Showers","link":"DireShowers.html","text":"DIRE Parton Showers DIRE Parton Showers Dire Parton Showers The Dire parton shower combines dipole-shower ideas in the spirit of Ariadne with the careful handling of collinear enhancements in classical parton showers. It includes a detailed treatment of mass effects and various higher-order corrections. The Dire parton shower is developed jointly in Pythia and Sherpa to allow maximal validation. The Dire physics publication is arxiv:1506.05057 [hep-ph]. Please cite this article (and of course the Pythia 8 reference) if you use Pythia 8 + Dire for your research.  Dire is a complete replacement for the default showers in Pythia, and is automatically interleaved with Pythia's multiple interaction model. At present, Dire offers DIRE Parton Showers DIRE Parton Showers QCD and QED showers with automatic uncertainties and the possiblity to enhance individual splittings. DIRE Parton Showers Inclusive next-to-leading order DGLAP corrections to the shower evolution. DIRE Parton Showers Next-to-leading order final-state showering for lepton colliders. DIRE Parton Showers Iterated Matrix-Element corrections for splittings within the parton-shower phase space. Built-in CKKW-L and UNLOPS merging are in preparation.  It is worth noting that Dire is constructed as as weighted parton shower, meaning that all events that are produced with Dire acquire a weight close to, but not identical to, unity. These weights need to be included when filling histograms or storing events. These weights can, conveniently combined with other weights (due to weighted LHEF inputs, merging etc.), be retrieved from DIRE Parton Showers pythia.info.weight(). DIRE Parton Showers The following discusses some basic settings that might be of interest. Some convenience features are discussed DIRE Parton Showers here , while expert features (mainly aimed at comparisons of Dire to analytic calculations) are documented DIRE Parton Showers here. DIRE Parton Showers Settings related to the evaluation of running (QCD) couplings DIRE Parton Showers Settings to perform variations to gauge shower uncertainties DIRE Parton Showers The following settings are currently under investigation and not used in the code. DIRE Parton Showers Settings related to parton distribution functions and quark masses DIRE Parton Showers Settings related to the tune of Pythia 8 + Dire DIRE Parton Showers Settings for debugging or educational purposes"},{"name":"Dire Splitting Enhancements","link":"DireWeights.html","text":"Dire Splitting Enhancements Dire Splitting Enhancements Dire Splitting Enhancements The Dire parton shower allows to weight individual splittings to allow efficient isolation and study of their impact. This can e.g. be used to increase the rate of a single splitting, and/or decrease the rate of others, thus e.g. allowing to study rare splittings. It should be noted that this can make some splittings much more frequent, at the expense of a new event weight, whose fluctuations might require larger event samples. Dire Splitting Enhancements Nevertheless, sometimes enhancements can be useful. Dire offers the option to enhance each available splitting kernel separately. For brevity, we here only describe auxiliary parameters, then one enhancement factor, and then just list all other corresponding keywords. Dire Splitting Enhancements QCD splittings Dire Splitting Enhancements QED splittings Dire Splitting Enhancements Electroweak splittings At present, electroweak evolution is under development, so that these settings should not be touched for production for now. Dire Splitting Enhancements Dark U(1) splittings At present, dark photon evolution is under development, so that these settings should not be touched for production for now."},{"name":"Electroweak Processes","link":"ElectroweakProcesses.html","text":"Electroweak Processes Electroweak Processes Electroweak Processes This page contains processes involving Prompt-photon, Electroweak Processes gamma^*/Z^0 and Electroweak Processes W^+- production, plus a few with Electroweak Processes t -channel boson exchange. Electroweak Processes Prompt photon processes This group collects the processes where one or two photons are produced by the hard process. Additional sources of photons include parton showers and hadron decays. A Electroweak Processes pT cut is required to stay away from the unphysical low- Electroweak Processes pT region. An eikonalized description, intended to be valid at all Electroweak Processes pT , is included as part of the multiparton-interactions framework. Electroweak Processes Weak boson processes Under this heading we group processes involving the production of a single electroweak gauge boson, i.e. a Electroweak Processes gamma^*/Z^0 or a Electroweak Processes W^+- , or a pair of them, or one of them in combination with a parton. Since the three sets are partly conflicting, each is associated with its own group flag. In addition, Electroweak Processes t -channel exchange of such a boson between two fermions form a separate group. Electroweak Processes Note that the Electroweak Processes Z^0 and Electroweak Processes W^+- decay modes generated with the processes below only include those Standard-Model ones that are allowed for on-shell decays. Thus several other processes that receive contributions from off-shell resonances are listed separately, e.g. for Electroweak Processes top or Electroweak Processes fourth generation fermions. Electroweak Processes There is one flag that can be used to influence the Electroweak Processes gamma^*/Z^0 structure in all the processes below where it is produced, unless otherwise stated. Electroweak Processes Boson exchange The two processes in this subgroup encode the standard Deeply Inelastic Scattering (DIS) of lepton-hadron collisions. In the latter context, it is useful to recall that the traditional Electroweak Processes Q^2 facorization and renormalization scales need be set explicitly by Electroweak Processes SigmaProcess:factorScale2 = 6 and Electroweak Processes SigmaProcess:renormScale2 = 6. The special phase space cut Electroweak Processes PhaseSpace:Q2Min may be more convenient than the traditional Electroweak Processes pT cut; to cover the phase space edges it may also be relevant to reduce Electroweak Processes PhaseSpace:pTHatMinDiverge. Electroweak Processes The processes are also included as part of the multiparton-interactions framework in hadron-hadron collisions. Electroweak Processes Single boson Electroweak Processes Boson pair Note that, in the decay of the two vector bosons produced by an Electroweak Processes f fbar &rarr; V V process, the full four-fermion correlations from the leading-order Electroweak Processes f fbar &rarr; V V &rarr; 4f matrix elements are included Electroweak Processes Gun86 (with some extensions by the authors). The matrix elements are provided in the double-resonant approach, i.e. excludes graph like Electroweak Processes f fbar &rarr; V &rarr; f fbar &rarr; f fbar V &rarr; 4f. Electroweak Processes Boson and parton Electroweak Processes Photon Collision Processes A few electroweak two-photon production processes are available. To use them, photon PDFs have to be defined for the incoming beam particles. This is the case for the internal NNPDF 2.3 QCD+QED sets, as well as some further ones available in the LHAPDF library, but not for all PDFs. Electroweak Processes Photon-Parton Processes Electroweak Processes Photon-parton production processes. See comment related to PDFs above. Also relevant for direct-resolved processes in photon-photon collisions. Two instances of a given process are created when mixing processes where the direct photon can come from either side. In this case the process code in the parentheses is used when the direct photon is from side A."},{"name":"Error Checks","link":"ErrorChecks.html","text":"Error Checks Error Checks Error Checks There is a few settings related to error checking during program execution. Many other checks are performed as well, but do not have any specific setting related to themselves."},{"name":"Event Analysis","link":"EventAnalysis.html","text":"Event Analysis Event Analysis Event Analysis Event Analysis Introduction The routines in this section are intended to be used to analyze event properties. As such they are not part of the main event generation chain, but can be used in comparisons between Monte Carlo events and real data. They are rather free-standing, but assume that input is provided in the PYTHIA 8 Event Analysis Event format, and use a few basic facilities such as four-vectors. Their ordering is mainly by history; for current LHC applications the final one, Event Analysis SlowJet , is of special interest. Event Analysis In addition to the methods presented here, there is also the possibility to make use of Event Analysis external jet finders. Event Analysis Sphericity The standard sphericity tensor is Event Analysis S^{ab} = (sum_i p_i^a p_i^b) / (sum_i p_i^2) where the Event Analysis sum i runs over the particles in the event, Event Analysis a, b = x, y, z, and Event Analysis p without such an index is the absolute size of the three-momentum. This tensor can be diagonalized to find eigenvalues and eigenvectors. Event Analysis The above tensor can be generalized by introducing a power Event Analysis r , such that Event Analysis S^{ab} = (sum_i p_i^a p_i^b p_i^{r-2}) / (sum_i p_i^r) In particular, Event Analysis r = 1 gives a linear dependence on momenta and thus a collinear safe definition, unlike sphericity. Event Analysis To do sphericity analyses you have to set up a Event Analysis Sphericity instance, and then feed in events to it, one at a time. The results for the latest event are available as output from a few methods. Event Analysis After the analysis has been performed, a few methods are available to return the result of the analysis of the latest event: Event Analysis There is also one method that returns information accumulated for all the events analyzed so far. Event Analysis Thrust Thrust is obtained by varying the thrust axis so that the longitudinal momentum component projected onto it is maximized, and thrust itself is then defined as the sum of absolute longitudinal momenta divided by the sum of absolute momenta. The major axis is found correspondingly in the plane transverse to thrust, and the minor one is then defined to be transverse to both. Oblateness is the difference between the major and the minor values. Event Analysis The calculation of thrust is more computer-time-intensive than e.g. linear sphericity, introduced above, and has no specific advantages except historical precedent. In the PYTHIA 6 implementation the search was sped up at the price of then not being guaranteed to hit the absolute maximum. The current implementation studies all possibilities, but at the price of being slower, with time consumption for an event with Event Analysis n particles growing like Event Analysis n^3. Event Analysis To do thrust analyses you have to set up a Event Analysis Thrust instance, and then feed in events to it, one at a time. The results for the latest event are available as output from a few methods. Event Analysis After the analysis has been performed, a few methods are available to return the result of the analysis of the latest event: Event Analysis There is also one method that returns information accumulated for all the events analyzed so far. Event Analysis ClusterJet Event Analysis ClusterJet (a.k.a. Event Analysis LUCLUS and Event Analysis PYCLUS ) is a clustering algorithm of the type used for analyses of Event Analysis e^+e^- events, see the PYTHIA 6 manual. All visible particles in the events are clustered into jets. A few options are available for some well-known distance measures. Cutoff distances can either be given in terms of a scaled quadratic quantity like Event Analysis y = pT^2/E^2 or an unscaled linear one like Event Analysis pT. Event Analysis Note that we have deliberately chosen not to include the Event Analysis e^+e^- equivalents of the Cambridge/Aachen and anti- Event Analysis kRT algorithms. These tend to be good at clustering the densely populated (in angle) cores of jets, but less successful for the sparsely populated transverse regions, where many jets may come to consist of a single low-momentum particle. In hadron collisions such jets could easily be disregarded, while in Event Analysis e^+e^- annihilation all particles derive back from the hard process. Event Analysis To do jet finding analyses you have to set up a Event Analysis ClusterJet instance, and then feed in events to it, one at a time. The results for the latest event are available as output from a few methods. Event Analysis After the analysis has been performed, a few Event Analysis ClusterJet class methods are available to return the result of the analysis: Event Analysis There is also one method that returns information accumulated for all the events analyzed so far. Event Analysis CellJet Event Analysis CellJet (a.k.a. Event Analysis PYCELL ) is a simple cone jet finder in the UA1 spirit, see the PYTHIA 6 manual. It works in an Event Analysis (eta, phi, eT) space, where Event Analysis eta is pseudorapidity, Event Analysis phi azimuthal angle and Event Analysis eT transverse energy. It will draw cones in Event Analysis R = sqrt(Delta-eta^2 + Delta-phi^2) around seed cells. If the total Event Analysis eT inside the cone exceeds the threshold, a jet is formed, and the cells are removed from further analysis. There are no split or merge procedures, so later-found jets may be missing some of the edge regions already used up by previous ones. Not all particles in the event are assigned to jets; leftovers may be viewed as belonging to beam remnants or the underlying event. It is not used by any experimental collaboration, but is closely related to the more recent and better theoretically motivated anti- Event Analysis kT algorithm Event Analysis Cac08. Event Analysis To do jet finding analyses you have to set up a Event Analysis CellJet instance, and then feed in events to it, one at a time. Especially note that, if you want to use the options where energies are smeared in order so emulate detector imperfections, you must hand in an external random number generator, preferably the one residing in the Event Analysis Pythia class. The results for the latest event are available as output from a few methods. Event Analysis After the analysis has been performed, a few Event Analysis CellJet class methods are available to return the result of the analysis: Event Analysis There is also one method that returns information accumulated for all the events analyzed so far. Event Analysis SlowJet Event Analysis SlowJet is a simple program for doing jet finding according to either of the Event Analysis kT , anti- Event Analysis kT , and Cambridge/Aachen algorithms, in a cylindrical coordinate frame. The name is obviously an homage to the Event Analysis FastJet program Event Analysis Cac06, Cac12. That package contains many more algorithms, with many more options, and, above all, is Event Analysis much faster. Therefore Event Analysis SlowJet is not so much intended for massive processing of data or Monte Carlo files as for simple first tests. Nevertheless, within the advertised capabilities of Event Analysis SlowJet , it has been checked to find identically the same jets as Event Analysis FastJet. The time consumption typically is around or below that to generate an LHC Event Analysis pp event in the first place, so is not prohibitive. But the time rises rapidly for large multiplicities, so obviously Event Analysis SlowJet can not be used for tricks like distributing a dense grid of pseudoparticles to be able to define jet areas, like Event Analysis FastJet can, and also not for events with much pileup or other noise. Event Analysis The recent introduction of Event Analysis fjcore , containing the core functionality of Event Analysis FastJet in a very much smaller package, has changed the conditions. It now is possible (even encouraged by the authors) to distribute the two Event Analysis fjcore files as part of the PYTHIA package. Therefore the Event Analysis SlowJet class doubles as a convenient front end to Event Analysis fjcore , managing the conversion back and forth between PYTHIA and Event Analysis FastJet variables. Some applications may still benefit from using the native codes, but the default now is to let Event Analysis SlowJet call on Event Analysis fjcore for the jet finding. Event Analysis The first step is to decide which particles should be included in the analysis, and with what four-momenta. The Event Analysis SlowJet constructor allows to pick a maximum pseudorapidity defined by the extent of the assumed detector, to pick among some standard options of which particles to analyze, and to allow for some standard mass assumptions, like that all charged particles have the pion mass. Obviously this is only a restricted set of possibilities. Event Analysis Full flexibility can be obtained by deriving from the base class Event Analysis SlowJetHook to write your own Event Analysis include method. This will be presented with one final-state particle at a time, and should return Event Analysis true for those particles that should be analyzed. It is also possible to return modified four-momenta and masses, to take into account detector smearing effects or particle identity misassignments, but you must respect Event Analysis E^2 - p^2 = m^2. Event Analysis Alternatively you can modify the event record itself, or a copy of it (if you want to keep the original intact). For instance, only final particles are considered in the analysis, i.e. particles with positive status code, so negative status code should then be assigned to those particles that you do not want to see analyzed. Again four-momenta and masses can be modified, subject to Event Analysis E^2 - p^2 = m^2. Event Analysis The jet reconstructions is then based on sequential recombination with progressive removal, using the Event Analysis E recombination scheme. To be more specific, the algorithm works as follows. Event Analysis Event Analysis Each particle to be analyzed defines an original cluster. It has a well-defined four-momentum and mass at input. From this information the triplet Event Analysis (pT, y, phi) is calculated, i.e. the transverse momentum, rapidity and azimuthal angle of the cluster. Event Analysis Define distance measures of all clusters Event Analysis i to the beam Event Analysis d_iB = pT_i^2p and of all pairs Event Analysis (i,j) relative to each other Event Analysis d_ij = min( pT_i^2p, pT_j^2p) DeltaR_ij^2 / R^2 where Event Analysis DeltaR_ij^2 = (y_i - y_j)^2 + (phi_i - phi_j)^2. The jet algorithm is determined by the user-selected Event Analysis p value, where Event Analysis p = -1 corresponds to the anti- Event Analysis kT one, Event Analysis p = 0 to the Cambridge/Aachen one and Event Analysis p = 1 to the Event Analysis kT one. Also Event Analysis R is chosen by the user, to give an approximate measure of the size of jets. However, note that jets need not have a circular shape in Event Analysis (y, phi) space, so Event Analysis R can not straight off be interpreted as a jet radius. Event Analysis Find the smallest of all Event Analysis d_iB and Event Analysis d_ij. Event Analysis If this is a Event Analysis d_iB then cluster Event Analysis i is removed from the clusters list and instead added to the jets list. Optionally, a Event Analysis pTjetMin requirement is imposed, where only clusters with Event Analysis pT > pTjetMin are added to the jets list. If so, some of the analyzed particles will not be part of any final jet. Event Analysis If instead the smallest measure is a Event Analysis d_ij then the four-momenta of the Event Analysis i and Event Analysis j clusters are added to define a single new cluster. Convert this four-momentum to a new Event Analysis (pT, y, phi) triplet and update the list of Event Analysis d_iB and Event Analysis d_ij. Event Analysis Return to step 3 until no clusters remain. Event Analysis To do jet finding analyses you first have to set up a Event Analysis SlowJet instance, where the arguments of the constructor specifies the details of the subsequent analyses. Thereafter you can feed in events to it, one at a time, and have them analyzed by the Event Analysis analyze method. Information on the resulting jets can be extracted by a few different methods. The minimal procedure only requires one call per event to do the analysis. We will begin by presenting it, and only afterwards some extensions. Event Analysis After the analysis has been performed, a few Event Analysis SlowJet class methods are available to return the result of the analysis: Event Analysis These are the basic methods. For more sophisticated usage it is possible to trace the clustering, one step at a time. It requires the native jet finding code, Event Analysis useFJcore = false in the constructor. If so, the Event Analysis setup method should be used to read in the event and find the initial smallest distance. Each subsequent Event Analysis doStep will then do one cluster joining and find the new smallest distance. You can therefore interrogate which clusters will be joined next before the joining actually is performed. Alternatively you can take several steps in one go, or take steps down to a predetermined number of jets plus remaining clusters. Event Analysis With this extension, the methods Event Analysis double pT(int i) , Event Analysis double y(int i) , Event Analysis double phi(int i) , Event Analysis Vec4 p(int i) , Event Analysis double m(int i) and Event Analysis int multiplicity(int i) can be used as before. Furthermore, Event Analysis list() generalizes Event Analysis Three further methods can be used to check what will happen next. Event Analysis Finally, and separately, the Event Analysis SlowJetHook class can be used for a more smart selection of which particles to include in the analysis. For instance, isolated and/or high- Event Analysis pT muons, electrons and photons should presumably be identified separately at an early stage, and then not clustered to jets. Event Analysis Technically, it works like with Event Analysis User Hooks. That is, PYTHIA contains the base class. You write a derived class. In the main program you create an instance of this class, and hand it in to Event Analysis SlowJet ; in this case already as part of the constructor. Event Analysis The following methods should be defined in your derived class. Event Analysis It is also possible to define further methods of your own. One such could e.g. be called directly in the main program before the Event Analysis analyze method is called, to identify and bookkeep some event properties you may not want to reanalyze for each individual particle."},{"name":"Event Information","link":"EventInformation.html","text":"Event Information Event Information Event Information The Event Information Info class collects various one-of-a-kind information, some relevant for all events and others for the current event. An object Event Information info is a public member of the Event Information Pythia class, so if you e.g. have declared Event Information Pythia pythia , the Event Information Info methods can be accessed by Event Information pythia.info.method(). Most of this is information that could also be obtained e.g. from the event record, but is here more directly available. It is primarily intended for processes generated internally in PYTHIA, but many of the methods would work also for events fed in via the Les Houches Accord. Event Information List information Event Information The beams Event Information Initialization Event Information The event type Event Information Hard process initiators The methods in this sections refer to the two initial partons of the hard Event Information 2 &rarr; n process (diffraction excluded; see below). Event Information Hard process parton densities and scales The methods in this section refer to the partons for which parton densities have been defined, in order to calculate the cross section of the hard process (diffraction excluded; see below). Event Information These partons would normally agree with the ones above, the initiators of the Event Information 2 &rarr; n process, but it does not have to be so. Currently the one counterexample is POWHEG events Event Information Ali10. Here the original hard process could be Event Information 2 &rarr; (n-1). The NLO machinery at times would add an initial-state branching to give a Event Information 2 &rarr; n process with a changed initial state. In that case the values in this section refer to the original Event Information 2 &rarr; (n-1) state and the initiator ones above to the complete Event Information 2 &rarr; n process. The Event Information Info::list() printout will contain a warning in such cases. Event Information For external events in the Les Houches format, the pdf information is obtained from the optional Event Information #pdf line. When this information is absent, the parton identities and Event Information x values agree with the initiator ones above, while the pdf values are unknown and therefore set to vanish. The Event Information alpha_s and Event Information alpha_em values are part of the compulsory information. The factorization and renormalization scales are both equated with the one compulsory scale value in the Les Houches standard, except when a Event Information #pdf line provides the factorization scale separately. If Event Information alpha_s , Event Information alpha_em or the compulsory scale value are negative at input then new values are defined as for internal processes. Event Information Hard process kinematics The methods in this section provide info on the kinematics of the hard processes, with special emphasis on Event Information 2 &rarr; 2 (diffraction excluded; see below). Event Information Soft Diffraction Information on the primary elastic or Event Information diffractive process ( Event Information A B &rarr; A B, X1 B, A X2, X1 X2, A X B ) can be obtained with the methods in the 'Hard process kinematics' section above. The variables here obviously are Event Information s, t, u, ... rather than Event Information sHat, tHat, uHat, ... , but the method names remain to avoid unnecessary duplication. Most other methods are irrelevant for a primary elastic/diffractive process. Event Information Central diffraction Event Information A B &rarr; A X B is a Event Information 2 &rarr; 3 process, and therefore most of the Event Information 2 &rarr; 2 variables are no longer relevant. The Event Information tHat() and Event Information uHat() methods instead return the two Event Information t values at the Event Information A &rarr; A and Event Information B &rarr; B vertices, and Event Information pTHat() the average transverse momentum of the three outgoing 'particles', while Event Information thetaHat() and Event Information phiHat() are undefined. Event Information While the primary interaction does not contain a hard process, the diffractive subsystems can contain them, but need not. Specifically, double diffraction can contain two separate hard subprocesses, which breaks the methods above. Most of them have been expanded with an optional argument to address properties of diffractive subsystems. This argument can take four values: Event Information Event Information 0 : default argument, used for normal nondiffractive events or the primary elastic/diffractive process (see above); Event Information 1 : the Event Information X1 system in single diffraction Event Information A B &rarr; X1 B or double diffraction Event Information A B &rarr; X1 X2 ; Event Information 2 : the Event Information X2 system in single diffraction Event Information A B &rarr; A X2 or double diffraction Event Information A B &rarr; X1 X2 ; Event Information 3 : the Event Information X system in central diffraction Event Information A B &rarr; A X B. The argument is defined for all of the methods in the three sections above, 'Hard process initiators', 'Hard process parton densities and scales' and 'Hard process kinematics', with the exception of the Event Information isValence methods. Also the four final methods of 'The event type' section, the Event Information ...Sub() methods, take this argument. But recall that they will only provide meaningful answers, firstly if there is a system of the requested type, and secondly if there is a hard subprocess in this system. A simple check for this is that Event Information id1() has to be nonvanishing. The methods below this section do not currently provide information specific to diffractive subsystems, e.g. the MPI information is not bookkept in such cases. Event Information Hard Diffraction Information on the momentum fraction taken from the beam and the momentum transfer in the hard diffractive process. Note that when side A is diffractively exited, then the Pomeron has been taken from side B and vice versa. Event Information Photons from lepton beams Information about the kinematics of photon-photon collisions from lepton beams. Event Information Event weight and activity Event Information Multiparton interactions As already noted, these methods do not make sense for diffractive topologies, and should not be used there. Partly this is physics, but mainly it is for technical reasons, e.g. that double diffraction involves two separate systems that would have to be bookkept as such. Event Information Cross sections Here are the currently available methods related to the event sample as a whole, for the default value Event Information i = 0 , and otherwise for the specific process code provided as argument. This is the number obtained with Event Information Info::code() , while the further subdivision given by Event Information Info::codeSub() is not bookkept. While continuously updated during the run, it is recommended only to study these properties at the end of the event generation, when the full statistics is available. The individual process results are not available if Event Information a second hard process has been chosen, but can be gleaned from the Event Information pythia.stat() output. Event Information Loop counters Mainly for internal/debug purposes, a number of loop counters from various parts of the program are stored in the Event Information Info class, so that one can keep track of how the event generation is progressing. This may be especially useful in the context of the Event Information Event Information User Hooks facility. Event Information Parton shower history The following methods are mainly intended for internal use, e.g. for matrix-element matching. Event Information Les Houches Event File information Since the Event Information Info class is one of the main interfaces between the PYTHIA generation and the user, it also handles the retrieval of information that is passed to PYTHIA through input Les Houches Event files. The Event Information Info class further provides the interface to the information stored after reading Les Houches Event files in the updated format Event Information But14. An example main program using LHEF 3.0 information is Event Information main38.cc.  For the documentation of the necessary Event Information Info class retrieval functions, please consult the Event Information Les Houches Event Files section."},{"name":"Event Record","link":"EventRecord.html","text":"Event Record Event Record The Event Record A Event Record Pythia instance contains two members of the Event Record Event class. The one called Event Record process provides a brief summary of the main steps of the hard process, while the one called Event Record event contains the full history. The user would normally interact mainly with the second one, so we will exemplify primarily with that one. Event Record The Event Record Event class to first approximation is a vector of Event Record Particle s, so that it can expand to fit the current event size. The index operator is overloaded, so that e.g. Event Record event[i] corresponds to the Event Record i 'th particle of the object Event Record event. Thus Event Record event[i].id() returns the identity of the Event Record i 'th particle, and so on. Therefore the methods of the Event Record Event Record Particle class are at least as essential as those of the Event Record Event class itself. Event Record As used inside PYTHIA, some conventions are imposed on the structure of the event record. Entry 0 of the Event Record vector<Particle> is used to represent the event as a whole, with its total four-momentum and invariant mass, but does not form part of the event history. Lines 1 and 2 contains the two incoming beams, and only from here on history tracing works as could be expected. That way unassigned mother and daughter indices can be put 0 without ambiguity. Depending on the task at hand, a loop may therefore start at index 1 rather than 0 without any loss. Specifically, for translation to other event record formats such as HepMC Event Record Dob01 , where the first index is 1, the Pythia entry 0 definitely ought to be skipped in order to minimize the danger of indexing errors. Event Record In the following we will list the methods available. Only a few of them have a function to fill in normal user code. Event Record Basic output methods Some methods are available to read out information on the current event record: Event Record i 'th or last particle in the event record, as an alternative to the methods above. Event Record Further output methods Many event properties are accessible via the Event Record Info class, Event Record see here. Since they are used directly in the event generation, a few are stored directly in the Event Record Event class, however. Event Record One data member in an Event Record Event object is used to keep track of the largest Event Record col() or Event Record acol() colour tag set so far, so that new ones do not clash. Event Record Constructors and modifications of the event record Although you would not normally need to create your own Event Record Event instance, there may be times where that could be convenient. The typical example would be if you want to create a new event record that is the sum of a few different ones, e.g. if you want to simulate pileup events. There may also be cases where you want to add one or a few particles to an existing event record. Event Record A few methods exist to rotate and boost events. These derive from the Event Record Vec4 methods, and affect both the momentum and the vertex (position) components of all particles. Event Record The Junction Class The event record also contains a vector of junctions, which often is empty or else contains only a very few per event. Methods are available to add further junctions or query the current junction list. This is only for the expert user, however, and is not discussed further here, but only the main points. Event Record A junction stores the properties associated with a baryon number that is fully resolved, i.e. where three different colour indices are involved. There are two main applications, Event Record Event Record baryon beams, where at least two valence quarks are kicked out, and so the motion of the baryon number is nontrivial; Event Record baryon-number violating processes, e.g. in SUSY with broken Event Record R -parity. Information on junctions is set, partly in the process generation, partly in the beam remnants machinery, and used by the fragmentation routines, but the normal user does not have to know the details. Event Record For each junction, information is stored on the kind of junction, and on the three (anti)colour indices that are involved in the junction. The possibilities foreseen are: Event Record Event Record Event Record kind = 1 : incoming colourless particle to three outgoing colours (e.g. baryon beam remnant or Event Record neutralino &rarr; q q q ); Event Record Event Record kind = 2 : incoming colourless particle to three outgoing anticolours; Event Record Event Record kind = 3 : one incoming anticolour (stored first) and two outgoing  colours (e.g. antisquark decaying to two quarks, or  gluino decay to three quarks); Event Record Event Record kind = 4 : one incoming colour (stored first) and two outgoing anticolours (e.g. squark decaying to two antiquarks, or  gluino decaying to three antiquarks); Event Record Event Record kind = 5 : two incoming anticolours (stored first) and one outgoing colour (e.g. resonant squark production through RPV); Event Record Event Record kind = 6 : two incoming colours (stored first) and one outgoing anticolour (e.g. resonant antisquark production  through RPV); The odd (even) Event Record kind codes corresponds to a +1 (-1) change in baryon number across the junction. Event Record The kind and colour information in the list of junctions can be set or read with methods of the Event Record Event class, but are not of common interest and so not described here. Event Record A listing of current junctions can be obtained with the Event Record listJunctions() method. Event Record Subsystems Separate from the event record as such, but closely tied to it is the Event Record Event Record PartonSystems class, which mainly stores the parton indices of incoming and outgoing partons, classified by collision subsystem. Such information is needed to interleave multiparton interactions, initial-state showers and final-state showers, and append beam remnants. It could also be used in other places. It is intended to be accessed only by experts, such as implementors of Event Record new showering models."},{"name":"Event Statistics","link":"EventStatistics.html","text":"Event Statistics Event Statistics Event Statistics At the end of the run you will want to write out the final statistics on number of events generated, the corresponding cross sections and the number of errors encountered. This is done with the Event Statistics pythia.stat() method, assuming Event Statistics pythia is an instance of the Event Statistics Pythia class.The method is steered entirely by settings values, see Event Statistics here. Event Statistics Cross-section statistics The Event Statistics ProcessLevel::statistics() method cannot be accessed directly, but only via the Event Statistics Pythia::stat() call above. When called it will loop over the list of existing processes, and for each write out name, code, the number of tried, selected and accepted events, the cross section and the estimated error on the latter. The three different event numbers are related to the Monte Carlo method used, whereby an initial upper estimate of the cross section is used to select a large number of trial phase-space points, whereof then not all survive. Rejections are normally done by the internal machinery, but can also be obtained by Event Statistics user hooks. Therefore: Event Statistics Event Statistics Event Statistics tried events reflect the original number of phase-space points probed, as part of the upper estimate; Event Statistics Event Statistics selected events correspond to those that survive the internal Monte-Carlo selection procedure; Event Statistics Event Statistics accepted events are those that also survive the additional user cuts. In most runs there would be no user hooks implemented, and then the numbers of selected and of accepted events will agree. Aborted events (see below) usually appear in the selected statistics but not in the accepted one. Event Statistics For Les Houches events the total cross section will be correctly displayed; however the (optional) error value will not be used, so that the reported error will be smaller than the correct statistical ones, and often vanish completely. Furthermore, while the number of events is shown for each user process, the cross section is only for the sum of them. Event Statistics Error messages When Pythia is run, errors may occur, and give rise to warning messages. These may be of varying severity, as follows: Event Statistics Event Statistics Event Statistics Abort means things went seriously wrong, and the initialization or event generation failed. In the former case it is not possible to generate events at all, in the latter the current event is flawed and should be skipped. In either case the respective method, Event Statistics Pythia::init() or Event Statistics Pythia::next() , then also returns the value Event Statistics false. There are occasions where an abort may be deliberate, such as when a file of Les Houches Events is read and the end of the file is reached. Event Statistics Event Statistics Error normally is less severe. Typically the program will back up one step and try again. There are cases where this is not possible, in particular during the initialization and the generation of a hard process, and then the error may be followed by an abort as a direct consequence (with two separate messages). Event Statistics Event Statistics Warning is even less severe. In some cases the program will try again, with  good chances of success, in others no measure at all need to be taken. Event Statistics The error messages is handled by a small part of the Event Statistics Info class. It is handed any abort, error or warning messages during the event generation phase, and will store each distinct message, with a counter for how many times it is issued. Thus it is possible to limit the number of identical messages issued, currently hardcoded so that each kind of error message is only printed once ( Event Statistics static const int TIMESTOPRINT = 1 ). This can be overridden by the calling routine, so that all messages of this kind are shown, which is particularly relevant for the initialization  stage. The summary table printed by Event Statistics Pythia::stat() provides a table with all the different messages issued, in alphabetical order, with the total number of times each was generated. Event Statistics Multiparton-interactions statistics If you call Event Statistics Pythia::stat() with Event Statistics Stat:showPartonLevel = true also statistics on multiparton interactions is printed, comprising a list of all allowed subprocesses with how many times each of them has been generated. For the nondiffractive process this also includes the hardest interaction, while else the hardest process is excluded from the statistics. (This is because the hardest process is of the same character and generated by the same machinery in the former case but not in the latter. Also, for the former case only, the standard statistics listing only lists nondiffractive as one single process, i.e. does not further specify the character of the hardest subprocess, so there is not any overlap between the two.)"},{"name":"Examples by Keyword","link":"ExampleKeywords.html","text":"Examples by Keyword Examples by Keyword Examles by Keyword Examples by Keyword The Pythia examples directory contains about 100 examples, each showcasing one or several features of the framework. The examples are ordered by keyword below, and cross referenced, allowing for exploration of the various features. A new user may want to start with examples presenting the Examples by Keyword Basic Usage before going on to explore more advanced topics. Below, the search box can be used to search for keywords which will be displayed the box. This is followed by an expandable list of keywords with links. Finally, a full list of keywords and the relevant examples for each keyword is provided. The code for the example can be accessed by clicking on the name of the example. Examples by Keyword Examples by Keyword Examples by Keyword Examples by Keyword Examples by Keyword Examples by Keyword"},{"name":"External Decays","link":"ExternalDecays.html","text":"External Decays External Decays External Decays External Decays DecayHandler is a base class for the external handling of decays. It is intended for normal particle decays, primarily External Decays B mesons and External Decays tau , and cannot be used to redirect decays of heavy resonances like External Decays t or External Decays Z^0. The user-written derived class is called if a pointer to it has been given with the External Decays External Decays pythia.decayPtr() method, where it also is specified which particles it will be called for. This particle information is accessible with the External Decays External Decays doExternalDecay() method. External Decays The main pure virtual method in External Decays DecayHandler to do the decay is: External Decays At input, these vectors each have size one, so that External Decays idProd[0] , External Decays mProd[0] and External Decays pProd[0] contain information on the particle that is to be decayed. At output, the vectors should have increased by the addition of all the decay products. Even if initially defined in the rest frame of the mother, the products should have been boosted so that their four-momenta add up to the External Decays pProd[0] of the decaying particle. External Decays Should it be of interest to know the prehistory of the decaying particle, e.g. to set some helicity information affecting the decay angular distribution, the full event record is available read-only, with info in which slot External Decays iDec the decaying particle is stored. External Decays The routine should return External Decays true if it managed the decay and External Decays false otherwise, in which case External Decays Pythia will try to do the decay itself. This e.g. means you can choose to do some decay channels yourself, and leave others to External Decays Pythia. To avoid double-counting, the channels you want to handle should be switched off in the External Decays Pythia particle database. In the beginning of the external External Decays decay method you should then return External Decays false with a probability given by the sum of the branching ratios for those channels you do not want to handle yourself. External Decays Note that the decay vertex is always set by External Decays Pythia , and that External Decays B-Bbar oscillations have already been taken into account, if they were switched on. Thus External Decays idProd[0] may be the opposite of External Decays event[iDec].id() , where the latter provides the code at production. External Decays One limitation of the method above is that it is only intended for one decay step, not for a sequential decay chain. (At least not for displaying such intermediate steps.) That is, the control for any subsequent decays returns to PYTHIA. If you want to avoid this another method exists, with one extra argument: External Decays Here the new External Decays motherProd vector also has size one at input, with External Decays motherProd[0] = 0. At output it should have increaed in size in the same way as the other arrays. Particles that come directly from the mother should have value 0, whereas secondary decay products should have the index of the mother in the arrays. To simplify parsing, particles having the same mother should be placed consecutively in the arrays, and daughters can not be put before their mothers. When the particles are transferred to the standard event record, the full mother-daughter relations will be reconstructed from the new array, and any particle with daughters will be considered to have decayed. For long-lived intermediate particles also vertex information will take this into account. User-selected secondary decay channels will be accepted as they are, however, without any knowledge whether the user has allowed for particle-antiparticle oscillations before that decay. Therefore a simple exponential decay time will be used to find secondary vertices. External Decays While primarily intended for sequential decays, of course the External Decays chainDecay method can be used also for simple decays in one step, and is then equivalent with External Decays decay one. This is useful if a particle species has some decay channels that lead to sequential decays whereas others do not. During code execution it is first checked whether External Decays chainDecay can do the decay, and if not External Decays decay is offered to. By default External Decays chainDecay returns false, so if you only overload External Decays decay it will be called. If you want to you can choose to handle the decays of some particles in one of the methods and other particles in the other method, so long as you return false for those decays you do not handle. External Decays The choice of which method to use can be done by the user in the method External Decays A sample test program is available in External Decays main17.cc , providing a simple example of how to use this facility. External Decays EvtGen The external External Decays B and External Decays C -hadron decay program EvtGen performs a chain of decays, rather than single particle decays, to propagate helicity information throughout the chain. Consequently, EvtGen cannot be simply interfaced via the External Decays DecayHandler class. A special class, External Decays EvtGenDecays , is provided in External Decays Pythia8Plugins which can be called after an event has been generated, to perform all remaining decays via EvtGen. An example of how to use this class is provided in External Decays main48.cc. A more detailed discussion of some physics considerations, notably event weights for forced decays, can be found in External Decays this note."},{"name":"Extra-Dimensional Processes","link":"ExtraDimensionalProcesses.html","text":"Extra-Dimensional Processes Extra-Dimensional Processes Extra-Dimensional Processes Scenarios with extra dimensions (ED) allow a multitude of processes. Currently three different categories of processes are implemented. The first involves the production of excited Kaluza Klein states within so-called Randall-Sundrum (RS) scenarios, the second is related to resonance production in TeV-1 sized extra dimensions and the third relates to phenomena from large extra dimensions (LED). Due to the close relation between the LED model and a so-called unparticle model, similar unparticle processes are also kept in this section. Extra-Dimensional Processes Randall-Sundrum Resonances, production processes The graviton (G*) and gluon (KKgluon*) resonance states are assigned PDG code 5100039 and 5100021 respectively. The G* processes are described in Extra-Dimensional Processes Bij01 and the KKgluon* process in Extra-Dimensional Processes Ask11. Decays into fermion and boson pairs are handled with the correct angular distributions, while subsequent decays are handled isotropically. Extra-Dimensional Processes There are two lowest-order processes that together normally should be sufficient for a simulation of Extra-Dimensional Processes G^* production. Extra-Dimensional Processes In addition there are three first-order processes included. These are of less interest, but can be used for dedicated studies of the high- Extra-Dimensional Processes pT tail of Extra-Dimensional Processes G^* production. As usual, it would be double counting to include the lowest-order and first-order processes simultaneously. Therefore the latter ones are not included with the Extra-Dimensional Processes ExtraDimensionsG*:all = on option. In this set of processes all decay angles are assumed isotropic. Extra-Dimensional Processes There is also one process for the production of a gluon resonance. Extra-Dimensional Processes Randall-Sundrum Resonances, parameters In the above scenario the main free parameters are the masses, which are set as usual. In addition there are the following coupling parameters. The coupling Extra-Dimensional Processes kappaMG follows the conventions in Extra-Dimensional Processes Bij01 , where as the flavour dependent couplings follow the conventions used in Extra-Dimensional Processes Dav01. Extra-Dimensional Processes TeV^-1 Sized Extra Dimension, production processes This section contains a processes involving the production of electroweak KK gauge bosons, i.e. Extra-Dimensional Processes gamma_{KK}/Z_{KK} , in one TeV^-1 sized extra dimension. The process is described in Extra-Dimensional Processes Bel10 and allows for individual final states to be specified. Extra-Dimensional Processes TeV^-1 Sized Extra Dimension, parameters Irrespective of the parameter options used, the particle produced, Extra-Dimensional Processes gamma_{KK}/Z_{KK} , will always be assigned code 5000023. Extra-Dimensional Processes Large Extra Dimensions, production processes The LED graviton, where the KK-modes normally are summed and do not give rise to phenomena individually, is assigned PDG code 5000039. The graviton emission and virtual graviton exchange processes use the same implementation as the corresponding unparticle processes, which are all described in Extra-Dimensional Processes Ask10. It is also possible to generate monojet events from scalar graviton emission as described in Extra-Dimensional Processes Azu05 , by turning on the option Extra-Dimensional Processes GravScalar. Extra-Dimensional Processes Extra-Dimensional Processes Note: As discussed in Extra-Dimensional Processes Ask09 , for the graviton or unparticle emission processes the underlying Breit-Wigner mass distribution should be matched to the graviton mass spectrum in order to achieve an optimal MC efficiency. Extra-Dimensional Processes The following lowest order graviton emission processes are available. Extra-Dimensional Processes The following LED processes with virtual graviton exchange are available. Extra-Dimensional Processes Dijet production including graviton exchange is also available, using the same effective theory approach as the LED G exchange processes above or including more detailed amplitudes in accordance with Extra-Dimensional Processes Fra11. In case of the latter, the value of Extra-Dimensional Processes LambdaT is used as the value of the cut-off scale Extra-Dimensional Processes Lambda. For this reason the dijet processes only relates to the LED model and no unparticle versions are available. The processes are grouped together like their Extra-Dimensional Processes HardQCD equivalents and should therefore converge to the same results in the limit of an insignificant graviton contribution. Extra-Dimensional Processes Extra-Dimensional Processes Warning: These LED dijets processes are still being validated. Extra-Dimensional Processes Large Extra Dimensions, parameters Extra-Dimensional Processes Unparticles, production processes As mentioned above, the similar unparticle and graviton processes share the same implementations. The unparticle processes, however, only use the dedicated unparticle parameters below. The unparticle is also assigned the PDG code 5000039 and is therefore called Extra-Dimensional Processes Graviton in the event record. The graviton and unparticle emission as well as virtual graviton and unparticle exchange processes are described in Extra-Dimensional Processes Ask10. Extra-Dimensional Processes Extra-Dimensional Processes Note: As discussed in Extra-Dimensional Processes Ask09 , for the graviton or unparticle emission processes the underlying Breit-Wigner mass distribution should be matched to the graviton mass spectrum in order to achieve an optimal MC efficiency. Extra-Dimensional Processes The following unparticle emission processes are available. Extra-Dimensional Processes The following processes with virtual unparticle exchange are available. Extra-Dimensional Processes Unparticles, parameters"},{"name":"Flavour Selection","link":"FlavourSelection.html","text":"Flavour Selection Flavour Selection Flavour Selection The Flavour Selection StringFlav class handles the choice of a new flavour in the fragmentation process, and the production of a new hadron from a set of input flavours. It is mainly used by the string fragmentation machinery (including ministrings), but also e.g. in some particle decays and for some beam-remnant cases. The basic concepts are in agreement with Flavour Selection And83. An alternative 'thermal model' is described further below. Flavour Selection Flavour Selection Flavour Selection Flavour Selection Flavour Selection for Gaussian Flavour Selection pT Distribution The relative production rates of different particle species is influenced by the parameters below. Some have only an impact on one specific quantity, but most directly or indirectly have consequences for many observables. Therefore the values to use have to be viewed in the context of a complete Flavour Selection tune. Flavour Selection New flavours The main parameters of the selection of a new flavour are Flavour Selection Standard-meson production The bulk of the particle production corresponds to the lowest-lying pseudoscalar and vector multiplets. Their production rates are determined by the parameters in this section. Flavour Selection For a given set of flavours, produced according to the probabilities outlined above, the ratio of vector-to-pseudocalar meson production is described by the parameters below. The maximum allowed rate for each case has been set according to spin-counting rules, but we expect the real rates to be lower, especially for lighter mesons, owing to the vector-pseudoscalar mass splitting. Flavour Selection Inside each light-quark meson nonet, an octet-singlet mixing angle describes the mixing of the two flavour-diagonal isoscalar = 0 states. (For terminology and details see Flavour Selection Yao06 , chapter 14 on the quark model.) This angle is needed to specify the probability for such a Flavour Selection q qbar state to project onto a specific meson. More transparent formulae are obtained by introducing the angle Flavour Selection alpha = theta + 54.7 degrees: Flavour Selection f  = (uubar + ddbar)/sqrt(2) * sin(alpha) + ssbar * cos(alpha) Flavour Selection f' = (uubar + ddbar)/sqrt(2) * cos(alpha) - ssbar * sin(alpha) Flavour Selection Further, the simple model overestimates the production of Flavour Selection eta and, in particular, Flavour Selection eta' mesons, which can be rectified by Flavour Selection Excited-meson production Several excited mesons, ie. with radial or orbital excitations, have been observed at non-negligible production rates. Extrapolated to all states a fair fraction of all particle production might proceed through such states. There are big uncertainties, however, since these excited mesons in many cases are extremely poorly known. This also means that the modeling of their production and decay is very primitive, and even that the inclusion of the production of such states may lead to a degraded agreement with data. Currently the default is that all such production is switched off. Flavour Selection Parameters are provided to switch them on. By demand, this machinery has been made more flexible than in the past. Therefore one parameter is provided for each combination of heaviest flavour ( Flavour Selection u/d , Flavour Selection s , Flavour Selection c or Flavour Selection b ) and multiplet produced. In each case the production rate is normalized to that of the lowest-lying pseudoscalar of the same flavour content, as for the vector-meson rates introduced above. The multiplets available are the four obtained for one unit of orbital angular momentum, in the nonrelativistic classification. Using Flavour Selection J to denote the sum of quark spin Flavour Selection S and orbital angular momentum Flavour Selection L , i.e. what would normally be called the spin of the meson, one has: Flavour Selection Flavour Selection a pseudovector multiplet with Flavour Selection L=1, S=0, J=1 ; Flavour Selection a scalar multiplet with Flavour Selection L=1, S=1, J=0 ; Flavour Selection a pseudovector multiplet with Flavour Selection L=1, S=1, J=1 ; Flavour Selection a tensor multiplet with Flavour Selection L=1, S=1, J=2. The maximum allowed rate for each case has been set according to spin-counting rules, but we expect the real rates to be significantly lower, owing to mass suppression. Flavour Selection In addition, an octet-singlet mixing angle is needed for each multiplet, as for the pseudoscalar and vector multiplets above. Only for the tensor multiplet does any determination exist; for the other multiplets default has been chose so that Flavour Selection ssbar does not mix with the light quarks, and so that the Flavour Selection ssbar state is the heavier of the two. Flavour Selection Baryon production The relative rate of baryon production is mainly given by the quark and diquark production parameters above, plus SU(6) Clebsch-Gordans. The one modifiable parameter related to these coefficients is Flavour Selection In addition, if popcorn production is allowed, wherein a set of mesons ( Flavour Selection M ) may be produced in between the baryon ( Flavour Selection B ) and the antibaryon ( Flavour Selection Bbar ), a set of further parameters is introduced. Currently only the simplest scenario is implemented, wherein at most one intermediate meson may be produced. Flavour Selection Finally, there are some indications that leading-baryon production may be further suppressed. A proper description should probably be based on a suppression of early production times Flavour Selection Ede97 , but we here only implement a simpler version where production near the end of a string, as defined by rank, is suppressed. The more detailed studies suggest that leading Flavour Selection c and Flavour Selection b baryon production will be less suppressed, so we leave it open to set light- and heavy-baryon suppression separately. Flavour Selection Flavour Selection Flavour Selection Flavour Selection Flavour Selection for Thermal Flavour Selection pT Distribution If the hadronic Flavour Selection pT is generated according to the non-default thermal distribution, i.e. if Flavour Selection StringPT:thermalModel = on , the choice of a new flavour in the fragmentation process, and the production of a new hadron from a set of input flavours, depends mainly on the hadron mass Flavour Selection Fis16. For a given Flavour Selection pT value the new flavour is chosen according to Flavour Selection exp( -mT_had/T) = exp( - sqrt( pT_had^2 + mT_had^2 )/T). Here Flavour Selection T is primarily given by Flavour Selection StringPT:temperature , but can be further modified in the context of closely packed strings, Flavour Selection StringPT:closePacking = on. Additional factors are included from theory arguments, for instance the ratio of vector-to-pseudocalar meson production is set according to spin-counting rules. Note that the octet-singlet mixing angles in the light-quark meson nonets are taken from the parameters above. Currently popcorn production has not been implemented, i.e. a baryon and an antibaryon are nearest neighbours in the flavour fragmentation chain, and share the flavours of one diquark. In addition the following two factors are introduced to provide an improved description of the flavour composition, although not as good as obtained in the default Gaussian scenario, with its bigger selection of free parameters. Flavour Selection Flavour Selection Flavour Selection The following parameters are used to determine which hadrons to choose from. By default only the pseudoscalar and vector meson nonet (L=0) and baryons with u/d/s quarks are included. For an already-existing heavier flavour, say c or b, this corresponds to picking only u/d/s for the new quark(s). Flavour Selection Note: The computer time for selecting the flavour of new hadrons goes linearly with the number of hadrons included. Therefore we recommend sticking to the default options as heavier hadrons are produced less likely anyway."},{"name":"Four-Vectors","link":"FourVectors.html","text":"Four-Vectors Four-Vectors Four-Vectors The Four-Vectors Vec4 class gives a simple implementation of four-vectors. The member function names are based on the assumption that these represent four-momentum vectors. Thus one can get or set Four-Vectors p_x, p_y, p_z and Four-Vectors e , but not Four-Vectors x, y, z or Four-Vectors t. This is only a matter of naming, however; a Four-Vectors Vec4 can equally well be used to store a space-time four-vector. Four-Vectors The Four-Vectors Particle object contains a Four-Vectors Vec4 p that stores the particle four-momentum, and another Four-Vectors Vec4 vProd for the production vertex. For the latter the input/output method names are adapted to the space-time character rather than the normal energy-momentum one. Thus a user would not normally access the Four-Vectors Vec4 classes directly, but only via the methods of the Four-Vectors Particle class, see Four-Vectors Particle Properties. Four-Vectors Nevertheless you are free to use the PYTHIA four-vectors, e.g. as part of some simple analysis code based directly on the PYTHIA output, say to define the four-vector sum of a set of particles. But note that this class was never set up to allow complete generality, only  to provide the operations that are of use inside PYTHIA. There is no separate class for three-vectors, since such can easily be represented by four-vectors where the fourth component is not used. Four-Vectors Four-vectors have the expected functionality: they can be created, copied, added, multiplied, rotated, boosted, and manipulated in other ways. Operator overloading is implemented where reasonable. Properties can be read out, not only the components themselves but also for derived quantities such as absolute momentum and direction angles. Four-Vectors Constructors and basic operators A few methods are available to create or copy a four-vector: Four-Vectors Member methods for input The values stored in a four-vector can be modified in a few different ways: Four-Vectors Member methods for output A number of methods provides output of basic or derived quantities: Four-Vectors Friend methods for output There are also some Four-Vectors friend methods that take one, two or three four-vectors as argument. Several of them only use the three-vector part of the four-vector. Four-Vectors Operations with four-vectors Of course one should be able to add, subtract and scale four-vectors, and more: Four-Vectors There are also a few related operations that are normal member methods: Four-Vectors Rotations and boosts A common task is to rotate or boost four-vectors. In case only one four-vector is affected the operation may be performed directly on it. However, in case many particles are affected, the helper class Four-Vectors RotBstMatrix can be used to speed up operations. Four-Vectors For a longer sequence of rotations and boosts, and where several Four-Vectors Vec4 are to be rotated and boosted in the same way, a more efficient approach is to define a Four-Vectors RotBstMatrix , which forms a separate auxiliary class. You can build up this 4-by-4 matrix by successive calls to the methods of the class, such that the matrix encodes the full sequence of operations. The order in which you do these calls must agree with the imagined order in which the rotations/boosts should be applied to a four-momentum, since in general the operations do not commute. Four-Vectors (Mathematically you would e.g. define Four-Vectors M = M_3 M_2 M_1 in that Four-Vectors M p = M_3( M_2( M_1 p) ) ). That is, operations on the four-vector Four-Vectors p are carried out in the order first Four-Vectors M_1 , then Four-Vectors M_2 and finally Four-Vectors M_3. Thus Four-Vectors M_1, M_2, M_3 is also the order in which you should input rotations and boosts to Four-Vectors M .)"},{"name":"Fourth-Generation Processes","link":"FourthGenerationProcesses.html","text":"Fourth-Generation Processes Fourth-Generation Processes Fourth-Generation Processes A fourth generation can be accommodated within the Standard Model, without the introduction of any new concepts. Many experimental constraints exist, but it has not been fully excluded. Therefore we offer a simple implementation, along the lines of the top. It could also be useful as a template for studies of other new particles with similar characteristics. Fourth-Generation Processes The fourth generation are given names as in the third, but with a prime, i.e. Fourth-Generation Processes b' with PDG code 7, Fourth-Generation Processes t' with code 8, Fourth-Generation Processes tau' with code 17, and Fourth-Generation Processes nu'_tau with code 18. Most important for you is to assign a mass hierarchy, to decide which fermions can decay into which. The current implementation assumes that mass splittings are big enough that fourth-generation fermions can decay to third-generation ones by the emission of an on-shell Fourth-Generation Processes W. To this end, the standard three-generation CKM mixing matrix has been extended to include a fourth generation, see below. Since no mixing has been implemented in the neutrino sector it would be assumed that the lighter of Fourth-Generation Processes tau' and Fourth-Generation Processes nu'_tau is stable. No decay modes have been implemented that go beyond the Standard Model, so modifications would be needed if e.g. also SUSY is included in the game. Fourth-Generation Processes Production processes Fourth-Generation Processes 1) Fourth-Generation Processes b' processes Different ways to produce Fourth-Generation Processes b' quarks, singly or in pairs. For a Fourth-Generation Processes b' t' pair see section 3 below. Fourth-Generation Processes 2) Fourth-Generation Processes t' processes Different ways to produce Fourth-Generation Processes t' quarks, singly or in pairs. For a Fourth-Generation Processes b' t' pair see section 3 below. Fourth-Generation Processes 3) Pair-processes with different flavours Different ways to produce two different fourth-generation fermions. Fourth-Generation Processes Missing in this list is scatterings Fourth-Generation Processes q q' &rarr; t' b' by Fourth-Generation Processes t -channel exchange of a Fourth-Generation Processes W^+- boson, since currently the matrix element for such processes have not been implemented for two massive particles in the final state. Since this process would involve two CKM-suppressed vertices it ought to be small. Fourth-Generation Processes Parameters The Cabibbo-Kobayashi-Maskawa matrix is extended by seven further values. So as not to mess up the Standard Model, the normal 3 * 3 matrix is kept unitary, and so the new off-diagonal elements lead to a slight breaking of this. For exploratory studies this should be good enough; more detailed 4 * 4 tunes to data would only make sense the day there are evidence for the existence of a fourth generation."},{"name":"Fragmentation","link":"Fragmentation.html","text":"Fragmentation Fragmentation Fragmentation Fragmentation in PYTHIA is based on the Lund string model Fragmentation And83, Sjo84. Several different aspects are involved in the physics description, which  here therefore is split accordingly. This also, at least partly, reflect the set of classes involved in the fragmentation machinery. Fragmentation The variables collected here have a very wide span of usefulness. Some would be central in any hadronization tuning exercise, others should not be touched except by experts. Fragmentation The fragmentation flavour-choice machinery is also used in a few other places of the program, notably particle decays, and is thus described on the separate Fragmentation Flavour Selection page. Fragmentation Fragmentation functions The Fragmentation StringZ class handles the choice of longitudinal lightcone fraction Fragmentation z according to one of two possible shape sets. Fragmentation The Lund symmetric fragmentation function Fragmentation And83 is the only alternative for light quarks. It is of the form Fragmentation f(z) = (1/z) * (1-z)^a * exp(-b m_T^2 / z) with the two main free parameters Fragmentation a and Fragmentation b to be tuned to data. They are stored in Fragmentation In the context of fits to experimental data, note that the Fragmentation a and Fragmentation b parameters typically exhibit a very high degree of correlation. An option for choosing an alternative parameterisation is therefore provided, whereby the user specifies the desired average value of the fragmentation function for primary rho mesons instead of the Fragmentation b parameter. The Fragmentation a parameter should still be given by Fragmentation StringZ:aLund as usual. The rho has been chosen as reference since its mass is near the average of the primary hadron production, while pions come to dominate only after secondary decays. This option can be enabled via the following flag: Fragmentation In principle, each flavour can have a different Fragmentation a. Then, for going from an old flavour Fragmentation i to a new Fragmentation j one the shape is Fragmentation f(z) = (1/z) * z^{a_i} * ((1-z)/z)^{a_j} * exp(-b * m_T^2 / z) This is only implemented for s quarks and diquarks relative to normal quarks: Fragmentation Finally, the Bowler modification Fragmentation Bow81 introduces an extra factor Fragmentation 1/z^{r_Q * b * m_Q^2} for heavy quarks. To keep some flexibility, a multiplicative factor Fragmentation r_Q is introduced, which ought to be unity (provided that quark masses were uniquely defined) but can be set in Fragmentation Within the string framework, the Fragmentation b parameter is universal, i.e. common for all flavours. Nevertheless, for fits to experimental data, better agreement can be obtained if both Fragmentation a_Q and Fragmentation b_Q can be set freely in a general expression Fragmentation f(z) = 1/z^{1 + r_Q * b_Q * m_Q^2} * (1-z)^a_Q * exp(-b_Q m_T^2 / z) The below switches and values can be used to achieve this. They should be used with caution and constitute clear deviations from the Lund philosophy. Fragmentation As another nonstandard alternative, it is possible to switch over to the Peterson/SLAC formula Fragmentation Pet83 Fragmentation f(z) = 1 / ( z * (1 - 1/z - epsilon/(1-z))^2 ) for charm, bottom and heavier (defined as above) by the three flags Fragmentation When switched on, the corresponding epsilon values are chosen to be Fragmentation Fragmentation Fragmentation pT The Fragmentation StringPT class handles the choice of fragmentation Fragmentation pT. At each string breaking the quark and antiquark of the pair are supposed to receive opposite and compensating Fragmentation pT kicks. How they are distributed depends on the following flag: Fragmentation Gaussian Distribution For Fragmentation StringPT:thermalModel = off the quarks receive Fragmentation pT kicks according to a Gaussian distribution in Fragmentation p_x and Fragmentation p_y separately. Call Fragmentation sigma_q the width of the Fragmentation p_x and Fragmentation p_y distributions separately, i.e. Fragmentation d(Prob) = exp( -(p_x^2 + p_y^2) / 2 sigma_q^2). Then the total squared width is Fragmentation <pT^2> = <p_x^2> +  <p_y^2> = 2 sigma_q^2 = sigma^2. It is this latter number that is stored in Fragmentation Since a normal hadron receives Fragmentation pT contributions for two string breakings, it has a Fragmentation <p_x^2>_had = <p_y^2>_had = sigma^2 , and thus Fragmentation <pT^2>_had = 2 sigma^2. Fragmentation Some studies on isolated particles at LEP has indicated the need for a slightly enhanced rate in the high- Fragmentation pT tail of the above distribution. This would have to be reviewed in the context of a complete retune of parton showers and hadronization, but for the moment we stay with the current recipe, to boost the above Fragmentation pT by a factor Fragmentation enhancedWidth for a small fraction Fragmentation enhancedFraction of the breakups, where Fragmentation In the context of some toy studies Fragmentation Fis16 the following three options have also been introduced, but are not part of any recommended framework. Fragmentation Thermal Distribution For Fragmentation StringPT:thermalModel = on the quark Fragmentation pT is generated such that the resulting hadron Fragmentation pT follows a thermal distribution Fragmentation d(Prob) = exp( -pT_had/T) d^2pT_had with temperature Fragmentation T , whose value is given by Fragmentation Common setup for enhanced width If strings are closely packed, e.g. as a consequence of MPIs, it is likely that they receive an increased string tension, which translates into a broader Fragmentation pT spectrum, see further Fragmentation Fis16. It also means an enhanced rate (or rather reduced suppression) of heavy-particle production relative to pions. This can be regulated by the flag and parameters below. Fragmentation Jet joining procedure String fragmentation is carried out iteratively from both string ends inwards, which means that the two chains of hadrons have to be joined up somewhere in the middle of the event. This joining is described by parameters that in principle follows from the standard fragmentation parameters, but in a way too complicated to parametrize. The dependence is rather mild, however, so for a sensible range of variation the parameters in this section should not be touched. Fragmentation This Fragmentation W_min_smeared is then compared with the current remaining Fragmentation W_transverse to determine if there is energy left for further particle production. If not, i.e. if Fragmentation W_transverse < W_min_smeared , the final two particles are produced from what is currently left, if possible. (If not, the fragmentation process is started over.) Fragmentation Colour tracing Fragmentation Simplifying systems There are a few situations when it is meaningful to simplify the original task, one way or another. Fragmentation Ministrings The Fragmentation MiniStringFragmentation machinery is only used when a string system has so small invariant mass that normal string fragmentation is difficult/impossible. Instead one or two particles are produced, in the former case shuffling energy-momentum relative to another colour singlet system in the event, while preserving the invariant mass of that system. With one exception parameters are the same as defined for normal string fragmentation, to the extent that they are at all applicable in this case.  A discussion of the relevant physics is found in Fragmentation Nor00. The current implementation does not completely abide to the scheme presented there, however, but has in part been simplified. (In part for greater clarity, in part since the class is not quite finished yet.) Fragmentation Junction treatment A junction topology corresponds to an Y arrangement of strings i.e. where three string pieces have to be joined up in a junction. Such topologies can arise if several valence quarks are kicked out from a proton beam, or in baryon-number-violating SUSY decays. Special attention is necessary to handle the region just around the junction, where the baryon number topologically is located. The junction fragmentation scheme is described in Fragmentation Sjo03. The parameters in this section should not be touched except by experts."},{"name":"Hadron Scattering","link":"HadronScattering.html","text":"Hadron Scattering Hadron Scattering Hadron Scattering This page describes a few simple hadron (re)scattering models. They are intended to take into account that the overlap of multiple strings at low transverse dimensions is likely to lead to some collective effects, not unlike those observed in heavy-ion collisions, even if not quite as pronounced. Specifically, it is assumed that the hadrons produced can scatter against each other on the way out, before the fragmenting system has had time to expand enough that the hadrons get free. Thereby heavier particles are shifted to higher transverse momenta, at the expense of the lighter ones. Hadron Scattering The main switch on/off switch for rescattering is Hadron Scattering HadronLevel:HadronScatter , which by the default is off, since all models are rather simplistic and have to be used with some caution. Currently there are three different options available: Hadron Scattering The New Model for Hadron Scattering Within the new model, there are two options available for how hadron pairs are found: Hadron Scattering Rapidity based This corresponds to Hadron Scattering HadronScatter:mode = 0. Hadron Scattering Probe all hadron pairs with an invariant mass Hadron Scattering m Hadron Scattering inv < (m Hadron Scattering 2 Hadron Scattering 1 +p Hadron Scattering 2 Hadron Scattering Max ) Hadron Scattering 1/2 + (m Hadron Scattering 2 Hadron Scattering 2 +p Hadron Scattering 2 Hadron Scattering Max ) Hadron Scattering 1/2 with the parameter Hadron Scattering p Hadron Scattering Max Hadron Scattering If a hadron pair passes this cut, the scattering probability for hadrons of different strings is Hadron Scattering P Hadron Scattering DS (&#x394y) = P Hadron Scattering max Hadron Scattering DS (1 - &#x394y/&#x394y Hadron Scattering max ) with rapidity difference Hadron Scattering &#x394y of the hadron pair and the parameters Hadron Scattering &#x394y Hadron Scattering max Hadron Scattering and Hadron Scattering P Hadron Scattering max Hadron Scattering DS , see Hadron Scattering below. If the hadrons are produced within the same string the probability is Hadron Scattering P Hadron Scattering DS (&#x394y) P Hadron Scattering max Hadron Scattering SS if the hadrons are further apart from each other as Hadron Scattering HadronScatter:neighbourFar , Hadron Scattering 0 if they are closer together as Hadron Scattering HadronScatter:neighbourNear , and linear between the maximum Hadron Scattering HadronScatter:maxProbSS and minimum probability Hadron Scattering HadronScatter:minProbSS inbetween. Hadron Scattering Rapidity and Azimuth based This corresponds to Hadron Scattering HadronScatter:mode = 1. Hadron Scattering All hadron pairs are considered. The scattering probability for hadrons of different strings is Hadron Scattering P Hadron Scattering DS (&#x394y,&#x394&#x3C6) = P Hadron Scattering max Hadron Scattering DS (1 - ((&#x394y) Hadron Scattering 2 +(&#x394&#x3C6) Hadron Scattering 2 ) Hadron Scattering 1/2 /R Hadron Scattering max ) with rapidity difference Hadron Scattering &#x394y and difference in azimuth Hadron Scattering &#x394&#x3C6 of the hadron pair and the parameters Hadron Scattering R Hadron Scattering max Hadron Scattering and Hadron Scattering P Hadron Scattering max Hadron Scattering DS , see Hadron Scattering below. The probability for hadron pairs from the same string is similar to the one before. Hadron Scattering Common Parameters The following paramters are used for both the above cases: Hadron Scattering The Old Model for Hadron Scattering Hadron Scattering Warning: This is still at an experimental level, and should not be used unless you know what you are doing. Hadron Scattering Hadron selection Hadron Scattering Scattering probability Hadron Scattering Hadron Production Vertices It is not trivial to define where in space-time that the primary hadrons are produced by the string fragmentation machinery. The basic strategy is well-defined in a 1+1-dimensional picture, as represented by a single straight string stretched between massless Hadron Scattering q and Hadron Scattering qbar endpoints Hadron Scattering And83. Even so there is no unique definition of the production vertex of the hadron straddling two adjacent breakup vertices, and the transverse width of the string adds a further smearing. Some of that ambiguity is reflected in the options below. The major step in complexity comes with the introduction of more convoluted string topologies, however. Here the momentum-space description contains a number of ambiguities, notably for those hadrons that straddle two or more different string regions, that were only overcome by a set of reasonable simplifications Hadron Scattering Sjo84. The space-time picture introduced here inherits all these problems, and thus many of the same prescriptions, but also require a few further simplifications and assumptions. Hadron Scattering Below the main switches and parameters of this picture are described. Note, however, that that the machinery is still under development and should be used with caution. Hadron Scattering When on, the machinery assigns space-time production vertices to all primary hadrons, i.e. those that are produced directly from the string breakups. These vertices can be read out by the Hadron Scattering event[i].vProd() method. Note that the length unit is mm, and mm/s for time. To study the hadronization process it is natural to cnvert to fm. The conversion constants Hadron Scattering FM2MM Hadron Scattering = 10^12 and Hadron Scattering MM2FM Hadron Scattering = 10^-12 are defined inside the Hadron Scattering Pythia8 namespace, available in user programs that include Hadron Scattering Pythia8/Pythia.h. Hadron Scattering Secondary vertices are set in decays, but by default only for scales of the order of mm or above. That is, decays on the fm scale, like for Hadron Scattering rho mesons, then are not considered. When the machinery in this section is switched on, also such displacements are considered, see further Hadron Scattering HadronVertex:rapidDecays below. Do note that the factor Hadron Scattering 10^12 separation between fm and mm scales means that the two do not mix well, i.e. any contribution of the latter kind would leave little trace of the former when stored in double-precision real numbers. For this reason it is also not meaningful to combine studies of hadron production vertices with displaced Hadron Scattering pp collision vertices from the profile of the incoming bunches."},{"name":"Hadron-Level Standalone","link":"HadronLevelStandalone.html","text":"Hadron-Level Standalone Hadron-Level Standalone Hadron-Level Standalone The Les Houches Accord allows external process-level configurations to be fed in, for subsequent parton-level and hadron-level generation to be handled internally by PYTHIA. There is no correspondingly standardized interface if you have external events that have also been generated through the parton-level stage, so that only the hadron-level remains to be handled. A non-standard way to achieve this exists, however, and can be useful both for real applications and for various tests of the hadronization model on its own. Hadron-Level Standalone The key trick is to set the flag Hadron-Level Standalone ProcessLevel:all = off. When Hadron-Level Standalone pythia.next() is called it then does not try to generate a hard process. Since there are no beams, it is also not possible to perform the normal Hadron-Level Standalone PartonLevel step. (It is still possible to generate final-state radiation, but this is not automatic. It would have to be done by hand, using the Hadron-Level Standalone pythia.forceTimeShower(...) method, before Hadron-Level Standalone pythia.next() is called.) Thus only the Hadron-Level Standalone HadronLevel methods are called, to take the current content of the event record stored in Hadron-Level Standalone pythia.event as a starting point for any hadronization and decays that are allowed by the normal parameters of this step. Often the input would consist solely of partons grouped into colour singlets, but also (colour-singlet) particles are allowed. Hadron-Level Standalone To set up all the parameters, a Hadron-Level Standalone pythia.init() call has to be used, without any arguments. In brief, the structure of the main program therefore should be something like Hadron-Level Standalone Pythia pythia;                     // Declare generator.  Event& event = pythia.event            // Convenient shorthand.  pythia.readString('ProcessLevel:all = off'); // The trick!  pythia.init();                     // Initialization.  for (int iEvent = 0; iEvent < nEvent; ++iEvent) {    // Insert filling of event here!    pythia.next();                    // Do the hadron level.  } Of course this should be supplemented by analysis of events, error checks, and so on, as for a normal PYTHIA run. The unique aspect is how to fill the Hadron-Level Standalone event inside the loop, before Hadron-Level Standalone pythia.next() is called. Hadron-Level Standalone Input configuration To set up a new configuration the first step is to throw away the current one, with Hadron-Level Standalone event.reset(). This routine will also reserve the zeroth entry in the even record to represent the event as a whole. Hadron-Level Standalone With the Hadron-Level Standalone event.append(...) methods a new entry is added at the bottom of the current record, i.e. the first time it is called entry number 1 is filled, and so on. The Hadron-Level Standalone append method basically exists in four variants, either without or with history information, and with four-momentum provided either as a Hadron-Level Standalone Vec4 four-vector or as four individual components: Hadron-Level Standalone append( id, status, col, acol, p, m)  append( id, status, col, acol, px, py, pz, e, m)  append( id, status, mother1, mother2, daughter1, daughter2, col, acol, p, m)  append( id, status, mother1, mother2, daughter1, daughter2, col, acol, px, py, pz, e, m) The methods return the index at which the entry has been stored, but normally you would not use this feature. Hadron-Level Standalone All the four methods have two final, optional arguments. The Hadron-Level Standalone scale one is highly relevant if you want to perform parton showers in addition to hadronization; see the Hadron-Level Standalone pythia.forceTimeShower() description below. The final Hadron-Level Standalone pol one denotes polarization, and could be used to perform polarized Hadron-Level Standalone tau decays. Hadron-Level Standalone You can find descriptions of the input variables Hadron-Level Standalone here. The PDG particle code Hadron-Level Standalone id and the Les Houches Accord colour Hadron-Level Standalone col and anticolour Hadron-Level Standalone acol tags must be set correctly. The four-momentum and mass have to be provided in units of GeV; if you omit the mass it defaults to 0. Hadron-Level Standalone Outgoing particles that should hadronize should be given status code 23. Often this is the only status code you need. You could e.g. also fill in incoming partons with -21 and intermediate ones with -22, if you so wish. Usually the choice of status codes is not crucial, so long as you recall that positive numbers correspond to particles that are still around, while negative numbers denote ones that already hadronized or decayed. However, so as not to run into contradictions with the internal PYTHIA checks (when Hadron-Level Standalone Check:event = on ), or with external formats such as HepMC, we do recommend the above codes. When Hadron-Level Standalone pythia.next() is called the positive-status particles that hadronize/decay get the sign of the status code flipped to negative but the absolute value is retained. The new particles are added with normal PYTHIA status codes. Hadron-Level Standalone For normal hadronization/decays in Hadron-Level Standalone pythia.next() the history encoded in the mother and daughter indices is not used. Therefore the first two Hadron-Level Standalone append methods, which set all these indices vanishing, should suffice. The subsequent hadronization/decays will still be properly documented. Hadron-Level Standalone The exception is when you want to include junctions in your string topology, i.e. have three string pieces meet. Then you must insert in your event record the (decayed) particle that is the reason for the presence of a junction, e.g. a baryon beam remnant from which several valence quarks have been kicked out, or a neutralino that underwent a baryon-number-violating decay. This particle must have as daughters the three partons that together carry the baryon number. Hadron-Level Standalone When Hadron-Level Standalone ProcessLevel:all = off the Hadron-Level Standalone pythia.next() call applied to a parton-level confguration will hadronize it, without generating any parton showers. Indeed, the point of the framework described here is to be able to feed in complete showered parton topologies for hadronization. (The exception is if you feed in a resonance, see next section.) As an option, however, it is possible to generate a shower before the Hadron-Level Standalone pythia.next() step by using the Hadron-Level Standalone pythia.forceTimeShower( int iBeg, int iEnd, double pTmax, int nBranchMax = 0) method. Here Hadron-Level Standalone iBeg and Hadron-Level Standalone iEnd give the range of partons that should be allowed to shower, Hadron-Level Standalone pTmax the maximum Hadron-Level Standalone pT scale of emissions, and a nonzero Hadron-Level Standalone nBranchMax a maximum number of allowed branchings. Additionally, a Hadron-Level Standalone scale has to be set for each parton that should shower, which requires an additional final argument to the Hadron-Level Standalone append methods above, or alternatively separately with the Hadron-Level Standalone pythia.event[i].scale(...) method. This scale limits the maximum Hadron-Level Standalone pT allowed for each parton, in addition to the global Hadron-Level Standalone pTmax. When not set the scale defaults to 0, meaning no radiation for that parton. Hadron-Level Standalone The sample program in Hadron-Level Standalone main21.cc illustrates how you can work with this facility, both for simple parton configurations and for more complicated ones with junctions, and also how to force a shower. Hadron-Level Standalone As an alternative to setting up a topology with the methods above, a Hadron-Level Standalone Les Houches Event File (LHEF) can also provide the configurations, using the 'no-beams' extension. For parsing reasons the Hadron-Level Standalone <init> and Hadron-Level Standalone </init> tags need to be present as two separate lines, but there need not be anything between them. If there is, then the beam identities should be picked to be 0. A standard Hadron-Level Standalone <LesHouchesEvents version='1.0'> line must also be at the top of the file. For the rest only the Hadron-Level Standalone <event>....</event> blocks need to be present, one for each event. You should select Hadron-Level Standalone Beams:frameType = 4 and provide the file name in Hadron-Level Standalone Beams:LHEF , but setting Hadron-Level Standalone ProcessLevel:all = off here is superfluous since the absence of beams is enough to make this apparent. Needless to say, an externally linked Hadron-Level Standalone LHAup class works as well as an LHEF, with Hadron-Level Standalone Beams:frameType = 5. Hadron-Level Standalone The event information to store in the LHEF, or provide by the Hadron-Level Standalone LHAup , is essentially the same as above. The only difference is in status codes: outgoing particles should have 1 instead of 23, and intermediate resonances 2 instead of -22. Incoming partons, if any, are -1 instead of -21. Hadron-Level Standalone Extensions to resonance decays With the above scheme, Hadron-Level Standalone pythia.next() will generate hadronization, i.e. string fragmentation and subsequent decays of normal unstable particles. Alternatively it could be used to decay Hadron-Level Standalone resonances , i.e. Hadron-Level Standalone W, Z , top, Higgs, SUSY and other massive particles. Hadron-Level Standalone The default when a resonance is encountered is to decay it, let the decay products shower, and finally hadronize the partons. Should a decay sequence already be provided at input, this sequence will be used as input for the showers, which are handled consecutively, followed by hadronization. Thus, a Higgs could be provided alone, or decaying to a pair of Hadron-Level Standalone W bosons, or the same with the Hadron-Level Standalone W 's decaying further to fermion pairs. Needless to say, correct process-specific angular correlations in decays should not be expected when the process is unspecified. Hadron-Level Standalone If you do not want resonances to decay then you can use the Hadron-Level Standalone ProcessLevel:resonanceDecays = off setting. If instead you want them to decay but not shower, you can use either Hadron-Level Standalone PartonLevel:FSR = off or Hadron-Level Standalone PartonLevel:FSRinResonances = off. A warning here is that, generally, it is not a good idea to provide a part of the shower history but not all, e.g. Hadron-Level Standalone Z^0 &rarr; q qbar g : it is not straightforward to avoid doublecouning or other problems within this simpler alternative to a full-scale event generation. Hadron-Level Standalone The input configuration has to follow the rules described above, i.e. Hadron-Level Standalone ProcessLevel:all = off should be set for internal input, but is not necessary for LHEF input. It is possible to combine several resonances, and other coloured or uncoloured particles into the same event. Partonic daughters of resonances would then shower, but other partons not. It may be possible to fool the program, however, since this is not a fully tested core functionality, so don't combine wildly if there is no reason to. Hadron-Level Standalone Repeated hadronization or decay An alternative approach is possible with the Hadron-Level Standalone pythia.forceHadronLevel() routine. This method does a call to the Hadron-Level Standalone HadronLevel methods, irrespective of the value of the Hadron-Level Standalone HadronLevel:all flag. If you hadronize externally generated events it is equivalent to a Hadron-Level Standalone pythia.next() call with Hadron-Level Standalone ProcessLevel:all = off. Hadron-Level Standalone This method truly sticks to the hadron level, and thus cannot handle resonance decays. The real application instead is for repeated hadronization of the same PYTHIA process- and parton-level event. This may for some studies help to save time, given that these two first step are more time-consuming than the hadronization one. Hadron-Level Standalone For repeated hadronization you should first generate an event as usual, but with Hadron-Level Standalone HadronLevel:all = off. This event you can save in a temporary copy, e.g. Hadron-Level Standalone Event savedEvent = pythia.event. Inside a loop you copy back with Hadron-Level Standalone pythia.event = savedEvent , and call Hadron-Level Standalone pythia.forceHadronLevel() to obtain a new hadronization history. Hadron-Level Standalone A more limited form of repetition is if you want to decay a given kind of particle repeatedly, without having to generate the rest of the event anew. This could be the case e.g. in Hadron-Level Standalone B physics applications. Then you can use the Hadron-Level Standalone pythia.moreDecays() method, which decays all particles in the event record that have not been decayed but should have been done so. The Hadron-Level Standalone pythia.particleData.mayDecay( id, false/true) method may be used to switch off/on the decays of a particle species Hadron-Level Standalone id , so that it is not decayed in the Hadron-Level Standalone pythia.next() call but only inside a loop over a number of tries. Hadron-Level Standalone Between each loop the newly produced decay products must be removed and the decayed particle status restored to undecayed. The former is simple, since the new products are appended to the end of the event record: Hadron-Level Standalone event.saveSize() saves the initial size of the event record, and Hadron-Level Standalone event.restoreSize() can later be used repeatedly to restore this original size, which means that the new particles at the end are thrown away. The latter is more complicated, and requires the user to identify the positions of all particles of the species and restore a positive status code with Hadron-Level Standalone event[i].statusPos(). Hadron-Level Standalone The Hadron-Level Standalone main15.cc program illustrates both these methods, i.e. either repeated hadronization or repeated decay of PYTHIA events."},{"name":"Hard Process Selection","link":"ProcessSelection.html","text":"Hard Process Selection Hard Process Selection Hard Process Selection There is no way PYTHIA could contain all processes of interest, neither in terms of potential physics topics nor in terms of high-multiplicity final states. What exists is a reasonably complete setup of all Hard Process Selection 2 &rarr; 1 and Hard Process Selection 2 &rarr; 2 processes within the Standard Model, plus some examples of processes beyond that, again for low multiplicities. Combined with the PYTHIA parton showers, this should be enough to get a flying start in the study of many physics scenarios. Other processes could be fed in via the Hard Process Selection Les Houches Accord or Hard Process Selection Les Houches Event Files , or be implemented as a Hard Process Selection Semi-Internal Process. In the latter case the existing processes would act as obvious templates. Hard Process Selection By default all processes are switched off. You should switch on those you want to simulate. This may be done at two (occasionally three) levels, either for each individual process or for a group of processes. That is, a process is going to be generated either if its own flag or its group flag is on. There is no built-in construction to switch on a group and then switch off a few of its members. Hard Process Selection Each process is assigned an integer code. This code is not used in the internal administration of events (so having the same code for two completely different processes would not be a problem), but only intended to allow a simpler user separation of different processes. Also the process name is available, as a string. Hard Process Selection To ease navigation, the list of processes has been split into several separate pages, by main topic. The classification is hopefully intuitive, but by no means unambiguous. For instance, essentially all processes involve QCD, so the 'QCD processes' are the ones that only involve QCD. (And also that is not completely true, once one includes all that may happen in multiparton interactions.) On these separate pages also appear the settings that are completely local to that particular process class, but not the ones that have a broader usage. Hard Process Selection Hard Process Selection QCD Processes QCD processes fall in two main categories: soft and hard. The soft ones contain elastic, diffractive and 'minimum-bias' events, together covering the total cross section. Hard processes are the normal Hard Process Selection 2 &rarr; 2 ones, including charm and bottom production. Hard Process Selection Reserved code range: 101 - 199. Hard Process Selection Hard Process Selection Electroweak Processes Prompt-photon, Hard Process Selection gamma^*/Z^0 and Hard Process Selection W^+- production, plus a few processes with Hard Process Selection t -channel boson exchange. Hard Process Selection Reserved code range: 201 - 299. Hard Process Selection Hard Process Selection Onia Processes Colour singlet and octet production of charmonium and bottomonium. Hard Process Selection Reserved code range: 401 - 499 for charmonium and 501 - 599 for bottomonium. Hard Process Selection Hard Process Selection Top Processes Top production, singly or doubly. Hard Process Selection Reserved code range: 601 - 699. Hard Process Selection Hard Process Selection Fourth-Generation Processes Production of hypothetical fourth-generation fermions. Hard Process Selection Reserved code range: 801 - 899. Hard Process Selection Hard Process Selection Higgs Processes Higgs production, within or beyond the Standard Model. See section on Left-Right-Symmetry processes for doubly charged Higgs bosons. Hard Process Selection Reserved code range: 901 - 999 for a Standard Model Higgs and 1001 - 1199 for MSSM Higgs bosons. Hard Process Selection Hard Process Selection SUSY Processes Production of supersymmetric particles, currently barely begun. Hard Process Selection Reserved code range: 1001 - 2999. (Whereof 1001 - 1199 for Higgs bosons; see above.) Hard Process Selection Hard Process Selection New-Gauge-Boson Processes Production of new gauge bosons such as Hard Process Selection Z' and Hard Process Selection W'. Hard Process Selection Reserved code range: 3001 - 3099. Hard Process Selection Hard Process Selection Left-Right-Symmetry Processes Production of righthanded Hard Process Selection Z_R and Hard Process Selection W_R bosons and of doubly charged Higgs bosons. Hard Process Selection Reserved code range: 3101 - 3199. Hard Process Selection Hard Process Selection Leptoquark Processes Production of a simple scalar leptoquark state. Hard Process Selection Reserved code range: 3201 - 3299. Hard Process Selection Hard Process Selection Compositeness Processes Production of excited fermion states and contact-interaction modification to interactions between fermions (excluding technicolor; see below). Hard Process Selection Reserved code range: 4001 - 4099. Hard Process Selection Technicolor Processes Production of technicolor particles and modifications of QCD processes by technicolor interactions. Does not exist yet. Hard Process Selection Reserved code range: 4101 - 4199. Hard Process Selection Hard Process Selection Hidden Valley Processes A scenario for the pair production of new particles with couplings under a new gauge group, with invisible gauge bosons. Radiation of these gauge bosons is included in the standard final-state parton shower. Hard Process Selection Reserved code range: 4901 - 4999. Hard Process Selection Hard Process Selection Extra-Dimensional Processes A vast area, here represented by the production of a Randall-Sundrum excited graviton state and a Kaluza-Klein gluon, a Kaluza-Klein tower of Hard Process Selection gamma/Z^0 excitations in one TeV^- sized extra dimension, several Large Extra Dimension processes, and a few related Unparticle processes. Hard Process Selection Reserved code range: 5001 - 5099. Hard Process Selection Hard Process Selection Dark Matter Processes An area of increasing interest. Currently only represented by a few basic processes. Hard Process Selection Reserved code range: 6001 - 6099."},{"name":"Heavy Ion Collisions","link":"HeavyIons.html","text":"Heavy Ion Collisions Heavy Ion Collisions Heavy Ion Collisions PYTHIA does not normally handle collisions involving heavy ions, but it includes a facility where a model for combining several nucleon-nucleon collisions into one heavy ion collision can be implemented. One such model, called Heavy Ion Collisions Angantyr , is provided with PYTHIA and is inspired by the old Fritiof program from the Lund group Heavy Ion Collisions And87 with recent improvements Heavy Ion Collisions Bie16a (see below). Heavy Ion Collisions To allow for the generation of collisions with heavy ions, PYTHIA includes a handful of nuclei with PDG numbers on the form 100ZZZAAAI: Heavy Ion Collisions 4 He (1000020040), Heavy Ion Collisions 6 Li (1000030060), Heavy Ion Collisions 12 C (1000060120), Heavy Ion Collisions 16 O (1000080160), Heavy Ion Collisions 63 Cu (1000290630), Heavy Ion Collisions 129 Xe (1000541290), Heavy Ion Collisions 197 Au (1000791970), and Heavy Ion Collisions 208 Pb (1000822080), but more can be added using the function Heavy Ion Collisions ParticleData::addParticle. Heavy Ion Collisions If Heavy Ion Collisions HeavyIon:mode is on, the normal initialization in Heavy Ion Collisions Pythia::init() is early on diverted to an object with the base class Heavy Ion Collisions HeavyIons which may instantiate secondary Heavy Ion Collisions Pythia objects needed to generate different types of nucleon-nucleon collisions that can be merged together into a full heavy ion event. This is all done in the virtual Heavy Ion Collisions HeavyIons::init() function. Subsequent calls to Heavy Ion Collisions Pythia::next() will then also be diverted to the virtual function Heavy Ion Collisions HeavyIons::next() which will be responsible for building up the heavy ion collision. The final event will be available in the primary Heavy Ion Collisions Pythia object. Heavy Ion Collisions The Heavy Ion Collisions HeavyIon class is very simple and flexible and basically only specifies that the Heavy Ion Collisions HeavyIons::init() and Heavy Ion Collisions HeavyIons::next() functions are overridden in a subclass. But there are a few additional helper classes that should be generic enough to be used by any model implemented. Heavy Ion Collisions Heavy Ion Collisions The Heavy Ion Collisions Nucleon class represents a single nucleon in a nuclei. It can be a proton or a neutron ( Heavy Ion Collisions id() ), it has a position in impact parameter space ( Heavy Ion Collisions Vec2 ), both absolute ( Heavy Ion Collisions bPos() ) and relative to the nuclei ( Heavy Ion Collisions nPos() ), and optionally it can be in a particular state represented by a vector of real numbers which are completely model dependent. Heavy Ion Collisions The Heavy Ion Collisions SubCollision class represents a potential nucleon-nucleon  collision between a projectile and a target Heavy Ion Collisions Nucleon. Heavy Ion Collisions The Heavy Ion Collisions NucleusModel class is a base class for implementing a model for the distribution in impact parameter space of nucleons in a nucleus. There are two ready-made subclasses called Heavy Ion Collisions WoodsSaxonModel , implementing a standard Woods-Saxon distribution, and Heavy Ion Collisions GLISSANDOModel , implementing the more advanced model in Heavy Ion Collisions Bro09,Ryb14. Heavy Ion Collisions The Heavy Ion Collisions ImpactParameterGenerator is used to sample the impact parameter space for the colliding nuclei. The base class implements a Gaussian sampling, which means that the events produced will always be weighted. Other distributions can be implemented in subclasses. Heavy Ion Collisions The Heavy Ion Collisions SubCollisionModel is used to generate individual, potential nucleon-nucleon Heavy Ion Collisions SubCollision s. Two subclasses are available, one called Heavy Ion Collisions NaiveSubCollisionModel which treats nucleons as simple black disks, and one implementing a more advanced model called Heavy Ion Collisions DoubleStrikman described below. Heavy Ion Collisions The Heavy Ion Collisions HIInfo class contains information related to the generated heavy ion events. Heavy Ion Collisions The Heavy Ion Collisions HIUserHooks class is provided to simplify the customization of a model implemented as a Heavy Ion Collisions HeavyIons subclass. It can be used to eg. change the Heavy Ion Collisions ImpactParamerGenerator used, in a way similar to how the Heavy Ion Collisions UserHooks and Heavy Ion Collisions MergingHooks classes are used. Heavy Ion Collisions The default model in PYTHIA is called Angantyr and is inspired by the old Fritiof model Heavy Ion Collisions And86 with improvements described in Heavy Ion Collisions Bie16a. The main idea is to stack parton level events, corresponding to individual nucleon-nucleon sub-collisions, on top of each other and hadronise them together. Heavy Ion Collisions Heavy Ion Collisions Please note: although it is possible to use Heavy Ion Collisions Rope Hadronisation in heavy ion collisions, these two modules have not yet been validated to work properly together. Also the parameters in the model have not been properly tuned, so the results from running must not be taken as definitive predictions. Heavy Ion Collisions To determine which projectile nucleon interacts with which target nucleon, special care is taken to determine in which way the nucleons interact. In a standard Heavy Ion Collisions Glauber calculations one typicaly only cares about if a sub-collision is inelastic or not, but in Angantyr this is divided up, so that each inelastic sub-collision can either be single-diffractive, double-diffractive or absorptive (ie. non-diffractive). To achieve this, Angantyr uses a model with fluctuating radii of the nucleons resulting in a fluctuating nucleon-nucleon cross section inspired by the model by Strikman et al. Heavy Ion Collisions Alv13. The model for this includes a number of parameters which should be fitted to reproduce inclusive nucleon-nucleon cross sections. To be consistent, the values used comes from PYTHIA's internal model of Heavy Ion Collisions total cross sections. Heavy Ion Collisions The default model for nucleon fluctuations has three parameters, the general fitting machinery in Heavy Ion Collisions SubCollisionModel allows for up to eight parameters. Heavy Ion Collisions The fitting procedure in Heavy Ion Collisions SubCollisionModel is a kind of genetic algorith where a population of parameter values are allowed to evolve for a number of generations. In the end the the parameter set in the final population  which gives the best inclusive cross sections is picked. Eight different cross sections may be fitted to but it is possible to select only some of them: Heavy Ion Collisions After all possible nucleon-nucleon sub-collisions has been determined, they are ordered in increasing nucleon-nucleon impact parameter. This list is then gone through in order several time. First all absorptive sub-collisions are treated. One full nucleon-nucleon non-diffractive minimum bias event is generated for each possible absorptive sub-colision. These are also ordered in impact parameter. Note that one target nucleon can interact absorptively with several target nucleons, in a first round only those absorptive sub-collisions involving nucleons that have not already interacted absorptively are are assigned a non-diffractive event. Heavy Ion Collisions If PYTHIA is not set up to generate minimum bias events, one or more of the generated non-diffractive events will be replaced by events generated with the selected signal process, and the cross section reported will be modified accordingly. Heavy Ion Collisions In a second round only those potential absorptive sub-collisions are considered where one nucleon has already been assinged a full non-diffractive event. In the Angantyr model it is then assumed that the other nuclean will contribute to the final state as if it had just been diffractively excited. Therefore a corresponding single-diffractive event is generated, the elastically scattered beam particle is discarded and the rest is added to the previous non-diffractive event, shuffling a bit with the kinematics so that the total emergy and momentum is conserved. Heavy Ion Collisions To generate these single-diffraction events to emulate multiple absorptive sub-collisions a special Heavy Ion Collisions Pythia object is used. To allow flexibility this object need not have exactly the same settings as the the one generating events for normal single-diffraction sub-collisions. To manipulate this Heavy Ion Collisions Pythia object a special form of settings can be used. All settings available for Heavy Ion Collisions Heavy Ion Collisions Diffraction , Heavy Ion Collisions Heavy Ion Collisions MultipartonInteractions , Heavy Ion Collisions Heavy Ion Collisions PDF , Heavy Ion Collisions Heavy Ion Collisions SigmaDiffractive and Heavy Ion Collisions Heavy Ion Collisions PDF can be set separately for this Heavy Ion Collisions Pythia object by prefixing their names with Heavy Ion Collisions HI.  As an example, setting Heavy Ion Collisions HISigmaDiffractive:PomFlux and Heavy Ion Collisions HIPDF:PomSet will set the Heavy Ion Collisions SigmaDiffractive:PomFlux and Heavy Ion Collisions PDF:PomSet options for this Heavy Ion Collisions Pythia object. Heavy Ion Collisions After all absorptive sub-collisions have been dealt with, the diffractive and elastic sub-collisions are dealt with in a similar way. In the end there will be a number of parton level events which are finally stacked together, and then hadronised. Finally nucleus remnants constructed from the non-interacting nucleans, are added to complete the full nucleaus-nucleus collision."},{"name":"HelacOnia Processes","link":"HelacOniaProcesses.html","text":"HelacOnia Processes HelacOnia Processes HelacOnia Processes HelacOnia HelacOnia Processes Sha15 is an external package which provides automated calculations for heavy quarkonia production using NRQCD, similar in style to HelacOnia Processes MadGraph5 and the extension MadOnia, which is only available for MadGraph4. This can be useful when additional quarkonia processes other than the internal processes provided in HelacOnia Processes Onia are needed, including matrix elements which are not spin-averaged, as well as the ability to produce HelacOnia Processes n -leg matrix elements beyond the leading tree-level diagrams. The HelacOnia code can be downloaded from HelacOnia Processes HelacOnia Processes http://helac-phegas.web.cern.ch/helac-phegas/helac-onia.html , where only version 2 and above is compatible with PYTHIA. HelacOnia Processes Within HelacOnia, events can automatically be passed to PYTHIA for additional processing, e.g. showering, MPI, and hadronization. However, in many cases it may be simpler to produce HelacOnia events directly in PYTHIA. The HelacOnia Processes LHAupHelaconia class provided in HelacOnia Processes Pythia8Plugins/LHAHelaconia is designed to provide such utility. Here we will describe how this can be used to wrap the HelacOnia generator as a PYTHIA Les Houches interface. HelacOnia Processes Of course, HelacOnia can also output files of parton-level events according to the HelacOnia Processes LHEF standard, that can be read in and processed further by PYTHIA 8. This is the most commonly used approach, and requires no further description here. HelacOnia Processes HelacOnia executable inside PYTHIA The HelacOnia Processes Pythia::setLHAupPtr(LHAup* lhaUpPtr) method allows a Pythia generator to accept a pointer to an object derived from the HelacOnia Processes HelacOnia Processes LHAup base class. Such an object will be initialized from within Pythia, and be called repeatedly to generate the next parton-level event, using the LHA specification as a standard to transfer the relevant information back to Pythia. Properly constructed, the operation of an HelacOnia Processes LHAup object thus is almost completely hidden from the user, and generates events almost like an ordinary internal Pythia process. HelacOnia Processes The HelacOnia Processes LHAupHelaconia is precisely such a class, derived from HelacOnia Processes LHAup , that contains the code needed to wrap a HelacOnia executable. Thereby the generation of HelacOnia processes from within Pythia becomes straightforward. An explicit example is provided in HelacOnia Processes main35.cc. We describe some of the key elements used there and in the general case."},{"name":"HepMC Interface","link":"HepMCInterface.html","text":"HepMC Interface HepMC Interface HepMC Interface An interface to the HepMC HepMC Interface Dob01 standard event record format has been provided by M. Kirsanov. The code is stored in HepMC Interface include/Pythia8Plugins/HepMC2.h. To use it, the relevant libraries need to be linked, as explained in the HepMC Interface README file. Only version 2.06 (or later) of HepMC is supported, by agreement with the LHC experimental community. HepMC Interface The (simple) procedure to translate PYTHIA 8 events into HepMC ones is illustrated in the HepMC Interface main41.cc , HepMC Interface main42.cc and HepMC Interface main43.cc main programs. At the core is a call to the HepMC Interface HepMC::Pythia8ToHepMC::fill_next_event( pythia, hepmcevt, ievnum = -1) which takes a reference of the generator object and uses it, on the one hand, to read out and convert the event record in HepMC Interface pythia.event and, on the other hand, to extract and store parton-density (PDF), cross section and other information for the hard subprocess from HepMC Interface pythia.info. There is also an alternative form that does not requires access to the full HepMC Interface pythia object, but only the event record, at the expense of a reduced information storage, see below. HepMC Interface While PYTHIA always stores momenta in units of GeV, with HepMC Interface c = 1 , HepMC nowadays can be built either for MeV or GeV as default, a choice that can then be overridden on an event-by-event basis, see e.g. the HepMC Interface main41.cc code. When filling the HepMC event record, PYTHIA will convert to the unit specified for the current HepMC event record. HepMC Interface Also for length units there are choices, and again the PYTHIA interface will convert to the units set for the HepMC event record. Here the mm choice of PYTHIA seems to be shared by most other programs, and is HepMC default. HepMC Interface The status code is now based on the new standard introduced for HepMC 2.05, see the HepMC Interface Event::statusHepMC(...) conversion routine for details. HepMC Interface The current values from HepMC Interface pythia.info.sigmaGen() and HepMC Interface pythia.info.sigmaErr() are stored for each event, multiplied by HepMC Interface 10^9 to convert from mb to pb. Note that PYTHIA improves its accuracy by Monte Carlo integration in the course of the run, so the values associated with the last generated event should be the most accurate ones. If events also come with a dimensional weight, like in some Les Houches strategies, this weight is in units of pb. HepMC Interface Direct output to HepMC Provided that PYTHIA is properly linked to HepMC, implementation of the most common user case (run PYTHIA with a runcard, output HepMC) exists. The example HepMC Interface main93 implements this. The sample command file HepMC Interface main93.cmnd provides a good starting point. The line: HepMC Interface Main:writeHepMC = on is the switch needed to write a HepMC file. The example is then run with: HepMC Interface ./main93 -c main93.cmnd and a HepMC file is then written. HepMC Interface There are several other useful command line options to HepMC Interface main93. They are all displayed by running HepMC Interface ./main93 -h. HepMC Interface The public methods Here comes a complete list of all public methods of the HepMC Interface Pythia8ToHepMC class in the HepMC Interface HepMC ( HepMC Interface not HepMC Interface Pythia8 !) namespace. HepMC Interface The following paired methods can be used to set and get the status of some switches that modify the behaviour of the conversion routine. The HepMC Interface set methods have the same default input values as the internal initialization ones, so that a call without an argument (re)stores the default."},{"name":"Hidden Valley Processes","link":"HiddenValleyProcesses.html","text":"Hidden Valley Processes Hidden Valley Processes Hidden Valley Processes This Hidden Valley (HV) scenario has been developed specifically to allow the study of visible consequences of radiation in a hidden sector, by recoil effect. A key aspect is therefore that the normal timelike showering machinery has been expanded with a third kind of radiation, in addition to the QCD and QED ones. These three kinds of radiation are fully interleaved, i.e. evolution occurs in a common Hidden Valley Processes pT -ordered sequence. The scenario is described in Hidden Valley Processes Car10. Furthermore hadronization in the hidden sector has been implemented. Three main scenarios for production into and decay out of the hidden sector can be compared, in each case either for an Abelian or a non-Abelian gauge group in the HV. For further details see Hidden Valley Processes Car11. Hidden Valley Processes Warning : do not use the alternative hadronization scenarios Hidden Valley Processes StringPT:thermalModel = on or Hidden Valley Processes StringPT:mT2suppression = on in conjunction with Hidden Valley processes, since they have not been constructed to work together. Hidden Valley Processes Particle content and properties For simplicity we assume that the HV contains an unbroken Hidden Valley Processes SU(N) gauge symmetry. This is used in the calculation of production cross sections. These could be rescaled by hand for other gauge groups. Hidden Valley Processes A minimal HV particle content has been introduced. Firstly, there is a set of 12 particles that mirrors the Standard Model flavour structure, and is charged under both the SM and the HV symmetry groups. Each new particle couples flavour-diagonally to a corresponding SM state, and has the same SM charge and colour, but in addition is in the fundamental representation of the HV colour, as follows: Hidden Valley Processes Hidden Valley Processes Dv , identity 4900001, partner to the normal Hidden Valley Processes d quark; Hidden Valley Processes Hidden Valley Processes Uv , identity 4900002, partner to the normal Hidden Valley Processes u quark; Hidden Valley Processes Hidden Valley Processes Sv , identity 4900003, partner to the normal Hidden Valley Processes s quark; Hidden Valley Processes Hidden Valley Processes Cv , identity 4900004, partner to the normal Hidden Valley Processes c quark; Hidden Valley Processes Hidden Valley Processes Bv , identity 4900005, partner to the normal Hidden Valley Processes b quark; Hidden Valley Processes Hidden Valley Processes Tv , identity 4900006, partner to the normal Hidden Valley Processes t quark; Hidden Valley Processes Hidden Valley Processes Ev , identity 4900011, partner to the normal Hidden Valley Processes e lepton; Hidden Valley Processes Hidden Valley Processes nuEv , identity 4900012, partner to the normal Hidden Valley Processes nue neutrino; Hidden Valley Processes Hidden Valley Processes MUv , identity 4900013, partner to the normal Hidden Valley Processes mu lepton; Hidden Valley Processes Hidden Valley Processes nuMUv , identity 4900014, partner to the normal Hidden Valley Processes numu neutrino; Hidden Valley Processes Hidden Valley Processes TAUv , identity 4900015, partner to the normal Hidden Valley Processes tau lepton; Hidden Valley Processes Hidden Valley Processes nuTAUv , identity 4900016, partner to the normal Hidden Valley Processes nutau neutrino. Hidden Valley Processes Collectively we will refer to these states as Hidden Valley Processes Fv ; note, however, that they need not be fermions themselves. Hidden Valley Processes In addition the model contains the HV gauge particle, either a HV-gluon or a HV-photon, but not both; see Hidden Valley Processes Ngauge above: Hidden Valley Processes Hidden Valley Processes gv , identity 4900021, is the massless gauge boson of the HV Hidden Valley Processes SU(N) group; Hidden Valley Processes Hidden Valley Processes gammav , identity 4900022,  is the massless gauge boson of the HV Hidden Valley Processes U(1) group. Hidden Valley Processes Finally, for the basic HV scenario, there is a new massive particle with only HV charge sitting in the fundamental representation of the HV gauge group: Hidden Valley Processes Hidden Valley Processes qv , identity 4900101. Hidden Valley Processes The typical scenario would be for pair production of one of the states presented first above, e.g. Hidden Valley Processes g g &rarr; Dv Dvbar. Such a Hidden Valley Processes Dv can radiate gluons and photons like an SM quark, but in addition HV-gluons or HV-photons in a similar fashion. Eventually the Hidden Valley Processes Dv will decay like Hidden Valley Processes Dv &rarr; d + qv. The strength of this decay is not set as such, but is implicit in your choice of width for the Hidden Valley Processes Dv state. Thereafter the Hidden Valley Processes d and Hidden Valley Processes qv can radiate further within their respective sectors. The Hidden Valley Processes qv , Hidden Valley Processes gv or Hidden Valley Processes gammav are invisible, so their fate need not be considered further. Hidden Valley Processes While not part of the standard scenario, as an alternative there is also a kind of Hidden Valley Processes Z' resonance: Hidden Valley Processes Hidden Valley Processes Zv , identity 4900023, a boson that can couple both to pairs of Standard Model fermions and to Hidden Valley Processes qv qvbar pairs. Mass, total width and branching ratios can be set as convenient. Hidden Valley Processes This opens up for alternative processes Hidden Valley Processes l^+l^-, q qbar &rarr; Zv &rarr; qv qvbar. Hidden Valley Processes The possibility of a leakage back from the hidden sector will be considered in the Hadronization section below. For the Hidden Valley Processes U(1) case the Hidden Valley Processes gammav acquires a mass and can decay back to a Standard-Model fermion pair, while the Hidden Valley Processes qv remains invisible. The Hidden Valley Processes SU(N) alternative remains unbroken, so confinement holds and the Hidden Valley Processes gv is massless. A string like Hidden Valley Processes qv - gv - ... - gv - qvbar can break by the production of new Hidden Valley Processes qv - qvbar pairs, which will produce Hidden Valley Processes qv-qvbar mesons. It would be possible to build a rather sophisticated hidden sector by trivial extensions of the HV flavour content. For now, however, the Hidden Valley Processes qv can be duplicated in up to eight copies with the same properties except for the flavour charge. These are assigned codes 4900101 - 4900108. This gives a total of 64 possible lowest-lying mesons. We also include a duplication of that, into two multiplets, corresponding to the pseudoscalar and vector mesons of QCD. For now, again, these are assumed to have the same mass and other properties. By default, only the flavour-diagonal ones can decay back into the Standard-Model sector, however, while the rest remains in the hidden sector. It is therefore only necessary to distinguish a few states: Hidden Valley Processes Hidden Valley Processes pivDiag , identity 4900111, a flavour-diagonal HV-meson with spin 0 that can decay back into the Standard-Model sector; Hidden Valley Processes Hidden Valley Processes rhovDiag , identity 4900113, a flavour-diagonal HV-meson with spin 1 that can decay back into the Standard-Model sector; Hidden Valley Processes Hidden Valley Processes pivUp , identity 4900211, an off-diagonal HV-meson with spin 0 that is stable and invisible, with an antiparticle Hidden Valley Processes pivDn with identity -4900211; the particle is the one where the code of the flavour is larger than that of the antiflavour; Hidden Valley Processes Hidden Valley Processes rhovUp , identity 4900213, an off-diagonal HV-meson with spin 1 that is stable and invisible, with an antiparticle Hidden Valley Processes rhovDn with identity -4900213; again the particle is the one where the code of the flavour is larger than that of the antiflavour; Hidden Valley Processes Hidden Valley Processes ggv , identity 4900991, is only rarely used, to handle cases where it is kinematically impossible to produce an HV-meson on shell, and it therefore is assumed to de-excite by the emission of invisible Hidden Valley Processes gv-gv v-glueball bound states. Hidden Valley Processes By changing ParticleData, it is possible to allow decays even for the off-diagonal Up/Dn mesons. Hidden Valley Processes Only the spin of the HV-gluon or HV-photon is determined unambiguously to be unity, for the others you can make your choice. Hidden Valley Processes You should set the Hidden Valley Processes Fv and Hidden Valley Processes qv masses appropriately, with the latter smaller than the former two to allow decays. When Hidden Valley Processes U(1) hadronization is switched on, you need to set the Hidden Valley Processes gammav mass and decay modes. For Hidden Valley Processes SU(N) hadronization the HV-meson masses should be set to match the Hidden Valley Processes qv ones. The simplest is to assume that Hidden Valley Processes m_qv defines a constituent mass, so that Hidden Valley Processes m_HVmeson = 2 m_qv. The Hidden Valley Processes hvMesonDiag decay modes also need to be set. Hidden Valley Processes Production processes Hidden Valley Processes Timelike showers One key point of this HV scenario is that radiation off the HV-charged particles is allowed. This is done by the standard final-state showering machinery. (HV particles are not produced in initial-state radiation.) All the (anti)particles Hidden Valley Processes Fv and Hidden Valley Processes qv have one (negative) unit of HV charge. That is, radiation closely mimics the one in QCD. Both QCD, QED and HV radiation are interleaved in one common sequence of decreasing emission Hidden Valley Processes pT scales. Each radiation kind defines a set of dipoles, usually spanned between a radiating parton and its recoil partner, such that the invariant mass of the pair is not changed when a radiation occurs. This need not follow from trivial colour assignments, but is often obvious. For instance,  in a decay Hidden Valley Processes Qv &rarr; q + qv the QCD dipole is between the Hidden Valley Processes q and the hole after Hidden Valley Processes Qv , but Hidden Valley Processes qv becomes the recoiler should a radiation occur, while the role of Hidden Valley Processes q and Hidden Valley Processes qv is reversed for HV radiation. Hidden Valley Processes This also includes matrix-element corrections for a number of decay processes, with colour, spin and mass effects included Hidden Valley Processes Nor01. They were calculated within the context of the particle content of the MSSM, however, which does not include spin 1 particles with unit colour charge. In such cases spin 0 is assumed instead. By experience, the main effects come from mass and colour flow anyway, so this is not a bad approximation. (Furthermore the MSSM formulae allow for Hidden Valley Processes gamma_5 factors from wave functions or vertices; these are even less important.) Hidden Valley Processes An emitted Hidden Valley Processes gv can branch in its turn, Hidden Valley Processes gv &rarr; gv + gv. This radiation may affect momenta in the visible sector by recoil effect, but this is a minor effect relative to the primary emission of the Hidden Valley Processes gv. Hidden Valley Processes While the default model has a fixed Hidden Valley coupling Hidden Valley Processes alpha_HV , some further work Hidden Valley Processes Scw15 has considered the impact of a running coupling. This is included as an option. Hidden Valley Processes Hadronization By default the HV particles with no Standard Model couplings are not visible. Their presence can only be deduced by the observation of missing (transverse) momentum in the event as a whole. In the current implementation it is possible to simulate two different scenarios where activity can leak back from the hidden sector. Hidden Valley Processes The first possibility is relevant for the Hidden Valley Processes U(1) scenario. The Hidden Valley Processes U(1) group may be broken, so that the Hidden Valley Processes gammav acquires a mass. Furthermore, the Hidden Valley Processes gammav may have a small mixing angle with the normal photon, or with some Hidden Valley Processes Z' state or other mediator, and may thus decay back into Standard Model particles. The Hidden Valley Processes qv still escapes undetected; recall that there is no confinement in the Hidden Valley Processes U(1) option. Hidden Valley Processes In order to enable this machinery two commands are necessary, Hidden Valley Processes 4900022:m0 = ... to set the Hidden Valley Processes gammav mass to the desired value, and Hidden Valley Processes 4900022:onMode = on to enable Hidden Valley Processes gammav decays. The default Hidden Valley Processes gammav decay table contains all Standard Model fermion-antifermion pairs, except top, with branching ratios in proportion to their coupling to the photon, whenever the production channel is allowed by kinematics. This table could easily be tailored to more specific models and needs. For instance, for a mass below 1 - 2 GeV, it would make sense to construct a table of exclusive hadronic decay channels rather than go the way via a hadronizing quark pair. Hidden Valley Processes The Hidden Valley Processes gammav are expected to decay so rapidly that no secondary vertex will be detectable. However, it is possible to set Hidden Valley Processes 4900022:tau0 to a finite lifetime (in mm) that will be used to create separated secondary vertices. Hidden Valley Processes The second, more interesting, possibility is relevant for the Hidden Valley Processes SU(N) scenarios. Here the gauge group remains unbroken, i.e. Hidden Valley Processes gv is massless, and the partons are confined. Like in QCD, the HV-partons can therefore be arranged in one single HV-colour-ordered chain, with a Hidden Valley Processes qv in one end, a Hidden Valley Processes qvbar in the other, and a varying number of Hidden Valley Processes gv in between. Each event will only contain (at most) one such string, (i) since perturbative branchings Hidden Valley Processes gv &rarr; qv qvbar have been neglected, as is a reasonable approximation for QCD, and (ii) since HV-colours are assigned in the Hidden Valley Processes N_C &rarr; infinity limit, just like in the handling of string fragmentation in QCD. The HV-string can then fragment by the nonperturbative creation of Hidden Valley Processes qv qvbar pairs, leading to the formation of HV-mesons along the string, each with its Hidden Valley Processes qv from one vertex and its Hidden Valley Processes qvbar from the neighbouring one. Hidden Valley Processes Since, so far, we have only assumed there to be one Hidden Valley Processes qv species, all produced Hidden Valley Processes qv qvbar HV-mesons are of the same flavour-diagonal species. Such an HV-meson can decay back to the normal sector, typically by whatever mediator particle allowed production in the first place. In this framework the full energy put into the HV sector will leak back to the normal one. To allow more flexibility, an ad hoc possibility of Hidden Valley Processes n_Flav different Hidden Valley Processes qv species is introduced. For now they are all assumed to have the same mass and other properties, but distinguished by some flavour-like property. Only the flavour-diagonal ones can decay, meaning that only a fraction (approximately) Hidden Valley Processes 1/n_Flav of the HV-energy leaks back, while the rest remains in the hidden sector. Hidden Valley Processes This scenario contains more parameters than the first one, for the Hidden Valley Processes U(1) group. They can be subdivided into two sets. One is related to particle properties, both for Hidden Valley Processes qv and for the two different kinds of HV-mesons, here labeled 4900111 and 4900113 for the diagonal ones, and +-4900211 and +-4900213 for the off-diagonal ones. It makes sense to set the HV-meson masses to be twice the Hidden Valley Processes qv one, as in a simple constituent mass context. Furthermore the Hidden Valley Processes hvMesonDiag decay modes need to be set up. Like with the Hidden Valley Processes gammav in the Hidden Valley Processes U(1) option, the default decay table is based on the branching ratios of an off-shell photon. Hidden Valley Processes The second set are fragmentation parameters that extend or replace the ones used in normal string fragmentation. Some of them are not encoded in the same way as normally, however, but rather scale as the Hidden Valley Processes qv mass is changed, so as to keep a sensible default behaviour. This does not mean that deviations from this set should not be explored, or that other scaling rules could be preferred within alternative scenarios. These parameters are as follows."},{"name":"Higgs Processes","link":"HiggsProcesses.html","text":"Higgs Processes Higgs Processes Higgs Processes This page documents Higgs production within and beyond the Standard Model (SM and BSM for short). This includes several different processes and, for the BSM scenarios, a large set of parameters that would only be fixed within a more specific framework such as MSSM. Some choices can be made irrespective of the particular model: Higgs Processes One setting is specific to the Standard Model: Higgs Processes Standard-Model Higgs, basic processes This section provides the standard set of processes that can be run together to provide a reasonably complete overview of possible production channels for a single SM Higgs. The main parameter is the choice of Higgs mass, which can be set in the normal Higgs Processes ParticleData database; thereafter the properties within the SM are essentially fixed. Higgs Processes Standard-Model Higgs, further processes A number of further production processes has been implemented, that are specializations of some of the above ones to the high- Higgs Processes pT region. The sets therefore could not be used simultaneously without unphysical double-counting, as further explained below. They are not switched on by the Higgs Processes HiggsSM:all flag, but have to be switched on for each separate process after due consideration. Higgs Processes The first three processes in this section are related to the Higgs point coupling to fermions, and so primarily are of interest for Higgs Processes b quarks. It is here useful to begin by reminding that a process like Higgs Processes b bbar &rarr; H^0 implies that a Higgs Processes b/bbar is taken from each incoming hadron, leaving behind its respective antiparticle. The initial-state showers will then add one Higgs Processes g &rarr; b bbar branching on either side, so that effectively the process becomes Higgs Processes g g &rarr; H0 b bbar. This would be the same basic process as the Higgs Processes g g &rarr; H^0 t tbar one used for top. The difference is that (a) no PDF's are defined for top and (b) the shower approach would not be good enough to provide sensible kinematics for the Higgs Processes H^0 t tbar subsystem. By contrast, owing to the Higgs Processes b being much lighter than the Higgs, multiple gluon emissions must be resummed for Higgs Processes b , as is done by PDF's and showers, in order to obtain a sensible description of the total production rate,  when the Higgs Processes b quarks predominantly are produced at small Higgs Processes pT values. Higgs Processes The second set of processes are predominantly first-order corrections to the Higgs Processes g g &rarr; H^0 process, again dominated by the top loop. We here only provide the kinematical expressions obtained in the limit that the top quark goes to infinity, but scaled to the finite-top-mass coupling in Higgs Processes g g &rarr; H^0. (Complete loop expressions are available e.g. in PYTHIA 6.4 but are very lengthy.) This provides a reasonably accurate description for 'intermediate' Higgs Processes pT values, but fails when the Higgs Processes pT scale approaches the top mass. Higgs Processes Beyond-the-Standard-Model Higgs, introduction Further Higgs multiplets arise in a number of scenarios. We here concentrate on the MSSM scenario with two Higgs doublets, but with flexibility enough that also other two-Higgs-doublet scenarios could be represented by a suitable choice of parameters. Conventionally the Higgs states are labeled Higgs Processes h^0, H^0, A^0 and Higgs Processes H^+-. If the scalar and pseudocalar states mix the resulting states are labeled Higgs Processes H_1^0, H_2^0, H_3^0. In process names and parameter explanations both notations will be used, but for settings labels we have adapted the shorthand hybrid notation Higgs Processes H1 for Higgs Processes h^0(H_1^0) , Higgs Processes H2 for Higgs Processes H^0(H_2^0) and Higgs Processes A3 for Higgs Processes A^0(H_3^0). (Recall that the Higgs Processes Settings database does not distinguish upper- and lowercase characters, so that the user has one thing less to worry about, but here it causes problems with Higgs Processes h^0 vs. Higgs Processes H^0 .) We leave the issue of mass ordering between Higgs Processes H^0 and Higgs Processes A^0 open, and thereby also that of Higgs Processes H_2^0 and Higgs Processes H_3^0. Higgs Processes Beyond-the-Standard-Model Higgs, basic processes This section provides the standard set of processes that can be run together to provide a reasonably complete overview of possible production channels for a single neutral Higgs state in a two-doublet scenarios such as MSSM. The list of processes for neutral states closely mimics the one found for the SM Higgs. Some of the processes vanish for a pure pseudoscalar Higgs Processes A^0 , but are kept for flexibility in cases of mixing with the scalar Higgs Processes h^0 and Higgs Processes H^0 states, or for use in the context of non-MSSM models. This should work well to represent e.g. that a small admixture of the 'wrong' parity would allow a process such as Higgs Processes q qbar &rarr; A^0 Z^0 , which otherwise is forbidden. However, note that the loop integrals e.g. for Higgs Processes g g &rarr; h^0/H^0/A^0 are hardcoded to be for scalars for the former two particles and for a pseudoscalar for the latter one, so absolute rates would not be correctly represented in the case of large scalar/pseudoscalar mixing. Higgs Processes 1) Higgs Processes h^0(H_1^0) processes Higgs Processes 2) Higgs Processes H^0(H_2^0) processes Higgs Processes 3) Higgs Processes A^0(H_3^0) processes Higgs Processes 4) Higgs Processes H+- processes Higgs Processes 5) Higgs-pair processes Higgs Processes Beyond-the-Standard-Model Higgs, further processes This section mimics the above section on 'Standard-Model Higgs, further processes', i.e. it contains higher-order corrections to the processes already listed. The two sets therefore could not be used simultaneously without unphysical double-counting. They are not controlled by any group flag, but have to be switched on for each separate process after due consideration. We refer to the standard-model description for a set of further comments on the processes. Higgs Processes 1) Higgs Processes h^0(H_1^0) processes Higgs Processes 2) Higgs Processes H^0(H_2^0) processes Higgs Processes 3) Higgs Processes A^0(H_3^0) processes Higgs Processes Parameters for Beyond-the-Standard-Model Higgs production and decay This section offers a big flexibility to set couplings of the various Higgs states to fermions and gauge bosons, and also to each other. The intention is that, for scenarios like MSSM, you should use standard input from the Higgs Processes SUSY Les Houches Accord , rather than having to set it all yourself. In other cases, however, the freedom is there for you to use. Kindly note that some of the internal calculations of partial widths from the parameters provided do not include mixing between the scalar and pseudoscalar states. Higgs Processes Masses would be set in the Higgs Processes ParticleData database, while couplings are set below. When possible, the couplings of the Higgs states are normalized to the corresponding coupling within the SM. When not, their values within the MSSM are indicated, from which it should be straightforward to understand what to use instead. The exception is some couplings that vanish also in the MSSM, where the normalization has been defined in close analogy with nonvanishing ones. Some parameter names are asymmetric but crossing can always be used, i.e. the coupling for Higgs Processes A^0 &rarr; H^0 Z^0 obviously is also valid for Higgs Processes H^0 &rarr; A^0 Z^0 and Higgs Processes Z^0 &rarr; H^0 A^0. Note that couplings usually appear quadratically in matrix elements. Higgs Processes Another set of parameters are not used in the production stage but exclusively for the description of angular distributions in decays."},{"name":"Histograms","link":"Histograms.html","text":"Histograms Histograms Histograms The Histograms Hist class gives a simple implementation of one-dimensional histograms, useful for quick-and-dirty testing, without the need to link to more sophisticated packages. For this reason it is used in many of the Histograms sample main programs found in the Histograms examples subdirectory. Histograms Basic principles We here provide a simple overview of what is involved. As a first step you need to declare a histogram, with name, title, number of bins and Histograms x range (from, to). Histograms Hist ZpT( 'Z0 pT spectrum', 100, 0., 100.); Alternatively you can first declare it and later define it: Histograms Hist ZpT;   ZpT.book( 'Z0 pT spectrum', 100, 0., 100.); Once declared, its contents can be added by repeated calls to Histograms fill , Histograms ZpT.fill( 22.7, 1.); where the first argument is the Histograms x value and the second the weight. Since the weight defaults to 1 the last argument could have been omitted in this case. Histograms A set of overloaded operators have been defined, so that histograms can be added, subtracted, divided or multiplied by each other. Then the contents are modified accordingly bin by bin. Thus the relative deviation between two histograms Histograms data and Histograms theory can be found as Histograms diff = (data - theory) / (data + theory); assuming that Histograms diff , Histograms data and Histograms theory have been booked with the same number of bins and Histograms x range. That responsibility rests on the user; some checks are made for compatibility, but not enough to catch all possible mistakes. Histograms Also overloaded operations with double real numbers are available. Again these four operations are defined bin by bin, i.e. the corresponding amount is added to, subtracted from, multiplied by or divided by each bin. The double number can come before or after the histograms, with obvious results. Thus the inverse of a histogram Histograms result is given by Histograms 1. / result. The two kind of operations can be combined, e.g. Histograms allpT = ZpT + 2. * WpT Finally, also the Histograms +=, -+, *=, /= are overloaded, with the right-hand side being either a histogram or a real number. Histograms Basic output format A histogram can be printed by making use of the overloaded << operator, e.g.: Histograms cout << ZpT; The printout format is inspired by the old HBOOK one. To understand how to read this format, consider the simplified example Histograms 3.50*10^ 2  9      3.00*10^ 2  X  7      2.50*10^ 2  X  1X      2.00*10^ 2  X6 XX      1.50*10^ 2  XX5XX      1.00*10^ 2  XXXXX      0.50*10^ 2  XXXXX        Contents         *10^ 2  31122         *10^ 1  47208         *10^ 0  79373        Low edge  --         *10^ 1  10001         *10^ 0  05050 The key feature is that the Histograms Contents and Histograms Low edge have to be read vertically. For instance, the first bin has the contents Histograms 3 * 10^2 + 4 * 10^1 + 7 * 10^0 = 347. Correspondingly, the other bins have contents 179, 123, 207 and 283. The first bin stretches from Histograms -(1 * 10^1 + 0 * 10^0) = -10 to the beginning of the second bin, at Histograms -(0 * 10^1 + 5 * 10^0) = -5. Histograms The visual representation above the contents give a simple impression of the shape. An Histograms X means that the contents are filled up to this level, a digit in the topmost row the fraction to which the last level is filled. So the 9 of the first column indicates this bin is filled 9/10 of the way from Histograms 3.00*10^2 = 300 to Histograms 3.50*10^2 = 350 , i.e. somewhere close to 345, or more precisely in the range 342.5 to 347.5. Histograms The printout also provides some other information, such as the number of entries, i.e. how many times the histogram has been filled, the total weight inside the histogram, the total weight in underflow and overflow, and the mean value and root-mean-square width (disregarding underflow and overflow). The mean and width assumes that all the contents is in the middle of the respective bin. This is especially relevant when you plot a integer quantity, such as a multiplicity. Then it makes sense to book with limits that are half-integers, e.g. Histograms Hist multMPI( 'number of multiparton interactions', 20, -0.5, 19.5); so that the bins are centered at 0, 1, 2, ..., respectively.  This also avoids ambiguities which bin gets to be filled if entries are exactly at the border between two bins. Also note that the Histograms fill( xValue) method automatically performs a cast to double precision where necessary, i.e. Histograms xValue can be an integer. Histograms Matplotlib output format Assuming you have Python installed on your platform, it is possible to generate simple Histograms Matplotlib/Pyplot Python code from the histograms generated above, which then can be run to produce PDF plots. This should be done near the end of a run, after the histograms have been filled and properly normalized, as an alternative or complement to the basic output format above. Histograms In  a first step you must then decide on the name of the Python program, e.g.: Histograms HistPlot hpl( 'bosonpT'); where file ending Histograms .py is added automatically. Histograms For each new frame the name should be given, which will later give rise to a PDF file, with ending Histograms .pdf added automatically. If you leave the name field empty the same file will be used as for the latest named one, i.e. producing several frames in one file. One can optionally also give title and Histograms x and Histograms y axis labels: Histograms hpl.frame( 'pTdist', 'Boson pT distributions', 'pT (GeV)', 'sigma'); Next, existing Histograms Hist histograms can be added to the frame, one by one: Histograms hpl.add( ZpT, '-');  hpl.add( WpT, '--,indigo');  hpl.add( ZpT + 2. * WpT , '', 'pT spectrum of Z, W+ and W-'); where the second argument tells how each histogram will be plotted. Default is histogram style, 'h', but the values can also be connected with full lines '-', dashed ones '--', or dash-dotted ones '-.', or plotted as points '.' or crosses 'x', to mention some of the many options offered by Pyplot. Here you can also specify the colour, separated by a comma from the line style, to override the normal colour cycle. The most common colours can be given just as a single letter, such as 'r', 'g', 'b', but a more extensive Histograms colour palette allow finetuning to nuances such as 'orange', 'gold', 'darkgreen', 'royalblue', 'crimson', and so on. A third argument can set the legend of each histogram; by default it is taken as the title of histogram. Histograms Finally the plot code itself will be set up by Histograms hpl.plot(); where optionally it is possible to demand a logarithmic Histograms y scale. Histograms The Histograms frame - add - plot steps can be repeated as needed, each giving rise to a separate PDF file with a plot. In case a plot is to be generated from a single histogram the three steps can be joined into one Histograms hpl.plotFrame( 'onlyZ', ZpT ); where only the name of the PDF file and the histogram are compulsory, while further arguments as discussed above are optional. Histograms At the end, a file Histograms bosonpT.py has now been generated with the proper plotting commands. Additionally a data file has been generated for each histogram to be plotted, Histograms pTdist-0.dat, pTdist-1.dat , etc. Now doing Histograms python bosonpT.py in a terminal window will produce the plots, such as Histograms pTdist.pdf and Histograms onlyZ.pdf. You may of course edit the python file further to improve on the finer details. Histograms Examples are provided in Histograms main03.cc and Histograms main07.cc , where the latter is the simpler one. The Histograms main51.cc example illustrates that the Histograms x scale can be chosen logarithmically, by using an optional last argument when histograms are booked. Histograms The methods We here collect a more complete and formal overview of the methods."},{"name":"Implement New Matching/Merging schemes","link":"ImplementNewMatching.html","text":"Implement New Matching/Merging schemes Implement New Matching/Merging schemes Implementing an external ME+PS combination scheme and interfacing this plugin with Pythia For experts and developers of new matching/merging schemes, Pythia also offers the possibility to completely replace its internal merging machinery with a user-defined plugin code (much in the same way that parton shower plugins (cf. Implement New Matching/Merging schemes Implement New Showers ) are possible). This allows for maximum flexibility while still benefiting from the full Pythia event generation machinery. Note that the ME+PS merging with the VINCIA and DIRE shower plugins make use of this flexibility, and might thus provide helpful clarifications.  Of course, implementing your own, new matching/merging scheme is a non-trivial task, and comprehensive guidelines on how to proceed are impossible to set. However, it is important that an external matching/merging plugin interfaces to Pythia in a simple and well-defined manner. Here, we will document which C++ functions are necessary to be able to use an external matching/merging (MM) plugin within Pythia. Implement New Matching/Merging schemes To understand how to design a MM plugin for Pythia, it is useful to review how Pythia's internal merging machinery is structured. The interaction between the core Pythia and the merging code is governed by the Implement New Matching/Merging schemes Merging and Implement New Matching/Merging schemes MergingHooks classes. Note that for moderately complex requirements, it may be sufficient to only replace Pythia's instance of Implement New Matching/Merging schemes MergingHooks with a pointer to an external class (cf. Implement New Matching/Merging schemes CKKW-L merging ). The latter two classes are supplemented with the helper classes Implement New Matching/Merging schemes History and Implement New Matching/Merging schemes HardProcess. The latter gathers information on the (user-supplied information about the) hard core scattering process to which hard jets are added by ME+PS merging. It is only used as a helper to the Implement New Matching/Merging schemes MergingHooks class. The Implement New Matching/Merging schemes History class contains the implementation of all internal (LO or NLO) merging schemes. The Implement New Matching/Merging schemes Merging class acts as a bridge between the implementation in the Implement New Matching/Merging schemes History class and the rest of the Pythia code. Implement New Matching/Merging schemes To implement an external MM plugin, you will have to write classes that derive from the Implement New Matching/Merging schemes Merging , Implement New Matching/Merging schemes MergingHooks and Implement New Matching/Merging schemes HardProcess classes of Pythia. For special cases, it might also be permissible to only implement a replacement of the Implement New Matching/Merging schemes Merging class, while still using Pythia's implementation of the other two classes.  The external MM plugin can then be transferred to and used by Pythia much in the same way as Implement New Matching/Merging schemes UserHooks classes or shower plugins. More concretely, an external MM code will be used if a pointer to an instance of the external classes is transferred to Pythia via the methods Implement New Matching/Merging schemes The option to only use a user-defined Implement New Matching/Merging schemes MergingHooks instance is already documented in the item Implement New Matching/Merging schemes CKKW-L merging and will not be discussed further. We will now focus on how to implement external Implement New Matching/Merging schemes Merging , Implement New Matching/Merging schemes MergingHooks and Implement New Matching/Merging schemes HardProcess classes that can be used as a complete replacement of the Pythia methods.  Let us assume that you want to create a class of type Implement New Matching/Merging schemes MyMerging , and you call its instance Implement New Matching/Merging schemes myMerging. For this external ME+PS merging class to be interfaced to Pythia, the class needs to inherit from the Implement New Matching/Merging schemes Pythia8::Merging base class. It is further necessary to define the following functions that serve as interface to Pythia: Implement New Matching/Merging schemes For more details on how to design your Implement New Matching/Merging schemes MyMerging class, and to understand the interface to Pythia, studying Pythia's internal code is unavoidable. Each potential developer of a MM plugin should do so. Implement New Matching/Merging schemes The other main ingredient of the interface to MM plugins is a new implementation of the Implement New Matching/Merging schemes MergingHooks class. Let us assume that you want to create a class of type Implement New Matching/Merging schemes MyMergingHooks , and you call its instance Implement New Matching/Merging schemes myMergingHooks. For this class to be interfaced to Pythia, it will need to inherit from the Implement New Matching/Merging schemes Pythia8::MergingHooks base class. Implement New Matching/Merging schemes The Implement New Matching/Merging schemes MergingHooks base class allows for further virtual functions that are not directly called by Pythia, and are hence not necessary to define. Th usage of these functions within Pythia's Implement New Matching/Merging schemes Merging and Implement New Matching/Merging schemes History classes is documented in Implement New Matching/Merging schemes CKKW-L merging. The additional (optional) virtual functions are: Implement New Matching/Merging schemes The internal implementation of Implement New Matching/Merging schemes MergingHooks in Pythia heavily relies on the Implement New Matching/Merging schemes HardProcess helper class. It is in principle not necessary to follow the same strategy when implementing a derived Implement New Matching/Merging schemes MyMergingHooks class. However, to benefit from the Pythia implementation, and to allow for a structure similar to the internal code also for an external MM plugin, it is also possible to effectively replace (in the Implement New Matching/Merging schemes MergingHooks class) the pointer to an instance of Implement New Matching/Merging schemes HardProcess with a pointer to an external implementation. Let us assume that you want to create a class of type Implement New Matching/Merging schemes MyHardProcess , and you call its instance Implement New Matching/Merging schemes myHardProcess. For this class to be interfaced to Implement New Matching/Merging schemes MergingHooks (or the derived Implement New Matching/Merging schemes MyMergingHooks class), it will need to inherit from the Implement New Matching/Merging schemes Pythia8::HardProcess base class."},{"name":"Implement New Showers","link":"ImplementNewShowers.html","text":"Implement New Showers Implement New Showers Implement New Showers In case you want to replace the PYTHIA initial- and final-state showers by your own, it is possible but not trivial. The point is that multiparton interactions (MPI), initial-state radiation (ISR) and final-state radiation (FSR) in general appear in one single interleaved sequence of decreasing Implement New Showers pT values. Therefore shower replacements would have to be able to play the game by such rules, as we will outline further below. Of course, this still leaves the field open exactly how to define what to mean by Implement New Showers pT , how to handle recoil effects, how the colour flow is affected, and so on, so there is certainly room for alternative showers. A first example of a shower implemented within the PYTHIA context is Implement New Showers VINCIA. Implement New Showers For the moment we assume you want to keep the MPI part of the story unchanged, and make use of the existing beam-remnants (BR) machinery. If you want to replace both MPI, ISR, FSR and BR then you had better replace the whole Implement New Showers PartonLevel module of the code. If, in addition, you want to produce your own hard processes, then you only need the Implement New Showers hadron-level standalone part of the machinery. Implement New Showers In order to write replacement codes for ISR and/or FSR it is useful to be aware of which information has to be shared between the different components, and which input/output structure is required of the relevant methods. For details, nothing beats studying the existing code. However, here we provide an overview, that should serve as a useful introduction. Implement New Showers It should be noted that we here primarily address the problem in its full generality, with interleaved MPI, ISR and FSR. There exists an option Implement New Showers TimeShower:interleave = off where only MPI and ISR would be interleaved and FSR be considered after these two, but still before BR. Most of the aspects described here would apply also for that case. By contrast, resonance decays are only considered after all the four above components, and timelike showers in those decays would never be interleaved with anything else, so are much simpler to administrate. Implement New Showers Therefore the Implement New Showers Implement New Showers pythia.setShowerPtr( timesDecPtr, timesPtr, spacePtr) method allows two separate pointers to be set to instances of derived Implement New Showers TimeShower classes. The first is only required to handle decays, say of Implement New Showers Z^0 or Implement New Showers Upsilon , with no dependence on beam remnants or ISR. The second, as well as Implement New Showers spacePtr , has to handle the interleaved evolution of MPI, ISR and FSR. Therefore you are free to implement only the first, and let the PYTHIA default showers take care of the latter two. But, if you wanted to, you could also set Implement New Showers timesDecPtr = 0 and only provide a Implement New Showers timesPtr , or only a Implement New Showers spacePtr. If your timelike shower does both cases, the first two pointers can agree. The only tiny point to take into account then is that Implement New Showers init( beamAPtr, beamBPtr) is called twice, a first time to Implement New Showers timesDecPtr with beam pointers 0, and a second time to Implement New Showers timesPtr with nonvanishing beam pointers. Implement New Showers The event record and associated information Obviously the main place for sharing information is the event record, specifically the Implement New Showers Event event member of Implement New Showers Pythia , passed around as a reference. It is assumed you already studied how it works, so here we only draw attention to a few aspects of special relevance. Implement New Showers One basic principle is that existing partons should not be overwritten. Instead new partons should be created, even when a parton only receives a slightly shifted momentum and for the rest stays the same. Such 'carbon copies' by final-state branchings should be denoted by both daughter indices of the original parton pointing to the copy, and both mother indices of the copy to the original. If the copy instead is intended to represent an earlier step, e.g. in ISR backwards evolution, the role of mothers and daughters is interchanged. The Implement New Showers event.copy( iCopy, newStatus) routine can take care of this tedious task; the sign of Implement New Showers newStatus tells the program which case to assume. Implement New Showers To make the event record legible it is essential that the Implement New Showers status codes are selected appropriately to represent the reason why each new parton is added to the record. Also remember to change the status of a parton to be negative whenever an existing parton is replaced by a set of new daughter partons. Implement New Showers Another important parton property is Implement New Showers scale() , which does not appear in the normal event listing, but only if you use the extended Implement New Showers Event:listScaleAndVertex = on option. This property is supposed to represent the production scale (in GeV) of a parton. In the current FSR and ISR algorithms it is used to restrict from above the allowed Implement New Showers pT values for branchings of this particular parton. Beam remnants and other partons that should not radiate are assigned scale 0. Implement New Showers Auxiliary to the event record proper is the Implement New Showers Implement New Showers PartonSystems class, that keep track of which partons belong together in the same scattering subsystem. This information must be kept up-to-date during the shower evolution. Implement New Showers For initial-state showers it is also necessary to keep track of the partonic content extracted from the beams. This information is stored in the Implement New Showers Implement New Showers BeamParticle class. Implement New Showers The TimeShower interface If you want to replace the Implement New Showers TimeShower class this would involve replacing the virtual methods among the following ones. Implement New Showers One of the major complications when combining fixed-order calculations with parton showers comes from constructing a parton shower history. This crucial step requires very precise knowledge of the functional forms of the evolution variable (e.g. transverse momentum), the auxiliary variable (e.g. an energy sharing variable), as well as the parton shower splitting probabilities and the (inverse) parton shower momentum mapping. All of these are readily available within the parton shower, but can be difficult to reconstruct, particularly if non-general improvements are included in the parton shower. To minimise code proliferation and bug potential, the timelike showers contain easy-access functions that can be loaded directly from PYTHIA's merging machinery. Note that within a new shower, you do not need to use these functions or all of the inputs transferred to these functions. Any dummy definition is acceptable. Implement New Showers The easy-access functions are listed in the following. They use some common terminology, wherein Implement New Showers iRad is the position in the event record of the radiating parton, Implement New Showers iRec is the position of the recoiling partner of the dipole, which ensures overall energy and momentum conservation in the splitting, and Implement New Showers iEmt is the position of the radiated parton, all after the splitting. (The ones before are stored in Implement New Showers iRadBef and Implement New Showers iRecBef , not used here.) Obviously the distinctions between Implement New Showers iRad and Implement New Showers iEmt , or between Implement New Showers iRad and Implement New Showers iRec , are a matter of choice. Implement New Showers The SpaceShower interface If you want to replace the Implement New Showers SpaceShower class this would involve replacing the virtual methods in the following. You will find that much of the story reminds of Implement New Showers TimeShower above, and actually some cut-and-paste of text is involved. In some respects the description is simpler, since there are no special cases for resonance decays and non-interleaved evolution. Thus there is no correspondence to the Implement New Showers TimeShower::shower(...) routine. Implement New Showers As mentioned at the end of the section on timelike showers, it can be beneficial to merging and matching machinery of PYTHIA if some additional functionality is available. This in particular includes easy access to a) the evolution variable, b) the auxiliary (energy-sharing) variable, c) to parton shower splitting probabilities and d) to the (inverse) parton shower momentum mapping. Thus, as in the timelike case, it can be beneficial to define the functions"},{"name":"Jet Finders","link":"JetFinders.html","text":"Jet Finders Jet Finders Jet Finders Jet Finders Pythia comes with three Jet Finders built-in jet finders , Jet Finders ClusterJet for Jet Finders e^+e^- events and Jet Finders SlowJet and Jet Finders CellJet for hadron collider ones. Especially the latter is not so well matched to the standards of its field, however. (But it is closely related to the anti- Jet Finders kT algorithm, so is also not completely disconnected Jet Finders Cac08 .) Jet Finders Jet Finders SlowJet can do jet finding according to the current-day Jet Finders kT , Cambridge/Aachen and anti- Jet Finders kT algorithms. It can be run in two modes. The original one is a native implementation which, as the name indicates, is rather slow. However, with the release of the Jet Finders fjcore code from Jet Finders FastJet Jet Finders Cac06, Cac12 , the default mode has become to use the Jet Finders fjcore methods. This is transparent to the user. Jet Finders FastJet Jet Finders SlowJet does not exhaust all the posssibilities of the Jet Finders fjcore code, so users are welcome to extend on the existing functionality by a direct usage of the Jet Finders fjcore methods. Jet Finders Missing from Jet Finders fjcore is a number of aspects, such as jet areas functionality, background estimation, access to other algorithms via plugins, interface to CGAL and tools such as filters and taggers. Therefore, for more sophisticated jet studies the complete Jet Finders FastJet package needs to be linked. This is foreseen in the configure file in the Jet Finders examples subdirectory, and the Jet Finders main71.cc and Jet Finders main72.cc programs contain examples how it can be used with Jet Finders Pythia events. (Even if these examples do not go beyond the functionality that Jet Finders SlowJet can offer.) Jet Finders The latter program makes use of the Jet Finders include/Pythia8Plugins/FastJet3.h header file, contributed by Gavin Salam. This allows simple input of a Jet Finders Pythia particle into a Jet Finders FastJet one, either retaining only the four-momentum or the full particle information. Thereby more sophisticated selectors become possible at the Jet Finders FastJet level. This code could be duplicated, with trivial modifications, to augment the Jet Finders fjcore package functionality in an identical manner, should the need arise."},{"name":"Left-Right-Symmetry Processes","link":"LeftRightSymmetryProcesses.html","text":"Left-Right-Symmetry Processes Left-Right-Symmetry Processes Left-Right-Symmetry Processes At current energies, the world is left-handed, i.e. the Standard Model contains an Left-Right-Symmetry Processes SU(2)_L group. Left-right symmetry at some larger scale implies the need for an Left-Right-Symmetry Processes SU(2)_R group. Thus the particle content is expanded by right-handed Left-Right-Symmetry Processes Z_R^0 and Left-Right-Symmetry Processes W_R^+- and right-handed neutrinos. The Higgs fields have to be in a triplet representation, leading to doubly-charged Higgs particles, one set for each of the two Left-Right-Symmetry Processes SU(2) groups. Also the number of neutral and singly-charged Higgs states is increased relative to the Standard Model, but a search for the lowest-lying states of this kind is no different from e.g. the freedom already accorded by the MSSM Higgs scenarios. Left-Right-Symmetry Processes PYTHIA implements the scenario of Left-Right-Symmetry Processes Hui97. Left-Right-Symmetry Processes The Left-Right-Symmetry Processes W_R^+- has been implemented as a simple copy of the ordinary Left-Right-Symmetry Processes W^+- , with the exception that it couples to right-handed neutrinos instead of the ordinary left-handed ones. Thus the standard CKM matrix is used in the quark sector, and the same vector and axial coupling strengths, leaving only the mass as free parameter. The Left-Right-Symmetry Processes Z_R^0 implementation (without interference with the photon or the ordinary Left-Right-Symmetry Processes Z^0 ) allows decays both to left- and right-handed neutrinos, as well as other fermions, according to one specific model ansatz. Obviously both the Left-Right-Symmetry Processes W_R^+- and the Left-Right-Symmetry Processes Z_R^0 descriptions are  likely to be simplifications, but provide a starting point. Left-Right-Symmetry Processes For the doubly-charged Higgs bosons, the main decay modes implemented are Left-Right-Symmetry Processes H_L^++ &rarr; W_L^+ W_L^+, l_i^+ l_j^+ ( Left-Right-Symmetry Processes i, j generation indices) and Left-Right-Symmetry Processes H_R^++ &rarr; W_R^+ W_R^+, l_i^+ l_j^+. Left-Right-Symmetry Processes The right-handed neutrinos can be allowed to decay further. Assuming them to have a mass below that of Left-Right-Symmetry Processes W_R^+- , they decay to three-body states via a virtual Left-Right-Symmetry Processes W_R^+- , Left-Right-Symmetry Processes nu_Rl &rarr; l+- f fbar' , where both lepton charges are allowed owing to the Majorana character of the neutrinos. If there is a significant mass splitting, also sequential decays Left-Right-Symmetry Processes nu_Rl &rarr; l+- l'-+  nu'_Rl are allowed. Currently the decays are isotropic in phase space. If the neutrino masses are close to or above the Left-Right-Symmetry Processes W_R^ ones, this description has to be substituted by a sequential decay via a real Left-Right-Symmetry Processes W_R^ (not implemented, but actually simpler to do than the one here). Left-Right-Symmetry Processes Production processes A few different production processes have been implemented, which normally would not overlap and therefore could be run together. Left-Right-Symmetry Processes Parameters The basic couplings of the model are Left-Right-Symmetry Processes The corresponding vacuum expectation value Left-Right-Symmetry Processes v_R is assumed given by Left-Right-Symmetry Processes v_R = sqrt(2) M_WR / g_R and is not stored explicitly. Left-Right-Symmetry Processes The Yukawa couplings of a lepton pair to a Left-Right-Symmetry Processes H^-- , assumed the same for Left-Right-Symmetry Processes H_L^-- and Left-Right-Symmetry Processes H_R^-- , is described by a symmetric 3-by-3 matrix. The default matrix is dominated by the diagonal elements and especially by the Left-Right-Symmetry Processes tau tau one."},{"name":"Leptoquark Processes","link":"LeptoquarkProcesses.html","text":"Leptoquark Processes Leptoquark Processes Leptoquark Processes Leptoquarks arise in many scenarios, and can have widely different characteristics, with respect to spin, isospin am d flavour. The current implementation in no sense attempts to exhaust these possibilities, but only to encode one of the simplest possibilities, with a single scalar leptoquark, denoted Leptoquark Processes LQ and assigned PDG code 42. The leptoquark is assumed to carry specific quark and lepton quantum numbers, by default Leptoquark Processes u quark plus electron. These flavour numbers are conserved, i.e. a process such as Leptoquark Processes u e^- &rarr; LQ &rarr; d nu_e is not allowed. Leptoquark Processes Although only one leptoquark is implemented, its flavours may be changed arbitrarily to study the different possibilities. The flavours of the leptoquark are defined by the quark and lepton flavours in the decay mode list. Therefore, to change from the current Leptoquark Processes u e^- to Leptoquark Processes c mu^+ , say, you only need a line Leptoquark Processes Leptoquark Processes pythia.readString('42:0:products = 4 -13'); Leptoquark Processes in your main program, or the equivalent in a command file. The former must always be a quark, while the latter could be a lepton or an antilepton; a charge-conjugate partner is automatically defined by the program. At initialization, the charge is recalculated as a function of the flavours defined; also the leptoquark name is redefined to be of the type Leptoquark Processes LQ_q,l , where actual quark and lepton flavours are displayed. Leptoquark Processes The leptoquark is likely to be fairly long-lived, in which case it could have time to fragment into a mesonic- or baryonic-type state, which would decay later on. Currently this possibility is not handled; therefore the leptoquark is always assumed to decay before fragmentation. For that reason the leptoquark can also not be put stable. Leptoquark Processes Production processes Four production processes have been implemented, which normally would not overlap and therefore could be run together. Leptoquark Processes Parameters In the above scenario the main free parameters are the leptoquark flavour content, set as already described, and the Leptoquark Processes LQ mass, set as usual. In addition there is one further parameter."},{"name":"Les Houches Accord","link":"LHA.html","text":"Les Houches Accord Les Houches Accord Les Houches Accord The Les Houches Accord (LHA) for user processes Les Houches Accord Boo01 is the standard way to input parton-level information from a matrix-elements-based generator into PYTHIA. The conventions for which information should be stored has been defined in a Fortran context, as two commonblocks. Here a C++ equivalent is defined, as a single class. The most common application is to read input from a Les Houches Event File (LHEF) Les Houches Accord Alw06 , but it is also possible to have a runtime interface to another program. This page will discuss runtime interface. For LHEF handling, please refer to Les Houches Accord Les Houches Event Files. Les Houches Accord The Les Houches Accord LHAup class is a base class, containing reading and printout functions, plus two pure virtual functions, one to set initialization information and one to set information on each new event. Derived classes have to provide these two virtual functions to do the actual work. The existing derived classes are for reading information from a Les Houches Event File, from the respective Fortran commonblocks, or from PYTHIA 8 itself. Les Houches Accord You are free to write your own derived classes, using the rules and methods to be described below. Normally, pointers to objects of such derived classes should be handed in with the Les Houches Accord Les Houches Accord Pythia::setLHAupPtr( LHAup*) method. However, with the LHEF format a filename can replace the pointer, see further below. Les Houches Accord Let us now describe the methods at your disposal to do the job. Les Houches Accord Initialization The Les Houches Accord LHAup class stores information equivalent to the Les Houches Accord /HEPRUP/ commonblock, as required to initialize the event generation chain. The main difference is that the vector container now allows a flexible number of subprocesses to be defined. For the rest, names have been modified, since the 6-character-limit does not apply, and variables have been regrouped for clarity, but nothing fundamental is changed. Les Houches Accord Inside Les Houches Accord setInit() , such information can be set by the following methods: Les Houches Accord Note : PYTHIA does not make active use of the (optional) Les Houches Accord xErr values, but calculates a statistical cross section error based on the spread of event-to-event weights. This should work fine for strategy options +-1, but not for the others. Specifically, for options +-2 and +-3 the weight spread may well vanish, and anyway is likely to be an underestimate of the true error. If the author of the LHA input information does provide error information you may use that - this information is displayed at initialization. If not, then a relative error decreasing like Les Houches Accord 1/sqrt(n_acc) , where Les Houches Accord n_acc is the number of accepted events, should offer a reasonable estimate. Les Houches Accord Information is handed back by the following methods (that normally you would not need to touch): Les Houches Accord Les Houches Accord Event input The Les Houches Accord LHAup class also stores information equivalent to the Les Houches Accord /HEPEUP/ commonblock, as required to hand in the next parton-level configuration for complete event generation. The main difference is that the vector container now allows a flexible number of partons to be defined. For the rest, names have been modified, since the 6-character-limit does not apply, and variables have been regrouped for clarity, but nothing fundamental is changed. Les Houches Accord The LHA standard is based on Fortran arrays beginning with index 1, and mother information is defined accordingly. In order to be compatible with this convention, the zeroth line of the C++ particle array is kept empty, so that index 1 also here corresponds to the first particle. One small incompatibility is that the Les Houches Accord sizePart() method returns the full size of the particle array, including the empty zeroth line, and thus is one larger than the true number of particles ( Les Houches Accord NUP ). Les Houches Accord Inside a normal Les Houches Accord setEvent(...) call, information can be set by the following methods: Les Houches Accord Information is handed back by the following methods: Les Houches Accord From the information in the event record it is possible to set the flavour and Les Houches Accord x values of the initiators Les Houches Accord This information is returned by the methods Les Houches Accord In the LHEF description Les Houches Accord Alw06 an extension to include information on the parton densities of the colliding partons is suggested. This optional further information can be set by Les Houches Accord This information is returned by the methods Les Houches Accord The maximum scale for parton-shower evolution of a Les Houches event is regulated by the Les Houches Accord Les Houches Accord TimeShower:pTmaxMatch and Les Houches Accord Les Houches Accord SpaceShower:pTmaxMatch modes. If you want to guarantee that the input Les Houches Accord scale value is respected, as is often the case in matching/merging procedures, you should set both of these modes to 1. That only affects the hard process, while resonance decays are still processed using the resonance mass to set the upper limit. However, the optional Les Houches Accord Les Houches Accord Beams:strictLHEFscale = on setting restricts also resonance-decay emissions to be below the input Les Houches Accord scale value. Les Houches Accord As a further non-standard feature, it is also possible to read in the separate scale values of all final particles. Such scale values could be used e.g. to restrict the maximum scale for shower evolutions for each parton separately. This reading will only be applied if the Les Houches Accord Beams:setProductionScaleFromLHEF switch is true (see Les Houches Accord Les Houches Accord Beam Parameters for details). This information is returned by the method Les Houches Accord double LHAup::scale(int i). When no such information has been read from the LHEF, the scale defaults to -1. Les Houches Accord Les Houches Accord The LHA expects the decay of resonances to be included as part of the hard process, i.e. if unstable particles are produced in a process then their decays are also described. This includes Les Houches Accord Z^0, W^+-, H^0 and other short-lived particles in models beyond the Standard Model. Should this not be the case then PYTHIA will perform the decays of all resonances it knows how to do, in the same way as for internal processes. Note that you will be on slippery ground if you then restrict the decay of these resonances to specific allowed channels since, if this is not what was intended, you will obtain the wrong cross section and potentially the wrong mix of different event types. (Since the original intention is unknown, the cross section will not be corrected for the fraction of open channels, i.e. the procedure used for internal processes is not applied in this case.) Les Houches Accord Even if PYTHIA can select resonance decay modes according to its internal tables, there is normally no way for it to know which decay angular correlations should exist in the simulated process. Therefore almost all decays are isotropic. The exceptions are Higgs and top decays, in the decay chains Les Houches Accord H &rarr; WW/ZZ &rarr; f fbar f' fbar' and Les Houches Accord t &rarr; b W &rarr; b f fbar , where the process-independent correlations implemented for internal processes are used. If part of the decay chain has already been set, however (e.g. Les Houches Accord H &rarr; WW/ZZ or Les Houches Accord t &rarr; b W ), then decay is still isotropic. Les Houches Accord The LHA standard only allows for one hard subcollision in an event. Further multiparton interactions are supposed to be handled by the internal MPI machinery. As a nonstandard feature, it is possible to input two hard subcollisions in the same event, to match the internal Les Houches Accord second hard process machinery. In such cases two partons are extracted from each of the two incoming hadrons. A restriction is that, unlike the single-subprocess case, it is important that the partons are input in the order that PYTHIA later would need. That is, the two subcollisions should follow each other, with instate preceding outstate. Any resonance decay chain should be put at the end, after both interactions. As illustration, consider double Les Houches Accord W production. With Les Houches Accord 1 and Les Houches Accord 2 labelling the two subcollisions, and Les Houches Accord A and Les Houches Accord B the two incoming hadron beams, the event record ordering should be Les Houches Accord in_A1 - in_B1 - W_1 - in_A2 - in_B2 - W_2 - f_1 - fbar_1 - f_2 - fbar_2 , where Les Houches Accord f fbar is the fermion decay products of the respective Les Houches Accord W. A limitation is that currently only one input scale is used, that thereby limits all further partonic activity in the same way for both processes. Les Houches Accord When transferring events through the runtime interface, it is worth noting that PYTHIA offers some settings to ensure the consistency of momenta, e.g. reshuffling of particle momenta to guarantee on-shell conditions,  or matching the sum of incoming to the sum of outgoing momenta. The documentation of settings related to this can be found under the Les Houches Accord Transfer to the PYTHIA process record heading of Les Houches Accord Les Houches Event Files. Les Houches Accord A LHEF reader class The LHEF standard ( Les Houches Accord Alw06 , Les Houches Accord But14 ) specifies a format where a single file packs initialization and event information. This has become the most frequently used procedure to process external parton-level events in Pythia, and is discussed in detail in the Les Houches Accord Les Houches Event Files section. Internally the file handling and reading is us handled by instance of the derived class Les Houches Accord LHAupLHEF. Les Houches Accord The workhorses of the Les Houches Accord LHAupLHEF class are three methods found in the base class, so as to allow them to be reused in other contexts. Les Houches Accord These three main methods build on a number of container classes and a generic LHEF reader class (called Les Houches Accord Reader ) found in Les Houches Accord LHEF3.h and Les Houches Accord LHEF3.cc. The Les Houches Accord Reader handles all the parsing and storage necessary to adhere with Les Houches Accord But14. (A matching Les Houches Accord Writer class is also available; see documentation in Les Houches Accord LHEF3.h how it can be used.) All parsing that is not strictly part of the LHEF format (e.g. the reading of header information) is instead performed directly in the Les Houches Accord LHAupLHEF methods. Les Houches Accord Some other small utility routines are: Les Houches Accord A few other methods, most of them derived from the base class, streamlines file opening and closing, e.g. if several LHE files are to be read consecutively, without the need for a complete reinitialization. This presupposes that the events are of the same kind, only split e.g. to limit file sizes. Les Houches Accord A runtime Fortran interface The runtime Fortran interface requires linking to an external Fortran code. In order to avoid problems with unresolved external references when this interface is not used, the code has been put in a separate Les Houches Accord include/Pythia8Plugins/LHAFortran.h file, that is not included in any of the other library files. Instead it should be included in the user-supplied main program, and used to create a derived class that contains the implementation of two methods below that call the Fortran program to do its part of the job. Les Houches Accord The Les Houches Accord LHAupFortran class derives from Les Houches Accord LHAup. It reads initialization and event information from the LHA standard Fortran commonblocks, assuming these commonblocks behave like two Les Houches Accord extern 'C' struct named Les Houches Accord heprup_ and Les Houches Accord hepeup_. (Note the final underscore, to match how the gcc compiler internally names Fortran files.) Les Houches Accord The instantiation does not require any arguments. Les Houches Accord The user has to supply implementations of the Les Houches Accord fillHepRup() and Les Houches Accord fillHepEup() methods, that is to do the actual calling of the external Fortran routines that fill the Les Houches Accord HEPRUP and Les Houches Accord HEPEUP commonblocks. The translation of this information to the C++ structure is provided by the existing Les Houches Accord setInit() and Les Houches Accord setEvent() code. Les Houches Accord Up to and including version 8.125 the Les Houches Accord LHAupFortran class was used to construct a runtime interface to PYTHIA 6.4. This was convenient in the early days of PYTHIA 8 evolution, when this program did not yet contain hard-process generation, and the LHEF standard did not yet exist. Nowadays it is more of a bother, since a full cross-platform support leads to many possible combinations. Therefore this support has been removed, but can still be recuperated from previous code versions, in a reduced form up to version 8.176. Les Houches Accord A LHEF writer class The main objective of the Les Houches Accord LHAup class is to feed information from an external program into PYTHIA. It can be used to export information as well, however. The main documentation of these features is found in the Les Houches Accord Les Houches Event Files section. Nevertheless, we quickly summarize the main workhorse functions here. There are four routines in the base class that should be called in sequence to build up the proper file structure."},{"name":"Les Houches Event Files","link":"LHEF.html","text":"Les Houches Event Files Les Houches Event Files Les Houches Event Files The most common application of the Les Houches Accord (LHA) for user processes Les Houches Event Files Boo01 is to read input from a Les Houches Event File (LHEF) Les Houches Event Files Alw06 , but it is also possible to have a runtime interface to another program. Les Houches Event Files A 'no-beams' extension, currently not part of the standard, has been implemented. In this case only one part of a complete event is studied, and so no meaningful beam information can be set. The prime example is to study the decay properties of a resonance, where a parton-level decay chain is provided as input, and then showers and nadronization should be added. This simplified option does not cover Les Houches Event Files R -hadron formation and may not handle junction topologies in baryon-number-violating decays. Normally it is assumed that parton showers in the decays are fully handled by PYTHIA, but you can also specify multiparton configurations as the starting point. Then it is important to avoid doublecounting between emissions accounted for by matrix elements and by shower, by a judicious choice of scales or by a rejection of unwanted emissions in a user hook. Another example would be where a given partonic configuration would be hadronized, without any previous showers. See further below and in the Les Houches Event Files Hadron-Level Standalone description. Les Houches Event Files Another unofficial extension is the support for Double Parton Scattering (DPS), i.e. when two hard scatterings should be defined. This is allowed by letting one follow after the other in the event listing, such that two Les Houches Event Files 2 &rarr; 2 scatterings are specified by eight lines. It is here required that daughters are located below mothers strictly within each scattering separately, since the logic needed to sort out an arbitrary ordering is deemed overkill for such a peripheral case. An additional line Les Houches Event Files #scaleShowers scale1 scale2 can be attached after the event proper, where the starting shower scale can be defined for each scattering separately; if not present both scatterings evolve down from the standard scale value. The Les Houches Event Files LHAup method Les Houches Event Files bool scaleShowersIsSet() tells whether such information has been set for the current event and, if so, Les Houches Event Files double scaleShowers(int i) return the two scale values for arguments 0 and 1. Les Houches Event Files Event input Les Houches Event Files The maximum scale for parton-shower evolution of a Les Houches event is regulated by the Les Houches Event Files Les Houches Event Files TimeShower:pTmaxMatch and Les Houches Event Files Les Houches Event Files SpaceShower:pTmaxMatch modes. If you want to guarantee that the input Les Houches Event Files scale value is respected, as is often the case in matching/merging procedures, you should set both of these modes to 1. That only affects the hard process, while resonance decays are still processed using the resonance mass to set the upper limit. However, the optional Les Houches Event Files Les Houches Event Files Beams:strictLHEFscale = on setting restricts also resonance-decay emissions to be below the input Les Houches Event Files scale value. Les Houches Event Files As a further non-standard feature, it is also possible to read in the separate scale values of all final particles. Such scale values could be used e.g. to restrict the maximum scale for shower evolutions for each parton separately. This reading will only be applied if the Les Houches Event Files Beams:setProductionScaleFromLHEF switch is true (see Les Houches Event Files Les Houches Event Files Beam Parameters for details). This information is returned by the method Les Houches Event Files double LHAup::scale(int i). When no such information has been read from the LHEF, the scale defaults to -1. Les Houches Event Files The LHA standard only allows for one hard subcollision in an event. Further multiparton interactions are supposed to be handled by the internal MPI machinery. As a nonstandard feature, it is possible to input two hard subcollisions in the same event, to match the internal Les Houches Event Files second hard process machinery. In such cases two partons are extracted from each of the two incoming hadrons. A restriction is that, unlike the single-subprocess case, it is important that the partons are input in the order that PYTHIA later would need. That is, the two subcollisions should follow each other, with instate preceding outstate. Any resonance decay chain should be put at the end, after both interactions. As illustration, consider double Les Houches Event Files W production. With Les Houches Event Files 1 and Les Houches Event Files 2 labelling the two subcollisions, and Les Houches Event Files A and Les Houches Event Files B the two incoming hadron beams, the event record ordering should be Les Houches Event Files in_A1 - in_B1 - W_1 - in_A2 - in_B2 - W_2 - f_1 - fbar_1 - f_2 - fbar_2 , where Les Houches Event Files f fbar is the fermion decay products of the respective Les Houches Event Files W. A limitation is that currently only one input scale is used, that thereby limits all further partonic activity in the same way for both processes. Les Houches Event Files Transfer to the PYTHIA process record There are a few settings available for event input. They take effect when the LHA event record is translated to the PYTHIA Les Houches Event Files process event record, but leaves the LHA event record itself unchanged. Les Houches Event Files Structure of Les Houches Event Files The LHEF standard ( Les Houches Event Files Alw06 , Les Houches Event Files But14 ) specifies a format where a single file packs initialization and event information. This has become the most frequently used procedure to process external parton-level events in Pythia. To access this, you must set Les Houches Event Files Beams:frameType = 4 and Les Houches Event Files Beams:LHEF to be the file name, see Les Houches Event Files Beam Parameters. Internally this name is then used to create an instance of the derived class Les Houches Event Files LHAupLHEF , which can do the job of reading an LHEF. Les Houches Event Files As some information in a Les Houches Event File init block is only known at the end of generation, some programs choose to output this as a separate file. If so, the name of this file can be specified by Les Houches Event Files Les Houches Event Files Beams:LHEFheader. Les Houches Event Files The two key compulsory parts of an LHEF is the initialization information stored in an init block, enclosed by a matching Les Houches Event Files <init> - Les Houches Event Files </init> pair of lines, and the event input, with each event enclosed by a matching Les Houches Event Files <event> - Les Houches Event Files </event> pair of lines. In the case of the no-beams extension the init block may be empty, but the Les Houches Event Files <init> and Les Houches Event Files </init> lines must be included for the file parsing to work as expected. It is also possible to have a non-empty init block, with the beams assigned code 0, and optionally a number of specified 'processes'. Les Houches Event Files The latest update of the LHEF format Les Houches Event Files But14 introduced a multitude of different optional features. This means that apart from the Les Houches Event Files <init> and Les Houches Event Files <event> tags, a plethora of new, optional information is available. Furthermore, the inclusion of an arbitrary number of attributes into the tags should be supported. The LHEF reader in Pythia adheres to the updated LHEF format without any restriction. The new generation information available through the updated LHEF format can be retrieved by using Pythia's Les Houches Event Files Info class. For a detailed description, please consult the section 'Les Houches Event File 3.0 information' in Les Houches Event Files Event Information. Les Houches Event Files The LHEF reader can also read in and store header blocks. By default this option is switched on, but may be controlled through the Les Houches Event Files Les Houches Event Files Beams:readLHEFheaders flag if necessary. The information can later be read out through the Les Houches Event Files Info class for further processing. Due to the non-standard nature of the information in these blocks they are stored whole, and PYTHIA itself makes no further attempt to process their meaning. Les Houches Event Files Because Les Houches Event files tend not to adhere strictly to XML conventions, to consistently read in header information, certain choices must be made. The primary goal is to make as much information available as possible. First, information sitting directly in the <header> block is stored under the key 'base'. Second, the tags starting and ending each sub block must be on their own line. Finally, the contents of comment blocks, <!-- -->, are still stored. The header keys are formed hierarchically from the names of the header blocks. This behaviour is illustrated in the following example: Les Houches Event Files <header>    BaseA    <hblock1>     1A     <hblock11>      11A <hblock111>      </hblock111> 11B     </hblock11>     1B    </hblock1>    <hblock2>     2A     <!-- 2B -->    </hblock2>    BaseB  </header> which would lead to the following information being stored in the Les Houches Event Files Info class: Les Houches Event Files Les Houches Event Files Les Houches Event Files Key Les Houches Event Files Value Les Houches Event Files Les Houches Event Files base Les Houches Event Files BaseA Les Houches Event Files BaseB Les Houches Event Files Les Houches Event Files hblock1 Les Houches Event Files 1A Les Houches Event Files 1B Les Houches Event Files Les Houches Event Files hblock1.hblock11 Les Houches Event Files 11A <hblock111> Les Houches Event Files </hblock111> 11B Les Houches Event Files Les Houches Event Files hblock2 Les Houches Event Files 2A Les Houches Event Files <!-- 2B --> Les Houches Event Files Les Houches Event Files Normally the LHEF would be in uncompressed format, and thus human-readable if opened in a text editor. A possibility to read gzipped files has been added, based on the Boost and zlib libraries, which therefore have to be linked appropriately in order for this option to work. See the Les Houches Event Files README file in the main directory for details on how to do this. Les Houches Event Files An example how to generate events from an LHEF is found in Les Houches Event Files main11.cc. Note the use of Les Houches Event Files Info::atEndOfFile() to find out when the whole LHEF has been processed. Les Houches Event Files To allow the sequential use of several event files, the Les Houches Event Files Les Houches Event Files Beams:newLHEFsameInit can be set Les Houches Event Files true. Then there will be no initialization, except that the existing Les Houches Event Files LHAupLHEF class instance will be deleted and replaced by one pointing to the new file. It is assumed (but never checked) that the initialization information is identical, and that the new file simply contains further events of exactly the same kind as the previous one. An example of this possibility, and the option to mix with internal processes, is found in Les Houches Event Files main12.cc. A variant, based on input in a command file, is given in Les Houches Event Files main13.cc. Les Houches Event Files In C++, real numbers are printed with an 'E' to denote the exponent part, e.g. 1.23E+04, and are read in accordingly. Other languages may use other letters, e.g. Fortran allows either 'E' or 'D'. A file using the latter convention would not be readable by the standard routines. In case you have such an 'incorrectly formatted' file, a conversion to a new corrected file could be done e.g. using Les Houches Event Files sed , as a one-line command Les Houches Event Files sed -e 's/\([0-9]\.\{0,1\}\)[dD]\([+-]\{0,1\}[0-9]\)/\1E\2/g' old.lhe > new.lhe This replaces a 'd' or 'D' with an 'E' only when it occurs in the combination Les Houches Event Files Les Houches Event Files (digit) ('.' or absent) ('d' or 'D') ('+', '-' or absent) (digit) Les Houches Event Files It will work on all parts of the file, also inside a Les Houches Event Files <header>...</header> block. For conversion only inside the Les Houches Event Files <init>...</init> and Les Houches Event Files <event>...</event> blocks, create a file Les Houches Event Files convert.sed containing Les Houches Event Files /<init>/,/<\/init>/bconv  /<event>/,/<\/event>/bconv  b  :conv  s/\([0-9]\.\{0,1\}\)[dD]\([+-]\{0,1\}[0-9]\)/\1E\2/g and run it with Les Houches Event Files sed -f convert.sed old.lhe > new.lhe Les Houches Event Files Header information A simple string key/value store, mainly intended for accessing information that is stored in the header block of Les Houches Event (LHE) files. In principle, any Les Houches Event Files LHAup derived class can set this header information, which can then be read out later. Although the naming convention is arbitrary, in practice, it is dictated by the XML-like format of LHE files. Les Houches Event Files Retrieving the information read from LHEF Information passed to PYTHIA through LHE files is handled in, and can be retrieved by two ways. The collection of particles transferred through the Les Houches event is directly accessible through the event record. A copy of the hard scattering event (i.e. the hard particle identifiers, colors, momenta etc. read from the Les Houches event file) is stored in the Les Houches Event Files process data member of the Les Houches Event Files Pythia instance. It can for example be printed to the terminal by calling Les Houches Event Files pythia.process.list().  All other information (e.g. stored in headers, the LHEF init block, or non-particle tags of the current event, such as weight information) is accessible through the Les Houches Event Files Info class. Les Houches Event Files If some information has been Les Houches Event Files Les Houches Event files can conform to version 1.0 (as agreed upon in Les Houches Event Files Alw06 ) and version 3.0 of the standard (version 2.0 having been extended to 3.0 in Les Houches Event Files But14 ). The LHEF version of an input file can can be accessed by Les Houches Event Files Les Houches Event Files LHEF 1.0 information Please find below the documentation of LHEF 1.0 information as stored in the Les Houches Event Files Info class. Note also the description of some settings in the Les Houches Event Files Beam Parameters section. Theinformation is divided into the Les Houches Event Files header , Les Houches Event Files init and Les Houches Event Files event blocks. The information stored in the Les Houches Event Files header and Les Houches Event Files init is: Les Houches Event Files Les Houches Event Files Les Houches Event Files To check if the process information has been generated by external Les Houches Accord, you can infer the function Les Houches Event Files bool Info::isLHA().  As convenience feature, it is also possible to check if the end of the file from which events have been read in has been reached by calling Les Houches Event Files bool Info::atEndOfFile(). Les Houches Event Files Les Houches Event Files If the process has been transferred through LHEF, then you can retrieve the cross section values and errors by calling Les Houches Event Files double Info::sigmaGen(int i = 0) and Les Houches Event Files double Info::sigmaErr(int i = 0). Please consult the Les Houches Event Files Event Information section for further details. Alternatively, you may use the functions Les Houches Event Files Les Houches Event Files The weighting strategy indicated in the Les Houches Event Files init block can be retrieved by calling Les Houches Event Files int Info::lhaStrategy(). The event-by-event information read from the Les Houches Event Files event block is: Les Houches Event Files Les Houches Event Files Les Houches Event Files The scale associated with the event, which can be obtained from a call to Les Houches Event Files double Info::scalup() , see the Les Houches Event Files Event Information section for further details. Les Houches Event Files Les Houches Event Files The weight associated with the event can be retrieved from a call to Les Houches Event Files double Info::weight() , see the Les Houches Event Files Event Information section for further details. Les Houches Event Files LHEF 3.0 information Please find below the documentation of LHEF 3.0 information as stored in the Les Houches Event Files Info class. An example main program using LHEF 3.0 information is Les Houches Event Files main38.cc. Note also the description of some settings in the Les Houches Event Files Beam Parameters section.  LHEF 3.0 offers new features both in the initialisation and the event sections of the input files. Possible information include extended use of XML tags in the Les Houches Event Files <header> and Les Houches Event Files <init> and Les Houches Event Files event blocks. This LHEF 3.0 information is stored in the Les Houches Event Files Info class in a series Les Houches Event Files struct 's: Les Houches Event Files Les Houches Event Files Les Houches Event Files The Les Houches Event Files <initrwgt> tag is a container tag for weight and weightgroup tags.  This information is stored internally in Les Houches Event Files LHAinitrwgt. Currently, there is no dedicated output for this tag. However, all the information stored in the tag can be retrieved by using the Les Houches Event Files Info class member pointer Les Houches Event Files LHAinitrwgt Info::initrwgt. Les Houches Event Files Les Houches Event Files Multiple Les Houches Event Files <weightgroup> tags: Container tag for weight tags. Currently, there is no dedicated output for this tag. However, all the information stored in the tag can be retrieved by using the Les Houches Event Files Info class member pointer Les Houches Event Files vector<LHAweightgroups> * Info::weightgroups. Les Houches Event Files Les Houches Event Files Multiple Les Houches Event Files <weight> tags: Tag defining auxiliary information on an event weight, e.g. the identifier and information on what the weight represents. All the information stored in the tag can be retrieved by using the Les Houches Event Files Info class member pointer Les Houches Event Files vector<LHAweightgroups> * Info::init_weights. This vector contains all Les Houches Event Files <weight> tags in the Les Houches Event Files <initrwgt> container and its subcontainer Les Houches Event Files <weightgroup> tags. The size of the vector can be accessed through the method Les Houches Event Files Les Houches Event Files Les Houches Event Files Multiple Les Houches Event Files <generator> tags: Store information on the generators used in the event generation. All the information stored in the tag can be retrieved by using the Les Houches Event Files Info class member pointer Les Houches Event Files vector<LHAgenerators> * Info::generators. More easy-to-use output functions are available. The size of this vector can be obtained from Les Houches Event Files Les Houches Event Files The contents of an individual Les Houches Event Files <generator> tag can be accessed through the method Les Houches Event Files Les Houches Event Files Attributes of the Les Houches Event Files <generator> tag (e.g. the generator Les Houches Event Files name and Les Houches Event Files version ) can be accessed via Les Houches Event Files Les Houches Event Files Note that the complete header can be obtained with the Les Houches Event Files Info class member Les Houches Event Files string getHeaderBlock(). For more information on the header block, please see the Les Houches Event Files Header information paragraph above. Finally, to obtain information on cross sections, the following two methods can be used Les Houches Event Files Les Houches Event Files Les Houches Event Files LHEF 3 also greatly extended the possible information stored within Les Houches Event Files <event> blocs. In particular, multiple weights are supported, as are multiple scale values. Possible information from extended use of XML tags in the Les Houches Event Files <event> block is: Les Houches Event Files Les Houches Event Files Les Houches Event Files The Les Houches Event Files <rwgt> tag is a container tag for wgt tags. Currently, there is no dedicated output for this tag. It can however be retrieved by using the Les Houches Event Files Info class member pointer Les Houches Event Files LHArwgt Info::rwgt. Les Houches Event Files Les Houches Event Files Multiple Les Houches Event Files <wgt> tags: Tag defining the event weight in the detailed version of LHEF 3.0.  All the information stored in the tag can be retrieved by using the Les Houches Event Files Info class member pointer Les Houches Event Files vector<LHAwgt> * Info::weights_detailed. More easy-to-use output functions are available. The size of this vector can be obtained from Les Houches Event Files Les Houches Event Files <wgt> tags is the Les Houches Event Files Info class member Les Houches Event Files vector<double> Info::weights_detailed_vector. The entries of this vector are ordered according to how Les Houches Event Files <wgt> tags appear in the event block. Les Houches Event Files The contents of a Les Houches Event Files <wgt> tag can be accessed through the method Les Houches Event Files Les Houches Event Files Attributes of the Les Houches Event Files <wgt> tag (e.g. the weight Les Houches Event Files id ) can be accessed via Les Houches Event Files Les Houches Event Files Les Houches Event Files The Les Houches Event Files <weights> tag: Tag containing  a vector of Les Houches Event Files double entries for weights in the compressed version  of LHEF 3.0. All the information stored in the tag can be retrieved by using  the Les Houches Event Files Info class member pointer Les Houches Event Files LHAweights *  Info::weights and the vector Les Houches Event Files vector<double>  Info::weights_compressed. More easy-to-use output functions are  available. The size of this vector can be obtained from Les Houches Event Files Les Houches Event Files The n'th weight can be accessed through the method Les Houches Event Files Les Houches Event Files Attributes of the Les Houches Event Files <weights> tag (not normally used) can be accessed via Les Houches Event Files Les Houches Event Files Les Houches Event Files The Les Houches Event Files <scales> tag: Contains information  on different scales used by the matrix element generator. All the information  stored in the tag can be retrieved by using the Les Houches Event Files Info class  member pointer Les Houches Event Files LHAweights * Info::scales. More easy-to-use  output functions are available. The contents of the scales tag can be  obtained from Les Houches Event Files Les Houches Event Files However, note that the actual scale values are stored as attributes (called e.g. Les Houches Event Files muf or Les Houches Event Files mur ). Attributes of the Les Houches Event Files <scales> tag can be accessed via Les Houches Event Files Les Houches Event Files Les Houches Event Files Finally, arbitrary attributes of the Les Houches Event Files <event> tag are supported. Attributes of the Les Houches Event Files <event> tag can be accessed by Les Houches Event Files Les Houches Event Files <event> tag can be obtained with the Les Houches Event Files Info class member Les Houches Event Files string getEventComments(). Les Houches Event Files PYTHIA 8 output to a Les Houches Event File version 1.0 The above methods could be used by any program to write an LHEF. For PYTHIA 8 to do this, a derived class already exists, Les Houches Event Files LHAupFromPYTHIA8. In order for it to do its job, it must gain access to the information produced by PYTHIA, specifically the Les Houches Event Files process event record and the generic information stored in Les Houches Event Files info. Therefore, if you are working with an instance Les Houches Event Files pythia of the Les Houches Event Files Pythia class, you have to instantiate Les Houches Event Files LHAupFromPYTHIA8 with pointers to the Les Houches Event Files process and Les Houches Event Files info objects of Les Houches Event Files pythia : Les Houches Event Files Les Houches Event Files LHAupFromPYTHIA8 myLHA(&pythia.process, &pythia.info); Les Houches Event Files The method Les Houches Event Files setInit() should be called to store the Les Houches Event Files pythia initialization information in the LHA object, and Les Houches Event Files setEvent() to store event information. Furthermore, Les Houches Event Files updateSigma() can be used at the end of the run to update cross-section information, cf. Les Houches Event Files closeLHEF(true) above. An example how the generation, translation and writing methods should be ordered is found in Les Houches Event Files main20.cc. Les Houches Event Files Currently there are some limitations, that could be overcome if necessary. Firstly, you may mix many processes in the same run, but the cross-section information stored in Les Houches Event Files info only refers to the sum of them all, and therefore they are all classified as a common process 9999. Secondly, you should generate your events in the CM frame of the collision, since this is the assumed frame of stored Les Houches events, and no boosts have been implemented for the case that Les Houches Event Files Pythia::process is not in this frame. Les Houches Event Files The LHEF standard is the agreed format to store the particles of a hard process, as input to generators, whereas output of final states is normally handled using the Les Houches Event Files HepMC standard. It is possible to use LHEF also here, however. It requires that the above initialization is replaced by Les Houches Event Files Les Houches Event Files LHAupFromPYTHIA8 myLHA(&pythia.event, &pythia.info); Les Houches Event Files i.e. that Les Houches Event Files process is replaced by Les Houches Event Files event. In addition, the Les Houches Event Files PartonLevel:all = off command found in Les Houches Event Files main20.cc obviously must be removed if one wants to obtain complete events. Les Houches Event Files PYTHIA 8 output to a Les Houches Event File version 3.0 PYTHIA 8 also supports LHEF 3.0 output, and we include a general LHEF3 writer ( Les Houches Event Files Pythia::Writer of LHEF3.h and LHEF3.cc) for this purpose. The functions of this file writer are used in the Les Houches Event Files LHEF3FromPYTHIA8. This latter class allows users to output PYTHIA events in LHEF3 format from a PYTHIA main program. An example of how to use Les Houches Event Files LHEF3FromPYTHIA8 is found in the Les Houches Event Files main20lhef3.cc example. Please note that, although similar, the usage of Les Houches Event Files LHEF3FromPYTHIA8 differs from the usage of Les Houches Event Files LHAupFromPYTHIA8 , with Les Houches Event Files LHEF3FromPYTHIA8 requiring fewer function calls. Les Houches Event Files To print a comprehensive LHE file, Les Houches Event Files LHEF3FromPYTHIA8 is constructed with pointers to an Les Houches Event Files Event object, as well as pointers to instances of Les Houches Event Files Settings , Les Houches Event Files Info and Les Houches Event Files ParticleData , giving e.g. a constructor call Les Houches Event Files Les Houches Event Files LHEF3FromPYTHIA8 myLHEF3(&pythia.event, &pythia.settings, &pythia.info, &pythia.particleData); Les Houches Event Files As a next step, you should open the output file by using the Les Houches Event Files LHAupFromPYTHIA8 member function Les Houches Event Files Les Houches Event Files openLHEF(string name) Les Houches Event Files where Les Houches Event Files name is the output file name. Les Houches Event Files Then, the method Les Houches Event Files setInit() should be called to store the initialization information (read from Les Houches Event Files settings and Les Houches Event Files info ) and write the header and init blocks into the output file. Note that at this stage, the cross section printed in the init block is not sensible, as no integration has yet taken place. The init block can be updated at the end of the event generation (see below). Les Houches Event Files During event generation, you should use Les Houches Event Files setEvent() to write the event information (as read from Les Houches Event Files info and Les Houches Event Files event ) to the output file. Les Houches Event Files Finally, before leaving your main program, it is necessary to close the output file by using the Les Houches Event Files LHAupFromPYTHIA8 member function Les Houches Event Files Les Houches Event Files closeLHEF( bool doUpdate = false) Les Houches Event Files The boolean variable Les Houches Event Files doUpdate is optional. If Les Houches Event Files doUpdate is used, and if Les Houches Event Files doUpdate = true , then the init block of the output file will be updated with the latest cross section information. Les Houches Event Files Currently there are some limitations, that could be overcome if necessary. Firstly, you may mix many processes in the same run, but the cross-section information stored in Les Houches Event Files info only refers to the sum of them all, and therefore they are all classified as a common process 9999. Secondly, you should generate your events in the CM frame of the collision, since this is the assumed frame of stored Les Houches events, and no boosts have been implemented for the case that Les Houches Event Files Pythia::process is not in this frame."},{"name":"MadGraph5 Processes","link":"MadGraph5Processes.html","text":"MadGraph5 Processes MadGraph5 Processes MadGraph5 Processes Here we will describe two special ways to make use of MadGraph5 and MadGraph5_aMC\@NLO MadGraph5 Processes Alw11,Alw14 inside PYTHIA, either by exporting Madgraph process code or by wrapping the MadGraph5_aMC\@NLO generator as a PYTHIA Les Houches interface. MadGraph5 Processes Of course, MadGraph5 can also output files of parton-level events according to the MadGraph5 Processes LHEF standard, that can be read in and processed further by PYTHIA 8. This is the most commonly used approach, and requires no further description here. MadGraph5 Processes MadGraph5 code inside PYTHIA By far the easiest way to implement new processes into PYTHIA 8 is by using the matrix-element generator MadGraph5. This program has an option to output the results of a matrix-element calculation as a set of PYTHIA 8 C++ classes (plus further auxiliary code), that can then be linked and used as MadGraph5 Processes semi-internal processes, meaning they are handled identically with normal internal ones. This way, MadGraph5 can be used to implement processes from any model that can be written in  terms of a Lagrangian. Any MadGraph5 Processes 2 &rarr; 1 , MadGraph5 Processes 2 &rarr; 2 and MadGraph5 Processes 2 &rarr; 3 processes can be implemented, the limit being set by the absence of efficient phase space generator algorithms for higher multiplicities in PYTHIA. Features such as MadGraph5 Processes s -channel resonances are automatically implemented in the process classes.  Besides the process library and necessary model files, also an example main program is generated for each set of processes, which can be easily modified to perform the desired analyses. MadGraph5 Processes In order to create a PYTHIA 8 process library with MadGraph5, first download the MadGraph5 package from MadGraph5 Processes https://launchpad.net/madgraph5 , and untar the package. You can then specify the location of your MadGraph5 Processes pythia81xx directory in the file MadGraph5 Processes input/mg5_configuration.txt : MadGraph5 Processes MadGraph5 Processes pythia8_path = ./pythia81xx MadGraph5 Processes The location can be either relative (to the directory MadGraph5 Processes MadGraph5_v_x_x_x/. ) or absolute. MadGraph5 Processes For any model that is already implemented in the MadGraph5 package, you can directly use the model. Start the MadGraph5 interface MadGraph5 Processes bin/mg5 , and do: MadGraph5 Processes import model model_name generate your_process_in_mg5_syntax add process your_next_process_in_mg5_syntax ... output pythia8 [path_to_pythia81xx_directory] MadGraph5 Processes For examples of MG5 process syntax, please see MadGraph5 Processes http://madgraph.phys.ucl.ac.be/EXAMPLES/example_mg5.html or type MadGraph5 Processes help generate. If you specified the path to the MadGraph5 Processes pythia81xx directory in the MadGraph5 Processes mg5_configuration file, you do not need to enter it in the MadGraph5 Processes output command. MadGraph5 Processes If your preferred model is found on the FeynRules model wiki page, MadGraph5 Processes http://feynrules.irmp.ucl.ac.be/wiki/ModelDatabaseMainPage , download the UFO (Universal FeynRules Output) tar file for the model, untar in the MadGraph5 Processes models/ directory, and use as above. MadGraph5 Processes If you want to implement a new model which has not yet been implemented, you can do this either using the Mathematica package FeynRules (see MadGraph5 Processes http://feynrules.irmp.ucl.ac.be/ ) or directly edit the UFO model files of the most similar model in the MadGraph5 Processes models/ directory. MadGraph5 Processes The resulting output from the MadGraph5 Processes output pythia8 command is: MadGraph5 Processes MadGraph5 Processes A process directory MadGraph5 Processes Processes_modelname with the model information and the files needed for all processes defined for this model, placed in the MadGraph5 Processes pythia81xx main directory. The model files are MadGraph5 Processes Parameters_modelname.h/cc and MadGraph5 Processes HelAmps_modelname.h/cc , and the process files for each process class (with the same mass, spin and color of the initial/final state particles) are called MadGraph5 Processes Sigma_modelname_processname.h/cc. The directory also contains a MadGraph5 Processes makefile and a model parameter file MadGraph5 Processes param_card_modelname.dat. MadGraph5 Processes An example main program in the directory MadGraph5 Processes examples/ (in the MadGraph5 Processes pythia81xx main directory) called MadGraph5 Processes main_modelname_N.cc and a corresponding makefile MadGraph5 Processes Makefile_modelname_N. This main program links in the process classes in the process directory described above. To run the example main program, just go to the MadGraph5 Processes examples/ directory and run MadGraph5 Processes MadGraph5 Processes make -f Makefile_modelname_N MadGraph5 Processes or run MadGraph5 Processes launch directly inside the MadGraph5 command line interface. MadGraph5 Processes Note that in order for PYTHIA 8 to be able to automatically decay any new particles, it is necessary to specify the branching ratios of the particles in the MadGraph5 Processes param_card file, see MadGraph5 Processes Ska04,Alw07 for details. MadGraph5 Processes For further technical details, please see the MadGraph5 release paper MadGraph5 Processes Alw11 and the MadGraph5 Processes semi-internal processes page. MadGraph5 Processes Currently the standard way of interfacing is to use the LHEF standard with an intermediate event file. The advantage is that then the MadGraph5 phase space generator can be used, which opens up for processes with more than three particles in the final state. The disadvantages are that it is less easy to mix and match with existing PYTHIA processes, and that one needs to regenerate and store large LHEF files for different  kinematics cuts or parameter values. MadGraph5 Processes Please cite the MadGraph5 release paper MadGraph5 Processes Alw11 if you use MadGraph5 to generate process libraries for PYTHIA 8. MadGraph5 Processes MadGraph5_aMC\@NLO executable inside PYTHIA The MadGraph5 Processes Pythia::setLHAupPtr(LHAup* lhaUpPtr) method allows a Pythia generator to accept a pointer to an object derived from the MadGraph5 Processes MadGraph5 Processes LHAup base class. Such an object will be initialized from within Pythia, and be called repeatedly to generate the next parton-level event, using the LHA specification as a standard to transfer the relevant information back to Pythia. Properly constructed, the operation of an MadGraph5 Processes LHAup object thus is almost completely hidden from the user, and generates events almost like an ordinary internal Pythia process. MadGraph5 Processes The MadGraph5 Processes LHAupMadgraph is precisely such a class, derived from MadGraph5 Processes LHAup , that contains the code needed to wrap a MadGraph5_aMC\@NLO executable. Thereby the generation of Madgraph processes from within Pythia becomes straightforward. An explicit example is provided in MadGraph5 Processes main34.cc. We describe some of the key elements used there and in the general case. MadGraph5 Processes Note that GZIP support must be enabled in the Pythia executable, so use the MadGraph5 Processes --with-gzip option in the MadGraph5 Processes configure step before Pythia compilation. MadGraph5 Processes Events are generated with MadGraph utilizing the MadGraph5 Processes gridpack method for MadGraph5 and an MadGraph5 Processes equivalent method for aMC\@NLO. Consequently the run directory, MadGraph5 Processes 'madgraphrun' by default, does not need to be deleted between independent runs with the same configuration (excluding random seeds). Indeed, keeping the directory significantly speeds the generation process, particularly for NLO generation with aMC\@NLO as the grid initialization can be skipped after the initial run."},{"name":"Main-Program and Related Settings","link":"MainProgramSettings.html","text":"Main-Program and Related Settings Main-Program and Related Settings Main-Program and Related Settings Main-Program and Related Settings Introduction The main program is up to the user to write. However, Main-Program and Related Settings sample main programs are provided. In one such class of programs, key settings of the run are read in from a 'cards file'. For experimental collaborations this is actually the most common way to run a program like PYTHIA. The commands in such a file may be of two types Main-Program and Related Settings (a) instructions directly to Main-Program and Related Settings Pythia , like which processes to generate, and Main-Program and Related Settings (b) instructions to the main program for what it should do, like how many events to generate, and how many events should be listed. Main-Program and Related Settings In principle these two kinds could be kept completely separate. However, to make life simpler, a few useful main-program settings are defined on this page, so that they are recognized by the Main-Program and Related Settings Settings machinery. They can thus be put among the other cards without distinction. It is up to you to decide which ones, if any, you actually want to use when you write your main program. Main-Program and Related Settings To further reduce the necessary amount of main-program code, some of the tasks that you can steer from your main program can also be done internally. This in particular relates to some information printing. To give an example, Main-Program and Related Settings pythia.event.list() can be inserted to print an event, i.e. all the particles belonging to it. Given the length of these listings one would list only a few events at the beginning of the run, to get some feeling for the character of events. This could be achieved e.g. with a main-program statement Main-Program and Related Settings Main-Program and Related Settings if (iEvent < 3) pythia.event.list() Main-Program and Related Settings to list the first three events in a loop over Main-Program and Related Settings iEvent , after Main-Program and Related Settings pythia.next() has been used to generate the next event. Alternatively a Main-Program and Related Settings Next:numberShowEvent = 3 setting, e.g. in a command file, would achieve the same, by an internal call at the end of Main-Program and Related Settings pythia.next(). Main-Program and Related Settings The settings names on this page thus fall into four main groups Main-Program and Related Settings Main-Program and Related Settings Main-Program and Related Settings Init:... denote actions that automatically may be taken during the Main-Program and Related Settings pythia.init() call. Main-Program and Related Settings Main-Program and Related Settings Next:... denote actions that automatically may be taken during the Main-Program and Related Settings pythia.next() call. Main-Program and Related Settings Main-Program and Related Settings Stat:... denote actions that automatically may be taken during the Main-Program and Related Settings pythia.stat() call. Main-Program and Related Settings Main-Program and Related Settings Main:... denote actions that you yourself have the freedom to make use of in your main program. Main-Program and Related Settings Initialization settings Main-Program and Related Settings Event-generation settings Main-Program and Related Settings Statistics Main-Program and Related Settings Main-program settings The settings in this section Main-Program and Related Settings must be under the control of the user, i.e. there are no internal equivalents. The first one is especially important and would be a standard feature of any separate command file. Main-Program and Related Settings The Main-Program and Related Settings Main:... options works like this. Once you have used the Main-Program and Related Settings pythia.readFile(fileName) method to read in the cards file, where the values have been set, you can interrogate the Main-Program and Related Settings Settings database to make the values available in your main program. A slight complication is that you need to use a different Main-Program and Related Settings Settings method for each of the four possible return types that you want to extract. To save some typing the same method names are found directly in the Main-Program and Related Settings Pythia class, and these just send on to the Main-Program and Related Settings Settings ones to do the job, e.g. Main-Program and Related Settings Main-Program and Related Settings int nEvent = pythia.mode('Main:numberOfEvents'); Main-Program and Related Settings The area of subruns is covered separately below. A few spares are also defined after that, for unforeseen applications. Main-Program and Related Settings Subruns You can use Main-Program and Related Settings subruns to carry out several tasks in the same run. In that case you will need repeated instances of the first setting below in your command file, and could additionally use the second and third as well. Main-Program and Related Settings Spares For currently unforeseen purposes, a few dummy settings are made available here. The user can set the desired value in a 'cards file' and then use that value in the main program as desired."},{"name":"Master Switches","link":"MasterSwitches.html","text":"Master Switches Master Switches Master Switches Sometimes it may be convenient to omit certain aspects of the event generation chain. This cannot be motivated in a full-blown production run, but can often be convenient for own understanding and for debug purposes. The flags on this page allow just that. Master Switches The event generation is subdivided into three levels: the process level, the parton level and the hadron level, and flags are grouped accordingly. Master Switches Process Level The Master Switches ProcessLevel class administrates the initial step of the event generation, wherein the basic process is selected. Currently this is done either using some of the internal processes, or with Les Houches Accord input. Master Switches There could not be a complete event without an initial process, so it would not be a normal action to switch off this step. Furthermore, without a process set, it is also not possible to carry out the tasks on the parton level. It is still possible, however, to hadronize a parton-level configuration provided by some external program. Master Switches For Master Switches ProcessLevel:all = on one part of the event generation on this level may be switched off individually: Master Switches It is possible to stop the generation immediately after the basic process has been selected, see Master Switches PartonLevel:all below. Master Switches PartonLevel The Master Switches PartonLevel class administrates the middle step of the event generation, i.e. the evolution from an input (hard) process from Master Switches ProcessLevel , containing a few partons only, to a complete parton-level configuration to be handed on to Master Switches HadronLevel. This step involves the application of initial- and final-state radiation, multiparton interactions and the structure of beam remnants. Master Switches For Master Switches PartonLevel:all = on some parts of the event generation on this level may be switched off individually: Master Switches Switching off all the above MPI/ISR/FSR switches is Master Switches not equivalent to setting Master Switches PartonLevel:all = off. In the former case a minimal skeleton of parton-level operations are carried out, such as tying together the scattered partons with the beam remnants into colour singlets, and storing this information in the Master Switches event record. It is therefore possible to go on and hadronize the event, if desired. In the latter case Master Switches no operations at all are carried out on the parton level, and therefore it is also not possible to go on to the hadron level. Master Switches It is possible to stop the generation immediately after the parton level has been set up, see Master Switches HadronLevel:all below. Master Switches HadronLevel The Master Switches HadronLevel class administrates the final step of the event generation, wherein the partonic configuration from Master Switches PartonLevel is hadronized, including string fragmentation and secondary decays. Master Switches Most of the code in this class itself deals with subdividing the partonic content of the event into separate colour singlets, that can be treated individually by the string fragmentation machinery. When a junction and an antijunction are directly connected, it also breaks the string between the two, so that the topology can be reduced back to two separate one-junction systems, while still preserving the expected particle flow in the junction-junction string region(s). Master Switches For Master Switches HadronLevel:all = on some parts of the event generation on this level may be switched off individually: Master Switches Printing"},{"name":"Matching and Merging","link":"MatchingAndMerging.html","text":"Matching and Merging Matching and Merging Matching and Merging This page first describes the matching and merging capabilitities of PYTHIA, and then, below, the use of a somewhat generic example main program to produce matched or merged results.  Precision and a wide kinematical coverage are important ingredients to the applicability of Event Generators. Both can be aided by including higher-order corrections into the Generator. Depending on needs, the inclusion of higher orders (on top of a Born-level leading-order (LO) process) can be prioritized in different ways: Matching and Merging Matching and Merging A formal order-by-order perturbative calculation, in each order higher including graphs both with one particle more in the final state and with one loop more in the intermediate state. This is accurate to the order of the calculation, and limited to a first- or second-order corrections. Matching and Merging Multiple hard real emission corrections, but neglecting the virtual corrections that should accompany the corrections. Thereby it is possible to allow for topologies with a larger and varying number of partons, at the prize of not being accurate to any particular order. Matching and Merging The parton shower provides an approximation to higher orders, both real and virtual contributions for the emission of arbitrarily many particles. Each of these approaches have drawbacks in complementary phasespace regions (the first two not being suitable in soft/collinear emissions regions, and thus unsuitable to combine with hadronization, while the third fails in hard, well-separated regions), such that many schemes to combine the strengths of the different approaches exist. Matching and Merging The common traits of all combination methods are that matrix elements are used to describe the production of hard and well separated particles, and parton showers for the production of soft or collinear particles. What differs between the various approaches that have been proposed are which matrix elements are being used, how doublecounting is avoided, and how the transition from the hard to the soft regime is handled. These combination methods are typically referred to as 'matching' or 'merging' algorithms. There is some confusion about the distinction between the two terms. We will use 'matching' to describe the combination of one (NLO) calculation with the parton shower, and 'merging' when several calculations are combined with each other (and the shower).  PYTHIA offers implementations of several different matching and merging algorithms, which hopefully suit most needs. Matching and Merging Matching and Merging For many/most resonance decays the first branching in the shower is merged with first-order matrix elements Matching and Merging Ben87, Nor01. This means that the emission rate is accurate to NLO, similarly to the POWHEG strategy (see below), but built into the Matching and Merging timelike showers. The angular orientation of the event after the first emission is only handled by the parton shower kinematics, however. Needless to say, this formalism is precisely what is tested by Matching and Merging Z^0 decays at LEP1, and it is known to do a pretty good job there. Matching and Merging Also the Matching and Merging spacelike showers contain a correction to first-order matrix elements, but only for the one-body-final-state processes Matching and Merging q qbar &rarr; gamma^*/Z^0/W^+-/h^0/H^0/A0/Z'0/W'+-/R0 Matching and Merging Miu99 and Matching and Merging g g &rarr; h^0/H^0/A0 , and only to leading order. That is, it is equivalent to the POWHEG formalism for the real emission, but the prefactor 'cross section normalization' is LO rather than NLO. Therefore this framework is less relevant, and has been superseded the following ones. Matching and Merging The POWHEG strategy Matching and Merging Nas04 provides a cross section accurate to NLO. The hardest emission is constructed with unit probability, based on the ratio of the real-emission matrix element to the Born-level cross section, and with a Sudakov factor derived from this ratio, i.e. the philosophy introduced in Matching and Merging Ben87. Matching and Merging While POWHEG is a generic strategy, the POWHEG BOX Matching and Merging Ali10 is an explicit framework, within which several processes are available. The code required for merging the PYTHIA showers with POWHEG input can be found in Matching and Merging include/Pythia8Plugins/PowHegHooks.h , and is further described on a Matching and Merging separate page.  A user example is found in Matching and Merging examples/main31. Matching and Merging The other traditional approach for NLO calculations is the MC\@NLO one Matching and Merging Fri02. In it the shower emission probability, without its Sudakov factor, is subtracted from the real-emission matrix element to regularize divergences. It therefore requires a analytic knowledge of the way the shower populates phase space.  The aMC\@NLO package Matching and Merging Fre11 offers an implementation for PYTHIA 8, developed by Paolo Torrielli and Stefano Frixione. The global-recoil option of the PYTHIA final-state shower has been constructed to be used for the above-mentioned subtraction. Matching and Merging Multi-jet merging in the CKKW-L approach Matching and Merging Lon01 is directly available. Its implementation, relevant parameters and test programs are documented on a Matching and Merging separate page. Matching and Merging Multi-jet matching in the MLM approach Matching and Merging Man02, Man07 is also available, either based on the ALPGEN or on the Madgraph variant, and with input events either from ALPGEN or from Madgraph. For details see Matching and Merging separate page. Matching and Merging Unitarised matrix element + parton shower merging (UMEPS) is directly available. Its implementation, relevant parameters and test programs are documented on a Matching and Merging separate page. Matching and Merging Next-to-leading order multi-jet merging (in the NL3 and UNLOPS approaches) is directly available. Its implementation, relevant parameters and test programs are documented on a Matching and Merging separate page. Matching and Merging Next-to-leading order jet matching in the FxFx approach is also available. For details see Matching and Merging the jet matching page. Matching and Merging For quick-and-dirty studies, note that the field is open-ended, however: any external program can feed in Matching and Merging Les Houches events that PYTHIA subsequently processes. In this case, the maximum Matching and Merging pT of the shower evolution is set by the Les Houches Matching and Merging scale , on the one hand, and by the values of the Matching and Merging SpaceShower:pTmaxMatch , Matching and Merging TimeShower:pTmaxMatch and other parton-shower settings, on the other. It is typically not possible to achieve perfect matching this simplistic way, given that the PYTHIA Matching and Merging pT evolution variables are not likely to agree with the variables used for cuts in the external program. Often one can get close enough with simple means but, for an improved matching, Matching and Merging User Hooks may be inserted to control the steps taken on the way, e.g. to veto those parton shower branchings that would doublecount emissions included in the matrix elements. Matching and Merging Matching and Merging Matching and Merging main89.cc: A generic interface for matching and merging A common Pythia main program for MC\@NLO NLO+PS matching, MLM jet merging, FxFx (NLO) jet merging, CKKW-L merging, UMEPS merging and UNLOPS (NLO) merging is available through Matching and Merging main89.cc , together with the input files Matching and Merging main89mlm.cmnd , Matching and Merging main89fxfx.cmnd , Matching and Merging main89ckkwl.cmnd , Matching and Merging main89umeps.cmnd and Matching and Merging main89unlops.cmnd. The interface to MLM jet matching relies on MadGraph, while all other options of Matching and Merging main89.cc use aMC\@NLO input. Matching and Merging main89.cc produces HepMC events Matching and Merging Dob01 , that can be histogrammed (e.g. using RIVET Matching and Merging Buc10 ), or used as input for a detector simulation. If the user is not familiar with HepMC analysis tools, it is possible to instead use Pythia's histogramming routines. For this, remove the lines referring to HepMC, and histogram events as illustrated (for CKKW-L) for the histogram Matching and Merging histPTFirstSum in Matching and Merging main84.cc , i.e. using Matching and Merging weight*normhepmc as weight. Matching and Merging All settings can be transferred to Matching and Merging main89.cc through an input file. The input file is part of the command line input of Matching and Merging main89.cc , i.e. you can execute Matching and Merging main89 with the command Matching and Merging Matching and Merging ./main89 myInputFile.cmnd myhepmc.hepmc Matching and Merging to read the input Matching and Merging myInputFile.cmnd and produce the output file Matching and Merging myhepmc.hepmc. Since Matching and Merging main89.cc is currently a 'front-end' for different types of matching/merging, we will briefly discuss the inputs for this sample program in the following. Matching and Merging Inputs In its current form, Matching and Merging main89.cc uses LHEF input to transfer (weighted) phase space points to Pythia. It is possible to include all parton multiplicities in one LHEF sample. If e.g. UMEPS merging for W-boson + up to two additional partons is to be performed, one LHE file containing W+zero, W+one and W+two parton events is required. Matching and Merging All input settings are handed to Matching and Merging main89.cc in the form of an input file. We have included the input settings files Matching and Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; Matching and Merging main89mlm.cmnd , which illustrates the MLM jet matching interface, Matching and Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; Matching and Merging main89ckkwl.cmnd , which illustrates the CKKW-L multi-jet merging interface, Matching and Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; Matching and Merging main89umeps.cmnd , which illustrates the UMEPS multi-jet merging interface, and Matching and Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; Matching and Merging main89fxfx.cmnd , which illustrates the FxFx NLO jet matching interface, Matching and Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; Matching and Merging main89unlops.cmnd , which illustrates the UNLOPS multi-jet NLO merging interface. Matching and Merging Other settings (e.g. using Matching and Merging main89.cc as simple LO+PS or as MC\@NLO interface) are of course possible. In the following, we will briefly explain how input for the five choices above are generated and handled. Matching and Merging MLM jet matching with main89.cc For MLM jet matching, Matching and Merging main89.cc currently relies on LHEF input from MadGraph. Due to the particular unweighting strategy performed in the generation of these inputs, the sample program starts by estimating the cross section. After this estimate, MLM jet matching within the Madgraph approach is performed in a second Pythia run. Example MLM settings can be found in Matching and Merging main89mlm.cmnd. Please consult Matching and Merging Jet Matching for more details. Matching and Merging CKKW-L merging with main89.cc For CKKW-L merging, Matching and Merging main89.cc currently relies on LHEF inputs generated with the leading-order mode of aMC\@NLO (i.e. events should be generated with Matching and Merging ./bin/generate_events aMC\@LO ). No run to estimate the cross section estimate is needed. Example CKKW-L settings can be found in Matching and Merging main89ckkwl.cmnd. Please consult Matching and Merging CKKW-L merging for more details. Matching and Merging UMEPS merging with main89.cc For UMEPS merging, Matching and Merging main89.cc currently relies on LHEF inputs generated with the leading-order mode of aMC\@NLO as well (see above). Matching and Merging main89.cc automatically assigns if an event will be used as 'standard' event or as 'subtractive' contribution. Example UMEPS settings can be found in Matching and Merging main89umeps.cmnd. Please consult Matching and Merging UMEPS merging and Matching and Merging CKKW-L merging for more details. Matching and Merging FxFx (NLO) jet matching with main89.cc For FxFx jet matching, Matching and Merging main89.cc relies on MC\@NLO input LHE files generated with aMC\@NLO. To produce FxFx outputs in aMC\@NLO, the settings Matching and Merging PYTHIA8  = parton_shower , Matching and Merging 3 = ickkw and Matching and Merging x = ptj are necessary in your aMC\@NLO run card. Here, Matching and Merging x is the value of the matching scale in FxFx, i.e. has be identical to Matching and Merging JetMatching:qCutME in the Pythia inputs. Example FxFx settings for Pythia can be found in Matching and Merging main89fxfx.cmnd. Please consult Matching and Merging Jet Matching and Matching and Merging aMC\@NLO matching for more details. Matching and Merging UNLOPS (NLO) merging with main89.cc For UNLOPS merging, Matching and Merging main89.cc currently relies on LHEF inputs generated with the aMC\@NLO. The UNLOPS interface in Matching and Merging main89.cc requires a) leading-order inputs generated with the leading-order mode of aMC\@NLO, using the UNLOPS prescription, and b) next-to-leading-order inputs generated with the NLO mode of aMC\@NLO, using the UNLOPS prescription. To produce UNLOPS outputs in aMC\@NLO, the settings Matching and Merging PYTHIA8  = parton_shower , Matching and Merging 4 = ickkw and Matching and Merging x = ptj are necessary in your aMC\@NLO run card. Here, Matching and Merging x is the value of the merging scale in UNLOPS, i.e. has be identical to Matching and Merging Merging:TMS in the Pythia inputs. Matching and Merging main89.cc will then process NLO inputs and LO inputs consecutively, and will automatically assign if an event will be used as 'standard' event or as 'subtractive' contribution. Example UNLOPS settings can be found in Matching and Merging main89umeps.cmnd. Please consult Matching and Merging UMEPS merging and Matching and Merging CKKW-L merging for more details."},{"name":"MLM jet merging","link":"JetMatching.html","text":"MLM jet merging MLM jet merging MLM jet merging This manual page describes the parton-jet matching interfaces for PYTHIA8. In this approach, usually referred to as MLM merging MLM jet merging Man02, Man07 , the final jets after parton-shower evolution and jet clustering are matched to the original partons. The event is accepted if a reasonable match is found, and rejected if not. The rejection step in an approximate way introduces a Sudakov form factor on to the hard processes. Notably the parton shower should not generate an emission that would doublecount hard activity already included in the matrix-element description. Within this general ansatz, different technical solutions can be adopted. We provide two alternatives, one based on the algorithm used in ALPGEN MLM jet merging Man03 , and another on the one used in Madgraph MLM jet merging Alw11 , both reimplemented from scratch here. The main points of these two algorithms are outlined further down on this page. MLM jet merging We also allow for two alternative sources of external events, one in the ALPGEN native format and one in the Madgraph LHEF-based one. All four combinations of input format and scheme are implemented. In the following it is therefore important to keep the two aspects apart, whenever the ALPGEN and Madgraph labels are used. MLM jet merging Currently all the files of interest are located in the MLM jet merging include/Pythia8Plugins/ subdirectory: MLM jet merging MLM jet merging MLM jet merging JetMatching.h contains the machinery for the parton-jet matching, in the two MLM jet merging JetMatchingAlpgen and MLM jet merging JetMatchingMadgraph classes. MLM jet merging MLM jet merging GeneratorInput.h contains three classes for the reading of ALPGEN event and parameter files, and one for the reading of Madgraph parameters. MLM jet merging MLM jet merging CombineMatchingInput.h contains three classes that combine the reading of events with the merging of them. MLM jet merging MLM jet merging main32.cc, main32.cmnd : a sample main program and card file showing the usage of the previous files/classes. MLM jet merging Event input source External sources of partons are used in the parton-jet matching process. The source of the partons has been separated from the implementation of the algorithm. By default, PYTHIA8 contains a machinery to process MLM jet merging Les Houches Event Files (LHEFs) Madgraph5 adheres to this format, but also contains some further non-standardized information that can be used. The parsing of the native ALPGEN file format is described on the MLM jet merging Alpgen Event Interface page. MLM jet merging Commonly, the source of external partons also contains information about how a particular type of algorithm should be employed. This information is handled by the MLM jet merging AlpgenPar class for ALPGEN files, and MLM jet merging MadgraphPar for LHEFs. The user can choose to set default merging parameters using the MLM jet merging MLM jet merging Alpgen:setMLM flag for ALPGEN files. For LHEFs, instead, the setting of default parameters is controlled with the MLM jet merging JetMatching:setMad flag: MLM jet merging Jet Matching parameters A class MLM jet merging JetMatching , derived from MLM jet merging UserHooks , is used to define the basic structure of a parton-jet matching algorithm. Two versions are implemented here, based on the FORTRAN code provided by the ALPGEN and Madgraph packages, respectively: MLM jet merging JetMatchingAlpgen and MLM jet merging JetMatchingMadgraph. The merging parameters are defined with the MLM jet merging JetMatching:* keyword. MLM jet merging Scheme and Usage MLM jet merging Jet algorithm The choice of jet algorithm and associated parameters can be adjusted with the settings below. The PYTHIA8 internal MLM jet merging CellJet and MLM jet merging SlowJet routines are used for jet finding.  See the MLM jet merging Event Analysis page for more details. MLM jet merging Merging parameters The following options are the three main parameters for the merging procedure. Although here they are in principle free parameters, they should be heavily influenced by the hard process generation cuts. These values can be set automatically based on the information in the ALPGEN file or LHEF. MLM jet merging Exclusive mode The following settings determine whether clustered jets which do not match an original hard parton are allowed. They are typically permitted in the highest jet multiplicity sample, where the parton shower may produce extra hard jets, without risk of double counting. Any extra jet produced by the shower must be softer than any matched light jet, or else the event is vetoed. MLM jet merging Jet matching The following parameters control the criteria for matching a clustered jet to a hard parton. MLM jet merging Alpgen-specific parameters MLM jet merging Madgraph-specific parameters MLM jet merging A preliminary implementation of the FxFx prescription for combining multiple NLO calculations MLM jet merging Fre12 is available. We would like to stress that this implementation is still undergoing validation. FxFx merging with aMC\@NLO shares most parameters with the leading-order (MadGraph-style) MLM prescriptions and can be activated by using the three additional settings below. MLM jet merging Alpgen-style parton-jet merging This section describes the Alpgen-style MLM merging algorithm for PYTHIA8. The most common reference to the algorithm is MLM jet merging Man02. In many respects, however, the implementation provided in the ALPGEN package should be considered the official description of the MLM merging procedure. Although designed primarily to work with events generated with ALPGEN, it can in principle also be used with events from a different source. This should not be done without thought, however, and it is up to the user to understand the details of the algorithm and the implications of using a different hard process generator. MLM jet merging First, either the MLM jet merging CellJet or MLM jet merging SlowJet jet algorithm is chosen. Both of these algorithms have an MLM jet merging R and an MLM jet merging etaMax parameter. In addition, MLM jet merging CellJet has an MLM jet merging eTmin and MLM jet merging SlowJet has a MLM jet merging pTmin parameter. These are the primary three parameters of the merging procedure, and in practice are set dependent on the cuts applied to the matrix element (ME) generation. We stress that the merging procedure is not tied to the geometry of a specific physical detector, but only to the match between the original partons and the resulting jets, using standard jet algorithms in the phase space region where partons have been generated. MLM jet merging ME samples with different jet multiplicities are run through the event generator, and the generation interrupted after parton showers have been applied, but before resonance decays and beam remnants have been processed. Note in particular that top quarks will not yet be decayed, which may lead to slight differences with the PYTHIA 6 interface included with the ALPGEN package. In what follows, the hardness measure of jets/partons is taken to be MLM jet merging eT when MLM jet merging CellJet is used and MLM jet merging pT when MLM jet merging SlowJet is used. The hard system (ignoring all MPI systems) is then analysed: MLM jet merging MLM jet merging The particles in the original matrix element process are sorted into    light partons, heavy partons and other particles. For backwards    compatibility, a light parton is defined as the set MLM jet merging (d, u, s, c,    b, g) with zero mass. A heavy parton is defined as the set MLM jet merging (c, b, t) with non-zero mass. MLM jet merging All particles not originating from the heavy partons or other    particles are passed to the jet algorithm and clustered. MLM jet merging Clustered jets are matched to the light partons in the original ME    process. There are two different methods which can be used: MLM jet merging MLM jet merging Method 1: The following is done for each parton, in order      of decreasing hardness. The MLM jet merging delta R between the parton      and all jets is calculated and the smallest value taken. If      this is less than the jet MLM jet merging R parameter, possibly      multiplied by a constant, the jet and parton are considered to      match, and the jet is removed from further consideration.      Note that for MLM jet merging CellJet the MLM jet merging delta R measure      is in MLM jet merging (eta, phi) , while for MLM jet merging SlowJet , it is      in MLM jet merging (y, phi). MLM jet merging Method 2: This method is only possible when using the MLM jet merging SlowJet algorithm. Before the clustering is performed,      extremely soft 'ghost' particles are added to the event at the MLM jet merging (y, phi) coordinates of the original matrix element      partons. If such a particle is clustered into a jet, the parton      and jet are considered to match. The idea of 'ghost' particles      was originally introduced by FastJet as a way to measure jet      areas MLM jet merging Cac06 and should not affect clustering with an      infrared-safe jet algorithm. MLM jet merging If there is a light ME parton remaining which has not been matched    to a jet, then the event is vetoed. If all ME partons have been    matched to a jet, but there are still some extra jets remaining,    then two options are possible: MLM jet merging MLM jet merging Exclusive mode: the event is vetoed. This is typically used when      there are ME samples with higher jet multiplicities, which would      fill in the extra jets. MLM jet merging Inclusive mode: the event is retained if the extra jets are softer      than the softest matched jet. This is typically used when      there is no ME sample with higher jet multiplicity, so the parton      shower should be allowed to give extra jets. MLM jet merging All particles originating from the heavy partons are passed to the    jet algorithm and clustered. MLM jet merging The clustered jets are again matched to the original partons, but    there is no requirement for a match to be present; all matched jets    are immediately discarded. The matching procedure is much the same    as for light partons, but with two differences when MLM jet merging delta R matching is used. First, a different MLM jet merging R parameter than that    used by the jet algorithm may optionally be given. Second, all jets    that are within the given radius of the parton are matched, not    just the one with the smallest MLM jet merging delta R measure. If there    are still extra jets remaining then in exclusive mode the event is    immediately vetoed, while in inclusive mode the event is retained if    the extra jets are softer than the softest MLM jet merging light matched jet. MLM jet merging Some different options are provided, specified further above in the parameters section. These are set so that, by default, the algorithm closely follows the official MLM interface provided in the ALPGEN package. MLM jet merging All vetoing of events is done through the usual MLM jet merging User Hooks machinery, and is therefore already taken into account in the cross section. In the output from MLM jet merging MLM jet merging Pythia::stat() , the difference between the 'Selected' and 'Accepted' columns gives the number of events that have not survived the vetoing procedure. It is still the responsibility of the user to add together the results from runs with different jet multiplicities. In the simplest case, when ALPGEN input is used and the hard process parameters are used to guide the merging procedure, it is enough to set the MLM jet merging JetMatching:nJetMax parameter. MLM jet merging Madgraph-style parton-jet merging MLM jet merging This section describes the Madgraph parton-jet merging algorithm for PYTHIA8. MLM jet merging First, the k MLM jet merging T jet algorithm is applied using the PYTHIA8 MLM jet merging SlowJet implementation. The MLM jet merging useStandardR = false is used, ie. the MLM jet merging (delta R)^2 separation is defined as MLM jet merging 2 (cosh(delta y) - cos(delta phi)) rather than the more common MLM jet merging (delta y)^2 + delta phi)^2. The MLM jet merging R , MLM jet merging etaMax , and a MLM jet merging pTmin parameters are specified. By default, MLM jet merging R = 1 and MLM jet merging pTmin = qCut. It is not recommended to change these. These should match the algorithm parameters used in the Madgraph Matrix Element (ME) generation. MLM jet merging ME samples with different jet multiplicities are run through the event generator, and the generation is interrupted after parton showers have been applied, but before resonance decays and beam remnants have been processed. In what follows, the hardness measure of jets/partons is taken to be MLM jet merging k MLM jet merging T relative to MLM jet merging qCut. The hard system (ignoring all MPI systems) is analyzed: MLM jet merging MLM jet merging The hard partons in the original matrix element process, provided by    the LHEF, are sorted into light partons, heavy partons and other    particles. A heavy parton is defined by the MLM jet merging JetMatching:nQmatch or by the MLM jet merging maxjetflavor value in the LHEF. MLM jet merging nQmatch refers to the absolute value of    the quark PDG identity code. MLM jet merging All partons arising from the parton shower are sorted based on their    motherhood. A showered parton arising from a heavy parton or 'other'    parton classified in the previous step is not passed to the jet    algorithm. All other partons are clustered into light jets. MLM jet merging It is checked whether there are 'too few' or 'too many' light jets.    If the number of light jets is less than the number of light partons    defined by MLM jet merging nQmatch , the event is vetoed. If the number is    larger, the event is vetoed only in exclusive mode (defined below). MLM jet merging In exclusive mode, the number of jets matches the number of light    partons. In inclusive mode, the jets are re-clustered until the number    of jets equals the number of light partons. Next, each light hard    parton is clustered, one at a time, with the jets until a match is found.    A match is defined as a squared cluster scale that equals: MLM jet merging MLM jet merging MLM jet merging |clFact| * qCut for inclusive mode, MLM jet merging MLM jet merging |clFact| * max(qCut,min(p MLM jet merging T (parton))) for exclusive mode, MLM jet merging clFact &ge; 0, or MLM jet merging MLM jet merging |clFact| * min(k MLM jet merging T (parton)) for exclusive       mode, MLM jet merging clFact < 0. If no match is found, the event is vetoed. When a parton    matches a jet, the jet is removed from the collection, and    the process continues. The process terminates when all partons    are matched to a jet, or a parton is unmatched. MLM jet merging All particles originating from the heavy partons are not used. In exclusive mode, it is expected that ME samples with higher parton multiplicity are available to fill the phase space above MLM jet merging qCut. The inclusive mode is when there are no such samples, and the parton shower is used to fill the phase space. MLM jet merging Some different options are provided, specified further above. These are set so that, by default, the algorithm closely follows the FORTRAN interface MLM jet merging ME2Pythia provided in the Madgraph package. MLM jet merging All vetoing of events is done through the usual MLM jet merging User Hooks machinery, and is therefore already taken into account in the cross section. In the output from MLM jet merging MLM jet merging Pythia::stat() , the difference between the 'Selected' and 'Accepted' columns gives the number of events that have not survived the vetoing procedure. It is still the responsibility of the user to add together the results from runs with different jet multiplicities. In the simplest case, when the hard process parameters are used to guide the merging procedure, events will be matched in the exclusive mode. MLM jet merging Madgraph scheme with no internal vetoes (assuming an external veto implementation) MLM jet merging This section describes the facilities that allow expert users to use their own veto code to perform a Madgraph-style merging. This can e.g. be useful to assess parameter changes without having to process the same input events multiple times. MLM jet merging As a first step, any vetoes in the Pythia Jet Matching need to be disabled by using MLM jet merging JetMatching:doVeto = off. In this mode, Pythia only stores all the information that is necessary to check (and apply) the shower-kT or kT-MLM vetoes externally by hand. This information can be accessed by calling the functions MLM jet merging We do not currently supply example code for this very advanced functionality. Interested expert users should feel free to contact the Pythia authors for further explanations. MLM jet merging MLM jet merging A note on combining UserHooks As have been noted above, the matching is implemented using classes derived from the MLM jet merging MLM jet merging UserHooks class, thereby gaining access to the event generation process at the relevant locations. For native ALPGEN files, which do not adhere to the Les Houches standards, it is also necessary to intervene with a MLM jet merging UserHooks -derived MLM jet merging AlpgenHooks to handle the extraction and setting of relevant extra information. MLM jet merging One must then combine multiple MLM jet merging UserHooks classes, such that the functionality of both is present. A prerequisite is that the different MLM jet merging UserHooks classes should be declared with virtual inheritance, e.g. MLM jet merging class JetMatching : virtual public UserHooks Without this option, when combining two MLM jet merging UserHooks -derived classes, two copies of the base MLM jet merging UserHooks class would be created, leading to ambiguities. MLM jet merging The two first classes in MLM jet merging CombineMatchingInput.h combine ALPGEN input with the two different matching schemes, e.g. for the first MLM jet merging class JetMatchingAlpgenInputAlpgen : public AlpgenHooks,  public JetMatchingAlpgen { public:  // Constructor and destructor.  JetMatchingAlpgenInputAlpgen(Pythia& pythia) : AlpgenHooks(pythia),    JetMatchingAlpgen() { }  ~JetMatchingAlpgenInputAlpgen() {}  // Initialisation.  virtual bool initAfterBeams() {    if (!AlpgenHooks::initAfterBeams()) return false;    if (!JetMatchingAlpgen::initAfterBeams()) return false;    return true;  }  // Process level vetos.  virtual bool canVetoProcessLevel() {    return JetMatchingAlpgen::canVetoProcessLevel();  }  .... }; This class inherits from both MLM jet merging AlpgenHooks and MLM jet merging JetMatchingAlpgen. Any functions which are present in both classes should be overridden with a function that calls the different parent methods in the desired order. In the above example, the only shared methods are the constructor and MLM jet merging initAfterBeams()."},{"name":"Multiparton Interactions","link":"MultipartonInteractions.html","text":"Multiparton Interactions Multiparton Interactions Multiparton Interactions The starting point for the multiparton interactions physics scenario in PYTHIA is provided by Multiparton Interactions Sjo87. Recent developments have included a more careful study of flavour and colour correlations, junction topologies and the relationship to beam remnants Multiparton Interactions Sjo04 , interleaving with initial-state radiation Multiparton Interactions Sjo05 , making use of transverse-momentum-ordered initial- and final-state showers, with the extension to fully interleaved evolution covered in Multiparton Interactions Cor10a. A framework to handle rescattering is described in Multiparton Interactions Cor09. Multiparton Interactions A big unsolved issue is how the colour of all these subsystems is correlated. For sure there is a correlation coming from the colour singlet nature of the incoming beams, but in addition final-state colour rearrangements may change the picture. Indeed such extra effects appear necessary to describe data, e.g. on Multiparton Interactions <pT>(n_ch). A simple implementation of colour rearrangement is found as part of the Multiparton Interactions beam remnants description. Multiparton Interactions Main variables Multiparton Interactions Matching to hard process The maximum Multiparton Interactions pT to be allowed for multiparton interactions is related to the nature of the hard process itself. It involves a delicate balance between not double-counting and not leaving any gaps in the coverage. The best procedure may depend on information only the user has: how the events were generated and mixed (e.g. with Les Houches Accord external input), and how they are intended to be used. Therefore a few options are available, with a sensible default behaviour. Multiparton Interactions Cross-section parameters The rate of interactions is determined by Multiparton Interactions The actual value is then regulated by the running to the scale Multiparton Interactions pT^2 , at which it is evaluated Multiparton Interactions QED interactions are regulated by the Multiparton Interactions alpha_electromagnetic value at the Multiparton Interactions pT^2 scale of an interaction. Multiparton Interactions Note that the choices of Multiparton Interactions alpha_strong and Multiparton Interactions alpha_em made here override the ones implemented in the normal process machinery, but only for the interactions generated by the Multiparton Interactions MultipartonInteractions class. Multiparton Interactions In addition there is the possibility of a global rescaling of cross sections (which could not easily be accommodated by a changed Multiparton Interactions alpha_strong , since Multiparton Interactions alpha_strong runs) Multiparton Interactions The processes used to generate multiparton interactions form a subset of the standard library of hard processes. The input is slightly different from the standard hard-process machinery, however, since incoming flavours, the Multiparton Interactions alpha_strong value and most of the kinematics are already fixed when the process is called. It is possible to regulate the set of processes that are included in the multiparton-interactions framework. Multiparton Interactions Cross-section regularization There are two complementary ways of regularizing the small- Multiparton Interactions pT divergence, a sharp cutoff and a smooth dampening. These can be combined as desired, but it makes sense to coordinate with how the same issue is handled in Multiparton Interactions spacelike showers. Actually, by default, the parameters defined here are used also for the spacelike showers, but this can be overridden. Multiparton Interactions Regularization of the divergence of the QCD cross section for Multiparton Interactions pT &rarr; 0 is obtained by a factor Multiparton Interactions pT^4 / (pT0^2 + pT^2)^2 , and by using an Multiparton Interactions alpha_s(pT0^2 + pT^2). An energy dependence of the Multiparton Interactions pT0 choice is introduced by two further parameters, so that Multiparton Interactions pT0Ref is the Multiparton Interactions pT0 value for the reference CM energy, Multiparton Interactions pT0Ref = pT0(ecmRef). Multiparton Interactions Warning: if a large Multiparton Interactions pT0 is picked for multiparton interactions, such that the integrated interaction cross section is below the nondiffractive inelastic one, this Multiparton Interactions pT0 will automatically be scaled down to cope. Multiparton Interactions The actual Multiparton Interactions pT0 parameter used at a given CM energy scale, Multiparton Interactions ecmNow , is obtained from a power law or a logarithmic parametrization. The former is default with hadron beams and the latter for photon-photon collisions. Multiparton Interactions Alternatively, or in combination, a sharp cut can be used. Multiparton Interactions G&ouml;sta Gustafson has proposed (private communication, unpublished) that the amount of screening, as encapsulated in the Multiparton Interactions pT0 parameter, fluctuates from one event to the next. Specifically, high-activity event are more likely to lead to interactions at large Multiparton Interactions pT scales, but the high activity simultaneously leads to a larger screening of interactions at smaller Multiparton Interactions pT. Such a scenario can approximately be simulated by scaling up the Multiparton Interactions pT0 by a factor Multiparton Interactions sqrt(n) , where Multiparton Interactions n is the number of interactions considered so far, including the current one. That is, for the first interaction the dampening factor is Multiparton Interactions pT^4 / (pT0^2 + pT^2)^2 , for the second Multiparton Interactions pT^4 / (2 pT0^2 + pT^2)^2 , for the third Multiparton Interactions pT^4 / (3 pT0^2 + pT^2)^2 , and so on. Optionally the scheme may also be applied to ISR emissions. For simplicity the same Multiparton Interactions alpha_s(pT0^2 + pT^2) is used throughout. Note that, in this scenario the Multiparton Interactions pT0 scale must be lower than in the normal case to begin with, since it later is increased back up. Also note that the idea with this scenario is to propose an alternative to colour reconnection to understand the rise of Multiparton Interactions <pT>(n_ch) , so that the amount of colour reconnection should be reduced. Multiparton Interactions Impact-parameter dependence The choice of impact-parameter dependence is regulated by several parameters. The ones listed here refer to nondiffractive topologies only, while their equivalents for diffractive events are put in the Multiparton Interactions Diffraction description. Note that there is currently no Multiparton Interactions bProfile = 4 option for diffraction. Other parameters are assumed to agree between diffractive and nondiffractive topologies. Multiparton Interactions Rescattering It is possible that a parton may rescatter, i.e. undergo a further interaction subsequent to the first one. The machinery to model this kind of physics has only recently become fully operational Multiparton Interactions Cor09 , and is therefore not yet so well explored. Multiparton Interactions The rescattering framework has ties with other parts of the program, notably with the Multiparton Interactions beam remnants. Multiparton Interactions Further variables These should normally not be touched. Their only function is for cross-checks. Multiparton Interactions Technical notes Relative to the articles mentioned above, not much has happened. The main news is a technical one, that the phase space of the Multiparton Interactions 2 &rarr; 2 (massless) QCD processes is now sampled in Multiparton Interactions dy_3 dy_4 dpT^2 , where Multiparton Interactions y_3 and Multiparton Interactions y_4 are the rapidities of the two produced partons. One can show that Multiparton Interactions (dx_1 / x_1) * (dx_2 / x_2) * d(tHat) = dy_3 * dy_4 * dpT^2 Furthermore, since cross sections are dominated by the 'Rutherford' one of Multiparton Interactions t -channel gluon exchange, which is enhanced by a factor of 9/4 for each incoming gluon, effective structure functions are defined as Multiparton Interactions F(x, pT2) = (9/4) * xg(x, pT2) + sum_i xq_i(x, pT2) With this technical shift of factors 9/4 from cross sections to parton densities, a common upper estimate of Multiparton Interactions d(sigmaHat)/d(pT2) < pi * alpha_strong^2 / pT^4 is obtained. Multiparton Interactions In fact this estimate can be reduced by a factor of 1/2 for the following reason: for any configuration Multiparton Interactions (y_3, y_4, pT2) also one with Multiparton Interactions (y_4, y_3, pT2) lies in the phase space. Not both of those can enjoy being enhanced by the Multiparton Interactions tHat &rarr; 0 singularity of Multiparton Interactions d(sigmaHat) propto 1/tHat^2. Or if they are, which is possible with identical partons like Multiparton Interactions q q &rarr; q q and Multiparton Interactions g g &rarr; g g , each singularity comes with half the strength. So, when integrating/averaging over the two configurations, the estimated Multiparton Interactions d(sigmaHat)/d(pT2) drops. Actually, it drops even further, since the naive estimate above is based on Multiparton Interactions (4 /9) * (1 + (uHat/sHat)^2) < 8/9 < 1 The 8/9 value would be approached for Multiparton Interactions tHat &rarr; 0 , which implies Multiparton Interactions sHat >> pT2 and thus a heavy parton-distribution penalty, while parton distributions are largest for Multiparton Interactions tHat = uHat = -sHat/2 , where the above expression evaluates to 5/9. A fudge factor is therefore introduced to go the final step, so it can easily be modified when further non-Rutherford processes are added, or should parton distributions change significantly. Multiparton Interactions At initialization, it is assumed that Multiparton Interactions d(sigma)/d(pT2) < d(sigmaHat)/d(pT2) * F(x_T, pT2) * F(x_T, pT2)      * (2 y_max(pT))^2 where the first factor is the upper estimate as above, the second two the parton density sum evaluated at Multiparton Interactions y_3 = y_ 4 = 0 so that Multiparton Interactions x_1 = x_2 = x_T = 2 pT / E_cm , where the product is expected to be maximal, and the final is the phase space for Multiparton Interactions -y_max < y_{3,4} < y_max. The right-hand side expression is scanned logarithmically in Multiparton Interactions y , and a Multiparton Interactions N is determined such that it always is below Multiparton Interactions N/pT^4. Multiparton Interactions To describe the dampening of the cross section at Multiparton Interactions pT &rarr; 0 by colour screening, the actual cross section is multiplied by a regularization factor Multiparton Interactions (pT^2 / (pT^2 + pT0^2))^2 , and the Multiparton Interactions alpha_s is evaluated at a scale Multiparton Interactions pT^2 + pT0^2 , where Multiparton Interactions pT0 is a free parameter of the order of 2 - 4 GeV. Since Multiparton Interactions pT0 can be energy-dependent,  an ansatz Multiparton Interactions pT0(ecm) = pT0Ref * (ecm/ecmRef)^ecmPow is used, where Multiparton Interactions ecm is the current CM frame energy, Multiparton Interactions ecmRef is an arbitrary reference energy where Multiparton Interactions pT0Ref is defined, and Multiparton Interactions ecmPow gives the energy rescaling pace. For technical reasons, also an absolute lower Multiparton Interactions pT scale Multiparton Interactions pTmin , by default 0.2 GeV, is introduced. In principle, it is possible to recover older scenarios with a sharp Multiparton Interactions pT cutoff by setting Multiparton Interactions pT0 = 0 and letting Multiparton Interactions pTmin be a larger number. Multiparton Interactions The above scanning strategy is then slightly modified: instead of an upper estimate Multiparton Interactions N/pT^4 one of the form Multiparton Interactions N/(pT^2 + r * pT0^2)^2 is used. At first glance, Multiparton Interactions r = 1 would seem to be fixed by the form of the regularization procedure, but this does not take into account the nontrivial dependence on Multiparton Interactions alpha_s , parton distributions and phase space. A better Monte Carlo efficiency is obtained for Multiparton Interactions r somewhat below unity, and currently Multiparton Interactions r = 0.25 is hardcoded.  In the generation a trial Multiparton Interactions pT2 is then selected according to Multiparton Interactions d(Prob)/d(pT2) = (1/sigma_ND) * N/(pT^2 + r * pT0^2)^2 * ('Sudakov') For the trial Multiparton Interactions pT2 , a Multiparton Interactions y_3 and a Multiparton Interactions y_4 are then selected, and incoming flavours according to the respective Multiparton Interactions F(x_i, pT2) , and then the cross section is evaluated for this flavour combination. The ratio of trial/upper estimate gives the probability of survival. Multiparton Interactions Actually, to profit from the factor 1/2 mentioned above, the cross section for the combination with Multiparton Interactions y_3 and Multiparton Interactions y_4 interchanged is also tried, which corresponds to exchanging Multiparton Interactions tHat and Multiparton Interactions uHat , and the average formed, while the final kinematics is given by the relative importance of the two. Multiparton Interactions Furthermore, since large Multiparton Interactions y values are disfavoured by dropping PDF's, a factor Multiparton Interactions WT_y = (1 - (y_3/y_max)^2) * (1 - (y_4/y_max)^2) is evaluated, and used as a survival probability before the more time-consuming PDF+ME evaluation, with surviving events given a compensating weight Multiparton Interactions 1/WT_y. Multiparton Interactions An impact-parameter dependence is also allowed. Based on the hard Multiparton Interactions pT scale of the first interaction, and enhancement/depletion factor is picked, which multiplies the rate of subsequent interactions. Multiparton Interactions Parton densities are rescaled and modified to take into account the energy-momentum and flavours kicked out by already-considered interactions."},{"name":"New-Gauge-Boson Processes","link":"NewGaugeBosonProcesses.html","text":"New-Gauge-Boson Processes New-Gauge-Boson Processes New-Gauge-Boson Processes This page contains the production of new New-Gauge-Boson Processes Z'^0 and New-Gauge-Boson Processes W'^+- gauge bosons, e.g. within the context of a new New-Gauge-Boson Processes U(1) or New-Gauge-Boson Processes SU(2) gauge group, and also a (rather speculative) horizontal gauge boson New-Gauge-Boson Processes R^0. Left-right-symmetry scenarios also contain new gauge bosons, but are described New-Gauge-Boson Processes separately. New-Gauge-Boson Processes New-Gauge-Boson Processes Z'^0 This group only contains one subprocess, with the full New-Gauge-Boson Processes gamma^*/Z^0/Z'^0 interference structure for couplings to fermion pairs. It is possible to pick only a subset, e.g, only the pure New-Gauge-Boson Processes Z'^0 piece. No higher-order processes are available explicitly, but the ISR showers contain automatic matching to the New-Gauge-Boson Processes Z'^0 + 1 jet matrix elements, as for the corresponding &nbsp New-Gauge-Boson Processes gamma^*/Z^0 process. New-Gauge-Boson Processes The couplings of the New-Gauge-Boson Processes Z'^0 to quarks and leptons can either be assumed universal, i.e. generation-independent, or not. In the former case eight numbers parametrize the vector and axial couplings of down-type quarks, up-type quarks, leptons and neutrinos, respectively. Depending on your assumed neutrino nature you may want to restrict your freedom in that sector, but no limitations are enforced by the program. The default corresponds to the same couplings as that of the Standard Model New-Gauge-Boson Processes Z^0 , with axial couplings New-Gauge-Boson Processes a_f = +-1 and vector couplings New-Gauge-Boson Processes v_f = a_f - 4 e_f sin^2(theta_W) , with New-Gauge-Boson Processes sin^2(theta_W) = 0.23. Without universality the same eight numbers have to be set separately also for the second and the third generation. The choice of fixed axial and vector couplings implies a resonance width that increases linearly with the New-Gauge-Boson Processes Z'^0 mass. New-Gauge-Boson Processes By a suitable choice of the parameters, it is possible to simulate just about any imaginable New-Gauge-Boson Processes Z'^0 scenario, with full interference effects in cross sections and decay angular distributions and generation-dependent couplings; the default values should mainly be viewed as placeholders. The conversion from the coupling conventions in a set of different New-Gauge-Boson Processes Z'^0 models in the literature to those used in PYTHIA is described in New-Gauge-Boson Processes Cio08. New-Gauge-Boson Processes Here are the couplings always valid for the first generation, and normally also for the second and third by trivial analogy: New-Gauge-Boson Processes Here are the further couplings that are specific for a scenario with New-Gauge-Boson Processes Zprime:universality switched off: New-Gauge-Boson Processes The coupling to the decay channel New-Gauge-Boson Processes Z'^0 &rarr; W^+ W^- is more model-dependent. By default it is therefore off, but can be switched on as follows. New-Gauge-Boson Processes A massive New-Gauge-Boson Processes Z'^0 is also likely to decay into Higgs bosons and potentially into other now unknown particles. Such possibilities clearly are quite model-dependent, and have not been included for now. New-Gauge-Boson Processes Finally, to allow the exploration of more BSM physics scenarios, we include the possibility of the New-Gauge-Boson Processes Z'^0 (and hence the New-Gauge-Boson Processes gamma and New-Gauge-Boson Processes Z^0 ) coupling to a fourth generation of fermions. This provides redundancy with and extensions beyond those processes implemented as New-Gauge-Boson Processes fourth-generation processes. By default, the decay channels for the fourth-generation and not included. They are enabled using: New-Gauge-Boson Processes Here are the further couplings that are specific for a scenario with New-Gauge-Boson Processes Zprime:universality switched off: New-Gauge-Boson Processes New-Gauge-Boson Processes W'^+- The New-Gauge-Boson Processes W'^+- implementation is less ambitious than the New-Gauge-Boson Processes Z'^0. Specifically, while indirect detection of a New-Gauge-Boson Processes Z'^0 through its interference contribution is a possible discovery channel in lepton colliders, there is no equally compelling case for New-Gauge-Boson Processes W^+-/W'^+- interference effects being of importance for discovery, and such interference has therefore not been implemented for now. Related to this, a New-Gauge-Boson Processes Z'^0 could appear on its own in a new New-Gauge-Boson Processes U(1) group, while New-Gauge-Boson Processes W'^+- would have to sit in a New-Gauge-Boson Processes SU(2) group and thus have a New-Gauge-Boson Processes Z'^0 partner that is likely to be found first. Only one process is implemented but, like for the New-Gauge-Boson Processes W^+- , the ISR showers contain automatic matching to the New-Gauge-Boson Processes W'^+- + 1 jet matrix elements. New-Gauge-Boson Processes The couplings of the New-Gauge-Boson Processes W'^+- are here assumed universal, i.e. the same for all generations. One may set vector and axial couplings freely, separately for the New-Gauge-Boson Processes q qbar' and the New-Gauge-Boson Processes l nu_l decay channels. The defaults correspond to the New-Gauge-Boson Processes V - A structure and normalization of the Standard Model New-Gauge-Boson Processes W^+- , but can be changed to simulate a wide selection of models. One limitation is that, for simplicity, the same Cabibbo--Kobayashi--Maskawa quark mixing matrix is assumed as for the standard New-Gauge-Boson Processes W^+-. Depending on your assumed neutrino nature you may want to restrict your freedom in the lepton sector, but no limitations are enforced by the program. New-Gauge-Boson Processes The coupling to the decay channel New-Gauge-Boson Processes W'^+- &rarr; W^+- Z^0 is more model-dependent, like for New-Gauge-Boson Processes Z'^0 &rarr; W^+ W^- described above. By default it is therefore off, but can be switched on as follows. Furthermore, we have left some amount of freedom in the choice of decay angular correlations in this channel, but obviously alternative shapes could be imagined. New-Gauge-Boson Processes A massive New-Gauge-Boson Processes W'^+- is also likely to decay into Higgs bosons and potentially into other now unknown particles. Such possibilities clearly are quite model-dependent, and have not been included for now. New-Gauge-Boson Processes New-Gauge-Boson Processes R^0 The New-Gauge-Boson Processes R^0 boson (particle code 41) represents one possible scenario for a horizontal gauge boson, i.e. a gauge boson that couples between the generations, inducing processes like New-Gauge-Boson Processes s dbar &rarr; R^0 &rarr; mu^- e^+. Experimental limits on flavour-changing neutral currents forces such a boson to be fairly heavy. In spite of being neutral the antiparticle is distinct from the particle: one carries a net positive generation number and the other a negative one. This particular model has no new parameters beyond the New-Gauge-Boson Processes R^0 mass. Decays are assumed isotropic. For further details see New-Gauge-Boson Processes Ben85."},{"name":"NLO Merging","link":"NLOMerging.html","text":"NLO Merging NLO Merging NLO Merging Pythia offers two NLO merging approaches. Both of these methods have been presented in NLO Merging Lon13. The goal of NLO merging is to extend tree-level multi-jet merging methods to next-to-leading order accuracy in QCD, for every available jet multiplicity. If for example NLO calculations for Higgs + 0 jet, Higgs + 1 jet and Higgs + 2 jets were available, NLO merging allows to simultaneously describe 0-, 1- and 2-jet observables with NLO accuracy. Further jets can, depending on additional tree-level input, be described by additional tree-level matrix elements. In the example, it would be possible to achieve NLO accuracy for 0-, 1- and 2-jet observables, tree-level accuracy for 3-, 4- and 5-jet configurations, and use the parton shower approximation for events with more than five jets. NLO Merging The two NLO merging methods implemented in Pythia are called NL NLO Merging 3 (for Nils Lavesson + Leif L&ouml;nnblad) and UNLOPS (for unitarised NLO+PS merging). Both of these schemes require Les Houches Event File input that is generated by tree-level or NLO matrix element generators. Currently, Pythia requires NLO input generated within the POWHEG framework. The generation of sensible input will be discussed below. The two NLO merging methods are illustrated in the sample main programs NLO Merging main87.cc (introducing NL NLO Merging 3 ) and NLO Merging main88.cc (introducing UNLOPS). Before describing these programs, we would like to outline the differences between the two approaches. NLO Merging NL NLO Merging 3 is a generalisation of NLO Merging CKKW-L tree-level merging. The main idea of NL NLO Merging 3 is to start from CKKW-L-reweighted multi-jet merging, and replace the NLO Merging &alpha; NLO Merging s NLO Merging n+0 - and NLO Merging &alpha; NLO Merging s NLO Merging n+1 -terms by the NLO result of POWHEG. This 'replacement' means that we subtract the NLO Merging &alpha; NLO Merging s NLO Merging n+0 - and NLO Merging &alpha; NLO Merging s NLO Merging n+1 -terms from the CKKW-L-reweighted tree-level samples, and add another sample -- the POWHEG input. All 'higher orders' are unchanged w.r.t. CKKW-L. We have implemented the 'inclusive' scheme of NLO Merging Lon13 in Pythia. This means that the POWHEG input will contain contributions for hard, resolved real emission jets, which are already taken care of by higher-multiplicity samples in CKKW-L. Thus, explicit phase space subtractions are also included. The sample program NLO Merging main87.cc , together with the input file NLO Merging main87.cmnd , illustrates the procedure. NLO Merging UNLOPS is a generalisation of the NLO Merging UMEPS multi-jet merging scheme. Since UMEPS is already slightly more complicated than CKKW-L, this makes UNLOPS more complicated than NL NLO Merging 3. The basic idea however remains the same: Start from a tree-level merging scheme (in this case UMEPS), remove all undesirable NLO Merging &alpha; NLO Merging s NLO Merging n+0 - and NLO Merging &alpha; NLO Merging s NLO Merging n+1 -terms from this result, and add back the 'correct' description via POWHEG input samples. Again, since the 'inclusive' scheme of NLO Merging Lon13 was implemented in Pythia, it is necessary to handle explicit phase space subtractions. Similar to UMEPS, UNLOPS further ensures that the lowest-multiplicity cross section is given by the NLO result. This means that the UMEPS philosophy of 'subtract what you add' needs to be extended to multi-leg NLO inputs. NLO Merging UNLOPS is a theoretically more appealing definition of NLO merging than NL NLO Merging 3 , and should thus be considered the preferred choice. However, we believe it valuable to include both methods into Pythia, so that the variation of NLO merged results due to different NLO merging schemes can be studied in situ. Furthermore, NLO merging can be outlined more pedagogically when starting from NL NLO Merging 3. The two NLO merging methods share parts of code with CKKW-L and UMEPS, and correspondingly share many input settings with these schemes. In particular, NLO Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; The hard process ( NLO Merging Merging:Process ) needs to be defined exactly as in CKKW-L (see NLO Merging Defining the hard process in the NLO Merging CKKW-L documentation ). NLO Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; The merging scale value ( NLO Merging Merging:TMS ) has to be set. NLO Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; The maximal number of additional partons in tree-level events ( NLO Merging Merging:nJetMax ) has to be set. NLO Merging All settings listed under the sections ' NLO Merging Matrix element merging and HepMC output for RIVET ' and ' NLO Merging Further variables ' in  the NLO Merging CKKW-L documentation can be accessed in NLO merging as well. Furthermore, the NLO Merging Merging:nRecluster switch (see the NLO Merging UMEPS documentation ) is important.  Also, all NLO Merging MergingHooks routines that allow for user interference in CKKW-L merging are also usable for NLO merging -- with the exception of a user-defined merging scale. The NLO merging schemes currently implemented in Pythia do not allow for a merging scale definition that differs from the parton shower evolution variable. Since this merging scale definition is not completely obvious, the NLO merging schemes also share the NLO Merging Merging:enforceCutOnLHE switch with CKKW-L. In this way, it is possible to use LHE files that are regularised only with weak cuts as input, while the merging machinery imposes the stronger merging scale cut automatically. This means that no merging scale implementation is required from the user side, but also means that it is the user's responsibility to ensure that the cuts used for generating input LHE files are always looser than the cut given by the merging scale value NLO Merging Merging:TMS. This will lead to warnings of the form ' NLO Merging Les Houches Event fails merging scale cut. Cut by rejecting event '. These warning should rather be regarded as information. An example of inclusive matrix element generation cuts would be NLO Merging pT NLO Merging jet = 5 GeV , NLO Merging &Delta;R NLO Merging jetA jetB = 0.01 and NLO Merging Q NLO Merging jetA jetB = 5 GeV , if NLO merging with a desired merging scale value of NLO Merging Merging:TMS = 15 is attempted for Higgs + jets events at the LHC. NLO Merging In the following, we will first describe the generation of NLO input samples, and list input settings for NLO merging in Pythia. Then, we will examine the sample main programs NLO Merging main87.cc and NLO Merging main88.cc , which implement NL NLO Merging 3 and UNLOPS merging, respectively. NLO Merging NLO Merging NLO Merging NLO Merging Inputs for NLO merging The NLO merging schemes in Pythia currently require Les Houches Event File input. To perform a merging with up to NLO Merging M additional partons described by tree-level matrix elements, and with up to NLO Merging N &le; M-1 additional partons at NLO accuracy, the user needs to supply NLO Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; LHE files for NLO Merging 0... M additional partons, taken from a tree-level matrix element generator, and NLO Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; LHE files for NLO Merging 0... N additional partons, taken from a POWHEG NLO generator. NLO Merging All input files need to be regularised, if they contain additional partons. Large files with fairly inclusive (i.e. loose) cuts are recommended. The input LHE files should further be generated with fixed renormalisation and factorisation scales. (In the POWHEG-BOX program, this means using the settings NLO Merging runningscales 0, btlscalereal 1, btlscalect 1, ckkwscalup 0. Some older processes in the POWHEG-BOX program need the input NLO Merging runningscale 0 instead of NLO Merging runningscales 0 .) NLO Merging When attempting NLO merging, the following Pythia settings are relevant. NLO Merging All further settings will be discussed while examining the sample main programs. NLO Merging NLO Merging NLO Merging NLO Merging NL NLO Merging 3 merging with main87.cc NL NLO Merging 3 -style NLO merging in Pythia is illustrated by the sample main program NLO Merging main87.cc. This program works together with an input file (e.g. NLO Merging main87.cmnd ) for Pythia settings, and requires LHE input files that follow the naming convention NLO Merging name_tree_#nAdditionalJets.lhe (tree-level samples) and NLO Merging name_powheg_#nAdditionalJets.lhe (POWHEG NLO samples). NLO Merging main87.cc produces HepMC event output NLO Merging Dob01 , which can be used for analysis (e.g. using RIVET NLO Merging Buc10 ), or as input for detector simulations. For users not familiar with HepMC output, it is of course possible remove the HepMC code in the sample program, and use Pythia's histogramming routines instead. Histograms should then be filled as indicated for the NLO Merging histPTFirstSum histograms in NLO Merging main84.cc , i.e. using NLO Merging weightNLO*normhepmc. NLO Merging If the user only wants to change the number of requested events ( NLO Merging Main:numberOfEvents ), the hard process ( NLO Merging Merging:Process ), the merging scale value ( NLO Merging Merging:TMS ) and the maximal number of additional tree-level or NLO-accuracte jets ( NLO Merging Merging:nJetMax and NLO Merging Merging:nJetMaxNLO , respectively), and HepMC output is desired, then there is no need to change the NLO Merging main87.cc code. The input LHE files are also part of the (command line) input for NLO Merging main87.exe. The default settings in NLO Merging main87.cmnd are intended to work with the (very short) sample LHEF inputs ( NLO Merging w_production_tree_0.lhe , NLO Merging w_production_tree_1.lhe , NLO Merging w_production_tree_2.lhe and NLO Merging w_production_powheg_0.lhe , NLO Merging w_production_powheg_1.lhe ). For these input files, the NLO Merging main87.exe executable can be run with the command NLO Merging NLO Merging ./main87.exe main87.cmnd w_production myhepmc.hepmc NLO Merging to produce a file myhepmc.hepmc of NLO merged HepMC event output. All mandatory Pythia input settngs have been outlined earlier. Please refrain from adding input switches than invoke any other merging scheme (e.g. e.g. NLO Merging Merging:doKTMerging ) into the input file that you want to use in conjunction with NLO Merging main87.cc. NLO Merging In the following, we will explain NLO Merging main87.cc in depth. Users who are willing to accept the default choices do not need to know all details, but are still encouraged to read further. NLO Merging Program flow NLO Merging main87.cc can be divided into four steps: NLO Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 1. Estimate the cross section for tree-level and NLO samples NLO Merging after the merging scale cut. NLO Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 2. Produce reweighted tree-level    events, which do not contain NLO Merging &alpha; NLO Merging s NLO Merging 0 -    and NLO Merging &alpha; NLO Merging s NLO Merging 1 -terms. NLO Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 3. Add POWHEG NLO events. NLO Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 4. Subtract phase space points with an    extra (real-emission) jet above the merging scale from the POWHEG result,    since such configurations have already been taken into account by    processing other samples. NLO Merging The first step is necessary to produce the correct weights for HepMC output events. The estimation of tree-level cross sections after the merging scale cut is generated by invoking the switch NLO Merging Merging:doXSectionEstimate together with NLO Merging Merging:doNL3Tree. In this configuration, the latter switch will only act to define the merging scale.  After the tree-level cross sections have been estimated, NLO Merging main87.cc estimates the NLO cross sections after application of the merging scale cut, by inferring NLO Merging Merging:doXSectionEstimate together with NLO Merging Merging:doNL3Loop. Again, in this configuration, the latter switch only acts as the merging scale definition. When generating the estimates, all showering, multiparton interactions and hadronisation is turned off to not unnecessarily waste processor time. For all estimates, is further NLO Merging mandatory to set the value of NLO Merging Merging:nRequested to the jet multiplicity of the current event sample (e.g. to '2' for a sample containing W + 2 jet events). This is necessary in order to correctly apply the merging scale cut. POWHEG NLO input files for W + 1 jet e.g. contain W + 1 jet and W + 2 jet (i.e. real emission) kinematics. However, the merging scale cut aims at regularising the 'underlying Born' configuration (i.e. the W + 1 states in our example). Setting NLO Merging Merging:nRequested = 1 for the  W + 1 jet POWHEG sample ensures that even for real-emission (W + 2 jet) kinematics, the merging scale cut is applied to W + 1 jet states. NLO Merging After the cross section estimation step, NLO Merging main87.cc proceeds to perform the actual merging. Before explaining this part, we would like to make some comments about K-factors. NLO Merging NLO Merging main87.cc is prepared to use fixed K-factors to rescale the weight of tree-level events. This rescaling does not affect the NLO accuracy of the method, and was investigated in NLO Merging Lon13. By default, NLO Merging main87.cc does not use K-factors. However, if the user wants to include K-factors, this can be done by using the following input settings. NLO Merging If the variables NLO Merging k0, k1, k2 in NLO Merging main87.cc are set to non-unity values, K-factors will be applied. The K-factor of highest jet multiplicity will then be used to also rescale tree-level samples with a number of additional jets beyond the number of the highest-multiplicity real-emission sample. If we, for example, attempt an NLO merging of NLO Merging W+0 jet and NLO Merging W+1 jet at NLO accuracy, and with NLO Merging W+&le;4 jets at tree-level accuracy, then NLO Merging Merging:kFactor2j is used to rescale the NLO Merging W+2 jet , NLO Merging W+3 jets and NLO Merging W+4 jets tree-level samples. We recommend to not include a K-factor rescaling of the tree-level samples. NLO Merging Let us turn to the production of NLO merged events. The first step in the procedure is to generate reweighted tree-level samples. This is implemented by using the following switch. NLO Merging The weight of tree-level events can be accessed by calling the function NLO Merging double Info::mergingWeightNLO(). When printing (or histogramming) NLO merged events, this weight, multiplied with the estimated cross section of the current event sample, should be used as event weight (or weight of histogram bins). For NLO Merging Merging:doNL3Tree = on , the weight NLO Merging double Info::mergingWeightNLO() contains the CKKW-L weight, subtracted, if necessary, by NLO Merging &alpha; NLO Merging s NLO Merging 0 - and NLO Merging &alpha; NLO Merging s NLO Merging 1 -terms. This weight can become negative. As an example, imagine we attempt an NLO merging of W + 0 jet and W + 1 jet at NLO accuracy, and with  W + 2 jets at tree-level accuracy. This weight will then be NLO Merging &nbsp; NLO Merging Info::mergingWeightNLO() = CKKW-L-weight for zero jets  - NLO Merging &alpha; NLO Merging s NLO Merging 0 -terms  - NLO Merging &alpha; NLO Merging s NLO Merging 1 -terms for events in the zero-jet sample, NLO Merging &nbsp; NLO Merging Info::mergingWeightNLO() = CKKW-L-weight for one jet  - NLO Merging &alpha; NLO Merging s NLO Merging 0 -terms  - NLO Merging &alpha; NLO Merging s NLO Merging 1 -terms for events in the one-jet sample, and NLO Merging &nbsp; NLO Merging Info::mergingWeightNLO() = CKKW-L-weight for two jets for events in the two-jet sample. NLO Merging After the tree-level events have been reweighted, NLO Merging main87.cc will move on to process the POWHEG NLO input. This is done by switching to the following flag. NLO Merging Also in this case, the NLO merging weight of the events can be accessed by calling the function NLO Merging double Info::mergingWeightNLO(). This weight should also be used when printing (or histogramming) events. For NLO Merging Merging:doNL3Loop = on , the weight NLO Merging double Info::mergingWeightNLO() is either one or zero (see Appendix E in NLO Merging Lon13 ).  After the processing of POWHEG NLO events, NLO Merging main87.cc continues by generating explicit phase space subtractions. This is facilitated by the following switch. NLO Merging These contributions are necessary because we have implemented the 'inclusive scheme' of NLO Merging Lon13 in Pythia. The benefit of this scheme is the user does not have to intrusively change the POWHEG-BOX program to implement very particular cuts. Let us explain this comment with an example (a more detailed explanation of the idea is given in Appendix A.2 of NLO Merging Lon13 ). When generating W + 0 jet events with the POWHEG-BOX program, the output LHE files will contain W  + 1 jet real emission events. Some of these events will contain a jet above the merging scale. However, in NLO merging methods, such configurations have already been included by a separate W + 1 jet sample. Thus, to avoid counting such events twice, we have to remove the configurations from the POWHEG-BOX output. We choose to remove such events by explicit subtraction. NLO Merging As always, the NLO merging weight of the events can be accessed by calling the function NLO Merging double Info::mergingWeightNLO(). This weight should also be used when printing (or histogramming) events. For NLO Merging Merging:doNL3Subt = on , the weight NLO Merging double Info::mergingWeightNLO() is either one or zero (see Appendix E in NLO Merging Lon13 ). NLO Merging After these steps, all necessary events for NL NLO Merging 3 merging have been produced. NLO Merging main87.cc finishes by returning the NL NLO Merging 3 -merged total cross section. NLO Merging NLO Merging NLO Merging NLO Merging UNLOPS merging with main88.cc UNLOPS-style NLO merging in Pythia is illustrated by the sample main program NLO Merging main88.cc , which relies on an input file (e.g. NLO Merging main88.cmnd ) for Pythia settings. As for all merging methods in Pythia, NLO Merging main88.cc requires LHE input files. To use NLO Merging main88.cc without any changes, these input files should follow the naming convention NLO Merging name_tree_#nAdditionalJets.lhe (for tree-level samples) and NLO Merging name_powheg_#nAdditionalJets.lhe (for POWHEG NLO samples). NLO Merging main88.cc produces HepMC event output, which can e.g. be analysed with RIVET, or used as input for detector simulations. For users not familiar with HepMC output, it is of course possible remove the HepMC code in the sample program, and use Pythia's histogramming routines instead. Histograms should then be filled as indicated for the NLO Merging histPTFirstSum histograms in NLO Merging main84.cc , i.e. using NLO Merging weightNLO*normhepmc. NLO Merging As for NL NLO Merging 3 , it is not necessary to change NLO Merging main88.cc if the user is only interested in changing standard settings. Thus, if the user only wants to change the number of requested events ( NLO Merging Main:numberOfEvents ), the hard process ( NLO Merging Merging:Process ), the merging scale value ( NLO Merging Merging:TMS ) and the maximal number of additional tree-level or NLO-accuracte jets ( NLO Merging Merging:nJetMax and NLO Merging Merging:nJetMaxNLO , respectively), and HepMC output is desired, then there is no need to change the NLO Merging main88.cc code. The input LHE files are also part of the (command line) input for NLO Merging main88.exe. The default settings in NLO Merging main88.cmnd are intended to work with the (very short) sample LHEF inputs ( NLO Merging w_production_tree_0.lhe , NLO Merging w_production_tree_1.lhe , NLO Merging w_production_tree_2.lhe and NLO Merging w_production_powheg_0.lhe , NLO Merging w_production_powheg_1.lhe ). For these input files, the NLO Merging main88.exe executable can be run with the command NLO Merging NLO Merging ./main88.exe main88.cmnd w_production myhepmc.hepmc NLO Merging to produce a file myhepmc.hepmc of UNLOPS merged HepMC event output. Please refrain from adding input switches than invoke any other merging scheme (e.g. NLO Merging Merging:doKTMerging ) into the input file that you want to use in conjunction with NLO Merging main88.cc. NLO Merging In the following, we will explain NLO Merging main88.cc in depth. To not be overly repetitive, we will at times refer to the relevant parts in the discussion of NLO Merging main87.cc. Users who are willing to accept the default choices do not need to know all details, but are still encouraged to read further. NLO Merging Program flow NLO Merging main88.cc can be divided into five steps: NLO Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 1. Estimate the cross section for tree-level and NLO samples NLO Merging after the merging scale cut. NLO Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 2. Produce reweighted tree-level    events, which do not contain NLO Merging &alpha; NLO Merging s NLO Merging 0 -    and NLO Merging &alpha; NLO Merging s NLO Merging 1 -terms. NLO Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 3. Add POWHEG NLO events. NLO Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 4. Subtract integrated, reweighted    tree-level events, to ensure that the inclusive NLO cross section remains    intact upon inclusion of multi-jet tree-level events. NLO Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 5. Subtract integrated POWHEG NLO    events, to ensure that the inclusive NLO cross section remains    intact upon inclusion of multi-jet tree-level events. NLO Merging The estimation of cross sections after the application of the merging scale cut is nearly identical to the first step in NLO Merging main87.cc , and we refer to the first paragraph of the 'Program flow' discussion for NLO Merging main87.cc for details. For NLO Merging main88.cc , the flags NLO Merging Merging:doUNLOPSTree or NLO Merging Merging:doUNLOPSLoop supply the merging scale definition used in the cross section estimation. NLO Merging After the cross section estimation step, NLO Merging main88.cc proceeds to perform the actual NLO merging. The discussion of K-factors given in the NL NLO Merging 3 section (i.e. of NLO Merging Merging:kFactor0j , NLO Merging Merging:kFactor1j and NLO Merging Merging:kFactor2j ) also applies to NLO Merging main88.cc. Although UNLOPS is considerably more stable than NL NLO Merging 3 upon changing the K-factors, we do not recommend the use of K-factors. NLO Merging The production of UNLOPS-merged events with NLO Merging main88.cc starts by generating reweighted tree-level events. The processing of tree-level events can be invoked by setting the following flag. NLO Merging The weight of tree-level events is returned by the function NLO Merging double Info::mergingWeightNLO(). When printing (or histogramming) NLO merged events, this weight, multiplied with the estimated cross section of the current event sample, should be used as event weight (or weight of histogram bins). For NLO Merging Merging:doUNLOPSTree = on , the weight NLO Merging double Info::mergingWeightNLO() contains the UMEPS weight, subtracted, if necessary, by NLO Merging &alpha; NLO Merging s NLO Merging 0 - and NLO Merging &alpha; NLO Merging s NLO Merging 1 -terms. This weight can become negative. As an example, assume that we attempt an UNLOPS merging of W + 0 jet and W + 1 jet at NLO accuracy, and with  W + 2 jets at tree-level accuracy. This weight will then be NLO Merging &nbsp; NLO Merging Info::mergingWeightNLO() = UMEPS-weight for one jet  - NLO Merging &alpha; NLO Merging s NLO Merging 0 -terms  - NLO Merging &alpha; NLO Merging s NLO Merging 1 -terms for events in the one-jet sample, and NLO Merging &nbsp; NLO Merging Info::mergingWeightNLO() = UMEPS-weight for two jets for events in the two-jet sample. NLO Merging After reweighted tree-level events have been generated, NLO Merging main88.cc processes the POWHEG NLO input files. This is facilitated by the following switch. NLO Merging The NLO merging weight of the events can be accessed by calling the function NLO Merging double Info::mergingWeightNLO(). This weight should also be used when printing (or histogramming) events. For NLO Merging Merging:doUNLOPSLoop = on , the weight NLO Merging double Info::mergingWeightNLO() is either one or zero (see Appendix E in NLO Merging Lon13 ). NLO Merging After processing the POWHEG NLO events, NLO Merging main88.cc continues by generating the reweighted subtraction terms of UMEPS. This part is implemented by setting the following flag. NLO Merging By using this switch, NLO Merging main88.cc ensures that the inclusive cross section is preserved. At variance with UMEPS however, the event weight contains the UMEPS weight, subtracted, if necessary, by NLO Merging &alpha; NLO Merging s NLO Merging +0 - and NLO Merging &alpha; NLO Merging s NLO Merging 1 -terms. Otherwise, NLO Merging &alpha; NLO Merging s NLO Merging n+0 - and NLO Merging &alpha; NLO Merging s NLO Merging n+1 -terms of the UMEPS procedure would be introduced, although our goal is to describe all NLO Merging &alpha; NLO Merging s NLO Merging n+0 - and NLO Merging &alpha; NLO Merging s NLO Merging n+1 -terms by n-jet POWHEG input. The weight of these integrated, subtractive tree-level events is, as always, returned by the function NLO Merging double Info::mergingWeightNLO(). When printing (or histogramming) NLO merged events, this weight, multiplied with the estimated cross section of the current event sample, and with NLO Merging -1 , should be used as event weight (or weight of histogram bins). As for the case of tree-level events in UNLOPS, this weight can become negative. For the example given before, i.e. attempting an UNLOPS merging of W + 0 jet and  W + 1 jet at NLO accuracy, and with W + 2 jets at tree-level accuracy, this weight will be NLO Merging &nbsp; NLO Merging Info::mergingWeightNLO() = UMEPS-weight for the integrated  one-jet sample - NLO Merging &alpha; NLO Merging s NLO Merging 0 -terms  - NLO Merging &alpha; NLO Merging s NLO Merging 1 -terms for events in the integrated one-jet sample, and NLO Merging &nbsp; NLO Merging Info::mergingWeightNLO() = UMEPS-weight for the integrated  two-jet sample for events in the integrated two-jet sample. NLO Merging This choice of weights already incorporates the fact that we have implemented the 'inclusive scheme' of NLO Merging Lon13 , meaning that the 'explicit phase space subtractions' of NL NLO Merging 3 are (partially) included though these weights. NLO Merging To ensure that the NLO inclusive cross section is unchanged, UNLOPS further requires the introduction of another sample. If POWHEG NLO events with one or more jets are included, it is necessary to subtract these samples in an integrated form. In NLO Merging main88.cc , this is done by setting the following flag. NLO Merging This sample also provides some 'explicit phase space subtractions' of NL NLO Merging 3 , which are necessary because we implemented the 'inclusive scheme' of NLO Merging Lon13. Let us again look at the example of UNLOPS merging of W + 0 jet and W + 1 jet at NLO accuracy. The integrated  W + 1 jet NLO events, which are produced by the setting NLO Merging Merging:doUNLOPSSubtNLO = on , contain a tree-level part. This part will exactly cancel the real-emission events with one jet above the merging scale in the  W + 0 jet NLO events. NLO Merging The NLO merging weight of these 'integrated' events can be accessed by calling the function NLO Merging double Info::mergingWeightNLO(). This weight should also be used when printing (or histogramming) events. For NLO Merging Merging:doUNLOPSSubtNLO = on , the weight NLO Merging double Info::mergingWeightNLO() is either one or zero (see Appendix E in NLO Merging Lon13 ). NLO Merging After these five steps (estimation of cross sections, tree-level processing, POWHEG processing, integrated tree-level processing, integrated POWHEG processing) we have produced a UNLOPS-merged HepMC event file. NLO Merging main88.cc finishes by returning the UNLOPS-merged total cross section. NLO Merging NLO Merging NLO Merging NLO Merging NLO merging and 'exclusive' NLO inputs Currently, both sample main programs for NLO merging ( NLO Merging main87.cc and NLO Merging main88.cc ) are intended for 'inclusive' POWHEG input. Inclusive input means that all real emission phase space points are included in the POWHEG output files. In order to avoid double counting with higher-multiplicity matrix elements, it is then necessary remove phase space points with too many jets from the real-emission configurations. This can be done by introducing explicit phase space subtractions. Another way of removing the undesired configurations is by implementing a cut in the NLO generator. This is not a completely trivial task, since it is necessary to ensure numerical stability and the correct cancellation of (finite) dipole regularisation terms. One way of producing such exclusive NLO output is by setting the (tree-level) real-emission matrix element in the NLO generator to zero if the real-emission phase space point contains too many jets above the merging scale. This will however not be numerically stable for too low merging scale values. NLO Merging NLO Merging We should be very clear that using exclusive NLO input is not recommended, since it requires hacking the NLO generator.  Only for the expert user, we briefly summarise the necessary changes for using exclusive NLO input. NLO Merging For the moment, assume that the NLO input has been produced in an 'exclusive' way. This input can then be processed by some trivial changes in NLO Merging main87.cc : estimate the cross section for tree-level and NLO samples NLO Merging after the merging scale cut, still using inclusive NLO samples, remove the last part of NLO Merging main87.cc , i.e. the part that produces explicit phase space subtractions, and use the exclusive NLO files as input files for the processing of 'POWHEG NLO files'. NLO Merging The changes to NLO Merging main88.cc (implementing UNLOPS) are slightly more complicated. This is the case because the weights of integrated tree-level samples change when using exclusive input, as can be seen in Appendix D in NLO Merging Lon13. The correct weights can be produced by Pythia by using the following flag. NLO Merging Then, it is necessary to add code for processing another sample to NLO Merging main88.cc , since when using exclusive inputs, it is also necessary to enforce two integrations on tree-level events (the '&uarr;'-contributions in Appendix D of NLO Merging Lon13 ). This can be achieved by adding the following code at the end of NLO Merging main88.cc. NLO Merging NLO Merging cout << endl << endl << endl;  cout << 'Shower subtractive events' << endl;   // Switch on processing of counter-events.  pythia.settings.flag('Merging:doUNLOPSTree',false);  pythia.settings.flag('Merging:doUNLOPSLoop',false);  pythia.settings.flag('Merging:doUNLOPSSubt',true);  pythia.settings.flag('Merging:doUNLOPSSubtNLO',false);  pythia.settings.mode('Merging:nRecluster',2);   nMaxCT      = nMaxNLO+1;  njetcounterCT  = nMaxCT;  iPathSubt    = iPath + '_tree';   while(njetcounterCT >= 2){    // From njet, choose LHE file    stringstream in;    in  << '_' << njetcounterCT << '.lhe';    string LHEfile = iPathSubt + in.str();    cout << endl << endl << endl       << 'Start subtractive treatment for ' << njetcounterCT       << ' jets\n'       << 'Recluster at least 2 times' << endl;    pythia.readString('Beams:frameType = 4');    pythia.settings.word('Beams:LHEF', LHEfile);    pythia.settings.mode('Merging:nRequested', njetcounterCT);    pythia.init();    // Remember position in vector of cross section estimates.    int iNow = sizeLO-1-njetcounterCT;    // Start generation loop    for( int iEvent=0; iEvent < nEvent; ++iEvent ){      // Generate next event     if( !pythia.next() ) {      if( pythia.info.atEndOfFile() ) break;      else continue;     }      // Get event weight(s).     double weightNLO  = pythia.info.mergingWeightNLO();     double evtweight  = pythia.info.weight();     weightNLO      *= evtweight;     // Do not print zero-weight events.     if ( weightNLO == 0. ) continue;      // Construct new empty HepMC event.     HepMC::GenEvent* hepmcevt = new HepMC::GenEvent();     // Get correct cross section from previous estimate.     double normhepmc = -1*xsecLO[iNow] / nAcceptLO[iNow];     // Set hepmc event weight.     hepmcevt->weights().push_back(weightNLO*normhepmc);     // Fill HepMC event.     ToHepMC.fill_next_event( pythia, hepmcevt );     // Add the weight of the current event to the cross section.     sigmaTotal += weightNLO*normhepmc;     errorTotal += pow2(weightNLO*normhepmc);     // Report cross section to hepmc.     HepMC::GenCrossSection xsec;     xsec.set_cross_section( sigmaTotal*1e9, pythia.info.sigmaErr()*1e9 );     hepmcevt->set_cross_section( xsec );     // Write the HepMC event to file. Done with it.     ascii_io << hepmcevt;     delete hepmcevt;    } // end loop over events to generate    // print cross section, errors    pythia.stat();    // Restart with ME of a reduced the number of jets    if( njetcounterCT > 2 )     njetcounterCT--;    else     break;   } NLO Merging NLO Merging NLO Merging Further variables More advanced manipulations of the merging machinery are of course possible, and additional switches can be found at the end of the NLO Merging CKKW-L tree-level merging documentation. Here, we only document switches that NLO Merging only apply to NLO merging."},{"name":"Onia Processes","link":"OniaProcesses.html","text":"Onia Processes Onia Processes Onia Processes Production of any Onia Processes 3S1 , Onia Processes 3PJ , and Onia Processes 3DJ charmonium and bottomonium states via the colour-singlet and colour-octet mechanisms. This includes by default, but is not limited to, production of the Onia Processes 3S1 Onia Processes J/psi and Onia Processes Upsilon and their radially excited states, as well as the Onia Processes 3PJ Onia Processes chi states and the Onia Processes 3D1 Onia Processes psi(3770). In each process the heavy quark content, either Onia Processes ccbar or Onia Processes bbbar , is followed by a round-bracketed expression which specifies the physical state in spectroscopic notation, Onia Processes (2S+1) L J. Proceding this is a square-bracketed expression, also in spectroscopic notation, which specifies the Fock state through which the process occurs, where Onia Processes (1) indicates a colour-singlet state and Onia Processes (8) a colour-octet state. Onia Processes The unphysical colour-octet states follow the Onia Processes id scheme of Onia Processes 99 n_q n_s n_r n_L n_J where Onia Processes n_q is the quark flavour of the state and Onia Processes n_s is the colour-octet state type. Here Onia Processes 0 is Onia Processes 3S1 , Onia Processes 1 is Onia Processes 1S0 , and Onia Processes 2 is Onia Processes 3PJ. All remaining numbers follow the standard PDG numbering scheme. If a physical state is requested without a corresponding colour-octet state, a colour-octet state is automatically added to the Onia Processes ParticleData when a colour-octet process is selected. The colour-octet state is created with a mass given by the mass of the physical state plus the singlet-octet mass splitting parameter Onia Processes Onia:massSplit , which is by default set at 200 MeV, and decays exclusively to a gluon and the physical state. If the user wishes to manually set the mass splitting for each colour-octet state individually then Onia Processes Onia:forceMassSplit can be set to Onia Processes off. By default the widths of the octet states are set to vanish. This is not realistic, given their presumably rather rapid decay, but a nonvanishing width is not likely to have any measurable consequences that go beyond what comes from viewing the singlet-octet mass splitting as an effective parameter. Onia Processes The original Fortran code for these processes has been contributed by Stefan Wolf [unpublished]. For the C++ version only the unpolarized expressions are retained, since the theoretical predictions of the colour-octet model anyway do not agree with the experimental observations. Furthermore, the polarization effects are modest, so isotropic decay is not a bad starting point. Such an event sample can afterwards be reweighted at will by the user, to test various assumptions. The expressions for the colour-singlet production of the Onia Processes 3S1 and Onia Processes 3PJ states can be found in Onia Processes Bai83 and Onia Processes Gas87. Colour-octet expressions can be found in Onia Processes Cho96 for the Onia Processes 1S0 , Onia Processes 3S1 , and Onia Processes 3PJ states, and the matrix elements for the Onia Processes 3DJ states are taken from Onia Processes Yua98. Onia Processes The implementation of charmonium and bottomonium production, including the colour-octet production mechanism, requires information on long-distance NRQCD matrix elements for the various wavefunctions involved. Default values for these are encoded in the Onia Processes O parameters and are taken from Onia Processes Nas00 ; see also Onia Processes Bar07. The Onia Processes 3DJ long-distance matrix elements are extracted from Onia Processes Yua98. Onia Processes Note that states that differ only by the radial excitation number Onia Processes n_r share the same short-distance matrix elements. The program has therefore been written such that further radial excitations can be easily added by editing this file, without requiring a recompilation of the code. All related arrays must be expanded in exactly the same way, however, i.e. the code of the colour singlet state, the long-distance matrix elements and the individual process on/off switches. Onia Processes Double production of charmonium and bottomonium Onia Processes 3S1 states is also available, but with only the colour-singlet processes included. The short-distance matrix elements for these processes can be found in Onia Processes Hum83 and Onia Processes Qia02. Arrays seperate to those used for single charmonium and bottomonium production set the long-distance NRQCD matrix elements. For consistency these values should be the same as those provided for single charmonium and bottomonium production, but are seperated to allow further control by the user if needed. Onia Processes The description of Onia Processes final-state radiation is in this case based on some further model assumptions. Onia Processes Most of the processes below are divergent in the limit Onia Processes pT &rarr; 0 , and therefore a Onia Processes pTmin scale should be set. Comparisons with data indicate that this divergence can be tamed the same way as for the normal QCD Onia Processes 2 &rarr; 2 cross sections Onia Processes Bar07,Kra08 , which makes sense, since they are all dominated by the same kind of Onia Processes t -channel gluon exchange. It is therefore possible to use the Onia Processes SuppressSmallPT user hook to impose a reweighting that cancels the low- Onia Processes pT divergence. Onia Processes An eikonalized description of these processes, excluding double onia production, is included in the multiparton-interactions framework. Here the low- Onia Processes pT damping is automatic, and additionally the framework is more consistent (e.g. with respect to energy-momentum constraints and the impact-parameter description) for events where the onium production is not the hardest subprocess, as would often be the case in the low- Onia Processes pT limit. Onia Processes Charmonium 3S1 States Onia Processes Warning : changed Onia Processes fvec , Onia Processes mvec or Onia Processes pvec values must be provided as a comma-separated list with the right number of elements, without any blanks inside the list. Onia Processes Charmonium 3PJ States Onia Processes Warning : changed Onia Processes fvec , Onia Processes mvec or Onia Processes pvec values must be provided as a comma-separated list with the right number of elements, without any blanks inside the list. Onia Processes Charmonium 3DJ States Onia Processes Warning : changed Onia Processes fvec , Onia Processes mvec or Onia Processes pvec values must be provided as a comma-separated list with the right number of elements, without any blanks inside the list. Onia Processes Double Charmonium 3S1 States Onia Processes Warning : changed Onia Processes fvec , Onia Processes mvec or Onia Processes pvec values must be provided as a comma-separated list with the right number of elements, without any blanks inside the list. Onia Processes Bottomonium 3S1 States Onia Processes Warning : changed Onia Processes fvec , Onia Processes mvec or Onia Processes pvec values must be provided as a comma-separated list with the right number of elements, without any blanks inside the list. Onia Processes Bottomonium 3PJ States Onia Processes Warning : changed Onia Processes fvec , Onia Processes mvec or Onia Processes pvec values must be provided as a comma-separated list with the right number of elements, without any blanks inside the list. Onia Processes Bottomonium 3DJ States Onia Processes Warning : changed Onia Processes fvec , Onia Processes mvec or Onia Processes pvec values must be provided as a comma-separated list with the right number of elements, without any blanks inside the list. Onia Processes Double Bottomonium 3S1 States Onia Processes Warning : changed Onia Processes fvec , Onia Processes mvec or Onia Processes pvec values must be provided as a comma-separated list with the right number of elements, without any blanks inside the list."},{"name":"Particle Data","link":"ParticleData.html","text":"Particle Data Particle Data Particle Data The structure and operation of the particle data table is described Particle Data here. That page also describes how default data properties can be changed. The current page provides the actual default values. Particle Data Main settings Apart from the data itself, the particle data table only contains a few aspects that are available to change: Particle Data Since running masses are only calculated for the six quark flavours, e.g. to obtain couplings to the Higgs boson(s), there is not an entry in the normal tables for each particles, but only the six MSbar mass values below, used as starting point for the running. In addition you can pick an Particle Data alpha_s(M_Z) , which is converted into a first-order five-flavour Lambda that is used to determine the rate of the running. (Without any match to four flavours below Particle Data m_b ; if desired, this can be fixed by slightly shifted default mass values, since the routines never should be called below the Particle Data m_b scale anyway.) Particle Data Comments on the data Much of the current data has been updated based on the 2012 Review of Particle Physics Particle Data Ber12 , while some is still based on the 2006 RPP Particle Data Yao06. All known particle masses, widths and lifetimes have been set accordingly, while most not-yet-measured particles are kept at their values from PYTHIA 6. Decay channels and their branching ratios remain a major worry: many particles do not have one single solidly measured branching ratio, and many further do not have known branching ratios that add up to (the neighbourhood of) unity. Particle Data Uncertainties are especially big for the scalar, pseudovector and tensor Particle Data L = 1 multiplets available in PYTHIA. We note that some distributions become better described when these multiplets are included in the generation, while others become worse. It is tempting to associate this lackluster performance with the primitive knowledge. Not even the multiplets themselves are particularly well known. It used to be that the Particle Data a_0(980) and Particle Data f_0(980) were considered to be members of the scalar multiplet. Nowadays they are commonly assumed to be either four-quark states or of some other exotic character. This means that the PYTHIA 8 PDG particle codes have been changed for these particles, relative to what was used in PYTHIA 6 based on previous PDG editions. Specifically their numbers are now in the 9000000 series, and they have been replaced in the scalar multiplet by Particle Data a_0(1450) and Particle Data f_0(1370). Particle Data For charm and bottom mesons the jungle of partial measurements makes it very difficult to construct fully consistent sets of decay channels. This part of the program has not yet been brought up to date to the 2006 RPP. Instead the LHCb decay tables (for EvtGen, but without using the EvtGen matrix-element machinery) and the DELPHI tune for PYTHIA 6 is being used. (This also includes a few non-c/b hadrons that only occur in the c/b decay tables.) This has the advantage that many tests have been made for consistency, but the disadvantage that it is not always in agreement with the latest measurements of some specific decay channels. The decays based on the LHCb tables (with some modifications) are 411, 421, 431, 441, 445, 511, 521, 531, 541, 3124, 4122, 4124, 5122, 10441, 10443, 13122, 14122, 20443, 23122, 30313, 30323, 30443, 33122, 100113, 100213, 100441, 100443, 100553, 9000111, 9000211. Correspondingly the decays based on the DELPHI tables are 415, 425, 435, 515, 525, 535, 4132, 4232, 4332, 5132, 5232 and 5332. Particle Data The data itself Here comes the default particle data used in the program. Do not touch. The meaning of the various properties and the format used are explained Particle Data here and the Particle Data meMode codes Particle Data here."},{"name":"Particle Data Scheme","link":"ParticleDataScheme.html","text":"Particle Data Scheme Particle Data Scheme Particle Data Scheme The particle data scheme may take somewhat longer to understand than the settings one. In particular the set of methods to access information is rather more varied, to allow better functionality for advanced usage. However, PYTHIA does come with a sensible default set of particle properties and decay tables. Thus there is no need to learn any of the methods on this page to get going. Only when you perceive a specific need does it make sense to learn the basics. Particle Data Scheme The central section on this page is the Operation one. The preceding sections are there mainly to introduce the basic structure and the set of properties that can be accessed. The subsequent sections provide a complete listing of the existing public methods, which most users probably will have little interaction with. Particle Data Scheme Databases The management of particle data is based on three classes: Particle Data Scheme Particle Data Scheme Particle Data Scheme ParticleData , which is the top-level class, with methods that can be used to interrogate all particle data. It contains a map of PDG particle identity numbers Particle Data Scheme Yao06 onto the relevant Particle Data Scheme ParticleDataEntry objects, Particle Data Scheme Particle Data Scheme ParticleDataEntry , which stores the relevant information on an individual particle species, and Particle Data Scheme Particle Data Scheme DecayChannel , which stores info on one particular decay mode of a particle. The objects of these classes together form a database that is continuously being used as the program has to assign particle masses, select decay modes, etc. Particle Data Scheme Each Particle Data Scheme Pythia object has a public member Particle Data Scheme particleData of the Particle Data Scheme ParticleData class. Therefore you access the particle data methods as Particle Data Scheme pythia.particleData.command(argument) , assuming that Particle Data Scheme pythia is an instance of the Particle Data Scheme Pythia class. Further, for some of the most frequent user tasks, Particle Data Scheme Pythia methods have been defined, so that Particle Data Scheme pythia.command(argument) would work, see further below. Particle Data Scheme A fundamental difference between the particle data classes and the settings ones is that the former are accessed regularly during the event generation process, as a new particle is produced and its mass need to be set, e.g., while the latter are mainly/only used at the initialization stage. Nevertheless, it is not a good idea to change data in either of them in mid-run, since this may lead to inconsistencies. Particle Data Scheme Stored properties for particles The main properties stored for each particle are as follows. Different ways to set and get these properties will be described further down. Particle Data Scheme Particle Data Scheme Particle Data Scheme name : a character string with the name of the particle. Particle and antiparticle names are stored separately, with Particle Data Scheme void returned when no antiparticle exists. Particle Data Scheme Particle Data Scheme spinType : the spin type, of the form Particle Data Scheme 2 s + 1 , with special code 0 for entries of unknown or indeterminate spin. Particle Data Scheme Particle Data Scheme chargeType : three times the charge (to make it an integer). Particle Data Scheme Particle Data Scheme colType : the colour type, with 0 uncoloured, 1 triplet, -1 antitriplet and 2 octet. (A preliminary implementation of colour  sextets, available since version 8.150, further uses 3 for a sextet  and -3 for an antisextet.) Particle Data Scheme Particle Data Scheme m0 : the nominal mass Particle Data Scheme m_0 (in GeV). Particle Data Scheme Particle Data Scheme mWidth : the width Particle Data Scheme Gamma of the Breit-Wigner distribution (in GeV). Particle Data Scheme Particle Data Scheme mMin : the lower limit of the allowed mass range generated by the Breit-Wigner (in GeV). Has no meaning for particles without width, and would typically be 0 there. Particle Data Scheme Particle Data Scheme mMax : the upper limit of the allowed mass range generated by the Breit-Wigner (in GeV). If Particle Data Scheme mMax < mMin then no upper limit is imposed. Has no meaning for particles without width, and would typically be 0 there. Particle Data Scheme Particle Data Scheme tau0 : the nominal proper lifetime Particle Data Scheme tau_0 (in mm/c). Particle Data Scheme Particle Data Scheme isResonance : a flag telling whether a particle species is considered as a resonance or not. Here Particle Data Scheme 'resonance' is used as shorthand for any massive particle where the decay process should be counted as part of the hard process itself, and thus be performed before showers and other event aspects are added. Restrictions on allowed decay channels is also directly reflected in the cross section of simulated processes, while those of normal hadrons and other light particles are not. In practice, it is reserved for states above the Particle Data Scheme b bbar bound systems in mass, i.e. for Particle Data Scheme W, Z, t , Higgs states, supersymmetric states and (most?) other states in any new theory. All particles with Particle Data Scheme m0 above 20 GeV are by default initialized to be considered as resonances. Particle Data Scheme Particle Data Scheme mayDecay : a flag telling whether a particle species may decay or not, offering the main user switch. Whether a given particle of this kind then actually will decay also depends on it having allowed decay channels, and on other flags for Particle Data Scheme particle decays (or Particle Data Scheme resonance decays ). All particles with Particle Data Scheme tau0 below 1000 mm are by default initialized to allow decays. Particle Data Scheme Particle Data Scheme doExternalDecays : a flag telling whether a particle should be handled by an external decay package or not, with the latter default. Can be manipulated as described on this page, but should normally not be. Instead the Particle Data Scheme Particle Data Scheme Pythia::decayPtr(...) method should be provided with the list of relevant particles. Particle Data Scheme Particle Data Scheme isVisible : a flag telling whether a particle species is to be considered as visible in a detector or not, as used e.g. in analysis routines. By default the invisibles include neutrinos, Dark Matter particles (codes 51 - 60) and a few BSM particles (gravitino, sneutrinos, neutralinos) that have neither strong nor electromagnetic charge, and are not made up of constituents that have it. The value of this flag is only relevant if a particle is long-lived enough actually to make it to a detector. Particle Data Scheme Particle Data Scheme doForceWidth : a flag applicable only for resonances (see Particle Data Scheme isResonance above), whereby it is possible to force resonances to retain their assigned width, whatever that is, see Particle Data Scheme Resonance Decays for details. Particle Data Scheme Stored properties for decays An unstable particle has a decay table consisting of one or more decay channel. The following properties are stored for each such channel. Again different ways to set and get these properties will be described further down. Particle Data Scheme Particle Data Scheme Particle Data Scheme onMode : integer code for use or not of channel, Particle Data Scheme 0 if a channel is off, Particle Data Scheme 1 if on, Particle Data Scheme 2 if on for a particle but off for an antiparticle, Particle Data Scheme 3 if on for an antiparticle but off for a particle. Particle Data Scheme If a particle is its own antiparticle then 2 is on and 3 off but, of course, for such particles it is much simpler and safer to use only 1 and 0. Particle Data Scheme The 2 and 3 options can be used e.g. to encode CP violation in B decays, or to let the Particle Data Scheme W 's in a Particle Data Scheme q qbar &rarr; W^+ W^- process decay in different channels. Particle Data Scheme Particle Data Scheme bRatio : the branching ratio of the channel (with some reservations for resonances, see Particle Data Scheme meMode below). Particle Data Scheme Particle Data Scheme meMode : the mode of processing this channel, possibly with matrix elements; see the Particle Data Scheme particle decays and Particle Data Scheme resonance decays descriptions for the list of possibilities. Notably the default code 0 for a particle means pure phase space decays according to the given branching ratios, while for a resonance it means that code exists for the dynamic calculations of partial widths and thereby branching ratios as a function of the resonance mass (which is done e.g. at initialization based on the mass set by the user). Then codes 1 - 99 are reserved for various matrix-element-improved ordinary particle decays, and 100 - 103 for resonances where the partial width of a given channel is calculated from the total width and the stored branching ratio. Thus, to enforce a new branching ratio for a resonance channel (with its own partial-width calculation code) it is not sufficient only to change the Particle Data Scheme bRatio but also to set e.g. Particle Data Scheme meMode = 100. Particle Data Scheme Particle Data Scheme multiplicity : the number of decay products of the channel. Can be at most 8. Particle Data Scheme Particle Data Scheme product(i) : the identity code of the decay products, where Particle Data Scheme i runs between Particle Data Scheme 0 and Particle Data Scheme multiplicity - 1. Trailing positions are filled with 0. Particle Data Scheme Operation The normal flow of the particle data operations is: Particle Data Scheme Particle Data Scheme When a Particle Data Scheme Pythia object Particle Data Scheme pythia is created, the Particle Data Scheme pythia.particleData member is asked to scan the Particle Data Scheme ParticleData.xml file. Particle Data Scheme All lines beginning with Particle Data Scheme <particle are scanned for information on a particle species, and all lines beginning with Particle Data Scheme <channel are assumed to contain a decay channel of the enclosing particle. In both cases XML syntax is used, with attributes used to identify the stored properties, and with omitted properties defaulting back to 0 where meaningful. The particle and channel information may be split over several lines, up to the > endtoken. The format of a Particle Data Scheme <particle tag is: Particle Data Scheme <particle id='...' name='...' antiName='...' spinType='...' chargeType='...' colType='...'      m0='...' mWidth='...' mMin='...' mMax='...' tau0='...'>    </particle> where the fields are the properties already introduced above. Note that Particle Data Scheme isResonance , Particle Data Scheme mayDecay , Particle Data Scheme doExternalDecay , Particle Data Scheme isVisible and Particle Data Scheme doForceWidth are not set here, but are provided with default values by the rules described above. Once initialized, also these latter properties can be changed, see below. Particle Data Scheme The format of  a Particle Data Scheme <channel> tag is: Particle Data Scheme <channel onMode='...' bRatio='...' meMode='...' products='...' /> again see properties above. The products are given as a blank-separated list of Particle Data Scheme id codes. Particle Data Scheme Important : the values in the Particle Data Scheme .xml file should not be changed, except by the PYTHIA authors. Any changes should be done with the help of the methods described below. Particle Data Scheme Particle Data Scheme Between the creation of the Particle Data Scheme Pythia object and the Particle Data Scheme init call for it, you may use the methods of the Particle Data Scheme ParticleData class to modify some of the default values. Several different approaches can be chosen for this. Particle Data Scheme a) Inside your main program you can directly set values with Particle Data Scheme pythia.readString(string); where both the variable name and the value are contained inside the character string, separated by blanks and/or a =, e.g. Particle Data Scheme pythia.readString('111:mayDecay = off'); switches off the decays of the Particle Data Scheme pi^0. Particle Data Scheme The particle id (> 0) and the property to be changed must be given, separated by a colon. Particle Data Scheme The allowed properties are: Particle Data Scheme name , Particle Data Scheme antiName , Particle Data Scheme spinType , Particle Data Scheme chargeType , Particle Data Scheme colType , Particle Data Scheme m0 , Particle Data Scheme mWidth , Particle Data Scheme mMin , Particle Data Scheme mMax , Particle Data Scheme tau0 , Particle Data Scheme isResonance , Particle Data Scheme mayDecay , Particle Data Scheme doExternalDecay , Particle Data Scheme isVisible and Particle Data Scheme doForceWidth. All of these names are case-insensitive. Names that do not match an existing variable are ignored. Particle Data Scheme Strings beginning with a non-alphanumeric character, like # or !, are assumed to be comments and are not processed at all. For Particle Data Scheme bool values, the following notation may be used interchangeably: Particle Data Scheme true = on = yes = ok = 1 , while everything else gives Particle Data Scheme false (including but not limited to Particle Data Scheme false , Particle Data Scheme off , Particle Data Scheme no and Particle Data Scheme 0 ). Particle Data Scheme Particle data often comes in sets of closely related information. Therefore some properties expect the value to consist of several numbers. These can then be separated by blanks (or by commas). A simple example is Particle Data Scheme names , which expects both the name and antiname to be given. A more interesting one is the Particle Data Scheme all property, Particle Data Scheme id:all = name antiName spinType chargeType colType m0 mWidth mMin mMax tau0 where all the current information on the particle itself is replaced, but any decay channels are kept unchanged. Using Particle Data Scheme new instead of Particle Data Scheme all also removes any previous decay channels. If the string contains fewer fields than expected the trailing properties are set to vanish ('void', 0 or 0.). Note that such a truncated string should not be followed by a comment, since this comment would then be read in as if it contained the missing properties. The truncation can be done anywhere, specifically a string with only Particle Data Scheme id:new defines a new 'empty' particle. As before, Particle Data Scheme isResonance , Particle Data Scheme mayDecay , Particle Data Scheme doExternalDecay , Particle Data Scheme isVisible and Particle Data Scheme doForceWidth are (re)set to their default values, and would have to be changed separately if required. Particle Data Scheme A further command is Particle Data Scheme rescaleBR , which rescales each of the existing branching ratios with a common factor, such that their new sum is the provided value. This may be a first step towards adding new decay channels, see further below. Particle Data Scheme Alternatively the Particle Data Scheme id code may be followed by another integer, which then gives the decay channel number. This then has to be followed by the property specific to this channel, either Particle Data Scheme onMode , Particle Data Scheme bRatio , Particle Data Scheme meMode or Particle Data Scheme products. In the latter case all the products of the channel should be given: Particle Data Scheme id:channel:products =  product1 product2 .... The line will be scanned until the end of the line, or until a non-number word is encountered, or until the maximum allowed number of eight products is encountered, whichever happens first. (Thus the multiplicity of a decay channel need not be input; it is automatically calculated from the products list.) It is also possible to replace all the properties of a channel in a similar way: Particle Data Scheme id:channel:all = onMode bRatio meMode product1 product2 .... To add a new channel at the end, use Particle Data Scheme id:addChannel = onMode bRatio meMode product1 product2 .... Particle Data Scheme It is currently not possible to remove a channel selectively, but setting its branching ratio vanishing is as effective. If you want to remove all existing channels and force decays into one new channel you can use Particle Data Scheme id:oneChannel = onMode bRatio meMode product1 product2 .... A first Particle Data Scheme oneChannel command could be followed by several subsequent Particle Data Scheme addChannel ones, to build up a completely new decay table for an existing particle. Particle Data Scheme When adding new channels or changing branching ratios in general, note that, once a particle is to be decayed, the sum of branching ratios is always rescaled to unity. Beforehand, Particle Data Scheme rescaleBR may be used to rescale an existing branching ratio by the given factor. Particle Data Scheme There are a few commands that will study all the decay channels of the given particle, to switch them on or off as desired. The Particle Data Scheme id:onMode = onMode will set the Particle Data Scheme onMode property of all channels to the desired value. The Particle Data Scheme id:offIfAny  = product1 product2 ....    id:onIfAny   = product1 product2 ....    id:onPosIfAny = product1 product2 ....    id:onNegIfAny = product1 product2 .... will set the Particle Data Scheme onMode 0, 1, 2 or 3, respectively, for all channels which contain any of the enumerated products, where the matching to these products is done without distinction of particles and antiparticles. Note that ' Particle Data Scheme Pos ' and ' Particle Data Scheme Neg ' are slightly misleading since it refers to the particle and antiparticle of the Particle Data Scheme id species rather than charge, but should still be simpler to remember and understand than alternative notations. Correspondingly Particle Data Scheme id:offIfAll  = product1 product2 ....    id:onIfAll   = product1 product2 ....    id:onPosIfAll = product1 product2 ....    id:onNegIfAll = product1 product2 .... will set the Particle Data Scheme onMode 0, 1, 2 or 3, respectively, for all channels which contain all of the enumerated products, again without distinction of particles and antiparticles. If the same product appears twice in the list it must also appear twice in the decay channel, and so on. The decay channel is allowed to contain further particles, beyond the product list. By contrast, Particle Data Scheme id:offIfMatch  = product1 product2 ....    id:onIfMatch   = product1 product2 ....    id:onPosIfMatch = product1 product2 ....    id:onNegIfMatch = product1 product2 .... requires the decay-channel multiplicity to agree with that of the product list, but otherwise works as the Particle Data Scheme onIfAll/offIfAll methods. Particle Data Scheme Note that the action of several of the commands depends on the order in which they are executed, as one would logically expect. For instance, Particle Data Scheme id:oneChannel removes all decay channels of Particle Data Scheme id and thus all previous changes in this decay table, while subsequent additions or changes would still take effect. Another example would be that Particle Data Scheme 23:onMode = off followed by Particle Data Scheme 23:onIfAny = 1 2 3 4 5 would let the Particle Data Scheme Z^0 decay to quarks, while no decays would be allowed if the order were to be reversed. Particle Data Scheme b) The Particle Data Scheme Pythia Particle Data Scheme readString(string) method actually does not do changes itself, but sends on the string either to the Particle Data Scheme ParticleData class or to the Particle Data Scheme Settings one, depending on whether the string begins with a digit or a letter. If desired, it is possible to communicate directly with the corresponding Particle Data Scheme ParticleData method: Particle Data Scheme pythia.particleData.readString('111:mayDecay = off');    pythia.particleData.readString('15:2:products = 16 -211'); In this case, changes intended for Particle Data Scheme Settings would not be understood. Particle Data Scheme c) Underlying this are commands for all the individual properties in the Particle Data Scheme ParticleData class, one for each. These are further described below. Thus, an example now reads Particle Data Scheme pythia.particleData.mayDecay(111, false); Boolean values should here be given as Particle Data Scheme true or Particle Data Scheme false. Particle Data Scheme d) A simpler and more useful way is to collect all your changes in a separate file, with one line per change, e.g. Particle Data Scheme 111:mayDecay = off The file can be read by the Particle Data Scheme pythia.readFile(fileName); method, where Particle Data Scheme fileName is a string, e.g. Particle Data Scheme pythia.readFile('main.cmnd') (or an Particle Data Scheme istream instead of a Particle Data Scheme fileName ). Each line is processed as described for the string in 2a). This file can freely mix commands to the Particle Data Scheme Settings and Particle Data Scheme ParticleData classes. Particle Data Scheme Particle Data Scheme A routine Particle Data Scheme reInit(fileName) is provided, and can be used to zero the particle data table and reinitialize it from scratch. Such a call might be useful if several subruns are to be made with widely different particle data - normally the maps are only built from scratch once, namely when the Particle Data Scheme Pythia() object is created. Also, there is no other possibility to restore the default values, unlike for the settings. Particle Data Scheme Particle Data Scheme You may at any time obtain a listing of all the particle data by calling Particle Data Scheme pythia.particleData.listAll(); The listing is by increasing Particle Data Scheme id number. It shows the basic quantities introduced above. Some are abbreviated in the header to fit on the lines: Particle Data Scheme spn = spinType , Particle Data Scheme chg = chargeType , Particle Data Scheme col = colType , Particle Data Scheme res = isResonance , Particle Data Scheme dec = mayDecay && canDecay (the latter checks that decay channels have been defined), Particle Data Scheme ext = doExternalDecay , Particle Data Scheme vis = isVisible and Particle Data Scheme wid = doForceWidth. Particle Data Scheme To list only those particles that were changed (one way or another, the listing will not tell what property or decay channel was changed), instead use Particle Data Scheme pythia.particleData.listChanged(); (This info is based on a further Particle Data Scheme hasChanged flag of a particle or a channel, set Particle Data Scheme true whenever any of the changing methods are used. It is possible to manipulate this value, but this is not recommended.) By default the internal initialization of the widths of resonances such as Particle Data Scheme gamma^*/Z^0, W^+-, t/tbar, H^0 do not count as changes; if you want to list also those changes instead call Particle Data Scheme listChanged(true). Particle Data Scheme To list only one particle, give its Particle Data Scheme id code as argument to the Particle Data Scheme list(...) function.. To list a restricted set of particles, give in their Particle Data Scheme id codes to Particle Data Scheme list(...) as a Particle Data Scheme vector<int>. Particle Data Scheme Particle Data Scheme For wholesale changes of particle properties all available data can be written out, edited, and then read back in again. These methods are mainly intended for expert users. You can choose between two alternative syntaxes. Particle Data Scheme a) XML syntax, using the Particle Data Scheme <particle and Particle Data Scheme <channel lines already described. You use the method Particle Data Scheme particleData.listXML(fileName) to produce such an XML file and Particle Data Scheme particleData.readXML(fileName) to read it back in after editing. Particle Data Scheme b) Fixed/free format, using exactly the same information as illustrated for the Particle Data Scheme <particle and Particle Data Scheme <channel lines above, but now without any tags. This means that all information fields must be provided (if there is no antiparticle then write Particle Data Scheme void ), in the correct order (while the order is irrelevant with XML syntax), and all on one line. Information is written out in properly lined-up columns, but the reading is done using free format, so fields need only be separated by at least one blank. Each new particle is supposed to be separated by (at least) one blank line, whereas no blank lines are allowed between the particle line and the subsequent decay channel lines, if any.  You use the method Particle Data Scheme particleData.listFF(fileName) to produce such a fixed/free file and Particle Data Scheme particleData.readFF(fileName) to read it back in after editing. Particle Data Scheme As an alternative to the Particle Data Scheme readXML and Particle Data Scheme readFF methods you can also use the Particle Data Scheme particleData.reInit(fileName, xmlFormat) method, where Particle Data Scheme xmlFormat = true (default) corresponds to reading an XML file and Particle Data Scheme xmlFormat = false to a fixed/free format one. Particle Data Scheme To check that the new particle and decay tables makes sense, you can use the Particle Data Scheme particleData.checkTable() method, either directly or by switching it on among the standard Particle Data Scheme error checks. Particle Data Scheme Particle Data Scheme Particle Data Scheme The public methods In the following we present briefly the public methods in the three classes used to build up the particle database. The order is top-down, i.e from the full table of all particles to a single particle to a single channel. Note that these methods usually are less elegant and safe than the input methods outlined above. If you use any of these methods, it is likely to be the ones in the full database, i.e. the first ones to be covered in the following. Particle Data Scheme For convenience, we have grouped related input and output methods together. It should be obvious from the context which is which: the input is of type Particle Data Scheme void and has an extra last argument, namely is the input value, while the output method returns a quantity of the expected type. Particle Data Scheme The ParticleData methods Particle Data Scheme The ParticleDataEntry methods Most of the methods that can be applied to a single Particle Data Scheme ParticleDataEntry object are almost identical with those used above for the Particle Data Scheme ParticleData , except that the Particle Data Scheme id argument is no longer needed to find the right entry in the table. By and large, this makes direct access to the Particle Data Scheme ParticleDataEntry methods superfluous. There are a few methods that are unique to each class, however. Furthermore, to avoid some naming ambiguities, many methods that set values begin with Particle Data Scheme set. Particle Data Scheme The DecayChannel methods The properties stored in an individual decay channel can be set or get by the methods in this section."},{"name":"Particle Decays","link":"ParticleDecays.html","text":"Particle Decays Particle Decays Particle Decays The Particle Decays ParticleDecays class performs the sequential decays of all unstable hadrons produced in the string fragmentation stage, i.e. up to and including Particle Decays b hadrons and their decay products, such as the Particle Decays tau lepton. It is not to be used for the decay of more massive Particle Decays resonances , such as top, Particle Decays Z^0 or SUSY, where decays must be performed already at the Particle Decays ProcessLevel of the event generation. Particle Decays The decay description essentially copies the one present in PYTHIA since many years, but with some improvements, e.g. in the decay tables and the number of decay models available. Recently a more sophisticated handling of Particle Decays tau decays has also been introduced. Some issues may need further polishing. Particle Decays Variables determining whether a particle decays Before a particle is actually decayed, a number of checks are made. Particle Decays (i) Decay modes must have been defined for the particle kind; tested by the Particle Decays canDecay() method of Particle Decays Event (and Particle Decays ParticleData ). Particle Decays (ii) The main switch for allowing this particle kind to decay must be on; tested by the Particle Decays mayDecay() method of Particle Decays Event (and Particle Decays ParticleData ). By default this is defined as true for all particles with Particle Decays tau0 below 1000 mm, and false for ones above, see the Particle Decays Particle Data Scheme. This means that Particle Decays mu^+- , Particle Decays pi^+- , Particle Decays K^+- , Particle Decays K^0_L and Particle Decays n/nbar always remain stable unless decays are explicity switched on, e.g. Particle Decays 211:mayDecay  = true. Particle Decays (iii) Particles may be requested to have a nominal proper lifetime Particle Decays tau0 below a threshold. Particle Decays (iv) Particles may be requested to have an actual proper lifetime Particle Decays tau below a threshold. Particle Decays (v) Particles may be requested to decay within a given distance of the origin. Particle Decays (vi) Particles may be requested to decay within a given cylindrical volume around the origin. Particle Decays Mixing Particle Decays Tau decays Decays of Particle Decays tau leptons can be performed using helicity information from the Particle Decays tau production process and with the hadronic current of the Particle Decays tau decay modelled using form factors fit to data. The Particle Decays tau decay framework is largely based on the corresponding Herwig++ implementation Particle Decays Gre07 , with some input from Tauola Particle Decays Jad90. A short summary can be found in Particle Decays Ilt12 , while the complete writeup is in Particle Decays Ilt14. Particle Decays The decays of Particle Decays tau leptons are categorized as Particle Decays correlated , where a Particle Decays tau pair is produced from a single process, or Particle Decays uncorrelated , where only one Particle Decays tau is produced. Currently internally supported Particle Decays tau production mechanisms include correlated decays from Particle Decays gamma , Particle Decays Z^0 , Particle Decays Z'^0 , Particle Decays gamma^*/Z^0/Z'^0 , and Higgs bosons (CP-even, odd, or mixed) and uncorrelated decays from Particle Decays W^+- , Particle Decays W'^+- , Particle Decays B/D hadrons, and charged Higgs bosons. For all mechanisms except Particle Decays B/D hadrons, both the full process, e.g. Particle Decays q qbar &rarr; Z^0 &rarr; tau^+ tau^- , as well as just the decay of the boson with a given initial polarization, e.g. Particle Decays Z^0 &rarr; tau^+ tau^- , can be handled. The axial and vector couplings of the Particle Decays Z'^0 and Particle Decays W'^0 are set from the relevant parameters in Particle Decays New Gauge Boson Processes. Note that the CP of the various Higgs bosons can be set with the options Particle Decays HiggsX:parity , Particle Decays HiggsX:etaParity , and Particle Decays HiggsX:phiParity as described in Particle Decays Higgs Processes where Particle Decays X is either Particle Decays H1 , Particle Decays H2 , or Particle Decays A3. Particle Decays The Particle Decays tau polarization and Particle Decays tau decay correlation mechanism can be determined either using Particle Decays internal matrix elements or Particle Decays external SPINUP information provided in the event, e.g. via Les Houches Event Files (LHEF). For internal determination any Particle Decays tau pair or single Particle Decays tau from the processes of the previous list can be handeled. For external determination of a single uncorrelated Particle Decays tau , its polarization is set to its SPINUP information. When the SPINUP for the Particle Decays tau is not valid, e.g. when FSR is applied, the SPINUP for the first copy of that Particle Decays tau is used instead unless also invalid. For the external determination of a correlated Particle Decays tau pair the following options are available. Particle Decays A default behaviour is defined when the polarization and decay mechanism cannot be determined using either the internal or external methods. If the Particle Decays tau is known to be produced from a Particle Decays W^+- , Particle Decays gamma , or Particle Decays Z^0 , the Particle Decays tau or Particle Decays tau pair is assumed to be produced from an unpolarized boson of this type. If the mediator is unknown but there is a correlated Particle Decays tau pair, the pair is assumed to be produced from an unpolarized photon and a warning is issued. Finally, if the Particle Decays tau is uncorrelated, an unpolarized and uncorrelated decay is performed and a warning is issued. Particle Decays Both the internal and external determination have advantages and disadvantages. For example, if an LHEF Particle Decays Z^0 &rarr; tau^+ tau^- event is passed with SPINUP provided for both Particle Decays tau s but without SPINUP for the Particle Decays Z^0 then with Particle Decays TauDecays:externalTau set to Particle Decays 0 the decays of the Particle Decays tau s will be uncorrelated. Using Particle Decays 1 instead will result in correlations, assuming an unpolarized Particle Decays Z^0. If using internal determination, then the correlation and polarization will be fully calculated using the correct production mechanism for the Particle Decays Z^0. Consequently, a variety of options on how to determine polarization and correlation are available, with a sensible default in place which should catch most everything. Particle Decays QED radiation So far PYTHIA does not have any generic machinery for handling QED radiation in normal particle decays. In order to include this, a program like Photos Particle Decays Bar94, Dav10 could be used as an afterburner. In a few cases, however, the existing shower machinery can be used also here: for two-body decays to a lepton pair ( Particle Decays l^+ l^- or Particle Decays l^+- nu_l ). Such decays are mediated by Particle Decays gamma^*/Z^0/W^+- exchange, for which PYTHIA does have an existing machinery that can be applied, including first-order matrix-element corrections for the first (hardest) photon emission. Particle Decays Other variables Particle Decays When a decay mode is defined in terms of a partonic content, a random multiplicity (and a random flavour set) of hadrons is to be picked, especially for some charm and bottom decays. This is done according to a Poissonian distribution, for Particle Decays n_p normal particles and Particle Decays n_q quarks the average value is chosen as Particle Decays n_p/ 2 + n_q/4 + multIncrease * ln ( mDiff / multRefMass) with Particle Decays mDiff the difference between the decaying particle mass and the sum of the normal-particle masses and the constituent quark masses. For gluon systems Particle Decays multGoffset offers and optional additional term to the multiplicity. The lowest possible multiplicity is Particle Decays n_p + n_q/2 (but at least 2) and the highest possible 10. If the picked hadrons have a summed mass above that of the mother a new try is made, including a new multiplicity. These constraints imply that the actual average multiplicity does not quite agree with the formula above. Particle Decays Modes for Matrix Element Processing Some decays can be treated better than what pure phase space allows, by reweighting with appropriate matrix elements. In others a partonic content has to be converted to a set of hadrons. The presence of such corrections is signaled by a nonvanishing Particle Decays meMode() value for a decay mode in the Particle Decays particle data table. The list of allowed possibilities almost agrees with the PYTHIA 6 ones, but several obsolete choices have been removed, a few new introduced, and most have been moved for better consistency. Here is the list of currently allowed Particle Decays meMode() codes: Particle Decays Particle Decays 0 : pure phase space of produced particles ('default'); input of partons is allowed and then the partonic content is converted into the minimal number of hadrons (i.e. one per parton pair, but at least two particles in total) Particle Decays 1 : Particle Decays omega and Particle Decays phi &rarr; pi+ pi- pi0 Particle Decays 2 : polarization in Particle Decays V &rarr; PS + PS ( Particle Decays V = vector, Particle Decays PS = pseudoscalar), when Particle Decays V is produced by Particle Decays PS &rarr; PS + V or Particle Decays PS &rarr; gamma + V Particle Decays 11 : Dalitz decay into one particle, in addition to the lepton pair (also allowed to specify a quark-antiquark pair that should collapse to a single hadron) Particle Decays 12 : Dalitz decay into two or more particles in addition to the lepton pair Particle Decays 13 : double Dalitz decay into two lepton pairs Particle Decays 21 : decay to phase space, but weight up Particle Decays neutrino_tau spectrum in Particle Decays tau decay Particle Decays 22 : weak decay; if there is a quark spectator system it collapses to one hadron; for leptonic/semileptonic decays the Particle Decays V-A matrix element is used, for hadronic decays simple phase space Particle Decays 23 : as 22, but require at least three particles in decay Particle Decays 31 : decays of type B &rarr; gamma X, very primitive simulation where X is given in terms of its flavour content, the X multiplicity is picked according to a geometrical distribution with average number 2, and the photon energy spectrum is weighted up relative to pure phase space Particle Decays 42 - 50 : turn partons into a random number of hadrons, picked according to a Poissonian with average value as described above, but at least Particle Decays code - 40 and at most 10, and then distribute then in pure phase space; make a new try with another multiplicity if the sum of daughter masses exceed the mother one Particle Decays 52 - 60 : as 42 - 50, with multiplicity between Particle Decays code - 50 and 10, but avoid already explicitly listed non-partonic channels Particle Decays 62 - 70 : as 42 - 50, but fixed multiplicity Particle Decays code - 60 Particle Decays 72 - 80 : as 42 - 50, but fixed multiplicity Particle Decays code - 70, and avoid already explicitly listed non-partonic channels Particle Decays 91 : decay to Particle Decays q qbar or Particle Decays g g , which should shower and hadronize Particle Decays 92 : decay onium to Particle Decays g g g or Particle Decays g g gamma (with matrix element), which should shower and hadronize Particle Decays 93 : decay of colour singlet to Particle Decays q qbar plus another singlet, flat in phase space (and arbitrarily ordered), where the Particle Decays q qbar pair should shower and hadronize Particle Decays 94 : same as 93, but weighted with Particle Decays V-A weak matrix element if the decay chain is of the type Particle Decays neutrino \rarr; dbar u lepton in that order Particle Decays 100 - : reserved for the description of partial widths of Particle Decays resonances Three special decay product identity codes are defined. Particle Decays Particle Decays 81: remnant flavour. Used for weak decays of c and b hadrons, where the c or b quark decays and the other quarks are considered as a spectator remnant in this decay. In practice only used for baryons with multiple c and b quarks, which presumably would never be used, but have simple (copied) just-in-case decay tables. Assumed to be last decay product. Particle Decays 82: random flavour, picked by the standard fragmentation flavour machinery, used to start a sequence of hadrons, for matrix element codes in 41 - 80. Assumed to be first decay product, with -82 as second and last. Where multiplicity is free to be picked it is selected as for normal quarkonic systems. Currently unused. Particle Decays 83: as for 82, with matched pair 83, -83 of decay products. The difference is that here the pair is supposed to come from a closed gluon loop (e.g. Particle Decays eta_c &rarr; g g ) and so have a somewhat higher average multiplicity than the simple string assumed for 82, see the Particle Decays ParticleDecays:multGoffset parameter above."},{"name":"Particle Properties","link":"ParticleProperties.html","text":"Particle Properties Particle Properties Particle Properties A Particle Properties Particle corresponds to one entry/slot in the event record. Its properties therefore is a mix of ones belonging to a particle-as-such, like its identity code or four-momentum, and ones related to the event-as-a-whole, like which mother it has. Recall that energies, momenta and masses are all given in GeV, and space-time coordinates all in mm, i.e. units are chosen such that the speed of light Particle Properties c is unity. In particular, times are also in mm, Particle Properties not in seconds. Particle Properties What is stored for each particle is Particle Properties Particle Properties the identity code, Particle Properties the status code, Particle Properties two mother indices, Particle Properties two daughter indices, Particle Properties a colour and an anticolour index, Particle Properties the four-momentum and mass, Particle Properties the scale at which the particle was produced (optional), Particle Properties the polarization/spin/helicity of the particle (optional), Particle Properties the production vertex and proper lifetime (optional), Particle Properties a pointer to the particle kind in the particle data table, and Particle Properties a pointer to the event the particle belongs to. From these, a number of further quantities may be derived. Particle Properties Basic output methods The following member functions can be used to extract the most important information: Particle Properties Input methods The same method names as above are also overloaded in versions that set values. These have an input argument of the same type as the respective output above, and are of type Particle Properties void. Particle Properties There are also a few alternative methods for input: Particle Properties Further output methods In addition, a number of derived quantities can easily be obtained, but cannot be set, such as: Particle Properties Not part of the Particle Properties Particle class proper, but obviously tightly linked, are the two methods Particle Properties Properties of the particle species Each Particle contains a pointer to the respective Particle Properties ParticleDataEntry object in the Particle Properties particle data tables. This gives access to properties of the particle species as such. It is there mainly for convenience, and should be thrown if an event is written to disk, to avoid any problems of object persistency. Should an event later be read back in, the pointer will be recreated from the Particle Properties id code if the normal input methods are used. (Use the Particle Properties Particle Properties Event::restorePtrs() method if your persistency scheme bypasses the normal methods.) This pointer is used by the following member functions: Particle Properties Methods that may access the event the particle belongs to A particle can be created on its own. When inserted into an event record, it obtains a pointer to that event-as-a-whole. It is then possible to use methods that do not make sense for a particle in isolation. These methods are listed below. Whenever the pointer to the event is not defined, these will return an appropriate 'null' value, this being -1 for an integer, false for a bool, and empty for a vector, unless otherwise specified. Particle Properties Methods that perform operations There are some further methods, some of them inherited from Particle Properties Vec4 , to modify the properties of a particle. They are of little interest to the normal user. Particle Properties Constructors and operators Normally a user would not need to create new particles. However, if necessary, the following constructors and methods may be of interest."},{"name":"Parton Distributions","link":"PartonDistributions.html","text":"Parton Distributions Parton Distributions Parton Distributions The parton distributions file contains the Parton Distributions PDF class. Parton Distributions PDF is the base class, from which specific Parton Distributions PDF classes are derived. Parton Distributions The choice of which PDF to use is made by settings in the Parton Distributions Pythia class, see Parton Distributions here. These settings also allow to access all the proton PDF's available in the LHAPDF library Parton Distributions Wha05,Buc15. Thus there is no need for a normal user to study the Parton Distributions PDF class. The structure must only be understood when interfacing new PDF's, e.g. ones not yet found in LHAPDF. Parton Distributions The PDF base class Parton Distributions PDF defines the interface that all PDF classes should respect. The constructor requires the incoming beam species to be given: even if used for a proton PDF, one needs to know whether the beam is actually an antiproton. This is one of the reasons why Parton Distributions Pythia always defines two PDF objects in an event, one for each beam. Parton Distributions Once a Parton Distributions PDF object has been constructed, call it Parton Distributions pdf , the main method is Parton Distributions pdf.xf( id, x, Q2) , which returns Parton Distributions x*f_id(x, Q2) , properly taking into account whether the beam is an antiparticle or not. Parton Distributions Whenever the Parton Distributions xf member is called with a new flavour, Parton Distributions x or Parton Distributions Q^2 , the Parton Distributions xfUpdate member is called to do the actual updating. This routine may either update that particular flavour or all flavours at this Parton Distributions (x, Q^2) point. (In the latter case the saved Parton Distributions id value Parton Distributions idSav should be set to 9.) The choice is to be made by the producer of a given set, based on what he/she deems most effective, given that sometimes only one flavour need be evaluated, and about equally often all flavours are needed at the same Parton Distributions x and Parton Distributions Q^2. Anyway, the latest value is always kept in memory. This is the other reason why Parton Distributions Pythia has one separate Parton Distributions PDF object for each beam, so that values at different Parton Distributions x can be kept in memory. Parton Distributions Two further public methods are Parton Distributions xfVal( id, x, Q2) and Parton Distributions xfSea( id, x, Q2). These are simple variants whereby the quark distributions can be subdivided into a valence and a sea part. If these are not directly accessible in the parametrization, one can make the simplified choices Parton Distributions u_sea = ubar_sea, u_val = u_tot - u_sea , and correspondingly for Parton Distributions d. (Positivity will always be guaranteed at output.) The Parton Distributions xfUpdate method should also take care of updating this information. Parton Distributions A method Parton Distributions setExtrapolate(bool) allows you to switch between freezing parametrizations  at the low- Parton Distributions x boundary ( Parton Distributions false ) or extrapolate them outside the boundary ( Parton Distributions true ). This method works both for LHAPDF 5, LHAPDF6 and modern internal PDFs. (For some older PDFs the behaviour implemented by the original authors is maintained.) In either case the PDFs are frozen at Parton Distributions Q_min and Parton Distributions Q_max. (And also at Parton Distributions x_max , but this is irrelevant when Parton Distributions x_max = 1 .) Parton Distributions With Parton Distributions insideBounds(double x, double Q2) you can probe whether an Parton Distributions (x, Q^2) pair falls inside the fit region or not. The Parton Distributions alphaS(double Q2) method returns the Parton Distributions alpha_s of the PDF at the given Parton Distributions Q^2 scale, while Parton Distributions mQuarkPDF(int id) returns the quark masses used to set flavour thresholds. Currently these three methods are only implemented for LHAPDF6. Parton Distributions Derived classes There is only one pure virtual method, Parton Distributions xfUpdate , that therefore must be implemented in any derived class. A reasonable number of such classes come with the program: Parton Distributions For protons: Parton Distributions Parton Distributions Parton Distributions LHAPDF provides a plugin interface class to the LHAPDF library Parton Distributions Wha05,Buc15. It loads either the Parton Distributions LHAPDF5 or Parton Distributions LHAPDF6 class. Parton Distributions Parton Distributions GRV94L gives the GRV 94 L parametrization Parton Distributions Glu95. Parton Distributions Parton Distributions CTEQ5L gives the CTEQ 5 L parametrization Parton Distributions Lai00. Parton Distributions Parton Distributions MSTWpdf gives the four distributions of the MRST/MSTW group that have been implemented. Parton Distributions Parton Distributions CTEQ6pdf gives the six distributions of the CTEQ/CT group that have been implemented. Parton Distributions Parton Distributions NNPDF gives four distributions from the NNPDF 2.3 QCD+QED sets that have been implemented. Parton Distributions Parton Distributions LHAGrid1 can read and use files in the LHAPDF6 lhagrid1 format, assuming that the same x grid is used for all Q subgrids. Results are not exactly identical with LHAPDF6, owing to different interpolation. Parton Distributions Parton Distributions nPDF, Isospin, EPS09 three classes allowing to introduce nuclear modifications to a specified proton PDF. The first is base class for the other two, where Parton Distributions Isospin only provides the appropriate mix of protons and isospin-conjugate neutrons, while Parton Distributions EPS09 also contains nuclear modification factors Parton Distributions Esk09. The current default is NNPDF 2.3. Parton Distributions For charged pions: Parton Distributions Parton Distributions Parton Distributions GRVpiL gives the GRV 1992 pi+ parametrization. Parton Distributions For Pomerons (used to describe diffraction): Parton Distributions Parton Distributions Parton Distributions PomFix gives a simple but flexible Parton Distributions Q2 -independent parametrization. Parton Distributions Parton Distributions PomH1FitAB gives the H1 2006 Fit A and Fit B parametrizations. Parton Distributions Parton Distributions PomH1Jets gives the H1 2007 Jets parametrization. Parton Distributions For photons: Parton Distributions Parton Distributions Parton Distributions CJKL gives the CJKL parametrization Parton Distributions Cor03. Parton Distributions Parton Distributions GammaPoint gives the trivial distribution of a pointlike (i.e. unresolved) photon. Parton Distributions For charged leptons (e, mu, tau) and the proton: Parton Distributions Parton Distributions Parton Distributions Lepton gives a QED parametrization Parton Distributions Kle89. In QED there are not so many ambiguities, so here one set should be enough. On the other hand, there is the problem that the lepton-inside-lepton pdf is integrably divergent for Parton Distributions x &rarr; 1 , which gives numerical problems. Like in PYTHIA 6, the pdf is therefore made to vanish for Parton Distributions x > 1 - 10^{-10} , and scaled up in the range Parton Distributions 1 - 10^{-7} < x < 1 - 10^{-10} in such a way that the total area under the pdf is preserved. Parton Distributions Parton Distributions LeptonPoint gives the trivial distribution of a pointlike (i.e. unresolved) charged lepton. Parton Distributions Parton Distributions EPAexternal provides an external photon flux to study photoproduction with different fluxes. Still optimized for lepton beams, but also other fluxes can be studied. Parton Distributions Parton Distributions Lepton2gamma gives the convolution between photon flux from leptons and photon PDFs. Parton Distributions Parton Distributions ProtonPoint gives the equivalent photon spectrum of an unresolved proton. Parton Distributions For neutrinos: Parton Distributions Parton Distributions Parton Distributions NeutrinoPoint is the only method, so there is no choice. Analogously to Parton Distributions LeptonPoint it gives the distribution of a pointlike (i.e. unresolved) neutrino. A difference, however, is that neutrinos always are lefthanded, so there is no need to average over incoming spin states. Since the PYTHIA formalism assumes unpolarized beams, and thus implicitly includes a 1/2 for incoming fermions, the Parton Distributions NeutrinoPoint PDF is normalized to 2 rather than 1 to compensate for this. Parton Distributions There is another method, Parton Distributions isSetup() , that returns the base-class boolean variable Parton Distributions isSet. This variable is initially Parton Distributions true , but could be set Parton Distributions false if the setup procedure of a PDF failed, e.g. if the user has chosen an unknown PDF set. Parton Distributions The MRST/MSTW, CTEQ/CT, NNPDF and H1 PDF routines are based on the interpolation in Parton Distributions (x, Q) grids. The grid files are stored in the Parton Distributions xmldoc subdirectory, like settings and particle data. Only PDF sets that will be used are read in during the initialization stage. Just as input streams can be used to initialize the settings and particle data, so can the individual PDFs be constructed.  See the header files for explicit constructor descriptions."},{"name":"Parton Showers","link":"PartonShowers.html","text":"Parton Showers Parton Showers Parton Showers Parton Showers Shower Model Selection As of version 8.3, PYTHIA comes with three different complete parton-shower frameworks: the original 'simple' showers, the VINCIA antenna showers and the Dire dipole showers. Thereby comparisons between these different shower approaches become easier. A warning, however, is that the integration of VINCIA and Dire is still ongoing, so one may expect some adjustments to occur in the next few releases, over and above the level of normal evolution. Parton Showers Since early days PYTHIA 8 has allowed external shower programs to be linked, thereby replacing the internal simple ones, see the Parton Showers Implement New Showers page. The VINCIA and Dire codes originally were structured to make use of this functionality, but were developed and distributed as separate codes. Starting with version 8.300, these two programs now are fully integrated into the PYTHIA distributions, and appear on equal footing with the old simple showers. Which of the internal shower frameworks that will be used in a run is determined by the following switch. Parton Showers There are some differences between the showers to be aware of Parton Showers Parton Showers The Dire shower comes with a nontrivial variable weight. It is therefore important that results for each event are weighted by the event weight in Parton Showers pythia.info.weight() , e.g. when filled in a histogram. The simple and VINCIA showers by default come with unit weight, so do not have that issue. (Non-unit weights can still come from the hard-process cross section in some cases, so it is prudent always to apply the event weight.) Parton Showers While all three shower models do ordinary QCD and QED radiation, beyond that the capabilities vary. Parton Showers Tuned parameter values for PYTHIA's modeling of nonperturbative physics are normally only valid for the specific shower model they were tuned with, due to differences in perturbative regularisations between the three shower models and a nontrivial interplay between perturbative and nonperturbative physics modeling in general. Both VINCIA and Dire therefore come with their own dedicated default tune parameters which are activated in different ways, see the respective documentation pages. Parton Showers As mentioned above, some of the hallmark features of VINCIA during its standalone development have not yet been carried over to the PYTHIA implementation. This includes (iterated) matrix-element corrections, automated uncertainty variations, tree-level 2&rarr;4 branchings and NLO corrected 2&rarr; 3 ones, sector showers, facilities for matching and merging, and the VinciaRoot tool for live histogram displays. This is work in progress and we expect most of these features to reappear in future releases of PYTHIA 8.3. Parton Showers Some details Originally the Parton Showers TimeShower and Parton Showers SpaceShower classes implemented the simple shower, but also acted as base classes from which the external showers derived. This had some disadvantages for the purpose of the tighter integration of VINCIA and Dire, so the two aspects are now split. The Parton Showers TimeShower and Parton Showers SpaceShower classes remain as bare-bones base classes, from which the actual showers are derived. The code for the simple showers has been moved to the new derived Parton Showers SimpleTimeShower and Parton Showers SimpleSpaceShower. An external shower that does not use any of the existing shower algorithms will therefore work as before, which would be the normal case, but alternatively a shower could derive from the new classes and then reuse relevant code in them. Parton Showers Settings names for the simple shower have been retained through this transformation, again for reasons of backwards compatibility of user code, e.g. in command files. Thus setting names beginning with Parton Showers TimeShower: , Parton Showers SpaceShower: , Parton Showers WeakShower: or Parton Showers UncertaintyBands: refer to the current baseline 'simple' showers, and so do the Parton Showers HiddenValley: shower-related settings. As a rule, the corresponding VINCIA settings begin with Parton Showers Vincia: and the Dire ones with Parton Showers Dire: , Parton Showers DireTimes: , Parton Showers DireSpace: or Parton Showers Variations:. A few of the simple shower settings also apply to the other two, as documented on the respective page. It is possible that future evolution will standardize some settings, while others will be more clearly separated."},{"name":"PDF Selection","link":"PDFSelection.html","text":"PDF Selection PDF Selection PDF Selection This page contains several subsections. The first deals with how to pick the parton distribution set for protons, including from LHAPDF, to be used for all proton and antiproton beams. The second is a special option that allows a separate PDF set to be used for the hard process only, while the first choice would still apply to everything else. The third introduces the possibility of nuclear modifications. Further sections give access to pion, Pomeron and photon PDF's, respectively, the second being used to describe diffractive systems. Towards the end comes the possibility to switch off the lepton 'parton density', and photons from lepton beams. More information on PDF classes is found PDF Selection here. PDF Selection Parton densities for protons PYTHIA comes with a reasonably complete list of recent LO fits built-in, both ones within the normal LO context and ones with modifications for better matching to event generators. In addition two older sets are included for backwards reference (most studies to date are based on CTEQ 5L). Therefore there is no real need to link any external PDF sets. PDF Selection If the internal PDF sets are not sufficient, the PDF Selection LHAPDF library PDF Selection Wha05,Buc15 gives you access to a much wider selection. PDF Selection Warning 1: owing to previous problems with the behaviour of PDF's beyond the PDF Selection x and PDF Selection Q^2 boundaries of a set, you should only use LHAPDF PDF Selection version 5.3.0 or later. PDF Selection Warning 2: the behaviour of the LHAPDF sets need not be identical with the implementation found in PYTHIA. Specifically we are aware of the following points that may influence a comparison. PDF Selection (a) CTEQ 5L in PYTHIA is the parametrization, in LHAPDF the grid interpolation. PDF Selection (b) MRST LO* and LO** in PYTHIA is based on an updated edition, where one makes use of the expanded MSTW grid format, while LHAPDF is based on the original smaller grid. PDF Selection (c) The CTEQ 6 and CT09MC sets in PYTHIA are frozen at the boundaries of the grid, by recommendation of the authors, while LHAPDF also offers an option with a smooth extrapolation outside the grid boundaries. PDF Selection If you do not want to install LHAPDF, it is possible to use LHAPDF6 data grids natively in PYTHIA. This is based on a simplified implementation of interpolation in a PDF Selection .dat 'lhagrid1' file, and so does not give fully identical results, and also is not foolproof. PDF Selection The selection of parton densities is made once and then is propagated through the program. It is essential to make an informed choice, for several reasons PDF Selection Kas10 : PDF Selection Warning 1: the choice of PDF set affects a number of properties of events. A change of PDF therefore requires a complete retuning e.g.  of the multiparton-interactions model for minimum-bias and underlying events. Conversely, the PDF Selection pp physics tunes are all made for a specific PDF tune, and the chosen (or default) tune will therefore overwrite the PDF Selection PDF:pSet default value described below. If you want to set PDF Selection PDF:pSet differently it should be done PDF Selection after the PDF Selection Tune:pp value, if any, has been set. PDF Selection Warning 2: People often underestimate the differences between different sets on the market. The sets for the same order are constructed to behave more or less similarly at large PDF Selection x and PDF Selection Q^2 , while the multiparton interactions are dominated by the behaviour in the region of small PDF Selection x and PDF Selection Q^2. A good PDF parametrization ought to be sensible down to PDF Selection x = 10^-6 ( PDF Selection x = 10^-7 ) and PDF Selection Q^2 = 1 GeV^2 for Tevatron (LHC) applications. Unfortunately there are distributions on the market that completely derail in that region. The PDF Selection main51.cc and PDF Selection main52.cc programs in the PDF Selection examples subdirectory provide some examples of absolutely minimal sanity checks before a new PDF set is put in production. PDF Selection Warning 3: NLO and LO sets tend to have quite different behaviours, e.g. NLO ones have less gluons at small x, which then is compensated by positive corrections in the NLO matrix elements. Therefore do not blindly assume that an NLO tune has to be better than an LO one when combined with the LO matrix elements in PYTHIA. There are explicit examples where such thinking can lead you down the wrong alley, especially if you study low- PDF Selection pT physics. A longer discussion on this point can be found in PDF Selection this note. In the list below you should therefore be extra cautious when using set 6 or set 9. PDF Selection If you want to use PDF's not found in LHAPDF, or you want to interface LHAPDF another way, you have full freedom to use the more generic PDF Selection interface options. PDF Selection Parton densities for protons in the hard process The above options provides a PDF set that will be used everywhere: for the hard process, the parton showers and the multiparton interactions alike. As already mentioned, therefore a change of PDF should be accompanied by a PDF Selection complete retuning of the whole MPI framework, and maybe more. There are cases where one may want to explore different PDF options for the hard process, but would not want to touch the rest. If several different sets are to be compared, a simple reweighting based on the PDF Selection originally used flavour, PDF Selection x , PDF Selection Q^2 and PDF values may offer the best route. The options in this section allow a choice of the PDF set for the hard process alone, while the choice made in the previous section would still be used for everything else. The hardest interaction of the minimum-bias process is part of the multiparton-interactions framework and so does not count as a hard process here. PDF Selection Of course it is inconsistent to use different PDF's in different parts of an event, but if the PDF Selection x and PDF Selection Q^2 ranges mainly accessed by the components are rather different then the contradiction would not be too glaring. Furthermore, since standard PDF's are one-particle-inclusive we anyway have to 'invent' our own PDF modifications to handle configurations where more than one parton is kicked out of the proton PDF Selection Sjo04. PDF Selection The PDF choices that can be made are the same as above, so we do not repeat the detailed discussion. PDF Selection Nuclear modifications of parton densities PDF Selection Nuclear modifications of the PDFs are implemented for the hard-process generation only. The final PDF value is calculated for an average nucleon within given nucleus, i.e. PDF Selection f_i^A(x,Q^2) = (Z/A)*f_i^(p/A) + ((A-Z)/A)*f_i^(n/A) , where PDF Selection A is the nuclear mass number and PDF Selection Z the number of protons, set using the PDG code for nucleus. The neutron PDFs are obtained by applying isospin symmetry, e.g. PDF Selection f_u^(n/A)(x,Q^2) = f_d^(p/A)(x,Q^2). The nuclear PDFs implemented provide only the nuclear modification so the full PDF is calculated by multiplying the selected free proton PDF with the modification. PDF Selection PDF Selection Parton densities for pions The parton densities of the pion are considerably less well known than those of the proton. There are only rather few sets on the market, and none particularly recent. Only one comes built-in, but others can be accessed from LHAPDF. Input parametrizations are for the PDF Selection pi+. >From this the PDF Selection pi- is obtained by charge conjugation and the PDF Selection pi0 from averaging (half the pions have PDF Selection d dbar valence quark content, half PDF Selection u ubar. PDF Selection Much of the switches are taken over from the proton case, with obvious modifications; therefore the description is briefer. Currently we have not seen the need to allow separate parton densities for hard processes. When using LHAPDF the PDF Selection PDF:extrapolateLHAPDF switch of the proton also applies to pions. PDF Selection Parton densities for Pomerons The Pomeron is introduced in the description of diffractive events, i.e. a diffractive system is viewed as a Pomeron-proton collision at a reduced CM energy. Here the PDF's are even less well known. Most experimental parametrizations are NLO, which makes them less well suited for Monte Carlo applications. Furthermore note that the momentum sum is arbitrarily normalized to a non-unity value. PDF Selection Parton densities for photons Photon PDFs describe the partonic content of the resolved photons and can be used to generate any process initiated by quarks and gluons. PDF Selection There are several PDF sets available for photons, although there have not been much activity recently. Currently one internal set is included, but more sets are available from LHAPDF5. The sets from LHAPDF5 can only be used as PDFs in the hard process (see PDF Selection PDF:GammaHardSet below). In case of photons the parton shower and beam remnant generation require additional methods that are provided only for internal sets. Currently no photon PDFs have been included in LHAPDF6. PDF Selection Parton densities for leptons For electrons/muons/taus there is no need to choose between different parametrizations, since only one implementation is available, and should be rather uncontroversial (apart from some technical details). However, insofar as e.g. PDF Selection e^+ e^- data often are corrected back to a world without any initial-state photon radiation, it is useful to have a corresponding option available here. PDF Selection Neutrinos are always taken pointlike. Do note that the phase space selection machinery currently does not allow one resolved and one unresolved lepton beam. For lepton-neutrino collisions to work you must therefore set PDF Selection PDF:lepton = off. PDF Selection Photons from lepton beams Lepton beams can emit photons and therefore may have partonic content. The PDFs describing these can be obtained by convoluting the photon flux with the selected photon PDFs. The photon flux is modelled according to equivalent photon approximation (EPA) which gives the flux of bremsstrahlung photons. PDF Selection Incoming parton selection There is one useful degree of freedom to restrict the set of incoming quark flavours for hard processes. It does not change the PDF's as such, only which quarks are allowed to contribute to the hard-process cross sections. Note that separate but similarly named modes are available for multiparton interactions and spacelike showers."},{"name":"Phase Space Cuts","link":"PhaseSpaceCuts.html","text":"Phase Space Cuts Phase Space Cuts Phase Space Cuts Phase Space Cuts PhaseSpace is base class for all hard-process phase-space generators, either generic Phase Space Cuts 2 &rarr; 1 or Phase Space Cuts 2 &rarr; 2 ones, or specialized ones like for elastic and diffractive scattering. Phase Space Cuts In it, it is possible to constrain the kinematics of most processes. (Exceptions are 'soft physics', i.e. minimum bias, elastic and diffractive processes. The Coulomb singularity for elastic scatterings, if simulated, is Phase Space Cuts handled separately .) These constraints apply in the rest frame of the hard subprocess, and topologies normally would be changed e.g. by subsequent showering activity. The cross section of a process is adjusted to only correspond to the allowed phase space. Phase Space Cuts The more particles in the final state, the more cuts could be applied. Here we have tried to remain with the useful minimum, however. More generic possibilities could be handled by the Phase Space Cuts user hooks facility. Phase Space Cuts Cuts in all processes Phase Space Cuts Cuts in Phase Space Cuts 2 &rarr; 1 processes When a resonance Phase Space Cuts id is produced, the Phase Space Cuts Phase Space Cuts mMin(id) and Phase Space Cuts Phase Space Cuts mMax(id) methods restrict the allowed mass range of this resonance. Therefore the allowed range is chosen to be the overlap of this range and the Phase Space Cuts mHatMin to Phase Space Cuts mHatMax range above. Most resonances by default have no upper mass limit, so effects mainly concern the lower limit. Should there be no overlap between the two ranges then the process will be switched off. Phase Space Cuts Cuts in Phase Space Cuts 2 &rarr; 2 processes Phase Space Cuts For a particle with a Breit-Wigner shape selected, according to the rules above and to the rules of the particle species itself, the Phase Space Cuts Phase Space Cuts mMin(id) and Phase Space Cuts Phase Space Cuts mMax(id) methods restrict the allowed mass range of the particle, just like for the Phase Space Cuts 2 &rarr; 1 processes. Phase Space Cuts Cuts in Phase Space Cuts 2 &rarr; 3 processes There are two main classes of Phase Space Cuts 2 &rarr; 3 processes. One is the processes such as Phase Space Cuts WW/ZZ -fusion Higgs production, i.e. Phase Space Cuts q q &rarr; q q H , where there are no special singularities associated with two partons in the final state being collinear, or even for Phase Space Cuts pT &rarr; 0. For this class, no further cuts have been introduced than those already available for Phase Space Cuts 2 &rarr; 2 processes. Specifically, for now all three are restricted exactly the same way by Phase Space Cuts pTHatMin and Phase Space Cuts pTHatMax. As above, Breit-Wigner mass ranges can be restricted. Phase Space Cuts The other Phase Space Cuts 2 &rarr; 3 event class is QCD processes, such as Phase Space Cuts g g &rarr; g g g. Here the soft and collinear singularities play a major role, and the phase space generation and cuts have been adapted to this. For this class, an alternative set of cuts is used, as outlined in the following. First of all the three outgoing partons are ordered in falling Phase Space Cuts pT , i.e. Phase Space Cuts pT_3 > pT_4 > pT_5 (where the labeling 3, 4, 5 of the outgoing partons is random, i.e. unrelated to the order specified in the process name). The allowed ranges of Phase Space Cuts pT_3 and Phase Space Cuts pT_5 can be specified, but obviously Phase Space Cuts pT_3max >= pT_5max and Phase Space Cuts pT_3min >= pT_5min. The Phase Space Cuts pT_4 is not constrained explicitly, but is constructed from the vector sum of Phase Space Cuts pT_3 and Phase Space Cuts pT_5 , subject to the constraint that it has to lie between the two in magnitude. While the Phase Space Cuts pT cuts take care of singularities collinear with the incoming beams, it is also necessary to handle final-state singularities, when two outgoing partons become collinear. This is done by requiring a minimal separation in Phase Space Cuts R , where Phase Space Cuts R^2 = (Delta eta)^2 + (Delta phi)^2. Finally, a note about efficiency. The QCD Phase Space Cuts 2 &rarr; 3 phase space is not set up to explicitly include Phase Space Cuts mHat as one of the basic variables. Such a cut is only done after a phase space point is already selected, which means that a narrow mass choice will slow down the program appreciably. Also narrow Phase Space Cuts pT_3 and Phase Space Cuts pT_5 bins are likely to give inefficient generation, if it gives rise to significant indirect restrictions on Phase Space Cuts pT_4. Phase Space Cuts Generation strategy and documentation During the initialization stage a simplified function is found, that is intended to be above the true cross-section behaviour over the whole of phase space. It is chosen to be easily integrable and invertible. That way a trial phase space point can be selected according this simple function, and then be accepted by the ratio of true to the simple function. For a good efficiency the ratio should be close to unity,  yet never above it. This constrains the absolute normalization of the simple function. The initial search may fail to find the phase space point where the true-to-simple ratio is maximal, however. This then can lead to subsequent maximum violations, where the ratio is above unity. Two alternative strategies are implemented to handle such situations, see below. Phase Space Cuts Reweighting of Phase Space Cuts 2 &rarr; 2 processes Events normally come with unit weight, i.e. are distributed across the allowed phase space region according to the appropriate differential cross sections. Sometimes it may be convenient to have an uneven distribution of events. The classical example here is that many cross sections drop off with transverse momentum Phase Space Cuts pT , such that few events are generated at large Phase Space Cuts pT scales. If one wants to plot the Phase Space Cuts pT cross section, and all that comes with it, the statistical error will then degrade with increasing Phase Space Cuts pT where fewer events end up. Phase Space Cuts One solution is to split the full Phase Space Cuts pT range into several separate subranges, where the events of each subsample obtains a different overall normalization. Specifically, if you generate a comparable number of events in each Phase Space Cuts pT bin, such that larger Phase Space Cuts pT bins are oversampled, these bins come with a correspondingly reduced overall weight, that needs to be taken into account when the bins are combined. The other is to have a continuously increasing oversampling of events at larger Phase Space Cuts pT scales, which is compensated by a continuously decreasing weight for the event. Phase Space Cuts Both of these solutions are supported. Specifically, for Phase Space Cuts 2 &rarr; 2 processes, the Phase Space Cuts pTHat scale offers a convenient classification of the event. (Of course, two events starting out from the same Phase Space Cuts pTHat scale will experience different parton shower evolutions, etc., and may therefore look quite different at the end.) The two cuts Phase Space Cuts PhaseSpace:pTHatMin and Phase Space Cuts PhaseSpace:pTHatMax therefore offers a way to slice a Phase Space Cuts pT range into subranges, see e.g. Phase Space Cuts main08.cc. Alternatively the Phase Space Cuts User Hooks machinery offers the possibility for you to define your own reweighting of phase space sampling, with a corresponding event weight, with Phase Space Cuts UserHooks::canBiasSelection and related methods. Phase Space Cuts As a simplified option, we here offer the possibility to bias the Phase Space Cuts 2 &rarr; 2 sampling by a power of Phase Space Cuts pTHat , then with events having a weight the inverse of this. This fast track will only work under a number of strict conditions, implemented to reduce the risk of abuse. (Whereas a Phase Space Cuts UserHooks setup can be more flexible.) Specifically it will work if only high- Phase Space Cuts pT Phase Space Cuts 2 &rarr; 2 processes already implemented in PYTHIA are requested, notably the Phase Space Cuts HardQCD ones. That is, you cannot mix with Phase Space Cuts 2 &rarr; 1 or Phase Space Cuts 2 &rarr; 3 processes, nor with external processes (notably Les Houches input) or Phase Space Cuts SoftQCD ones, and  you cannot use the option to define a Phase Space Cuts second hard process in the same event. Furthermore you have to be careful about the choice of Phase Space Cuts PhaseSpace:pTHatMin , since a Phase Space Cuts pTHat = 0 event would come with an infinite weight."},{"name":"Photoproduction","link":"Photoproduction.html","text":"Photoproduction Photoproduction Photoproduction Photoproduction Interactions involving one or two photons, either in photon-photon or photon-hadron collision or photons emitted from lepton beams. Includes both direct and resolved contributions and also soft QCD and MPIs for events with resolved photons. Only (quasi-)real photons are considered so virtuality of the photons is restricted. The PDF set for resolved photons is selected in the Photoproduction PDF selection. This page describes some of the special features related to these collisions and introduces the relevant parameters. Photoproduction Types of photon processes Photoproduction Photons can be either resolved or act as point-like particles (direct). Therefore for a photon-photon interaction there are four different contributions, resolved-resolved, resolved-direct, direct-resolved and direct-direct. In case of photon-hadron collisions there are two contributions. With the default value of the parameter below, a mix of relevant contributions is generated but each process type can also be generated individually. Note that for photon-hadron collisions the code for direct contribution depends on which of the beams is photon. The sample main program Photoproduction main69.cc demonstrates different possibilities. Photoproduction The type of the generated process can be obtained from Photoproduction Info class with method Photoproduction int Info::photonMode() which follows the conventions above. Photoproduction Resolved photon Photoproduction Photons can either interact directly as an unresolved particle or as a hadronic state ('Vector Meson Dominance'). In the latter case the hard process can be simulated using PDFs to describe the partonic structure of the resolved photon. The evolution equations for photons include an additional term that corresponds to Photoproduction gamma &rarr; q qbar splittings. Due to this, the PDFs are somewhat different for photons than for hadrons and some parts of event generation need special attention. Photoproduction Process-level generation Photoproduction Due to the additional term in the evolution equations the quarks in a resolved photon may carry a very large fraction Photoproduction (x~1) of the photon momentum. In these cases it may happen that, after the hard process, there is no energy left to construct the beam remnants. This is true especially if a heavy quark is taken out from the beam and a corresponding massive antiquark needs to be added to the remnant system to conserve flavour. Even though these events are allowed based on the PDFs alone, they are not physical and should be rejected. Therefore some amount of errors can be expected when generating events close to the edge of phase space, e.g. when collision energy is low. Photoproduction Spacelike showers Photoproduction The parton showers are generated according to the DGLAP evolution equations. Due to the Photoproduction gamma &rarr; q qbar splitting in the photon evolution, a few modifications are needed for the ISR algorithm. Photoproduction Photoproduction The additional term corresponds to a possibility to find the original beam photon during the backwards evolution, which is added to the QED part of the spacelike shower evolution. If this splitting happens there is no need to construct the beam remnants for the given beam. Photoproduction The heavy quark production threshold with photon beams is handled in a similar manner as for hadrons, but now the splitting that is forced to happen is Photoproduction gamma &rarr; Q Qbar. Photoproduction As the splittings in backwards evolution increases the Photoproduction x of the parton taken from the beam, the splittings can lead to a situation where there is no room left for massive beam remnants. To make sure that the required  remnants can be constructed, splittings that would not leave room for the beam remnants are not allowed. Photoproduction MPIs with photon beams Photoproduction Multiparton interactions with resolved photon beams are generated as with hadron beams. The only difference follows again from the additional Photoproduction gamma &rarr; q qbar splittings where the beam photon becomes unresolved. If this splitting happens during the interleaved evolution for either of the photon beams no further MPIs below the branching scale Photoproduction pT are allowed since the photon is not resolved anymore. Photoproduction If there have been multiple interactions and a Photoproduction gamma &rarr; q qbar splitting occur, the kinematics of this branching are not constructed in the spacelike shower. Instead the Photoproduction pT scale of the branching is stored and the relevant momenta are then fixed in the beam remnant handling. Therefore the status codes for the partons related to this splitting actually refer to beam remnants. Photoproduction If there are no MPIs before the Photoproduction gamma &rarr; q qbar splitting, this splitting is constructed in the spacelike shower in the usual way, but the mother beam photon is not added to the event record, since a copy of it already exists at the top of the event record. This is unlike the documentation of other ISR splittings, where the mother of the branching is shown, but consistent with the photon not being added (a second time) for events that contain several MPIs. Optionally the photon can be shown, using the following flag. Photoproduction Based on comparisons with charged hadron production in photon-photon collision data from LEP, the default MPI parametrization tuned to proton-(anti)proton collisions produces too much hadrons from the additional interactions. Such differences are not surprising, given that the photon is less hadron-like than the proton, e.g. with less well developed PDFs, leaving less room for MPIs. Therefore a different parametrization for Photoproduction pT0(eCM) is used in case of photon-photon collisions, where the default values are tuned to the LEP data (a reference to this study will be added later). By default, a logarithmic dependence on Photoproduction eCM is used. Photoproduction Note: These parameters override the choices made in Photoproduction Multiparton Interactions when photon-photon collisions are generated. Photoproduction Alternatively, or in combination, a sharp cut can be used. Photoproduction A similar study for photon-hadron collisions will follow, current recommendation is to use value Photoproduction pT0Ref = 3.0 GeV set in Photoproduction Multiparton Interactions page. Photoproduction The total cross section for photon-photon collisions is paramerized as in Photoproduction Sch97. Approximate diffractive cross sections have been defined according to the assumed VMD contribution. Photoproduction Beam Remnants Photoproduction To construct the beam remnants, one should know whether the parton taken from the beam is a valence parton or not. The valence partons of a photon includes the partons that originate from Photoproduction gamma &rarr; q qbar splittings of the original beam photon and the valence partons from the hadron-like part of the PDF. In either case, the flavour of the valence quarks can fluctuate. Unfortunately the decomposition to the different components are typically not provided in the PDF sets and some further assumptions are needed to decide the valence content. Photoproduction When ISR is applied for photon beams it is possible to end up to the original beam photon during the evolution. Therefore there are three possibilities for the remnants: Photoproduction Photoproduction Remnants need to be constructed for both beams. Photoproduction Remnants are constructed only for one side. Photoproduction No need for remnants on either side. The last case is the simplest as all the partons in the event are already generated by the parton showers. In the first case the remnants and primordial Photoproduction kT are constructed similarly as for normal hadronic interactions Photoproduction Sjo04. For the second case the momenta of the remnant partons can not be balanced between the two beams as the kinematics of the other side are already fixed. In these cases the momenta are balanced between the scattered system and the remnants. Photoproduction Since the primordial Photoproduction kT increases the invariant mass of the remnants and the scattered system, it may again happen that there is no room for the remnant partons after Photoproduction kT is added, so the kinematics can not be constructed. In this case new values for Photoproduction kT are sampled. If this does not work, a new shower is generated and in some rare cases the parton-level generation fails and the hard process is rejected. The inclusion of additional MPIs increases the invariant mass of the remnants and takes more momentum from the beam particles. Even though the MPIs that would not leave enough room for the remnants are rejected, these can still lead to a situation where the kinematics cannot be constructed due to the added primordial Photoproduction kT. This may cause some amount of errors especially when the invariant mass of Photoproduction gamma-gamma system is small. Photoproduction Photons from lepton beams Photoproduction Interaction of photons from leptons including photon-photon interactions in lepton-lepton collisions and photon-hadron lepton-hadron collisions can be set up as described in Photoproduction PDF selection. Since the current framework can handle only (quasi-)real photons, a upper limit for the photon virtuality needs to be set. This can be done with the parameter Photoproduction Photon:Q2max. The upper limit for virtuality will set also the upper limit for the Photoproduction k_T of the photon, which in turn will be the same as the Photoproduction k_T of the scattered lepton. Also some other cuts can be imposed. Photoproduction MPIs with lepton beams Photoproduction The invariant mass of Photoproduction gamma-gamma or Photoproduction gamma-hadron system from lepton beams will vary. Therefore, to generate MPIs and non-diffractive events in Photoproduction gamma-gamma and Photoproduction gamma-hadron collisions from lepton beams, the MPI framework is initialized with five values of Photoproduction W from Photoproduction Photon:Wmin to Photoproduction Photon:Wmax. The parameter values are then interpolated for the sampled Photoproduction W."},{"name":"POWHEG Matching","link":"POWHEGMerging.html","text":"POWHEG Matching POWHEG Matching POWHEG Matching POWHEG POWHEG Matching Nas04 in its character is very much like a parton shower, with a Sudakov factor arising from the ordering of emissions. Both POWHEG-BOX POWHEG Matching Ali10 and PYTHIA are based on a combined evolution of ISR and FSR in POWHEG Matching pT -related 'hardness' variables, and thus are kindred spirits. The hardness definitions differ, however. Frequently we will therefore need to distinguish between POWHEG-hardness and PYTHIA-hardness in the following. POWHEG Matching The simplest merging solution, of continuing the PYTHIA shower at the LHA POWHEG Matching scale hardness where POWHEG leaves off, is obtained if you set POWHEG Matching SpaceShower:pTmaxMatch = 1 and POWHEG Matching TimeShower:pTmaxMatch = 1. But then mismatches are bound to happen: some regions may be doublecounted, while others may not be counted at all. Depending on the choice of hardness, such mismatches might be small. POWHEG Matching There are no guarantees, however, so a (hopefully) more accurate merging scheme is coded up in the POWHEG Matching include/Pythia8Plugins/PowHegHooks.h file, with a realistic user example in the POWHEG Matching examples/main31 files. Here we would like to discuss the (POWHEG-specific) input settings for POWHEG Matching main31.cc , see POWHEG Matching main31.cmnd , and attempt to give some recommendations on how to use the main program to perform a matching of POWHEG-BOX with PYTHIA 8. POWHEG Matching POWHEG-BOX inputs contain Born-like events (with no resolved emission) and Real-type events (containing an additional parton). The mismatch between POWHEG-hardness and PYTHIA-hardness can be minimised if the PYTHIA shower knows POWHEG Matching a) The POWHEG-hardness criterion (through which the separation of Born- and Real-like events is defined), and POWHEG Matching b) The POWHEG-hardness value (which separates Born- and Real-like events). POWHEG Matching If these definitions are known, then PYTHIA can fill missing phase space regions through vetoed showering: let the shower sweep over the full phase space, using its PYTHIA-hardness ordering, and use the POWHEG-hardness to veto those emissions that POWHEG should already have covered. This is only possible since the POWHEG-hardness criterion and the shower ordering criterion are very similar. In the more general case a truncated showering would be needed POWHEG Matching Nas04. POWHEG Matching For vetoed showering, it is necessary to define the POWHEG-hardness criterion. In the presence of multiple partons, the definition quickly becomes complicated, and allows for different choices. Similar decisions have already been made in the implementation of POWHEG, one example being the choice in defining which 'hardness value' is transferred as POWHEG-hardness, e.g. by deciding if the 'singular regions' of the FKS or the CS approach are used. If the POWHEG-hardness definition were to be changed, or extended to more objects, the POWHEG Matching PowhegHooks.h code would need to be modified accordingly. POWHEG Matching The merging code is designed to be very flexible, and allows access to many possible choices. However, this flexibility means that many parameters can be changed, potentially leading to confusion. Thus, recommendations might prove helpful. All mistakes and inaccuracies rest with the author. POWHEG Matching We recommend the usage of vetoed showers. This means using POWHEG Matching &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; POWHEG Matching POWHEG:veto = 1 POWHEG Matching This means that PYTHIA will sweep over the full phase space, and apply a veto on parton shower emissions for which the POWHEG-hardness separation between radiator and emission is above the POWHEG-hardness value of the current input event. The variation POWHEG Matching POWHEG:veto = 0 can be used to assess how much phase space is under- or double-counted. POWHEG Matching To define the POWHEG-hardness criterion, use POWHEG Matching &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; POWHEG Matching POWHEG:pTdef = 1 POWHEG Matching Other values can be used by experts to assess variations. POWHEG Matching Both POWHEG-BOX and PYTHIA 8 generate emissions through a parton shower step, meaning that both programs have a clear definition of a radiator that emits particles, which is very similar (if not identical). To fix the ambiguity if the radiator or the emitted particle should be called 'the emission', use POWHEG Matching &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; POWHEG Matching POWHEG:emitted = 0 POWHEG Matching More complicated choices can be used by experts. For instance, use POWHEG Matching POWHEG:emitted = 2 to check the POWHEG-hardness of both radiator and emitted. POWHEG Matching To exhaustively fix the criterion by which to veto parton shower emissions, it is important to decide which partons/parton pairs are used to calculate the POWHEG hardness of a PYTHIA 8 emission. The minimal and recommended choice is POWHEG Matching &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; POWHEG Matching POWHEG:pTemt = 0 POWHEG Matching This means that only the POWHEG hardness with respect to the radiating leg is checked, and recoil effects are neglected. This prescription should be very similar to how a hardness value is assigned to a Real-type event in the POWHEG-BOX, since in the (implementation of FKS in the) POWHEG-BOX, initial state splittings only have singular regions with the radiating initial state parton, and final state splittings only have singular regions with respect to the radiating final state line. Other choices of POWHEG Matching POWHEG:pTemt are available. A warning is that the impact of changes can be huge, particularly for inputs with many jets. Other choices therefore should only be made by experts, and a high degree of caution is advised. POWHEG Matching It is furthermore necessary to decide on a value of the hardness criterion. POWHEG-BOX transfers this value in the POWHEG Matching SCALUP member of Les Houches Events, and we recommend using this value by setting POWHEG Matching &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; POWHEG Matching POWHEG:pThard = 0 POWHEG Matching As a variation, in order to estimate the uncertainty due this choice of POWHEG-hardness definition, it can be useful to also check POWHEG Matching POWHEG:pThard = 2. This will recalculate the POWHEG-hardness value as promoted in POWHEG Matching Ole12. POWHEG Matching You need to decide how many emissions the vetoed shower should check after an allowed emission has been constructed. If the hardness definitions in POWHEG-BOX and PYTHIA 8 where identical, all checking could be stopped after the first allowed PS emission. To be prudent, we recommend setting POWHEG Matching &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; POWHEG Matching POWHEG:vetoCount = 3 POWHEG Matching which will then check up to three allowed emissions. Higher values of POWHEG Matching POWHEG:vetoCount have not lead to visible differences for the processes which have been tested. POWHEG Matching Finally, for many POWHEG processes, the Sudakov effects from electroweak emissions (here we are concerned mainly with photon emissions, but this could apply also to W/Z emissions) are not included. This effect can be investigated using POWHEG Matching POWHEG:QEDveto = 0,1, or POWHEG Matching 2. For the default  value of POWHEG Matching POWHEG:pTemt = 0 , only POWHEG Matching POWHEG:QEDveto = 2 has any effect. For this choice, a hard photon and subsequent QCD radiation is retained. In many cases, particularly when the Born contributions are small, the choice has little effect. POWHEG Matching The modes Note that the modes have generally been defined with several default values below corresponding to the 'off' state, and thus do not agree with the recommended values described above."},{"name":"Program Flow","link":"ProgramFlow.html","text":"Program Flow Program Flow Program Flow Recall that, to first order, the event generation process can be subdivided into three stages: Program Flow Program Flow Initializaion. Program Flow The event loop. Program Flow Finishing. This is reflected in how the top-level Program Flow Pythia class should be used in the user-supplied main program, further outlined in the following. Since the nature of the run is defined at the initialization stage, this is where most of the PYTHIA user code has to be written. So as not to confuse the reader unduly, the description of initialization options has been subdivided into what would normally be used and what is intended for more special applications. Program Flow At the bottom of this webpage is a complete survey of all public Program Flow Pythia methods and data members, in a more formal style than the task-oriented descriptions found in the preceding sections. This offers complementary information. Program Flow Normal usage Program Flow Initialization Program Flow Program Flow Already at the top of the main program file, you need to include the proper header file Program Flow #include 'Pythia8/Pythia.h' To simplify typing, it also makes sense to declare Program Flow using namespace Pythia8; Program Flow Program Flow The first step is to create a generator object, e.g. with Program Flow Pythia pythia; It is this object that we will use from now on. Normally a run will only contain one Program Flow Pythia object. (But you can use several Program Flow Pythia objects, which then will be independent of each other.) Program Flow By default all output from Program Flow Pythia will be on the Program Flow cout stream, but a few methods do allow output to alternative streams or files. Program Flow Program Flow You next want to set up the character of the run. The pages under the 'Setup Run Tasks' heading in the index describe all the options available (with some very few exceptions, found on the other pages). The default values and your modifications are stored in two databases, one for Program Flow generic settings and one for Program Flow particle data. Both of these are initialized with their default values by the Program Flow Pythia constructor. The default values can then be changed, primarily by one of the two ways below, or by a combination of them. Program Flow a) You can use the Program Flow pythia.readString(string); method repeatedly to do a change of a property at a time. The information in the string is case-insensitive, but upper- and lowercase can be combined for clarity. The rules are that Program Flow (i) if the first nonblank character of the string is a letter it is assumed to contain a setting, and is sent on to Program Flow pythia.settings.readString(string) ; Program Flow (ii) if instead the string begins with a digit it is assumed to contain particle data updates, and so sent on to Program Flow pythia.particleData.readString(string) ; Program Flow (iii) if none of the above, the string is assumed to be a comment, i.e. nothing will be done. Program Flow In the former two cases, a warning is issued whenever a string cannot be recognized (maybe because of a spelling mistake). Program Flow Some examples would be Program Flow pythia.readString('TimeShower:pTmin = 1.0');    pythia.readString('111:mayDecay = false'); The Program Flow readString(string) method is intended primarily for a few changes. It can also be useful if you want to construct a parser for input files that contain commands both to PYTHIA and to other libraries. Program Flow Program Flow b) You can read in a file containing a list of those variables you want to see changed, with a Program Flow pythia.readFile(fileName); Each line in this file with be processes by the Program Flow readString(string) method introduced above. You can thus freely mix comment lines and lines handed on to Program Flow Settings or to Program Flow ParticleData. Program Flow This approach is better suited for more extensive changes than a direct usage of Program Flow readString(string) , and can also avoid having to recompile and relink your main program between runs. Program Flow It is also possible to read input from an Program Flow istream , by default Program Flow cin , rather than from a file. This may be convenient if information is generated on-the-fly, within the same run. Program Flow Changes are made sequentially in the order the commands are encountered during execution, meaning that if a parameter is changed several times it is the last one that counts. The two special Program Flow Program Flow Tune:ee and Program Flow Program Flow Tune:pp modes are expanded to change several settings in one go, but these obey the same ordering rules. Program Flow Program Flow Program Flow Next comes the initialization stage, where all remaining details of the generation are to be specified. There is one standard method to use for this Program Flow Program Flow pythia.init(); Program Flow with no arguments will read all relevant information from the Program Flow Program Flow Settings and Program Flow Program Flow ParticleData databases. Specifically the setup of incoming beams and energies is governed by the the beam parameters from the Program Flow Program Flow Beams group of variables. If you don't change any of those you will default to proton-proton collisions at 14 TeV, i.e. the nominal LHC values. Program Flow Program Flow If you want to have a list of the generator and particle data used, either only what has been changed or everything, you can use Program Flow pythia.settings.listChanged();    pythia.settings.listAll();    pythia.particleData.listChanged();    pythia.particleData.listAll(); Program Flow The event loop Program Flow Program Flow Inside the event generation loop you generate the next event using the Program Flow next() method, Program Flow pythia.next(); This method takes no arguments; everything has already been specified. It does return a bool value, however, Program Flow false when the generation failed. This can be a 'programmed death' when the supply of input parton-level configurations on file is exhausted. It can alternatively signal a failure of Program Flow Pythia to generate an event, or unphysical features in the event record at the end of the generation step. It makes sense to allow a few Program Flow false values before a run is aborted, so long as the related faulty events are skipped. Program Flow Program Flow The generated event is now stored in the Program Flow event object, of type Program Flow Program Flow Event , which is a public member of Program Flow pythia. You therefore have access to all the tools described on the pages under the 'Study Output' header in the index. For instance, an event can be listed with Program Flow pythia.event.list() , the identity of the Program Flow i 'th Program Flow particle is given by Program Flow pythia.event[i].id() , and so on. Program Flow The hard process - roughly the information normally stored in the Les Houches Accord event record - is available as a second object, Program Flow process , also of type Program Flow Event. Program Flow A third useful public object is Program Flow Program Flow info , which offers a set of one-of-a kind pieces of information about the most recent event. Program Flow Finishing Program Flow Program Flow At the end of the generation process, you can call Program Flow pythia.stat(); to get some run statistics, on cross sections and the number of errors and warnings encountered. Program Flow Advanced usage, mainly for initialization A) Necessary data are automatically loaded when you use the default PYTHIA installation directory structure and run the main programs in the Program Flow examples subdirectory. However, in the general case, you must provide the path of the Program Flow xmldoc directory, where default settings and particle data are found. This can be done in several ways. Program Flow Program Flow You can set the environment variable Program Flow PYTHIA8DATA to contain the location of the Program Flow xmldoc directory. In the Program Flow csh and Program Flow tcsh shells this could e.g. be Program Flow setenv PYTHIA8DATA /home/myname/pythia82xx/share/Pythia8/xmldoc while in other shells it could be Program Flow export PYTHIA8DATA=/home/myname/pythia82xx/share/Pythia8/xmldoc where xx is the subversion number. Program Flow Recall that environment variables set locally are only defined in the current instance of the shell. The above lines should go into your Program Flow .cshrc and Program Flow .bashrc files, respectively, if you want a more permanent assignment. Program Flow Program Flow You can provide the path as argument to the Program Flow Pythia constructor, e.g. Program Flow Pythia pythia('/home/myname/pythia82xx/share/Pythia8/xmldoc'); where again xx is the subversion number. Program Flow When Program Flow PYTHIA8DATA is set it takes precedence, else the path in the constructor is used, else one defaults to the Program Flow ../share/Pythia8/xmldoc directory. Program Flow You can provide references to existing Settings and ParticleData (useful if several identical copies of Pythia8 are constructed): Program Flow Pythia(Settings& settingsIn, ParticleData& particleDataIn); Program Flow You can take input from streams of Settings and ParticleData information (which requires the user to create the streams with the appropriate information): Program Flow Pythia(istream& settingsStrings, istream& particleDataStrings); Program Flow B) You can override the default behaviour of PYTHIA not only by the settings and particle data, but also by replacing some of the PYTHIA standard routines by ones of your own. Of course, this is only possible if your routines fit into the general PYTHIA framework. Therefore they must be coded according to the the rules relevant in each case, as a derived class of a PYTHIA base class, and a pointer to such an object must be handed in by one of the methods below. These calls must be made before the Program Flow pythia.init() call. Program Flow Program Flow If you are not satisfied with the list of parton density functions that are implemented internally or available via the LHAPDF interface (see the Program Flow PDF Selection page), you can supply your own by a call to the Program Flow setPDFPtr(...) method Program Flow pythia.setPDFptr( pdfAPtr, pdfBPtr); where Program Flow pdfAPtr and Program Flow pdfBPtr are pointers to two Program Flow Pythia Program Flow PDF objects. Note that Program Flow pdfAPtr and Program Flow pdfBPtr cannot point to the same object; even if the PDF set is the same, two copies are needed to keep track of two separate sets of Program Flow x and density values. Program Flow If you further wish to use separate PDF's for the hard process of an event than the ones being used for everything else, the extended form Program Flow pythia.setPDFptr( pdfAPtr, pdfBPtr, pdfHardAPtr, pdfHardBPtr); allows you to specify those separately, and then the first two sets would only be used for the showers and for multiparton interactions. Program Flow There is a further method to set photon fluxes in a similar spirit. Program Flow Program Flow If you want to link to an external generator that feeds in events in the LHA format, you can call the Program Flow setLHAupPtr(...) method Program Flow pythia.setLHAupPtr( lhaUpPtr); where the Program Flow lhaUpPtr derives from the Program Flow LHAup base class. Program Flow Program Flow If you want to perform some particle decays with an external generator, you can call the Program Flow setDecayPtr(...) method Program Flow pythia.setDecayPtr( decayHandlePtr, particles); where the Program Flow decayHandlePtr derives from the Program Flow Program Flow DecayHandler base class and Program Flow particles is a vector of particle codes to be handled. Program Flow Program Flow If you want to use an external random number generator, you can call the Program Flow setRndmEnginePtr(...) method Program Flow pythia.setRndmEnginePtr( rndmEnginePtr); where Program Flow rndmEnginePtr derives from the Program Flow Program Flow RndmEngine base class. The Program Flow Pythia default random number generator is perfectly good, so this is only intended for consistency in bigger frameworks. Program Flow Program Flow If you want to interrupt the evolution at various stages, to interrogate the event and possibly veto it, or you want to reweight the cross section, you can use Program Flow pythia.setUserHooksPtr( userHooksPtr); where Program Flow userHooksPtr derives from the Program Flow Program Flow UserHooks base class. Program Flow Program Flow If you want to use your own merging scale definition for matrix element + parton shower merging, you can call Program Flow pythia.setMergingHooksPtr( mergingHooksPtr); where Program Flow mergingHooksPtr derives from the Program Flow Program Flow MergingHooks base class. Program Flow Program Flow If you want to use your own parametrization of beam momentum spread and interaction vertex, rather than the provided simple Gaussian parametrization (off by default), you can call Program Flow pythia.setBeamShapePtr( beamShapePtr); where Program Flow beamShapePtr derives from the Program Flow Program Flow BeamShape base class. Program Flow Program Flow If you want to implement a cross section of your own, you can use Program Flow pythia.setSigmaPtr( sigmaPtr ); or, optionally, Program Flow pythia.setSigmaPtr( sigmaPtr, phaseSpacePtr ); where Program Flow sigmaPtr is of type Program Flow SigmaProcess* and Program Flow phaseSpacePtr is of type Program Flow PhaseSpace*. When only the cross-section expression is provided, the built-in phase-space selection machinery will be used. Then Program Flow sigmaPtr must be an instance of a class derived from one of the Program Flow Sigma1Process , Program Flow Sigma2Process and Program Flow Sigma3Process classes for 1-, 2- and 3- particle production, in their turn derived from Program Flow Program Flow SigmaProcess. When you supply your own phase-space generator there is no fundamental limit on the complexity of the process. This call can be used repeatedly to hand in several different processes, mixing ones with and ones without their own phase-space generators. Program Flow Program Flow If your cross section contains the production of a new resonance with known analytical expression for all the relevant partial widths, you can make this resonance available to the program with Program Flow pythia.setResonancePtr( resonancePtr); where Program Flow resonancePtr of type Program Flow ResonanceWidths* is an instance of a class derived from the Program Flow Program Flow ResonanceWidths base class. In addition you need to add the particle to the normal Program Flow particle and decay database. This procedure can be used repeatedly to hand in several different resonances. Program Flow Program Flow If you are a real expert and want to Program Flow replace the PYTHIA initial- and final-state showers , you can use Program Flow pythia.setShowerPtr( timesDecPtr, timesPtr, spacePtr); where Program Flow timesDecPtr and Program Flow timesPtr derive from the Program Flow TimeShower base class, and Program Flow spacePtr from Program Flow SpaceShower. Program Flow Program Flow With even bigger expertise you can plug in your own Program Flow Heavy Ions generator, to replace the default Angantyr one, with Program Flow pythia.setHeavyIonsPtr( heavyIonsPtr); Maybe more useful is the possibility to get back a pointer to the generator used, e.g. to probe various quantities that are not available with the normal Pythia methods: Program Flow pythia.getHeavyIonsPtr(); Program Flow C) Some comments on collecting several tasks in the same run. Program Flow Program Flow PYTHIA has not been written for threadsafe execution on multicore processors. If you want to use all cores, the most efficient way presumably is to start correspondingly many jobs, with different random number seeds, and add the statistics at the end. However, note that several instances  can be set up in the same main program, since instances are completely independent of each other, so each instance could be run inside a separate thread. Program Flow Program Flow In some cases it is convenient to use more than one Program Flow Pythia object. The key example would be the simultaneous generation of signal and pileup events, see Program Flow main19.cc. The two objects are then set up and initialized separately, and generate events completely independently of each other. It is only afterwards that the event records are combined into one single super-event per beam crossing. Program Flow Program Flow When time is not an issue, it may be that you want to perform several separate subruns sequentially inside a run, e.g. to combine results for several kinematical regions or to compare results for some different tunes of the underlying event. One way to go is to create (and destroy) one Program Flow pythia object for each subrun, in which case they are completely separate. You can also use the same Program Flow pythia object, only doing a new Program Flow init() call for each subrun. In that case, the settings and particle databases remain as they were in the previous subrun, only affected by the specific changes you introduced in the meantime. You can put those changes in the main program, with Program Flow pythia.readString(string) , using your own logic to decide which ones to execute in which subrun. A corresponding possibility exists with Program Flow pythia.readFile(fileName, subrun) (or an Program Flow istream instead of a Program Flow fileName ), which as second argument can take a non-negative subrun number. Then only those sections of the file before any Program Flow Main:subrun = ... line or with matching Program Flow subrun number will be read. That is, the file could have a structure like Program Flow ( lines always read, i.e. 'default values' always (re)set )    Main:subrun = 1    ( lines only read with readFile(fileName, 1) )    Main:subrun = 2    ( lines only read with readFile(fileName, 2) ) Both of these possibilities are illustrated in Program Flow main08.cc. Program Flow Program Flow When working with Les Houches Event Files, it may well be that your intended input event sample is spread over several files, that you all want to turn into complete events in one and the same run. There is no problem with looping over several subruns, where each new subrun is initialized with a new file, with name set in Program Flow Beams:LHEF. However, in that case you will do a complete re-initialization each time around. If you want to avoid this, note that the flag Program Flow Beams:newLHEFsameInit = true can be set for the second and subsequent subruns. Then the new file will be simulated with the same initialization data as already set in a previous Program Flow pythia.init() call. The burden rests on you to ensure that this is indeed correct, e.g. that the two event samples have not been generated for different beam energies. Also note that cross sections for processes will be based on the information in the first-read file, when the full initialization is performed. Program Flow Program Flow Program Flow The Pythia class methods and members Here follows the complete survey of all public Program Flow Pythia methods and data members. Program Flow Constructors and destructor Program Flow Set up run Program Flow Initialize At the initialization stage all the information provided above is processed, and the stage is set up for the subsequent generation of events. Currently only one Program Flow init method is available for this stage. Program Flow Generate events The Program Flow next() method is the main one to generate events. In this section we also put a few other specialized methods that may be useful in some circumstances. Program Flow Finalize There is no required finalization step; you can stop generating events when and how you want. It is still recommended that you make it a routine to call the following method at the end. A second method provides a deprecated alternative. Program Flow Interrogate settings Normally settings are used in the setup and initialization stages to determine the character of a run, e.g. read from a file with the above-described Program Flow Pythia::readFile(...) method. There is no strict need for a user to interact with the Program Flow Settings database in any other way. However, as an option, some settings variables have been left free for the user to set in such a file, and then use in the main program to directly affect the performance of that program, see Program Flow here. A typical example would be the number of events to generate. For such applications the following shortcuts to some Program Flow Settings methods may be convenient. Program Flow Get a PDF set Program Flow Pythia contains an number of parton density sets internally, plus an interface to LHAPDF (5 or 6). With the method below, this machinery is also made available for external usage. Program Flow Data members The Program Flow Pythia class contains a few public data members, several of which play a central role. We list them here, with links to the places where they are further described."},{"name":"Python Interface","link":"PythonInterface.html","text":"Python Interface Python Interface Python Interface Python Interface Python is a powerful, high-level interpreted language that is widely used within the particle physics community. It is particularly useful as an interactive language that provides fast proto-typing of code. A Python interface to PYTHIA is available. This interface is automatically generated with Python Interface Binder using the Python Interface PyBind11 template library. Please note that this interface has not been extensively tested and consequently issues may arise. If bugs are found or additional features are required, as usual, please report them to the PYTHIA authors. This interface is a significant departure from the previous interface generated with SWIG, which does not support C++11. Python Interface A simplified interface ships with PYTHIA, which is intended to meet the needs of most users while remaining lightweight. Note, not all PYTHIA classes are available through this interface. It is also possible for users to automatically generate their own interface. This is particularly useful if users modify the PYTHIA source code and need to update the interface. When generating the interface there are three options: the simplified interface, a full interface, and a user defined interface. The process of generating these interfaces is described in more detail below. Python Interface Simplified Interface An attempt has been made to provide the everyday functionality of PYTHIA through the simplified interface. However, if classes or methods appear to be missing, please contact the PYTHIA authors; additional functionality can be included upon request. The following list highlights the available classes and methods in this interface, roughly categorized by function. Note that Python Interface help(pythia8) will return all the available classes and methods in the interface. Python Interface Python Interface top level: Python Interface Pythia Python Interface event access: Python Interface Event , Python Interface Particle , Python Interface Vec4 , Python Interface RotBstMatrix Python Interface particle data: Python Interface ParticleData , Python Interface ParticleDataEntry , Python Interface DecayChannel Python Interface settings and information: Python Interface Info , Python Interface Settings , Python Interface Flag , Python Interface Mode , Python Interface Parm , Python Interface Word , Python Interface FVec , Python Interface MVec , Python Interface PVec , Python Interface WVec Python Interface user interface pointers: Python Interface Rndm , Python Interface PDF , Python Interface DecayHandler , Python Interface RndmEngine , Python Interface UserHooks , Python Interface MergingHooks , Python Interface BeamShape , Python Interface SigmaProcess , Python Interface TimeShower , Python Interface SpaceShower , Python Interface HeavyIons , Python Interface PartonVertex Python Interface analysis tools: Python Interface Hist , Python Interface HistPlot , Python Interface SlowJet , Python Interface SlowJetHook Python Interface kinematic functions: Python Interface m , Python Interface m2 , Python Interface dot3 , Python Interface cross3 , Python Interface cross4 , Python Interface theta , Python Interface costheta , Python Interface phi , Python Interface cosphi , Python Interface RRapPhi , Python Interface REtaPhi The following points highlight some of the features of the interface. Python Interface Python Interface Documentation through the built-in help function in Python provides the relevant mappings between the Python interface and the C++ code. For documentation on the purpose of the code, see the user HTML manual and Doxygen Python Interface Templated C++ types are returned as native Python types, e.g. vectors are returned as lists, etc. Similarly, native Python types can be passed as arguments and are converted to their equivalent C++ templates Python Interface No difference is made between passing by reference or pointer; methods in C++ which take a pointer as an argument in Python simply take the object, e.g. Python Interface foo(Vec4*) and Python Interface foo(Vec4&amp;) are the same in the Python interface. Python Interface All operators defined in C++, e.g. Python Interface Vec4*double are available. Note that reverse operators are not, e.g. Python Interface double*Vec4. Python Interface Classes with defined Python Interface [] operators are iterable, using standard Python iteration, e.g. Python Interface for prt in pythia.event. Python Interface Classes with a Python Interface << operator can be printed via the built-in print function in Python. Note this means that a string representation via Python Interface str is also available for these classes in Python. Python Interface Derived classes in Python can be passed back to PYTHIA, and should be available for all classes. See Python Interface main10.py for a direct Python translation of the C++ Python Interface main10.cc example which uses a derived class from the UserHooks class to veto events. Python Interface The constant Python Interface Pythia::info member is available as Python Interface Pythia::infoPython. Note, this creates a new instance of the Python Interface Info class, and so needs to be called each time the information might be updated. Python Interface Limitations In general, most code using PYTHIA implemented through C++ is also possible in the Python interface. There are a number of issues, such as passing streams, which cannot be handled in the Python interface. Additionally, protected members of classes are exposed as fully public members in the Python interface. Python Interface Installation To install the Python interface, the Python system header Python Interface Python.h must be available. By default when configuring using Python Interface --with-python the system Python Interface python-config script will be used to determine the location of Python Interface Python.h. In some cases, users might wish to use a different version of Python, and so Python Interface --with-python-config can be used to set the Python configuration script used to pick up paths. Alternatively, the directory containing Python Interface Python.h can be set manually with the option Python Interface --with-python-include. Some example configurations could be as follows, Python Interface ./configure --with-python    ./configure --with-python-config=python3-config    ./configure --with-python-include=/usr/include/python2.7 where the Python configuration script and path must be changed accordingly for the local system. Python Interface After configuring the Python interface for PYTHIA to be built and running Python Interface make as usual, the following files should be generated in the directory Python Interface lib. Python Interface Python Interface Python Interface pythia8.so : compiled Python module. Python Interface Python Interface libpythia8.[so,dylib] : the standard shared PYTHIA library. Python Interface To ensure that the Python Interface pythia8.so module is available to Python, the system variable Python Interface PYTHONPATH should be set similar to Python Interface export PYTHONPATH=$(PREFIX_LIB):$PYTHONPATH where Python Interface PREFIX_LIB is the directory Python Interface lib which contains Python Interface pythia8.so. Generally, the library paths should be set correctly, but it also may be necessary to set Python Interface export LD_LIBRARY_PATH=$(PREFIX_LIB):$LD_LIBRARY_PATH where Python Interface DYLD should be substituted for Python Interface LD in OS X. Alternatively, it is also possible to define the Python path from within Python, as is done within the provided examples. Note that the Python module is always compiled as Python Interface pythia8.so , even in OS X. This is because older versions of Python in OS X do not correctly recognize modules ending with the Python Interface dylib suffix. Python Interface Examples To use the Python interface for PYTHIA, start Python and Python Interface import pythia8. The provided examples can be run by Python Interface python mainXX.py where Python Interface XX is the number of the example. Python Interface Interface Generation A script for automatically generating the Python interface, Python Interface generate , is available in Python Interface plugins/python/ and should be run from this directory. This script requires that the user has Docker installed. A small Docker image of roughly 80 MB will be pulled to run the necessary generation code. There are a number of command line arguments which can be passed. Python Interface Python Interface Python Interface --help prints the help message for the script. Python Interface Python Interface --part generates the simplified interface. When Python Interface generate is run without arguments, then this is the default behaviour. Note that this requires running the interface generation twice. The first time the required classes are interfaced, the second time additional classes are removed. Python Interface Python Interface --full generates the full interface. Python Interface Python Interface --user=FILE generates a user defined interface using the Binder configuration given by Python Interface FILE. Python Interface Python Interface --debug can be specified with any of the options above and stops the temporary files used in generation from being removed. Whenever PYTHIA headers are modified, the Python interface is invalidated, and so this automatic generation is particularly useful in such a situation. An example of generating the full Python interface is as follows. Python Interface cd plugins/python    ./generate --full"},{"name":"QCD Processes","link":"QCDSoftProcesses.html","text":"QCD Processes QCD Processes Soft QCD Processes As a rule, the processes in this class should not be mixed with the simulation of other processes. All by themselves, they are intended to represent the total cross section of hadron collisions, with the exception of the 'rare processes' that one wishes to study separately. In particular, jet physics at all scales occurs as part of the minimum-bias description. Note, therefore, that there is a considerable amount of overlap between the soft and hard QCD process classes, so that you are likely to double-count if you include both in a run. QCD Processes We here use the 'minimum bias' expression as a shorthand for inelastic, nondiffractive events. Strictly speaking, 'minimum bias' represents an experimental procedure of accepting 'everything', with some non-universal cuts to exclude elastic and diffractive topologies. In practice, the experimental minimum-bias sample may then contain some contamination of what is in PYTHIA classified as diffractive, especially (high-mass) double diffractive. QCD Processes Some options to modify these cross sections are found on the QCD Processes Total Cross Sections page. QCD Processes QCD Processes Hard QCD Processes This group contains the processes for QCD jet production above some minimum QCD Processes pT threshold, with open charm and bottom production set aside as a special part, and three-jet topologies as a special subset. The QCD Processes pT_min cut cannot be put too low, or else unreasonably large jet cross sections will be obtained. This is because the divergent perturbative QCD cross section is used in this process group, without any regularization modifications. An eikonalized description, intended to be valid at all QCD Processes pT , is instead included as part of the multiparton-interactions framework, specifically in QCD Processes SoftQCD:nonDiffractive , see the manual section on QCD Processes Soft QCD Processes. QCD Processes Warning 1 : you QCD Processes must remember to set the QCD Processes PhaseSpace:pTHatMin value if you use any of these processes; there is no sensible default. QCD Processes Warning 2 : you QCD Processes must not mix processes from the QCD Processes SoftQCD and QCD Processes HardQCD process groups, since this is likely to lead to double-counting. QCD Processes Light Quarks and Gluons QCD Processes Heavy Flavours These processes form a natural part of the above class, but can also be generated separately. Formally the heavy-quark mass makes these matrix elements finite in the QCD Processes pT &rarr; 0 limit, but at high energies one may still question the validity of the expressions at low QCD Processes pT values, like for the other hard-QCD processes. Also as above, an eikonalized description, intended to be valid at all QCD Processes pT , is included as part of the multiparton-interactions framework. QCD Processes Note that the processes below only represent the 'tip of the iceberg' of charm and bottom production at high energies, where flavour excitation and shower branchings provide major additional sources. All these sources come together in the descriptions offered by QCD Processes SoftQCD:nonDiffractive and QCD Processes HardQCD:all. QCD Processes Three-parton processes Three-parton final states are generated by showers off two-parton processes. Topologies then cannot be specified beforehand, beyond what is provided by the two-parton hard process. For some checks it may be convenient to have access to the dedicated three-parton final states, which is what this set of processes allows. Cross sections have been taken from QCD Processes Ber81. QCD Processes Note that the processes in this section are QCD Processes not affected by the QCD Processes HardQCD:all switch. In fact, it would be double-counting to include both the QCD Processes HardQCD:all and the QCD Processes HardQCD:3parton processes in a run or study. QCD Processes QCD Processes Warning: this section is still incomplete, e.g. the selection of colour flow is very simple, and so it should only be used with caution."},{"name":"R-hadrons","link":"RHadrons.html","text":"R-hadrons R-hadrons R-hadrons When a coloured SUSY particle is longer-lived than typical hadronization scales, i.e. around c*tau > 1 fm, or equivalently width Gamma < 0.2 GeV, it will have time to hadronize into a colour singlet hadronic state, a R-hadron. Currently a set of such R-hadrons have been implemented for the case of a long-lived gluino, stop or sbottom. Needless to say, the normal case would be that only one of them will be long-lived enough to form R-hadrons. R-hadrons For simplicity all gluino-mesons are assumed to have light-flavour spin 1, since those are the lightest and favoured by spin-state counting. Further, all gluino-baryons are bookkept as having light-flavour spin 3/2, and flavours are listed in descending order. This is more for convenience of notation, however, since the normal baryon octet e.g. has no uuu = 'p++' state. When a diquark is extracted, a mixture of spin 0 and spin 1 is allowed. Names and codes are essentially in agreement with the PDG conventions, e.g. R-hadrons 1000993 R-hadrons R0(~g g) (or gluinoball) R-hadrons 1009213 R-hadrons R+(~g u dbar) (or gluino-rho+) R-hadrons 1092214 R-hadrons R+(~g uud) (or gluino-Delta+) R-hadrons For internal bookkeeping of momenta, the code 1009002, R-hadrons Rtemp(~g q) , is used to denote the intermediate state formed when only one of the two string pieces attached to the gluino has broken. R-hadrons For the stop- and sbottom-hadrons the spin counting is simpler, since it is entirely given by the constituent quark or diquark spin. Again names and codes follow PDG conventions, e.g. R-hadrons 1000612 R-hadrons R+(~t dbar) R-hadrons 1006211 R-hadrons R+(~t ud0) R-hadrons The spin and electromagnetic charge of the new particle plays only a minor role in the hadronization process, that can be neglected to first approximation. Therefore it is possible to use the same R-hadrons framework instead for other BSM scenarios with long-lived coloured particles, e.g. with massive extra-dimensions copies of gluons and quarks, or with leptoquarks. This can be regulated by the switches below. Note that the codes and names of the R-hadrons is not changed when the heavy particle involved is switched, for reasons of administrative simplicity. R-hadron mass spectra and other relevant particle data is automatically updated to reflect the change, however."},{"name":"Random Numbers","link":"RandomNumbers.html","text":"Random Numbers Random Numbers Random Numbers This page describes the random-number generator in PYTHIA and how it can be replaced by an external one. Random Numbers Internal random numbers The Random Numbers Rndm class generates random numbers, using the Marsaglia-Zaman-Tsang algorithm Random Numbers Mar90. Random Numbers Random numbers Random Numbers R uniformly distributed in Random Numbers 0 < R < 1 are obtained with Random Numbers Rndm::flat(); There are also methods to generate according to an exponential, to Random Numbers x * exp(-x) , to a Gaussian, or picked among a set of possibilities, which make use of Random Numbers flat(). Random Numbers If the random number generator is not initialized before, it will be so the first time it is asked to generate a random number, and then with the default seed, 19780503. This means that, by default, all runs will use identically the same random number sequence. This is convenient for debugging purposes, but dangerous if you intend to run several 'identical' jobs to boost statistics. You can initialize, or reinitialize, with your own choice of seed with a Random Numbers Rndm::init(seed); Here values Random Numbers 0 < seed < 900 000 000 gives so many different random number sequences, while Random Numbers seed = 0 will call the Random Numbers Stdlib time(0) function to provide a 'random' Random Numbers seed , and Random Numbers seed < 0 will revert back to the default Random Numbers seed. Random Numbers The Random Numbers Pythia class defines Random Numbers a flag and a mode , that allows the Random Numbers seed to be set in the Random Numbers Pythia::init call. That would be the standard way for a user to pick the random number sequence in a run. Random Numbers External random numbers Random Numbers RndmEngine is a base class for the external handling of random-number generation. The user-written derived class is called if a pointer to it has been handed in with the Random Numbers pythia.rndmEnginePtr() method. Since the default Marsaglia-Zaman-Tsang algorithm is quite good, chances are that any replacement would be a step down, but this may still be required by consistency with other program elements in big experimental frameworks. Random Numbers There is only one pure virtual method in Random Numbers RndmEngine , to generate one random number flat in the range between 0 and 1: Random Numbers virtual double flat() = 0; Note that methods for initialization are not provided in the base class, in part since input parameters may be specific to the generator used, in part since initialization can as well be taken care of externally to the Random Numbers Pythia code. Random Numbers An example illustrating how to run with an external random number generator is provided in Random Numbers main23.cc. Random Numbers MIXMAX random numbers The MIXMAX class of random number generators utilizes matrix-recursion based on Anosov-Kolmogorov C-K systems, with the ability to create a large number of statistically independent sequences of random numbers based on different initial seeds. This is particularly advantageous in creating statistically independent samples when running a large number of parallel jobs, each with a different initial seed. In the plugin header Random Numbers Pythia8Plugins/MixMax.h an implementation of a MIXMAX random number generator is provided Random Numbers Sav91,Sav15 , courtesy of Konstantin Savvidy, as well as a PYTHIA interface through the Random Numbers MixMaxRndm class.  In this implementation a dimensionality of 17 is used, as this has been found to provide faster access to large numbers of independent sequences. A timing comparison between the external MIXMAX random number generator, and the default internal PYTHIA random number generator is provided in the example Random Numbers main23.cc. The MIXMAX random number generator is found to be comparable in speed to the default generator. The primary methods of the Random Numbers MixMaxRndm class are given here. Random Numbers The methods We here collect a more complete and formal overview of the Random Numbers Rndm class methods."},{"name":"Random-Number Seed","link":"RandomNumberSeed.html","text":"Random-Number Seed Random-Number Seed Random-Number Seed The seed of the random number generator can be set as follows: Random-Number Seed For more on random numbers see Random-Number Seed here. This includes methods to save and restore the state of the generator, and some preprogrammed methods to generate non-uniform random numbers."},{"name":"Resonance Decays","link":"ResonanceDecays.html","text":"Resonance Decays Resonance Decays Resonance Decays The Resonance Decays ResonanceDecays class performs the sequential decays of all resonances formed in the hard process. Note the important distinction between 'resonances' and other 'particles' made in PYTHIA. Resonance Decays Resonance Decays The list of resonances contains Resonance Decays gamma^*/Z^0 , Resonance Decays W^+- , top, the Higgs, and essentially all new particles of Beyond-the-Standard-Model physics: further Higgs bosons, sfermions, gauginos, techniparticles, and so on. The partial widths to different decay channels are perturbatively calculable, given the parameters of the respective model, and branching ratios may be allowed to vary across a (reasonably broad) resonance peak. Usually resonances are short-lived, and therefore it makes sense to consider their decays immediately after the primary hard process has been set up. Furthermore, in several cases the decay angular distributions are encoded as part of the specific process, e.g. the Resonance Decays W decays differently in Resonance Decays f fbar &rarr; W^+- , Resonance Decays f fbar &rarr; W^+ W^- and Resonance Decays h^0 &rarr; W^+ W^-. All of these particles are (in PYTHIA) only produced as part of the hard process itself, i.e. they are not produced in showers or hadronization processes. Therefore the restriction to specific decay channels can be consistently taken into account as a corresponding reduction in the cross section of a process. Finally, note that all of these resonances have an on-shell mass above 20 GeV, with the exception of some hypothetical weakly interacting and stable particles such as the gravitino. Resonance Decays The other particles include normal hadrons and the Standard-Model leptons, including the Resonance Decays tau^+-. These can be produced in the normal hadronization and decay description, which involve unknown nonperturbative parameters and multistep chains that cannot be predicted beforehand: a hard process like Resonance Decays g g &rarr; g g can develop a shower with a Resonance Decays g &rarr; b bbar branching, where the Resonance Decays b hadronizes to a Resonance Decays B^0bar that oscillates to a Resonance Decays B^0 that decays to a Resonance Decays tau^+. Therefore any change of branching ratios - most of which are determined from data rather than from first principles anyway - will not be taken into account in the cross section of a process. Exceptions exist, but most particles in this class are made to decay isotropically. Finally, note that all of these particles have a mass below 20 GeV. There is one ambiguous case in this classification, namely the photon. The Resonance Decays gamma^*/Z^0 combination contains a low-mass peak when produced in a hard process. On the other hand, photons can participate in shower evolution, and therefore a photon originally assumed massless can be assigned an arbitrarily high mass when it is allowed to branch into a fermion pair. In some cases this could lead to double-counting, e.g. between processes such as Resonance Decays f fbar &rarr; (gamma^*/Z^0) (gamma^*/Z^0) , Resonance Decays f fbar &rarr; (gamma^*/Z^0) gamma and Resonance Decays f fbar &rarr; gamma gamma. Here it make sense to limit the lower mass allowed for the Resonance Decays gamma^*/Z^0 combination, in Resonance Decays 23:mMin , to be the same as the upper limit allowed for an off-shell photon in the shower evolution, in Resonance Decays TimeShower:mMaxGamma. By default this matching is done at 10 GeV. Resonance Decays In spite of the above-mentioned differences, the resonances and the other particles are all stored in one common Resonance Decays particle data table , so as to offer a uniform interface to Resonance Decays setting and getting properties such as name, mass, charge and decay modes, also for the Resonance Decays particle properties in the event record. Some methods are specific to resonances, however, in particular for the calculation of partial widths and thereby of branching ratio. For resonances these can be calculated dynamically, set up at initialization for the nominal mass and then updated to the current mass when these are picked according to a Breit-Wigner resonance shape. Resonance Decays Resonance Decays and Cross Sections As already hinted above, you have the possibility to set the allowed decay channels of resonances, see Resonance Decays Particle Data Scheme description. For instance, if you study the process Resonance Decays q qbar &rarr; H^0 Z^0 you could specify that the Resonance Decays Z^0 should decay only to lepton pairs, the Resonance Decays H^0 only to Resonance Decays W^+ W^- , the Resonance Decays W^+ only to a muon and a neutrino, while the Resonance Decays W^- can decay to anything. Unfortunately there are limits to the flexibility: you cannot set a resonance to have different properties in different places of a process, e.g. if instead Resonance Decays H^0 &rarr; Z^0 Z^0 in the above process then the three Resonance Decays Z^0 's would all obey the same rules. Resonance Decays The restrictions on the allowed final states of a process is directly reflected in the cross section of it. That is, if some final states are excluded then the cross section is reduced accordingly. Such restrictions are built up recursively in cases of sequential decay chains. The restrictions are also reflected in the compositions of those events that actually do get to be generated. For instance, the relative rates of Resonance Decays H^0 &rarr; W^+ W^- and Resonance Decays H^0 &rarr; Z^0 Z^0 are shifted when the allowed sets of Resonance Decays W^+- and Resonance Decays Z^0 decay channels are changed. Resonance Decays We remind that only those particles that Pythia treat as resonances enjoy this property, and only those that are considered as part of the hard process and its associated resonance decays. Resonance Decays There is one key restriction on resonances: Resonance Decays In spite of this technical parameter choice, it is possible to set a lifetime for a resonance, and thereby to obtain displaced vertices. If a resonance is allowed to decay it will do so, irrespective of the location of the decay vertex. This is unlike Resonance Decays normal particle decays , where it is possible to define some region around the primary vertex within which all decays should happen, with particles leaving that region considered stable. The logic is that resonances as a rule are too short-lived for secondary vertices, so if you pick a scenario with a long-lived but unstable resonance it is because you Resonance Decays want to study secondary vertices. How to interface those decays to a detector simulation program then is another story, to be solved separately. Do note that a special treatment is needed for coloured long-lived resonances, that form Resonance Decays R-hadrons , and where charge and flavour may change between the production and decay vertices. Resonance Decays Special properties and methods for resonances The method Resonance Decays ParticleData::isResonance(id) allows you to query whether a given particle species is considered a resonance or not. You can also change the default value of this flag in the normal way, e.g. Resonance Decays pythia.readString('id:isResonance = true'). Resonance Decays Resonances come in two kinds. Resonance Decays Resonance Decays The standard built-in ones include Resonance Decays Z^0 , Resonance Decays W^+- , Resonance Decays t , Resonance Decays h^0 , and many more. These have explicit decay-widths formulae encoded, in classes derived from the Resonance Decays Resonance Decays ResonanceWidths base class. The formulae are used, e.g., to calculate all the partial widths as a function of the resonance masses you choose, and at initialization the existing total width values are overwritten. This is especially convenient for hypothetical states, like a Resonance Decays Z' , where the mass is not known and therefore routinely changed. Often the partial widths are associated with parameters that can be changed by the user, e.g. for MSSM Higgs states. Resonance Decays If a resonance does not have a class of its own, with hardcoded equations for all relevant partial widths, then a simpler object will be created at initialization. This object will take the total width and branching ratios as is (with the optional variations explained in the next section). When you set a particle to be a resonance, and do not provide any class to go with its width calculations, this is where it will end up. Sometimes experimentalists want to modify the physical width of a resonance, to understand how sensitive analyses are to this width, if at all. For the second, simpler kind of resonances, the Resonance Decays id:mWidth can be changed right away, but for the first kind any change will be overwritten at initialization. To circumvent this problem, the Resonance Decays id:doForceWidth flag can be changed from the default Resonance Decays off to Resonance Decays on. Then the width stored in Resonance Decays id:mWidth is strictly used to describe the Breit-Wigner of the resonance. Partial widths are still recalculated to set the mass-dependent branching ratios, but then uniformly rescaled to the requested total width. The width can also run across the lineshape, so that it deviates from the nominal one in the wings of the Breit-Wigner. Resonance Decays For processes that contain interference terms between resonances, notably Resonance Decays gamma^*/Z^0 or Resonance Decays gamma^*/Z^0/Z'^0 , it is not obvious how these contributions should be modified consistently. Therefore it is necessary to set Resonance Decays WeakZ0:gmZmode = 2 or Resonance Decays Zprime:gmZmode = 3 , to have a pure Resonance Decays Z^0 or Resonance Decays Z'^0 , respectively, for width forcing to be allowed in these cases. Resonance Decays A warning is that the different processes have cross sections that rescale in different ways when the resonance width is varied. This depends on them not having been implemented in a guaranteed uniform way. To illustrate the point, consider the case of an Resonance Decays s -channel resonance, where the cross section dependence on the width can be written as Resonance Decays sigmaHat(sHat) = constant * Gamma_in * Gamma_out / ((sHat - m^2)^2 + m^2 * Gamma^2) Here the Resonance Decays doForceWidth = on option ensures that the Resonance Decays Gamma in the denominator is rescaled by some factor Resonance Decays k relative to the natural width, but does not guarantee that Resonance Decays Gamma_in and Resonance Decays Gamma_out are rescaled as well. If all three are rescaled by the same factor Resonance Decays k , as they should, then the integrated cross section also scales like Resonance Decays k , assuming that the peak is reasonably narrow, so that the variation of PDF's across the Breit-Wigner can be neglected. This is the case for some processes. But in others either or both of the production and decay vertices can have been hardcoded, based on the coupling structure, and thus not scale with Resonance Decays k. If only Resonance Decays Gamma_out scales with Resonance Decays k , say,  the cross section remains (approximately) constant, and if neither scales the cross section will even go like Resonance Decays 1/k. Such obvious normalization imperfections have to be corrected by hand. Resonance Decays Mainly for internal usage, the Resonance Decays Resonance Decays ParticleData contain some special methods that are only meaningful for resonances: Resonance Decays Resonance Decays Resonance Decays resInit(...) to initialize a resonance, possibly including a recalculation of the nominal width to match the nominal mass; Resonance Decays Resonance Decays resWidth(...) to calculate the partial and total widths at the currently selected mass; Resonance Decays Resonance Decays resWidthOpen(...) to calculate the partial and total widths of those channels left open by user switches, at the currently selected mass; Resonance Decays Resonance Decays resWidthStore(...) to calculate the partial and total widths of those channels left open by user switches, at the currently selected mass, and store those as input for a subsequent selection of decay channel; Resonance Decays Resonance Decays resOpenFrac(...) to return the fraction of the total width that is open by the decay channel selection made by users (based on the choice of Resonance Decays Resonance Decays onMode for the various decay channels, recursively calculated for sequential decays); Resonance Decays Resonance Decays resWidthRescaleFactor(...) returns the factor by which the internally calculated PYTHIA width has to be rescaled to give the user-enforced width; Resonance Decays Resonance Decays resWidthChan(...) to return the width for one particular channel (currently only used for Higgs decays, to obtain instate coupling from outstate width). These methods actually provide an interface to the classes derived from the Resonance Decays ResonanceWidths base class, to describe various resonances. Resonance Decays Modes for Matrix Element Processing The Resonance Decays meMode() value for a decay mode is used to specify Resonance Decays nonisotropic decays or the conversion of a parton list into a set of hadrons in some channels of normal particles. For resonances it can also take a third function, namely to describe how the branching ratios and widths of a resonance should be rescaled as a function of the current mass of the decaying resonance. The rules are especially useful when new channels are added to an existing particle, or a completely new resonance added. Resonance Decays Resonance Decays 0 : channels for which hardcoded partial-width expressions are expected to exist in the derived class of the respective resonance. Should no such code exist then the partial width defaults to zero. Resonance Decays 1 - 99 : same as 0, but normally not used for resonances. Resonance Decays 100 : calculate the partial width of the channel from its stored branching ratio times the stored total width. This value remains unchanged when the resonance fluctuates in mass. Specifically there are no threshold corrections. That is, if the resonance fluctuates down in mass, to below the nominal threshold, it is assumed that one of the daughters could also fluctuate down to keep the channel open. (If not, there may be problems later on.) Resonance Decays 101 : calculate the partial width of the channel from its stored branching ratio times the stored total width. Multiply by a step threshold, i.e. the channel is switched off when the sum of the daughter on-shell masses is above the current mother mass. Resonance Decays 102 : calculate the partial width of the channel from its stored branching ratio times the stored total width. Multiply by a smooth threshold factor Resonance Decays beta = sqrt( (1 - m_1^2/m_2 - m_2^2/m^2)^2 - 4 m_1^2 m_2^2/m^4) for two-body decays and Resonance Decays sqrt(1 - Sum_i m_i / m) for multibody ones. The former correctly encodes the size of the phase space but misses out on any nontrivial matrix-element behaviour, while the latter obviously is a very crude simplification of the correct phase-space expression. Specifically, it is thereby assumed that the stored branching ratio and total width did not take into account such a factor. Resonance Decays 103 : use the same kind of behaviour and threshold factor as for 102 above, but assume that such a threshold factor has been used when the default branching ratio and total width were calculated, so that one should additionally divide by the on-shell threshold factor. Specifically, this will give back the stored branching ratios for on-shell mass, unlike the 102 option. To avoid division by zero, or in general unreasonably big rescaling factors, a lower limit Resonance Decays minThreshold (see below) on the value of the on-shell threshold factor is imposed. (In cases where a big rescaling is intentional, code 102 would be more appropriate.) Resonance Decays All of these Resonance Decays meMode 's may coexist for the same resonance. This would be the case e.g. if you want to add a few new channels to an already existing resonance, where the old partial widths come hardcoded while the new ones are read in from an external file. The typical example would be an MSSM Higgs sector, where partial widths to SM particles are already encoded, Resonance Decays meMode = 0 , while decay rates to sparticles are read in from some external calculation and maybe would be best approximated by using Resonance Decays meMode = 103. Indeed the default particle table in PYTHIA uses 103 for all channels that are expected to be provided by external input. Resonance Decays Some further clarification may be useful. At initialization the existing total width and on-shell branching ratios will be updated. For channels with Resonance Decays meMode < 100 the originally stored branching ratios are irrelevant, since the existing code will anyway be used to calculate the partial widths from scratch. For channels with Resonance Decays meMode = 100 or bigger, instead the stored branching ratio is used together with the originally stored total width to define the correct on-shell partial width. The sum of partial widths then gives the new total width, and from there new branching ratios are defined. Resonance Decays In these operations the original sum of branching ratios need not be normalized to unity. For instance, you may at input have a stored total width of 1 GeV and a sum of branching ratios of 2. After initialization the width will then have been changed to 2 GeV and the sum of branching ratios rescaled to unity. This might happen e.g. if you add a few channels to an existing resonance, without changing the branching ratios of the existing channels or the total width of the resonance. Resonance Decays In order to simulate the Breit-Wigner shape correctly, it is important that all channels that contribute to the total width are included in the above operations. This must be kept separate from the issue of which channels you want to have switched on for a particular study, to be considered next. Resonance Decays In the event-generation process, when an off-shell resonance mass has been selected, the width and branching ratios are re-evaluated for this new mass. At this stage also the effects of restrictions on allowed decay modes are taken into account, as set by the Resonance Decays onMode switch for each separate decay channel. Thus a channel may be on or off, with different choices of open channels between the particle and its antiparticle. In addition, even when a channel is on, the decay may be into another resonance with its selection of allowed channels. It is these kinds of restrictions that lead to the Resonance Decays Gamma_out possibly being smaller than Resonance Decays Gamma_tot.  As a reminder, the Breit-Wigner for decays behaves like Resonance Decays Gamma_out / ((s - m^2)^2 + s * Gamma_tot^2) , where the width in the numerator is only to those channels being studied, but the one in the denominator to all channels of the particle. These ever-changing numbers are not directly visible to the user, but are only stored in a work area."},{"name":"Resources for New Users","link":"GettingStarted.html","text":"Resources for New Users Resources for New Users Resources for New Users Resources for New Users For a new user, getting started using an event generator can be a daunting task.  PYTHIA attemts to describe all parts of high-energy collisions between several species of fundamental and composite particles, and must by definition contain many settings and possibilities, which are not neccesarily interesting or useful to a new user. Resources for New Users PYTHIA therefore ships with several example programs, each highlighting one, or a few, aspects of the framework. All example programs are located in the Resources for New Users examples/ subdirectory, along with instructions on how to be run. Resources for New Users A new user who is already familar with other event generators, might want to start reading through the description of the Resources for New Users Program Flow , and then proceed to browse through the Resources for New Users Example Main Programs , to find the physics aspects the user desires to study. Resources for New Users For completely new users, the separate Resources for New Users PYTHIA 8.2 Worksheet , offers a more suitable practical introduction."},{"name":"RIVET usage","link":"RIVETusage.html","text":"RIVET usage RIVET usage RIVET usage RIVET usage RIVET is a toolkit for the validation of Monte Carlo event generators RIVET usage Buc10. It contains the results of many experimental analyses, so that generator output can easily be compared to data, as well as providing a framework to implement your own analyses.  Although using PYTHIA with RIVET is not officially supported, some helpful hints are given below. The full RIVET manual is available RIVET usage online. RIVET usage RIVET usage RIVET usage Using PYTHIA with RIVET The following assumes that you already have RIVET installed. Instructions for this may be found RIVET usage here. RIVET usage RIVET usage Events are passed from PYTHIA to RIVET using the HepMC format. PYTHIA must be compiled with HepMC support, using the same version of HepMC used when compiling RIVET. This is setup through the PYTHIA RIVET usage configure script e.g. RIVET usage ./configure --with-hepmc=/path/to/HepMC The PYTHIA library itself does not need to be recompiled. RIVET usage RIVET usage The RIVET usage examples/main42.cc sample program can then be used to generate events in HepMC format (which RIVET usage examples/main43.cc extends by allowing subruns). When in the RIVET usage examples directory, the main program can be built and used as follows RIVET usage make main42  ./main42 main42.cmnd main42.hepmc The first argument is the input file which provides the options for event generation, while the second is the output file where the HepMC events should be written. RIVET usage RIVET usage This HepMC file may now be read and processed by RIVET RIVET usage rivet --analysis=ANALYSIS_NAME main42.hepmc where RIVET usage ANALYSIS_NAME is a RIVET usage built-in RIVET analysis , or one you have created yourself. The output of RIVET is in the form of RIVET usage .aida files, containing the histograms for the analysis, which can be processed further with RIVET (see the RIVET usage RIVET documentation for more details). RIVET usage RIVET usage The above examples requires that (potentially large) HepMC events are stored to disk before being read by RIVET. It is possible, instead, to pass the events directly to RIVET as they are produced by using a RIVET usage FIFO pipe. This is done with the RIVET usage mkfifo command RIVET usage mkfifo my_fifo  ./main42.exe main42.cmnd my_fifo &  rivet --analysis=ANALYSIS_NAME my_fifo Note that RIVET usage main42 is run in the background. RIVET usage Compiling PYTHIA with RIVET It is also possible to compile a PYTHIA main program together with the RIVET library. To facilitate this, there is a header file called RIVET usage Pythia8Plugins/Pythia8Rivet.h defining a helper class called RIVET usage Pythia8::Pythia8Rivet. To use this class, a main program needs to be modified as follows: RIVET usage #include 'Pythia8/Pythia.h'   // Include the Pythia8Rivet header file.  #include 'Pythia8Plugins/Pythia8Rivet.h'   int main() {    Pythia pythia;    // Setup the run by reading strings or a command file.    pythia.init();    // Create a Pythia8Rivet object and add (one or several) analyses.    Pythia8Rivet rivet(pythia, 'outputfile.yoda');    rivet.addAnalysis('AnalysisName');    rivet.addAnalysis('AnotherAnalysisName');    for (int iEvent = 0; iEvent < 100; ++iEvent) {     if (!pythia.next()) continue;      // Push event to Rivet.     rivet();      // Maybe do other non-Rivet analysis.    }    // Tell Rivet to finalise the run.    rivet.done();   } To compile the program, information about where Rivet and YODA are installed is needed. Hence the compile flag RIVET usage -I/path/to/rivet/installation/include is needed, as well as the link flag RIVET usage -L/path/to/rivet/installation/lib -lRivet -lYODA. (Further information about how to compile and link Rivet can be found using the RIVET usage rivet-config script distributed with Rivet.) RIVET usage The example program RIVET usage main111.cc includes optional analysis with RIVET usage Pythia8::Pythia8Rivet. To use it, compile the program with the flags above and add RIVET usage -DUSE_PYTHIA8_RIVET. RIVET usage The most common user case (run PYTHIA with a run card, using one or several RIVET analyses) is implemented in the example RIVET usage main93. The sample command file RIVET usage main93.cmnd provides a good starting point. The lines: RIVET usage Main:runRivet = on    Main:analyses = ATLAS_2010_S8817804,ALICE_2010_S8625980,CMS_2011_S8957746    Main:writeHepMC = on provides the switch to run RIVET, and gives the user the possibility to add any number of (installed) RIVET analyses to the run, as a comma separated list. The last line is the switch needed to write a HepMC file.  The example is run with: RIVET usage ./main93 -c main93.cmnd and a .yoda file (the RIVET output) is then written.  There are several other useful command line options to RIVET usage main93. They are all displayed by running RIVET usage ./main93 -h."},{"name":"ROOT usage","link":"ROOTusage.html","text":"ROOT usage ROOT usage ROOT usage Many PYTHIA users wish to use ROOT usage ROOT to produce histograms, or even to run PYTHIA as a plugin to ROOT. This is possible. It is not a task supported by the PYTHIA team, however. All issues involving ROOT usage should be directed to the ROOT team, or to the local support team of your collaboration. Below some helpful hints have been collected. The text is based on contributions by Rene Brun, Andreas Morsch and Axel Naumann. Another example may be found in the ROOT usage VINCIA add-on program for parton showers, but this should also work for a PYTHIA standalone run. ROOT usage ROOT usage Note that in all that follows, a Linux-type system with a Bash shell and GNU Make is assumed. In particular, for Mac OS X, the ROOT usage LD_LIBRARY_PATH should be replaced with ROOT usage DYLD_LIBRARY_PATH and the extension for shared libraries ROOT usage .so should be replaced with ROOT usage .dylib. ROOT usage ROOT usage ROOT usage ROOT usage Standalone usage One can perform the generation and analysis of events in a completely standalone fashion, and only use ROOT to process the completed events. Two example programs are provided in the ROOT usage examples directory, with details provided below.  The examples assume that ROOT is installed, that you have run ROOT usage ./configure --with-root=root-installation-directory where you have to specify which is the ROOT installation directory, and subsequently run ROOT usage make. More fine-grained options are available with ROOT usage configure , if need be. ROOT usage Histogramming with ROOT An example of histogramming with ROOT is provided in ROOT usage examples/main91.cc. It may be compiled and run just like the other example programs. After PYTHIA has run, a ROOT histogram of the charged multiplicity in the events will be shown. This is now stored in the ROOT usage hist.root file. If you can make this example work, the road should be open to do the same for all other histogramming needs. Specifically, you need to edit the ROOT usage examples/Makefile file to add the other programs to link as ROOT usage main91.cc currently does. ROOT usage Storing PYTHIA events in ROOT trees Instead of only generating histograms, it is possible to store entire PYTHIA events in ROOT trees. The ROOT usage examples/main92 code provides an example of this and is comprised of the following files: ROOT usage ROOT usage ROOT usage main92.cc is the main example program showing how  PYTHIA events can be stored in ROOT trees; ROOT usage ROOT usage main92LinkDef.h is used by Makefile to generate the  dictionary for all PYTHIA classes involved in the IO, as needed for  the example; and ROOT usage ROOT usage main92.h is a small include declaring the ROOT usage Pythia8 namespace as default. ROOT usage The example may be compiled and run with as usual. Afterwards, the new ROOT usage pytree.root file will contain the PYTHIA events. Note that files can become quite large when many events are generated. To open these files within the ROOT interpreter the PYTHIA class dictionary must be loaded, ROOT usage .L main92.so. In compiled code, the PYTHIA class dictionary ROOT usage main92.so must be linked against, to either read or write PYTHIA events to a ROOT file. ROOT usage Error notice It appears that ROOTCINT cannot handle the ROOT usage dlfcn.h header in the current ROOT version. If you run into this problem with your ROOT installation, you could try to insert the following lines in your ROOT usage PythiaStdlib.h file: ROOT usage // Stdlib header file for dynamic library loading.   #ifndef __CINT__   #define dlsym __   #include <dlfcn.h>   #undef dlsym   #endif ROOT usage ROOT usage ROOT usage Storing partial PYTHIA events in ROOT trees Instead of storing full PYTHIA events in ROOT trees, a common user case is to store only track information relevant to a particular analysis. The resulting ROOT trees will then be what is often referred to as 'n-tuples'. The advantage of this over the above method is a significant reduction of disk space used, as well as the possibility to construct trees resembling those familiar from the experiments' central MC production.  The ROOT usage examples/main93 example provides this - among other - functionality. As for the above example, it is split up in several files. ROOT usage ROOT usage ROOT usage main93.cc is the main example program; ROOT usage ROOT usage main93.cmnd is a sample input command file; ROOT usage ROOT usage main93LinkDef.h is used by Makefile to generate the  dictionary for only the used PYTHIA classes involved in the IO, for  the example; and ROOT usage ROOT usage main93.h defines a 'track' and an 'event' class where  relevant event -and track information is defined. ROOT usage Compiling the example The ROOT usage main93 example is compatible with ROOT v.6 and above. One should have a working installation of ROOT, and then configure PYTHIA with: ROOT usage ./configure --with-root=root-installation-directory One can then compile ROOT usage main93 with the usual: ROOT usage make main93 provided that all ROOT paths are set correctly by eg. running: ROOT usage source root-installation-directory/bin/thisroot.sh ROOT usage Running the example The ROOT usage main93 example can be run with several command line options. Running: ROOT usage ./main93 -h will display a help text showing these options. To produce events, the user needs to supply a command file with option ROOT usage -c COMMAND-FILE.cmnd. The example command file ROOT usage main93.cmnd is a good starting point. The crucial command to output ROOT trees is to set ROOT usage Main:writeROOT = on.  The ROOT file will be named ROOT usage pythia.root per default. This can be changed by appending ROOT usage -o ONAME on the command line. ROOT usage Changing the event information The header file ROOT usage main93.h defines a simple event class and track class, which in turn defines the information stored to the tree. If a user wants to change this, either by adding more track information or imposing cuts corresponding to detector acceptance (thus reducing the file size), this can be done directly in this header file. Both the track class and the event class has ROOT usage init functions returning a boolean value, and by returning ROOT usage false , the track/event is rejected. The ROOT usage main93 example must be recompiled after making any changes to the header file. ROOT usage ROOT usage ROOT usage ROOT usage PYTHIA as a plugin to ROOT In more ROOT-centric applications, PYTHIA can be run as a ROOT plug-in. This requires a version of ROOT that has been ROOT usage installed from source. The reason is that the interfaces depend on PYTHIA header files that are not distributed with ROOT. Installing ROOT is not more difficult than the PYTHIA installation, and some guidelines are provided below. ROOT usage Installation To be run as a plugin, PYTHIA must be compiled as a shared library. This is achieved by running the PYTHIA ROOT usage configure script with the ROOT usage --enable-shared option before ROOT usage make is run. ROOT usage ROOT usage Define an environment variable for the path to your PYTHIA installation directory ROOT usage export PYTHIA8=path_to_PYTHIA8_installation Before compiling ROOT, ROOT usage configure ROOT by running the ROOT usage configure command including the following options ROOT usage --enable-pythia8    --with-pythia8-incdir=$PYTHIA8/include/Pythia8    --with-pythia8-libdir=$PYTHIA8/lib In case ROOT has already been compiled before, it will only recompile the PYTHIA module and build the library ROOT usage libEGPythia8. ROOT usage Interfaces When running PYTHIA as a plugin, the exact interface structure becomes very relevant. ROOT provides two simple interfaces (wrappers) for PYTHIA 8. The code for these interfaces are located in ROOT usage path_to_ROOT_source/montecarlo/pythia8 ROOT usage The two interfaces are ROOT usage ROOT usage ROOT usage ROOT usage TPythia8 is an implementation of the ROOT usage ROOT usage TGenerator interface for PYTHIA 8. ROOT usage It allows you to use PYTHIA within a ROOT macro or as a plug-in  for a general-purpose particle generator based on this interface. The  main methods of the interface are ROOT usage ROOT usage ROOT usage GenerateEvent() which triggers the    generation of the next event, and ROOT usage ROOT usage ImportParticles(TClonesArray* particles) which copies the native PYTHIA stack into a ROOT usage ROOT usage TClonesArray of ROOT usage ROOT usage TParticles. In addition, some methods that are directly related to corresponding  PYTHIA methods are implemented ROOT usage ROOT usage ROOT usage ReadString(const char* string) &rarr; ROOT usage readString(...) ROOT usage ROOT usage ReadConfigFile(const char* string) &rarr; ROOT usage readFile(...) ROOT usage ROOT usage Initialize(int idAin, int idBin, double ecms) &rarr; ROOT usage init() ROOT usage Warning: this method will have to be updated for the 8.2 version! ROOT usage ROOT usage EventListing() &rarr; ROOT usage event.list() ROOT usage ROOT usage PrintStatistic() &rarr; ROOT usage stat() ROOT usage ROOT usage Warning: this method will have to be updated for    the 8.2 version! These methods provide already the basic PYTHIA functionality  interactively from the ROOT command line. However, this does not mean  that the usage of PYTHIA from within ROOT is restricted to these methods.  In compiled code, one can always obtain a pointer to the ROOT usage Pythia instance e.g. ROOT usage TPythia8      *tp = new TPythia8();    Pythia8::Pythia *p  = tp->Pythia8(); giving access to the full PYTHIA functionality. To access this  functionality in the CINT interpreter see the 'Advanced usage'  section below. ROOT usage ROOT usage ROOT usage TPythia8Decayer is an implementation of the ROOT usage ROOT usage TVirtualMCDecayer interface. ROOT usage It allows you to use PYTHIA as a plug-in decayer for simulation  frameworks based on the Virtual Monte Carlo  ( ROOT usage VMC ) interface  classes. The main methods of the interface are ROOT usage ROOT usage ROOT usage TPythia8Decayer::Init() for initialisation, ROOT usage ROOT usage TPythia8Decayer::Decay(Int_t pdg, TLorentzVector* p) to decay a particle with PDG code ROOT usage pdg and ROOT usage 4-momentum ROOT usage p , and ROOT usage ROOT usage ImportParticles(TClonesArray* particles) to retrieve the decay products as ROOT usage ROOT usage TParticles in the ROOT usage ROOT usage TClonesArray particles. ROOT usage An example A ROOT usage basic example for generating minimum-bias events with PYTHIA 8 inside a ROOT macro, and filling some histograms with the kinematics of the final-state particles is provided in either of the locations below ROOT usage /path_to_ROOT_source/tutorials/pythia/pythia8.C    /path_to_ROOT_installation/share/doc/root/tutorials/pythia/pythia8.C ROOT usage Note that before executing this script ROOT usage ROOT usage the environment variables ROOT usage PYTHIA8 and ROOT usage PYTHIA8DATA must be setup correctly e.g. ROOT usage export PYTHIA8=/path_to_PYTHIA_installation    export PYTHIA8DATA=$PYTHIA8/share/Pythia8/xmldoc ROOT usage your LD_LIBRARY_PATH must contain the location of the  PYTHIA 8 shared library, e.g. ROOT usage export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:path_to_PYTHIA8_installation/lib The script can then be run with ROOT ROOT usage root pythia8.C After execution, ROOT will display some histograms from the event generation. ROOT usage Advanced usage To access the full PYTHIA functionality from the CINT interpreter, a ROOT dictionary must be created. Currently that option has not been implemented as a standard option for PYTHIA 8.2, but it should be in the same spirit as what can be found in the 8.1 ROOT usage rootexamples directory. Also note that one dictionary is found in the ROOT usage examples/main92LinkDef.h file.  This may then be loaded in ROOT giving full access to the full PYTHIA 8 functionality, e.g. in an interactive session ROOT usage gSystem->Load('path_to_PYTHIA8_installation/rootexamples/pythiaDict');    Pythia8::Pythia *p = new Pythia8::Pythia();    p->readString('SoftQCD:nonDiffractive = on');"},{"name":"Rope Hadronization","link":"RopeHadronization.html","text":"Rope Hadronization Rope Hadronization Rope Hadronization In collisions of protons, there are often tens of multiparton interactions, all producing Lund strings occupying the same area in transverse space of Rope Hadronization ~1 fm Rope Hadronization ^2. The Rope Hadronization framework describes the interactions between such overlapping strings, by (a) allowing nearby strings to shove each other with an interaction potential derived from the colour superconductor analogy Rope Hadronization Bie16b , Rope Hadronization Bie17 and (b) at hadronization time, colour charges at string endpoints and in gluon 'kinks' can act together coherently to form a 'rope', which is hadronized with a larger, effective string tension Rope Hadronization Bie14. The latter has noticeable effects on the flavour composition of the hadronic final state Rope Hadronization Bie15 , and this effect is denoted 'flavour ropes' below. Rope Hadronization Since both models deal with string overlaps in transverse space, it is necessary to provide such information, as it is not present in the Pythia MPI model. The information is provided through the Rope Hadronization Parton Vertex methods. The string shoving mechanism is exemplified in the Rope Hadronization main101 example, and the flavour ropes in Rope Hadronization main102. A simpler version of flavour composition ropes exist Rope Hadronization Bie16c , which do not require vertex information. This can be enabled by a switch. Rope Hadronization Main settings The main settings are common for both the string shoving and the flavour rope models. Rope Hadronization String shoving The string shoving mechanism allows strings to push each other, before hadronization, as described in Rope Hadronization Bie16b. Rope Hadronization String shoving divides the event up in many small rapidity slices (in the lab frame), and all string pieces in all slices are allowed to push each other with a force: Rope Hadronization f(d_\perp) = \frac{g_A \kappa d_\perp}{R^2} \exp\left(-\frac{d^2_\perp }{4R^2}\right), where Rope Hadronization d_\perp is the distance in transverse space between two string pieces, calculated dynamically using Rope Hadronization Vertex Information. Model parameters are Rope Hadronization g_A , the amplitude of the shoving force, Rope Hadronization R , the string radius, and Rope Hadronization g_E , a parameter dividing the equilibrium string radius to account for the effect of strings starting out with a vanishing string radius. Rope Hadronization The model should be used with some caution. Simply switching it on, one will not retain full description of single particle observables in minimum bias pp collisions, as the excitation gluons will increase multiplicity. Besides normal tuning, one can use the parameter Rope Hadronization FragmentationSystems:mJoin to join the excitation gluons together, in order to recover single particle observables. Rope Hadronization Flavour Ropes The Flavour Ropes mechanism allows strings situated close in impact parameter space to interact coherently, forming a rope, which hadronizes with a larger, effective string tension. The model is described in ref. Rope Hadronization Bie14 , building on an older idea by Biro et al. Rope Hadronization Bir84. Rope Hadronization In the flavour rope formalism, a rope is described as an SU(3) multiplet, characterized uniquely by two quantum numbers Rope Hadronization p and Rope Hadronization q. The quantum numbers are calculated, following ref. Rope Hadronization Bir84 , by a random walk procedure in colour space, taking Rope Hadronization m, n steps, where Rope Hadronization m and Rope Hadronization n signify the number of overlapping strings which are respectively parallel or anti-parallel to the hadronizing string. Rope Hadronization When the rope quantum numbers have been determined, the effective string tension is calculated per individual breaking, using a lattice QCD determination of the string tension Rope Hadronization Bal00. The effective string tension is then used to rescale the hadronization parameters described in the section on Rope Hadronization String Fragmentation. One point to note regarding the rescaling is the fragmentation parameter Rope Hadronization StringFlav:probQQtoQ , describing baryon relative to meson production. Baryon production is, as suggested by eg. the popcorn hadronization model Rope Hadronization Ede97 , more complicated than meson production. The current modelling of this in the flavour ropes framework is limited, but intended to be extended in the future."},{"name":"Sample Main Programs","link":"SampleMainPrograms.html","text":"Sample Main Programs Sample Main Programs Sample Main Programs Descriptions of available classes, methods and settings are all very good and useful. Ultimately they are necessary for you to be able to fine-tune your runs to the task at hand. To get going, however, nothing helps like having explicit examples to study. This is what is provided in the Sample Main Programs examples subdirectory, along with instructions how they should be run: Sample Main Programs Sample Main Programs Sample Main Programs main00.cc : does not exist, but it has been defined in the Sample Main Programs Makefile , so this name could be used for a simple first test run. Sample Main Programs Sample Main Programs main01.cc : a simple study of the charged multiplicity for jet events at the LHC. (Brief example fitting on one slide.) Sample Main Programs Sample Main Programs main01.py : a Python interface equivalent of Sample Main Programs main01.cc. Sample Main Programs Sample Main Programs main02.cc : a simple study of the Sample Main Programs pT spectrum of Z bosons at the Tevatron. (Brief example fitting on one slide.) Sample Main Programs Sample Main Programs main03.cc : a simple study of several different kinds of events, with the choice to be made in the Sample Main Programs main03.cmnd 'cards file'. Also shows how to plot histograms using the Python/Matplotlib/Pyplot solution. Sample Main Programs Sample Main Programs main04.cc : tests of cross sections, multiplicities and average transverse momenta for elastic, diffractive and nondiffractive topologies, using Sample Main Programs main04.cmnd to pick processes. For photoproduction  one can use the alternative Sample Main Programs main04_photons.cmnd input. Sample Main Programs Sample Main Programs main05.cc : generation of QCD jet events at the LHC, with jet analysis using the Sample Main Programs SlowJet inclusive anti- Sample Main Programs kT sequential-recombination finder and the Sample Main Programs CellJet cone-jet finder. Sample Main Programs Sample Main Programs main06.cc : generation of LEP1 hadronic events, i.e. Sample Main Programs e^+e^- &rarr; gamma*/Z^0 &rarr; q qbar , with charged multiplicity, sphericity, thrust and jet analysis. Sample Main Programs Sample Main Programs main07.cc : set up a fictitious production process to a generic resonance, where you easily can compose your own list of (two-body) decay modes to a variety of final states. Also traces decay chains down to truly stable particles: gamma, e+-, p/pbar and neutrinos. Suitable for astroparticle applications, like neutralino pair annihilation, where cross sections are calculated separately in another program.  Also shows how to plot histograms using the Python/Matplotlib/Pyplot solution. Sample Main Programs Sample Main Programs main08.cc : generation of the QCD jet cross section biased towards higher pT values, by two different techniques. Firstly, by splitting the run into subruns, each in its own Sample Main Programs pT bin, and adding the results properly reweighted. Two suboptions, with limits set either in the main program or by subrun specification in the Sample Main Programs main08.cmnd file. Secondly, by a continuous reweighting with a Sample Main Programs pT^4 bias in the selection, compensated by a Sample Main Programs 1/pT^4 event weight. Also inclusion of soft processes is illustrated, with subruns and weighted events. Sample Main Programs Sample Main Programs main09.cc : generation of two predetermined hard interactions in each event. Sample Main Programs Sample Main Programs main10.cc : illustration how userHooks can be used interact directly with the event-generation process. Sample Main Programs Sample Main Programs main10.py : a Python interface equivalent of Sample Main Programs main10.cc. Provides an example of how to derive PYTHIA classes in Python. Sample Main Programs Sample Main Programs main11.cc : a study of top events, fed in from the Les Houches Event File Sample Main Programs ttbar.lhe , here generated by PYTHIA 6.4. This file currently only contains 100 events so as not to make the distributed PYTHIA package too big, and so serves mainly as a demonstration of the principles involved. Sample Main Programs Sample Main Programs main12.cc : a more sophisticated variant of Sample Main Programs main11.cc , where two Les Houches Event Files ( Sample Main Programs ttbar.lhe and Sample Main Programs ttbar2.lhe ) successively are used as input. Also illustrating some other aspects, like the capability to mix in internally generated events. Sample Main Programs Sample Main Programs main13.cc : a streamlined version of Sample Main Programs main12.cc , where two Les Houches Event Files ( Sample Main Programs ttbar.lhe and Sample Main Programs ttbar2.lhe ) successively are used as input in Sample Main Programs main13.cmnd file. Sample Main Programs Sample Main Programs main14.cc : a systematic comparison of several cross section values with their corresponding values in PYTHIA 6.4, the latter available as a table in the code. Sample Main Programs Sample Main Programs main15.cc : loop over several tries, either to redo B decays only or to redo the complete hadronization chain of an event. Since much of the generation process is only made once this is a way to increase efficiency. Sample Main Programs Sample Main Programs main16.cc : put all user analysis code into a class of its own, separate from the main program; provide the 'cards file' name as a command-line argument. Also exemplifies how Higgs mass, width and branching ratios can be set by hand. Sample Main Programs Sample Main Programs main17.cc : shows (a) how to use UserHooks to regularize onium cross section for pT &rarr; 0, and (b) how decays could be handled externally. Sample Main Programs Sample Main Programs main18.cc : shows how to write an event filter class, where you keep a vector of pointers to the subset of particles you want to study further. The event record itself remains unchanged. Sample Main Programs Sample Main Programs main19.cc : use several instances of Pythia, one for signal events and others for a variable number of pileup and 'beam-gas' events, combined into one common event record. Illustrates how new Pythia instances can copy existing settings and particle data. Sample Main Programs Sample Main Programs main20.cc : shows how PYTHIA 8 can write a Les Houches Event File, using facilities potentially useful also for other programs to write an LHEF. See also Sample Main Programs main64.cc. Sample Main Programs Sample Main Programs main21.cc : an example how a single particle or various parton-level configurations can be input directly for hadronization, without being tied to the full process-generation machinery, e.g. to study the hadronization of junction topologies. Can also be used for single-resonance decays, with showers. Sample Main Programs Sample Main Programs main22.cc : shows how an external resonance can be implemented as a new class derived from a PYTHIA base class, and be used in an external process, both of them handed in for generation as with normal internal classes. Sample Main Programs Sample Main Programs main23.cc : shows how to write external classes, derived from PYTHIA base classes, that can be handed to PYTHIA for internal generation. The MIXMAX random number generator is this way compared with the default PYTHIA one. Explicit implementations are included for the generation of external beam momentum spread and vertex location, and for a simple scaling external parton distribution set. Sample Main Programs Sample Main Programs main24.cc : tests of internally implemented cross sections for Supersymmetric particle production, with SUSY spectrum defined in Sample Main Programs slha2-example.spc and settings in Sample Main Programs main24.cmnd. For illustration, an alternative example spectrum is also available, Sample Main Programs sps1aWithDecays.spc , which contains a decay table in SLHA format. Sample Main Programs Sample Main Programs main25.cc : input RPV-SUSY events from an LHEF file that contains an SLHA spectrum inside its header. The event file, Sample Main Programs main25.lhe , contains a sample events that illustrate how to arrange color tags in the presence of the color-space epsilon tensors that accompany baryon number violating event topologies. Sample Main Programs Sample Main Programs main26.cc : test program for processes in scenarios with large extra dimensions or unparticles. Sample Main Programs Sample Main Programs main27.cc : production of Kaluza-Klein Sample Main Programs gamma/Z states in TeV-sized extra dimensions. Sample Main Programs Sample Main Programs main28.cc : production of long-lived R-hadrons, that are forced to decay at a separate vertices and possibly with changed momenta. Sample Main Programs Sample Main Programs main29.cc : colour reconnection models studied for top production. Illustrates how to set up the user hooks in Sample Main Programs include/Pythia8Plugins/ColourReconnectionHooks.h , with several models not found in the standard PYTHIA library. Sample Main Programs Sample Main Programs main30.cc : example how to create a tailormade copy of the ordinary event record, here with hard-process history tracing closer to the PYTHIA 6 conventions. Sample Main Programs Sample Main Programs main31.cc : exemplifies an improved matching of parton showers to LHEF-style input based on the Sample Main Programs POWHEG approach. The Sample Main Programs main31.cmnd allows to switch between several different matching options. It also allows to select input process, in this case either for the POWHEG-hvq program applied to top pair production Sample Main Programs Cor10 or for QCD 2+3-jet events. The small samples of input events are stored in the Sample Main Programs powheg-hvq.lhe and Sample Main Programs powheg-dijets.lhe files, respectively. Sample Main Programs Sample Main Programs main32.cc : exemplifies MLM merging, either in the ALPGEN variant or in the Madgraph one, and with input events either from ALPGEN or from Madgraph, with relevant control cards stored in Sample Main Programs main32.cmnd. See Sample Main Programs Jet Matching for further details. Traditionally the ALPGEN output is split into one file with events and another with parameters and cross sections (unlike in LHEF). Here a sample of Sample Main Programs W + 3 jets events is stored in Sample Main Programs main32.unw and the parameters to go with it in Sample Main Programs main32_unw.par. Madgraph events are taken from the Sample Main Programs w+_production_lhc_2.lhe file in this case. Sample Main Programs Sample Main Programs main33.cc : demonstrates how to link the POWHEGBOX matrix element programs dynamically, bypassing the need for intermediate LHE files. Two special files are used in this option: Sample Main Programs include/Pythia8Plugins/LHAPowheg.h contains the LHAup class wrapper used to build the POWHEG plugin libraries, and Sample Main Programs include/Pythia8Plugins/PowhegProcs.h the simple class that facilitates loading the POWHEG plugins. In addition Sample Main Programs main33.cmnd contains the commands needed for POWHEGBOX to run the example. Sample Main Programs Sample Main Programs main34.cc : demonstrates how Madgraph5_aMC\@NLO can be run 'from within' Pythia, making use of the Sample Main Programs LHAupMadgraph wrapper/interface of Madgraph5_aMC\@NLO and the Pythia jet matching facilities. Sample Main Programs Sample Main Programs main34.py : a Python interface equivalent of Sample Main Programs main34.cc. Demonstrates usage of a PYTHIA plugin within the Python interface. Sample Main Programs Sample Main Programs main35.cc : demonstrates how to generate quarkonia events with the external HelacOnia package interfaced to Pythia, and compare results with the internal implementation. Sample Main Programs Sample Main Programs main36.cc : demonstrates how to generate Deeply Inelastic Scattering events, e.g. in a HERA configuration. Sample Main Programs Sample Main Programs main37.cc : shows how LHEF version 3.0 files can be read and used to fill several histograms of the same property, but with different event weights. Sample Main Programs Sample Main Programs main38.cc : an extended version of Sample Main Programs main37.cc , where additionally it is shown how to extract many different kinds of LHEF version 3.0 information. Sample Main Programs Sample Main Programs main41.cc : similar to Sample Main Programs main01 , except that the event record is output in the HepMC event record format. Requires that HepMC is properly linked. Note that the Sample Main Programs hepmcout41.dat output file can become quite big; so no example is included in this distribution. Sample Main Programs Sample Main Programs main42.cc : a streamlined version for the generation of events that are then stored in HepMC format, without any event analysis. That is, all physics studies will have to be done afterwards. The name of the input 'cards file' (e.g. Sample Main Programs main42.cmnd ) and output HepMC event file (e.g. Sample Main Programs hepmcout42.dat ) are to be provided as command-line arguments. Requires that HepMC is properly linked. Note that the HepMC output file can become quite big; so no example is included in this distribution. Sample Main Programs Sample Main Programs main43.cc : a further extension of Sample Main Programs main42.cc , where subruns are used to process several consecutive LHEF, as in Sample Main Programs main13.cc , with information stored e.g in Sample Main Programs main43.cmnd. Other comments as for Sample Main Programs main42.cc. Sample Main Programs Sample Main Programs main48.cc : demonstrates how to use the Sample Main Programs EvtGenDecays class provided by Sample Main Programs include/Pythia8Plugins/EvtGen.h to perform decays with the Sample Main Programs EvtGen package. The Sample Main Programs main48.cc header contains special instructions how to configure PYTHIA for use with Sample Main Programs EvtGen. Sample Main Programs Sample Main Programs main51.cc : a test of the shape of parton densities, as a check prior to using a given PDF set in a generator.  Requires that LHAPDF is properly linked. Also shows how to plot histograms (with logarithmic Sample Main Programs x scale) using the Python/Matplotlib/Pyplot solution. Sample Main Programs Sample Main Programs main52.cc : compares the charged multiplicity distribution, and a few other minimum-bias physics aspects, between default PYTHIA PDF and another one. Requires that LHAPDF is properly linked. Sample Main Programs Sample Main Programs main53.cc : tests the possibility to do backwards evolution from an incoming photon at the hard interaction. Requires that you link to a LHAPDF set that includes the photon PDF. Sample Main Programs Sample Main Programs main54.cc : compares the internal and LHAPDF implementations of the NNPDF 2.3 QCD+QED sets, for results and for timing. Requires that LHAPDF is properly linked. Sample Main Programs Sample Main Programs main55.cc : exemplifies how you can use the internal implementation of interpolation in an lhagrid1 .dat file, without linking LHAPDF6. Also illustrates the topical issue of associated event properties for an intermediate spinless resonance in Sample Main Programs &gamma; + &gamma; &rarr; &gamma; + &gamma; at 750 GeV. Sample Main Programs Sample Main Programs main61.cc : exemplifies the generation of hard diffractive processes. Sample Main Programs Sample Main Programs main62.cc : illustrates how a user hook can be made to steer the angular distribution selection in resonance decays. The prime example would be if LHEF input, e.g. from Madgraph, contains undecayed resonances with helicity information. These would then be decayed isotropically by PYTHIA, but this example shows how one could do better. Some input in Sample Main Programs main62.cmnd. Sample Main Programs Sample Main Programs main63.cc : exemplifies how a user hook can be used to enhance the rate of rare emissions in the shower. Sample Main Programs Sample Main Programs main64.cc : examplifies how LHEF version 3 events can be written on an external file. Sample Main Programs Sample Main Programs main68.cc : examplifies hard diffraction in the context of a photon-inside-lepton beam, like a HERA. Sample Main Programs Sample Main Programs main69.cc : examplifies how to generate all relevant contributions for charged particle spectra in photon-photon and photon-proton collisions. Sample Main Programs Sample Main Programs main70.cc : examplifies how to provide an external photon flux for photo-production processes. Sample Main Programs Sample Main Programs main71.cc : an example how the FastJet jet finding package can be linked to allow an analysis of the final state, in this case for a study of W + jet production. Sample Main Programs Sample Main Programs main72.cc : a comparison of SlowJet and FastJet jet finding, showing that they find the same jets if run under identical conditions, in this case for QCD jets. Sample Main Programs Sample Main Programs main73.cc : a comparison of jet properties on the parton and the hadron level, illustrating possibilities for larger control of which particles are used in the jet analyses. Sample Main Programs Sample Main Programs main74.cc : exemplifies how to use one of the contributed add-ons to the FastJet package. In this case the modified Mass Drop Tagger is used to improve the mass reconstruction of a boosted hadronically decaying Sample Main Programs Z^0. Sample Main Programs Sample Main Programs main75.cc : setup (in Sample Main Programs main75.cmnd ) for Dark Matter production via an Sample Main Programs s -channel mediator, where a mono-jet Sample Main Programs pT spectrum is found with the FastJet package. Sample Main Programs Sample Main Programs main76.cc : simple setup for Dark Matter production in several different scenarios, as specified in Sample Main Programs main76.cmnd , notably with long-lived particle signatures. Sample Main Programs Sample Main Programs main77.cc : example how double parton scattering events can be reweighted according to a different model than default in Pythia. Contributed by Boris Blok and Paolo Gunnellini. Sample Main Programs Sample Main Programs main80.cc : do CKKW-L merging with a merging scale defined in Sample Main Programs kT. Input is provided by the Sample Main Programs main80.cmnd file and input LHE files. Very basic and pedagogical setup, suitable for tutorials. Sample Main Programs Sample Main Programs main81.cc : do CKKW-L merging with a merging scale defined in Sample Main Programs kT. Input is provided by the Sample Main Programs main81.cmnd file and the three data files Sample Main Programs w+_production_lhc_0.lhe , Sample Main Programs w+_production_lhc_1.lhe and Sample Main Programs w+_production_lhc_2.lhe. Sample Main Programs Sample Main Programs main82.cc : do CKKW-L merging with a user-defined merging scale function. Input is provided by the Sample Main Programs main82.cmnd file and the three data files Sample Main Programs w+_production_lhc_0.lhe , Sample Main Programs w+_production_lhc_1.lhe and Sample Main Programs w+_production_lhc_2.lhe. Sample Main Programs Sample Main Programs main83.cc : as Sample Main Programs main82.cc but with an additional cut on the lowest multiplicity allowed for the reclustered state. The same input as for Sample Main Programs main82.cc can be used. Sample Main Programs Sample Main Programs main84.cc : do CKKW-L merging with output in such a way that it can be used in subsequent RIVET analyses. Input is provided by the Sample Main Programs main84.cmnd file and the three data files Sample Main Programs w+_production_lhc_0.lhe , Sample Main Programs w+_production_lhc_1.lhe and Sample Main Programs w+_production_lhc_2.lhe. Sample Main Programs Sample Main Programs main85.cc : do CKKW-L merging, with HepMC event output. Input settings are provided by the Sample Main Programs main85.cmnd file. This example program allows the use of input Les Houches events that are regularised with only very minimal cuts, and on which Pythia itself should enforce the more restrictive merging scale cut. The example program can be used with the input files Sample Main Programs w_production_tree_0.lhe , Sample Main Programs w_production_tree_1.lhe and Sample Main Programs w_production_tree_2.lhe. Sample Main Programs Sample Main Programs main86.cc : do unitarised ME+PS (UMEPS) merging, with HepMC event output. Input settings are provided by the Sample Main Programs main86.cmnd file. This example program allows the consistent use of input Les Houches events that are regularised with only very minimal cuts, similar to Sample Main Programs main85.cc. The example program can be used with the input files Sample Main Programs w_production_tree_0.lhe , Sample Main Programs w_production_tree_1.lhe and Sample Main Programs w_production_tree_2.lhe. The program will produce positively and negatively weighted events. See Sample Main Programs UMEPS Merging for further details. Sample Main Programs Sample Main Programs main87.cc : do NL Sample Main Programs 3 NLO merging, with inclusive NLO input, and with HepMC event output. Input settings are provided by the Sample Main Programs main87.cmnd file. This example program allows the consistent use of input Les Houches events that are regularised with only very minimal cuts, similar to Sample Main Programs main85.cc. The example program can be used with the tree-level input files Sample Main Programs w_production_tree_0.lhe , Sample Main Programs w_production_tree_1.lhe , Sample Main Programs w_production_tree_2.lhe and the inclusive POWHEG input files Sample Main Programs w_production_powheg_0.lhe , Sample Main Programs w_production_powheg_1.lhe. The program will produce positively and negatively weighted events. See Sample Main Programs NLO Merging (NL Sample Main Programs 3 section) for further details. Sample Main Programs Sample Main Programs main88.cc : do unitarised NLO+PS (UNLOPS) merging, with inclusive NLO input, and with HepMC event output. Input settings are provided by the Sample Main Programs main88.cmnd file. This example program allows the consistent use of input Les Houches events that are regularised with only very minimal cuts, similar to Sample Main Programs main85.cc. The example program can be used with the tree-level input files Sample Main Programs w_production_tree_0.lhe , Sample Main Programs w_production_tree_1.lhe , Sample Main Programs w_production_tree_2.lhe and the inclusive POWHEG input files Sample Main Programs w_production_powheg_0.lhe , Sample Main Programs w_production_powheg_1.lhe. The program will produce positively and negatively weighted events. See Sample Main Programs NLO Merging (UNLOPS section) for further details. Sample Main Programs Sample Main Programs main89.cc : do matching/merging according to five alternative methods, simply by choosing which Sample Main Programs .cmnd file to read: Sample Main Programs main89ckkwl.cmnd for CKKW-L, Sample Main Programs main89fxfx.cmnd for FxFx, Sample Main Programs main89mlm.cmnd for MLM, Sample Main Programs main89umeps.cmnd for UMEPS, and Sample Main Programs main89unlops.cmnd for UNLOPS. Sample Main Programs Sample Main Programs main91.cc : shows how ROOT can be used for histogramming in a program that for the rest is structured like a normal PYTHIA run. Sample Main Programs Sample Main Programs main92.cc : shows how PYTHIA events can be stored as ROOT trees. Sample Main Programs Sample Main Programs main93.cc : stremlined event generation with possibility to output ROOT files, output HepMC files and run RIVET analyses, all by specifying output modes in a cmnd file, where also the event generator settings are specified. The example is run with command line options, run Sample Main Programs ./main93 -h to see a full list. See Sample Main Programs ROOT Usage for information about ROOT output, Sample Main Programs RIVET Usage for information about RIVET and Sample Main Programs HepMC Interface for information about HepMC. Sample Main Programs Sample Main Programs main101.cc : shows how the string shoving mechanism, part of the rope hadronization framework, can be set up and used to generate ridge effects. Sample Main Programs Sample Main Programs main102.cc : shows how flavour production is changed in the rope hadronization framework. Sample Main Programs Sample Main Programs main111.cc : simple pp collisions as in Sample Main Programs main01.cc , but using the Angantyr model for Heavy Ion collisions. Also shows how Rivet analyses can be set up easily using a special interface. Sample Main Programs Sample Main Programs main112.cc : p-Pb collisions at LHC energies, using the Angantyr model for Heavy Ion collisions, and analyzing events by centrality bins. Sample Main Programs Sample Main Programs main113.cc : Pb-Pb collisions at LHC energies, using the Angantyr model for Heavy Ion collisions, and analyzing events by centrality bins. Sample Main Programs Sample Main Programs main121.cc : set up automatic uncertainty band variations to PDFs and factorization and renormalization scales. Sample Main Programs Sample Main Programs main200.cc : Basic VINCIA example program for hadronic Z decays at LEP. Sample Main Programs Sample Main Programs main201.cc : Comparison of VINCIA and Pythia on inclusive jets at LHC, with option to run the two generators in parallel using OpenMP. Sample Main Programs Sample Main Programs main202.cc : VINCIA setup for ttbar production at LHC, with measurement of run time and options to switch various shower and MPI/hadronisation components on/off via command file. Sample Main Programs Sample Main Programs main300.cc : Allows to steer Pythia from the command line and can produce HepMC files and allows for OpenMP parallelization. More documentation can be obtained by executing Sample Main Programs ./main300 --help. The input file main300.cmnd further illustrates the use of DIRE."},{"name":"Second Hard Process","link":"SecondHardProcess.html","text":"Second Hard Process Second Hard Process Second Hard Process When you have selected a set of hard processes for hadron beams, the Second Hard Process multiparton interactions framework can add further interactions to build up a realistic underlying event. These further interactions can come from a wide variety of processes, and will occasionally be quite hard. They do represent a realistic random mix, however, which means one cannot predetermine what will happen. Occasionally there may be cases where one wants to specify also the second hard interaction rather precisely. The options on this page allow you to do precisely that. Second Hard Process Process Selection In principle the whole Second Hard Process process selection allowed for the first process could be repeated for the second one. However, this would probably be overkill. Therefore here a more limited set of prepackaged process collections are made available, that can then be further combined at will. Since the description is almost completely symmetric between the first and the second process, you always have the possibility to pick one of the two processes according to the complete list of possibilities. Second Hard Process Here comes the list of allowed sets of processes, to combine at will: Second Hard Process A further process collection comes with a warning flag: Second Hard Process Phase Space Cuts and Scales By default, the second hard process obeys exactly the same selection rules for Second Hard Process phase space cuts and Second Hard Process couplings and scales as the first one does. Specifically, a Second Hard Process pTmin cut for Second Hard Process 2 &rarr; 2 processes would apply to the first and the second hard process alike, and ballpark half of the time the second could be generated with a larger Second Hard Process pT than the first. (Exact numbers depending on the relative shape of the two cross sections.) That is, first and second is only used as an administrative distinction between the two, not as a physics ordering one. Second Hard Process Optionally it is possible to pick the mass and Second Hard Process pT phase space cuts separately for the second hard interaction. The main application presumably would be to allow a second process that is softer than the first, but still hard. But one is also free to make the second process harder than the first, if desired. So long as the two Second Hard Process pT (or mass) ranges overlap the ordering will not be the same in all events, however. Second Hard Process Cross-section calculation As an introduction, a brief reminder of Poissonian statistics. Assume a stochastic process in time, for now not necessarily a high-energy physics one, where the probability for an event to occur at any given time is independent of what happens at other times. Then the probability for Second Hard Process n events to occur in a finite time interval is Second Hard Process P_n = <n>^n exp(-<n>) / n! where Second Hard Process <n> is the average number of events. If this number is small we can approximate Second Hard Process exp(-<n>) = 1 , so that Second Hard Process P_1 = <n> and Second Hard Process P_2 = <n>^2 / 2 = P_1^2 / 2. Second Hard Process Now further assume that the events actually are of two different kinds Second Hard Process a and Second Hard Process b , occurring independently of each other, such that Second Hard Process <n> = <n_a> + <n_b>. It then follows that the probability of having one event of type Second Hard Process a (or Second Hard Process b ) and nothing else is Second Hard Process P_1a = <n_a> (or Second Hard Process P_1b = <n_b> ). From Second Hard Process P_2 = (<n_a> + <n_b>)^2 / 2 = (P_1a + P_1b)^2 / 2 = (P_1a^2 + 2 P_1a P_1b + P_1b^2) / 2 it is easy to read off that the probability to have exactly two events of kind Second Hard Process a and none of Second Hard Process b is Second Hard Process P_2aa = P_1a^2 / 2 whereas that of having one Second Hard Process a and one Second Hard Process b is Second Hard Process P_2ab = P_1a P_1b. Note that the former, with two identical events, contains a factor Second Hard Process 1/2 while the latter, with two different ones, does not. If viewed in a time-ordered sense, the difference is that the latter can be obtained two ways, either first an Second Hard Process a and then a Second Hard Process b or else first a Second Hard Process b and then an Second Hard Process a. Second Hard Process To translate this language into cross-sections for high-energy events, we assume that interactions can occur at different Second Hard Process pT values independently of each other inside inelastic nondiffractive (sometimes equated with 'minbias') events. Then the above probabilities translate into Second Hard Process P_n = sigma_n / sigma_ND where Second Hard Process sigma_ND is the total nondiffractive cross section. Again we want to assume that Second Hard Process exp(-<n>) is close to unity, i.e. that the total hard cross section above Second Hard Process pTmin is much smaller than Second Hard Process sigma_ND. The hard cross section is dominated by QCD jet production, and a reasonable precaution is to require a Second Hard Process pTmin of at least 20 GeV at LHC energies. (For Second Hard Process 2 &rarr; 1 processes such as Second Hard Process q qbar &rarr; gamma^*/Z^0 (&rarr; f fbar) one can instead make a similar cut on mass.) Then the generic equation Second Hard Process P_2 = P_1^2 / 2 translates into Second Hard Process sigma_2/sigma_ND = (sigma_1 / sigma_ND)^2 / 2 or Second Hard Process sigma_2 = sigma_1^2 / (2 sigma_ND). Second Hard Process Again different processes Second Hard Process a, b, c, ... contribute, and by the same reasoning we obtain Second Hard Process sigma_2aa = sigma_1a^2 / (2 sigma_ND) , Second Hard Process sigma_2ab = sigma_1a sigma_1b / sigma_ND , and so on. Second Hard Process There is one important correction to this picture: all collisions do no occur under equal conditions. Some are more central in impact parameter, others more peripheral. This leads to a further element of variability: central collisions are likely to have more activity than the average, peripheral less. Integrated over impact parameter standard cross sections are recovered, but correlations are affected by a 'trigger bias' effect: if you select for events with a hard process you favour events at small impact parameter which have above-average activity, and therefore also increased chance for further interactions. (In PYTHIA this is the origin of the 'pedestal effect', i.e. that events with a hard interaction have more underlying activity than the level found in minimum-bias events.) Second Hard Process When you specify a matter overlap profile in the multiparton-interactions scenario, such an enhancement/depletion factor Second Hard Process f_impact is chosen event-by-event and can be averaged during the course of the run. As an example, the double Gaussian form used in Tune A gives approximately Second Hard Process <f_impact> = 2.5. In general, the more uneven the distribution the higher the Second Hard Process <f_impact>. Also the Second Hard Process pT0 parameter value has an impact, even if it is less important over a realistic range of values, although it implies that Second Hard Process <f_impact> is energy-dependent. The origin of this effect is as follows. A lower Second Hard Process pT0 implies more MPI activity at all impact parameters, so that the nondiffractive cross section Second Hard Process sigma_ND increases, or equivalently the proton size. But if Second Hard Process sigma_ND is fixed by data then the input radius of the matter overlap profile (not explicitly specified but implicitly adjusted at initialization) has to be shrunk  so that the output value can stay constant. This means that the proton matter is more closely packed and therefore Second Hard Process <f_impact> goes up. Second Hard Process The above equations therefore have to be modified to Second Hard Process sigma_2aa = <f_impact> sigma_1a^2 / (2 sigma_ND) , Second Hard Process sigma_2ab = <f_impact> sigma_1a sigma_1b / sigma_ND. Experimentalists often instead use the notation Second Hard Process sigma_2ab = sigma_1a sigma_1b / sigma_eff , from which we see that PYTHIA 'predicts' Second Hard Process sigma_eff = sigma_ND / <f_impact>. When the generation of multiparton interactions is switched off it is not possible to calculate Second Hard Process <f_impact> and therefore it is set to unity. Second Hard Process When this recipe is to be applied to calculate actual cross sections, it is useful to distinguish three cases, depending on which set of processes are selected to study for the first and second interaction. Second Hard Process (1) The processes Second Hard Process a for the first interaction and Second Hard Process b for the second one have no overlap at all. For instance, the first could be Second Hard Process TwoJets and the second Second Hard Process TwoPhotons. In that case, the two interactions can be selected independently, and cross sections tabulated for each separate subprocess in the two above classes. At the end of the run, the cross sections in Second Hard Process a should be multiplied by Second Hard Process <f_impact> sigma_1b / sigma_ND to bring them to the correct overall level, and those in Second Hard Process b by Second Hard Process <f_impact> sigma_1a / sigma_ND. Second Hard Process (2) Exactly the same processes Second Hard Process a are selected for the first and second interaction. In that case it works as above, with Second Hard Process a = b , and it is only necessary to multiply by an additional factor Second Hard Process 1/2. A compensating factor of 2 is automatically obtained for picking two different subprocesses, e.g. if Second Hard Process TwoJets is selected for both interactions, then the combination of the two subprocesses Second Hard Process q qbar &rarr; g g and Second Hard Process g g &rarr; g g can trivially be obtained two ways. Second Hard Process (3) The list of subprocesses partly but not completely overlap. For instance, the first process is allowed to contain Second Hard Process a or Second Hard Process c and the second Second Hard Process b or Second Hard Process c , where there is no overlap between Second Hard Process a and Second Hard Process b. Then, when an independent selection for the first and second interaction both pick one of the subprocesses in Second Hard Process c , half of those events have to be thrown, and the stored cross section reduced accordingly. Considering the four possible combinations of first and second process, this gives a Second Hard Process sigma'_1 = sigma_1a + sigma_1c * (sigma_2b + sigma_2c/2) / (sigma_2b + sigma_2c) with the factor Second Hard Process 1/2 for the Second Hard Process sigma_1c sigma_2c term. At the end of the day, this Second Hard Process sigma'_1 should be multiplied by the normalization factor Second Hard Process f_1norm = <f_impact> (sigma_2b + sigma_2c) / sigma_ND here without a factor Second Hard Process 1/2 (or else it would have been double-counted). This gives the correct Second Hard Process (sigma_2b + sigma_2c) * sigma'_1 = sigma_1a * sigma_2b + sigma_1a * sigma_2c + sigma_1c * sigma_2b + sigma_1c * sigma_2c/2 The second interaction can be handled in exact analogy. Second Hard Process For the considerations above it is assumed that the phase space cuts are the same for the two processes. It is possible to set the mass and transverse momentum cuts differently, however. This changes nothing for processes that already are different. For two collisions of the same type it is partly a matter of interpretation what is intended. If we consider the case of the same process in two non-overlapping phase space regions, most likely we want to consider them as separate processes, in the sense that we expect a factor 2 relative to Poissonian statistics from either of the two hardest processes populating either of the two phase space regions. In total we are therefore lead to adopt the same strategy as in case (3) above: only in the overlapping part of the two allowed phase space regions could two processes be identical and thus appear with a 1/2 factor, elsewhere the two processes are never identical and do not include the 1/2 factor. We reiterate, however, that the case of partly but not completely overlapping phase space regions for one and the same process is tricky, and not to be used without prior deliberation. Second Hard Process The listing obtained with the Second Hard Process pythia.stat() already contain these corrections factors, i.e. cross sections are for the occurrence of two interactions of the specified kinds. There is not a full tabulation of the matrix of all the possible combinations of a specific first process together with a specific second one (but the information is there for the user to do that, if desired). Instead Second Hard Process pythia.stat() shows this matrix projected onto the set of processes and associated cross sections for the first and the second interaction, respectively. Up to statistical fluctuations, these two sections of the Second Hard Process pythia.stat() listing both add up to the same total cross section for the event sample. Second Hard Process There is a further special feature to be noted for this listing, and that is the difference between the number of 'selected' events and the number of 'accepted' ones. Here is how that comes about. Originally the first and second process are selected completely independently. The generation (in)efficiency is reflected in the different number of initially tried events for the first and second process, leading to the same number of selected events. While acceptable on their own, the combination of the two processes may be unacceptable, however. It may be that the two processes added together use more energy-momentum than kinematically allowed, or, even if not, are disfavoured when the PYTHIA approach to provide correlated parton densities is applied. Alternatively, referring to case (3) above, it may be because half of the events should be thrown for identical processes. Taken together, it is these effects that reduced the event number from 'selected' to 'accepted'. (A further reduction may occur if a Second Hard Process user hook rejects some events.) Second Hard Process It is allowed to use external Les Houches Accord input for the hardest process, and then pick an internal one for the second hardest. In this case PYTHIA does not have access to your thinking concerning the external process, and cannot know whether it overlaps with the internal or not. (External events Second Hard Process q qbar' &rarr; e+ nu_e could agree with the internal Second Hard Process W ones, or be a Second Hard Process W' resonance in a BSM scenario, to give one example.) Therefore the combined cross section is always based on the scenario (1) above. Corrections for correlated parton densities are included also in this case, however. That is, an external event that takes a large fraction of the incoming beam momenta stands a fair chance of being rejected when it has to be combined with another hard process. For this reason the 'selected' and 'accepted' event numbers are likely to disagree. Second Hard Process In the cross section calculation above, the Second Hard Process sigma'_1 cross sections are based on the number of accepted events, while the Second Hard Process f_1norm factor is evaluated based on the cross sections for selected events. That way the suppression by correlations between the two processes does not get to be double-counted. Second Hard Process The Second Hard Process pythia.stat() listing contains two final lines, indicating the summed cross sections Second Hard Process sigma_1sum and Second Hard Process sigma_2sum for the first and second set of processes, at the 'selected' stage above, plus information on the Second Hard Process sigma_ND and Second Hard Process <f_impact> used. The total cross section generated is related to this by Second Hard Process <f_impact> * (sigma_1sum * sigma_2sum / sigma_ND) * (n_accepted / n_selected) with an additional factor of Second Hard Process 1/2 for case 2 above. Second Hard Process The error quoted for the cross section of a process is a combination in quadrature of the error on this process alone with the error on the normalization factor, including the error on Second Hard Process <f_impact>. As always it is a purely statistical one and of course hides considerably bigger systematic uncertainties. Second Hard Process Second Hard Process Warning: the calculational machinery above has not (yet) been implemented for the case that the two interactions are to be associated with different impact-parameter profiles, as is the case for Second Hard Process MultipartonInteractions:bProfile = 4 , i.e. when the radius depends on the Second Hard Process x value. Results for the double cross section therefore cannot be trusted in this case. Second Hard Process Event information Normally the Second Hard Process process event record only contains the hardest interaction, but in this case also the second hardest is stored there. If both of them are Second Hard Process 2 &rarr; 2 ones, the first would be stored in lines 3 - 6 and the second in 7 - 10. For both, status codes 21 - 29 would be used, as for a hardest process. Any resonance decay chains would occur after the two main processes, to allow normal parsing. The beams in 1 and 2 only appear in one copy. This structure is echoed in the full Second Hard Process event event record. Second Hard Process Most of the properties accessible by the Second Hard Process Second Hard Process pythia.info methods refer to the first process, whether that happens to be the hardest or not. The code and Second Hard Process pT scale of the second process are accessible by the Second Hard Process info.codeMPI(1) and Second Hard Process info.pTMPI(1) , however. Second Hard Process The Second Hard Process sigmaGen() and Second Hard Process sigmaErr() methods provide the cross section and its error for the event sample as a whole, combining the information from the two hard processes as described above. In particular, the former should be used to give the weight of the generated event sample. The statistical error estimate is somewhat cruder and gives a larger value than the subprocess-by-subprocess one  employed in Second Hard Process pythia.stat() , but this number is anyway less relevant, since systematical errors are likely to dominate."},{"name":"Semi-Internal Processes","link":"SemiInternalProcesses.html","text":"Semi-Internal Processes Semi-Internal Processes Semi-Internal Processes Normally users are expected to implement new processes via the Semi-Internal Processes Les Houches Accord , or by supplying Semi-Internal Processes Les Houches Event Files. Then you do all flavour, colour and phase-space selection externally, before your process-level events are input for further processing by PYTHIA. However, it is also possible to implement a new process in exactly the same way as the internal PYTHIA ones, thus making use of the internal phase space selection machinery to sample an externally provided cross-section expression. The MadGraph5 program Semi-Internal Processes Alw11 allows you to do exactly that, i.e. it can be used to generate C++ code that can be linked into the existing PYTHIA framework, see Semi-Internal Processes here. Semi-Internal Processes Should you decide to go ahead on your own, this page gives a brief summary how to do that. If you additionally want to introduce a new resonance species, with its own internal width calculations, you will find further instructions Semi-Internal Processes here. It is strongly recommended to shop around for a similar process that has already been implemented, and to use that existing code as a template. Look for processes with the same combinations of incoming flavours and colour flows, rather than the shape of the cross section itself. With a reasonable such match the task should be of medium difficulty, without it more demanding. Semi-Internal Processes PYTHIA's internal phase-space generators are rather good at handling the phase space of Semi-Internal Processes 2 &rarr; 1 and Semi-Internal Processes 2 &rarr; 2 processes, are more primitive for Semi-Internal Processes 2 &rarr; 3 ones and do not at all address higher multiplicities. An option is therefore also provided for external phase-space generators to be used, which must then be encapsulated to inherit from PYTHIA's Semi-Internal Processes PhaseSpace base class (or one of its derivatives). The set of processes that can be implemented in this framework is therefore in principle unlimited, though the user must supply external phase-space generators for non-trivial Semi-Internal Processes 2 &rarr; 3 processes and all higher Semi-Internal Processes 2 &rarr; n multiplicities. Note, however, that the produced particles may be resonances, so it is possible to end up with bigger 'final' multiplicities through sequential decays, also with the internal phase-space generators, and to include further matrix-element weighting in those decays. Semi-Internal Processes For processes using PYTHIA's internal phase-space generators, there are three steps involved in implementing a process: Semi-Internal Processes Semi-Internal Processes making use of the PYTHIA-provided kinematics information to calculate the relevant cross section, Semi-Internal Processes writing a new class,  where the matrix elements are implemented, including information on incoming and outgoing flavours and colours, and Semi-Internal Processes making the process available. We consider these aspects in turn. An example where it all comes together is found in Semi-Internal Processes main22.cc. Semi-Internal Processes For processes for which an external phase-space generator will be used, step 1 above changes to writing a new class, where the phase-space generator is implemented, and making use of that to calculate the relevant cross section. There are no example programs illustrating how to do this yet, but the methodology is described below, under 'Implementing an external phase-space generator'. Semi-Internal Processes The Cross Section Calculation The key method for the cross section calculation is Semi-Internal Processes SigmaProcess::sigmaHat() , described below. At the point when it is called, the kinematics has already been set up, and from these phase space variables the differential cross section is to be calculated. Semi-Internal Processes For a Semi-Internal Processes 2 &rarr; 1 process, the returned value should be Semi-Internal Processes sigmaHat(sHat) , where Semi-Internal Processes mH (= Semi-Internal Processes mHat ), Semi-Internal Processes sH (= Semi-Internal Processes sHat ) and Semi-Internal Processes sH2 (= Semi-Internal Processes sHat^2 ) are available to be used. Incoming partons are massless. Overload the Semi-Internal Processes convertM2() method below if you instead plan to return Semi-Internal Processes |M|^2. Semi-Internal Processes For a Semi-Internal Processes 2 &rarr; 2 process, instead Semi-Internal Processes d(sigmaHat)/d(tHat) should be returned, based on provided Semi-Internal Processes mH, sH, sH2, tH, tH2, uH, uH2, m3, s3, m4, s4 and Semi-Internal Processes pT2 values ( Semi-Internal Processes s3 = m3*m3 etc.). Incoming partons are massless. Overload the Semi-Internal Processes convertM2() method below if you instead plan to return Semi-Internal Processes |M|^2. Semi-Internal Processes For a Semi-Internal Processes 2 &rarr; 3 process, instead Semi-Internal Processes |M|^2 should be returned, with normalization such that Semi-Internal Processes |M|^2 / (2 sHat) integrated over the three-body phase space gives the cross section. Here no standard set of Mandelstam-style variables exists. Instead the obvious ones, Semi-Internal Processes mH, sH, m3, s3, m4, s4, m5, s5 , are complemented by the four-vectors Semi-Internal Processes p3cm, p4cm, p5cm , from which further invariants may be calculated. The four-vectors are defined in the CM frame of the subcollision, with massless incoming partons along the Semi-Internal Processes +-z axis. Semi-Internal Processes In either case, Semi-Internal Processes alpha_s and Semi-Internal Processes alpha_em have already been calculated, and are stored in Semi-Internal Processes alpS and Semi-Internal Processes alpEM. Also other standard variables may be used, like Semi-Internal Processes CoupEW::sin2thetaW() , and related flavour-dependent vector and axial couplings in Semi-Internal Processes CoupEW and CKM combinations in Semi-Internal Processes VCKM. Semi-Internal Processes In case some of the final-state particles are resonances, their squared masses have already been selected according to a Breit-Wigner with a linearly running width Semi-Internal Processes Gamma(m) = Gamma(m_0) * m / m_0. More precisely, the mass spectrum is weighted according to Semi-Internal Processes w_BW(m^2) d(m^2) , where Semi-Internal Processes w_BW(m^2) = (1/pi) * (m * Gamma(m)) / ( (m^2 - m_0^2)^2 + (m * Gamma(m))^2 ). If you would like to have another expression, the above weights are stored in Semi-Internal Processes runBW3 , Semi-Internal Processes runBW4 and Semi-Internal Processes runBW5 , respectively. If you divide out one of these factors, you just remain with a phase space selection Semi-Internal Processes d(m^2) for this particle, and can multiply on your desired shape factor instead. Unfortunately, the Monte Carlo efficiency will drop if your new mass distribution differs dramatically from the input one. Therefore it does make sense to adjust the database value of the width to be slightly (but not too much) broader than the distribution you have in mind. Also note that, already by default, the wings of the Breit-Wigner are oversampled (with a compensating lower internal weight) by partly sampling like Semi-Internal Processes (a + b/m^2 + c/m^4) d(m^2) , where the last term is only used for Semi-Internal Processes gamma^*/Z^0. Semi-Internal Processes As alternative to the kinematics variables defined above, also the two arrays Semi-Internal Processes mME[5] and Semi-Internal Processes pME[5] , for masses and four-momenta, respectively, can be used for cross-section calculations. Here indices 0 and 1 are the two incoming beams, and 2 and onwards the outgoing particles. Note that this differs by one step from the normal internal labeling, where slot 0 is left empty. The four-momenta are defined in the rest frame of the subcollision, with the incoming partons along the Semi-Internal Processes +-z direction. The kinematics need not agree with the 'correct' one stored in the event record, for three reasons. Semi-Internal Processes 1) Gauge invariance forces matrix-element calculations to use the same masses for incoming as outgoing legs of a particle species, say Semi-Internal Processes b quarks. Therefore the kinematics of the two incoming partons is recalculated, relative to the normal event record, to put the partons on the mass shell. (Note that initial masses is a technical issue, not the correct physics picture: the incoming partons are likely to be spacelike virtual rather than on the mass shell.) Semi-Internal Processes 2) In principle each fermion flavour has to be treated separately, owing to a different mass. However, in many cases fermions can be assumed massless, which speeds up the calculations, and further gains occur if then different flavours can use the same cross-section expression. In MadGraph the default is that fermions up to and including the Semi-Internal Processes c quark and the Semi-Internal Processes mu lepton are considered massless, while the Semi-Internal Processes b quark and the Semi-Internal Processes tau lepton are considered massive. This can be modified however, and below we provide four flags that can be used to consider the 'borderline' fermions either as massless or as massive when matrix elements are evaluated, to match the assumptions made for the matrix elements themselves. Semi-Internal Processes 3) For Semi-Internal Processes 2 &rarr; 2 and Semi-Internal Processes 2 &rarr; 3 processes of massive identical particles (or antiparticles) in the final state, such as Semi-Internal Processes t tbar or Semi-Internal Processes W^+ W^- , the kinematics is here adjusted so that the two or three particles have the same mass, formed as a suitable average of the actual Breit-Wigner-distributed masses. This allows the evaluation of matrix-element expressions that only have meaning if the two/three have the same mass. Semi-Internal Processes Thus the mass array Semi-Internal Processes mME[5] and the four-momentum array Semi-Internal Processes pME[5] present values both for initial- and final-state particles based on these mass principles suited for matrix-element input. Note that these variables therefore differ from the kinematics stored in the event record proper, where incoming fermions are always massless and outgoing resonances have independent Breit-Wigner mass distributions. Semi-Internal Processes The conversion from the normal to the special kinematics is done by calling the Semi-Internal Processes setupForME() method. This you have to do yourself in the Semi-Internal Processes SigmaHat() member of your derived class. Alternatively it could be done in Semi-Internal Processes SigmaKin() , i.e. before the loop over incoming flavours, but then these would be considered massless. The identity of final-state particles is obtained from the Semi-Internal Processes id3Mass() , Semi-Internal Processes id4Mass() and Semi-Internal Processes id5Mass() methods. Should the conversion to Semi-Internal Processes mME[5] and Semi-Internal Processes pME[5] not work, Semi-Internal Processes setupForME() will return Semi-Internal Processes false , and then the cross section should be put zero. Semi-Internal Processes The Cross Section Class The matrix-element information has to be encoded in a new class. The relevant code could either be put before the main program in the same file, or be stored separately, e.g. in a matched pair of Semi-Internal Processes .h and Semi-Internal Processes .cc files. The latter may be more convenient, in particular if the cross sections are lengthy, or if you intend to build up your own little process library, but of course requires that these additional files are correctly compiled and linked. Semi-Internal Processes The class has to be derived either from Semi-Internal Processes Sigma1Process , for Semi-Internal Processes 2 &rarr; 1 processes, from Semi-Internal Processes Sigma2Process , for Semi-Internal Processes 2 &rarr; 2 ones, or from Semi-Internal Processes Sigma3Process , for Semi-Internal Processes 2 &rarr; 3 ones. (The Semi-Internal Processes Sigma0Process class is used for elastic, diffractive and minimum-bias events, and is not recommended for use beyond that.) These are in their turn derived from the Semi-Internal Processes SigmaProcess base class. Semi-Internal Processes The class can implement a number of methods. Some of these are compulsory, others strongly recommended, and the rest are to be used only when the need arises to override the default behaviour. The methods are: Semi-Internal Processes A Semi-Internal Processes constructor for the derived class obviously must be available. Here you are quite free to allow a list of arguments, to set the parameters of your model, or even to create a set of closely related but distinct processes. For instance, Semi-Internal Processes g g &rarr; Q Qbar , Semi-Internal Processes Q = c or Semi-Internal Processes b , is only coded once, and then the constructor takes the quark code (4 or 5)  as argument, to allow the proper amount of differentiation. Semi-Internal Processes A Semi-Internal Processes destructor is only needed if you plan to delete the process before the natural end of the run, and require some special behaviour at that point. If you call such a destructor you will leave a pointer dangling inside the Semi-Internal Processes Pythia object you gave it in to, if that still exists. Semi-Internal Processes Access to a process Once you have implemented a class, it is straightforward to make use of it in a run. Assume you have written a new class Semi-Internal Processes MySigma , which inherits from Semi-Internal Processes Sigma1Process , Semi-Internal Processes Sigma2Process or Semi-Internal Processes Sigma3Process , which in their turn inherit from Semi-Internal Processes SigmaProcess. You then create an instance of this class and hand it in to a Semi-Internal Processes pythia object with Semi-Internal Processes SigmaProcess* mySigma = new MySigma();     pythia.setSigmaPtr( mySigma); If an external phase-space generator should be used for this process (see 'Implementing an external phase-space generator' below), this should be specified as a second argument in the call to Semi-Internal Processes setSigmaPtr() , as in: Semi-Internal Processes pythia.setSigmaPtr( new mySigma(), new myPhaseSpaceGenerator() ); If you have several processes you can repeat the procedure any number of times. When Semi-Internal Processes pythia.init() is called these processes are initialized along with any internal processes you may have switched on, and treated in exactly the same manner. The Semi-Internal Processes pythia.next() will therefore generate a mix of the different kinds of processes without distinction. See also the Semi-Internal Processes Program Flow description. Semi-Internal Processes If the code should be of good quality and general usefulness, it would be simple to include it as a permanently available process in the standard program distribution. The final step of that integration ought to be left for the PYTHIA authors, but here is a description of what is required. Semi-Internal Processes A flag has to be defined, that allows the process to be switched on; by default it should always be off. The name of the flag should be chosen of the type Semi-Internal Processes model:process. Here the Semi-Internal Processes model would be related to the general scenario considered, e.g. Semi-Internal Processes Compositeness , while Semi-Internal Processes process would specify instate and outstate, separated by a 2 (= to), e.g. Semi-Internal Processes ug2u*g. When several processes are implemented and 'belong together' it is also useful to define a Semi-Internal Processes model:all switch that affects all the separate processes. Semi-Internal Processes The flags should normally be stored in the Semi-Internal Processes ProcessSelection.xml file or one of its daughters for a specific kind of processes. This is to make them easily found by users. You could create and use your own Semi-Internal Processes .xml file, so long as you then add that name to the list of files in the Semi-Internal Processes Index.xml file. (If not, the flags would never be created and the program would not work.) Semi-Internal Processes In the Semi-Internal Processes ProcessContainer.c file, the Semi-Internal Processes SetupContainers::init() method needs to be expanded to create instances of the processes switched on. This code is fairly repetitive, and should be easy to copy and modify from the code already there. The basic structure is Semi-Internal Processes (i) check whether a process is requested by the user and, if so, Semi-Internal Processes (ii) create an instance of the matrix-element class, Semi-Internal Processes (iii)create a container for the matrix element and its associated phase-space handling, and Semi-Internal Processes (iv) add the container to the existing process list. Semi-Internal Processes Two minor variations are possible. One is that a set of related processes are lumped inside the the same initial check, i.e. are switched on all together. The second is that the matrix-element constructor may take arguments, as specified by you (see above). If so, the same basic matrix element may be recycled for a set of related processes, e.g. one for a composite Semi-Internal Processes u and one for a composite Semi-Internal Processes d. Obviously these variations may be combined. Semi-Internal Processes Implementing an external phase-space generator An external phase-space generator can be interfaced by encapsulating it within a class inheriting from PYTHIA's Semi-Internal Processes PhaseSpace base class. The following three virtual methods must be defined: Semi-Internal Processes // Determine how phase space should be sampled.     virtual bool setupSampling();     // Select a trial event kinematics.     virtual bool trialKin(bool inEvent = true, bool repeatSame = false);     // Construct final (accepted) event kinematics.     virtual bool finalKin(); Optionally, a further virtual method is available to specify whether beam particles are resolved in partons or scatter directly, Semi-Internal Processes // Inform whether beam particles are resolved or scatter directly.     virtual bool isResolved(); with default return value Semi-Internal Processes true. Semi-Internal Processes In the Semi-Internal Processes setupSampling() step the main point is to determine the upper estimate of the cross section integrated over the allowed phase space regions, and this should be stored in Semi-Internal Processes sigmaMx. The ratio between the correct cross section and its upper estimate is a measure of the phase-space selection efficiency, and the purpose of this step is to optimize the sampling accordingly. To this end any convenient set of phase-space variables may be chosen. The Semi-Internal Processes x1H and Semi-Internal Processes x2H varables should be used to denote the incoming parton momentum fractions, however, to be used in PDF evaluations. Semi-Internal Processes In the Semi-Internal Processes trialKin() intermediate step the same set of internal variables can be used, and fed into the Semi-Internal Processes SigmaProcess code to evaluate the cross section in the given phase space point, multiplied by the integrated cross section. This value is to be stored in Semi-Internal Processes sigmaNw , and the ratio Semi-Internal Processes sigmaNw/sigmaMx will be used to determine whether the trial event is accepted or not. Semi-Internal Processes In the Semi-Internal Processes finalKin() step the output is more standardized. The key values are the ones stored in the Semi-Internal Processes mH[] and Semi-Internal Processes pH[] arrays, the former for masses and the latter for four-momenta. Here the first two slots represent the two incoming partons and the subsequent ones up to ten outgoing particles. Other particle properties, like the number of final-state particles, their identities and colours, and more, are defined by the Semi-Internal Processes SigmaProcess class. Semi-Internal Processes A tailor-made Semi-Internal Processes 2 &rarr; 3 generator could be defined, e.g., by starting from the code for PYTHIA's internal Semi-Internal Processes PhaseSpace2to3tauycyl base class, which provides a specific representation of 3-parton phase space, used for generic Semi-Internal Processes 2 &rarr; 3 processes in PYTHIA. The virtual functions described could then be redefined to generate a different sampling of 3-parton phase space. One example of this is provided by the existing Semi-Internal Processes PhaseSpace2to3yyycyl class, which PYTHIA uses for massless QCD processes. Note the interplay between the phase-space variables, generated and saved here, and how they are used by the matrix-element codes. For general processes, the user can define samplings in terms of their own phase-space parametrizations, as long as the corresponding matrix elements use the same variables to evaluate the cross-section expressions."},{"name":"Semi-Internal Resonances","link":"SemiInternalResonances.html","text":"Semi-Internal Resonances Semi-Internal Resonances Semi-Internal Resonances The introduction of a new Semi-Internal Resonances semi-internal process may also involve a new particle, not currently implemented in PYTHIA. Often it is then enough to use the Semi-Internal Resonances standard machinery to introduce a new particle ( Semi-Internal Resonances id:all = ... ) and new decay channels ( Semi-Internal Resonances id:addChannel = ... ). By default this only allows you to define a fixed total width and fixed branching ratios. Using Semi-Internal Resonances Semi-Internal Resonances meMode values 100 or bigger provides the possibility of a very simple threshold behaviour. Semi-Internal Resonances If you want to have complete freedom, however, there are two ways to go. One is that you make the resonance decay part of the hard process itself, either using the Semi-Internal Resonances Les Houches interface or a semi-internal process. The other is for you to create a new Semi-Internal Resonances ResonanceWidths object, where you write the code needed for a calculation of the partial width of a particular channel. Semi-Internal Resonances Here we will explain what is involved in setting up a resonance. Should you actually go ahead with this, it is strongly recommended to use an existing resonance as a template, to get the correct structure. There also exists a sample main program, Semi-Internal Resonances main22.cc , that illustrates how you could combine a new process and a new resonance. Semi-Internal Resonances There are three steps involved in implementing a new resonance: Semi-Internal Resonances 1) providing the standard particle information, as already outlined above ( Semi-Internal Resonances id:all = ... , Semi-Internal Resonances id:addChannel = ... ), except that now branching ratios need not be specified, since they anyway will be overwritten by the dynamically calculated values. Semi-Internal Resonances 2) writing the class that calculates the partial widths. Semi-Internal Resonances 3) handing in a pointer to an instance of this class to PYTHIA. Semi-Internal Resonances We consider the latter two aspects in turn. Semi-Internal Resonances The ResonanceWidths Class The resonance-width calculation has to be encoded in a new class. The relevant code could either be put before the main program in the same file, or be stored separately, e.g. in a matched pair of Semi-Internal Resonances .h and Semi-Internal Resonances .cc files. The latter may be more convenient, in particular if the calculations are lengthy, or likely to be used in many different runs, but of course requires that these additional files are correctly compiled and linked. Semi-Internal Resonances The class has to be derived  from the Semi-Internal Resonances ResonanceWidths base class. It can implement a number of methods. The constructor and the Semi-Internal Resonances calcWidth ones are always needed, while others are for convenience. Much of the administrative machinery is handled by methods in the base class. Semi-Internal Resonances Thus, in particular, you must implement expressions for all possible final states, whether switched on in the current run or not, since all contribute to the total width needed in the denominator of the Breit-Wigner expression. Then the methods in the base class take care of selecting only allowed channels where that is required, and also of including effects of closed channels in secondary decays. These methods can be accessed indirectly via the Semi-Internal Resonances Semi-Internal Resonances res... methods of the normal Semi-Internal Resonances Semi-Internal Resonances particle database. Semi-Internal Resonances A Semi-Internal Resonances constructor for the derived class obviously must be available. Here you are quite free to allow a list of arguments, to set the parameters of your model. The constructor must call the base-class Semi-Internal Resonances initBasic(idResIn) method, where the argument Semi-Internal Resonances idResIn is the PDG-style identity code you have chosen for the new resonance. When you create several related resonances as instances of the same class you would naturally make Semi-Internal Resonances idResIn an argument of the constructor; for the PYTHIA classes this convention is used also in cases when it is not needed. Semi-Internal Resonances The Semi-Internal Resonances initBasic(...) method will hook up the Semi-Internal Resonances ResonanceWidths object with the corresponding entry in the generic particle database, i.e. with the normal particle information you set up in point 1) above. It will store, in base-class member variables, a number of quantities that you later may find useful: Semi-Internal Resonances Semi-Internal Resonances idRes : the identity code you provide; Semi-Internal Resonances Semi-Internal Resonances hasAntiRes : whether there is an antiparticle; Semi-Internal Resonances Semi-Internal Resonances mRes : resonance mass; Semi-Internal Resonances Semi-Internal Resonances GammaRes resonance width; Semi-Internal Resonances Semi-Internal Resonances m2Res : the squared mass; Semi-Internal Resonances Semi-Internal Resonances GamMRat : the ratio of width to mass. Semi-Internal Resonances A Semi-Internal Resonances destructor is only needed if you plan to delete the resonance before the natural end of the run, and require some special behaviour at that point. If you call such a destructor you will leave a pointer dangling inside the Semi-Internal Resonances Pythia object you gave it in to, if that still exists. Semi-Internal Resonances Access to resonance widths Once you have implemented a class, it is straightforward to make use of it in a run. Assume you have written a new class Semi-Internal Resonances MyResonance , which inherits from Semi-Internal Resonances ResonanceWidths. You then create an instance of this class and hand it in to a Semi-Internal Resonances pythia object with Semi-Internal Resonances ResonanceWidths* myResonance = new MyResonance();     pythia.setResonancePtr( myResonance); If you have several resonances you can repeat the procedure any number of times. When Semi-Internal Resonances pythia.init() is called these resonances are initialized along with all the internal resonances, and treated in exactly the same manner. See also the Semi-Internal Resonances Program Flow description. Semi-Internal Resonances If the code should be of good quality and general usefulness, it would be simple to include it as a permanently available process in the standard program distribution. The final step of that integration ought to be left for the PYTHIA authors, but basically all that is needed is to add one line in Semi-Internal Resonances ParticleData::initResonances , where one creates an instance of the resonance in the same way as for the resonances already there. In addition, the particle data and decay table for the new resonance has to be added to the permanent Semi-Internal Resonances particle database , and the code itself to Semi-Internal Resonances include/ResonanceWidths.h and Semi-Internal Resonances src/ResonanceWidths.cc."},{"name":"Settings Scheme","link":"SettingsScheme.html","text":"Settings Scheme Settings Scheme Settings Scheme The Settings Scheme Settings class keeps track of all the flags, modes, parameters and words used during the event generation. As such, it serves all the Settings Scheme Pythia program elements from one central repository. Accessing it allows the user to modify the generator behaviour. Settings Scheme Each Settings Scheme Pythia object has a public member Settings Scheme settings of the Settings Scheme Settings class. Therefore you access the settings methods as Settings Scheme pythia.settings.command(argument) , assuming that Settings Scheme pythia is an instance of the Settings Scheme Pythia class. Further, for the most frequent user tasks, Settings Scheme Pythia methods have been defined, so that Settings Scheme pythia.command(argument) would work, see further below. Settings Scheme The central section on this page is the Operation one. The preceding concepts section is there mainly to introduce the basic structure and the set of properties that can be accessed. The subsequent sections provide a complete listing of the existing public methods, which most users probably will have little interaction with. Settings Scheme Concepts We distinguish eight kinds of user-modifiable variables, by the way they have to be stored: Settings Scheme Settings Scheme Flags are on/off switches, and are stored as Settings Scheme bool. Settings Scheme Modes corresponds to a finite enumeration of separate options, and are stored as Settings Scheme int. Settings Scheme Parameters take a continuum of values, and are stored as Settings Scheme double. The shorthand notation parm is used in the C++ code and XML tags. Settings Scheme Words are simple character strings and are stored as Settings Scheme string. No double quotation marks &quot; or braces { } may appear inside a word, and commas , will take a spcial role next so should also be avoided. Normally the input string is expected not to contain any blanks or equal signs, but if it does it must be enclosed in braces { }. Settings Scheme Vectors of flags take a variable length, and are stored as Settings Scheme vector<bool>. The shorthand notation fvec is used in the C++ code and XML tags. When the vector is input as a string it should be given as a comma-separated list, either containing no blanks or else enclosed in braces { }. Settings Scheme Vectors of modes take a variable length, and are stored as Settings Scheme vector<int>. The shorthand notation mvec is used in the C++ code and XML tags. When the vector is input as a string it should be given as a comma-separated list, either containing no blanks or else enclosed in braces { }. Settings Scheme Vectors of parameters take a variable length and for each element a continuum of values, and are stored as Settings Scheme vector<double>. The shorthand notation pvec is used in the C++ code and XML tag. When the vector is input as a string it should be given as a comma-separated list, either containing no blanks or else enclosed in braces { }. Settings Scheme Vectors of words take a variable length, and are stored as Settings Scheme vector<string>. The shorthand notation wvec is used in the C++ code and XML tags. When the vector is input as a string it should be given as a comma-separated list, either containing no blanks or else enclosed in braces { }. Note the special role played by the braces { } to enclose words or lists that are allowed to contain blanks and equal signs, and of commas , to separate the fields of the list, in analogy with how C++ arrays can be initialized. You should not be using these three characters for any other purposes. Input of a vector can be split across several lines, until a close brace } is found that matches the open brace {. If no such is found the program will abort, so beware. The double quotation mark &quot; is avoided since it is already used for other purposes. Also note that all shorthands have been chosen four letters long. Settings Scheme In general, each variable stored in Settings Scheme Settings is associated with four kinds of information: Settings Scheme Settings Scheme The variable name, of the form Settings Scheme class:name (or Settings Scheme file:name , usually these agree), e.g. Settings Scheme TimeShower:pTmin. The class/file part usually identifies the Settings Scheme .xml file where the variable is defined, and the part of the program where it is used, but such a connection cannot be strictly upheld, since e.g. the same variable may be used in a few different cases (even if most of them are not). Settings Scheme The default value, set in the original declaration, and intended to represent a reasonable choice. Settings Scheme The current value, which differs from the default when the user so requests. Settings Scheme An allowed range of values, represented by meaningful minimum and maximum values. This has no sense for a Settings Scheme flag , an Settings Scheme fvec a Settings Scheme word or a Settings Scheme wvec (and is not used there), is usually rather well-defined for a Settings Scheme mode or Settings Scheme mvec , but less so for a Settings Scheme parm or Settings Scheme pvec. Often the allowed range exaggerates the degree of our current knowledge, so as not to restrict too much what the user can do. One may choose not to set the lower or upper limit, in which case the range is open-ended. Settings Scheme Normally input values outside the allowed range are changed to the be at nearest limit. For Settings Scheme mode s only, a further boolean is stored to tell whether this should be allowed, or whether out-of-range inputs should be forbidden, to the extent that the whole PYTHIA initialization would abort. The latter applies to those modes that have been defined with the Settings Scheme modepick label in the Settings Scheme xmldoc/*.xml files, and where maximal and minimal values have been specified. Such labels are used to represent a discrete set of options, and so any value outside the allowed range is just plain wrong. Also attempts to change Settings Scheme modefix fixed-value Settings Scheme mode s lead to aborts. By contrast those defined with Settings Scheme mode or Settings Scheme modeopen follow the normal rules of being reset to fall into the allowed range, without any warnings. Settings Scheme Technically, the Settings Scheme Settings class is implemented with the help of eight separate maps, one for each kind of variable, with the variable Settings Scheme name used as key. Settings Scheme Operation The normal flow of setting values is: Settings Scheme Settings Scheme Settings Scheme When a Settings Scheme Pythia object Settings Scheme pythia is created, the member Settings Scheme pythia.settings is asked to scan the files listed in the Settings Scheme Index.xml file in the Settings Scheme xmldoc subdirectory. Settings Scheme In all of the files scanned, lines beginning with Settings Scheme <flag , Settings Scheme <mode , Settings Scheme <parm , Settings Scheme <word , Settings Scheme <fvec , Settings Scheme <mvec , Settings Scheme <pvec or Settings Scheme <wvec are identified, and the information on such a line is used to define a new flag, mode, parameter, word, or vector of flags, modes or parameters. To exemplify, consider a line Settings Scheme <parm name='TimeShower:pTmin' default='0.5' min='0.1' max='2.0'> which appears in the Settings Scheme TimeShower.xml file, and there defines a parameter Settings Scheme TimeShower:pTmin with default value 0.5 GeV and allowed variation in the range 0.1 - 2.0 GeV. The min and max values are optional. Settings Scheme Important: the values in the Settings Scheme .xml files should not be changed, except by the PYTHIA authors. Any changes should be done with the help of the methods described below. Settings Scheme Settings Scheme Between the creation of the Settings Scheme Pythia object and the Settings Scheme init call for it, you may use several alternative methods to modify some of the default values. The same variable can be changed several times. If so, it is the last read value that counts. The two special Settings Scheme Settings Scheme Tune:ee and Settings Scheme Settings Scheme Tune:pp modes and the Settings Scheme Settings Scheme Print:quiet flag are expanded to change several settings in one go, but these obey the same ordering rules. Settings Scheme a) Inside your main program you can directly set values with Settings Scheme pythia.readString(string) where both the variable name and the value are contained inside the character string, separated by blanks and/or a =, e.g. Settings Scheme pythia.readString('TimeShower:pTmin = 1.0'); The match of the name to the database is case-insensitive. Names that do not match an existing variable are ignored. A warning is printed, however. Strings beginning with a non-alphanumeric character, like # or !, are assumed to be comments and are not processed at all. Values below the minimum or above the maximum are set at the respective border. In extreme cases, where it is necessary to go outside the allowed range, ' Settings Scheme FORCE= ' can replace the normal ' Settings Scheme = ' separator to force the requested value, at own responsibility. For Settings Scheme bool values, the following notation may be used interchangeably: Settings Scheme true = on = yes = ok = 1 , while everything else gives Settings Scheme false (including but not limited to Settings Scheme false , Settings Scheme off , Settings Scheme no and 0). Settings Scheme Settings Scheme b) The Settings Scheme Pythia Settings Scheme readString(string) method actually does not do changes itself, but sends on the string either to the Settings Scheme Settings class or to Settings Scheme ParticleData. The former holds if the string begins with a letter, the latter if it begins with a digit. (The exception is if an input list has been begun by an open brace { but no matching close brace } was present; then all subsequent non-empty input is directed to Settings Scheme Settings until the close brace is found.) If desired, it is possible to communicate directly with the corresponding Settings Scheme Settings method: Settings Scheme pythia.settings.readString('TimeShower:pTmin = 1.0'); In this case, changes intended for Settings Scheme ParticleData would not be understood. Settings Scheme c) Underlying the Settings Scheme settings.readString(string) method are the settings-type-sensitive commands in the Settings Scheme Settings , that are split by names containing Settings Scheme flag , Settings Scheme mode , Settings Scheme parm or Settings Scheme word. Thus, the example now reads Settings Scheme pythia.settings.parm('TimeShower:pTmin', 1.0); Such a form could be convenient e.g. if a parameter is calculated at the beginning of the main program, and thus is available as a variable rather than as a character string. Note that Boolean values must here be given as Settings Scheme true or Settings Scheme false i.e. there is less flexibility than with the previous methods. Settings Scheme At the same level, there are several different methods available. These are included in the full description below, but normally the user should have no need for them. Settings Scheme d) A simpler and more useful way is to collect all your changes in a separate file, with one line per change, e.g. Settings Scheme TimeShower:pTmin = 1.0 Each line is read in as a string and processed with the methods already introduced.  The file can be read by the Settings Scheme pythia.readFile(fileName); method (or an Settings Scheme istream instead of a Settings Scheme fileName ). The file can freely mix commands to the Settings Scheme Settings and Settings Scheme ParticleData classes, and so is preferable. Lines with settings are handled by calls to the Settings Scheme pythia.settings.readString(string) method. Settings Scheme A file can make use of two extra features that are not available with the Settings Scheme readString(...) method. One is the possibility to provide information for several distinct Settings Scheme subruns. The other is the possibility to comment out a section of lines in the file. The first line of the commented section should then begin by Settings Scheme /* and the last begin by Settings Scheme */. This is reminiscent of the convention used in C++ and other languages, but is not as powerful, in that it is not possible to comment in or out parts of lines. It is only the first two non-blank characters of a line that are checked for a match, and a line beginning with Settings Scheme */ is counted as part of the commented section. To avoid mistakes it is best to keep Settings Scheme /* and Settings Scheme */ on lines of their own, optionally followed by comments, but not by commands. Settings Scheme Settings Scheme In the Settings Scheme pythia.init() call, many of the various other program elements are initialized, making use of the current values in the database. Once initialized, the common Settings Scheme Settings database is likely not consulted again by these routines. It is therefore not productive to do further changes in mid-run: at best nothing changes, at worst you may set up inconsistencies. Settings Scheme A routine Settings Scheme reInit(fileName) is provided, and can be used to zero all the maps and reinitialize them from scratch. Such a call might be useful if several subruns are to be made with widely different parameter sets - normally the maps are only built from scratch once, namely when the Settings Scheme Pythia() object is created. A more economical alternative is offered by Settings Scheme resetAll() , however, which sets all variables back to their default values. Settings Scheme Settings Scheme You may at any time obtain a listing of all variables in the database by calling Settings Scheme pythia.settings.listAll(); The listing is strictly alphabetical, which at least means that names from the same file are kept together, but otherwise may not be so well-structured: important and unimportant ones will appear mixed. A more relevant alternative is Settings Scheme pythia.settings.listChanged(); where you will only get those variables that differ from their defaults. Or you can use Settings Scheme pythia.settings.list('string'); where only those variables with names that contain the string (case-insensitive match) are listed. Thus, with a string Settings Scheme shower , the shower-related variables would be shown. Settings Scheme The method Settings Scheme pythia.settings.output(key) can return the value of a variable as a string, convenient for output. In a Settings Scheme readString or Settings Scheme readFile command, the construction Settings Scheme key =? will echo back the variable and its value, using this method. Settings Scheme Settings Scheme The above listings are in a tabular form that cannot be read back in. Assuming you want to save all changed settings (maybe because you read in changes from several files), you can do that by calling Settings Scheme pythia.settings.writeFile(fileName); This file could then directly be read in by Settings Scheme readFile(fileName) in a subsequent (identical) run. Some variants of this command are listed below. Settings Scheme Settings Scheme Settings Scheme The public methods The complete list of methods and arguments is as follows. Most of the ones of interest to the user have already been mentioned above. Others can be used, but the same functionality is better achieved by higher-level routines. Some are part of the internal machinery, and should not be touched by user. Settings Scheme Note that there is no Settings Scheme Settings::readFile(...) method. The intention is that you should use Settings Scheme Pythia::readFile(...). It parses and decides which individual lines should be sent on to Settings Scheme Settings::readString(...)."},{"name":"Simple Showers","link":"SimpleShowers.html","text":"Simple Showers Simple Showers The Simple Shower Simple Showers Introduction Up until the end of the PYTHIA 8.2 version these simple shower codes were the only ones distributed as part of the PYTHIA package. They were originally only called Simple Showers TimeShower and Simple Showers SpaceShower , with no further qualification necessary. In version 8.240 (December 2018) a transformation was begun where this physics code was transferred to Simple Showers SimpleTimeShower and Simple Showers SimpleSpaceShower , while Simple Showers TimeShower and Simple Showers SpaceShower remained as bare-bones base classes. This paved the way for the inclusion of the VINCIA and Dire showers as core parts of the PYTHIA 8.3 distribution. Simple Showers The prepending of 'simple' was a minimalistic choice under the circumstances; more fancy names could have been chosen. What it refers to is that showers like VINCIA and Dire aim higher, in striving to achieve full NLL accuracy, whereas the simple ones operate in an improved LL approximation. In other respects the simple showers can do more different physics than the other two, at least currently. Some examples of the broad approach are Simple Showers Simple Showers Matrix elements corrections for the first ('hardest') gluon emission in most two-body resonance decays, effectively making the FSR in these decays NLO accurate. Simple Showers There is no corresponding NLO accuracy for ISR in any processes, but several examples where reasonably accurate kinematics spectra are available over the full phase space, by input of partial higher-order information. Simple Showers The default dipole-recoil scheme for FSR can be switched to a global-recoil option for the first few emissions, in order to simplify matching and merging to higher-order calculations (e.g. as done in MadGraph_aMC\@NLO). Simple Showers The default global-recoil scheme for ISR can be replaced by a dipole-recoil scheme, where the other colour dipole end may be in the final state (as needed e.g. for DIS studies). Simple Showers Showers off massive objects, within and beyond the Standard Model, including e.g. octet onium states. Simple Showers Showers interleaved with multiparton interactions, and set up to handle Simple Showers two predefined hard interactions. Simple Showers QED showers, where photons can be emitted and then branch into fermion pairs that shower further. Simple Showers Weak radiation of Simple Showers W^+- and Simple Showers Z^0 off fermions. Simple Showers Radiation also in some hadronic decays. Simple Showers Possibility to handle both abelian and nonabelian showers in a hidden valley sector, where relevant fully interleaved with normal QCD and QED radiation. Simple Showers A wide selection of further switches and parameters to vary shower assumptions: running of Simple Showers alpha_s , Simple Showers p_Tmin value, scale choices, gluon polarization effects, mass effects in Simple Showers g &rarr; q qbar , etc. Simple Showers Most existing tunes to LEP and LHC data are based on this choice of showers. Simple Showers When the Simple Showers Time/SpaceShower became Simple Showers SimpleTime/SpaceShower the related settings names were retained, for reasons of backwards compatibility of user code, e.g. in command files. Thus shower setting names beginning with Simple Showers TimeShower: , Simple Showers SpaceShower: , Simple Showers WeakShower: , Simple Showers UncertaintyBands: or Simple Showers HiddenValley: refer to the current baseline 'simple' showers. Simple Showers Shower components The Simple Showers Master Switches for ISR and FSR in general, and a switch for QED radiation in Simple Showers Particle Decays to leptons, are intended to be common for all shower programs, where applicable. Simple Showers The full description of settings in the Simple Shower framework is spread across several pages: Simple Showers Simple Showers The final-state Simple Showers Timelike Showers cover all aspects of QCD and QED FSR. Simple Showers The initial-state Simple Showers Spacelike Showers cover all aspects of QCD and QED ISR. Simple Showers While the main switches for weak radiation of Simple Showers W^+- and Simple Showers Z^0 are found in the two previous FSR and ISR pages, there also a few common technical Simple Showers Weak Showers settings. Simple Showers There is a special framework to produce uncertainty bands from Simple Showers Automated Variations of basic parameters, such as factorization and renormalization scales, or choice of parton distributions. Simple Showers The settings for final-state showers in a Simple Showers Hidden Valleys are stored along with the switches for such hard processes. Simple Showers There is a wide selection of Simple Showers Matching and Merging approaches that have been implemented so as to work well with these showers. Simple Showers Tunes that include ISR and FSR parameters are described on the Simple Showers Tunes page. Simple Showers The shower evolution can be interrupted or modified with the help of Simple Showers User Hooks."},{"name":"Spacelike Showers","link":"SpacelikeShowers.html","text":"Spacelike Showers Spacelike Showers Spacelike Showers The PYTHIA algorithm for spacelike initial-state showers is based on the article Spacelike Showers Sjo05 , where a transverse-momentum-ordered backwards evolution scheme is introduced, with the extension to fully interleaved evolution covered in Spacelike Showers Cor10a. This algorithm is a further development of the virtuality-ordered one presented in Spacelike Showers Sjo85 , with matching to first-order matrix element for Spacelike Showers Z^0 , Spacelike Showers W^+- and Higgs (in the Spacelike Showers m_t &rarr; infinity limit) production as introduced in Spacelike Showers Miu99. Spacelike Showers The normal user is not expected to call Spacelike Showers SpaceShower directly, but only have it called from Spacelike Showers Pythia , via Spacelike Showers PartonLevel. Nonetheless, some of the parameters below, in particular Spacelike Showers SpaceShower:alphaSvalue , would be of interest for uncertainty estimates and tuning exercises. Note that PYTHIA also incorporates an Spacelike Showers automated framework for shower uncertainty variations. Spacelike Showers Main variables The maximum Spacelike Showers pT to be allowed in the shower evolution is related to the nature of the hard process itself. It involves a delicate balance between not double-counting and not leaving any gaps in the coverage. The best procedure may depend on information only the user has: how the events were generated and mixed (e.g. with Les Houches Accord external input), and how they are intended to be used. Therefore a few options are available, with a sensible default behaviour. Spacelike Showers The amount of QCD radiation in the shower is determined by Spacelike Showers The actual value is then regulated by the running to the scale Spacelike Showers pT^2 , at which it is evaluated Spacelike Showers The CMW rescaling of Spacelike Showers Lambda_QCD (see the section on Spacelike Showers StandardModelParameters ) can be applied to the Spacelike Showers alpha_strong values used for spacelike showers. Note that tunes using this option need lower values of Spacelike Showers alpha_strong(m_Z^2) than tunes that do not. Spacelike Showers QED radiation is regulated by the Spacelike Showers alpha_electromagnetic value at the Spacelike Showers pT^2 scale of a branching. Spacelike Showers The natural scale for couplings and PDFs is Spacelike Showers pT^2. To explore uncertainties it is possibly to vary around this value, however, in analogy with what can be done for Spacelike Showers hard processes. (Note that there is also an Spacelike Showers automated framework for shower uncertainties.) Spacelike Showers There are two complementary ways of regularizing the small- Spacelike Showers pT divergence, a sharp cutoff and a smooth dampening. These can be combined as desired but it makes sense to coordinate with how the same issue is handled in multiparton interactions. Spacelike Showers The actual Spacelike Showers pT0 parameter used at a given CM energy scale, Spacelike Showers ecmNow , is obtained from a power law or a logarithmic parametrization. The former is default with hadron beams and the latter for photon-photon collisions. Spacelike Showers Dipole showers By default the recoil of an ISR emission is taken by the whole final state. The option below gives an alternative approach with local recoils, where only one final-state parton takes the recoil of an emission. See Spacelike Showers Cab17 for further details on the philosophy and implementation. Spacelike Showers The existing initial-initial global recoil scheme is maintained for an emission off a colour line that stretches through the hard process, so it is the handling of initial-final dipole ends that is changed. Here the single recoiler is picked based on the colour flow of the hard process. Additionally the description unifies the emission of a gluon from the initial-final and final-initial dipole ends, and handles both as part of the ISR framework. Therefore the separation into ISR and FSR is not a meaningful classification, and either both should be simulated or none. Spacelike Showers Note that this option should not be combined with the global option for FSR, Spacelike Showers TimeShower:globalRecoil. Furthermore some settings are neglected internally to ensure the same behaviour as obtained for Spacelike Showers TimeShower:allowBeamRecoil = on , Spacelike Showers TimeShower:dampenBeamRecoil = off , and Spacelike Showers SpaceShower:phiIntAsym = off. Spacelike Showers The dipole recoil option for the first time allows the simulation of Deeply Inelastic Scattering processes in PYTHIA 8, see the Spacelike Showers main36.cc example. Note that the simultaneous emission of photons off the lepton leg has not yet been implemented, so you need to set Spacelike Showers PDF:lepton = off and Spacelike Showers TimeShower:QEDshowerByL = off. You are further recommended to set Spacelike Showers SpaceShower:pTmaxMatch = 2 to fill the whole phase space with parton showers. This is allowed since the shower and matrix-element behaviours match well over the whole phase space (at least for the first emission). Spacelike Showers Weak showers The emission of weak gauge bosons is an integrated part of the initial- and final-state radiation, see Spacelike Showers Weak Showers. The following settings are those specifically related to the initial-state weak radiation, while common settings are found in the Spacelike Showers Weak Showers description. Spacelike Showers Further variables These should normally not be touched. Their only function is for cross-checks. Spacelike Showers There are three flags you can use to switch on or off selected branchings in the shower: Spacelike Showers There are some further possibilities to modify the shower: Spacelike Showers Technical notes Almost everything is equivalent to the algorithm in Spacelike Showers Sjo05,Cor10a. Minor changes are as follows. Spacelike Showers Spacelike Showers It is now possible to have a second-order running Spacelike Showers alpha_s , in addition to fixed or first-order running. Spacelike Showers The description of heavy flavour production in the threshold region has been modified, so as to be more forgiving about mismatches between the Spacelike Showers c/b masses used in Pythia relative to those used in a respective PDF parametrization. The basic idea is that, in the threshold region of a heavy quark Spacelike Showers Q , Spacelike Showers Q = c/b , the effect of subsequent Spacelike Showers Q &rarr; Q g branchings is negligible. If so, then Spacelike Showers f_Q(x, pT2) = integral_mQ2^pT2  dpT'2/pT'2 * alpha_s(pT'2)/2pi     * integral P(z) g(x', pT'2) delta(x - z x') so use this to select the Spacelike Showers pT2 of the Spacelike Showers g &rarr; Q Qbar branching. In the old formalism the same kind of behaviour should be obtained, but by a cancellation of a Spacelike Showers 1/f_Q that diverges at the threshold and a Sudakov that vanishes. Spacelike Showers The strategy therefore is that, once Spacelike Showers pT2 < f * mQ2 , with Spacelike Showers f a parameter of the order of 2, a Spacelike Showers pT2 is chosen like Spacelike Showers dpT2/pT2 between Spacelike Showers mQ2 and Spacelike Showers f * mQ2 , a nd a Spacelike Showers z flat in the allowed range. Thereafter acceptance is based on the product of three factors, representing the running of Spacelike Showers alpha_strong , the splitting kernel (including the mass term) and the gluon density weight. At failure, a new Spacelike Showers pT2 is chosen in the same  range, i.e. is not required to be lower since no Sudakov is involved. Spacelike Showers The QED algorithm now allows for hadron beams with non-zero photon content. The backwards-evolution of a photon in a hadron is identical to that of a gluon, with Spacelike Showers CF &rarr; eq^2 and Spacelike Showers CA &rarr; 0. Note that this will only work in conjunction with parton distributions that explicitly include photons as part of the hadron structure, such as the NNPDF2.3 QCD+QED sets. The possibility of a fermion backwards-evolving to a photon has not yet been included, nor has photon backwards-evolution in lepton beams."},{"name":"Standard-Model Parameters","link":"StandardModelParameters.html","text":"Standard-Model Parameters Standard-Model Parameters Standard-Model Parameters Standard-Model Parameters The strong coupling The Standard-Model Parameters AlphaStrong class is used to provide a first- or second-order running Standard-Model Parameters alpha_strong (or, trivially, a zeroth-order fixed one). Formulae are the standard ones found in Standard-Model Parameters Yao06. The second-order expression used, eq. (9.5), may be somewhat different in other approaches (with differences formally of higher order), so do not necessarily expect perfect agreement, especially not at small Standard-Model Parameters Q^2 scales. The starting Standard-Model Parameters alpha_strong value is defined at the Standard-Model Parameters M_Z mass scale. The Standard-Model Parameters Lambda values are matched at the Standard-Model Parameters c , Standard-Model Parameters b and Standard-Model Parameters t flavour thresholds, such that Standard-Model Parameters alpha_strong is continuous. For second-order matching an approximate iterative method is used. Standard-Model Parameters For backwards compatibility, the following global switch determines whether 5- or 6-flavour running will be used above the Standard-Model Parameters t threshold: Standard-Model Parameters Since we allow Standard-Model Parameters alpha_strong to vary separately for hard processes, timelike showers, spacelike showers and  multiparton interactions, all other relevant values are set in each of these classes. The default behaviour is everywhere first-order running. Standard-Model Parameters The Standard-Model Parameters alpha_strong calculation is initialized by Standard-Model Parameters init( value, order, nfmax) , where Standard-Model Parameters value is the Standard-Model Parameters alpha_strong value at Standard-Model Parameters M_Z , Standard-Model Parameters order is the order of the running, 0, 1 or 2, and Standard-Model Parameters nfmax is the highest number of flavours to include in the running. Thereafter the value can be calculated by Standard-Model Parameters alphaS(scale2) , where Standard-Model Parameters scale2 is the Standard-Model Parameters Q^2 scale in GeV^2. Standard-Model Parameters By default the charm, bottom and top threshold-matching mass values are chosen to be 1.5, 4.8 and 171 GeV, respectively. The Standard-Model Parameters setThresholds(double mc, double mb, double mt) method can be invoked to select other values. To take effect, this must be done before the Standard-Model Parameters AlphaStrong::init() method is called, since this is where the flavour-dependent Standard-Model Parameters Lambda_i values are calculated and stored. If in doubt, better call it once again. Standard-Model Parameters For applications inside shower programs, a second-order Standard-Model Parameters alpha_s value can be obtained as the product of the two functions Standard-Model Parameters alphaS1Ord(scale2) and Standard-Model Parameters alphaS2OrdCorr(scale2) , where the first gives a simple first-order running (but with the second-order Standard-Model Parameters Lambda ) and the second the correction factor, below unity, for the second-order terms. This allows a compact handling of evolution equations. Standard-Model Parameters Resummation arguments Standard-Model Parameters Cat91 show that a set of universal QCD corrections can be absorbed in coherent parton showers by applying the so-called CMW rescaling of the MSbar value of Standard-Model Parameters Lambda_QCD. This can be accomplished via a fourth (optional) boolean argument to Standard-Model Parameters init( value, order, nfmax, useCMW) , with default value Standard-Model Parameters useCMW = false. When set to Standard-Model Parameters true , the translation amounts to an Standard-Model Parameters N_F -dependent rescaling of Standard-Model Parameters Lambda_QCD , relative to its MSbar value, by a factor 1.661 for NF=3, 1.618 for NF=4, 1.569 for NF=5, and 1.513 for NF=6. When using this option, be aware that the original CMW arguments were derived using two-loop running and that the CMW rescaling may need be taken into account in the context of matrix-element matching. Note also that this option has only been made available for timelike and spacelike showers, not for hard processes. Standard-Model Parameters The electromagnetic coupling The Standard-Model Parameters AlphaEM class is used to generate a running Standard-Model Parameters alpha_em. The input Standard-Model Parameters StandardModel:alphaEMmZ value at the Standard-Model Parameters M_Z mass is matched to a low-energy behaviour with running starting at the electron mass threshold. The matching is done by fitting an effective running coefficient in the region between the light-quark threshold and the charm/tau threshold. This procedure is approximate, but good enough for our purposes. Standard-Model Parameters Since we allow Standard-Model Parameters alpha_em to vary separately for hard processes, timelike showers, spacelike showers and  multiparton interactions, the choice between using a fixed or a running Standard-Model Parameters alpha_em can be made in each of these classes. The default behaviour is everywhere first-order running. The actual values assumed at zero momentum transfer and at Standard-Model Parameters M_Z are only set here, however. Standard-Model Parameters The Standard-Model Parameters alpha_em calculation is initialized by Standard-Model Parameters init(order) , where Standard-Model Parameters order is the order of the running, 0 or 1, with -1 a special option to use the fix value provided at Standard-Model Parameters M_Z.   Thereafter the value can be calculated by Standard-Model Parameters alphaEM(scale2) , where Standard-Model Parameters scale2 is the Standard-Model Parameters Q^2 scale in GeV^2. Standard-Model Parameters The electroweak couplings There are two degrees of freedom that can be set, related to the electroweak mixing angle: Standard-Model Parameters The Fermi constant is not much used in the currently coded matrix elements, since it is redundant, but it is available: Standard-Model Parameters The quark weak-mixing matrix The absolute values of the Cabibbo-Kobayashi-Maskawa matrix elements are set by the following nine real values taken from Standard-Model Parameters Yao06 - currently the CP-violating phase is not taken into account in this parametrization. It is up to the user to pick a consistent unitary set of new values whenever changes are made. Standard-Model Parameters The CoupSM class The Standard-Model Parameters Standard-Model Parameters Pythia class contains a public instance Standard-Model Parameters coupSM of the Standard-Model Parameters CoupSM class. This class contains one instance each of the Standard-Model Parameters AlphaStrong and Standard-Model Parameters AlphaEM classes, and additionally stores the weak couplings and the quark mixing matrix mentioned above. This class is used especially in the calculation of cross sections and resonance widths, but could also be used elsewhere. Specifically, as already mentioned, there are separate Standard-Model Parameters AlphaStrong and Standard-Model Parameters AlphaEM instances for timelike and spacelike showers and for multiparton interactions, while weak couplings and the quark mixing matrix are only stored here. With the exception of the first two methods below, which are for internal use, the subsequent ones could also be used externally."},{"name":"SUSY Les Houches Accord","link":"SUSYLesHouchesAccord.html","text":"SUSY Les Houches Accord SUSY Les Houches Accord SUSY Les Houches Accord The PYTHIA 8 program does not contain an internal spectrum calculator (a.k.a. RGE package) to provide supersymmetric couplings, mixing angles, masses and branching ratios. Thus the SUSY Les Houches Accord (SLHA) SUSY Les Houches Accord Ska04 SUSY Les Houches Accord All08 is the only way of inputting SUSY models, and SUSY processes (see the SUSY Les Houches Accord SUSYProcesses page) cannot be run unless such an input has taken place. SUSY Les Houches Accord The SLHA input format can also be extended for use with more general BSM models, beyond SUSY. Information specific to  how to use the SLHA interface for generic BSM models is collected below, under SUSY Les Houches Accord Using SLHA for generic BSM Models , with more elaborate explanations and examples in SUSY Les Houches Accord Des11. SUSY Les Houches Accord Most of the SUSY implementation in PYTHIA 8 is compatible with both the SLHA1 SUSY Les Houches Accord Ska04 and SLHA2 SUSY Les Houches Accord All08 conventions (with some limitations for the NMSSM in the latter case). Internally, PYTHIA 8 uses the SLHA2 conventions and translates SLHA1 input to these when necessary. See the section on SUSY Processes and SUSY Les Houches Accord Des11 for more information. Note that PYTHIA assumes that a spectrum is either fully SHLA1 or fully SLHA2 compliant. Mixing of the two standards is discouraged, as this can lead to ambiguities and inconsistencies. SUSY Les Houches Accord When reading LHEF files, Pythia automatically looks for SLHA information between SUSY Les Houches Accord <slha>...</slha> tags in the header of such files. When running Pythia without LHEF input (or if reading an LHEF file that does not contain SLHA information in the header), a separate file containing SLHA information may be specified using SUSY Les Houches Accord SLHA:file (see below). SUSY Les Houches Accord Normally the LHEF would be in uncompressed format, and thus human-readable if opened in a text editor. A possibility to read gzipped files has been added, based on the Boost and zlib libraries, which therefore have to be linked appropriately in order for this option to work. See the SUSY Les Houches Accord README file in the main directory for details on how to do this. SUSY Les Houches Accord Finally, the SLHA input capability can of course also be used to input SLHA-formatted SUSY Les Houches Accord MASS and SUSY Les Houches Accord DECAY tables for other particles, such as the Higgs boson, furnishing a less sophisticated but more universal complement to the standard PYTHIA 8-specific methods for inputting such information (for the latter, see the section on SUSY Les Houches Accord Particle Data and the SUSY Les Houches Accord scheme to modify it). This may at times not be desirable, so a few options can be used to curb the right of SLHA to overwrite particle data. Conversely, it is sometimes useful to allow the user to modify eg a mass parameter relative to its value in the SLHA spectrum. This is normally not permitted (the SLHA spectrum is normally self-consistent and should not be modified), but an option for allowing it is provided. SUSY Les Houches Accord The reading-in of information from SLHA or LHEF files is handled by the SUSY Les Houches Accord SusyLesHouches class, while the subsequent calculation of derived quantities of direct application to SUSY processes is done in the SUSY Les Houches Accord CoupSUSY , SUSY Les Houches Accord SigmaSUSY , and SUSY Les Houches Accord SUSYResonanceWidths classes. SUSY Les Houches Accord Sanity Checks As an aid for basic validation, some checks and ranges are imposed  on SLHA input during initialization, as follows: SUSY Les Houches Accord SUSY Les Houches Accord Several parameters ( SUSY Les Houches Accord SLHA:keepSM , SUSY Les Houches Accord minMassSM , and SUSY Les Houches Accord SLHA:allowUserOverride ) provide some safety against unintentionally overwriting PYTHIA's Standard-Model information. These parameters can be altered to hand over more or less control to the SLHA interface. In particular, a lot of mass and decay-table information may be included by default in some SLHA files, without it being the explicit intention of the user to overwrite the corresponding PYTHIA information. The default values of the SLHA safety parameters have been chosen so as to eliminate at least the most obvious causes of Garbage In Garbage Out. (E.g., there is usually no reason to modify the masses of well-measured SM particles, like the W and Z bosons, nor to replace their sophisticated internal decay treatments by the simplified isotropic treatment used for SLHA DECAY tables.) SUSY Les Houches Accord For SLHA SUSY spectra, the interface checks  the mass-ordering of the Higgs, Neutralino, and  Chargino sectors, and the unitarity/orthogonality of the mixing matrices. It also performs some additional self-consistency checks on whether the correct SLHA BLOCKs for the given SUSY model have been included, and whether all required entries have been defined. SUSY Les Houches Accord If MASS or DECAY information for a particle has been changed by SLHA input, the following sanity checks will be carried out. The particle will be declared stable unless there is at least one on-shell decay channel open (regardless of the presence of any DECAY information). In particular, massless particles will always be declared stable. A lower cutoff is imposed on the Breit-Wigner shape of the particle, requiring its mass to remain above the sum of masses for the lightest decay channel. Subject to that constraint, the SUSY Les Houches Accord mMin and SUSY Les Houches Accord mMax cutoffs will normally be placed at 5 times the width or the on-shell mass divided by two, whichever is smaller, so that the default gives a decent sampling of the shape without straying too far from the on-shell value. The user is allowed to use the SUSY Les Houches Accord mMin and SUSY Les Houches Accord mMax parameters to choose a different sampling range if so desired (still subject to the constraint of at least one decay channel remaining open for on-shell decay products). SUSY Les Houches Accord For each decay channel in an SLHA DECAY table, PYTHIA will checks the available phase space. If the channel is on shell (sum of daughter masses is less than mass of decaying particle), then the threshold dependence is given by SUSY Les Houches Accord SLHA:meMode. If the channel is off shell, then an SUSY Les Houches Accord meMode of 100 is always used. As a further protection against GIGO, if the channel appears to be physically impossible (defined as requiring fluctuations of more than more than 100 times the effective combined widths), it is switched of and a warning message is printed. SUSY Les Houches Accord DECAY table branching fractions are always interpreted as positive. However, a negative sign for one or more channels can be given, and will then be interpreted to mean that the corresponding channel(s) should be switched off for the current run. This furnishes a simple way to switch SLHA DECAY channels on and off while preserving the sum of branching fractions equal to unity. Note that these sanity checks will not catch all possible cases of Garbage In Garbage Out, so human verification of the input files is always a good idea, as is taking a look at any warnings or error messages printed by the SLHA interface during initialization. It is ultimately up to the user to ensure that sensible input is being given. SUSY Les Houches Accord SLHA Switches and Parameters SUSY Les Houches Accord SLHA DECAY Tables In addition to SUSY spectra, the SLHA also defines a set of conventions for decay tables. These are not restricted to SUSY models, but can be used for arbitrary particles, either in combination with or independently of the SUSY parts of the Accord. The settings in this section control whether and how PYTHIA will make use of such tables. See also the comments under sanity checks above. SUSY Les Houches Accord Note : the PYTHIA SLHA interface is limited to at most SUSY Les Houches Accord 1&rarr;8 decays. SUSY Les Houches Accord Internal SLHA Variables SUSY Les Houches Accord Using SLHA for generic BSM Models SUSY Les Houches Accord Using the SUSY Les Houches Accord QNUMBERS extension SUSY Les Houches Accord Alw07 , the SLHA can also be used to define new particles, with arbitrary quantum numbers. This already serves as a useful way to introduce new particles and can be combined with SUSY Les Houches Accord MASS and SUSY Les Houches Accord DECAY tables in the usual way, to generate isotropically distributed decays or even chains of such decays. (If you want something better than isotropic, sorry, you'll have to do some actual work ...) SUSY Les Houches Accord A more advanced further option is to make use of the possibility in the SLHA to include user-defined blocks with arbitrary names and contents. Obviously, standalone PYTHIA 8 does not know what to do with such information. However, it does not throw it away either, but instead stores the contents of user blocks as strings, which can be read back later, with the user having full control over the format used to read the individual entries. SUSY Les Houches Accord The contents of both standard and user-defined SLHA blocks can be accessed in any class inheriting from PYTHIA 8's SUSY Les Houches Accord SigmaProcess class (i.e., in particular, from any semi-internal process written by a user), through its SLHA pointer, SUSY Les Houches Accord slhaPtr , by using the following methods: SUSY Les Houches Accord bool slhaPtr->getEntry(string blockName, double& val); bool slhaPtr->getEntry(string blockName, int indx, double& val); bool slhaPtr->getEntry(string blockName, int indx, int jndx, double& val); bool slhaPtr->getEntry(string blockName, int indx, int jndx, int kndx, double& val); SUSY Les Houches Accord This particular example assumes that the user wants to read the entries (without index, indexed, matrix-indexed, or 3-tensor-indexed, respectively) in the user-defined block SUSY Les Houches Accord blockName , and that it should be interpreted as a SUSY Les Houches Accord double. The last argument is templated, and hence if anything other than a SUSY Les Houches Accord double is desired to be read, the user has only to give the last argument a different type. If anything went wrong (i.e., the block doesn't exist, or it doesn't have an entry with that index, or that entry can't be read as a double), the method returns false; true otherwise. This effectively allows to input completely arbitrary parameters using the SLHA machinery, with the user having full control over names and conventions. Of course, it is then the user's responsibility to ensure complete consistency between the names and conventions used in the SLHA input, and those assumed in any user-written semi-internal process code. SUSY Les Houches Accord Note that PYTHIA 8 always initializes at least the SLHA blocks MASS and SMINPUTS, starting from its internal SM parameters and particle data table values (updated to take into account user modifications). These blocks can therefore be accessed using the SUSY Les Houches Accord slhaPtr->getEntry() methods even in the absence of SLHA input. Note: in the SMINPUTS block, PYTHIA outputs physically correct (i.e., measured) values of SUSY Les Houches Accord GF , SUSY Les Houches Accord m_Z , and SUSY Les Houches Accord alpha_EM(m_Z). However, if one attempts to compute, e.g., the W mass, at one loop from these quantities, a value of 79 GeV results, with a corresponding value for the weak mixing angle. We advise to instead take the physically measured W mass from block MASS, and recompute the EW parameters as best suited for the application at hand."},{"name":"SUSY Processes","link":"SUSYProcesses.html","text":"SUSY Processes SUSY Processes SUSY SUSY Processes Here is collected processes involving supersymmetric particle production, with the exception of the (extended) Higgs sector. Since the number of separate but closely related processes is so big, there will not be switches for each separate process but only for a reasonable set of subgroups. However, the general switches SUSY Processes SUSY:idA and SUSY Processes SUSY:idB ,valternatively vectors SUSY Processes SUSY:idVecA and SUSY Processes SUSY:idVecB , may be used in conjunction with any of these groups to provide some additional flexibility to concentrate on processes involving only specific (s)particle final states, see below. SUSY Processes Most of the SUSY implementation in PYTHIA 8 has been written by N. Desai and is documented in SUSY Processes Des11. Please give due credit to external contributions to PYTHIA 8, such as this one, by including the original work in your list of references when using this implementation. The cross section formulae are mostly taken from SUSY Processes Boz07 and SUSY Processes Fuk11. SUSY Processes Since the implementation of SUSY processes was only recently completed SUSY Processes Des11 , case-by-case validations against other codes are still recommended. A set of default validations have already been carried out by the authors, comparing to the PYTHIA 6 SUSY implementation and to the XSUSY code, using an sps1a spectrum. Explicit validations of the non-trivial SLHA2-specific extensions have generally not been carried out yet, with the exception of the R-parity violating single-sparticle production cross sections. Please report the results of any user validations you may carry out to the authors. SUSY Processes Important Note on SLHA: In order to simulate SUSY processes it is required to read in the couplings and masses relevant for the scenario to be studied. This is done with the help of the SUSY Les Houches Accord (SLHA), including the SLHA2 extensions and generalizations. (Internally, the SLHA2 conventions are used. SLHA1 spectra are automatically translated into SLHA2 notation during initialization.) The reading of a relevant SLHA file SUSY Processes must be set up, as described on SUSY Processes the SLHA page. Attempting to generate SUSY processes without a properly initialized SLHA spectrum is strongly discouraged and may lead to unexpected results. Always check for warnings and errors reported by the SLHA reader during the initialization stage. SUSY Processes SUSY Processes SUSY Processes Note 1: Decays of SUSY particles are described separately SUSY Processes below. SUSY Processes Note 2: One special possibility is that the gluino or some squark(s) are sufficiently long-lived to hadronize. See SUSY Processes the R-hadrons page for further details. SUSY Processes Note 3: lepton- and photon-initial states are not yet available. Only quark/gluon-initiated SUSY Processes 2 &rarr; 2 and SUSY Processes 2 &rarr; 1 (RPV) processes have been implemented. SUSY Processes Note 4: cross sections will be correctly folded with open branching fractions of cascade decays, but at present any difference between particle and antiparticle decay tables is not taken into account. This possibility will be included in a future update. SUSY Processes Gluino Pair Production SUSY Processes Associated Squark-Gluino Production SUSY Processes Squark Pair Production SUSY Processes Neutralino and Chargino Pair Production SUSY Processes Associated Neutralino/Chargino + Squark/Gluino Production SUSY Processes Slepton Production SUSY Processes R-parity violating squark production SUSY Processes Decays of SUSY Particles Based on the parameters read in from the SLHA, PYTHIA 8 will normally compute the decay modes of SUSY particles automatically, using the SUSY Processes SusyResonanceDecays class(es). Essentially all tree-level 2-body decays in the MSSM have been implemented this way, excepting so far only those involving Higgs bosons (either in the in- or out-state) or gravitinos. Available channels so far include: SUSY Processes SUSY Processes ~q &rarr; q + ~chi SUSY Processes ~q &rarr; ~q + W/Z SUSY Processes ~q &rarr; q + q (RPV UDD) SUSY Processes ~q &rarr; l + q (RPV LQD) SUSY Processes ~g &rarr; ~q + q SUSY Processes ~chi &rarr; ~chi + Z/W SUSY Processes ~chi &rarr; ~q + q SUSY Processes ~chi &rarr; ~l/~nu + l/nu SUSY Processes ~chi0 &rarr; q + q + q (RPV UDD) SUSY Processes ~l/~nu &rarr; l/nu + ~chi SUSY Processes ~l/~nu &rarr; ~l/~nu + W/Z All channels are still undergoing validation, so this implementation should be considered preliminary. Still missing but to be included in a forthcoming update are: 3-body decays of charginos (via RPV), and 2-body decays of squarks and gauginos with Higgs as one of the decay products.  Some 3-body decays have been implemented with Matrix Element weighting. In particular, those for a neutralino to a lighter neutralino and a fermion pair can be enabled."},{"name":"Timelike Showers","link":"TimelikeShowers.html","text":"Timelike Showers Timelike Showers Timelike Showers The PYTHIA algorithm for timelike final-state showers is based on the article Timelike Showers Sjo05 , where a transverse-momentum-ordered evolution scheme is introduced, with the extension to fully interleaved evolution covered in Timelike Showers Cor10a. This algorithm is influenced by the previous mass-ordered algorithm in PYTHIA Timelike Showers Ben87 and by the dipole-emission formulation in Ariadne Timelike Showers Gus86. From the mass-ordered algorithm it inherits a merging procedure for first-order gluon-emission matrix elements in essentially all two-body decays in the standard model and its minimal supersymmetric extension Timelike Showers Nor01. Timelike Showers The normal user is not expected to call Timelike Showers TimeShower directly, but only have it called from Timelike Showers Pythia. Nonetheless, some of the parameters below, in particular Timelike Showers TimeShower:alphaSvalue , would be of interest for uncertainty estimates and tuning exercises. Note that PYTHIA also incorporates an Timelike Showers automated framework for shower uncertainty variations. Timelike Showers Main variables Often the maximum scale of the FSR shower evolution is understood from the context. For instance, in a resonance decay half the resonance mass sets an absolute upper limit. For a hard process in a hadronic collision the choice is not as unique. Here the Timelike Showers factorization scale has been chosen as the maximum evolution scale. This would be the Timelike Showers pT for a Timelike Showers 2 &rarr; 2 process, supplemented by mass terms for massive outgoing particles. For some special applications we do allow an alternative. Timelike Showers The amount of QCD radiation in the shower is determined by Timelike Showers The actual value is then regulated by the running to the scale Timelike Showers pT^2 , at which the shower evaluates Timelike Showers alpha_strong. Timelike Showers The CMW rescaling of Timelike Showers Lambda_QCD (see the section on Timelike Showers StandardModelParameters ) can be applied to the Timelike Showers alpha_strong values used for timelike showers. Note that tunes using this option need lower values of Timelike Showers alpha_strong(m_Z^2) than tunes that do not. Timelike Showers QED radiation is regulated by the Timelike Showers alpha_electromagnetic value at the Timelike Showers pT^2 scale of a branching. Timelike Showers The natural scale for couplings, and PDFs for dipoles stretching out to the beam remnants, is Timelike Showers pT^2. To explore uncertainties it is possibly to vary around this value, however, in analogy with what can be done for Timelike Showers hard processes. (Note that there is also an Timelike Showers automated framework for shower uncertainties.) Timelike Showers The rate of radiation if divergent in the Timelike Showers pT &rarr; 0 limit. Here, however, perturbation theory is expected to break down. Therefore an effective Timelike Showers pT_min cutoff parameter is introduced, below which no emissions are allowed. The cutoff may be different for QCD and QED radiation off quarks, and is mainly a technical parameter for QED radiation off leptons. Timelike Showers Shower branchings Timelike Showers gamma &rarr; f fbar , where Timelike Showers f is a quark or lepton, in part compete with the hard processes involving Timelike Showers gamma^*/Z^0 production. In order to avoid overlap it makes sense to correlate the maximum Timelike Showers gamma mass allowed in showers with the minimum Timelike Showers gamma^*/Z^0 mass allowed in hard processes. In addition, the shower contribution only contains the pure Timelike Showers gamma^* contribution, i.e. not the Timelike Showers Z^0 part, so the mass spectrum above 50 GeV or so would not be well described. Timelike Showers Interleaved evolution Multiparton interactions (MPI) and initial-state showers (ISR) are always interleaved, as follows. Starting from the hard interaction, the complete event is constructed by a set of steps. In each step the Timelike Showers pT scale of the previous step is used as starting scale for a downwards evolution. The MPI and ISR components each make their respective Monte Carlo choices for the next lower Timelike Showers pT value. The one with larger Timelike Showers pT is allowed to carry out its proposed action, thereby modifying the conditions for the next steps. This is relevant since the two components compete for the energy contained in the beam remnants: both an interaction and an emission take away some of the energy, leaving less for the future. The end result is a combined chain of decreasing Timelike Showers pT values, where ones associated with new interactions and ones with new emissions are interleaved. Timelike Showers There is no corresponding requirement for final-state radiation (FSR) to be interleaved. Such an FSR emission does not compete directly for beam energy (but see below), and also can be viewed as occurring after the other two components in some kind of time sense. Interleaving is allowed, however, since it can be argued that a high- Timelike Showers pT FSR occurs on shorter time scales than a low- Timelike Showers pT MPI, say. Backwards evolution of ISR is also an example that physical time is not the only possible ordering principle, but that one can work with conditional probabilities: given the partonic picture at a specific Timelike Showers pT resolution scale, what possibilities are open for a modified picture at a slightly lower Timelike Showers pT scale, either by MPI, ISR or FSR? Complete interleaving of the three components also offers advantages if one aims at matching to higher-order matrix elements above some given scale. Timelike Showers As an aside, it should be noted that such interleaving does not affect showering in resonance decays, such as a Timelike Showers Z^0. These decays are only introduced after the production process has been considered in full, and the subsequent FSR is carried out inside the resonance, with preserved resonance mass. Timelike Showers One aspect of FSR for a hard process in hadron collisions is that often colour dipoles are formed between a scattered parton and a beam remnant, or rather the hole left behind by an incoming partons. If such holes are allowed as dipole ends and take the recoil when the scattered parton undergoes a branching then this translates into the need to take some amount of remnant energy also in the case of FSR, i.e. the roles of ISR and FSR are not completely decoupled. The energy taken away is bookkept by increasing the Timelike Showers x value assigned to the incoming scattering parton, and a reweighting factor Timelike Showers x_new f(x_new, pT^2) / x_old f(x_old, pT^2) in the emission probability ensures that not unphysically large Timelike Showers x_new values are reached. Usually such Timelike Showers x changes are small, and they can be viewed as a higher-order effect beyond the accuracy of the leading-log initial-state showers. Timelike Showers This choice is not unique, however. As an alternative, if nothing else useful for cross-checks, one could imagine that the FSR is completely decoupled from the ISR and beam remnants. Timelike Showers When there is no interleaving, a number of MPIs may have been generated before FSR is considered. In principle there could be colour correlations between the MPIs, such that a final-state colour of one MPI could be matched by the corresponding final-state anticolour of another MPI. These thereby would form a colour dipole, but one that does not come out from a common vertex, and therefore presumably could not radiate in full. Currently the standard procedure is to match colours between MPIs only after FSR, so MPI systems would radiate independently, with recoils taken by the beam remnant, where necessary. This could change, however, and the following switch would then regulate the choice of behaviour. Timelike Showers Global recoil The final-state algorithm is based on dipole-style recoils, where one single parton takes the full recoil of a branching. This is unlike the initial-state algorithm, where the complete already-existing final state shares the recoil of each new emission. As an alternative, also the final-state algorithm contains an option where the recoil is shared between all partons in the final state. Thus the radiation pattern is unrelated to colour correlations. This is especially convenient for some matching algorithms, like MC\@NLO, where a full analytic knowledge of the shower radiation pattern is needed to avoid double-counting. (The Timelike Showers pT -ordered shower is described in Timelike Showers Sjo05 , and the corrections for massive radiator and recoiler in Timelike Showers Nor01 .) Timelike Showers Technically, the radiation pattern is most conveniently represented in the rest frame of the final state of the hard subprocess. Then, for each parton at a time, the rest of the final state can be viewed as a single effective parton. This 'parton' has a fixed invariant mass during the emission process, and takes the recoil without any changed direction of motion. The momenta of the individual new recoilers are then obtained by a simple common boost of the original ones. Timelike Showers This alternative approach will miss out on the colour coherence phenomena. Specifically, with the whole subcollision mass as 'dipole' mass, the phase space for subsequent emissions is larger than for the normal dipole algorithm. The phase space difference grows as more and more gluons are created, and thus leads to a way too steep multiplication of soft gluons. Therefore the main application is for the first one or few emissions of the shower, where a potential overestimate of the emission rate is to be corrected for anyway, by matching to the relevant matrix elements. Thereafter, subsequent emissions should be handled as before, i.e. with dipoles spanned between nearby partons. Furthermore, only the first (hardest) subcollision is handled with global recoils, since subsequent MPI's would not be subject to matrix element corrections anyway. Timelike Showers In order for the mid-shower switch from global to local recoils to work, colours are traced and bookkept just as for normal showers; it is only that this information is not used in those steps where a global recoil is requested. (Thus, e.g., a gluon is still bookkept as one colour and one anticolour dipole end, with half the charge each, but with global recoil those two ends radiate identically.) Timelike Showers Two variations of the scheme outlined above are also available, (motivated by comparative studies within aMC\@NLO). These studies indicate that global recoils should be used as sparsely as possible, in order to retain desirable features of the radiation pattern produced with the local recoil prescription. Timelike Showers The global-recoil machinery does not work well with rescattering in the MPI machinery, since then the recoiling system is not uniquely defined. Timelike Showers MultipartonInteractions:allowRescatter = off by default, so this is not a main issue. If both options are switched on, rescattering will only be allowed to kick in after the global recoil has ceased to be active, i.e. once the Timelike Showers nMaxGlobalRecoil limit has been exceeded. This should not be a major conflict, since rescattering is mainly of interest at later stages of the downwards Timelike Showers pT evolution. Timelike Showers Further, it is strongly recommended to set Timelike Showers TimeShower:MEcorrections = off (not default!), i.e. not to correct the emission probability to the internal matrix elements. The internal ME options do not cover any cases relevant for a multibody recoiler anyway, so no guarantees are given what prescription would come to be used. Instead, without ME corrections,  a process-independent emission rate is obtained, and Timelike Showers user hooks can provide the desired process-specific rejection factors. Timelike Showers Radiation off octet onium states In the current implementation, charmonium and bottomonium production can proceed either through colour singlet or colour octet mechanisms, both of them implemented in terms of Timelike Showers 2 &rarr; 2 hard processes such as Timelike Showers g g &rarr; (onium) g. In the former case the state does not radiate and the onium therefore is produced in isolation, up to normal underlying-event activity. In the latter case the situation is not so clear, but it is sensible to assume that a shower can evolve. (Assuming, of course, that the transverse momentum of the onium state is sufficiently high that radiation is of relevance.) Timelike Showers There could be two parts to such a shower. Firstly a gluon (or even a quark, though less likely) produced in a hard Timelike Showers 2 &rarr; 2 process can undergo showering into many gluons, whereof one branches into the heavy-quark pair. Secondly, once the pair has been produced, each quark can radiate further gluons. This latter kind of emission could easily break up a semibound quark pair, but might also create a new semibound state where before an unbound pair existed, and to some approximation these two effects should balance in the onium production rate. The showering 'off an onium state' as implemented here therefore should not be viewed as an accurate description of the emission history step by step, but rather as an effective approach to ensure that the octet onium produced 'in the hard process' is embedded in a realistic amount of jet activity. Of course both the isolated singlet and embedded octet are likely to be extremes, but hopefully the mix of the two will strike a reasonable balance. However, it is possible that some part of the octet production occurs in channels where it should not be accompanied by (hard) radiation. Therefore reducing the fraction of octet onium states allowed to radiate is a valid variation to explore uncertainties. Timelike Showers If an octet onium state is chosen to radiate, the simulation of branchings is based on the assumption that the full radiation is provided by an incoherent sum of radiation off the quark and off the antiquark of the onium state. Thus the splitting kernel is taken to be the normal Timelike Showers q &rarr; q g one, multiplied by a factor of two. Obviously this is a simplification of a more complex picture, averaging over factors pulling in different directions. Firstly, radiation off a gluon ought to be enhanced by a factor 9/4 relative to a quark rather than the 2 now used, but this is a minor difference. Secondly, our use of the Timelike Showers q &rarr; q g branching kernel is roughly equivalent to always following the harder gluon in a Timelike Showers g &rarr; g g branching. This could give us a bias towards producing too hard onia. A soft gluon would have little phase space to branch into a heavy-quark pair however, so the bias may not be as big as it would seem at first glance. Thirdly, once the gluon has branched into a quark pair, each quark carries roughly only half of the onium energy. The maximum energy per emitted gluon should then be roughly half the onium energy rather than the full, as it is now. Thereby the energy of radiated gluons is exaggerated, i.e. onia become too soft. So the second and the third points tend to cancel each other. Timelike Showers Finally, note that the lower cutoff scale of the shower evolution depends on the onium mass rather than on the quark mass, as it should be. Gluons below the octet-onium scale should only be part of the octet-to-singlet transition. Timelike Showers Weak showers The emission of weak gauge bosons is an integrated part of the initial- and final-state radiation, see Timelike Showers Weak Showers. The following settings are those specifically related to the final-state weak radiation, while common settings are found in the Timelike Showers Weak Showers description. Timelike Showers Further variables There are several possibilities you can use to switch on or off selected branching types in the shower, or in other respects simplify the shower. These should normally not be touched. Their main function is for cross-checks."},{"name":"Top Processes","link":"TopProcesses.html","text":"Top Processes Top Processes Top Processes Different ways to produce top quarks, singly or in pairs. Top Processes By default top always decays to a Top Processes W and a down-type quark. It is possible to switch on the Top Processes t &rarr; H+ b decay mode. Note that its partial width is calculated using the Top Processes tan(beta) value stored in Top Processes HiggsHchg:tanBeta , so that it can be used without having to read in a SUSY parameter file. For the Top Processes H+ to decay also Top Processes Higgs:useBSM = on is necessary."},{"name":"Total Cross Sections","link":"TotalCrossSections.html","text":"Total Cross Sections Total Cross Sections Total Cross Sections The Total Cross Sections SigmaTotal class returns the total, elastic, diffractive and nondiffractive cross sections in hadronic collisions. By implication it also has to provide differential elastic and diffractive cross sections, since many models start out from the differential expressions and then integrate to obtain more inclusive rates. In principle it would have been possible to decouple the overall normalization from the differential shape, however. Total Cross Sections The current page describes the options available for integrated and differential cross sections alike. The number of options is especially large for diffraction, reflecting the lack of a well-understood theory. Conversely, the wide spectrum of options should allow for detailed comparisons that eventually will improve our understanding. The Total Cross Sections Diffraction page contains those further parameters needed to describe the hadronization of a diffractive system, or at least those that set diffraction apart from the nondiffractive topologies. There are borderline cases, that could have been described in either place, such as the ones related to the pomeron-proton cross section, which mainly are relevant for the description of MPIs in diffractive systems, and therefore have been put on the Diffraction page. That page also contains the 'hard diffraction' framework, i.e. the modelling of diffractive events that contain a hard process. Total Cross Sections Several different parametrization options are available for Total Cross Sections p p and Total Cross Sections pbar p collisions, of special interest for hadron colliders, while the selection for other processes is considerably more limited. As a simple generalization, a neutron is assumed to have the same hadronic cross section as a proton. Total Cross Sections Historically most of the parametrizations used are from Total Cross Sections Sch94, Sch97 which borrows some of the total cross sections from Total Cross Sections Don92. A few parameters allow some possibility to vary the basic setup. The allowed combinations of incoming particles are Total Cross Sections p + p , Total Cross Sections pbar + p , Total Cross Sections pi+ + p , Total Cross Sections pi- + p , Total Cross Sections pi0/rho0 + p , Total Cross Sections phi + p , Total Cross Sections J/psi + p , Total Cross Sections rho + rho , Total Cross Sections rho + phi , Total Cross Sections rho + J/psi , Total Cross Sections phi + phi , Total Cross Sections phi + J/psi , Total Cross Sections J/psi + J/psi , Total Cross Sections Pomeron + p , Total Cross Sections gamma + gamma and Total Cross Sections gamma + p. The strong emphasis on vector mesons is related to the description of Total Cross Sections gamma + p and Total Cross Sections gamma + gamma interactions in a Vector Dominance Model framework (which is not explicitly used in the current implementation of photoproduction, but is retained for potential future applications). Total Cross Sections The other options available for total, elastic and diffractive cross sections are: Total Cross Sections Total Cross Sections A do-it-yourself selection of the main parameters. Total Cross Sections The MBR (Minimum Bias Rockefeller) model Total Cross Sections Cie12 , which is mainly intended for diffractive physics, but also parametrizes the total and elastic cross sections. Total Cross Sections The ABMST model Total Cross Sections App16 , which is based on a quite sophisticated Pomeron-inspired framework, and addresses total, elastic and single diffractive cross sections. The tuning to single diffractive data has mainly been performed at lower energies, so we also include variants that (hopefully) improves agreement with LHC data, and also introduce simple extensions to double and central diffraction. Total Cross Sections The RPP 2016 parametrization Total Cross Sections Pat16 , which is also Pomeron-inspired. It does not address diffractive cross sections. Total Cross Sections The elastic cross section is differential in the squared momentum transfer Total Cross Sections t. The single diffractive additionally is differential in the mass of the diffractive system, or in Total Cross Sections xi = x_Pom , where Total Cross Sections M^2_diff = xi * s. For double diffraction the two masses can accordingly be related to Total Cross Sections xi_1 and Total Cross Sections xi_2 values. For central diffraction Total Cross Sections M^2_diff = xi_1 * xi_2 * s , and additionally the cross section is differential in Total Cross Sections t_1 and Total Cross Sections t_2. Total Cross Sections Master switches The total and elastic cross sections are intimately connected via the optical theorem. Therefore the two should be calculated within a common setup. The diffractive cross sections are not as easily related, and can therefore be chosen separately, hence the two switches below. This allows different combinations to be tried out. Total Cross Sections Note that the total cross section subtracted by the elastic and various diffractive ones gives the inelastic nondiffractive cross section, which therefore is not set separately. However, since the nondiffractive inelastic cross section is what makes up the minimum-bias event class, and plays a major role in the description of multiparton interactions, it is important that a consistent set is used. Total Cross Sections In the following subsections all the parameters available for the various values of the master switches are described. A final subsection covers the possibility to include Coulomb corrections in elastic scattering, and is relevant for all scenarios. Total Cross Sections Set your own cross sections The following four parameters can be set for the Total Cross Sections SigmaTotal:mode = 0 option. The default values are in the right ballpark for LHC physics, but precise numbers depend on the energy used. Total Cross Sections The following four parameters can be set for the Total Cross Sections SigmaDiffractive:mode = 0 option. Again the default values are in the right ballpark for LHC physics, but with a considerable measure of uncertainty. Total Cross Sections The key parameter to set the differential shape of single diffraction is the Total Cross Sections SigmaDiffractive:PomFlux switch below. Seven different options are included, that provide the differential shape in diffractive mass and Total Cross Sections t of the scattered proton, based on the assumed Pomeron flux parametrizations. Only the SaS option contains a (published) extension to double diffraction, but the other alternatives have been extended in a minimal manner consistent with Pomeron phenomenology. These basic shapes can be further modified by the other settings below. Total Cross Sections In options 3, 4, 6, and 7 above, the Pomeron Regge trajectory is parametrized as Total Cross Sections alpha(t) = 1 + epsilon + alpha' t The Total Cross Sections epsilon and Total Cross Sections alpha' parameters can be set separately in options 3 and 4, and additionally Total Cross Sections alpha' is set in option 1, while values are fixed in options 6 and 7: Total Cross Sections The options above might give vanishing (or even negative) Total Cross Sections b slope values, and also do not enforce the presence of a rapidity gap. Furthermore the lowest allowed central diffractive mass is not well-defined; it would not be meaningful to go all the way down to the Total Cross Sections pi pi kinematical limit, since exclusive states are not modelled. Therefore the following parameters have been introduced to address such issues. Total Cross Sections Modify the SaS/DL cross sections The default description of total, elastic and diffractive interactions was parameterized and fit in Total Cross Sections Sch94, Sch97. There is no freedom for total and elastic cross sections, except that the Total Cross Sections rho parameter is not modelled but taken from the Total Cross Sections SigmaElastic:rho parameter above. Total Cross Sections The following three parameters allow for some modification of the mass distribution of the diffractive system, relative to the default setup. The parametrized cross sections explicitly depend on them, so that integrated diffractive cross section are changed acordingly. Total Cross Sections Central diffraction (CD) was not part of the framework in Total Cross Sections Sch94. It has now been added for Total Cross Sections p p or Total Cross Sections pbar p , but only for multiparticle states, i.e. excluding the low-mass resonance region below roughly 1 GeV, as well as other exclusive states. It uses the same proton-Pomeron vertex as in single diffraction, twice, to describe Total Cross Sections x_Pomeron and Total Cross Sections t spectra. This fixes the energy dependence, which has been integrated and parametrized. The absolute normalization has been left open, however. Furthermore, since CD has not been included in previous tunes to data, a special flag is available to reproduce the old behaviour (with due complications when one does not want to do this). Total Cross Sections LHC data have suggested that diffractive cross sections rise slower than predicted in the original studies. A likely reason is that unitarization effects may dampen the rise of diffractive cross sections relative to the default parametrizations. The settings here allows one way to introduce a dampening, which is used in some of the existing Total Cross Sections tunes. Total Cross Sections When Total Cross Sections SigmaDiffractive:dampen = on , the three diffractive cross sections are damped so that they never can exceed the respective values below. Specifically, if the standard parametrization gives the cross section Total Cross Sections sigma_old(s) and a fixed Total Cross Sections sigma_max is set, the actual cross section becomes Total Cross Sections sigma_new(s) = sigma_old(s) * sigma_max / (sigma_old(s) + sigma_max). This reduces to Total Cross Sections sigma_old(s) at low energies and to Total Cross Sections sigma_max at high ones. Note that the asymptotic value is approached quite slowly, however. Total Cross Sections As above, a reduced diffractive cross section automatically translates into an increased nondiffractive one, such that the total (and elastic) cross section remains fixed. Total Cross Sections Modify the MBR cross sections The MBR differential cross section also comes with a selection of parameters that can be changed from their default values, to modify diffractive event rates and shapes, while the total and elastic cross sections remain unaffected. These parameters are described in the following. Total Cross Sections Modify the ABMST cross sections The ABMST model provides a detailed description of the total, elastic and single diffractive cross sections. The former two components are accepted as is, while we have allowed alternative shapes for single diffraction, notably to enforce a rapidity gap. The ABMST model does not address double and central diffraction, so we have extended it on our own, as described below. Total Cross Sections Modify the RPP cross sections The RPP approach only addresses total and (differential) elastic cross sections, and there are no free parameters that can be changed. Total Cross Sections Coulomb corrections to elastic scattering By default there is no Coulomb-term contribution to the elastic (or total) cross section, which of course becomes infinite if this contribution is included in the collision between charged particles, owing to the Total Cross Sections 1/t^2 singularity of Total Cross Sections t -channel photon exchange. You can switch on Coulomb corrections below, however, including interference with the conventional strong-interaction term. The own, SaS/DL and MBR models share a common machinery to evaluate the interference Total Cross Sections Ber87 , while ABMST and RPP use a slighly different expression for the (poorly known) difference in phases between the hadronic and the electromagnetic amplitudes."},{"name":"Tunes","link":"Tunes.html","text":"Tunes Tunes Tunes Since some physics aspects cannot be derived from first principles, this program contains many parameters that represent a true uncertainty in our understanding of nature. Particularly afflicted are the areas of hadronization and multiparton interactions, which both involve nonperturbative QCD physics. Tunes Technically, PYTHIA  parameters can be varied independently of each other, but the physical requirement of a sensible description of a set of data leads to correlations and anticorrelations between the parameters. Hence the need to produce tunes, not of one parameter at a time, but simultaneously for a group of them. A well-known (separate) such example is parton densities, where combined tunes to a wide range of data have been produced, that can then be obtained prepackaged. Tunes Given the many PYTHIA parameters to be tuned, it is convenient to divide the task into subtasks. Firstly, if we assume jet universality, hadronization and final-state parton showers should be tuned to Tunes e^+e^- annihilation data, notably from LEP1, since this offers the cleanest environment. Secondly, with such parameters fixed, hadron collider data should be studied to pin down multiparton interactions and other further aspects, such as initial-state radiation. Ideally this would be done separately for diffractive and non-diffractive events, although it is not possible to have a clean separation. (Thirdly would come anything else, such as physics with photon beams, which involve further parameters, but that is beyond the current scope.) Tunes The first step was taken, with a tune to LEP1 data by Hendrik Hoeth, using the Rivet + Professor framework. Starting with version 8.125 it defined the default values for hadronization parameters and timelike showers. Tunes The situation is more complicated for hadronic interactions in general and multiparton interactions in particular, where PYTHIA 8 is more different from PYTHIA 6, and therefore more work is needed. Specifically, it is Tunes not possible to 'port' a PYTHIA 6 tune to PYTHIA 8. Tunes A first simple tune, appropriately called 'Tune 1', became default starting with version 8.127. It was noted, in particular by Hendrik Hoeth, that this tune had a tension between parameters needed to describe minimum-bias and underlying-event activity. Therefore some further physics features were introduced in the code itself Tunes Cor10a , which were made default as of 8.140. This version also included two new tunes, 2C and 2M, based on the CTEQ 6L1 and the MRST LO** PDF sets, respectively. These have been made by hand, as a prequel to complete Professor-style tunings. Tunes The very first data to come out of the LHC showed a higher rapidity plateau than predicted for current PYTHIA 6 tunes, also for the lower energies. This may suggest some tension in the data. Two alternatives, 3C and 3M, were produced by a few brute-force changes of 2C and 2M. These were introduced in 8.140, but discontinued in 8.145 in favour of the newer 4C tune, that is based on a more serious study of some early LHC data, see Tunes Cor10a. Following the comparative studies in Tunes Buc11 , which independently confirmed a reasonable agreement with LHC data, tune 4C was made the default from 8.150. A variant is tune 4Cx, where the Gaussian matter profile has an Tunes x -dependent width Tunes Cor11. Tunes Tune 4C was the basis for many subsequent LHC tunes. Several ATLAS tunes have been included here, obtained with different PDFs and with different emphasis on minimum-bias and underlying-event data Tunes ATL12. These typically require LHAPDF to be linked, but this can be avoided in cases where the same PDF set is implemented internally. Also two CMS underlying-event tunes are implemented Tunes CMS14. The ATLAS AZ tune Tunes ATL14 instead puts emphasis on the Tunes pT spectrum of the Tunes Z^/gamma^*0 boson. Tunes The Monash 2013 tune Tunes Ska14 is based on a larger set of LHC distributions. It starts out from a more careful comparison with and tuning to LEP data, and so involves several parameter changes. The PDF used is the NNPDF2.3 QCD+QED LO one with Tunes alpha_s(M_Z) = 0.130 , which includes more recent data than used in the previous default, and opens up for processes with incoming photons to the hard process. It is the default starting from 8.200. Tunes Recent tunes by the LHC collaborations are based on the Monash 2013 one. This includes the CMS tune MonashStar, or formally CUETP8M1-NNPDF2.3LO (currently unpublished). More significantly, ATLAS has produced and published a whole family for underlying-event tunes based on a major effort, including simultaneous fits of ten parameters Tunes ATL14a. This includes four central tunes, with four different PDF sets, and ten variations around the NNPDF2.3 QCD+QED LO central tune, grouped in five pairs of variations up and down. The publication Tunes ATL14a should be consulted for further details, like with what additional settings various processes have been generated, which should be respected to reap full benefit of the tunes. Tunes Central diffraction is a recent addition to the 'soft QCD' process palette, and is thus not yet included in tunes; indeed its cross section is actively zeroed. You can switch it back on Tunes after you have selected your tune, with Tunes SigmaTotal:zeroAXB = off. But note that, since the total cross section is assumed unchanged, the nondiffractive cross section is reduced and thus also the MPI machinery affected, even if effects should not be big (for a small central diffractive cross section). Tunes Note that comparisons with data also require that other aspects agree, such as that decay chains are stopped at an agreed-on level. For instance, in the ATLAS tunes all particles with a lifetime above 10 mm are considered stable, Tunes ParticleDecays:limitTau0 = on , Tunes ParticleDecays:tau0Max = 10. We have chosen not to include this as part of the tune settings itself, since the tune as such could still be used with any other choice of stable and unstable particles. Tunes Further comparisons have been posted on the Tunes MCPLOTS pages. They have been produced with help of the Tunes Rivet package Tunes Buc10. Tunes To simplify comparisons for the user, we propose to collect some of the tunes here, in a prepackaged form. Of course, in all cases it is a matter of setting values for parameters already defined elsewhere, so the tunes offer no new functionality, only a more convenient setup. Tunes You should be aware that the evolution of the program will not guarantee complete backwards compatibility between versions. Most obviously this concerns bug fixes. But also for some other major changes, like the introduction of the new diffractive machinery, the default behaviour of old tunes has been changed retroactively. (Which should be fine for diffraction, since previous tunes were not based on data strongly influenced by diffraction.) Tunes The setup of the tunes is special, in that the choice of a tune forces the change of several different flags, modes and parameters. Furthermore a design principle has been that it should be possible to start out from a tune and then change a few of its settings. This gives power and flexibility at the expense of requiring a more careful ordering of commands. We therefore here sketch the order in which operations are carried out. Tunes Tunes The constructor of a Tunes Pythia instance will read in all settings, and initialize them with their default values. Tunes At the end of this operation, the Tunes Tune:ee and Tunes Tune:pp modes (see further below) are checked. If either of them are positive the methods Tunes Settings::initTuneEE(...) and Tunes Settings::initTunePP(...) , respectively, are called to overwrite the whole collection of settings in the relevant tune. Zero (or negative) means that nothing will be done. Since most Tunes pp/ppbar tunes have been made in the context of an Tunes e^+e^- one, Tunes initTunePP(...) usually calls Tunes initTuneEE(...) to provide this synchronization. Tunes After the Tunes Pythia constructor all the relevant values for the default tune(s) have thus been set up. Tunes You as a user can now start to overwrite the values at will, using Tunes Pythia::readFile(...) to read a configuration file, or a list of Tunes Pythia::readString(...) commands, or the lower-level Tunes Settings methods. All changes are made in the order in which the commands are encountered during the execution. A given variable can be changed multiple times, but it is the latest change that sets the current value. Tunes The two Tunes Tune:ee and Tunes Tune:pp modes can also be changed in exactly the same way as described for all other settings above. Unique for them, however, is that when one of them is encountered it also initiates a call to the Tunes initTuneEE(...) or Tunes initTunePP(...) method, respectively. In such cases all settings affected by the Tunes e^+e^- or Tunes pp/ppbar tune are first reset to the default values (the Tunes -1 options) and thereafter the relevant tune is set up. Recall that Tunes initTunePP(...) in its turn is allowed to call Tunes initTuneEE(...). Tunes It is possible to mix commands of type 4 and 5 in any order; it is always the last change that counts. That is, any changes you have made to variables of a tune Tunes before a Tunes Tune:ee or Tunes Tune:pp command are overwritten by it, while variables you set Tunes after will overwrite the tune values. Further, the Tunes Tune:pp command usually implies an Tunes e^+e^- tune as well. Therefore Tunes Tune:ee would rarely be used for LHC applications. As a rule, instead, you want to begin with the Tunes Tune:pp choice, and thereafter modify only a small part of its settings. Tunes Needless to say, the flexibility can lead to unwanted setups if you do not exercise some discipline. It is therefore recommended that you always check the listing obtained with Tunes Pythia::settings.listChanged() to confirm that the final set of changes is the intended one."},{"name":"UMEPS Merging","link":"UMEPSMerging.html","text":"UMEPS Merging UMEPS Merging Unitarised Matrix Element + Parton Shower Merging Pythia offers the possibility to use the unitarised matrix element + parton shower merging scheme, as presented in UMEPS Merging Lon12. Unitarised ME+PS merging (UMEPS) allows for a consistent inclusion of tree-level multi-parton matrix elements into Pythia, and prevents potential changes in the inclusive production cross section. This makes it theoretically more appealing than CKKW-L merging. As in CKKW-L, UMEPS merging requires the user to supply Les Houches Event File input. UMEPS Merging UMEPS is different from other tree-level merging schemes in that it contains events with negative weights. These are generated by constructing parts of no-emission probabilities by reweighted higher-multiplicity samples UMEPS Merging Lon12. The main philosophy of UMEPS is 'subtract what you add', meaning that in order to ensure the stability of the inclusive cross section, one has to counter the inclusion of additional tree-level matrix elements by 'subtraction terms'. UMEPS Merging The scheme closely reflects how unitarity is achieved in a non-merged shower, and indeed explicitly enforces the cancellations that are implicitly happening in a non-merged shower. This makes very low merging scale values possible. UMEPS Merging The usage of UMEPS is illustrated in the sample main program UMEPS Merging main86.cc , together with the input file UMEPS Merging main86.cmnd. UMEPS Merging Unitarised merging is heavily indebted to CKKW-L merging, and shares many settings with CKKW-L. In particular, UMEPS Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; The hard process ( UMEPS Merging Merging:Process )needs to be defined exactly as in CKKW-L (see UMEPS Merging Defining the hard process in the UMEPS Merging CKKW-L documentation ). UMEPS Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; The merging scale value ( UMEPS Merging Merging:TMS ) has to be set. UMEPS Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; The maximal number of additional partons UMEPS Merging Merging:nJetMax has to be set. UMEPS Merging UMEPS further shares the switches listed under the sections ' UMEPS Merging Matrix element merging and HepMC output for RIVET ' and ' UMEPS Merging Further variables ' in  the UMEPS Merging CKKW-L documentation with CKKW-L merging. Also, all UMEPS Merging MergingHooks routines that allow for user interference in CKKW-L merging are also usable for UMEPS -- with the exception of a user-defined merging scale. Currently, UMEPS is only implemented for a merging scale defined by the minimal Pythia evolution pT value between sets of radiator, emitted and recoiler partons. This is no fundamental limitation of the method, and will possibly be lifted in the future. Since this merging scale definition is not completely obvious, UMEPS also shares the UMEPS Merging Merging:enforceCutOnLHE switch with CKKW-L. In this way, it is possible to use LHE files that are regularised only with weak cuts as input, while the merging machinery imposes the stronger merging scale cut automatically. This means that no merging scale implementation is required from the user side, but also means that it is the user's responsibility to ensure that the cuts used for generating input LHE files are always looser than the cut given by the merging scale value UMEPS Merging Merging:TMS. UMEPS Merging UMEPS Merging UMEPS Merging UMEPS Merging UMEPS merging with main86.cc The UMEPS procedure is illustrated in the sample main program UMEPS Merging main86.cc (with the input card UMEPS Merging main86.cmnd ). This program produces HepMC events UMEPS Merging Dob01 , that can be histogrammed (e.g. using RIVET UMEPS Merging Buc10 ), or used as input for a detector simulation. If the user is not familiar with HepMC analysis tools, it is possible to instead use Pythia's histogramming routines. For this, remove the lines referring to HepMC, and histogram events as illustrated (for CKKW-L) for the histogram UMEPS Merging histPTFirstSum in UMEPS Merging main84.cc , i.e. using UMEPS Merging weight*normhepmc as weight. UMEPS Merging In principle, no changes to UMEPS Merging main86.cc are necessary. Instead, all settings can be transferred to UMEPS Merging main86.cc through an input file. The input LHE files are also part of the (command line) input of UMEPS Merging main86.cc. Note  that the sample program assumes that LHE file names are of the form UMEPS Merging name_tree_#nAdditionalJets.lhe. If you want to e.g. use the LHE files that are shipped with the Pythia distribution, you can execute UMEPS Merging main86.exe with the command UMEPS Merging UMEPS Merging ./main86.exe ./main86.cmnd ./w_production ./myhepmc.hepmc Since UMEPS Merging main86.cc is currently the 'front-end' for UMEPS merging, we will briefly discuss this sample program in the following. UMEPS Merging Inputs In its current form, UMEPS Merging main86.cc uses separate tree-level LHE files for different numbers of additional partons as input. If e.g. UMEPS merging for W-boson + up to two additional partons is to be performed, three LHE files (for W+zero, W+one, W+two partons) are required. The configurations in the input files should be regularised with inclusive (i.e. weak) cuts. The actual 'merging scale cut' will be handled internally. If e.g. UMEPS Merging Merging:TMS = 15 is the desired merging scale value, it is acceptable to regularise the matrix element calculation for Higgs+jets events at the LHC with the loose cuts UMEPS Merging pT UMEPS Merging jet = 5 GeV , UMEPS Merging &Delta;R UMEPS Merging jetA jetB = 0.01 and UMEPS Merging Q UMEPS Merging jetA jetB = 5 GeV. UMEPS Merging All input settings are handed to UMEPS Merging main86.cc in the form of an input file. This input file has to contain UMEPS Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; The number of desired events ( UMEPS Merging Main:numberOfEvents ) UMEPS Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; The hard process ( UMEPS Merging Merging:Process ) UMEPS Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; The merging scale value ( UMEPS Merging Merging:TMS ) UMEPS Merging &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; The maximal number of additional partons ( UMEPS Merging Merging:nJetMax ). UMEPS Merging Other settings are of course allowed. However, please refrain from adding switches that are used to invoke other merging schemes (e.g. UMEPS Merging Merging:doKTMerging ) into the input file, since this can cause problems. UMEPS Merging Program flow The sample program starts by estimating the cross section for samples with different jet multiplicities. For this, the switch UMEPS Merging Merging:doXSectionEstimate is invoked together with the merging scale definition of UMEPS Merging Merging:doUMEPSTree , which corresponds to the minimal Pythia evolution pT value. We will come back to the latter switch below. All showering, multiparton interactions and hadronisation is, for speed reasons, switched off when estimating the cross section, since the hard cross section estimate would not be influenced by the event evolution anyway. UMEPS Merging After the hard cross sections are known (including the application of the merging scale cut), the first part of the UMEPS events is generated by using the following switch. UMEPS Merging The weight generated by the UMEPS procedure can be accessed by using the function UMEPS Merging double Info::mergingWeight(). When printing (or histogramming) merged events, this weight, multiplied with the estimated cross section for the current sample, should be used as event weight (or to fill histogram bins). UMEPS Merging After this first part is complete, the outcome is an addition of reweighted tree-level samples. To restore the inclusive cross section (i.e. that the cross section after merging corresponds to the cross section of the hard process, without any additional jets), it is necessary to subtract samples. Parton shower unitarity leads to the conclusion that 'resolved' and 'unresolved' corrections always cancel between states that contain an additional resolved jet, and states in which we 'integrate over' the phase space of the additional jet. UMEPS Merging main86.cc makes this cancellation explicit by producing (correctly weighted) counter events by switching on UMEPS Merging The integration is achieved internally, and the number of desired integrations (which is always one for UMEPS counter events) is set by UMEPS Merging Again, the weight generated by the UMEPS procedure can be accessed by using the function UMEPS Merging double Info::mergingWeight(). This weight, multiplied with the cross section of the current sample, and multiplied by UMEPS Merging -1 , should then be used as event weight (or to fill histogram bins). UMEPS Merging Before returning, UMEPS Merging main86.cc prints the merged cross section after UMEPS merging."},{"name":"User Hooks","link":"UserHooks.html","text":"User Hooks User Hooks User Hooks Sometimes it may be convenient to step in during the generation process: to modify the built-in cross sections, to veto undesirable events or simply to collect statistics at various stages of the evolution. There is a base class User Hooks UserHooks that gives you this access at a few selected places. This class in itself does nothing; the idea is that you should write your own derived class for your task. One simple derived class ( User Hooks SuppressSmallPT ) comes with the program, mainly as illustration, and the User Hooks main10.cc program provides a complete (toy) example how a derived class could be set up and used. User Hooks There are ten sets of routines, that give you different kinds of freedom. They are, in no particular order: User Hooks (i) Ones that give you access to the event record in between the process-level and parton-level steps, or in between the parton-level and hadron-level ones. You can study the event record and decide whether to veto this event. User Hooks (ii) Ones that allow you to set a scale at which the combined parton-level MPI+ISR+FSR downwards evolution in User Hooks pT is temporarily interrupted, so the event can be studied and either vetoed or allowed to continue the evolution. User Hooks (iii) Ones that allow you to to study the event after the first few ISR/FSR emissions, or first few MPI, so the event can be vetoed or allowed to continue the evolution. User Hooks (iv) Ones that allow you to study the latest initial- or final-state emission and veto that emission, without vetoing the event as a whole. User Hooks (v) Ones that give you access to the properties of the trial hard process, so that you can modify the internal Pythia cross section, alternatively the phase space sampling, by your own correction factors. User Hooks (vi) Ones that allow you to reject the decay sequence of resonances at the process level. User Hooks (vii) Ones that let you set the scale of shower evolution, specifically for matching in resonance decays. User Hooks (viii) Ones that allow colour reconnection, notably in connection with resonance decays. User Hooks (ix) Ones that allow an enhanced rate of rare shower splittings. User Hooks (x) Ones that give you access to to hadronization parameters in each step in the hadronization process, and allows for a veto of individual hadrons. User Hooks They are described further in the following numbered subsections. User Hooks All the possibilities above can be combined freely and also be combined with the standard flags. An event would then survive only if it survived each of the possible veto methods. There are no hidden interdependencies in this game, but of course some combinations may not be particularly meaningful. For instance, if you set User Hooks PartonLevel:all = off then the User Hooks doVetoPT(...) and User Hooks doVetoPartonLevel(...) locations in the code are not even reached, so they would never be called. User Hooks Normally you would gather all your changes into one derived class. In some cases it may be more convenient to separate different functionalities. Therefore it is possible to hand in several user hooks. See the section on 'Multiple user hooks' at the bottom of this page for further information on this possibility. User Hooks The effect of the vetoes of types (i), (ii) and (iii) can be studied in the output of the User Hooks User Hooks Pythia::stat() method. The 'Selected' column represents the number of events that were found acceptable by the internal Pythia machinery, whereas the 'Accepted' one are the events that also survived the user cuts. The cross section is based on the latter number, and so is reduced by the amount associated by the vetoed events. Also type (v) modifies the cross section, while types (iv), (vi) and (vii) do not. User Hooks A warning. When you program your own derived class, do remember that you must exactly match the arguments of the base-class methods you overload. If not, your methods will be considered as completely new ones, and compile without any warnings, but not be used inside User Hooks Pythia. So, at the debug stage, do insert some suitable print statements to check that the new methods are called (and do what they should). User Hooks The basic components For a derived User Hooks UserHooks class to be called during the execution, a pointer to an object of this class should be handed in with the User Hooks User Hooks User Hooks Pythia::setUserHooksPtr( UserHooks*) User Hooks method. The first step therefore is to construct your own derived class, of course. This must contain a constructor and a destructor. The User Hooks initPtr method comes 'for free', and is set up without any intervention from you. User Hooks Next you overload the desired methods listed in the sections below. These often come in pairs or triplets, where the first must return true for the last method to be called. This latter method typically hands you a reference to the event record, which you then can use to decide whether or not to veto. Often the event record can be quite lengthy and difficult to overview. The following methods and data member can then come in handy. User Hooks (i) Interrupt between the main generation levels User Hooks (ii) Interrupt during the parton-level evolution, at a User Hooks pT scale During the parton-level evolution, multiparton interactions (MPI), initial-state radiation (ISR) and final-state radiation (FSR) are normally evolved downwards in one interleaved evolution sequence of decreasing User Hooks pT values. For some applications, e.g  matrix-element-matching approaches, it may be convenient to stop the evolution temporarily when the 'hard' emissions have been considered, but before continuing with the more time-consuming soft activity. Based on these hard partons one can make a decision whether the event at all falls in the intended event class, e.g. has the 'right' number of parton-level jets. If yes then, as for the methods above, the evolution will continue all the way up to a complete event. Also as above, if no, then the event will not be considered in the final cross section. User Hooks Recall that the new or modified partons resulting from a MPI, ISR or FSR step are always appended to the end of the then-current event record. Previously existing partons are not touched, except for the User Hooks status, mother and daughter values, which are updated to reflect the modified history. It is therefore straightforward to find the partons associated with the most recent occurrence. User Hooks An MPI results in four new partons being appended, two incoming and two outgoing ones. User Hooks An ISR results in the whole affected system being copied down, with one of the two incoming partons being replaced by a new one, and one more outgoing parton. User Hooks An FSR results in three new partons, two that come from the branching and one that takes the recoil. User Hooks The story becomes more messy when rescattering is allowed as part of the MPI machinery. Then there will not only be a new system, as outlined above, but additionally some existing systems will undergo cascade effects, and be copied down with changed kinematics. User Hooks In this subsection we outline the possibility to interrupt at a given User Hooks pT scale, in the next to interrupt after a given number of emissions. User Hooks (iii) Interrupt during the parton-level evolution, after a step These options are closely related to the ones above in section (ii), so we do not repeat the introduction, nor the possibilities to study the event record, also by using User Hooks subEvent(...) and User Hooks workEvent. What is different is that the methods in this section give access to the event as it looks like after each of the first few steps in the downwards evolution, irrespective of the User Hooks pT scales of these branchings. Furthermore, it is here assumed that the focus normally is on the hardest subprocess, so that ISR/FSR emissions associated with additional MPI's are not considered. For MPI studies, however, a separate simpler alternative is offered to consider the event after a given number of interactions. User Hooks (iv) Veto emissions The methods in this group are intended to allow the veto of an emission in ISR, FSR or MPI, without affecting the evolution in any other way. If an emission is vetoed, the event record is 'rolled back' to the way it was before the emission occurred, and the evolution in User Hooks pT is continued downwards from the rejected value. The decision can be based on full knowledge of the kinematics of the shower branching or MPI. User Hooks To identify where shower emissions originated, the ISR/FSR veto routines are passed the system from which the radiation occurred, according to the Parton Systems class (see User Hooks Advanced Usage ). Note, however, that inside the veto routines only the event record has been updated; all other information, including the Parton Systems, reflects the event before the shower branching or MPI has taken place. User Hooks (v) Modify cross-sections or phase space sampling This section addresses two related but different topics. In both cases the sampling of events in phase space is modified, so that some regions are more populated while others are depleted. In the first case, this is assumed to be because the physical cross section should be modified relative to the built-in Pythia form. Therefore not only the relative population of phase space is changed, but also the integrated cross section of the process. In the second case the repopulation is only to be viewed as a technical trick to sample some phase-space regions better, so as to reduce the statistical error. There each event instead obtains a compensating weight, the inverse of the differential cross section reweighting factor, in such a way that the integrated cross section is unchanged. Below these two cases are considered separately, but note that they share many points. User Hooks One derived class is supplied as an example how this facility can be used to reweight cross sections in the same spirit as is done with QCD cross sections for the minimum-bias/underlying-event description: User Hooks The second main case of the current section involves three methods, as follows. User Hooks (vi) Reject the decay sequence of resonances Resonance decays are performed already at the process level, as an integrated second step of the hard process itself. One reason is that the matrix element of many processes encode nontrivial decay angular distributions. Another is to have equivalence with Les Houches input, where resonance decays typically are provided from the onset. The methods in this section allow you to veto that decay sequence and try a new one. Unlike the veto of the whole process-level step, in point (i), the first step of the hard process is retained, i.e. where the resonances are produced. For this reason the cross section is not affected here but, depending on context, you may want to introduce your own counters to check how often a new set of decay modes and kinematics is selected, and correct accordingly. User Hooks The main method below is applied after all decays. For the production of a User Hooks t tbar pair this typically means after four decays, namely those of the User Hooks t , the User Hooks tbar , the User Hooks W+ and the User Hooks W-. If Les Houches events are processed, the rollback is to the level of the originally read events. For top, that might mean either to the tops, or to the User Hooks W bosons, or no rollback at all, depending on how the process generation was set up. User Hooks (vii) Modify scale in shower evolution The choice of maximum shower scale in resonance decays is normally not a big issue, since the shower here is expected to cover the full phase space. In some special cases a matching scheme is intended, where hard radiation is covered by matrix elements, and only softer by showers. The below two methods support such an approach. Note that the two methods are not used in the User Hooks TimeShower class itself, but when showers are called from the User Hooks PartonLevel generation. Thus user calls directly to User Hooks TimeShower are not affected. User Hooks (viii) Allow colour reconnection PYTHIA contains only a limites set of possibilities for User Hooks colour reconnection , and none of them are geared specifically towards rapidly decaying resonances. Notably, with the default User Hooks User Hooks PartonLevel:earlyResDec = off , resonances will only decay after colour reconnection has already been considered. Thus a coloured parton like the top may be reconnected but, apart from this external connection with the rest of the event, the top decay products undergo no colour reconnection. For User Hooks PartonLevel:earlyResDec = on the resonance will decay earlier, and thus the decay products may undergo reconnections, but not necessarily by models that are specifically geared towards this kind of events. For tryout purposes, a user hook can be called directly after the resonance decays, and there modify the colour flow. This holds whether the resonance decay is handled early or late, but is especially appropriate for the latter default possibility. While intended specifically for resonance decays, alternatively it is possible to switch off the built-in colour reconnection and here implement your own reconnection model for the whole event. User Hooks (ix) Enhanced rate of rare shower splittings PYTHIA also offers possibilities to enhance the frequency of rare splittings.  This is not a trivial task, since a simple 'upweighting' of splittings would produce a mismatch between emission and no-emission probabilities, leading to a violation of the principle that the parton shower should not change the inclusive (input) cross section. Nevertheless, a general algorithm that allows for increased emission probabilities, while keeping no-emission factors intact, was presented in User Hooks Lon13a. User Hooks In User Hooks Lon13a two types of enhancements are proposed: those of 'regular' shower emissions, and those of trial shower emissions, the latter as part of the mandatory Sudakov reweighting in ME+PS merging schemes. Both of these possibilities are accessible through User Hooks UserHooks , but cannot be used at the same time. User Hooks The price to pay for these enhancements is that events come with a compensatory weight. The advantages of obtaining higher statistics for rare branchings thus is mitigated, and the usefulness has to be evaluated case by case. User Hooks Currently enhancements of ISR and FSR branchings have been included. These enhancements are currently not phase-space dependent, i.e. emissions will be enhanced uniformly in phase space. It should also be noted that the threshold region for gluon branchings to a pair of heavy quarks, specifically User Hooks g &rarr; c + cbar and User Hooks g &rarr; b + bbar , are not enhanced in this algorithm. Technically it is because this case is handled separately in the code, but there also remain some physics issues to understand. User Hooks To increase statistics of rare emissions in the showers, e.g. QED or weak radiation, Pythia supplies the following functions implementing the strategy of section 4 in User Hooks Lon13a. User Hooks In the context of merging, it can be beneficial to allow for enhanced trial emissions. As discussed in section 3 of User Hooks Lon13a , this means that the Sudakov factors that are commonly generated by event vetoes based on trial emissions (see e.g. User Hooks Lon11 ) are instead given by small but non-vanishing event weights. This can have advantages, since all events of an input sample will be retained. Pythia allows users to enhance trial emissions by using the following functions. User Hooks Trial emission enhancements also necessitate corrective weights. These are handled internally, so that users only have to ensure that User Hooks Info::mergingWeight() or User Hooks Info::mergingWeightNLO() are correctly taken into account. User Hooks A simple example of enhanced regular emissions is provided in User Hooks main63.cc , whereas User Hooks main64.cc illustrates the usefulness of enhanced trial emissions for expert users. User Hooks (x) Modified hadronization The methods in this group are intended to allow for modifications of the string hadronization model, involving changes to hadronization parameters based on local properties of the string. Given information on the hadronization history of a single string,  parameters can be changed to control the selection of quark flavour, User Hooks z and User Hooks pT in string breaks. Furthermore there is a option to veto the creation of a hadron before it is added to the event record, thus repeating a step in the hadronization procedure. User Hooks Multiple user hooks In addition to the User Hooks User Hooks User Hooks Pythia::setUserHooksPtr( UserHooks*) User Hooks method there is a second User Hooks User Hooks User Hooks Pythia::addUserHooksPtr( UserHooks*) User Hooks method that works almost like the former, but it allows the addition of further user hooks. These are stored as a vector and all of them will be called consecutively at the respective locations where they are set up to be active. User Hooks If two or more of them are active at the same location it is up to the user to ensure that the joint action is the one intended. In cases where weights are assigned the net result will be a weight that is is the product of them. In cases where vetoes are involved, a veto will be returned if either hook wants to veto, i.e. the no-veto survival probability is combined multiplicatively. It is not meaningful to let two hooks set the resonance scale or change fragmentation parameters, so warnings will be issued if this occurs."},{"name":"Vertex Information","link":"VertexInformation.html","text":"Vertex Information Vertex Information Vertex Information While the setting of secondary production vertices of unstable hadrons and leptons is a standard part of the particle decay rotines, no corresponding standardized handling is in place for the evolution in the partonic or hadronization phases of the event generation. The intention is to provide such methods in due course. Vertex Information There are some cases where such information is needed already now, specifically for the Vertex Information Rope Hadronization framework. Therefore the beginning of a framework is available, that can be used to set vertices for partonic production by MPI, FSR and ISR. This is done in the Vertex Information PartonVertex class. This is a base class, with a default implementation, but the user can replace it with a derived class that does a more sophisticated handling. Vertex Information Note that currently the parton-level vertices are expressed in fm, unlike the normal mm scale. This will be fixed as the methods evolve. Also other improvements and extensions are likely to come. So, while people are welcome to write their own derived classes, it is likely that these may need to be modified in later PYTHIA versions. Vertex Information Rope Hadronization Parameters Currently the base class implements two alternative approaches to picking a partonic vertex, for use inside the rope hadronization framework. There are also some free parameters in the models. Vertex Information External models A derived class for setting parton vertex information can be provided to PYTHIA with the Vertex Information Vertex Information bool Pythia::setPartonVertexPtr( PartonVertex* partonVertexPtrIn) Vertex Information method. The methods in the derived Vertex Information PartonVertex class can then be used to add vertex information to produced particles, at creation time, in MPI, FSR and ISR. The assigned vertex information will afterwards be accessible as properties of the individual particles. Particles produced in other types of processes than the ones mentioned above will not have vertex information assigned (e.g. hard process, beam remnants etc.), neither will particles produced in the weak shower."},{"name":"VINCIA QCD Antenna Shower Settings","link":"VinciaQCD.html","text":"VINCIA QCD Antenna Shower Settings VINCIA QCD Antenna Shower Settings VINCIA QCD Antenna Shower Settings VINCIA QCD Antenna Shower Settings Here, parameters specific to VINCIA's QCD antenna shower are collected. See the VINCIA QCD Antenna Shower Settings main VINCIA antenna shower page for more general parameters that are common to both the QCD and QED showers. VINCIA QCD Antenna Shower Settings Main Switches VINCIA QCD Antenna Shower Settings The QCD coupling in the Vincia Shower VINCIA QCD Antenna Shower Settings The strong coupling constant is specified by providing its reference value (interpreted as given at the Z pole in the MSbar scheme) and running properties (loop order, behaviour at top threshold, and any low-scale regularisation/dampening). VINCIA QCD Antenna Shower Settings Note that VINCIA only uses one global value for the definition of the strong coupling constant. The effective couplings used in shower branchings (renormalisation scheme and scale) are governed by separate parameters which are specified under initial- and final-state showers respectively. VINCIA QCD Antenna Shower Settings VINCIA implements its own instance of PYTHIA's VINCIA QCD Antenna Shower Settings AlphaStrong class for the strong coupling. You can find more documentation of the class in the section on Standard-Model Parameters in the PYTHIA documentation. Here, we list the specific parameters and switches governing its use in VINCIA. VINCIA QCD Antenna Shower Settings The free parameter of the strong coupling constant is specified by VINCIA QCD Antenna Shower Settings Resummation arguments VINCIA QCD Antenna Shower Settings Cat91 indicate that a set of universal QCD corrections can be absorbed in coherent parton showers by applying the so-called CMW rescaling of the MSbar value of VINCIA QCD Antenna Shower Settings Lambda_QCD , defined by VINCIA QCD Antenna Shower Settings VINCIA QCD Antenna Shower Settings &alpha; VINCIA QCD Antenna Shower Settings s (CMW) = &alpha; VINCIA QCD Antenna Shower Settings s (MSbar)  * (1 + K * &alpha; VINCIA QCD Antenna Shower Settings s (MSbar) / 2&pi;) with VINCIA QCD Antenna Shower Settings K = CA * (67/18 - &pi; VINCIA QCD Antenna Shower Settings 2 /6) - 5/9nf. The translation amounts to an VINCIA QCD Antenna Shower Settings NF -dependent rescaling of VINCIA QCD Antenna Shower Settings Lambda_QCD , relative to its MSbar value, by a factor 1.661 for NF=3, 1.618 for NF=4, 1.569 for NF=5, and 1.513 for NF=6. Although the original argument strictly concerned only the eikonal for soft-gluon emissions, the current version of VINCIA only offers the option of switching the rescaling of VINCIA QCD Antenna Shower Settings Lambda_QCD on or off. When on, the rescaling is applied to all branching types, not just gluon emissions. VINCIA QCD Antenna Shower Settings VINCIA QCD Antenna Shower Settings VINCIA QCD Antenna Shower Settings Note 1: If using VINCIA with an externally defined matching scheme, be aware that the CMW rescaling may need be taken into account in the context of matrix-element matching. Note also that this option has only been made available for timelike and spacelike showers, not for hard processes. VINCIA QCD Antenna Shower Settings VINCIA QCD Antenna Shower Settings Note 2: Tunes using this option need roughly 10% lower values of VINCIA QCD Antenna Shower Settings alpha VINCIA QCD Antenna Shower Settings s (m VINCIA QCD Antenna Shower Settings Z ) than tunes that do not. VINCIA QCD Antenna Shower Settings For both one- and two-loop running, the VINCIA QCD Antenna Shower Settings AlphaStrong class automatically switches from 3-, to 4-, and then to 5-flavour running as one passes the VINCIA QCD Antenna Shower Settings s , VINCIA QCD Antenna Shower Settings c , and VINCIA QCD Antenna Shower Settings b thresholds, respectively, with matching equations imposed at each flavour treshold to ensure continuous values. By default, a change to 6-flavour running is also included above the VINCIA QCD Antenna Shower Settings t threshold, though this can be disabled using the following parameter: VINCIA QCD Antenna Shower Settings Choice of Renormalisation Scales for Shower Branchings VINCIA QCD Antenna Shower Settings When VINCIA QCD Antenna Shower Settings Vincia:alphaSorder is non-zero, the actual value of alphaS used for shower branchings is governed by the choice of scheme (MSbar or CMW, see the section on AlphaStrong and then by running to the scale VINCIA QCD Antenna Shower Settings kR*Q VINCIA QCD Antenna Shower Settings 2 , at which the shower evaluates VINCIA QCD Antenna Shower Settings &alpha; VINCIA QCD Antenna Shower Settings s , with VINCIA QCD Antenna Shower Settings Q VINCIA QCD Antenna Shower Settings 2 the Vincia evolution scale of the branching.  The multiplicative scale factor VINCIA QCD Antenna Shower Settings kR is given by VINCIA QCD Antenna Shower Settings and VINCIA QCD Antenna Shower Settings For initial-state branchings, the functional form of VINCIA QCD Antenna Shower Settings muR is given by the evolution variable and the scale factor VINCIA QCD Antenna Shower Settings kR is given by VINCIA QCD Antenna Shower Settings Colour Charges VINCIA QCD Antenna Shower Settings The normalisation of colour factors in VINCIA is chosen such that the coupling factor for all antenna functions is &alpha;S/4&pi;. With this normalisation, all gluon-emission colour factors tend to NC in the large-NC limit while all gluon-splitting colour factors tend to unity. (Thus, e.g., the default normalisation of the qqbar &rarr; qgqbar antenna function is 2CF.) VINCIA QCD Antenna Shower Settings VINCIA QCD Antenna Shower Settings Kinematics and Recoils VINCIA QCD Antenna Shower Settings While the CM momenta of a VINCIA QCD Antenna Shower Settings 2&rarr;3 branching are fixed by the generated invariants (and hence by the antenna function), the global orientation of the produced 3-parton system with respect to the rest of the event (or, equivalently, with respect to the original dipole-antenna axis) suffers from an ambiguity outside the LL limits, which can be significant in regions where the leading logs are suppressed or absent. VINCIA QCD Antenna Shower Settings To illustrate this ambiguity, consider the emissision of a gluon from a qqbar antenna with some finite amount of transverse momentum (meaning transverse to the original dipole-antenna axis, in the CM of the dipole-antenna). The transverse momenta of the qqbar pair after the branching must now add up to an equal, opposite amount, so that total momentum is conserved, i.e., the emission generates a recoil. By an overall rotation of the post-branching 3-parton system, it is possible to align either the q or the qbar with the original axis, such that it becomes the other one that absorbs the entire recoil (the default in showers based on VINCIA QCD Antenna Shower Settings 1&rarr;2 branchings such as old-fashioned parton showers and Catani-Seymour showers), or to align both of them slightly off-axis, so that they share the recoil (the default in VINCIA, see illustration below). VINCIA QCD Antenna Shower Settings VINCIA QCD Antenna Shower Settings VINCIA QCD Antenna Shower Settings VINCIA QCD Antenna Shower Settings Kinematics and Recoils for II Antennae VINCIA QCD Antenna Shower Settings The post-branching momenta are fixed by the following requirements: VINCIA QCD Antenna Shower Settings 1) The direction of the initial state partons is aligned with the beam axis (z-axis). VINCIA QCD Antenna Shower Settings 2) The invariant mass and the rapidity of the final state recoiler are not changed by the branching. This allows a direct construction of the post-branching momenta in the lab frame. VINCIA QCD Antenna Shower Settings Kinematics and Recoils for IF Antennae For IF branchings, Vincia contains implementations of two different kinematics maps, called 'local' and 'global' in what follows. VINCIA QCD Antenna Shower Settings In the 'local map', the initial-state parton recoils longitudinally, and there is no recoil imparted to any partons that do not participate directly in the branching. (I.e., recoil effects are absorbed locally within the branching antenna, and no partons outside of it are affected.) This is equivalent to saying that any transverse momentum associated with the emitted parton (j) is absorbed by the other final-state parton (k). This allows a simple construction  of the post-branching momenta in the centre-of-mass frame of the initial-final antenna. VINCIA QCD Antenna Shower Settings The 'global map' allows for an overall transverse recoil associated with the initial-state leg to be imparted to the system of final-state partons other than those participating directly in the branchings. This is equivalent to saying that any transverse momentum associated with the emitted parton (j) is absorbed by the initial-stage leg (a), after which a Lorentz transformation brings it (plus the final-state system) back to having beam-collinear kinematics. The recoil vanishes For final-state collinear kinematicsbut is in general nonzero outside that limit. VINCIA QCD Antenna Shower Settings Intuitively, the local map should be appropriate for final-state splittings, while the global one would be appropriate for initial-state ones. The full story is more complicated, partly since soft wide-angle radiation intrinsically represents interference between the two cases, and partly because the phase-space limits for the two maps (outside of the strict soft and collinear limits) are different. (The x < 1 constraint translates to slightly different constraints on the branching invariants for the two maps, as does positivity of the Gram determinant.) A probabilistic selection is therefore made between the local and global maps, using a form obtained by R. Verheyen based on comparisons to DIS matrix elements, VINCIA QCD Antenna Shower Settings P(global) = (sAK - saj)^2/[ (sAK + sjk)^2 + (sAK - saj)^2 ] * Theta( sAK - saj ) , with Theta the unit step function (since the momenta in the global map always become unphysical for saj > sAK). VINCIA QCD Antenna Shower Settings VINCIA QCD Antenna Shower Settings When using the probabilistic selection, it is possible (in phase-space regions well away from the strict soft and collinear limits) that the selected kinematics map produces unphysical momenta (with x > 1 or negative energies) for the given branching invariants, while the other map would give physical momenta. In such cases, one has to choose whether the given phase-space point should be vetoed, or whether the other map should be allowed to be used instead to construct the kinematics. VINCIA QCD Antenna Shower Settings Kinematics and Recoils for FF Antennae VINCIA QCD Antenna Shower Settings Kinematics and Recoils for RF Antennae VINCIA QCD Antenna Shower Settings Lower Cutoffs for the QCD evolution VINCIA QCD Antenna Shower Settings VINCIA QCD Antenna Shower Settings The hadronisation cutoff , a.k.a. the infrared regularisation scale, defines the resolution scale at which the perturbative shower evolution is stopped. Thus, perturbative emissions below this scale are treated as fundmanentally unresolvable and are in effect inclusively summed over. VINCIA QCD Antenna Shower Settings VINCIA QCD Antenna Shower Settings Important Note: when hadronisation is switched on,  there is a delicate interplay between the hadronisation scale used  in the shower and the parameters of the hadronisation  model. Ideally,  the parameters of the hadronisation model should scale as a function  of the shower cutoff. This scaling does not happen automatically in  current hadronisation models, such as the string model  employed by PYTHIA. Instead, the  parameters of the hadronisation model are tuned for one specific  shower setting at a time and should be retuned if changes are made  to the shower cutoff. VINCIA QCD Antenna Shower Settings Other QCD Settings VINCIA QCD Antenna Shower Settings Subleading Colour VINCIA QCD Antenna Shower Settings During the perturbative shower evolution, the first aspect of subleading colour is simply what colour factors are used for the antenna functions. In a strict leading-colour limit, one would use VINCIA QCD Antenna Shower Settings CA for all antennae, thus overestimating the amount of radiation from quarks (note that we use a normalisation convention in which the colour factor for quarks is VINCIA QCD Antenna Shower Settings 2CF , hence the difference is explicitly subleading in colour). A more realistic starting point is to use VINCIA QCD Antenna Shower Settings 2CF for quark-antiquark antennae, VINCIA QCD Antenna Shower Settings CA for gluon-gluon ones, and something inbetween for quark-gluon ones.  The following switch determines whether and how subleading-colour corrections are treated in the evolution: VINCIA QCD Antenna Shower Settings Colour flow is traced using Les-Houches style colour tags, augmented by letting the last digit encode the 'colour index', running from 1 to 9, described further in the section below on antenna swing. One ambiguity arises in gluon emission as to which of the daughter antennae should inherit the 'parent' colour tag/index, and which should be assigned a new one. This is controlled by the following parameter:"},{"name":"VINCIA QED Antenna Shower Settings","link":"VinciaQED.html","text":"VINCIA QED Antenna Shower Settings VINCIA QED Antenna Shower Settings VINCIA QED Antenna Shower Settings VINCIA QED Antenna Shower Settings Here, parameters specific to VINCIA's QED antenna shower are collected. See the VINCIA QED Antenna Shower Settings main VINCIA antenna shower page for more general parameters that are common to both the QCD and QED showers. VINCIA QED Antenna Shower Settings Main Switches VINCIA QED Antenna Shower Settings The QED coupling in the Vincia Shower VINCIA QED Antenna Shower Settings Lower Cutoffs for the QED evolution VINCIA QED Antenna Shower Settings Other QED Settings"},{"name":"VINCIA User Reference","link":"Vincia.html","text":"VINCIA User Reference VINCIA User Reference The Antenna Shower Model (VINCIA) VINCIA User Reference Overview VINCIA User Reference The antenna shower model was initially developed as a  standalone plugin (VINCIA), but since Pythia version 8.300 it has  been incorporated into the Pythia 8 source code. VINCIA User Reference The shower evolution is driven by 2&rarr;3 antenna functions which  have DGLAP kernels as their collinear limits and eikonal factors  as their soft limits. They hence should exhibit improved colour coherence  effects relative to the old (DGLAP-based) simple shower model.  Likewise, the QED antenna-shower module is based on a fully coherent  (multipole) treatment of photon radiation patterns. For both QCD and  QED, the effects of parton masses (e.g., bottom and top quark masses)  are systematically included, and the massive  antenna functions have the appropriate  quasi-collinear limits. VINCIA User Reference Main Switches VINCIA User Reference Shower Starting Scales (Wimpy vs Power Showers) VINCIA User Reference Similarly to PYTHIA, for processes that include at least one quark,  gluon, or photon  in the  final state, the default choice in VINCIA is to start the shower from the  factorisation scale used for the hard process (as given by  PYTHIA for internal  processes, or defined by the VINCIA User Reference scale value for Les Houches  input),while processes  that do not include any such partons are allowed to populate the full  phase space. This behaviour can be changed by the following option,  which is anologous to the VINCIA User Reference SpaceShower:PTmaxMatch option  in PYTHIA. VINCIA User Reference When the first branching is limited by the factorisation scale for the  hard process, a  multiplicative factor can be applied to either increase or decrease  the shower starting scale relative to the factorisation scale: VINCIA User Reference Note that for any (combination of) choices that result in ISR  showers not using the factorisation scale as the starting scale, the  generated Sudakov factor will effectively produce leftover PDF ratios  in the exclusive cross sections produced by the shower. VINCIA User Reference Settings for the QCD Antenna Showers The settings for the QCD antenna shower modules are described VINCIA User Reference here. VINCIA User Reference Settings for the QED Antenna Showers The settings for the QED antenna shower module are described VINCIA User Reference here. VINCIA User Reference Evolution with Enhanced (Biased) Kernels VINCIA User Reference VINCIA's shower evolution can be biased to populate the multi-jet  phase space more efficiently and/or enhance the rate of rare processes  such as VINCIA User Reference g&rarr;bb and VINCIA User Reference g&rarr;cc splittings. It is  also possible to inhibit radiation (e.g., to focus on Sudakov  regions), by choosing enhancement factors smaller than unity. When  these options are used, it is important to note that the event weights  will be modified, reflecting that some types of events (e.g., multijet  events, or events with gluon splittings to heavy quarks) will be  'overrepresented' statistically, and others (events with few jets, or  events with no gluon splittings to heavy quarks)  underrepresented. Averages and histograms will therefore only be  correct if computed using the correct weight for each generated  event. A description and proof of the algorithm can be found in VINCIA User Reference MS16. Note that care has been taken to ensure that the  weights remain positive definite; under normal circumstances, VINCIA's  enhancement algorithm should not result in any negative weights. VINCIA User Reference VINCIA Tunes VINCIA User Reference VINCIA User Reference VINCIA accepts input of tune presets in the form of a standard PYTHIA  8 command file whose name and location can be specified by the  user. VINCIA User Reference VINCIA User Reference Note: the requested file will only be read in when VINCIA is switched on, in order not to interfere with the PYTHIA settings when VINCIA is switched off. VINCIA User Reference VINCIA User Reference Note 2: a special value  for this parameter is 'none', in which case no tune file will be used (i.e., PYTHIA's parameters will be used as they are). VINCIA User Reference VINCIA User Reference Note 3: the entries in the tune file will be superseded by any user modifications made in the main command file given to the VINCIA constructor. This should allow sufficient flexibility to explore user variations away from the tuned values. VINCIA User Reference A particular set of user-defined parameters can  easily be made into a tune set by simply copying the relevant parts of  the user's normal command file (i.e., omitting the process-specific  and program control parameters) into a new file that can then be shared  and/or submitted to the VINCIA authors for possible inclusion  in future distributions. In order to make tunings more stable  against possible  changes in the program defaults (be it PYTHIA or VINCIA), it is  advisable to include all relevant parameter values explicitly in the  tune file, rather than letting parameters that retain  their (version-specific) default values be defined implicitly. VINCIA User Reference Advice on Tuning VINCIA User Reference Although there are obviously parameters that  it makes more sense to tune than others, there is no explicit  restriction imposed on what parameters are allowed to be present in  the tune file. This implies some responsibility on the part of the  user. VINCIA User Reference VINCIA User Reference As a guideline, the main  parameters that need to be properly tuned are the  non-perturbative hadronisation parameters used in PYTHIA's string  fragmentation model. Since PYTHIA and VINCIA treat soft radiation  somewhat differently, there can be important differences between the  two in the soft region that the hadronisation model will not re-absorb  automatically and which therefore only a retuning can address. VINCIA User Reference The strategy used for the default tune of VINCIA is to take the reference value for alphaS from the current world average value in the MSbar scheme, and let the effective shower scheme tuning be done by first translating to the CMW scheme and then fine-tune by modifying the renormalisation-scale prefactors used for shower branchings. VINCIA User Reference An alternative (but equivalent) strategy that is often used in PYTHIA tunes, is to perceive of the value of the strong coupling itself as a tuning parameter. In this case the interpretation is that extracting alphaS from, e.g., event shapes, can be done equally well using a shower code as with more analytical approaches. The difference is that the alphaS value extracted with the shower code is in an a priori unknown scheme, defined by the shower algorithm. If the shower only includes LO/LL accuracy for the given observable(s), the extraction should be compared with other LO/LL extractions. This typically yields alphaS values ~ 0.13 - 0.14. When explicit NLO corrections are included for the relevant observable(s), values comparable to other NLO extractions should result, around 0.12. VINCIA User Reference About VINCIA VINCIA User Reference The authors of the current version, taking active responsibility for code development and day-to-day maintenance, are VINCIA User Reference VINCIA User Reference P. Skands: Main author VINCIA User Reference H. Brooks: Resonance-decay showers. VINCIA User Reference R. Verheyen: QED multipole showers VINCIA User Reference In addition, the  following people have made significant individual contributions to  the underlying formalism and code development of VINCIA: VINCIA User Reference VINCIA User Reference W. T. Giele and D. A. Kosower: Basics of the antenna shower    formalism. VINCIA User Reference L. Hartgring and E. Laenen: on NLO corrections to Z + 3 jets. VINCIA User Reference H.-T. Li: on 2&rarr;4 branchings and one-loop corrections to FF  shower kernels. VINCIA User Reference A. Larkoski: on helicity-based final-state showers and matrix  elements. VINCIA User Reference A. Lifson: Analytical MHV amplitudes. VINCIA User Reference N. Fischer: ISR and MECs for hadron collisions. VINCIA User Reference J. J. Lopez-Villarejo: Sector showers. VINCIA User Reference S. Prestel: Merging and strongly-ordered MECs. VINCIA User Reference M. Ritzmann: Mass corrections and initial-state antenna showers. VINCIA User Reference T. Sj&ouml;strand: Integration with PYTHIA 8. VINCIA User Reference VINCIA User Reference The main references for the current version of VINCIA are: VINCIA User Reference VINCIA User Reference VINCIA User Reference VINCIA for Hadron Colliders. VINCIA User Reference VINCIA User Reference Coherent Showers in Decays of Coloured Resonances (for showers    in top quark decays). VINCIA User Reference VINCIA User Reference The name VINCIA stands for 'VIrtual Numerical Collider with  Interleaved Antennae'. The naming of VINCIA is intended to allude  to a progression from PYTHIA - a name originating in ancient Greece -  to the renaissance era of Leonardo da Vinci. The logo of VINCIA is  the 'Vitruvian Man', by da Vinci, a choice which also reflects the  combination of art and accuracy which is necessary to write a  good event generator. Classical antiquity is still indirectly  represented, via the namesake of the logo, Vitruvius, a  first-century (BC) Roman author, architect, and engineer. VINCIA User Reference Expert Settings VINCIA User Reference Importante Note: the parameters in this section are intended for use only by authors or expert users. VINCIA User Reference Sector Shower VINCIA User Reference Octet Partitioning VINCIA User Reference Within the antenna formalism, the collinear singularity of two  gluons j and k is  distributed between two neighboring antennae. One contains the  singularity for j becoming  soft, one the singularity for k becoming soft. In showers based on  so-called global antenna functions (as opposed to sector functions,  which are no longer implemented in VINCIA), the  two antennae share the collinear singularity, j||k, point by point in  phase space, and only after summing over both is the full collinear AP  splitting kernel recovered.  The parameter below controls the repartition ambiguity and gives the value  of 'half' the gluon splitting function on its finite end. VINCIA User Reference Verbose Level VINCIA User Reference Shower Uncertainty Bands Automated uncertainty bands are not available in this version of the VINCIA code. VINCIA User Reference Numerical Checks"},{"name":"Weak Showers","link":"WeakShowers.html","text":"Weak Showers Weak Showers Weak Showers The emission of Weak Showers W^+- and Weak Showers Z^0 gauge bosons off fermions is intended to be an integrated part of the initial- and final-state radiation frameworks, and is fully interleaved with QCD and QED emissions. It is a new and still not fully explored feature, however, and therefore it is off by default. The weak-emission machinery is described in detail in Weak Showers Chr14 ; here we only bring up some of the most relevant points for using this machinery. Weak Showers In QCD and QED showers the real and virtual corrections are directly related with each other, which means that the appropriate Sudakov factors can be directly obtained as a by-product of the real-emission evolution. This does not hold for Weak Showers W^+- , owing to the flavour-changing character of emissions, so-called Bloch-Nordsieck violations. These effects are not expected to be large, but they are not properly included, since our evolution framework makes no distinction in this respect between QCD, QED or weak emissions. Another restriction is that there is no simulation of the full Weak Showers gamma^*/Z^0 interference: at low masses the QED shower involves a pure Weak Showers gamma^* component, whereas the weak shower generates a pure Weak Showers Z^0. Weak Showers The non-negligible Weak Showers W/Z masses have a considerable impact both on the matrix elements and on the phase space for their emission. The shower on its own is not set up to handle those aspects with a particularly good accuracy. Therefore the weak shower emissions are always matched to the matrix element for emission off a Weak Showers f fbar weak dipole, or some other Weak Showers 2 &rarr; 3 matrix element that resembles the topology at hand. Even if the match may not be perfect, at least the main features should be caught that way. Notably, the correction procedure is used throughout the shower, not only for the emission closest to the hard Weak Showers 2 &rarr; 2 process. In such extended applications, emission rates are normalized to the invariant mass of the dipole at the time of the weak emission, i.e. discounting the energy change by previous QCD/QED emissions. Weak Showers Also the angular distribution in the subsequent Weak Showers V = W^+-/Z^0 decay is matched to the matrix element expression for Weak Showers f fbar &rarr; f fbar V &rarr; f fbar f' fbar' (FSR) and Weak Showers f fbar &rarr; g^* V &rarr; g^* f' fbar' (ISR). Afterwards the Weak Showers f' fbar' system undergoes showers and hadronization just like any Weak Showers W^+-/Z^0 decay products would. Weak Showers Special for the weak showers is that couplings are different for left- and righthanded fermions. With incoming unpolarized beams this should average out, at least so long as only one weak emission occurs. In the case of several weak emissions off the same fermion the correlation between them will carry a memory of the fermion helicity. Such a memory is retained for the affected dipole end, and is reflected in the Weak Showers Particle::pol() property, it being Weak Showers +1 ( Weak Showers -1 ) for fermions considered righthanded (lefthanded), and 0 for the bulk where no choice has been made. Weak Showers Most events will not contain a Weak Showers W^+-/Z^0 emission at all, which means that dedicated generator studies of weak emissions can become quite  inefficient. In a shower framework it is not straightforward to force  such emissions to happen without biasing the event sample in some respect. An option is available to enhance the emission rate artificially, but it is then the responsibility of the user to correct the cross section accordingly, and not to pick an enhancement so big that the probability for more than one emission is non-negligible. (It is not enough to assign an event weight Weak Showers 1/e^n where Weak Showers e is the enhancement factor and Weak Showers n is the number of emitted gauge bosons. This still misses to account for the change in phase space for late emissions by the effect of earlier ones, or equivalently for the unwanted change in the Sudakov form factor. See Weak Showers Lon13a for a detailed discussion and possible solutions.) Weak Showers Another enhancement probability is to only allow some specific Weak Showers W^+-/Z^0 decay modes. By default the shower is inclusive, since it should describe all that can happen with unit probability. This also holds even if the Weak Showers W^+- and Weak Showers Z^0 produced in the hard process have been restricted to specific decay channels. The trick that allows this is that two new 'aliases' have been produced, a Weak Showers Zcopy with identity code 93 and a Weak Showers Wcopy with code 94. These copies are used specifically to bookkeep decay channels open for Weak Showers W^+-/Z^0 bosons produced in the shower. For the rest they are invisible, i.e. you will not find these codes in event listings, but only the regular 23 and 24 ones. The identity code duplication allows the selection of specific decay modes for 93 and 94, i.e. for only the gauge bosons produced in the shower. As above it is here up to the user to reweight the event to compensate for the bias introduced, and to watch out for possible complications. In this case there is no kinematics bias, but one would miss out on topologies where a not-selected decay channel could be part of the background to the selected one, notably when more than one gauge boson is produced. Weak Showers Note that the common theme is that a bias leads to an event-specific weight, since each event is unique. It also means that the cross-section information obtained e.g. by Weak Showers Pythia::stat() is misleading, since it has not been corrected for such weights. This is different from biases in a predetermined hard process, where the net reduction in cross section can be calculated once and for all at initialization, and events generated with unit weight thereafter. Weak Showers The weak shower introduces a possible doublecounting problem. Namely that it is now possible to produce weak bosons in association with jets from two different channels, Drell-Yan weak production with QCD emissions and QCD hard process with a weak emission. A method, built on a classification of each event with the Weak Showers kT jet algorithm, is used to remove the doublecounting. Specifically, consider a tentative final state consisting of a Weak Showers W/Z and two jets. Based on the principle that the shower emission ought to be softer than the hard emission, the emission of a hard Weak Showers W/Z should be vetoed in a QCD event, and that of two hard jets in a Drell-Yan event. The dividing criterion is this whether the first clustering step involves the Weak Showers W/Z or not. It is suggested to turn this method on only if you simulate both Drell-Yan weak production and QCD hard production with a weak shower. Do not turn on the veto algorithm if you only intend to generate one of the two processes. Weak Showers Variables Below are listed the variables related to the weak shower and common to both the initial- and final-state radiation. For variables only related to the initial-state radiation (e.g. to turn the weak shower on for ISR) see Weak Showers Spacelike Showers and for final-state radiation see Weak Showers Timelike Showers."},{"name":"access","link":"Variations.html#anchor11","text":"access"},{"name":"Alpgen:file","link":"AlpgenEventInterface.html#anchor1","text":"Alpgen:file This option is used to read in ALPGEN format event files. Using this option overrides any previously set beam options inside PYTHIA. The path to the files, not including any file extension, should be provided e.g. for input files Alpgen:file input_unw.par and Alpgen:file input.unw , the value Alpgen:file input should be used."},{"name":"Alpgen:setHeavyMasses","link":"AlpgenEventInterface.html#anchor3","text":"Alpgen:setHeavyMasses When switched on, Alpgen:setHeavyMasses t , Alpgen:setHeavyMasses Z , Alpgen:setHeavyMasses W and Alpgen:setHeavyMasses H masses provided by ALPGEN are set in the PYTHIA Alpgen:setHeavyMasses particle database."},{"name":"Alpgen:setLightMasses","link":"AlpgenEventInterface.html#anchor2","text":"Alpgen:setLightMasses When switched on, Alpgen:setLightMasses c and Alpgen:setLightMasses b quark masses provided by ALPGEN are set in the PYTHIA Alpgen:setLightMasses particle database. Since ALPGEN may set these two masses to vanish, the parton shower programs have been provided with some protection, but other parts of the code may not be as fortunate. You should therefore only switch on this option if you know what you are doing."},{"name":"Alpgen:setMLM","link":"AlpgenEventInterface.html#anchor4","text":"Alpgen:setMLM When switched on, the merging parameters (see below) are set according to the ALPGEN hard process cuts: Alpgen:setMLM Alpgen:setMLM Alpgen:setMLM JetMatching:eTjetMin = min(ptjmin + 5., 1.2 * ptjmin) , Alpgen:setMLM Alpgen:setMLM JetMatching:coneRadius = drjmin , Alpgen:setMLM Alpgen:setMLM JetMatching:etaJetMax = etajmax. where the Alpgen:setMLM ptjmin , Alpgen:setMLM drjmin and Alpgen:setMLM etajmax are the incoming ALPGEN parameters. Note that any existing values of these parameters are overwritten."},{"name":"Alpgen:setNjet","link":"AlpgenEventInterface.html#anchor5","text":"Alpgen:setNjet When switched on, the Alpgen:setNjet JetMatching:nJet parameter (see below) is set to the incoming Alpgen:setNjet njet ALPGEN parameter. Note that any existing value of this parameter is overwritten."},{"name":"alphaS","link":"VinciaQCD.html#anchor8","text":"alphaS"},{"name":"Angantyr","link":"HeavyIons.html#anchor9","text":"Angantyr Angantyr - the default heavy ion model"},{"name":"Angantyr:CollisionModel","link":"HeavyIons.html#anchor17","text":"Angantyr:CollisionModel The Angantyr model has a couple of option for the SubCollisionModel Angantyr:CollisionModel A simplified model with fixed nucleon radii. Angantyr:CollisionModel The default model with fluctuating radii and cross sections. Angantyr:CollisionModel Fluctuating radii and cross sections but different treatment of opacity. Angantyr:CollisionModel Black disks with no fluctuations, ie. no diffraction."},{"name":"Angantyr:GlauberOnly","link":"HeavyIons.html#anchor18","text":"Angantyr:GlauberOnly If switched on, the event generation will stop after SubCollisions has been determined, allowing the user to read out the nucleon configuration only."},{"name":"Angantyr:impactFudge","link":"HeavyIons.html#anchor21","text":"Angantyr:impactFudge Multiplicative factor used to compensate for the fact that the Angantyr:impactFudge SubColllisionModel in Angantyr may have a different impact parameter profile than what is assumed in the MPI overlap calculation in Pythia."},{"name":"Angantyr:impactMode","link":"HeavyIons.html#anchor20","text":"Angantyr:impactMode Determines how to bias non-diffractive minimum-bias sub-collisions in PYTHIA to be appropriately central. Angantyr:impactMode If we have N pirmary sub-collisions and Na secondary sub-collisions, generate N+Na non-diffractive events and pick the N most central. Angantyr:impactMode Use UserHooks to force Pythia to produce events with a particular impact parameter for the N primary sub collisions according to the generated impact parameter in the SubCollisionModel. Angantyr:impactMode As for option Angantyr:impactMode 1 but also the secondary absorptive sub-collisions have their impact parameter set."},{"name":"Angantyr:SASDmode","link":"HeavyIons.html#anchor19","text":"Angantyr:SASDmode Determines how to generate single-diffraction events as secondary absorptive (SASD) sub-collisions. Angantyr:SASDmode Standard singel-diffraction events as speicfied by Angantyr:SASDmode HIDiffraction settings above. Angantyr:SASDmode Always use Angantyr:SASDmode HIPDF:PomSet = 11 and use the same initial Angantyr:SASDmode HIMultipartonInteractions:pT0Ref as for non-diffractive events for the total nucleon-nucleon collision energy, independent of the mass of the diffractive system. Angantyr:SASDmode (Experimental) As for option Angantyr:SASDmode 1 but also rescale the pomeron proton non-diffractive cross section to match the pp non-diffractive one. Angantyr:SASDmode (Experimental) As for option Angantyr:SASDmode 1 but use the full nucleon-nucleon cross section for the non-diffractive nucleon-Pomeron in the multiple interaction machinery. Also rescale the Pomeron PDF with the log of the ratio of maximum and minimum Pomeron-nucleon collision energy. Angantyr:SASDmode As for option Angantyr:SASDmode 3 but no rescaling of the Pomeron  PDF."},{"name":"Angantyr:SDRecoil","link":"HeavyIons.html#anchor23","text":"Angantyr:SDRecoil Determines which particles in a primary sub-collision will take the recoil when adding single diffractive sub-collisions to other sub-collisions. The choice may be overridded by a user-defined Angantyr:SDRecoil HIUserHooks::findRecoilers function. Angantyr:SDRecoil Only elastically scattered nucleons and nucleon remnants will take recoil. Angantyr:SDRecoil All particles outside the added diffractive system's rapidity range are considered."},{"name":"Angantyr:SDTest","link":"HeavyIons.html#anchor24","text":"Angantyr:SDTest Used in conjunction with Angantyr:SDTest HeavyIon:mode = 2 and proton beams to generate single diffractive events that would be used as secondary non-diffractive scatterings in the Angantyr heavy ion model for the given nucleon energies. Used for tuning special Angantyr:SDTest HI -prefixed parameters of the secondary absorptive sub-collisions."},{"name":"Angantyr:SDTestB","link":"HeavyIons.html#anchor25","text":"Angantyr:SDTestB In conjunction with Angantyr:SDTestB Angantyr:SDTest = on and Angantyr:SDTestB Angantyr:impactMode = 2 only pick diffractive events with a particular impact parameter (as defined by the scaled value given in Angantyr:SDTestB Info::bMPI() ). If negative, the standard impact parameter distribution is used."},{"name":"Angantyr:SDTries","link":"HeavyIons.html#anchor22","text":"Angantyr:SDTries When adding single diffractive sub-collisions to other sub-collisions, there might not be enough energy for the diffractive mass. One option here is to  say that the diffractive sub-event simply fails, but setting this larger than unity allows for regenerating the single diffractive sub-event a number of times to see if a small enough diffractive system is produced."},{"name":"BeamRemnants:allowBeamJunction","link":"BeamRemnants.html#anchor21","text":"BeamRemnants:allowBeamJunction This parameter is only relevant if the new Beam remnant model is used. This parameter tells whether to allow the formation of junction structures in the colour configuration of the scattered partons."},{"name":"BeamRemnants:allowJunction","link":"BeamRemnants.html#anchor19","text":"BeamRemnants:allowJunction The BeamRemnants:allowJunction off option is intended for debug purposes only, as follows. When more than one valence quark is kicked out of a baryon beam, as part of the multiparton interactions scenario, the subsequent hadronization is described in terms of a junction string topology. This description involves a number of technical complications that may make the program more unstable. As an alternative, by switching this option off, junction configurations are rejected (which gives an error message that the remnant flavour setup failed), and the multiparton interactions and showers are redone until a junction-free topology is found."},{"name":"BeamRemnants:beamJunction","link":"BeamRemnants.html#anchor20","text":"BeamRemnants:beamJunction This parameter is only relevant if the new colour reconnection scheme is used. (see BeamRemnants:beamJunction colour reconnection ) This parameter tells whether to form a junction or a di-quark if more than two valence quarks are found in the beam remnants. If off a di-quark is formed and if on a junction will be formed."},{"name":"BeamRemnants:companionPower","link":"BeamRemnants.html#anchor12","text":"BeamRemnants:companionPower When a sea quark has been found, a companion antisea quark ought to be nearby in BeamRemnants:companionPower x. The shape of this distribution can be derived from the gluon mother distribution convoluted with the BeamRemnants:companionPower g &rarr; q qbar splitting kernel. In practice, simple solutions are only feasible if the gluon shape is assumed to be of the form BeamRemnants:companionPower g(x) ~ (1 - x)^p / x , where BeamRemnants:companionPower p is an integer power, the parameter above. Allowed values correspond to the cases programmed. BeamRemnants:companionPower Since the whole framework is approximate anyway, this should be good enough. Note that companions typically are found at small BeamRemnants:companionPower Q^2 , if at all, so the form is supposed to represent BeamRemnants:companionPower g(x) at small BeamRemnants:companionPower Q^2 scales, close to the lower cutoff for multiparton interactions."},{"name":"BeamRemnants:gluonPower","link":"BeamRemnants.html#anchor17","text":"BeamRemnants:gluonPower The abovementioned power for gluons."},{"name":"BeamRemnants:halfMassForKT","link":"BeamRemnants.html#anchor5","text":"BeamRemnants:halfMassForKT The scale BeamRemnants:halfMassForKT m_half in the equation above, defining the half-way point between low-mass and high-mass subsystems. (Kinematics construction can easily fail if a system is assigned a primordial BeamRemnants:halfMassForKT kT value higher than its mass, so the mass-dampening is intended to reduce some troubles later on.)"},{"name":"BeamRemnants:halfScaleForKT","link":"BeamRemnants.html#anchor4","text":"BeamRemnants:halfScaleForKT The scale BeamRemnants:halfScaleForKT Q_half in the equation above, defining the half-way point between hard and soft interactions."},{"name":"BeamRemnants:maxValQuark","link":"BeamRemnants.html#anchor11","text":"BeamRemnants:maxValQuark The maximum valence quark kind allowed in acceptable incoming beams, for which multiparton interactions are simulated. Default is that hadrons may contain BeamRemnants:maxValQuark u , BeamRemnants:maxValQuark d and BeamRemnants:maxValQuark s quarks, but not BeamRemnants:maxValQuark c and BeamRemnants:maxValQuark b ones, since sensible kinematics has not really been worked out for the latter."},{"name":"BeamRemnants:primordialKT","link":"BeamRemnants.html#anchor1","text":"BeamRemnants:primordialKT Allow or not selection of primordial BeamRemnants:primordialKT kT according to the parameter values below."},{"name":"BeamRemnants:primordialKThard","link":"BeamRemnants.html#anchor3","text":"BeamRemnants:primordialKThard The width BeamRemnants:primordialKThard sigma_hard in the above equation, assigned as a primordial BeamRemnants:primordialKThard kT to initiators in the hard-interaction limit."},{"name":"BeamRemnants:primordialKTremnant","link":"BeamRemnants.html#anchor7","text":"BeamRemnants:primordialKTremnant The width BeamRemnants:primordialKTremnant sigma_remn , assigned as a primordial BeamRemnants:primordialKTremnant kT to beam-remnant partons."},{"name":"BeamRemnants:primordialKTsoft","link":"BeamRemnants.html#anchor2","text":"BeamRemnants:primordialKTsoft The width BeamRemnants:primordialKTsoft sigma_soft in the above equation, assigned as a primordial BeamRemnants:primordialKTsoft kT to initiators in the soft-interaction limit."},{"name":"BeamRemnants:reducedKTatHighY","link":"BeamRemnants.html#anchor6","text":"BeamRemnants:reducedKTatHighY For a system of mass BeamRemnants:reducedKTatHighY m and energy BeamRemnants:reducedKTatHighY E the dampening factor BeamRemnants:reducedKTatHighY y_damp above is defined as BeamRemnants:reducedKTatHighY y_damp = pow( E/m, r_red) , where BeamRemnants:reducedKTatHighY r_red is the current parameter. The effect is to reduce the primordial BeamRemnants:reducedKTatHighY kT of low-mass systems extra much if they are at large rapidities (recall that BeamRemnants:reducedKTatHighY E/m = cosh(y) before BeamRemnants:reducedKTatHighY kT is added). The reason for this dampening is purely technical, and for reasonable values should not have dramatic consequences overall."},{"name":"BeamRemnants:remnantMode","link":"BeamRemnants.html#anchor9","text":"BeamRemnants:remnantMode Switch to choose between the two different colour models for the beam remnant. BeamRemnants:remnantMode The old beam remnant model. BeamRemnants:remnantMode The new beam remnant model."},{"name":"BeamRemnants:rescatterRestoreY","link":"BeamRemnants.html#anchor8","text":"BeamRemnants:rescatterRestoreY Is only relevant when BeamRemnants:rescatterRestoreY rescattering is switched on in the multiparton interactions scenario. For a normal interaction the rapidity and mass of a system is preserved when primordial BeamRemnants:rescatterRestoreY kT is introduced, by appropriate modification of the incoming parton momenta. Kinematics construction is more complicated for a rescattering, and two options are offered. Differences between these can be used to explore systematic uncertainties in the rescattering framework. BeamRemnants:rescatterRestoreY The default behaviour is to keep the incoming rescattered parton as is, but to modify the unrescattered incoming parton so as to preserve the invariant mass of the system. Thereby the rapidity of the rescattering is modified. BeamRemnants:rescatterRestoreY The alternative is to retain the rapidity (and mass) of the rescattered system when primordial BeamRemnants:rescatterRestoreY kT is introduced. This is made at the expense of a modified longitudinal momentum of the incoming rescattered parton, so that it does not agree with the momentum it ought to have had by the kinematics of the previous interaction. BeamRemnants:rescatterRestoreY For a double rescattering, when both incoming partons have already scattered, there is no obvious way to retain the invariant mass of the system in the first approach, so the second is always used."},{"name":"BeamRemnants:saturation","link":"BeamRemnants.html#anchor10","text":"BeamRemnants:saturation Controls the suppresion due to saturation in the new model. The exact formula used is BeamRemnants:saturation exp(-M / k) , where M is the multiplet size and k is this parameter. Thus a small number will result in a large saturation."},{"name":"BeamRemnants:unresolvedHadron","link":"BeamRemnants.html#anchor22","text":"BeamRemnants:unresolvedHadron Switch to to force either or both of the beam remnants to collapse to a single hadron, namely the original incoming one. Must only be used when this is physically meaningful, e.g. when a photon can be viewed as emitted from a proton that does not break up in the process. BeamRemnants:unresolvedHadron Both hadronic beams are resolved. BeamRemnants:unresolvedHadron Beam A is unresolved, beam B resolved. BeamRemnants:unresolvedHadron Beam A is resolved, beam B unresolved. BeamRemnants:unresolvedHadron Both hadronic beams are unresolved."},{"name":"BeamRemnants:valenceDiqEnhance","link":"BeamRemnants.html#anchor16","text":"BeamRemnants:valenceDiqEnhance Enhancement factor for valence diquarks in baryons, relative to the simple sum of the two constituent quarks."},{"name":"BeamRemnants:valencePowerDinP","link":"BeamRemnants.html#anchor15","text":"BeamRemnants:valencePowerDinP The abovementioned power for valence BeamRemnants:valencePowerDinP d quarks in protons."},{"name":"BeamRemnants:valencePowerMeson","link":"BeamRemnants.html#anchor13","text":"BeamRemnants:valencePowerMeson The abovementioned power for valence quarks in mesons."},{"name":"BeamRemnants:valencePowerUinP","link":"BeamRemnants.html#anchor14","text":"BeamRemnants:valencePowerUinP The abovementioned power for valence BeamRemnants:valencePowerUinP u quarks in protons."},{"name":"BeamRemnants:xGluonCutoff","link":"BeamRemnants.html#anchor18","text":"BeamRemnants:xGluonCutoff The gluon PDF is approximated with BeamRemnants:xGluonCutoff g(x) ~ (1 - x)^p / x , which integrates to infinity when integrated from 0 to 1. This cut-off is introduced as a minimum to avoid the problems with infinities."},{"name":"Beams:allowMomentumSpread","link":"BeamParameters.html#anchor26","text":"Beams:allowMomentumSpread Allow the beam momenta to be smeared around their initialization nominal values."},{"name":"Beams:allowVariableEnergy","link":"BeamParameters.html#anchor20","text":"Beams:allowVariableEnergy Master switch to allow collision energies below the initialization one, as described above."},{"name":"Beams:allowVertexSpread","link":"BeamParameters.html#anchor35","text":"Beams:allowVertexSpread Allow the interaction vertex of the two colliding beams to be smeared. If off, then the vertex is set to be the origin."},{"name":"Beams:eA","link":"BeamParameters.html#anchor5","text":"Beams:eA The energy of the first incoming particle, moving in the Beams:eA +z direction, to be set if Beams:eA Beams:frameType = 2. If the particle energy is smaller than its mass it is assumed to be at rest."},{"name":"Beams:eB","link":"BeamParameters.html#anchor6","text":"Beams:eB The energy of the second incoming particle, moving in the Beams:eB -z direction, to be set if Beams:eB Beams:frameType = 2. If the particle energy is smaller than its mass it is assumed to be at rest."},{"name":"Beams:eCM","link":"BeamParameters.html#anchor4","text":"Beams:eCM Collision CM energy, to be set if Beams:eCM Beams:frameType = 1."},{"name":"Beams:eMinPert","link":"BeamParameters.html#anchor21","text":"Beams:eMinPert The lowest CM energy that collisions are allowed to have. The highest is set by the full energy at initialization, as calculated in the respective options above. If you do not want to generate events with a higher collision energy than this you can save some initialization time by raising this number accordingly, so that fewer grid energies need to be used. You should not lower the value below the default one, however, since the perturbative MPI machinery cannot be made to work at lower energies. If you do want to generate events with lower energies, it is possible in a nonperturbative framework, see next."},{"name":"Beams:eWidthPert","link":"BeamParameters.html#anchor22","text":"Beams:eWidthPert A simpler low-mass description can be used for energies below the threshold energy Beams:eWidthPert e_min = Beams:eWidthPert eMinPert above, with only longitudinally stretched strings. A gradual switch-over between the simple low-energy and perturbative high-energy regimes is then natural. The probability for the latter picture is parametrized as Beams:eWidthPert P_pert = 1 - exp( (e_CM - e_min) / e_width ) which vanishes for the CM energy Beams:eWidthPert e_CM < e_min , and is Beams:eWidthPert 1 - 1/e = 0.632 for Beams:eWidthPert e_CM = e_min + e_width. The current parameter is this Beams:eWidthPert e_width."},{"name":"Beams:frameType","link":"BeamParameters.html#anchor3","text":"Beams:frameType Choice of frame for the two colliding particles. For options 1 - 3 the beam identities are specified above, while they are obtained by the Les Houches information for options 4 and 5. Beams:frameType the beams are colliding in their CM frame, and therefore only the CM energy needs to be provided, see Beams:frameType Beams:eCM below. Beams:frameType the beams are back-to-back, but with different energies, see Beams:frameType Beams:eA and Beams:frameType Beams:eB below. This option could also be used for fixed-target configurations. Beams:frameType the beams are not back-to-back, and therefore the three-momentum of each incoming particle needs to be specified, see Beams:frameType Beams:pxA through Beams:frameType Beams:pzB below. Beams:frameType the beam and event information is stored in a Beams:frameType Les Houches Event File , see Beams:frameType Beams:LHEF below. Beams:frameType the beam and event information is obtained by a pointer to an Beams:frameType Beams:frameType LHAup class instance."},{"name":"Beams:idA","link":"BeamParameters.html#anchor1","text":"Beams:idA The PDG Beams:idA id code for the first incoming particle. Allowed codes include Beams:idA Beams:idA 2212 = p , Beams:idA -2212 = pbar , Beams:idA Beams:idA 2112 = n , Beams:idA -2112 = nbar , Beams:idA Beams:idA 211 = pi^+ , Beams:idA -211 = pi^- , Beams:idA 111 = pi^0 , Beams:idA Beams:idA 990 = Pomeron (used in diffractive machinery; here mainly for debug purposes), Beams:idA Beams:idA 22 = gamma (for Beams:idA gamma-gamma and Beams:idA gamma-hadron interactions, more info Beams:idA here ), Beams:idA Beams:idA 11 = e^- , Beams:idA -11 = e^+ , Beams:idA Beams:idA 13 = mu^- , Beams:idA -13 = mu^+ , Beams:idA and a few more leptons/neutrinos in a few combinations. Beams:idA Recently Beams:idA heavy-ion collisions have been implemented in PYTHIA. Therefore a handful of nuclei have been added as allowed incoming beams, using PDG codes of the format Beams:idA 100ZZZAAAI : 1000020040 = Beams:idA 4 He , 1000030060 = Beams:idA 6 Li, 1000060120 = Beams:idA 12 C, 1000080160 = Beams:idA 16 O, 1000290630 = Beams:idA 63 Cu, 1000791970 = Beams:idA 197 Au, and 1000822080 = Beams:idA 208 Pb. More can be added using the function Beams:idA ParticleData::addParticle."},{"name":"Beams:idB","link":"BeamParameters.html#anchor2","text":"Beams:idB The PDG Beams:idB id code for the second incoming particle."},{"name":"Beams:LHEF","link":"BeamParameters.html#anchor13","text":"Beams:LHEF The name of a Les Houches Event File, to be set if Beams:LHEF Beams:frameType = 4."},{"name":"Beams:LHEFheader","link":"BeamParameters.html#anchor14","text":"Beams:LHEFheader As some information in a Les Houches Event File init block is only known at the end of generation, some programs choose to output this as a separate file. If Beams:LHEFheader Beams:LHEFheader is given, information up till the end of the init block is read from this file, with the events themselves read as usual from the file given in Beams:LHEFheader Beams:LHEF."},{"name":"Beams:maxDevA","link":"BeamParameters.html#anchor30","text":"Beams:maxDevA The triply Gaussian distribution Beams:maxDevA (p_x, p_y, p_z) is restricted to a maximal total deviation from the nominal values Beams:maxDevA (p_x0, p_y0, p_z0) for the first incoming particle, like Beams:maxDevA (p_x - p_x0)^2/sigma_px^2 + (p_y - p_y0)^2/sigma_py^2 + (p_z - p_z0)^2/sigma_pz^2 < maxDev^2 (Note the absence of a factor 2 in the denominator, unlike the Gaussians used to pick Beams:maxDevA (p_x, p_y, p_z) .)"},{"name":"Beams:maxDevB","link":"BeamParameters.html#anchor34","text":"Beams:maxDevB The triply Gaussian distribution Beams:maxDevB (p_x, p_y, p_z) is restricted to a maximal total deviation from the nominal values Beams:maxDevB (p_x0, p_y0, p_z0) , for the second incoming particle, like Beams:maxDevB (p_x - p_x0)^2/sigma_px^2 + (p_y - p_y0)^2/sigma_py^2 + (p_z - p_z0)^2/sigma_pz^2 < maxDev^2 (Note the absence of a factor 2 in the denominator, unlike the Gaussians used to pick Beams:maxDevB (p_x, p_y, p_z) .)"},{"name":"Beams:maxDevTime","link":"BeamParameters.html#anchor41","text":"Beams:maxDevTime The collision time is restricted to be in the range Beams:maxDevTime |t| < sigma_t * maxDevTime."},{"name":"Beams:maxDevVertex","link":"BeamParameters.html#anchor39","text":"Beams:maxDevVertex The triply Gaussian distribution of interaction vertex position Beams:maxDevVertex (x, y, z) is restricted to a maximal total deviation from the origin, like Beams:maxDevVertex x^2/sigma_x^2 + y^2/sigma_y^2 + z^2/sigma_z^2 < maxDevVertex^2 (Note the absence of a factor 2 in the denominator, unlike the Gaussians used to pick Beams:maxDevVertex (x, y, z) .)"},{"name":"Beams:newLHEFsameInit","link":"BeamParameters.html#anchor15","text":"Beams:newLHEFsameInit Allow to begin reading events from a new LHEF or or a new Beams:newLHEFsameInit LHAup instance without a completely new initialization. Only useful when Beams:newLHEFsameInit Beams:frameType = 4 or 5."},{"name":"Beams:nSkipLHEFatInit","link":"BeamParameters.html#anchor17","text":"Beams:nSkipLHEFatInit Skip the first Beams:nSkipLHEFatInit nSkip events of the input stream (cf. the Beams:nSkipLHEFatInit LHAup::skipEvent(nSkip) method). Only used when Beams:nSkipLHEFatInit Beams:frameType = 4 or 5."},{"name":"Beams:offsetTime","link":"BeamParameters.html#anchor45","text":"Beams:offsetTime The time Beams:offsetTime t of the interaction vertex is centered at this value."},{"name":"Beams:offsetVertexX","link":"BeamParameters.html#anchor42","text":"Beams:offsetVertexX The Beams:offsetVertexX x location of the interaction vertex is centered at this value."},{"name":"Beams:offsetVertexY","link":"BeamParameters.html#anchor43","text":"Beams:offsetVertexY The Beams:offsetVertexY y location of the interaction vertex is centered at this value."},{"name":"Beams:offsetVertexZ","link":"BeamParameters.html#anchor44","text":"Beams:offsetVertexZ The Beams:offsetVertexZ z location of the interaction vertex is centered at this value."},{"name":"Beams:pxA","link":"BeamParameters.html#anchor7","text":"Beams:pxA The Beams:pxA p_x component of the first incoming particle, to be set if Beams:pxA Beams:frameType = 3."},{"name":"Beams:pxB","link":"BeamParameters.html#anchor10","text":"Beams:pxB The Beams:pxB p_x component of the second incoming particle, to be set if Beams:pxB Beams:frameType = 3."},{"name":"Beams:pyA","link":"BeamParameters.html#anchor8","text":"Beams:pyA The Beams:pyA p_y component of the first incoming particle, to be set if Beams:pyA Beams:frameType = 3."},{"name":"Beams:pyB","link":"BeamParameters.html#anchor11","text":"Beams:pyB The Beams:pyB p_y component of the second incoming particle, to be set if Beams:pyB Beams:frameType = 3."},{"name":"Beams:pzA","link":"BeamParameters.html#anchor9","text":"Beams:pzA The Beams:pzA p_z component of the first incoming particle, to be set if Beams:pzA Beams:frameType = 3."},{"name":"Beams:pzB","link":"BeamParameters.html#anchor12","text":"Beams:pzB The Beams:pzB p_z component of the second incoming particle, to be set if Beams:pzB Beams:frameType = 3."},{"name":"Beams:readLHEFheaders","link":"BeamParameters.html#anchor16","text":"Beams:readLHEFheaders Read in LHEF header blocks and store them in the Beams:readLHEFheaders Info class. See also Beams:readLHEFheaders LHAupLHEF and the Beams:readLHEFheaders Les Houches Event files section for more information."},{"name":"Beams:setProductionScalesFromLHEF","link":"BeamParameters.html#anchor19","text":"Beams:setProductionScalesFromLHEF If enabled, production scales for all particles in an input Les Houches event will be set by using auxiliary information provided in the input event. Depending on which LHEF version is used, different information will be read. For LHEF 1.0, scale information can be transferred by including a line starting with the hashtag (#) character at the end of the event. The hashtag should be followed by the sequential scale values of the particles with status 1. For LHEF 3.0, the standardised Beams:setProductionScalesFromLHEF <scales> tag is used instead. In this case, please ensure that production scale of the final state particle with position Beams:setProductionScalesFromLHEF i in the input event will be transferred as the value of a scales tag attribute which contains Beams:setProductionScalesFromLHEF i at the end of the attribute name, separated from the rest of the name by an underscore (_). An example Beams:setProductionScalesFromLHEF <scales> tag would be Beams:setProductionScalesFromLHEF <scales muf='100' pt_start_3='100' pt_start_4='50'> </scales>. This could be used to set the production scales of particles three and four to 100 GeV and 50 GeV, respectively, provided that these particles have status 1."},{"name":"Beams:sigmaPxA","link":"BeamParameters.html#anchor27","text":"Beams:sigmaPxA The width of a Gaussian distribution of the Beams:sigmaPxA p_x spread of the first incoming particle."},{"name":"Beams:sigmaPxB","link":"BeamParameters.html#anchor31","text":"Beams:sigmaPxB The width of a Gaussian distribution of the Beams:sigmaPxB p_x spread of the second incoming particle."},{"name":"Beams:sigmaPyA","link":"BeamParameters.html#anchor28","text":"Beams:sigmaPyA The width of a Gaussian distribution of the Beams:sigmaPyA p_y spread of the first incoming particle."},{"name":"Beams:sigmaPyB","link":"BeamParameters.html#anchor32","text":"Beams:sigmaPyB The width of a Gaussian distribution of the Beams:sigmaPyB p_y spread of the second incoming particle."},{"name":"Beams:sigmaPzA","link":"BeamParameters.html#anchor29","text":"Beams:sigmaPzA The width of a Gaussian distribution of the Beams:sigmaPzA p_z spread of the first incoming particle."},{"name":"Beams:sigmaPzB","link":"BeamParameters.html#anchor33","text":"Beams:sigmaPzB The width of a Gaussian distribution of the Beams:sigmaPzB p_z spread of the second incoming particle."},{"name":"Beams:sigmaTime","link":"BeamParameters.html#anchor40","text":"Beams:sigmaTime The width of a Gaussian distribution of the collision time (in units of mm/c). Note that, if the above space parametrization is viewed as the effect of two incoming beams along the Beams:sigmaTime +-z axis, with each beam having a Gaussian spread, then the spread of the time would also become a Gaussian with the same width as the Beams:sigmaTime z one (times the velocity of the beams, which we expect is close to unity). For flexibility we have not enforced any such relation, however."},{"name":"Beams:sigmaVertexX","link":"BeamParameters.html#anchor36","text":"Beams:sigmaVertexX The width of a Gaussian distribution of the Beams:sigmaVertexX x location of the interaction vertex."},{"name":"Beams:sigmaVertexY","link":"BeamParameters.html#anchor37","text":"Beams:sigmaVertexY The width of a Gaussian distribution of the Beams:sigmaVertexY y location of the interaction vertex."},{"name":"Beams:sigmaVertexZ","link":"BeamParameters.html#anchor38","text":"Beams:sigmaVertexZ The width of a Gaussian distribution of the Beams:sigmaVertexZ z location of the interaction vertex."},{"name":"Beams:strictLHEFscale","link":"BeamParameters.html#anchor18","text":"Beams:strictLHEFscale Always use the Beams:strictLHEFscale SCALUP value read from LHEF as production scale for particles, also including particles coming from resonance decays. By default, the production scale of resonance decay products (W-, Z-, H-bosons, top quarks) will be set to Beams:strictLHEFscale M/2 , where Beams:strictLHEFscale M is the mass of the resonance."},{"name":"BoseEinstein:Eta","link":"BoseEinsteinEffects.html#anchor3","text":"BoseEinstein:Eta Include effects or not for identical BoseEinstein:Eta eta and BoseEinstein:Eta eta'."},{"name":"BoseEinstein:Kaon","link":"BoseEinsteinEffects.html#anchor2","text":"BoseEinstein:Kaon Include effects or not for identical BoseEinstein:Kaon K^+ , BoseEinstein:Kaon K^- , BoseEinstein:Kaon K_S^0 and BoseEinstein:Kaon K_L^0."},{"name":"BoseEinstein:lambda","link":"BoseEinsteinEffects.html#anchor4","text":"BoseEinstein:lambda The strength parameter for Bose-Einstein effects. On physical grounds it should not be above unity, but imperfections in the formalism used may require that nevertheless."},{"name":"BoseEinstein:Pion","link":"BoseEinsteinEffects.html#anchor1","text":"BoseEinstein:Pion Include effects or not for identical BoseEinstein:Pion pi^+ , BoseEinstein:Pion pi^- and BoseEinstein:Pion pi^0."},{"name":"BoseEinstein:QRef","link":"BoseEinsteinEffects.html#anchor5","text":"BoseEinstein:QRef The size parameter of the region in BoseEinstein:QRef Q space over which Bose-Einstein effects are significant.  Can be thought of as the inverse of an effective distance in normal space, BoseEinstein:QRef R = hbar / QRef , with BoseEinstein:QRef R as used in the above equation. That is, BoseEinstein:QRef f_2(Q) = (1 + lambda * exp(-(Q/QRef)^2)) * (...)."},{"name":"BoseEinstein:widthSep","link":"BoseEinsteinEffects.html#anchor6","text":"BoseEinstein:widthSep Particle species with a width above this value (in GeV) are assumed to be so short-lived that they decay before Bose-Einstein effects are considered, while otherwise they do not. In the former case the decay products thus can obtain shifted momenta, in the latter not. The default has been picked such that both BoseEinstein:widthSep rho and BoseEinstein:widthSep K^* decay products would be modified."},{"name":"Bottomonium:all","link":"OniaProcesses.html#anchor8","text":"Bottomonium:all Common switch for the group of bottomonium production, e.g. Bottomonium:all Upsilon and Bottomonium:all chi_b."},{"name":"Bottomonium:gg2bbbar(3DJ)[3DJ(1)]g","link":"OniaProcesses.html#anchor75","text":"Bottomonium:gg2bbbar(3DJ)[3DJ(1)]g Colour-singlet production of Bottomonium:gg2bbbar(3DJ)[3DJ(1)]g 3PJ bottomonium states via Bottomonium:gg2bbbar(3DJ)[3DJ(1)]g g g &rarr; bbbar[3DJ(1)] g. Code 517."},{"name":"Bottomonium:gg2bbbar(3DJ)[3PJ(8)]g","link":"OniaProcesses.html#anchor76","text":"Bottomonium:gg2bbbar(3DJ)[3PJ(8)]g Colour-octet production of Bottomonium:gg2bbbar(3DJ)[3PJ(8)]g 3DJ bottomonium states via Bottomonium:gg2bbbar(3DJ)[3PJ(8)]g g g &rarr; bbbar[3PJ(8)] g. Code 518."},{"name":"Bottomonium:gg2bbbar(3PJ)[3PJ(1)]g","link":"OniaProcesses.html#anchor66","text":"Bottomonium:gg2bbbar(3PJ)[3PJ(1)]g Colour-singlet production of Bottomonium:gg2bbbar(3PJ)[3PJ(1)]g 3PJ bottomonium states via Bottomonium:gg2bbbar(3PJ)[3PJ(1)]g g g &rarr; bbbar[3PJ(1)] g. Code 511."},{"name":"Bottomonium:gg2bbbar(3PJ)[3S1(8)]g","link":"OniaProcesses.html#anchor69","text":"Bottomonium:gg2bbbar(3PJ)[3S1(8)]g Colour-octet production of Bottomonium:gg2bbbar(3PJ)[3S1(8)]g 3PJ bottomonium states via Bottomonium:gg2bbbar(3PJ)[3S1(8)]g g g &rarr; bbbar[3S1(8)] g. Code 514."},{"name":"Bottomonium:gg2bbbar(3S1)[1S0(8)]g","link":"OniaProcesses.html#anchor57","text":"Bottomonium:gg2bbbar(3S1)[1S0(8)]g Colour-octet production of Bottomonium:gg2bbbar(3S1)[1S0(8)]g 3S1 bottomonium states via Bottomonium:gg2bbbar(3S1)[1S0(8)]g g g &rarr; bbbar[1S0(8)] g. Code 505."},{"name":"Bottomonium:gg2bbbar(3S1)[3PJ(8)]g","link":"OniaProcesses.html#anchor60","text":"Bottomonium:gg2bbbar(3S1)[3PJ(8)]g Colour-octet production of Bottomonium:gg2bbbar(3S1)[3PJ(8)]g 3S1 bottomonium states via Bottomonium:gg2bbbar(3S1)[3PJ(8)]g g g &rarr; bbbar[3PJ(8)] g. Code 508."},{"name":"Bottomonium:gg2bbbar(3S1)[3S1(1)]g","link":"OniaProcesses.html#anchor52","text":"Bottomonium:gg2bbbar(3S1)[3S1(1)]g Colour-singlet production of Bottomonium:gg2bbbar(3S1)[3S1(1)]g 3S1 bottomonium states via Bottomonium:gg2bbbar(3S1)[3S1(1)]g g g &rarr; bbbar[3S1(1)] g. Code 501."},{"name":"Bottomonium:gg2bbbar(3S1)[3S1(1)]gm","link":"OniaProcesses.html#anchor53","text":"Bottomonium:gg2bbbar(3S1)[3S1(1)]gm Colour-singlet production of Bottomonium:gg2bbbar(3S1)[3S1(1)]gm 3S1 bottomonium states via Bottomonium:gg2bbbar(3S1)[3S1(1)]gm g g &rarr; ccbar[3S1(1)] g with a hard Bottomonium:gg2bbbar(3S1)[3S1(1)]gm gamma. Code 551."},{"name":"Bottomonium:gg2bbbar(3S1)[3S1(8)]g","link":"OniaProcesses.html#anchor54","text":"Bottomonium:gg2bbbar(3S1)[3S1(8)]g Colour-octet production of Bottomonium:gg2bbbar(3S1)[3S1(8)]g 3S1 bottomonium states via Bottomonium:gg2bbbar(3S1)[3S1(8)]g g g &rarr; bbbar[3S1(8)] g. Code 502."},{"name":"Bottomonium:gg2doublebbbar(3S1)[3S1(1)]","link":"OniaProcesses.html#anchor83","text":"Bottomonium:gg2doublebbbar(3S1)[3S1(1)] Colour-singlet production of Bottomonium:gg2doublebbbar(3S1)[3S1(1)] 3S1 bottomonium state pairs via Bottomonium:gg2doublebbbar(3S1)[3S1(1)] g g &rarr; bbbar[3S1(1)] bbbar[3S1(1)]. Code 521."},{"name":"Bottomonium:O(3DJ)[3D1(1)]","link":"OniaProcesses.html#anchor73","text":"Bottomonium:O(3DJ)[3D1(1)] The color-singlet long-distance matrix elements Bottomonium:O(3DJ)[3D1(1)] <O[3D1(1)]> for the Bottomonium:O(3DJ)[3D1(1)] 3PJ bottomonium states. For a Bottomonium:O(3DJ)[3D1(1)] 3DJ bottomonium state where Bottomonium:O(3DJ)[3D1(1)] J is not Bottomonium:O(3DJ)[3D1(1)] 1 the long distance matrix element Bottomonium:O(3DJ)[3D1(1)] <O[3DJ(1)]> is calculated by Bottomonium:O(3DJ)[3D1(1)] (2J+1)<O[3D1(1)]/3> using leading order spin symmetry relations."},{"name":"Bottomonium:O(3DJ)[3P0(8)]","link":"OniaProcesses.html#anchor74","text":"Bottomonium:O(3DJ)[3P0(8)] The colour-octet long-distance matrix elements Bottomonium:O(3DJ)[3P0(8)] <O[3P0(8)]>/m_Q^2 for the 3DJ bottomonium states. The remaining Bottomonium:O(3DJ)[3P0(8)] <O[3PJ(8)]>/m_Q^2 are calculated from these long-distance matrix elements."},{"name":"Bottomonium:O(3PJ)[3P0(1)]","link":"OniaProcesses.html#anchor64","text":"Bottomonium:O(3PJ)[3P0(1)] The color-singlet long-distance matrix elements Bottomonium:O(3PJ)[3P0(1)] <O[3P0(1)]>/m_Q^2 for the Bottomonium:O(3PJ)[3P0(1)] 3PJ bottomonium states. The remaining Bottomonium:O(3PJ)[3P0(1)] <O[3PJ(1)]>/m_Q^2 are calculated from these long-distance matrix elements."},{"name":"Bottomonium:O(3PJ)[3S1(8)]","link":"OniaProcesses.html#anchor65","text":"Bottomonium:O(3PJ)[3S1(8)] The color-singlet long-distance matrix elements Bottomonium:O(3PJ)[3S1(8)] <O[3S1(8)]> for the Bottomonium:O(3PJ)[3S1(8)] 3PJ bottomonium states."},{"name":"Bottomonium:O(3S1)[1S0(8)]","link":"OniaProcesses.html#anchor50","text":"Bottomonium:O(3S1)[1S0(8)] The colour-octet long-distance matrix elements Bottomonium:O(3S1)[1S0(8)] <O[1S0(8)]> for the Bottomonium:O(3S1)[1S0(8)] 3S1 bottomonium states."},{"name":"Bottomonium:O(3S1)[3P0(8)]","link":"OniaProcesses.html#anchor51","text":"Bottomonium:O(3S1)[3P0(8)] The colour-octet long-distance matrix elements Bottomonium:O(3S1)[3P0(8)] <O[3P0(8)]>/m_Q^2 for the Bottomonium:O(3S1)[3P0(8)] 3S1 bottomonium states. The remaining Bottomonium:O(3S1)[3P0(8)] <O[3PJ(8)]>/m_Q^2 are calculated from these long-distance matrix elements."},{"name":"Bottomonium:O(3S1)[3S1(1)]","link":"OniaProcesses.html#anchor48","text":"Bottomonium:O(3S1)[3S1(1)] The colour-singlet long-distance matrix elements Bottomonium:O(3S1)[3S1(1)] <O[3S1(1)]> for the Bottomonium:O(3S1)[3S1(1)] 3S1 bottomonium states."},{"name":"Bottomonium:O(3S1)[3S1(1)]1","link":"OniaProcesses.html#anchor81","text":"Bottomonium:O(3S1)[3S1(1)]1 The color-singlet long-distance matrix elements Bottomonium:O(3S1)[3S1(1)]1 <O[3S1(1)]> for the first Bottomonium:O(3S1)[3S1(1)]1 3S1 bottomonium states."},{"name":"Bottomonium:O(3S1)[3S1(1)]2","link":"OniaProcesses.html#anchor82","text":"Bottomonium:O(3S1)[3S1(1)]2 The color-singlet long-distance matrix elements Bottomonium:O(3S1)[3S1(1)]2 <O[3S1(1)]> for the second Bottomonium:O(3S1)[3S1(1)]2 3S1 bottomonium states."},{"name":"Bottomonium:O(3S1)[3S1(8)]","link":"OniaProcesses.html#anchor49","text":"Bottomonium:O(3S1)[3S1(8)] The colour-octet long-distance matrix elements Bottomonium:O(3S1)[3S1(8)] <O[3S1(8)]> for the Bottomonium:O(3S1)[3S1(8)] 3S1 bottomonium states."},{"name":"Bottomonium:qg2bbbar(3DJ)[3PJ(8)]q","link":"OniaProcesses.html#anchor77","text":"Bottomonium:qg2bbbar(3DJ)[3PJ(8)]q Colour-octet production of Bottomonium:qg2bbbar(3DJ)[3PJ(8)]q 3DJ bottomonium states via Bottomonium:qg2bbbar(3DJ)[3PJ(8)]q q g &rarr; bbbar[3PJ(8)] q. Code 519."},{"name":"Bottomonium:qg2bbbar(3PJ)[3PJ(1)]q","link":"OniaProcesses.html#anchor67","text":"Bottomonium:qg2bbbar(3PJ)[3PJ(1)]q Colour-singlet production of Bottomonium:qg2bbbar(3PJ)[3PJ(1)]q 3PJ bottomonium states via Bottomonium:qg2bbbar(3PJ)[3PJ(1)]q q g &rarr; bbbar[3PJ(1)] q. Code 512."},{"name":"Bottomonium:qg2bbbar(3PJ)[3S1(8)]q","link":"OniaProcesses.html#anchor70","text":"Bottomonium:qg2bbbar(3PJ)[3S1(8)]q Colour-octet production of Bottomonium:qg2bbbar(3PJ)[3S1(8)]q 3PJ bottomonium states via Bottomonium:qg2bbbar(3PJ)[3S1(8)]q q g &rarr; bbbar[3S1(8)] q. Code 515."},{"name":"Bottomonium:qg2bbbar(3S1)[1S0(8)]q","link":"OniaProcesses.html#anchor58","text":"Bottomonium:qg2bbbar(3S1)[1S0(8)]q Colour-octet production of Bottomonium:qg2bbbar(3S1)[1S0(8)]q 3S1 bottomonium states via Bottomonium:qg2bbbar(3S1)[1S0(8)]q q g &rarr; bbbar[1S0(8)] q. Code 506."},{"name":"Bottomonium:qg2bbbar(3S1)[3PJ(8)]q","link":"OniaProcesses.html#anchor61","text":"Bottomonium:qg2bbbar(3S1)[3PJ(8)]q Colour-octet production of Bottomonium:qg2bbbar(3S1)[3PJ(8)]q 3S1 bottomonium states via Bottomonium:qg2bbbar(3S1)[3PJ(8)]q q g &rarr; bbbar[3PJ(8)] q. Code 509."},{"name":"Bottomonium:qg2bbbar(3S1)[3S1(8)]q","link":"OniaProcesses.html#anchor55","text":"Bottomonium:qg2bbbar(3S1)[3S1(8)]q Colour-octet production of Bottomonium:qg2bbbar(3S1)[3S1(8)]q 3S1 bottomonium states via Bottomonium:qg2bbbar(3S1)[3S1(8)]q q g &rarr; bbbar[3S1(8)] q. Code 503."},{"name":"Bottomonium:qqbar2bbbar(3DJ)[3PJ(8)]g","link":"OniaProcesses.html#anchor78","text":"Bottomonium:qqbar2bbbar(3DJ)[3PJ(8)]g Colour-octet production of Bottomonium:qqbar2bbbar(3DJ)[3PJ(8)]g 3DJ bottomonium states via Bottomonium:qqbar2bbbar(3DJ)[3PJ(8)]g q qbar &rarr; bbbar[3PJ(8)] g. Code 520."},{"name":"Bottomonium:qqbar2bbbar(3PJ)[3PJ(1)]g","link":"OniaProcesses.html#anchor68","text":"Bottomonium:qqbar2bbbar(3PJ)[3PJ(1)]g Colour-singlet production of Bottomonium:qqbar2bbbar(3PJ)[3PJ(1)]g 3PJ bottomonium states via Bottomonium:qqbar2bbbar(3PJ)[3PJ(1)]g q qbar &rarr; bbbar[3PJ(1)] g. Code 513."},{"name":"Bottomonium:qqbar2bbbar(3PJ)[3S1(8)]g","link":"OniaProcesses.html#anchor71","text":"Bottomonium:qqbar2bbbar(3PJ)[3S1(8)]g Colour-octet production of Bottomonium:qqbar2bbbar(3PJ)[3S1(8)]g 3PJ bottomonium states via Bottomonium:qqbar2bbbar(3PJ)[3S1(8)]g q qbar &rarr; bbbar[3S1(8)] g. Code 516."},{"name":"Bottomonium:qqbar2bbbar(3S1)[1S0(8)]g","link":"OniaProcesses.html#anchor59","text":"Bottomonium:qqbar2bbbar(3S1)[1S0(8)]g Colour-octet production of Bottomonium:qqbar2bbbar(3S1)[1S0(8)]g 3S1 bottomonium states via Bottomonium:qqbar2bbbar(3S1)[1S0(8)]g q qbar &rarr; bbbar[1S0(8)] g. Code 507."},{"name":"Bottomonium:qqbar2bbbar(3S1)[3PJ(8)]g","link":"OniaProcesses.html#anchor62","text":"Bottomonium:qqbar2bbbar(3S1)[3PJ(8)]g Colour-octet production of Bottomonium:qqbar2bbbar(3S1)[3PJ(8)]g 3S1 bottomonium states via Bottomonium:qqbar2bbbar(3S1)[3PJ(8)]g q qbar &rarr; bbbar[3SJ(8)] g. Code 510."},{"name":"Bottomonium:qqbar2bbbar(3S1)[3S1(8)]g","link":"OniaProcesses.html#anchor56","text":"Bottomonium:qqbar2bbbar(3S1)[3S1(8)]g Colour-octet production of Bottomonium:qqbar2bbbar(3S1)[3S1(8)]g 3S1 bottomonium states via Bottomonium:qqbar2bbbar(3S1)[3S1(8)]g q qbar &rarr; bbbar[3S1(8)] g. Code 504."},{"name":"Bottomonium:qqbar2doublebbbar(3S1)[3S1(1)]","link":"OniaProcesses.html#anchor84","text":"Bottomonium:qqbar2doublebbbar(3S1)[3S1(1)] Colour-singlet production of Bottomonium:qqbar2doublebbbar(3S1)[3S1(1)] 3S1 bottomonium state pairs via Bottomonium:qqbar2doublebbbar(3S1)[3S1(1)] q qbar &rarr; bbbar[3S1(1)] bbbar[3S1(1)]. Code 522."},{"name":"Bottomonium:states(3DJ)","link":"OniaProcesses.html#anchor72","text":"Bottomonium:states(3DJ) The Bottomonium:states(3DJ) 3DJ bottomonium states that can be produced from the following processes. Currently, no Bottomonium:states(3DJ) 3DJ states are included in the default Bottomonium:states(3DJ) ParticleData and so none are included here. Note that all vectors within this section, either of flags or parameters, must be the same length as this vector."},{"name":"Bottomonium:states(3PJ)","link":"OniaProcesses.html#anchor63","text":"Bottomonium:states(3PJ) The Bottomonium:states(3PJ) 3PJ bottomonium states that can be produced from the following processes. Note that all vectors within this section, either of flags or parameters, must be the same length as this vector."},{"name":"Bottomonium:states(3S1)","link":"OniaProcesses.html#anchor47","text":"Bottomonium:states(3S1) The Bottomonium:states(3S1) 3S1 bottomonium states that can be produced from the following processes. Note that all vectors within this section, either of flags or parameters, must be the same length as this vector."},{"name":"Bottomonium:states(3S1)1","link":"OniaProcesses.html#anchor79","text":"Bottomonium:states(3S1)1 The first Bottomonium:states(3S1)1 3S1 bottomonium states of the bottomonium pairs that can be produced from the following processes. Note that all vectors within this section, either of modes, flags, or parameters, must be the same length as this vector."},{"name":"Bottomonium:states(3S1)2","link":"OniaProcesses.html#anchor80","text":"Bottomonium:states(3S1)2 The second Bottomonium:states(3S1)2 3S1 bottomonium states of the bottomonium pairs that can be produced from the following processes."},{"name":"Charmonium:all","link":"OniaProcesses.html#anchor7","text":"Charmonium:all Common switch for the group of charmonium production, e.g. Charmonium:all J/psi and Charmonium:all chi_c."},{"name":"Charmonium:gg2ccbar(3DJ)[3DJ(1)]g","link":"OniaProcesses.html#anchor37","text":"Charmonium:gg2ccbar(3DJ)[3DJ(1)]g Colour-singlet production of Charmonium:gg2ccbar(3DJ)[3DJ(1)]g 3PJ charmonium states via Charmonium:gg2ccbar(3DJ)[3DJ(1)]g g g &rarr; ccbar[3DJ(1)] g. Code 417."},{"name":"Charmonium:gg2ccbar(3DJ)[3PJ(8)]g","link":"OniaProcesses.html#anchor38","text":"Charmonium:gg2ccbar(3DJ)[3PJ(8)]g Colour-octet production of Charmonium:gg2ccbar(3DJ)[3PJ(8)]g 3DJ charmonium states via Charmonium:gg2ccbar(3DJ)[3PJ(8)]g g g &rarr; ccbar[3PJ(8)] g. Code 418."},{"name":"Charmonium:gg2ccbar(3PJ)[3PJ(1)]g","link":"OniaProcesses.html#anchor28","text":"Charmonium:gg2ccbar(3PJ)[3PJ(1)]g Colour-singlet production of Charmonium:gg2ccbar(3PJ)[3PJ(1)]g 3PJ charmonium states via Charmonium:gg2ccbar(3PJ)[3PJ(1)]g g g &rarr; ccbar[3PJ(1)] g. Code 411."},{"name":"Charmonium:gg2ccbar(3PJ)[3S1(8)]g","link":"OniaProcesses.html#anchor31","text":"Charmonium:gg2ccbar(3PJ)[3S1(8)]g Colour-octet production of Charmonium:gg2ccbar(3PJ)[3S1(8)]g 3PJ charmonium states via Charmonium:gg2ccbar(3PJ)[3S1(8)]g g g &rarr; ccbar[3S1(8)] g. Code 414."},{"name":"Charmonium:gg2ccbar(3S1)[1S0(8)]g","link":"OniaProcesses.html#anchor19","text":"Charmonium:gg2ccbar(3S1)[1S0(8)]g Colour-octet production of Charmonium:gg2ccbar(3S1)[1S0(8)]g 3S1 charmonium states via Charmonium:gg2ccbar(3S1)[1S0(8)]g g g &rarr; ccbar[1S0(8)] g. Code 405."},{"name":"Charmonium:gg2ccbar(3S1)[3PJ(8)]g","link":"OniaProcesses.html#anchor22","text":"Charmonium:gg2ccbar(3S1)[3PJ(8)]g Colour-octet production of Charmonium:gg2ccbar(3S1)[3PJ(8)]g 3S1 charmonium states via Charmonium:gg2ccbar(3S1)[3PJ(8)]g g g &rarr; ccbar[3PJ(8)] g. Code 408."},{"name":"Charmonium:gg2ccbar(3S1)[3S1(1)]g","link":"OniaProcesses.html#anchor14","text":"Charmonium:gg2ccbar(3S1)[3S1(1)]g Colour-singlet production of Charmonium:gg2ccbar(3S1)[3S1(1)]g 3S1 charmonium states via Charmonium:gg2ccbar(3S1)[3S1(1)]g g g &rarr; ccbar[3S1(1)] g. Code 401."},{"name":"Charmonium:gg2ccbar(3S1)[3S1(1)]gm","link":"OniaProcesses.html#anchor15","text":"Charmonium:gg2ccbar(3S1)[3S1(1)]gm Colour-singlet production of Charmonium:gg2ccbar(3S1)[3S1(1)]gm 3S1 charmonium states via Charmonium:gg2ccbar(3S1)[3S1(1)]gm g g &rarr; ccbar[3S1(1)] g with a hard Charmonium:gg2ccbar(3S1)[3S1(1)]gm gamma. Code 441."},{"name":"Charmonium:gg2ccbar(3S1)[3S1(8)]g","link":"OniaProcesses.html#anchor16","text":"Charmonium:gg2ccbar(3S1)[3S1(8)]g Colour-octet production of Charmonium:gg2ccbar(3S1)[3S1(8)]g 3S1 charmonium states via Charmonium:gg2ccbar(3S1)[3S1(8)]g g g &rarr; ccbar[3S1(8)] g. Code 402."},{"name":"Charmonium:gg2doubleccbar(3S1)[3S1(1)]","link":"OniaProcesses.html#anchor45","text":"Charmonium:gg2doubleccbar(3S1)[3S1(1)] Colour-singlet production of Charmonium:gg2doubleccbar(3S1)[3S1(1)] 3S1 charmonium state pairs via Charmonium:gg2doubleccbar(3S1)[3S1(1)] g g &rarr; ccbar[3S1(1)] ccbar[3S1(1)]. Code 421."},{"name":"Charmonium:O(3DJ)[3D1(1)]","link":"OniaProcesses.html#anchor35","text":"Charmonium:O(3DJ)[3D1(1)] The color-singlet long-distance matrix elements Charmonium:O(3DJ)[3D1(1)] <O[3D1(1)]> for the Charmonium:O(3DJ)[3D1(1)] 3PJ charmonium states. For a Charmonium:O(3DJ)[3D1(1)] 3DJ charmonium state where Charmonium:O(3DJ)[3D1(1)] J is not Charmonium:O(3DJ)[3D1(1)] 1 the long distance matrix element Charmonium:O(3DJ)[3D1(1)] <O[3DJ(1)]> is calculated by Charmonium:O(3DJ)[3D1(1)] (2J+1)<O[3D1(1)]/3> using leading order spin symmetry relations."},{"name":"Charmonium:O(3DJ)[3P0(8)]","link":"OniaProcesses.html#anchor36","text":"Charmonium:O(3DJ)[3P0(8)] The colour-octet long-distance matrix elements Charmonium:O(3DJ)[3P0(8)] <O[3P0(8)]>/m_Q^2 for the 3DJ charmonium states. The remaining Charmonium:O(3DJ)[3P0(8)] <O[3PJ(8)]>/m_Q^2 are calculated from these long-distance matrix elements."},{"name":"Charmonium:O(3PJ)[3P0(1)]","link":"OniaProcesses.html#anchor26","text":"Charmonium:O(3PJ)[3P0(1)] The color-singlet long-distance matrix elements Charmonium:O(3PJ)[3P0(1)] <O[3P0(1)]>/m_Q^2 for the Charmonium:O(3PJ)[3P0(1)] 3PJ charmonium states. The remaining Charmonium:O(3PJ)[3P0(1)] <O[3PJ(1)]>/m_Q^2 are calculated from these long-distance matrix elements."},{"name":"Charmonium:O(3PJ)[3S1(8)]","link":"OniaProcesses.html#anchor27","text":"Charmonium:O(3PJ)[3S1(8)] The color-singlet long-distance matrix elements Charmonium:O(3PJ)[3S1(8)] <O[3S1(8)]> for the Charmonium:O(3PJ)[3S1(8)] 3PJ charmonium states."},{"name":"Charmonium:O(3S1)[1S0(8)]","link":"OniaProcesses.html#anchor12","text":"Charmonium:O(3S1)[1S0(8)] The colour-octet long-distance matrix elements Charmonium:O(3S1)[1S0(8)] <O[1S0(8)]> for the Charmonium:O(3S1)[1S0(8)] 3S1 charmonium states."},{"name":"Charmonium:O(3S1)[3P0(8)]","link":"OniaProcesses.html#anchor13","text":"Charmonium:O(3S1)[3P0(8)] The colour-octet long-distance matrix elements Charmonium:O(3S1)[3P0(8)] <O[3P0(8)]>/m_Q^2 for the Charmonium:O(3S1)[3P0(8)] 3S1 charmonium states. The remaining Charmonium:O(3S1)[3P0(8)] <O[3PJ(8)]>/m_Q^2 are calculated from these long-distance matrix elements."},{"name":"Charmonium:O(3S1)[3S1(1)]","link":"OniaProcesses.html#anchor10","text":"Charmonium:O(3S1)[3S1(1)] The colour-singlet long-distance matrix elements Charmonium:O(3S1)[3S1(1)] <O[3S1(1)]> for the Charmonium:O(3S1)[3S1(1)] 3S1 charmonium states."},{"name":"Charmonium:O(3S1)[3S1(1)]1","link":"OniaProcesses.html#anchor43","text":"Charmonium:O(3S1)[3S1(1)]1 The color-singlet long-distance matrix elements Charmonium:O(3S1)[3S1(1)]1 <O[3S1(1)]> for the first Charmonium:O(3S1)[3S1(1)]1 3S1 charmonium states."},{"name":"Charmonium:O(3S1)[3S1(1)]2","link":"OniaProcesses.html#anchor44","text":"Charmonium:O(3S1)[3S1(1)]2 The color-singlet long-distance matrix elements Charmonium:O(3S1)[3S1(1)]2 <O[3S1(1)]> for the second Charmonium:O(3S1)[3S1(1)]2 3S1 charmonium states."},{"name":"Charmonium:O(3S1)[3S1(8)]","link":"OniaProcesses.html#anchor11","text":"Charmonium:O(3S1)[3S1(8)] The colour-octet long-distance matrix elements Charmonium:O(3S1)[3S1(8)] <O[3S1(8)]> for the Charmonium:O(3S1)[3S1(8)] 3S1 charmonium states."},{"name":"Charmonium:qg2ccbar(3DJ)[3PJ(8)]q","link":"OniaProcesses.html#anchor39","text":"Charmonium:qg2ccbar(3DJ)[3PJ(8)]q Colour-octet production of Charmonium:qg2ccbar(3DJ)[3PJ(8)]q 3DJ charmonium states via Charmonium:qg2ccbar(3DJ)[3PJ(8)]q q g &rarr; ccbar[3PJ(8)] q. Code 419."},{"name":"Charmonium:qg2ccbar(3PJ)[3PJ(1)]q","link":"OniaProcesses.html#anchor29","text":"Charmonium:qg2ccbar(3PJ)[3PJ(1)]q Colour-singlet production of Charmonium:qg2ccbar(3PJ)[3PJ(1)]q 3PJ charmonium states via Charmonium:qg2ccbar(3PJ)[3PJ(1)]q q g &rarr; ccbar[3PJ(1)] q. Code 412."},{"name":"Charmonium:qg2ccbar(3PJ)[3S1(8)]q","link":"OniaProcesses.html#anchor32","text":"Charmonium:qg2ccbar(3PJ)[3S1(8)]q Colour-octet production of Charmonium:qg2ccbar(3PJ)[3S1(8)]q 3PJ charmonium states via Charmonium:qg2ccbar(3PJ)[3S1(8)]q q g &rarr; ccbar[3S1(8)] q. Code 415."},{"name":"Charmonium:qg2ccbar(3S1)[1S0(8)]q","link":"OniaProcesses.html#anchor20","text":"Charmonium:qg2ccbar(3S1)[1S0(8)]q Colour-octet production of Charmonium:qg2ccbar(3S1)[1S0(8)]q 3S1 charmonium states via Charmonium:qg2ccbar(3S1)[1S0(8)]q q g &rarr; ccbar[1S0(8)] q. Code 406."},{"name":"Charmonium:qg2ccbar(3S1)[3PJ(8)]q","link":"OniaProcesses.html#anchor23","text":"Charmonium:qg2ccbar(3S1)[3PJ(8)]q Colour-octet production of Charmonium:qg2ccbar(3S1)[3PJ(8)]q 3S1 charmonium states via Charmonium:qg2ccbar(3S1)[3PJ(8)]q q g &rarr; ccbar[3PJ(8)] q. Code 409."},{"name":"Charmonium:qg2ccbar(3S1)[3S1(8)]q","link":"OniaProcesses.html#anchor17","text":"Charmonium:qg2ccbar(3S1)[3S1(8)]q Colour-octet production of Charmonium:qg2ccbar(3S1)[3S1(8)]q 3S1 charmonium states via Charmonium:qg2ccbar(3S1)[3S1(8)]q q g &rarr; ccbar[3S1(8)] q. Code 403."},{"name":"Charmonium:qqbar2ccbar(3DJ)[3PJ(8)]g","link":"OniaProcesses.html#anchor40","text":"Charmonium:qqbar2ccbar(3DJ)[3PJ(8)]g Colour-octet production of Charmonium:qqbar2ccbar(3DJ)[3PJ(8)]g 3DJ charmonium states via Charmonium:qqbar2ccbar(3DJ)[3PJ(8)]g q qbar &rarr; ccbar[3PJ(8)] g. Code 420."},{"name":"Charmonium:qqbar2ccbar(3PJ)[3PJ(1)]g","link":"OniaProcesses.html#anchor30","text":"Charmonium:qqbar2ccbar(3PJ)[3PJ(1)]g Colour-singlet production of Charmonium:qqbar2ccbar(3PJ)[3PJ(1)]g 3PJ charmonium states via Charmonium:qqbar2ccbar(3PJ)[3PJ(1)]g q qbar &rarr; ccbar[3PJ(1)] g. Code 413."},{"name":"Charmonium:qqbar2ccbar(3PJ)[3S1(8)]g","link":"OniaProcesses.html#anchor33","text":"Charmonium:qqbar2ccbar(3PJ)[3S1(8)]g Colour-octet production of Charmonium:qqbar2ccbar(3PJ)[3S1(8)]g 3PJ charmonium states via Charmonium:qqbar2ccbar(3PJ)[3S1(8)]g q qbar &rarr; ccbar[3S1(8)] g. Code 416."},{"name":"Charmonium:qqbar2ccbar(3S1)[1S0(8)]g","link":"OniaProcesses.html#anchor21","text":"Charmonium:qqbar2ccbar(3S1)[1S0(8)]g Colour-octet production of Charmonium:qqbar2ccbar(3S1)[1S0(8)]g 3S1 charmonium states via Charmonium:qqbar2ccbar(3S1)[1S0(8)]g q qbar &rarr; ccbar[1S0(8)] g. Code 407."},{"name":"Charmonium:qqbar2ccbar(3S1)[3PJ(8)]g","link":"OniaProcesses.html#anchor24","text":"Charmonium:qqbar2ccbar(3S1)[3PJ(8)]g Colour-octet production of Charmonium:qqbar2ccbar(3S1)[3PJ(8)]g 3S1 charmonium states via Charmonium:qqbar2ccbar(3S1)[3PJ(8)]g q qbar &rarr; ccbar[3SJ(8)] g. Code 410."},{"name":"Charmonium:qqbar2ccbar(3S1)[3S1(8)]g","link":"OniaProcesses.html#anchor18","text":"Charmonium:qqbar2ccbar(3S1)[3S1(8)]g Colour-octet production of Charmonium:qqbar2ccbar(3S1)[3S1(8)]g 3S1 charmonium states via Charmonium:qqbar2ccbar(3S1)[3S1(8)]g q qbar &rarr; ccbar[3S1(8)] g. Code 404."},{"name":"Charmonium:qqbar2doubleccbar(3S1)[3S1(1)]","link":"OniaProcesses.html#anchor46","text":"Charmonium:qqbar2doubleccbar(3S1)[3S1(1)] Colour-singlet production of Charmonium:qqbar2doubleccbar(3S1)[3S1(1)] 3S1 charmonium state pairs via Charmonium:qqbar2doubleccbar(3S1)[3S1(1)] q qbar &rarr; ccbar[3S1(1)] ccbar[3S1(1)]. Code 422."},{"name":"Charmonium:states(3DJ)","link":"OniaProcesses.html#anchor34","text":"Charmonium:states(3DJ) The Charmonium:states(3DJ) 3DJ charmonium states that can be produced from the following processes. Note that all vectors within this section, either of flags or parameters, must be the same length as this vector."},{"name":"Charmonium:states(3PJ)","link":"OniaProcesses.html#anchor25","text":"Charmonium:states(3PJ) The Charmonium:states(3PJ) 3PJ charmonium states that can be produced from the following processes. Note that all vectors within this section, either of flags or parameters, must be the same length as this vector."},{"name":"Charmonium:states(3S1)","link":"OniaProcesses.html#anchor9","text":"Charmonium:states(3S1) The Charmonium:states(3S1) 3S1 charmonium states that can be produced from the following processes. Note that all vectors within this section, either of flags or parameters, must be the same length as this vector."},{"name":"Charmonium:states(3S1)1","link":"OniaProcesses.html#anchor41","text":"Charmonium:states(3S1)1 The first Charmonium:states(3S1)1 3S1 charmonium states of the charmonium pairs that can be produced from the following processes. Note that all vectors within this section, either of modes, flags, or parameters, must be the same length as this vector."},{"name":"Charmonium:states(3S1)2","link":"OniaProcesses.html#anchor42","text":"Charmonium:states(3S1)2 The second Charmonium:states(3S1)2 3S1 charmonium states of the charmonium pairs that can be produced from the following processes."},{"name":"Check:abortIfVeto","link":"ErrorChecks.html#anchor1","text":"Check:abortIfVeto There are a few ways in which an event can be vetoed, the most common being a Check:abortIfVeto User Hooks test. Normally this will simply mean that the next parton-level configuration is selected inside the Check:abortIfVeto Pythia::next() routine, without any need for a user intervention. With this option switched on, however, Check:abortIfVeto Pythia::next() will return Check:abortIfVeto false. It is then up to the user to decide what to do next."},{"name":"Check:beams","link":"ErrorChecks.html#anchor6","text":"Check:beams Check that Pythia supports the beam setup, i.e. if the beams are the allowed combinations described in Check:beams Beam Parameters. If turned off, all checks of allowed beam combinations will be skipped, as can e.g. be useful to allow processing of Les Houches event files with exotic beam structure."},{"name":"Check:epTolErr","link":"ErrorChecks.html#anchor8","text":"Check:epTolErr Maximum allowed summed deviation of Check:epTolErr E , Check:epTolErr p_x , Check:epTolErr p_y and Check:epTolErr p_z between the incoming beams and the final state, as a fraction of the initial energy, above which the event is counted as aborted. (Unfortunately roundoff errors do not scale linearly with the energy, and also have a very long tail. So while most events at lower energies may be correct to better than 1e-10, at LHC it does not have to signal any fundamental bug if also the default tolerance above is violated occasionally.)"},{"name":"Check:epTolWarn","link":"ErrorChecks.html#anchor9","text":"Check:epTolWarn A check on the same summed deviation as above, but counted as a warning rather than an error, and not leading to the event being classified as aborted."},{"name":"Check:event","link":"ErrorChecks.html#anchor4","text":"Check:event When an event has been successfully generated, check that the final event record in Check:event event does not contain any unphysical particles, or nonconserved charge or energy-momentum. If this check fails, then Check:event pythia.next() obtains the value Check:event false , i.e. the event is counted as aborted."},{"name":"Check:history","link":"ErrorChecks.html#anchor5","text":"Check:history When Check:history Check:event = on and the event is checked as above, further checks are made that all mother and daughter pointers are consistently set. Specifically that all daughters in the Check:history daughterlist (or Check:history motherList ) have the particle in their respective Check:history motherList (or Check:history daughterlist ). This operation takes a bit more time than the other error tests (of the order of 10% of what it takes to generate the event in the first place), and so could be switched off to save time."},{"name":"Check:levelParticleData","link":"ErrorChecks.html#anchor3","text":"Check:levelParticleData The level of verbosity and checks of particle data, if switched on. Check:levelParticleData minimal amount of checks, e.g. that no channels open. Check:levelParticleData further warning if individual channels closed, except for resonances. Check:levelParticleData also print branching-ratio-averaged threshold mass except for resonances. Check:levelParticleData as 1, but include resonances in detailed checks. Check:levelParticleData as 2, but include resonances in detailed checks."},{"name":"Check:mTolErr","link":"ErrorChecks.html#anchor10","text":"Check:mTolErr For each particle the maximum allowed deviation between the mass calculated from energy-momentum and the bookkept mass, as a fraction of the energy. This energy is taken to be at least 1 GeV, in order to avoid harmless problems at very low energies (gluons mainly)."},{"name":"Check:mTolWarn","link":"ErrorChecks.html#anchor11","text":"Check:mTolWarn A check on the deviation as above, but counted as a warning rather than an error."},{"name":"Check:nErrList","link":"ErrorChecks.html#anchor7","text":"Check:nErrList The number of erroneous events, in the above check, for which event listing and other detailed information will be printed. After that, only the normal error messages will be issued. Error counters are always updated, and accumulated numbers can be shown with Check:nErrList pythia.stat() at the end of the run."},{"name":"Check:particleData","link":"ErrorChecks.html#anchor2","text":"Check:particleData Check the particle data tables for potential problems during initialization. This includes inconsistent use of charge in particle names, inconsistent setup of mass, mass range, width and lifetime, sum of branching ratios not unity (allowed but discouraged) or charge not conserved in a decay channel. Warnings should be viewed as reasons to check further, but need not indicate a true problem, and also not all problems may be caught. The Check:particleData pythia.particleData.checkTable(level) method, used for these checks, may also be called directly."},{"name":"ColourReconnection:allowDoubleJunRem","link":"ColourReconnection.html#anchor12","text":"ColourReconnection:allowDoubleJunRem This parameter tells whether or not to allow a directly connected junction-antijunction pair to split into two strings. The lambda measure of the junction system is compared to that of the two possible string configurations. If the chosen configuration is the junction system, a q-qbar system is inserted between the junctions by removing some energy/momentum from the other legs."},{"name":"ColourReconnection:allowJunctions","link":"ColourReconnection.html#anchor10","text":"ColourReconnection:allowJunctions This switch disables the formation of junctions in the colour reconnection."},{"name":"ColourReconnection:blowR","link":"ColourReconnection.html#anchor24","text":"ColourReconnection:blowR Technical parameter used in the Monte Carlo sampling of the spatial phase space volume in SK I. There is no real reason to change this number."},{"name":"ColourReconnection:blowT","link":"ColourReconnection.html#anchor25","text":"ColourReconnection:blowT Technical parameter used in the Monte Carlo sampling of the temporal phase space volume in SK I. There is no real reason to change this number."},{"name":"ColourReconnection:dLambdaCut","link":"ColourReconnection.html#anchor17","text":"ColourReconnection:dLambdaCut Restrict gluon moves and colour flips to those that reduce ColourReconnection:dLambdaCut lambda by more than this amount. The larger this number, the fewer moves and flips will be performed, but those that remain are the ones most likely to produce large effects."},{"name":"ColourReconnection:flipMode","link":"ColourReconnection.html#anchor18","text":"ColourReconnection:flipMode Performing the flip step or not. Also possibility to omit the move step. ColourReconnection:flipMode No flip handling. ColourReconnection:flipMode Allow flips, but not for strings in junction topologies. ColourReconnection:flipMode Allow flips, including for strings in junction topologies. ColourReconnection:flipMode No move handling. Allow flips, but not for strings in junction topologies. ColourReconnection:flipMode No move handling. Allow flips, including for strings in junction topologies."},{"name":"ColourReconnection:forceHadronLevelCR","link":"ColourReconnection.html#anchor3","text":"ColourReconnection:forceHadronLevelCR This flag switches on colour reconnection in the ColourReconnection:forceHadronLevelCR forceHadronLevel function. The function is called when only the hadron level of PYTHIA is used (see ColourReconnection:forceHadronLevelCR Hadron-level Standalone ). The MPI-based model is not available for this setup and any resonance decays not already decayed are not included in the CR."},{"name":"ColourReconnection:forceResonance","link":"ColourReconnection.html#anchor4","text":"ColourReconnection:forceResonance This parameter allows an additional CR after late resonance decays. All the particles from all resonance decays are allowed to reconnect with each other. It is mainly intended for ColourReconnection:forceResonance H -> WW -> qqqq , where the Higgs decay ensures a separation between the W bosons and the MPI systems. Reconnections between the decay products from the two ColourReconnection:forceResonance W bosons is still a possibility, however. This option is not available for colored resonances, and not for the MPI-based model."},{"name":"ColourReconnection:fracGluon","link":"ColourReconnection.html#anchor16","text":"ColourReconnection:fracGluon The probability that a given gluon will be considered for being moved. It thus gives the average fraction of gluons being considered."},{"name":"ColourReconnection:fragmentationTime","link":"ColourReconnection.html#anchor22","text":"ColourReconnection:fragmentationTime This parameter specifies the average fragmentation time of the string, in fm. This is used as an upper limit on the invariant time where strings still exist and thus can collide. The expected fragmentation time is related to the ColourReconnection:fragmentationTime a and ColourReconnection:fragmentationTime b parameters of the Lund string fragmentation function as well as to the string tension. It is therefore not a quite free parameter."},{"name":"ColourReconnection:junctionCorrection","link":"ColourReconnection.html#anchor7","text":"ColourReconnection:junctionCorrection This variable allows to use a different m0 for junction strings in the lambda measure. It is multiplicative correction to the m0 chosen above."},{"name":"ColourReconnection:kI","link":"ColourReconnection.html#anchor21","text":"ColourReconnection:kI kI is the main free parameter in the reconnection probability for SK I. This probability is given by kI times the space-time overlap volume, up to saturation effects."},{"name":"ColourReconnection:lambdaForm","link":"ColourReconnection.html#anchor11","text":"ColourReconnection:lambdaForm This allows to switch between different options for what ColourReconnection:lambdaForm lambda -measure to use. The formula shown are how much each end of a dipole or junction contribute to the total ColourReconnection:lambdaForm lambda -measure. The energies are defined in respectively the dipole or junction rest frame. ColourReconnection:lambdaForm ColourReconnection:lambdaForm lambda = ln (1 + sqrt(2) E/m0) ColourReconnection:lambdaForm ColourReconnection:lambdaForm lambda = ln (1 + 2 E/m0) ColourReconnection:lambdaForm ColourReconnection:lambdaForm lambda = ln (2 E/m0)"},{"name":"ColourReconnection:lowerLambdaOnly","link":"ColourReconnection.html#anchor19","text":"ColourReconnection:lowerLambdaOnly Only allow overlaps that lowers the total string length."},{"name":"ColourReconnection:m0","link":"ColourReconnection.html#anchor6","text":"ColourReconnection:m0 This is the variable used in the lambda measure for the string length. See the different choices of lambda measure for exact formulas. This variable is in the new model also used as a cut for forming pseudo particles that are not colour reconnected."},{"name":"ColourReconnection:m2Lambda","link":"ColourReconnection.html#anchor15","text":"ColourReconnection:m2Lambda The ColourReconnection:m2Lambda m2Lambda parameter used in the definition of the approximate ColourReconnection:m2Lambda lambda measure above. It represents an approximate hadronic mass-square scale, cf. ColourReconnection:m2Lambda m0 in the previous model. Its value is uncertain up to factors of 2, but the ColourReconnection:m2Lambda lambda change induced by a potential move or flip is rather insensitive to the precise value, owing to large cancellations."},{"name":"ColourReconnection:mode","link":"ColourReconnection.html#anchor2","text":"ColourReconnection:mode Determine which model is used for colour reconnection. Beware that some settings may need to be changed to match the model selected. ColourReconnection:mode The MPI-based original Pythia 8 scheme. ColourReconnection:mode The new more QCD based scheme. Should be combined ewith ColourReconnection:mode BeamRemnants:remnantMode = 1. ColourReconnection:mode The new gluon-move model. ColourReconnection:mode The SK I ColourReconnection:mode e^+ e^- CR model. Requires ColourReconnection:mode ColourReconnection:forceResonance = on (and default ColourReconnection:mode PartonLevel:earlyResDec = off ) to give any CR. ColourReconnection:mode The SK II ColourReconnection:mode e^+ e^- CR model. Requires ColourReconnection:mode ColourReconnection:forceResonance = on (and default ColourReconnection:mode PartonLevel:earlyResDec = off ) to give any CR."},{"name":"ColourReconnection:nColours","link":"ColourReconnection.html#anchor8","text":"ColourReconnection:nColours The number of reconnection colours, this should not be confused with the standard number of QCD colours. Each string is given an integer number between 0 and ColourReconnection:nColours nColours - 1. Only strings with the same number are allowed to do a normal string reconnection. The default value provides the standard QCD probability that a triplet and an anti-triplet is in a singlet state. The probability for two strings to form a junction structure is in QCD given by the product of two triplets, which gives a probability of 1/3. Therefore the number of reconnection colours for junction formation is ColourReconnection:nColours iColours % 3 , where iColours refer to the integer of the string. The behaviour of junction formation therefore only changes slightly with this variable."},{"name":"ColourReconnection:range","link":"ColourReconnection.html#anchor5","text":"ColourReconnection:range The ColourReconnection:range range parameter defined above. The higher this number is the more reconnections can occur. For values above unity the reconnection rate tends to saturate, since then most systems are already connected with each other. This is why 10 is set as an effective upper limit, beyond which it is not meaningful to let the parameter go."},{"name":"ColourReconnection:reconnect","link":"ColourReconnection.html#anchor1","text":"ColourReconnection:reconnect Allow or not a system to be merged with another one."},{"name":"ColourReconnection:rHadron","link":"ColourReconnection.html#anchor23","text":"ColourReconnection:rHadron Width of the type I string in reconnection calculations, in fm, giving the radius of the Gaussian distribution in ColourReconnection:rHadron x and ColourReconnection:rHadron y separately."},{"name":"ColourReconnection:sameNeighbourColours","link":"ColourReconnection.html#anchor9","text":"ColourReconnection:sameNeighbourColours In the normal colour reconnection two neighbouring strings are not allowed to have the same colour. Similar two strings originating from a gluon split is not allowed to reconnect. The physics motivation for this is that it would require colour singlet gluons, and therefore for ordinary physics studies this should be turned off. But for testing of extreme scenarios (i.e. 1 colour), this variable needs to be turned on, since it is not possible to have different neighbouring colours."},{"name":"ColourReconnection:singleReconnection","link":"ColourReconnection.html#anchor20","text":"ColourReconnection:singleReconnection Limit the number of reconnections to a single reconnection."},{"name":"ColourReconnection:timeDilationMode","link":"ColourReconnection.html#anchor13","text":"ColourReconnection:timeDilationMode Disallow colour reconnection between strings that are not in causal contact; if either string has already decayed before the other string forms, there is no space-time region in which the reconnection could physically occur. The exact defintion of causal contact is not known, hence several possible defintions are included. They all include the boost factor, ColourReconnection:timeDilationMode gamma , and the majority also rely on the typical hadronization scale, ColourReconnection:timeDilationMode r , which is kept fixed at 1 fm. A tuneable dimensionless parameter is included, which can be used to control the overall amount of colour reconnection. ColourReconnection:timeDilationMode All strings are allowed to reconnect. ColourReconnection:timeDilationMode Strings are allowed to reconnect if ColourReconnection:timeDilationMode gamma < timeDilationPar and all strings should be causally connected to allow a reconnection. ColourReconnection:timeDilationMode Strings are allowed to reconnect if ColourReconnection:timeDilationMode gamma < timeDilationPar * mDip * r and all strings should be in causal contact to allow a reconnection. ColourReconnection:timeDilationMode Strings are allowed to reconnect if ColourReconnection:timeDilationMode gamma < timeDilationPar * mDip * r and if a single pair of dipoles are in causal contact the reconnection is allowed. ColourReconnection:timeDilationMode Strings are allowed to reconnect if ColourReconnection:timeDilationMode gamma < timeDilationPar * mDip' * r and all strings should be in causal contact to allow a reconnection. mDip' is the invariant mass at the formation of the dipole (ie. the first time the colour tag appear in the perturbative expansion). ColourReconnection:timeDilationMode Strings are allowed to reconnect if ColourReconnection:timeDilationMode gamma < timeDilationPar * mDip' * r and if a single pair of dipoles are in causal contact the reconnection is allowed. mDip' is the invariant mass at the formation of the dipole (ie. the first time the colour tag appear in the perturbative expansion)."},{"name":"ColourReconnection:timeDilationPar","link":"ColourReconnection.html#anchor14","text":"ColourReconnection:timeDilationPar This is a tuneable parameter for the time dilation. The definition can be seen above under ColourReconnection:timeDilationPar timeDilationMode."},{"name":"ContactInteractions:etaLL","link":"CompositenessProcesses.html#anchor39","text":"ContactInteractions:etaLL Helicity parameter. ContactInteractions:etaLL ContactInteractions:etaLL ContactInteractions:etaLL"},{"name":"ContactInteractions:etaLR","link":"CompositenessProcesses.html#anchor41","text":"ContactInteractions:etaLR Helicity parameter. ContactInteractions:etaLR ContactInteractions:etaLR ContactInteractions:etaLR"},{"name":"ContactInteractions:etaRL","link":"CompositenessProcesses.html#anchor42","text":"ContactInteractions:etaRL Helicity parameter. Implemented only for the ContactInteractions:etaRL q qbar &rarr; l- l+ process. ContactInteractions:etaRL ContactInteractions:etaRL ContactInteractions:etaRL"},{"name":"ContactInteractions:etaRR","link":"CompositenessProcesses.html#anchor40","text":"ContactInteractions:etaRR Helicity parameter. ContactInteractions:etaRR ContactInteractions:etaRR ContactInteractions:etaRR"},{"name":"ContactInteractions:Lambda","link":"CompositenessProcesses.html#anchor38","text":"ContactInteractions:Lambda Compositeness scale ContactInteractions:Lambda Lambda in GeV. Its overall normalization is largely a matter of convention. The choice made here for the ContactInteractions:Lambda q qbar &rarr; l- l+ processes is such that the pure contact interaction part of the left-left interactions (i.e. disregarding ContactInteractions:Lambda gamma^* , ContactInteractions:Lambda Z^0 and interference terms) has the form ContactInteractions:Lambda d(sigmaHat)/d(tHat) = pi * uHat^2 / (3 * sHat^2 * Lambda^4). The corresponding part of the ContactInteractions:Lambda q qbar &rarr; q' qbar' cross section is a factor 3 larger from colour."},{"name":"ContactInteractions:nQuarkNew","link":"CompositenessProcesses.html#anchor37","text":"ContactInteractions:nQuarkNew Number of allowed outgoing new quark flavours in the above ContactInteractions:nQuarkNew q qbar &rarr; q' qbar' process. Similar to ContactInteractions:nQuarkNew HardQCD:nQuarkNew for the QCD processes."},{"name":"ContactInteractions:QCffbar2eebar","link":"CompositenessProcesses.html#anchor34","text":"ContactInteractions:QCffbar2eebar Scatterings ContactInteractions:QCffbar2eebar f fbar &rarr; e- e+ including contact interactions. Code 4203."},{"name":"ContactInteractions:QCffbar2mumubar","link":"CompositenessProcesses.html#anchor35","text":"ContactInteractions:QCffbar2mumubar Scatterings ContactInteractions:QCffbar2mumubar f fbar &rarr; mu- mu+ including contact interactions. Code 4204."},{"name":"ContactInteractions:QCffbar2tautaubar","link":"CompositenessProcesses.html#anchor36","text":"ContactInteractions:QCffbar2tautaubar Scatterings ContactInteractions:QCffbar2tautaubar f fbar &rarr; tau- tau+ including contact interactions. Code 4205."},{"name":"ContactInteractions:QCqq2qq","link":"CompositenessProcesses.html#anchor32","text":"ContactInteractions:QCqq2qq Scatterings ContactInteractions:QCqq2qq q q &rarr; q q including contact interactions. Code 4201."},{"name":"ContactInteractions:QCqqbar2qqbar","link":"CompositenessProcesses.html#anchor33","text":"ContactInteractions:QCqqbar2qqbar Scatterings ContactInteractions:QCqqbar2qqbar q qbar &rarr; q' qbar' including contact interactions. Code 4202."},{"name":"decays","link":"SUSYProcesses.html#anchor24","text":"decays"},{"name":"DeuteronProduction:channels","link":"DeuteronProduction.html#anchor2","text":"DeuteronProduction:channels List of the deuteron production channels to include of the form DeuteronProduction:channels initial states > final states where DeuteronProduction:channels initial states are the PDG particle IDs of the initial state particles to combine (there must be two), and DeuteronProduction:channels final states are the PIDs of the final state particles, excluding the deuteron. There must be one or more final state particles in addition to the deuteron. The products of each channel are space separated, while the channels are comma separated."},{"name":"DeuteronProduction:kMax","link":"DeuteronProduction.html#anchor6","text":"DeuteronProduction:kMax The maximum bracketing value of DeuteronProduction:kMax k (in DeuteronProduction:kMax GeV ) when maximum finding."},{"name":"DeuteronProduction:kMin","link":"DeuteronProduction.html#anchor5","text":"DeuteronProduction:kMin The minimum bracketing value of DeuteronProduction:kMin k (in DeuteronProduction:kMin GeV ) when maximum finding. For the default DeuteronProduction:kMin p n &rarr; gamma 2H production model the cross-section diverges at low DeuteronProduction:kMin k , but the probability of producing two nucleons with low DeuteronProduction:kMin k suppresses this divergence."},{"name":"DeuteronProduction:kSteps","link":"DeuteronProduction.html#anchor8","text":"DeuteronProduction:kSteps The number of steps to sample in DeuteronProduction:kSteps k when calculating the initial grid for maximum finding."},{"name":"DeuteronProduction:kTol","link":"DeuteronProduction.html#anchor7","text":"DeuteronProduction:kTol The minimum relative tolerance in DeuteronProduction:kTol k required when maximum finding."},{"name":"DeuteronProduction:models","link":"DeuteronProduction.html#anchor3","text":"DeuteronProduction:models List of the parameterization mode for each deuteron production channel specified by DeuteronProduction:models DeuteronProduction:channels. The parameters for each of the channels is specified with DeuteronProduction:models DeuteronProduction:parms. The length of this vector must be the same as DeuteronProduction:models DeuteronProduction:channels. DeuteronProduction:models the coalescence model, DeuteronProduction:models p DeuteronProduction:models 1 &theta;(p DeuteronProduction:models 0 - k) , a step function with two parameters: DeuteronProduction:models p DeuteronProduction:models 0 the cut-off of the step function and DeuteronProduction:models p DeuteronProduction:models 1 the normalization of the step function. DeuteronProduction:models the differential cross-section model in DeuteronProduction:models &kappa; is given by the piece-wise function DeuteronProduction:models &sum; DeuteronProduction:models i=1 DeuteronProduction:models 12 p DeuteronProduction:models i &kappa; DeuteronProduction:models i-2 for DeuteronProduction:models &kappa; < p DeuteronProduction:models 0 , otherwise DeuteronProduction:models exp(-p DeuteronProduction:models 13 &kappa; - p DeuteronProduction:models 14 &kappa; DeuteronProduction:models 2 ). A total of 15 parameters are required: the function split followed by 12 polynomial coefficients for the first function, and 2 polynomial coefficients for the second exponential function. The function is fixed below DeuteronProduction:models 0.1 GeV to its value at this DeuteronProduction:models &kappa; where DeuteronProduction:models &kappa; is defined as DeuteronProduction:models k/GeV. DeuteronProduction:models the differential cross-section model in DeuteronProduction:models &eta; is given by DeuteronProduction:models p DeuteronProduction:models 0 &eta; DeuteronProduction:models p DeuteronProduction:models 1 /((p DeuteronProduction:models 2 - exp(p DeuteronProduction:models 3 &eta;)) DeuteronProduction:models 2 + p DeuteronProduction:models 4 ). A total of 5 parameters is required. Here, DeuteronProduction:models &eta; is the momentum of the non-deuteron final state divided by its mass in the COM. This model is intended for two-body final states containing a deuteron and a pion. DeuteronProduction:models the differential cross-section model in DeuteronProduction:models &kappa; is given by DeuteronProduction:models &sum; DeuteronProduction:models i=0 p DeuteronProduction:models 5*i+0 &kappa; DeuteronProduction:models p DeuteronProduction:models 5*i+1 /((p DeuteronProduction:models 5*i+2 - exp(p DeuteronProduction:models 5*i+3 &kappa;)) DeuteronProduction:models 2 + p DeuteronProduction:models 5*i+4 ) where the number of parameters can be any multiple of 5 and DeuteronProduction:models &kappa; is defined as DeuteronProduction:models k/GeV."},{"name":"DeuteronProduction:norm","link":"DeuteronProduction.html#anchor1","text":"DeuteronProduction:norm An overall unitless multiplicative normalization scale to increase the maximum used when sampling the differential cross-sections. Increasing this scale decreases the cross-section for deuteron production. Using the default model, the maximum differential cross-section is DeuteronProduction:norm 3.2 mb with the DeuteronProduction:norm n0 n0 &rarr; pi- 2H and DeuteronProduction:norm p+ p+ &rarr; pi+ 2H channels. To convert the fit values from table VIII of DeuteronProduction:norm Dal15 into this multiplicative normalization factor, take DeuteronProduction:norm 1/(value from table * maximum cross-section). For example, the ALICE 7 TeV deuteron fit with a DeuteronProduction:norm 1/&sigma; DeuteronProduction:norm 0 of 2.63 inverse barn, the multiplicative normalization is 119.6."},{"name":"DeuteronProduction:parms","link":"DeuteronProduction.html#anchor4","text":"DeuteronProduction:parms The parameters needed for the model of each channel. The parameters for each channel are space separated, while the channels are separated by commas. The length of this vector must be the same as DeuteronProduction:parms DeuteronProduction:channels. Note, to match the parameters of DeuteronProduction:parms Dal15 these parameters give differential cross-sections in DeuteronProduction:parms &mu;b not DeuteronProduction:parms mb."},{"name":"Diffraction:bProfile","link":"Diffraction.html#anchor11","text":"Diffraction:bProfile Choice of impact parameter profile for the incoming hadron beams. Diffraction:bProfile no impact parameter dependence at all. Diffraction:bProfile a simple Gaussian matter distribution; no free parameters. Diffraction:bProfile a double Gaussian matter distribution, with the two free parameters Diffraction:bProfile coreRadius and Diffraction:bProfile coreFraction. Diffraction:bProfile an overlap function, i.e. the convolution of the matter distributions of the two incoming hadrons, of the form Diffraction:bProfile exp(- b^expPow) , where Diffraction:bProfile expPow is a free parameter."},{"name":"Diffraction:bSelHard","link":"Diffraction.html#anchor20","text":"Diffraction:bSelHard Selection of impact parameter Diffraction:bSelHard b and the related enhancement factor for the Pomeron-proton subsystem when the MPI check is carried out. This affects the underlying-event activity in hard diffractive events. Diffraction:bSelHard Use the same Diffraction:bSelHard b as already assigned for the proton-proton collision. This implicitly assumes that a Pomeron is as big as a proton and centered in the same place. Since small Diffraction:bSelHard b values already have been suppressed, few events should have high enhancement factors. Diffraction:bSelHard Use the square root of the Diffraction:bSelHard b as already assigned for the proton-proton collision, thereby making the enhancement factor fluctuate less between events. If the Pomeron is very tiny then what matters is where it strikes the other proton, not the details of its shape. Thus the variation with Diffraction:bSelHard b is of one proton, not two, and so the square root of the normal variation, loosely speaking. Tecnhically this is difficult to implement, but the current simple recipe provides the main effect of reducing the variation, bringing all Diffraction:bSelHard b values closer to the average. Diffraction:bSelHard Pick a completely new Diffraction:bSelHard b. This allows a broad spread from central to peripheral values, and thereby also a more varying MPI activity inside the diffractive system than the other two options. This offers an extreme picture, even if not the most likely one."},{"name":"Diffraction:coreFraction","link":"Diffraction.html#anchor13","text":"Diffraction:coreFraction When assuming a double Gaussian matter profile, Diffraction:coreFraction bProfile = 2 , the inner core is assumed to have a fraction Diffraction:coreFraction coreFraction of the matter content of the hadron."},{"name":"Diffraction:coreRadius","link":"Diffraction.html#anchor12","text":"Diffraction:coreRadius When assuming a double Gaussian matter profile, Diffraction:coreRadius bProfile = 2 , the inner core is assumed to have a radius that is a factor Diffraction:coreRadius coreRadius smaller than the rest."},{"name":"Diffraction:doHard","link":"Diffraction.html#anchor15","text":"Diffraction:doHard Allows for the possibility to include hard diffraction tests in a run."},{"name":"Diffraction:expPow","link":"Diffraction.html#anchor14","text":"Diffraction:expPow When Diffraction:expPow bProfile = 3 it gives the power of the assumed overlap shape Diffraction:expPow exp(- b^expPow). Default corresponds to a simple exponential drop, which is not too dissimilar from the overlap obtained with the standard double Gaussian parameters. For Diffraction:expPow expPow = 2 we reduce to the simple Gaussian, Diffraction:expPow bProfile = 1 , and for Diffraction:expPow expPow &rarr; infinity to no impact parameter dependence at all, Diffraction:expPow bProfile = 0. For small Diffraction:expPow expPow the program becomes slow and unstable, so the min limit must be respected."},{"name":"Diffraction:hardDiffSide","link":"Diffraction.html#anchor16","text":"Diffraction:hardDiffSide Side which diffraction is evaluated for. Especially useful for diffraction in ep, where experiments only look for gaps on the proton side. Diffraction:hardDiffSide Check for diffraction on boths sides A and B. Diffraction:hardDiffSide Check for diffraction on side A only. Diffraction:hardDiffSide Check for diffraction on side B only."},{"name":"Diffraction:largeMassSuppress","link":"Diffraction.html#anchor7","text":"Diffraction:largeMassSuppress The choice of longitudinal and transverse structure of a diffractive beam remnant for a kicked-out gluon implies a remnant mass Diffraction:largeMassSuppress m_rem distribution (i.e. quark plus diquark invariant mass for a baryon beam) that knows no bounds. A suppression like Diffraction:largeMassSuppress (1 - m_rem^2 / m_diff^2)^p is therefore introduced, where Diffraction:largeMassSuppress p is the Diffraction:largeMassSuppress diffLargeMassSuppress parameter."},{"name":"Diffraction:mMinPert","link":"Diffraction.html#anchor1","text":"Diffraction:mMinPert The abovementioned threshold mass Diffraction:mMinPert m_min for phasing in a perturbative treatment. If you put this parameter to be bigger than the CM energy then there will be no perturbative description at all, but only the older low- Diffraction:mMinPert pt description."},{"name":"Diffraction:mPowPomP","link":"Diffraction.html#anchor10","text":"Diffraction:mPowPomP The Diffraction:mPowPomP p mass rescaling pace introduced above."},{"name":"Diffraction:mRefPomP","link":"Diffraction.html#anchor9","text":"Diffraction:mRefPomP The Diffraction:mRefPomP mRef reference mass scale introduced above."},{"name":"Diffraction:mWidthPert","link":"Diffraction.html#anchor2","text":"Diffraction:mWidthPert The abovementioned threshold width Diffraction:mWidthPert m_width."},{"name":"Diffraction:pickQuarkNorm","link":"Diffraction.html#anchor4","text":"Diffraction:pickQuarkNorm The abovementioned normalization Diffraction:pickQuarkNorm N for the relative quark rate in diffractive systems."},{"name":"Diffraction:pickQuarkPower","link":"Diffraction.html#anchor5","text":"Diffraction:pickQuarkPower The abovementioned mass-dependence power Diffraction:pickQuarkPower p for the relative quark rate in diffractive systems."},{"name":"Diffraction:PomFluxRescale","link":"Diffraction.html#anchor18","text":"Diffraction:PomFluxRescale Rescale the Pomeron flux by this uniform factor. It should be Diffraction:PomFluxRescale 1 / PDF:PomRescale to preserve the convolution of Pomeron flux and PDFs, but for greater flxibility the two can be set separately."},{"name":"Diffraction:primKTwidth","link":"Diffraction.html#anchor6","text":"Diffraction:primKTwidth The width of Gaussian distributions in Diffraction:primKTwidth p_x and Diffraction:primKTwidth p_y separately that is assigned as a primordial Diffraction:primKTwidth kT to the two beam remnants when a gluon is kicked out of a diffractive system."},{"name":"Diffraction:probMaxPert","link":"Diffraction.html#anchor3","text":"Diffraction:probMaxPert The abovementioned maximum probability Diffraction:probMaxPert P_max.. Would normally be assumed to be unity, but a somewhat lower value could be used to represent a small nonperturbative component also at high diffractive masses."},{"name":"Diffraction:sampleType","link":"Diffraction.html#anchor17","text":"Diffraction:sampleType Type of process the user wants to generate. Depends strongly on how an event is classified as diffractive. Diffraction:sampleType Generate an inclusive sample of both diffractive and nondiffractive hard processes, MPI-unchecked. Diffraction:sampleType Generate an inclusive sample of both diffractive and nondiffractive hard processes, MPI-checked. Diffraction:sampleType Generate an exclusive diffractive sample, MPI-unchecked. Diffraction:sampleType Generate an exclusive diffractive sample, MPI-checked."},{"name":"Diffraction:sigmaRefPomP","link":"Diffraction.html#anchor8","text":"Diffraction:sigmaRefPomP The assumed Pomeron-proton effective cross section, as used for multiparton interactions in diffractive systems. If this cross section is made to depend on the mass of the diffractive system then the above value refers to the cross section at the reference scale, and Diffraction:sigmaRefPomP sigma_PomP(m) = sigma_PomP(m_ref) * (m / m_ref)^p where Diffraction:sigmaRefPomP m is the mass of the diffractive system, Diffraction:sigmaRefPomP m_ref is the reference mass scale Diffraction:sigmaRefPomP Diffraction:mRefPomP below and Diffraction:sigmaRefPomP p is the mass-dependence power Diffraction:sigmaRefPomP Diffraction:mPowPomP. Note that a larger cross section value gives less MPI activity per event. There is no point in making the cross section too big, however, since then Diffraction:sigmaRefPomP pT0 will be adjusted downwards to ensure that the integrated perturbative cross section stays above this assumed total cross section. (The requirement of at least one perturbative interaction per event.)"},{"name":"Diffraction:useMBRrenormalization","link":"Diffraction.html#anchor19","text":"Diffraction:useMBRrenormalization Use the renormalized MBR flux."},{"name":"Dire:doExitAfterMerging","link":"DireExpert.html#anchor23","text":"Dire:doExitAfterMerging If on, this switch will allow to terminate the event processing once the calls to the merging machinery have been executed."},{"name":"Dire:doGenerateMergingWeights","link":"DireExpert.html#anchor21","text":"Dire:doGenerateMergingWeights This flag allows to switch on/off the generation of CKKW-L-type reweighting factors by the merging machinery."},{"name":"Dire:doGenerateSubtractions","link":"DireExpert.html#anchor20","text":"Dire:doGenerateSubtractions This flag allows to retrieve differential real-emission parton-shower counter-terms necessary for MC\@NLO matching directly from a shower call."},{"name":"Dire:doMECs","link":"DireExpert.html#anchor10","text":"Dire:doMECs If on, matrix-element corrections for the first few splittings are used."},{"name":"Dire:doMEM","link":"DireExpert.html#anchor18","text":"Dire:doMEM This flag switches on the possibility to classify input configurations according to the HYTRESS hypothesis testing scheme."},{"name":"Dire:doMerging","link":"DireExpert.html#anchor16","text":"Dire:doMerging This switch should be considered experimental. If on, this simply ensures that the merging machinery can be accessed. The type of merging can then be further specified with the switches below."},{"name":"Dire:doMOPS","link":"DireExpert.html#anchor17","text":"Dire:doMOPS This flag switches on the handling of unordered configurations necessary in the MOPS merging method."},{"name":"Dire:doSingleLegSudakovs","link":"DireExpert.html#anchor22","text":"Dire:doSingleLegSudakovs This flag allows to retrieve no-emission probabilities from the parton showers on a leg-by-leg basis. The default definition of no-emission probabilities is instead based on the evolution of a state as as a whole."},{"name":"Dire:MG5card","link":"DireExpert.html#anchor11","text":"Dire:MG5card The ME corrections in Dire rely on code produced by MadGraph5. The initialization of this code requires a Madgraph parameter card. This setting should give the full path to such a ' Dire:MG5card param_card '. Without this input, the code will abort."},{"name":"Dire:nFinalMaxMECs","link":"DireExpert.html#anchor12","text":"Dire:nFinalMaxMECs If set, this limits the amount of matrix element corrections to final-state particle counts below this value. Any negative value means that ME corrections are applied for each splitting for which ME code is available."},{"name":"Dire:pTminMECs","link":"DireExpert.html#anchor13","text":"Dire:pTminMECs The minimal evolution scale value (in GeV) for which ME corrections should be applied. A negative value means no restriction."},{"name":"Dire:QED:doForcePosChgCorrelators","link":"DireExpert.html#anchor1","text":"Dire:QED:doForcePosChgCorrelators If on, this requires all QED splitting functions to use positive charge correlators. This especially means that some (otherwise in principle allowed) splittings are forbidden. This switch is only included to compare to other methods."},{"name":"Dire:QED:pTminForcePos","link":"DireExpert.html#anchor2","text":"Dire:QED:pTminForcePos This parameter determines the minimal evolution variable above which the above scheme of positive-only charge correlators is employed. On top of possible scaling factors for the arguments of the running QCD coupling, Dire also offers different functional forms of the argument itself. All of these functional forms reduce to a relative transverse momentum in the soft collinear limits, but differ for hard emissions."},{"name":"Dire:QminMECs","link":"DireExpert.html#anchor14","text":"Dire:QminMECs The minimal of all two-particle momentum invariants (in GeV) for which ME corrections should be applied. Non-negative values mean that all two-particle invariants are calculated, and if any is below this parameter, then ME corrections are not attempted. The corresponding change in the emission rate is relected in the probability of clustering histories used for MECs, such that subsequent ME corrections still recover the correct distribution."},{"name":"Dire:suppressLargeMECs","link":"DireExpert.html#anchor15","text":"Dire:suppressLargeMECs"},{"name":"Dire:Tune","link":"DireShowers.html#anchor22","text":"Dire:Tune If set to one, this enables the default tune of Pythia8 + Dire. Currently, all other values mean that no Pythia parameters are automatically overwritten by Dire."},{"name":"Dire:U1new:alphaX","link":"DireExpert.html#anchor9","text":"Dire:U1new:alphaX The coupling of the dark photon to (ficticious) dark-sector particles."},{"name":"DireColorQCD:CA","link":"DireExpert.html#anchor27","text":"DireColorQCD:CA Changes CA used by Dire. Any negative value means that consistent defaults are used."},{"name":"DireColorQCD:CF","link":"DireExpert.html#anchor29","text":"DireColorQCD:CF Changes CF used by Dire. Any negative value means that consistent defaults are used."},{"name":"DireColorQCD:NC","link":"DireExpert.html#anchor28","text":"DireColorQCD:NC Changes NC used by Dire. Any negative value means that consistent defaults are used."},{"name":"DireColorQCD:TR","link":"DireExpert.html#anchor26","text":"DireColorQCD:TR Changes TR used by Dire. Any negative value means that consistent defaults are used."},{"name":"DireGeneralizedKernel:collCoeffs:Dire_fsr_qcd_1->1&21","link":"DireExpert.html#anchor36","text":"DireGeneralizedKernel:collCoeffs:Dire_fsr_qcd_1->1&21"},{"name":"DireGeneralizedKernel:collCoeffs:Dire_fsr_qcd_1->21&1","link":"DireExpert.html#anchor43","text":"DireGeneralizedKernel:collCoeffs:Dire_fsr_qcd_1->21&1"},{"name":"DireGeneralizedKernel:collCoeffs:Dire_fsr_qcd_21->1&1a","link":"DireExpert.html#anchor60","text":"DireGeneralizedKernel:collCoeffs:Dire_fsr_qcd_21->1&1a"},{"name":"DireGeneralizedKernel:collCoeffs:Dire_fsr_qcd_21->1&1b","link":"DireExpert.html#anchor63","text":"DireGeneralizedKernel:collCoeffs:Dire_fsr_qcd_21->1&1b"},{"name":"DireGeneralizedKernel:collCoeffs:Dire_fsr_qcd_21->21&21a","link":"DireExpert.html#anchor50","text":"DireGeneralizedKernel:collCoeffs:Dire_fsr_qcd_21->21&21a"},{"name":"DireGeneralizedKernel:collCoeffs:Dire_fsr_qcd_21->21&21b","link":"DireExpert.html#anchor57","text":"DireGeneralizedKernel:collCoeffs:Dire_fsr_qcd_21->21&21b"},{"name":"DireGeneralizedKernel:collExps:Dire_fsr_qcd_1->1&21","link":"DireExpert.html#anchor37","text":"DireGeneralizedKernel:collExps:Dire_fsr_qcd_1->1&21"},{"name":"DireGeneralizedKernel:collExps:Dire_fsr_qcd_1->21&1","link":"DireExpert.html#anchor44","text":"DireGeneralizedKernel:collExps:Dire_fsr_qcd_1->21&1"},{"name":"DireGeneralizedKernel:collExps:Dire_fsr_qcd_21->1&1a","link":"DireExpert.html#anchor61","text":"DireGeneralizedKernel:collExps:Dire_fsr_qcd_21->1&1a"},{"name":"DireGeneralizedKernel:collExps:Dire_fsr_qcd_21->1&1b","link":"DireExpert.html#anchor64","text