define(["playbackManager","events","serverNotifications","connectionManager"],function(playbackManager,events,serverNotifications,connectionManager){"use strict";var PlayerName="Remote Control";function sendPlayCommand(instance,apiClient,options,playType){var sessionId=instance.currentSessionId,remoteOptions={ItemIds:(options.ids||options.items.map(function(i){return i.Id})).join(","),PlayCommand:playType};return null!=options.startPositionTicks&&(remoteOptions.StartPositionTicks=options.startPositionTicks),options.mediaSourceId&&(remoteOptions.MediaSourceId=options.mediaSourceId),null!=options.audioStreamIndex&&(remoteOptions.AudioStreamIndex=options.audioStreamIndex),null!=options.subtitleStreamIndex&&(remoteOptions.SubtitleStreamIndex=options.subtitleStreamIndex),null!=options.startIndex&&(remoteOptions.StartIndex=options.startIndex),apiClient.sendPlayCommand(sessionId,remoteOptions)}function sendPlayStateCommand(instance,apiClient,command,options){var sessionId=instance.currentSessionId;return apiClient.sendPlayStateCommand(sessionId,command,options)}function getCurrentApiClient(instance){var currentServerId=instance.currentServerId;return currentServerId?connectionManager.getApiClient(currentServerId):connectionManager.currentApiClient()}function sendCommandByName(instance,name,options){var command={Name:name};return options&&(command.Arguments=options),instance.sendCommand(command)}function processUpdatedSessions(instance,sessions,apiClient){var currentTargetId=instance.currentSessionId;processUpdatedSession(instance,sessions.filter(function(s){return s.Id===currentTargetId})[0],apiClient)}function triggerEvent(instance,eventName,session){"sessionstarted"===eventName&&(eventName="statechange"),session?events.trigger(instance,eventName,[session]):events.trigger(instance,eventName)}function processUpdatedSession(instance,session,apiClient){if(session){var serverId=apiClient.serverId();session.NowPlayingItem&&(session.NowPlayingItem.ServerId=serverId),normalizeImages(session,apiClient);var eventNames=function(){var names=[];return names.push("statechange"),names}(instance.lastPlayerData);instance.lastPlayerData=session;for(var i=0,length=eventNames.length;i<length;i++)events.trigger(instance,eventNames[i],[session])}else instance.lastPlayerData=session,playbackManager.removeActivePlayer(PlayerName)}function subscribeToPlayerUpdates(instance){var sessionId=instance.currentSessionId||"",apiClient=getCurrentApiClient(instance),messageListenerName=apiClient.isMinServerVersion("4.3.0.14")?"SessionEvents":apiClient.isMinServerVersion("4.2.0.22")?"Session":"Sessions";apiClient.startMessageListener(messageListenerName,"100,800,"+sessionId),instance.pollInterval&&(clearInterval(instance.pollInterval),instance.pollInterval=null),instance.pollInterval=setInterval(function(){var instance=this,apiClient=getCurrentApiClient(instance);apiClient.isMessageChannelOpen()||apiClient.getSessions({Id:instance.currentSessionId}).then(function(sessions){processUpdatedSessions(instance,sessions,apiClient)})}.bind(instance),5e3)}function normalizeImages(state,apiClient){if(state&&state.NowPlayingItem){var item=state.NowPlayingItem;item.ImageTags&&item.ImageTags.Primary||item.PrimaryImageTag&&(item.ImageTags=item.ImageTags||{},item.ImageTags.Primary=item.PrimaryImageTag),item.BackdropImageTag&&item.BackdropItemId===item.Id&&(item.BackdropImageTags=[item.BackdropImageTag]),item.BackdropImageTag&&item.BackdropItemId!==item.Id&&(item.ParentBackdropImageTags=[item.BackdropImageTag],item.ParentBackdropItemId=item.BackdropItemId),item.ServerId||(item.ServerId=apiClient.serverId())}}function SessionPlayer(){var self=this;this.name=PlayerName,this.type="mediaplayer",this.isLocalPlayer=!1,this.id="remoteplayer",events.on(serverNotifications,"SessionEvents",function(e,apiClient,data){!function(instance,sessionEventInfo,apiClient){var eventName=(sessionEventInfo.EventName||"statechange").toLowerCase();if("sessionended"===eventName)return instance.lastPlayerData=null,playbackManager.removeActivePlayer(PlayerName);var session=sessionEventInfo.SessionInfo;if(session)return normalizeImages(session,apiClient),session.NowPlayingItem&&(session.NowPlayingItem.ServerId=apiClient.serverId()),session.NextMediaType=sessionEventInfo.NextMediaType,instance.lastPlayerData=session,triggerEvent(instance,eventName,session);if(session=instance.lastPlayerData){var playState=session.PlayState;playState=playState||{};var triggerTimeUpdate=!1;null!=sessionEventInfo.PositionTicks&&(playState.PositionTicks=sessionEventInfo.PositionTicks,triggerTimeUpdate=!0),null!=sessionEventInfo.IsPaused&&(playState.IsPaused=sessionEventInfo.IsPaused),null!=sessionEventInfo.VolumeLevel&&(playState.VolumeLevel=sessionEventInfo.VolumeLevel),null!=sessionEventInfo.IsMuted&&(playState.IsMuted=sessionEventInfo.IsMuted),null!=sessionEventInfo.RepeatMode&&(playState.RepeatMode=sessionEventInfo.RepeatMode),"subtitletrackchange"===eventName?playState.SubtitleStreamIndex=sessionEventInfo.SubtitleStreamIndex:"audiotrackchange"===eventName&&(playState.AudioStreamIndex=sessionEventInfo.AudioStreamIndex),triggerEvent(instance,eventName),"timeupdate"!==eventName&&triggerTimeUpdate&&triggerEvent(instance,"timeupdate")}}(self,data,apiClient)}),events.on(serverNotifications,"Session",function(e,apiClient,data){apiClient.isMinServerVersion("4.3.0.14")||processUpdatedSession(self,data,apiClient)}),events.on(serverNotifications,"Sessions",function(e,apiClient,data){apiClient.isMinServerVersion("4.2.0.22")||processUpdatedSessions(self,data,apiClient)})}return SessionPlayer.prototype.beginPlayerUpdates=function(){this.playerListenerCount=this.playerListenerCount||0,this.playerListenerCount<=0&&(this.playerListenerCount=0,subscribeToPlayerUpdates(this)),this.playerListenerCount++},SessionPlayer.prototype.endPlayerUpdates=function(){this.playerListenerCount=this.playerListenerCount||0,this.playerListenerCount--,this.playerListenerCount<=0&&(function(instance){var apiClient=getCurrentApiClient(instance),messageListenerName=apiClient.isMinServerVersion("4.3.0.14")?"SessionEvents":apiClient.isMinServerVersion("4.2.0.22")?"Session":"Sessions";apiClient.stopMessageListener(messageListenerName),instance.pollInterval&&(clearInterval(instance.pollInterval),instance.pollInterval=null)}(this),this.playerListenerCount=0)},SessionPlayer.prototype.getPlayerState=function(){return this.lastPlayerData||{}},SessionPlayer.prototype.getTargets=function(){var apiClient=getCurrentApiClient(this),sessionQuery={ControllableByUserId:apiClient.getCurrentUserId()};if(apiClient){var name=this.name;return apiClient.getSessions(sessionQuery).then(function(sessions){return sessions.filter(function(s){return s.DeviceId!==apiClient.deviceId()}).map(function(s){return{name:s.DeviceName,deviceName:s.DeviceName,deviceType:s.DeviceType,id:s.Id,playerName:name,appName:s.Client,playableMediaTypes:s.PlayableMediaTypes,isLocalPlayer:!1,supportedCommands:s.SupportedCommands,user:s.UserId?{Id:s.UserId,Name:s.UserName,PrimaryImageTag:s.UserPrimaryImageTag}:null}})})}return Promise.resolve([])},SessionPlayer.prototype.sendCommand=function(command){var sessionId=this.currentSessionId;return getCurrentApiClient(this).sendCommand(sessionId,command)},SessionPlayer.prototype.play=function(options){return(options=Object.assign({},options)).items&&(options.ids=options.items.map(function(i){return i.Id}),options.items=null),sendPlayCommand(this,getCurrentApiClient(this),options,"PlayNow")},SessionPlayer.prototype.shuffle=function(item){sendPlayCommand(this,getCurrentApiClient(this),{ids:[item.Id]},"PlayShuffle")},SessionPlayer.prototype.instantMix=function(item){sendPlayCommand(this,getCurrentApiClient(this),{ids:[item.Id]},"PlayInstantMix")},SessionPlayer.prototype.queue=function(options){sendPlayCommand(this,getCurrentApiClient(this),options,"PlayLast")},SessionPlayer.prototype.queueNext=function(options){sendPlayCommand(this,getCurrentApiClient(this),options,"PlayNext")},SessionPlayer.prototype.canPlayMediaType=function(mediaType){return"audio"===(mediaType=(mediaType||"").toLowerCase())||"video"===mediaType},SessionPlayer.prototype.stop=function(){return sendPlayStateCommand(this,getCurrentApiClient(this),"stop")},SessionPlayer.prototype.nextTrack=function(){return sendPlayStateCommand(this,getCurrentApiClient(this),"nextTrack")},SessionPlayer.prototype.previousTrack=function(){return sendPlayStateCommand(this,getCurrentApiClient(this),"previousTrack")},SessionPlayer.prototype.seek=function(positionTicks){sendPlayStateCommand(this,getCurrentApiClient(this),"seek",{SeekPositionTicks:positionTicks})},SessionPlayer.prototype.currentTime=function(val){if(null!=val)return this.seek(val);var state=this.lastPlayerData||{};return(state=state.PlayState||{}).PositionTicks},SessionPlayer.prototype.playbackStartTime=function(){var state=this.lastPlayerData||{};return(state=state.PlayState||{}).PlaybackStartTimeTicks},SessionPlayer.prototype.duration=function(){var state=this.lastPlayerData||{};return(state=state.NowPlayingItem||{}).RunTimeTicks},SessionPlayer.prototype.paused=function(){var state=this.lastPlayerData||{};return(state=state.PlayState||{}).IsPaused},SessionPlayer.prototype.getVolume=function(){var state=this.lastPlayerData||{};return(state=state.PlayState||{}).VolumeLevel},SessionPlayer.prototype.isMuted=function(){var state=this.lastPlayerData||{};return(state=state.PlayState||{}).IsMuted},SessionPlayer.prototype.pause=function(){sendPlayStateCommand(this,getCurrentApiClient(this),"Pause")},SessionPlayer.prototype.unpause=function(){sendPlayStateCommand(this,getCurrentApiClient(this),"Unpause")},SessionPlayer.prototype.playPause=function(){sendPlayStateCommand(this,getCurrentApiClient(this),"PlayPause")},SessionPlayer.prototype.setMute=function(isMuted){return sendCommandByName(this,isMuted?"Mute":"Unmute")},SessionPlayer.prototype.toggleMute=function(){return sendCommandByName(this,"ToggleMute")},SessionPlayer.prototype.setVolume=function(vol){return sendCommandByName(this,"SetVolume",{Volume:vol})},SessionPlayer.prototype.volumeUp=function(){return sendCommandByName(this,"VolumeUp")},SessionPlayer.prototype.volumeDown=function(){return sendCommandByName(this,"VolumeDown")},SessionPlayer.prototype.toggleFullscreen=function(){return sendCommandByName(this,"ToggleFullscreen")},SessionPlayer.prototype.audioTracks=function(){var state=this.lastPlayerData||{};return((state=state.NowPlayingItem||{}).MediaStreams||[]).filter(function(s){return"Audio"===s.Type})},SessionPlayer.prototype.getAudioStreamIndex=function(){var state=this.lastPlayerData||{};return(state=state.PlayState||{}).AudioStreamIndex},SessionPlayer.prototype.playTrailers=function(item){return sendCommandByName(this,"PlayTrailers",{ItemId:item.Id})},SessionPlayer.prototype.setAudioStreamIndex=function(index){return sendCommandByName(this,"SetAudioStreamIndex",{Index:index})},SessionPlayer.prototype.subtitleTracks=function(){var state=this.lastPlayerData||{};return((state=state.NowPlayingItem||{}).MediaStreams||[]).filter(function(s){return"Subtitle"===s.Type})},SessionPlayer.prototype.getSubtitleStreamIndex=function(){var state=this.lastPlayerData||{};return(state=state.PlayState||{}).SubtitleStreamIndex},SessionPlayer.prototype.setSubtitleStreamIndex=function(index){sendCommandByName(this,"SetSubtitleStreamIndex",{Index:index})},SessionPlayer.prototype.getMaxStreamingBitrate=function(){},SessionPlayer.prototype.setMaxStreamingBitrate=function(options){},SessionPlayer.prototype.isFullscreen=function(){},SessionPlayer.prototype.toggleFullscreen=function(){},SessionPlayer.prototype.getRepeatMode=function(){var state=this.lastPlayerData||{};return(state=state.PlayState||{}).RepeatMode},SessionPlayer.prototype.setRepeatMode=function(mode){return sendCommandByName(this,"SetRepeatMode",{RepeatMode:mode})},SessionPlayer.prototype.displayContent=function(options){return sendCommandByName(this,"DisplayContent",options)},SessionPlayer.prototype.isPlaying=function(){return null!=(this.lastPlayerData||{}).NowPlayingItem},SessionPlayer.prototype.getPlaylist=function(){return Promise.resolve([])},SessionPlayer.prototype.getCurrentPlaylistItemId=function(){return(this.lastPlayerData||{}).PlaylistItemId},SessionPlayer.prototype.getCurrentPlaylistIndex=function(){return(this.lastPlayerData||{}).PlaylistIndex},SessionPlayer.prototype.getCurrentPlaylistLength=function(){return(this.lastPlayerData||{}).PlaylistLength},SessionPlayer.prototype.setCurrentPlaylistItem=function(playlistItemId){return Promise.resolve()},SessionPlayer.prototype.removeFromPlaylist=function(playlistItemIds){return Promise.resolve()},SessionPlayer.prototype.tryPair=function(target){return this.currentSessionId=target.id,Promise.resolve()},SessionPlayer});