//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.3
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * The IceGrid administrative interface.
 * <p class="Warning">Allowing access to this interface
 * is a security risk! Please see the IceGrid documentation
 * for further information.
 **/
public interface AdminPrx extends com.zeroc.Ice.ObjectPrx
{
    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws DeploymentException Raised if application deployment
     * failed.
     **/
    default void addApplication(ApplicationDescriptor descriptor)
        throws AccessDeniedException,
               DeploymentException
    {
        addApplication(descriptor, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws DeploymentException Raised if application deployment
     * failed.
     **/
    default void addApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> context)
        throws AccessDeniedException,
               DeploymentException
    {
        try
        {
            _iceI_addApplicationAsync(descriptor, context, true).waitForResponseOrUserEx();
        }
        catch(AccessDeniedException ex)
        {
            throw ex;
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> addApplicationAsync(ApplicationDescriptor descriptor)
    {
        return _iceI_addApplicationAsync(descriptor, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> addApplicationAsync(ApplicationDescriptor descriptor, java.util.Map<String, String> context)
    {
        return _iceI_addApplicationAsync(descriptor, context, false);
    }

    /**
     * @hidden
     * @param iceP_descriptor -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_addApplicationAsync(ApplicationDescriptor iceP_descriptor, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "addApplication", null, sync, _iceE_addApplication);
        f.invoke(true, context, null, ostr -> {
                     ApplicationDescriptor.ice_write(ostr, iceP_descriptor);
                     ostr.writePendingValues();
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_addApplication =
    {
        AccessDeniedException.class,
        DeploymentException.class
    };

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if application deployment
     * failed.
     **/
    default void syncApplication(ApplicationDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        syncApplication(descriptor, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if application deployment
     * failed.
     **/
    default void syncApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> context)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        try
        {
            _iceI_syncApplicationAsync(descriptor, context, true).waitForResponseOrUserEx();
        }
        catch(AccessDeniedException ex)
        {
            throw ex;
        }
        catch(ApplicationNotExistException ex)
        {
            throw ex;
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> syncApplicationAsync(ApplicationDescriptor descriptor)
    {
        return _iceI_syncApplicationAsync(descriptor, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> syncApplicationAsync(ApplicationDescriptor descriptor, java.util.Map<String, String> context)
    {
        return _iceI_syncApplicationAsync(descriptor, context, false);
    }

    /**
     * @hidden
     * @param iceP_descriptor -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_syncApplicationAsync(ApplicationDescriptor iceP_descriptor, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "syncApplication", null, sync, _iceE_syncApplication);
        f.invoke(true, context, null, ostr -> {
                     ApplicationDescriptor.ice_write(ostr, iceP_descriptor);
                     ostr.writePendingValues();
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_syncApplication =
    {
        AccessDeniedException.class,
        ApplicationNotExistException.class,
        DeploymentException.class
    };

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if application deployment
     * failed.
     **/
    default void updateApplication(ApplicationUpdateDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        updateApplication(descriptor, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if application deployment
     * failed.
     **/
    default void updateApplication(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> context)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        try
        {
            _iceI_updateApplicationAsync(descriptor, context, true).waitForResponseOrUserEx();
        }
        catch(AccessDeniedException ex)
        {
            throw ex;
        }
        catch(ApplicationNotExistException ex)
        {
            throw ex;
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> updateApplicationAsync(ApplicationUpdateDescriptor descriptor)
    {
        return _iceI_updateApplicationAsync(descriptor, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> updateApplicationAsync(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> context)
    {
        return _iceI_updateApplicationAsync(descriptor, context, false);
    }

    /**
     * @hidden
     * @param iceP_descriptor -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_updateApplicationAsync(ApplicationUpdateDescriptor iceP_descriptor, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "updateApplication", null, sync, _iceE_updateApplication);
        f.invoke(true, context, null, ostr -> {
                     ApplicationUpdateDescriptor.ice_write(ostr, iceP_descriptor);
                     ostr.writePendingValues();
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_updateApplication =
    {
        AccessDeniedException.class,
        ApplicationNotExistException.class,
        DeploymentException.class
    };

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if application deployment
     * failed.
     **/
    default void syncApplicationWithoutRestart(ApplicationDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        syncApplicationWithoutRestart(descriptor, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if application deployment
     * failed.
     **/
    default void syncApplicationWithoutRestart(ApplicationDescriptor descriptor, java.util.Map<String, String> context)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        try
        {
            _iceI_syncApplicationWithoutRestartAsync(descriptor, context, true).waitForResponseOrUserEx();
        }
        catch(AccessDeniedException ex)
        {
            throw ex;
        }
        catch(ApplicationNotExistException ex)
        {
            throw ex;
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> syncApplicationWithoutRestartAsync(ApplicationDescriptor descriptor)
    {
        return _iceI_syncApplicationWithoutRestartAsync(descriptor, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> syncApplicationWithoutRestartAsync(ApplicationDescriptor descriptor, java.util.Map<String, String> context)
    {
        return _iceI_syncApplicationWithoutRestartAsync(descriptor, context, false);
    }

    /**
     * @hidden
     * @param iceP_descriptor -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_syncApplicationWithoutRestartAsync(ApplicationDescriptor iceP_descriptor, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "syncApplicationWithoutRestart", null, sync, _iceE_syncApplicationWithoutRestart);
        f.invoke(true, context, null, ostr -> {
                     ApplicationDescriptor.ice_write(ostr, iceP_descriptor);
                     ostr.writePendingValues();
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_syncApplicationWithoutRestart =
    {
        AccessDeniedException.class,
        ApplicationNotExistException.class,
        DeploymentException.class
    };

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if application deployment
     * failed.
     **/
    default void updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        updateApplicationWithoutRestart(descriptor, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if application deployment
     * failed.
     **/
    default void updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> context)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        try
        {
            _iceI_updateApplicationWithoutRestartAsync(descriptor, context, true).waitForResponseOrUserEx();
        }
        catch(AccessDeniedException ex)
        {
            throw ex;
        }
        catch(ApplicationNotExistException ex)
        {
            throw ex;
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> updateApplicationWithoutRestartAsync(ApplicationUpdateDescriptor descriptor)
    {
        return _iceI_updateApplicationWithoutRestartAsync(descriptor, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> updateApplicationWithoutRestartAsync(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> context)
    {
        return _iceI_updateApplicationWithoutRestartAsync(descriptor, context, false);
    }

    /**
     * @hidden
     * @param iceP_descriptor -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_updateApplicationWithoutRestartAsync(ApplicationUpdateDescriptor iceP_descriptor, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "updateApplicationWithoutRestart", null, sync, _iceE_updateApplicationWithoutRestart);
        f.invoke(true, context, null, ostr -> {
                     ApplicationUpdateDescriptor.ice_write(ostr, iceP_descriptor);
                     ostr.writePendingValues();
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_updateApplicationWithoutRestart =
    {
        AccessDeniedException.class,
        ApplicationNotExistException.class,
        DeploymentException.class
    };

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if application deployment failed.
     **/
    default void removeApplication(String name)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        removeApplication(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if application deployment failed.
     **/
    default void removeApplication(String name, java.util.Map<String, String> context)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        try
        {
            _iceI_removeApplicationAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(AccessDeniedException ex)
        {
            throw ex;
        }
        catch(ApplicationNotExistException ex)
        {
            throw ex;
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> removeApplicationAsync(String name)
    {
        return _iceI_removeApplicationAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> removeApplicationAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_removeApplicationAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_removeApplicationAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "removeApplication", null, sync, _iceE_removeApplication);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_removeApplication =
    {
        AccessDeniedException.class,
        ApplicationNotExistException.class,
        DeploymentException.class
    };

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if server instantiation
     * failed.
     **/
    default void instantiateServer(String application, String node, ServerInstanceDescriptor desc)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        instantiateServer(application, node, desc, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @param context The Context map to send with the invocation.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if server instantiation
     * failed.
     **/
    default void instantiateServer(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> context)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        try
        {
            _iceI_instantiateServerAsync(application, node, desc, context, true).waitForResponseOrUserEx();
        }
        catch(AccessDeniedException ex)
        {
            throw ex;
        }
        catch(ApplicationNotExistException ex)
        {
            throw ex;
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> instantiateServerAsync(String application, String node, ServerInstanceDescriptor desc)
    {
        return _iceI_instantiateServerAsync(application, node, desc, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> instantiateServerAsync(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> context)
    {
        return _iceI_instantiateServerAsync(application, node, desc, context, false);
    }

    /**
     * @hidden
     * @param iceP_application -
     * @param iceP_node -
     * @param iceP_desc -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_instantiateServerAsync(String iceP_application, String iceP_node, ServerInstanceDescriptor iceP_desc, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "instantiateServer", null, sync, _iceE_instantiateServer);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_application);
                     ostr.writeString(iceP_node);
                     ServerInstanceDescriptor.ice_write(ostr, iceP_desc);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_instantiateServer =
    {
        AccessDeniedException.class,
        ApplicationNotExistException.class,
        DeploymentException.class
    };

    /**
     * Patch the given application data.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws PatchException Raised if the patch failed.
     **/
    default void patchApplication(String name, boolean shutdown)
        throws ApplicationNotExistException,
               PatchException
    {
        patchApplication(name, shutdown, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Patch the given application data.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws PatchException Raised if the patch failed.
     **/
    default void patchApplication(String name, boolean shutdown, java.util.Map<String, String> context)
        throws ApplicationNotExistException,
               PatchException
    {
        try
        {
            _iceI_patchApplicationAsync(name, shutdown, context, true).waitForResponseOrUserEx();
        }
        catch(ApplicationNotExistException ex)
        {
            throw ex;
        }
        catch(PatchException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Patch the given application data.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> patchApplicationAsync(String name, boolean shutdown)
    {
        return _iceI_patchApplicationAsync(name, shutdown, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Patch the given application data.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> patchApplicationAsync(String name, boolean shutdown, java.util.Map<String, String> context)
    {
        return _iceI_patchApplicationAsync(name, shutdown, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param iceP_shutdown -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_patchApplicationAsync(String iceP_name, boolean iceP_shutdown, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "patchApplication", null, sync, _iceE_patchApplication);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                     ostr.writeBool(iceP_shutdown);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_patchApplication =
    {
        ApplicationNotExistException.class,
        PatchException.class
    };

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @return The application descriptor.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     **/
    default ApplicationInfo getApplicationInfo(String name)
        throws ApplicationNotExistException
    {
        return getApplicationInfo(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @return The application descriptor.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     **/
    default ApplicationInfo getApplicationInfo(String name, java.util.Map<String, String> context)
        throws ApplicationNotExistException
    {
        try
        {
            return _iceI_getApplicationInfoAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(ApplicationNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @return The application descriptor.
     **/
    default java.util.concurrent.CompletableFuture<ApplicationInfo> getApplicationInfoAsync(String name)
    {
        return _iceI_getApplicationInfoAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @return The application descriptor.
     **/
    default java.util.concurrent.CompletableFuture<ApplicationInfo> getApplicationInfoAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_getApplicationInfoAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<ApplicationInfo> _iceI_getApplicationInfoAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<ApplicationInfo> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getApplicationInfo", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_getApplicationInfo);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                 }, istr -> {
                     ApplicationInfo ret;
                     ret = ApplicationInfo.ice_read(istr);
                     istr.readPendingValues();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getApplicationInfo =
    {
        ApplicationNotExistException.class
    };

    /**
     * Get the default application descriptor.
     * @return The default application descriptor.
     * @throws DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     **/
    default ApplicationDescriptor getDefaultApplicationDescriptor()
        throws DeploymentException
    {
        return getDefaultApplicationDescriptor(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the default application descriptor.
     * @param context The Context map to send with the invocation.
     * @return The default application descriptor.
     * @throws DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     **/
    default ApplicationDescriptor getDefaultApplicationDescriptor(java.util.Map<String, String> context)
        throws DeploymentException
    {
        try
        {
            return _iceI_getDefaultApplicationDescriptorAsync(context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get the default application descriptor.
     * @return The default application descriptor.
     **/
    default java.util.concurrent.CompletableFuture<ApplicationDescriptor> getDefaultApplicationDescriptorAsync()
    {
        return _iceI_getDefaultApplicationDescriptorAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the default application descriptor.
     * @param context The Context map to send with the invocation.
     * @return The default application descriptor.
     **/
    default java.util.concurrent.CompletableFuture<ApplicationDescriptor> getDefaultApplicationDescriptorAsync(java.util.Map<String, String> context)
    {
        return _iceI_getDefaultApplicationDescriptorAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<ApplicationDescriptor> _iceI_getDefaultApplicationDescriptorAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<ApplicationDescriptor> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getDefaultApplicationDescriptor", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_getDefaultApplicationDescriptor);
        f.invoke(true, context, null, null, istr -> {
                     ApplicationDescriptor ret;
                     ret = ApplicationDescriptor.ice_read(istr);
                     istr.readPendingValues();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getDefaultApplicationDescriptor =
    {
        DeploymentException.class
    };

    /**
     * Get all the IceGrid applications currently registered.
     * @return The application names.
     **/
    default String[] getAllApplicationNames()
    {
        return getAllApplicationNames(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get all the IceGrid applications currently registered.
     * @param context The Context map to send with the invocation.
     * @return The application names.
     **/
    default String[] getAllApplicationNames(java.util.Map<String, String> context)
    {
        return _iceI_getAllApplicationNamesAsync(context, true).waitForResponse();
    }

    /**
     * Get all the IceGrid applications currently registered.
     * @return The application names.
     **/
    default java.util.concurrent.CompletableFuture<String[]> getAllApplicationNamesAsync()
    {
        return _iceI_getAllApplicationNamesAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get all the IceGrid applications currently registered.
     * @param context The Context map to send with the invocation.
     * @return The application names.
     **/
    default java.util.concurrent.CompletableFuture<String[]> getAllApplicationNamesAsync(java.util.Map<String, String> context)
    {
        return _iceI_getAllApplicationNamesAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<String[]> _iceI_getAllApplicationNamesAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<String[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getAllApplicationNames", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     String[] ret;
                     ret = istr.readStringSeq();
                     return ret;
                 });
        return f;
    }

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @return The server information.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     **/
    default ServerInfo getServerInfo(String id)
        throws ServerNotExistException
    {
        return getServerInfo(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The server information.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     **/
    default ServerInfo getServerInfo(String id, java.util.Map<String, String> context)
        throws ServerNotExistException
    {
        try
        {
            return _iceI_getServerInfoAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch(ServerNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @return The server information.
     **/
    default java.util.concurrent.CompletableFuture<ServerInfo> getServerInfoAsync(String id)
    {
        return _iceI_getServerInfoAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The server information.
     **/
    default java.util.concurrent.CompletableFuture<ServerInfo> getServerInfoAsync(String id, java.util.Map<String, String> context)
    {
        return _iceI_getServerInfoAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<ServerInfo> _iceI_getServerInfoAsync(String iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<ServerInfo> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getServerInfo", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_getServerInfo);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                 }, istr -> {
                     ServerInfo ret;
                     ret = ServerInfo.ice_read(istr);
                     istr.readPendingValues();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getServerInfo =
    {
        ServerNotExistException.class
    };

    /**
     * Get a server's state.
     * @param id The server id.
     * @return The server state.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     **/
    default ServerState getServerState(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return getServerState(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get a server's state.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The server state.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     **/
    default ServerState getServerState(String id, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        try
        {
            return _iceI_getServerStateAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(ServerNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get a server's state.
     * @param id The server id.
     * @return The server state.
     **/
    default java.util.concurrent.CompletableFuture<ServerState> getServerStateAsync(String id)
    {
        return _iceI_getServerStateAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get a server's state.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The server state.
     **/
    default java.util.concurrent.CompletableFuture<ServerState> getServerStateAsync(String id, java.util.Map<String, String> context)
    {
        return _iceI_getServerStateAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<ServerState> _iceI_getServerStateAsync(String iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<ServerState> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getServerState", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_getServerState);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                 }, istr -> {
                     ServerState ret;
                     ret = ServerState.ice_read(istr);
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getServerState =
    {
        DeploymentException.class,
        NodeUnreachableException.class,
        ServerNotExistException.class
    };

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @return The server's process id.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     **/
    default int getServerPid(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return getServerPid(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The server's process id.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     **/
    default int getServerPid(String id, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        try
        {
            return _iceI_getServerPidAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(ServerNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @return The server's process id.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Integer> getServerPidAsync(String id)
    {
        return _iceI_getServerPidAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The server's process id.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Integer> getServerPidAsync(String id, java.util.Map<String, String> context)
    {
        return _iceI_getServerPidAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.Integer> _iceI_getServerPidAsync(String iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.Integer> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getServerPid", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_getServerPid);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                 }, istr -> {
                     int ret;
                     ret = istr.readInt();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getServerPid =
    {
        DeploymentException.class,
        NodeUnreachableException.class,
        ServerNotExistException.class
    };

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @return The category for server admin objects.
     **/
    default String getServerAdminCategory()
    {
        return getServerAdminCategory(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @param context The Context map to send with the invocation.
     * @return The category for server admin objects.
     **/
    default String getServerAdminCategory(java.util.Map<String, String> context)
    {
        return _iceI_getServerAdminCategoryAsync(context, true).waitForResponse();
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @return The category for server admin objects.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.String> getServerAdminCategoryAsync()
    {
        return _iceI_getServerAdminCategoryAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @param context The Context map to send with the invocation.
     * @return The category for server admin objects.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.String> getServerAdminCategoryAsync(java.util.Map<String, String> context)
    {
        return _iceI_getServerAdminCategoryAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.String> _iceI_getServerAdminCategoryAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.String> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getServerAdminCategory", com.zeroc.Ice.OperationMode.Idempotent, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     String ret;
                     ret = istr.readString();
                     return ret;
                 });
        return f;
    }

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @return A proxy to the server's admin object
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     **/
    default com.zeroc.Ice.ObjectPrx getServerAdmin(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return getServerAdmin(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the server's admin object
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     **/
    default com.zeroc.Ice.ObjectPrx getServerAdmin(String id, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        try
        {
            return _iceI_getServerAdminAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(ServerNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @return A proxy to the server's admin object
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> getServerAdminAsync(String id)
    {
        return _iceI_getServerAdminAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the server's admin object
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> getServerAdminAsync(String id, java.util.Map<String, String> context)
    {
        return _iceI_getServerAdminAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> _iceI_getServerAdminAsync(String iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getServerAdmin", com.zeroc.Ice.OperationMode.Idempotent, sync, _iceE_getServerAdmin);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                 }, istr -> {
                     com.zeroc.Ice.ObjectPrx ret;
                     ret = istr.readProxy();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getServerAdmin =
    {
        DeploymentException.class,
        NodeUnreachableException.class,
        ServerNotExistException.class
    };

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     **/
    default void enableServer(String id, boolean enabled)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        enableServer(id, enabled, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @param context The Context map to send with the invocation.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     **/
    default void enableServer(String id, boolean enabled, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        try
        {
            _iceI_enableServerAsync(id, enabled, context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(ServerNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> enableServerAsync(String id, boolean enabled)
    {
        return _iceI_enableServerAsync(id, enabled, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> enableServerAsync(String id, boolean enabled, java.util.Map<String, String> context)
    {
        return _iceI_enableServerAsync(id, enabled, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param iceP_enabled -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_enableServerAsync(String iceP_id, boolean iceP_enabled, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "enableServer", com.zeroc.Ice.OperationMode.Idempotent, sync, _iceE_enableServer);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                     ostr.writeBool(iceP_enabled);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_enableServer =
    {
        DeploymentException.class,
        NodeUnreachableException.class,
        ServerNotExistException.class
    };

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @return True if the server is enabled.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    default boolean isServerEnabled(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return isServerEnabled(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return True if the server is enabled.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    default boolean isServerEnabled(String id, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        try
        {
            return _iceI_isServerEnabledAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(ServerNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @return True if the server is enabled.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Boolean> isServerEnabledAsync(String id)
    {
        return _iceI_isServerEnabledAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return True if the server is enabled.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Boolean> isServerEnabledAsync(String id, java.util.Map<String, String> context)
    {
        return _iceI_isServerEnabledAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.Boolean> _iceI_isServerEnabledAsync(String iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.Boolean> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "isServerEnabled", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_isServerEnabled);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                 }, istr -> {
                     boolean ret;
                     ret = istr.readBool();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_isServerEnabled =
    {
        DeploymentException.class,
        NodeUnreachableException.class,
        ServerNotExistException.class
    };

    /**
     * Start a server and wait for its activation.
     * @param id The server id.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws ServerStartException Raised if the server couldn't be
     * started.
     **/
    default void startServer(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStartException
    {
        startServer(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Start a server and wait for its activation.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws ServerStartException Raised if the server couldn't be
     * started.
     **/
    default void startServer(String id, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStartException
    {
        try
        {
            _iceI_startServerAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(ServerNotExistException ex)
        {
            throw ex;
        }
        catch(ServerStartException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Start a server and wait for its activation.
     * @param id The server id.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> startServerAsync(String id)
    {
        return _iceI_startServerAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Start a server and wait for its activation.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> startServerAsync(String id, java.util.Map<String, String> context)
    {
        return _iceI_startServerAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_startServerAsync(String iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "startServer", null, sync, _iceE_startServer);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_startServer =
    {
        DeploymentException.class,
        NodeUnreachableException.class,
        ServerNotExistException.class,
        ServerStartException.class
    };

    /**
     * Stop a server.
     * @param id The server id.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws ServerStopException Raised if the server couldn't be
     * stopped.
     **/
    default void stopServer(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStopException
    {
        stopServer(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Stop a server.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws ServerStopException Raised if the server couldn't be
     * stopped.
     **/
    default void stopServer(String id, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStopException
    {
        try
        {
            _iceI_stopServerAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(ServerNotExistException ex)
        {
            throw ex;
        }
        catch(ServerStopException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Stop a server.
     * @param id The server id.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> stopServerAsync(String id)
    {
        return _iceI_stopServerAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Stop a server.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> stopServerAsync(String id, java.util.Map<String, String> context)
    {
        return _iceI_stopServerAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_stopServerAsync(String iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "stopServer", null, sync, _iceE_stopServer);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_stopServer =
    {
        DeploymentException.class,
        NodeUnreachableException.class,
        ServerNotExistException.class,
        ServerStopException.class
    };

    /**
     * Patch a server.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws PatchException Raised if the patch failed.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    default void patchServer(String id, boolean shutdown)
        throws DeploymentException,
               NodeUnreachableException,
               PatchException,
               ServerNotExistException
    {
        patchServer(id, shutdown, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Patch a server.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws PatchException Raised if the patch failed.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    default void patchServer(String id, boolean shutdown, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               PatchException,
               ServerNotExistException
    {
        try
        {
            _iceI_patchServerAsync(id, shutdown, context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(PatchException ex)
        {
            throw ex;
        }
        catch(ServerNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Patch a server.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> patchServerAsync(String id, boolean shutdown)
    {
        return _iceI_patchServerAsync(id, shutdown, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Patch a server.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> patchServerAsync(String id, boolean shutdown, java.util.Map<String, String> context)
    {
        return _iceI_patchServerAsync(id, shutdown, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param iceP_shutdown -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_patchServerAsync(String iceP_id, boolean iceP_shutdown, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "patchServer", null, sync, _iceE_patchServer);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                     ostr.writeBool(iceP_shutdown);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_patchServer =
    {
        DeploymentException.class,
        NodeUnreachableException.class,
        PatchException.class,
        ServerNotExistException.class
    };

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @throws BadSignalException Raised if the signal is not recognized
     * by the target server.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    default void sendSignal(String id, String signal)
        throws BadSignalException,
               DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        sendSignal(id, signal, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @param context The Context map to send with the invocation.
     * @throws BadSignalException Raised if the signal is not recognized
     * by the target server.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    default void sendSignal(String id, String signal, java.util.Map<String, String> context)
        throws BadSignalException,
               DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        try
        {
            _iceI_sendSignalAsync(id, signal, context, true).waitForResponseOrUserEx();
        }
        catch(BadSignalException ex)
        {
            throw ex;
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(ServerNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> sendSignalAsync(String id, String signal)
    {
        return _iceI_sendSignalAsync(id, signal, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> sendSignalAsync(String id, String signal, java.util.Map<String, String> context)
    {
        return _iceI_sendSignalAsync(id, signal, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param iceP_signal -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_sendSignalAsync(String iceP_id, String iceP_signal, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "sendSignal", null, sync, _iceE_sendSignal);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                     ostr.writeString(iceP_signal);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_sendSignal =
    {
        BadSignalException.class,
        DeploymentException.class,
        NodeUnreachableException.class,
        ServerNotExistException.class
    };

    /**
     * Get all the server ids registered with IceGrid.
     * @return The server ids.
     **/
    default String[] getAllServerIds()
    {
        return getAllServerIds(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get all the server ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @return The server ids.
     **/
    default String[] getAllServerIds(java.util.Map<String, String> context)
    {
        return _iceI_getAllServerIdsAsync(context, true).waitForResponse();
    }

    /**
     * Get all the server ids registered with IceGrid.
     * @return The server ids.
     **/
    default java.util.concurrent.CompletableFuture<String[]> getAllServerIdsAsync()
    {
        return _iceI_getAllServerIdsAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get all the server ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @return The server ids.
     **/
    default java.util.concurrent.CompletableFuture<String[]> getAllServerIdsAsync(java.util.Map<String, String> context)
    {
        return _iceI_getAllServerIdsAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<String[]> _iceI_getAllServerIdsAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<String[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getAllServerIds", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     String[] ret;
                     ret = istr.readStringSeq();
                     return ret;
                 });
        return f;
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     * @throws AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     **/
    default AdapterInfo[] getAdapterInfo(String id)
        throws AdapterNotExistException
    {
        return getAdapterInfo(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     * @throws AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     **/
    default AdapterInfo[] getAdapterInfo(String id, java.util.Map<String, String> context)
        throws AdapterNotExistException
    {
        try
        {
            return _iceI_getAdapterInfoAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch(AdapterNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     **/
    default java.util.concurrent.CompletableFuture<AdapterInfo[]> getAdapterInfoAsync(String id)
    {
        return _iceI_getAdapterInfoAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     **/
    default java.util.concurrent.CompletableFuture<AdapterInfo[]> getAdapterInfoAsync(String id, java.util.Map<String, String> context)
    {
        return _iceI_getAdapterInfoAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<AdapterInfo[]> _iceI_getAdapterInfoAsync(String iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<AdapterInfo[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getAdapterInfo", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_getAdapterInfo);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                 }, istr -> {
                     AdapterInfo[] ret;
                     ret = AdapterInfoSeqHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getAdapterInfo =
    {
        AdapterNotExistException.class
    };

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @throws AdapterNotExistException Raised if the adapter doesn't
     * exist.
     * @throws DeploymentException Raised if application deployment failed.
     **/
    default void removeAdapter(String id)
        throws AdapterNotExistException,
               DeploymentException
    {
        removeAdapter(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @throws AdapterNotExistException Raised if the adapter doesn't
     * exist.
     * @throws DeploymentException Raised if application deployment failed.
     **/
    default void removeAdapter(String id, java.util.Map<String, String> context)
        throws AdapterNotExistException,
               DeploymentException
    {
        try
        {
            _iceI_removeAdapterAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch(AdapterNotExistException ex)
        {
            throw ex;
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> removeAdapterAsync(String id)
    {
        return _iceI_removeAdapterAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> removeAdapterAsync(String id, java.util.Map<String, String> context)
    {
        return _iceI_removeAdapterAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_removeAdapterAsync(String iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "removeAdapter", null, sync, _iceE_removeAdapter);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_removeAdapter =
    {
        AdapterNotExistException.class,
        DeploymentException.class
    };

    /**
     * Get all the adapter ids registered with IceGrid.
     * @return The adapter ids.
     **/
    default String[] getAllAdapterIds()
    {
        return getAllAdapterIds(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @return The adapter ids.
     **/
    default String[] getAllAdapterIds(java.util.Map<String, String> context)
    {
        return _iceI_getAllAdapterIdsAsync(context, true).waitForResponse();
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * @return The adapter ids.
     **/
    default java.util.concurrent.CompletableFuture<String[]> getAllAdapterIdsAsync()
    {
        return _iceI_getAllAdapterIdsAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @return The adapter ids.
     **/
    default java.util.concurrent.CompletableFuture<String[]> getAllAdapterIdsAsync(java.util.Map<String, String> context)
    {
        return _iceI_getAllAdapterIdsAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<String[]> _iceI_getAllAdapterIdsAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<String[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getAllAdapterIds", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     String[] ret;
                     ret = istr.readStringSeq();
                     return ret;
                 });
        return f;
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @throws DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     **/
    default void addObject(com.zeroc.Ice.ObjectPrx obj)
        throws DeploymentException,
               ObjectExistsException
    {
        addObject(obj, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @param context The Context map to send with the invocation.
     * @throws DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     **/
    default void addObject(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
        throws DeploymentException,
               ObjectExistsException
    {
        try
        {
            _iceI_addObjectAsync(obj, context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(ObjectExistsException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> addObjectAsync(com.zeroc.Ice.ObjectPrx obj)
    {
        return _iceI_addObjectAsync(obj, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> addObjectAsync(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return _iceI_addObjectAsync(obj, context, false);
    }

    /**
     * @hidden
     * @param iceP_obj -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_addObjectAsync(com.zeroc.Ice.ObjectPrx iceP_obj, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "addObject", null, sync, _iceE_addObject);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeProxy(iceP_obj);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_addObject =
    {
        DeploymentException.class,
        ObjectExistsException.class
    };

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @throws DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     **/
    default void updateObject(com.zeroc.Ice.ObjectPrx obj)
        throws DeploymentException,
               ObjectNotRegisteredException
    {
        updateObject(obj, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @param context The Context map to send with the invocation.
     * @throws DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     **/
    default void updateObject(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
        throws DeploymentException,
               ObjectNotRegisteredException
    {
        try
        {
            _iceI_updateObjectAsync(obj, context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(ObjectNotRegisteredException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> updateObjectAsync(com.zeroc.Ice.ObjectPrx obj)
    {
        return _iceI_updateObjectAsync(obj, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> updateObjectAsync(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return _iceI_updateObjectAsync(obj, context, false);
    }

    /**
     * @hidden
     * @param iceP_obj -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_updateObjectAsync(com.zeroc.Ice.ObjectPrx iceP_obj, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "updateObject", null, sync, _iceE_updateObject);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeProxy(iceP_obj);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_updateObject =
    {
        DeploymentException.class,
        ObjectNotRegisteredException.class
    };

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @throws DeploymentException Raised if application deployment failed.
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     **/
    default void addObjectWithType(com.zeroc.Ice.ObjectPrx obj, String type)
        throws DeploymentException,
               ObjectExistsException
    {
        addObjectWithType(obj, type, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @throws DeploymentException Raised if application deployment failed.
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     **/
    default void addObjectWithType(com.zeroc.Ice.ObjectPrx obj, String type, java.util.Map<String, String> context)
        throws DeploymentException,
               ObjectExistsException
    {
        try
        {
            _iceI_addObjectWithTypeAsync(obj, type, context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(ObjectExistsException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> addObjectWithTypeAsync(com.zeroc.Ice.ObjectPrx obj, String type)
    {
        return _iceI_addObjectWithTypeAsync(obj, type, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> addObjectWithTypeAsync(com.zeroc.Ice.ObjectPrx obj, String type, java.util.Map<String, String> context)
    {
        return _iceI_addObjectWithTypeAsync(obj, type, context, false);
    }

    /**
     * @hidden
     * @param iceP_obj -
     * @param iceP_type -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_addObjectWithTypeAsync(com.zeroc.Ice.ObjectPrx iceP_obj, String iceP_type, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "addObjectWithType", null, sync, _iceE_addObjectWithType);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeProxy(iceP_obj);
                     ostr.writeString(iceP_type);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_addObjectWithType =
    {
        DeploymentException.class,
        ObjectExistsException.class
    };

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @throws DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     **/
    default void removeObject(com.zeroc.Ice.Identity id)
        throws DeploymentException,
               ObjectNotRegisteredException
    {
        removeObject(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @param context The Context map to send with the invocation.
     * @throws DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     **/
    default void removeObject(com.zeroc.Ice.Identity id, java.util.Map<String, String> context)
        throws DeploymentException,
               ObjectNotRegisteredException
    {
        try
        {
            _iceI_removeObjectAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(ObjectNotRegisteredException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> removeObjectAsync(com.zeroc.Ice.Identity id)
    {
        return _iceI_removeObjectAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> removeObjectAsync(com.zeroc.Ice.Identity id, java.util.Map<String, String> context)
    {
        return _iceI_removeObjectAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_removeObjectAsync(com.zeroc.Ice.Identity iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "removeObject", null, sync, _iceE_removeObject);
        f.invoke(true, context, null, ostr -> {
                     com.zeroc.Ice.Identity.ice_write(ostr, iceP_id);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_removeObject =
    {
        DeploymentException.class,
        ObjectNotRegisteredException.class
    };

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @return The object info.
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     **/
    default ObjectInfo getObjectInfo(com.zeroc.Ice.Identity id)
        throws ObjectNotRegisteredException
    {
        return getObjectInfo(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @param context The Context map to send with the invocation.
     * @return The object info.
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     **/
    default ObjectInfo getObjectInfo(com.zeroc.Ice.Identity id, java.util.Map<String, String> context)
        throws ObjectNotRegisteredException
    {
        try
        {
            return _iceI_getObjectInfoAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch(ObjectNotRegisteredException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @return The object info.
     **/
    default java.util.concurrent.CompletableFuture<ObjectInfo> getObjectInfoAsync(com.zeroc.Ice.Identity id)
    {
        return _iceI_getObjectInfoAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @param context The Context map to send with the invocation.
     * @return The object info.
     **/
    default java.util.concurrent.CompletableFuture<ObjectInfo> getObjectInfoAsync(com.zeroc.Ice.Identity id, java.util.Map<String, String> context)
    {
        return _iceI_getObjectInfoAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<ObjectInfo> _iceI_getObjectInfoAsync(com.zeroc.Ice.Identity iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<ObjectInfo> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getObjectInfo", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_getObjectInfo);
        f.invoke(true, context, null, ostr -> {
                     com.zeroc.Ice.Identity.ice_write(ostr, iceP_id);
                 }, istr -> {
                     ObjectInfo ret;
                     ret = ObjectInfo.ice_read(istr);
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getObjectInfo =
    {
        ObjectNotRegisteredException.class
    };

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @return The object infos.
     **/
    default ObjectInfo[] getObjectInfosByType(String type)
    {
        return getObjectInfosByType(type, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @return The object infos.
     **/
    default ObjectInfo[] getObjectInfosByType(String type, java.util.Map<String, String> context)
    {
        return _iceI_getObjectInfosByTypeAsync(type, context, true).waitForResponse();
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @return The object infos.
     **/
    default java.util.concurrent.CompletableFuture<ObjectInfo[]> getObjectInfosByTypeAsync(String type)
    {
        return _iceI_getObjectInfosByTypeAsync(type, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @return The object infos.
     **/
    default java.util.concurrent.CompletableFuture<ObjectInfo[]> getObjectInfosByTypeAsync(String type, java.util.Map<String, String> context)
    {
        return _iceI_getObjectInfosByTypeAsync(type, context, false);
    }

    /**
     * @hidden
     * @param iceP_type -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<ObjectInfo[]> _iceI_getObjectInfosByTypeAsync(String iceP_type, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<ObjectInfo[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getObjectInfosByType", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_type);
                 }, istr -> {
                     ObjectInfo[] ret;
                     ret = ObjectInfoSeqHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     **/
    default ObjectInfo[] getAllObjectInfos(String expr)
    {
        return getAllObjectInfos(expr, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @param context The Context map to send with the invocation.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     **/
    default ObjectInfo[] getAllObjectInfos(String expr, java.util.Map<String, String> context)
    {
        return _iceI_getAllObjectInfosAsync(expr, context, true).waitForResponse();
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     **/
    default java.util.concurrent.CompletableFuture<ObjectInfo[]> getAllObjectInfosAsync(String expr)
    {
        return _iceI_getAllObjectInfosAsync(expr, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @param context The Context map to send with the invocation.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     **/
    default java.util.concurrent.CompletableFuture<ObjectInfo[]> getAllObjectInfosAsync(String expr, java.util.Map<String, String> context)
    {
        return _iceI_getAllObjectInfosAsync(expr, context, false);
    }

    /**
     * @hidden
     * @param iceP_expr -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<ObjectInfo[]> _iceI_getAllObjectInfosAsync(String iceP_expr, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<ObjectInfo[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getAllObjectInfos", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_expr);
                 }, istr -> {
                     ObjectInfo[] ret;
                     ret = ObjectInfoSeqHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @return true if the node ping succeeded, false otherwise.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     **/
    default boolean pingNode(String name)
        throws NodeNotExistException
    {
        return pingNode(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return true if the node ping succeeded, false otherwise.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     **/
    default boolean pingNode(String name, java.util.Map<String, String> context)
        throws NodeNotExistException
    {
        try
        {
            return _iceI_pingNodeAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(NodeNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @return true if the node ping succeeded, false otherwise.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Boolean> pingNodeAsync(String name)
    {
        return _iceI_pingNodeAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return true if the node ping succeeded, false otherwise.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Boolean> pingNodeAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_pingNodeAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.Boolean> _iceI_pingNodeAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.Boolean> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "pingNode", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_pingNode);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                 }, istr -> {
                     boolean ret;
                     ret = istr.readBool();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_pingNode =
    {
        NodeNotExistException.class
    };

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @return The node load information.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    default LoadInfo getNodeLoad(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeLoad(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The node load information.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    default LoadInfo getNodeLoad(String name, java.util.Map<String, String> context)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        try
        {
            return _iceI_getNodeLoadAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(NodeNotExistException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @return The node load information.
     **/
    default java.util.concurrent.CompletableFuture<LoadInfo> getNodeLoadAsync(String name)
    {
        return _iceI_getNodeLoadAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The node load information.
     **/
    default java.util.concurrent.CompletableFuture<LoadInfo> getNodeLoadAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_getNodeLoadAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<LoadInfo> _iceI_getNodeLoadAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<LoadInfo> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getNodeLoad", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_getNodeLoad);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                 }, istr -> {
                     LoadInfo ret;
                     ret = LoadInfo.ice_read(istr);
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getNodeLoad =
    {
        NodeNotExistException.class,
        NodeUnreachableException.class
    };

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @return The node information.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    default NodeInfo getNodeInfo(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeInfo(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The node information.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    default NodeInfo getNodeInfo(String name, java.util.Map<String, String> context)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        try
        {
            return _iceI_getNodeInfoAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(NodeNotExistException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @return The node information.
     **/
    default java.util.concurrent.CompletableFuture<NodeInfo> getNodeInfoAsync(String name)
    {
        return _iceI_getNodeInfoAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The node information.
     **/
    default java.util.concurrent.CompletableFuture<NodeInfo> getNodeInfoAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_getNodeInfoAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<NodeInfo> _iceI_getNodeInfoAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<NodeInfo> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getNodeInfo", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_getNodeInfo);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                 }, istr -> {
                     NodeInfo ret;
                     ret = NodeInfo.ice_read(istr);
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getNodeInfo =
    {
        NodeNotExistException.class,
        NodeUnreachableException.class
    };

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @return A proxy to the IceGrid node's admin object
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    default com.zeroc.Ice.ObjectPrx getNodeAdmin(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeAdmin(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @param context The Context map to send with the invocation.
     * @return A proxy to the IceGrid node's admin object
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    default com.zeroc.Ice.ObjectPrx getNodeAdmin(String name, java.util.Map<String, String> context)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        try
        {
            return _iceI_getNodeAdminAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(NodeNotExistException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @return A proxy to the IceGrid node's admin object
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> getNodeAdminAsync(String name)
    {
        return _iceI_getNodeAdminAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @param context The Context map to send with the invocation.
     * @return A proxy to the IceGrid node's admin object
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> getNodeAdminAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_getNodeAdminAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> _iceI_getNodeAdminAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getNodeAdmin", com.zeroc.Ice.OperationMode.Idempotent, sync, _iceE_getNodeAdmin);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                 }, istr -> {
                     com.zeroc.Ice.ObjectPrx ret;
                     ret = istr.readProxy();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getNodeAdmin =
    {
        NodeNotExistException.class,
        NodeUnreachableException.class
    };

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    default int getNodeProcessorSocketCount(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeProcessorSocketCount(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    default int getNodeProcessorSocketCount(String name, java.util.Map<String, String> context)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        try
        {
            return _iceI_getNodeProcessorSocketCountAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(NodeNotExistException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Integer> getNodeProcessorSocketCountAsync(String name)
    {
        return _iceI_getNodeProcessorSocketCountAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Integer> getNodeProcessorSocketCountAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_getNodeProcessorSocketCountAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.Integer> _iceI_getNodeProcessorSocketCountAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.Integer> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getNodeProcessorSocketCount", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_getNodeProcessorSocketCount);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                 }, istr -> {
                     int ret;
                     ret = istr.readInt();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getNodeProcessorSocketCount =
    {
        NodeNotExistException.class,
        NodeUnreachableException.class
    };

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    default void shutdownNode(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        shutdownNode(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    default void shutdownNode(String name, java.util.Map<String, String> context)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        try
        {
            _iceI_shutdownNodeAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(NodeNotExistException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> shutdownNodeAsync(String name)
    {
        return _iceI_shutdownNodeAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> shutdownNodeAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_shutdownNodeAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_shutdownNodeAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "shutdownNode", null, sync, _iceE_shutdownNode);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_shutdownNode =
    {
        NodeNotExistException.class,
        NodeUnreachableException.class
    };

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @return The node hostname.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    default String getNodeHostname(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeHostname(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The node hostname.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    default String getNodeHostname(String name, java.util.Map<String, String> context)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        try
        {
            return _iceI_getNodeHostnameAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(NodeNotExistException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @return The node hostname.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.String> getNodeHostnameAsync(String name)
    {
        return _iceI_getNodeHostnameAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The node hostname.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.String> getNodeHostnameAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_getNodeHostnameAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.String> _iceI_getNodeHostnameAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.String> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getNodeHostname", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_getNodeHostname);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                 }, istr -> {
                     String ret;
                     ret = istr.readString();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getNodeHostname =
    {
        NodeNotExistException.class,
        NodeUnreachableException.class
    };

    /**
     * Get all the IceGrid nodes currently registered.
     * @return The node names.
     **/
    default String[] getAllNodeNames()
    {
        return getAllNodeNames(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * @param context The Context map to send with the invocation.
     * @return The node names.
     **/
    default String[] getAllNodeNames(java.util.Map<String, String> context)
    {
        return _iceI_getAllNodeNamesAsync(context, true).waitForResponse();
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * @return The node names.
     **/
    default java.util.concurrent.CompletableFuture<String[]> getAllNodeNamesAsync()
    {
        return _iceI_getAllNodeNamesAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * @param context The Context map to send with the invocation.
     * @return The node names.
     **/
    default java.util.concurrent.CompletableFuture<String[]> getAllNodeNamesAsync(java.util.Map<String, String> context)
    {
        return _iceI_getAllNodeNamesAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<String[]> _iceI_getAllNodeNamesAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<String[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getAllNodeNames", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     String[] ret;
                     ret = istr.readStringSeq();
                     return ret;
                 });
        return f;
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @return true if the registry ping succeeded, false otherwise.
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     **/
    default boolean pingRegistry(String name)
        throws RegistryNotExistException
    {
        return pingRegistry(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @return true if the registry ping succeeded, false otherwise.
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     **/
    default boolean pingRegistry(String name, java.util.Map<String, String> context)
        throws RegistryNotExistException
    {
        try
        {
            return _iceI_pingRegistryAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(RegistryNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @return true if the registry ping succeeded, false otherwise.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Boolean> pingRegistryAsync(String name)
    {
        return _iceI_pingRegistryAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @return true if the registry ping succeeded, false otherwise.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Boolean> pingRegistryAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_pingRegistryAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.Boolean> _iceI_pingRegistryAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.Boolean> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "pingRegistry", com.zeroc.Ice.OperationMode.Idempotent, sync, _iceE_pingRegistry);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                 }, istr -> {
                     boolean ret;
                     ret = istr.readBool();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_pingRegistry =
    {
        RegistryNotExistException.class
    };

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @return The registry information.
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     **/
    default RegistryInfo getRegistryInfo(String name)
        throws RegistryNotExistException,
               RegistryUnreachableException
    {
        return getRegistryInfo(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @return The registry information.
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     **/
    default RegistryInfo getRegistryInfo(String name, java.util.Map<String, String> context)
        throws RegistryNotExistException,
               RegistryUnreachableException
    {
        try
        {
            return _iceI_getRegistryInfoAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(RegistryNotExistException ex)
        {
            throw ex;
        }
        catch(RegistryUnreachableException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @return The registry information.
     **/
    default java.util.concurrent.CompletableFuture<RegistryInfo> getRegistryInfoAsync(String name)
    {
        return _iceI_getRegistryInfoAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @return The registry information.
     **/
    default java.util.concurrent.CompletableFuture<RegistryInfo> getRegistryInfoAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_getRegistryInfoAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<RegistryInfo> _iceI_getRegistryInfoAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<RegistryInfo> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getRegistryInfo", com.zeroc.Ice.OperationMode.Idempotent, sync, _iceE_getRegistryInfo);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                 }, istr -> {
                     RegistryInfo ret;
                     ret = RegistryInfo.ice_read(istr);
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getRegistryInfo =
    {
        RegistryNotExistException.class,
        RegistryUnreachableException.class
    };

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @return A proxy to the IceGrid registry's admin object
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     **/
    default com.zeroc.Ice.ObjectPrx getRegistryAdmin(String name)
        throws RegistryNotExistException
    {
        return getRegistryAdmin(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @param context The Context map to send with the invocation.
     * @return A proxy to the IceGrid registry's admin object
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     **/
    default com.zeroc.Ice.ObjectPrx getRegistryAdmin(String name, java.util.Map<String, String> context)
        throws RegistryNotExistException
    {
        try
        {
            return _iceI_getRegistryAdminAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(RegistryNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @return A proxy to the IceGrid registry's admin object
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> getRegistryAdminAsync(String name)
    {
        return _iceI_getRegistryAdminAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @param context The Context map to send with the invocation.
     * @return A proxy to the IceGrid registry's admin object
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> getRegistryAdminAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_getRegistryAdminAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> _iceI_getRegistryAdminAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getRegistryAdmin", com.zeroc.Ice.OperationMode.Idempotent, sync, _iceE_getRegistryAdmin);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                 }, istr -> {
                     com.zeroc.Ice.ObjectPrx ret;
                     ret = istr.readProxy();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_getRegistryAdmin =
    {
        RegistryNotExistException.class
    };

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     **/
    default void shutdownRegistry(String name)
        throws RegistryNotExistException,
               RegistryUnreachableException
    {
        shutdownRegistry(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     **/
    default void shutdownRegistry(String name, java.util.Map<String, String> context)
        throws RegistryNotExistException,
               RegistryUnreachableException
    {
        try
        {
            _iceI_shutdownRegistryAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(RegistryNotExistException ex)
        {
            throw ex;
        }
        catch(RegistryUnreachableException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> shutdownRegistryAsync(String name)
    {
        return _iceI_shutdownRegistryAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> shutdownRegistryAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_shutdownRegistryAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_shutdownRegistryAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "shutdownRegistry", com.zeroc.Ice.OperationMode.Idempotent, sync, _iceE_shutdownRegistry);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_shutdownRegistry =
    {
        RegistryNotExistException.class,
        RegistryUnreachableException.class
    };

    /**
     * Get all the IceGrid registries currently registered.
     * @return The registry names.
     **/
    default String[] getAllRegistryNames()
    {
        return getAllRegistryNames(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get all the IceGrid registries currently registered.
     * @param context The Context map to send with the invocation.
     * @return The registry names.
     **/
    default String[] getAllRegistryNames(java.util.Map<String, String> context)
    {
        return _iceI_getAllRegistryNamesAsync(context, true).waitForResponse();
    }

    /**
     * Get all the IceGrid registries currently registered.
     * @return The registry names.
     **/
    default java.util.concurrent.CompletableFuture<String[]> getAllRegistryNamesAsync()
    {
        return _iceI_getAllRegistryNamesAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get all the IceGrid registries currently registered.
     * @param context The Context map to send with the invocation.
     * @return The registry names.
     **/
    default java.util.concurrent.CompletableFuture<String[]> getAllRegistryNamesAsync(java.util.Map<String, String> context)
    {
        return _iceI_getAllRegistryNamesAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<String[]> _iceI_getAllRegistryNamesAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<String[]> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getAllRegistryNames", com.zeroc.Ice.OperationMode.Idempotent, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     String[] ret;
                     ret = istr.readStringSeq();
                     return ret;
                 });
        return f;
    }

    /**
     * Shut down the IceGrid registry.
     **/
    default void shutdown()
    {
        shutdown(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Shut down the IceGrid registry.
     * @param context The Context map to send with the invocation.
     **/
    default void shutdown(java.util.Map<String, String> context)
    {
        _iceI_shutdownAsync(context, true).waitForResponse();
    }

    /**
     * Shut down the IceGrid registry.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> shutdownAsync()
    {
        return _iceI_shutdownAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Shut down the IceGrid registry.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> shutdownAsync(java.util.Map<String, String> context)
    {
        return _iceI_shutdownAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_shutdownAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "shutdown", null, sync, null);
        f.invoke(false, context, null, null, null);
        return f;
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @return A dictionary mapping Slice type ids to their checksums.
     **/
    default java.util.Map<java.lang.String, java.lang.String> getSliceChecksums()
    {
        return getSliceChecksums(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     **/
    default java.util.Map<java.lang.String, java.lang.String> getSliceChecksums(java.util.Map<String, String> context)
    {
        return _iceI_getSliceChecksumsAsync(context, true).waitForResponse();
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @return A dictionary mapping Slice type ids to their checksums.
     **/
    default java.util.concurrent.CompletableFuture<java.util.Map<java.lang.String, java.lang.String>> getSliceChecksumsAsync()
    {
        return _iceI_getSliceChecksumsAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     **/
    default java.util.concurrent.CompletableFuture<java.util.Map<java.lang.String, java.lang.String>> getSliceChecksumsAsync(java.util.Map<String, String> context)
    {
        return _iceI_getSliceChecksumsAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.util.Map<java.lang.String, java.lang.String>> _iceI_getSliceChecksumsAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.util.Map<java.lang.String, java.lang.String>> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getSliceChecksums", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     java.util.Map<java.lang.String, java.lang.String> ret;
                     ret = com.zeroc.Ice.SliceChecksumDictHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static AdminPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), AdminPrx.class, _AdminPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static AdminPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), AdminPrx.class, _AdminPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static AdminPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), AdminPrx.class, _AdminPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static AdminPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), AdminPrx.class, _AdminPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static AdminPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, AdminPrx.class, _AdminPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static AdminPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, AdminPrx.class, _AdminPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default AdminPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (AdminPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default AdminPrx ice_adapterId(String newAdapterId)
    {
        return (AdminPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default AdminPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (AdminPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default AdminPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (AdminPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default AdminPrx ice_invocationTimeout(int newTimeout)
    {
        return (AdminPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default AdminPrx ice_connectionCached(boolean newCache)
    {
        return (AdminPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default AdminPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (AdminPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default AdminPrx ice_secure(boolean b)
    {
        return (AdminPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default AdminPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (AdminPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default AdminPrx ice_preferSecure(boolean b)
    {
        return (AdminPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default AdminPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (AdminPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default AdminPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (AdminPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default AdminPrx ice_collocationOptimized(boolean b)
    {
        return (AdminPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default AdminPrx ice_twoway()
    {
        return (AdminPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default AdminPrx ice_oneway()
    {
        return (AdminPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default AdminPrx ice_batchOneway()
    {
        return (AdminPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default AdminPrx ice_datagram()
    {
        return (AdminPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default AdminPrx ice_batchDatagram()
    {
        return (AdminPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default AdminPrx ice_compress(boolean co)
    {
        return (AdminPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default AdminPrx ice_timeout(int t)
    {
        return (AdminPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default AdminPrx ice_connectionId(String connectionId)
    {
        return (AdminPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default AdminPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (AdminPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::IceGrid::Admin";
    }
}
