/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import sbt.internal.ClassLoadingLock;
import sbt.internal.ManagedClassLoader;
import sbt.internal.ReverseLookupClassLoader;
import sbt.internal.ReverseLookupClassLoaderHolder;
import sbt.util.Logger;

final class BottomClassLoader
extends ManagedClassLoader {
    private final ReverseLookupClassLoaderHolder holder;
    private final ReverseLookupClassLoader parent;
    private final ClassLoadingLock classLoadingLock = new ClassLoadingLock();

    BottomClassLoader(ReverseLookupClassLoaderHolder reverseLookupClassLoaderHolder, URL[] uRLArray, ReverseLookupClassLoader reverseLookupClassLoader, File file, boolean bl, Logger logger) {
        super(uRLArray, reverseLookupClassLoader, bl, logger);
        this.setTempDir(file);
        this.holder = reverseLookupClassLoaderHolder;
        this.parent = reverseLookupClassLoader;
        this.parent.setDescendant(this);
    }

    @Override
    public Class<?> findClass(String string) throws ClassNotFoundException {
        return this.classLoadingLock.withLock(string, () -> {
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz != null) {
                return clazz;
            }
            return super.findClass(string);
        });
    }

    @Override
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        try {
            return this.parent.loadClass(string, bl, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> clazz = this.findClass(string);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    @Override
    public void close() throws IOException {
        this.holder.checkin(this.parent);
        super.close();
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

