# _ProcessPosix
<span class="source-link">[[Source]](src/process/_process.md#L45)</span>
```pony
class ref _ProcessPosix is
  _Process ref
```

#### Implements

* [_Process](process-_Process.md) ref

---

## Constructors

### create
<span class="source-link">[[Source]](src/process/_process.md#L48)</span>


```pony
new ref create(
  path: String val,
  args: Array[String val] val,
  vars: Array[String val] val,
  stdin: _Pipe ref,
  stdout: _Pipe ref,
  stderr: _Pipe ref)
: _ProcessPosix ref^ ?
```
#### Parameters

*   path: [String](builtin-String.md) val
*   args: [Array](builtin-Array.md)\[[String](builtin-String.md) val\] val
*   vars: [Array](builtin-Array.md)\[[String](builtin-String.md) val\] val
*   stdin: [_Pipe](process-_Pipe.md) ref
*   stdout: [_Pipe](process-_Pipe.md) ref
*   stderr: [_Pipe](process-_Pipe.md) ref

#### Returns

* [_ProcessPosix](process-_ProcessPosix.md) ref^ ?

---

## Public fields

### let pid: [I32](builtin-I32.md) val
<span class="source-link">[[Source]](src/process/_process.md#L46)</span>



---

## Public Functions

### kill
<span class="source-link">[[Source]](src/process/_process.md#L117)</span>


Terminate the process, first trying SIGTERM and if that fails, try SIGKILL.


```pony
fun box kill()
: None val
```

#### Returns

* [None](builtin-None.md) val

---

### wait
<span class="source-link">[[Source]](src/process/_process.md#L135)</span>


```pony
fun ref wait()
: I32 val
```

#### Returns

* [I32](builtin-I32.md) val

---

## Private Functions

### _make_argv
<span class="source-link">[[Source]](src/process/_process.md#L67)</span>


Convert an array of String parameters into an array of
C pointers to same strings.


```pony
fun tag _make_argv(
  args: Array[String val] box)
: Array[Pointer[U8 val] tag] ref
```
#### Parameters

*   args: [Array](builtin-Array.md)\[[String](builtin-String.md) val\] box

#### Returns

* [Array](builtin-Array.md)\[[Pointer](builtin-Pointer.md)\[[U8](builtin-U8.md) val\] tag\] ref

---

### _child_fork
<span class="source-link">[[Source]](src/process/_process.md#L79)</span>


We are now in the child process. We redirect STDIN, STDOUT and STDERR
to their pipes and execute the command. The command is executed via
execve which does not return on success, and the text, data, bss, and
stack of the calling process are overwritten by that of the program
loaded. We've set the FD_CLOEXEC flag on all file descriptors to ensure
that they are all closed automatically once @execve gets called.


```pony
fun box _child_fork(
  path: String val,
  argp: Array[Pointer[U8 val] tag] ref,
  envp: Array[Pointer[U8 val] tag] ref,
  stdin: _Pipe ref,
  stdout: _Pipe ref,
  stderr: _Pipe ref)
: None val
```
#### Parameters

*   path: [String](builtin-String.md) val
*   argp: [Array](builtin-Array.md)\[[Pointer](builtin-Pointer.md)\[[U8](builtin-U8.md) val\] tag\] ref
*   envp: [Array](builtin-Array.md)\[[Pointer](builtin-Pointer.md)\[[U8](builtin-U8.md) val\] tag\] ref
*   stdin: [_Pipe](process-_Pipe.md) ref
*   stdout: [_Pipe](process-_Pipe.md) ref
*   stderr: [_Pipe](process-_Pipe.md) ref

#### Returns

* [None](builtin-None.md) val

---

### _dup2
<span class="source-link">[[Source]](src/process/_process.md#L102)</span>


Creates a copy of the file descriptor oldfd using the file
descriptor number specified in newfd. If the file descriptor newfd
was previously open, it is silently closed before being reused.
If dup2() fails because of EINTR we retry.


```pony
fun tag _dup2(
  oldfd: U32 val,
  newfd: U32 val)
: None val
```
#### Parameters

*   oldfd: [U32](builtin-U32.md) val
*   newfd: [U32](builtin-U32.md) val

#### Returns

* [None](builtin-None.md) val

---

