/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project3.ComplementColors;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.TaskDraw;
import net.sourceforge.plantuml.project3.TaskImpl;
import net.sourceforge.plantuml.project3.TimeScale;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TaskDrawRegular
implements TaskDraw {
    private static final HtmlColor defaultColor = new HtmlColorSetSimple().getColorIfValid("GreenYellow");
    private final TaskImpl task;
    private final TimeScale timeScale;
    private final double y;
    private ComplementColors colors;
    private final double margin = 2.0;

    public TaskDrawRegular(TaskImpl task, TimeScale timeScale, double y) {
        this.y = y;
        this.task = task;
        this.timeScale = timeScale;
    }

    @Override
    public void drawTitle(UGraphic ug) {
        TextBlock title = Display.getWithNewlines(this.task.getPrettyDisplay()).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        double shapeHeight = this.getShapeHeight(100);
        double titleHeight = title.calculateDimension(ug.getStringBounder()).getHeight();
        double h = (2.0 + shapeHeight - titleHeight) / 2.0;
        title.drawU(ug.apply(new UTranslate(this.timeScale.getEndingPosition(this.task.getStart()), h)));
    }

    private FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HtmlColorUtils.BLACK, HtmlColorUtils.BLACK, false);
    }

    @Override
    public void drawU(UGraphic ug1) {
        double start = this.timeScale.getStartingPosition(this.task.getStart());
        ug1 = this.applyColors(ug1);
        UGraphic ug2 = ug1.apply(new UTranslate(start + 2.0, 2.0));
        UShape shapeFull = this.getShape(100);
        if (shapeFull instanceof UPolygon) {
            ug2.draw(shapeFull);
        } else {
            ug2.draw(shapeFull);
        }
    }

    private UGraphic applyColors(UGraphic ug) {
        if (this.colors != null && this.colors.isOk()) {
            return this.colors.apply(ug);
        }
        if (this.isDiamond()) {
            return ug.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UChangeBackColor(HtmlColorUtils.BLACK));
        }
        return ug.apply(new UChangeColor(HtmlColorUtils.BLUE)).apply(new UChangeBackColor(defaultColor));
    }

    private UShape getShape(int load) {
        if (this.isDiamond()) {
            return this.getDiamond();
        }
        Instant instantStart = this.task.getStart();
        Instant instantEnd = this.task.getEnd();
        double start = this.timeScale.getStartingPosition(instantStart);
        double end = this.timeScale.getEndingPosition(instantEnd);
        return new URectangle(end - start - 4.0, this.getShapeHeight(load), 8.0, 8.0);
    }

    private double getShapeHeight(int load) {
        return (this.getHeight() - 4.0) * (double)load / 100.0;
    }

    private boolean isDiamond() {
        if (this.task.isDiamond()) {
            Instant instantEnd;
            Instant instantStart = this.task.getStart();
            return instantStart.compareTo(instantEnd = this.task.getEnd()) == 0;
        }
        return false;
    }

    private UShape getDiamond() {
        double h = this.getHeight() - 4.0;
        UPolygon result = new UPolygon();
        result.addPoint(h / 2.0, 0.0);
        result.addPoint(h, h / 2.0);
        result.addPoint(h / 2.0, h);
        result.addPoint(0.0, h / 2.0);
        return result;
    }

    @Override
    public double getHeight() {
        return 16.0;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getY(Direction direction) {
        if (direction == Direction.UP) {
            return this.y;
        }
        if (direction == Direction.DOWN) {
            return this.y + this.getHeight();
        }
        return this.y + this.getHeight() / 2.0;
    }

    @Override
    public void setColors(ComplementColors colors) {
        this.colors = colors;
    }
}

