/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter.image;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.common.collection.NullSafeSet;
import org.sejda.model.image.ImageColorType;
import org.sejda.model.image.ImageType;
import org.sejda.model.parameter.base.MultiplePdfSourceMultipleOutputParameters;
import org.sejda.model.parameter.image.PdfToImageParameters;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.pdf.page.PageRangeSelection;
import org.sejda.model.pdf.page.PagesSelection;
import org.sejda.model.pdf.page.PredefinedSetOfPages;

public abstract class AbstractPdfToMultipleImageParameters
extends MultiplePdfSourceMultipleOutputParameters
implements PageRangeSelection,
PagesSelection,
PdfToImageParameters {
    public static final int DEFAULT_DPI = 72;
    @Min(value=1L)
    private int resolutionInDpi = 72;
    @NotNull
    private ImageColorType outputImageColorType;
    @Valid
    private final Set<PageRange> pageSelection = new NullSafeSet<PageRange>();

    AbstractPdfToMultipleImageParameters(ImageColorType outputImageColorType) {
        this.outputImageColorType = outputImageColorType;
    }

    @Override
    public ImageColorType getOutputImageColorType() {
        return this.outputImageColorType;
    }

    @Override
    public void setOutputImageColorType(ImageColorType outputImageColorType) {
        this.outputImageColorType = outputImageColorType;
    }

    @NotNull
    public abstract ImageType getOutputImageType();

    @Override
    public int getResolutionInDpi() {
        return this.resolutionInDpi;
    }

    @Override
    public void setResolutionInDpi(int resolutionInDpi) {
        this.resolutionInDpi = resolutionInDpi;
    }

    public void addPageRange(PageRange range) {
        this.pageSelection.add(range);
    }

    public void addAllPageRanges(Collection<PageRange> ranges) {
        this.pageSelection.addAll(ranges);
    }

    @Override
    public Set<PageRange> getPageSelection() {
        return Collections.unmodifiableSet(this.pageSelection);
    }

    @Override
    public Set<Integer> getPages(int upperLimit) {
        if (this.pageSelection.isEmpty()) {
            return PredefinedSetOfPages.ALL_PAGES.getPages(upperLimit);
        }
        NullSafeSet<Integer> retSet = new NullSafeSet<Integer>();
        for (PageRange range : this.getPageSelection()) {
            retSet.addAll(range.getPages(upperLimit));
        }
        return retSet;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPdfToMultipleImageParameters that = (AbstractPdfToMultipleImageParameters)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.resolutionInDpi, that.resolutionInDpi).append((Object)this.outputImageColorType, (Object)that.outputImageColorType).append(this.pageSelection, that.pageSelection).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.resolutionInDpi).append((Object)this.outputImageColorType).append(this.pageSelection).toHashCode();
    }
}

