"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createApi = createApi;

var _search = require("../../common/search");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function createApi({
  caller,
  searchStrategies
}) {
  const api = {
    search: async (request, strategyName) => {
      const name = strategyName ? strategyName : _search.DEFAULT_SEARCH_STRATEGY;
      const strategyProvider = searchStrategies[name];

      if (!strategyProvider) {
        throw new Error(`No strategy found for ${strategyName}`);
      } // Give providers access to other search strategies by injecting this function


      const strategy = await strategyProvider(caller, api.search);
      return strategy.search(request);
    }
  };
  return api;
}