"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.docMissingSuite = docMissingSuite;

var _expect = _interopRequireDefault(require("@kbn/expect"));

var _sinon = _interopRequireDefault(require("sinon"));

var _lib = require("./lib");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function docMissingSuite() {
  // ensure the kibana index has no documents
  beforeEach(async () => {
    const {
      kbnServer,
      callCluster
    } = (0, _lib.getServices)(); // write a setting to ensure kibana index is created

    await kbnServer.inject({
      method: 'POST',
      url: '/api/kibana/settings/defaultIndex',
      payload: {
        value: 'abc'
      }
    }); // delete all docs from kibana index to ensure savedConfig is not found

    await callCluster('deleteByQuery', {
      index: kbnServer.config.get('kibana.index'),
      body: {
        query: {
          match_all: {}
        }
      }
    });
  });
  describe('get route', () => {
    it('creates doc, returns a 200 with settings', async () => {
      const {
        kbnServer
      } = (0, _lib.getServices)();
      const {
        statusCode,
        result
      } = await kbnServer.inject({
        method: 'GET',
        url: '/api/kibana/settings'
      });
      (0, _expect.default)(statusCode).to.be(200);
      (0, _lib.assertSinonMatch)(result, {
        settings: {
          buildNum: {
            userValue: _sinon.default.match.number
          },
          foo: {
            userValue: 'bar',
            isOverridden: true
          }
        }
      });
    });
  });
  describe('set route', () => {
    it('creates doc, returns a 200 with value set', async () => {
      const {
        kbnServer
      } = (0, _lib.getServices)();

      const defaultIndex = _lib.chance.word();

      const {
        statusCode,
        result
      } = await kbnServer.inject({
        method: 'POST',
        url: '/api/kibana/settings/defaultIndex',
        payload: {
          value: defaultIndex
        }
      });
      (0, _expect.default)(statusCode).to.be(200);
      (0, _lib.assertSinonMatch)(result, {
        settings: {
          buildNum: {
            userValue: _sinon.default.match.number
          },
          defaultIndex: {
            userValue: defaultIndex
          },
          foo: {
            userValue: 'bar',
            isOverridden: true
          }
        }
      });
    });
  });
  describe('setMany route', () => {
    it('creates doc, returns 200 with updated values', async () => {
      const {
        kbnServer
      } = (0, _lib.getServices)();

      const defaultIndex = _lib.chance.word();

      const {
        statusCode,
        result
      } = await kbnServer.inject({
        method: 'POST',
        url: '/api/kibana/settings',
        payload: {
          changes: {
            defaultIndex
          }
        }
      });
      (0, _expect.default)(statusCode).to.be(200);
      (0, _lib.assertSinonMatch)(result, {
        settings: {
          buildNum: {
            userValue: _sinon.default.match.number
          },
          defaultIndex: {
            userValue: defaultIndex
          },
          foo: {
            userValue: 'bar',
            isOverridden: true
          }
        }
      });
    });
  });
  describe('delete route', () => {
    it('creates doc, returns a 200 with just buildNum', async () => {
      const {
        kbnServer
      } = (0, _lib.getServices)();
      const {
        statusCode,
        result
      } = await kbnServer.inject({
        method: 'DELETE',
        url: '/api/kibana/settings/defaultIndex'
      });
      (0, _expect.default)(statusCode).to.be(200);
      (0, _lib.assertSinonMatch)(result, {
        settings: {
          buildNum: {
            userValue: _sinon.default.match.number
          },
          foo: {
            userValue: 'bar',
            isOverridden: true
          }
        }
      });
    });
  });
}