"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricAggParamEditor = MetricAggParamEditor;

var _react = _interopRequireWildcard(require("react"));

var _eui = require("@elastic/eui");

var _i18n = require("@kbn/i18n");

var _agg_utils = require("../../../../agg_types/agg_utils");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var aggFilter = ['!top_hits', '!percentiles', '!percentile_ranks', '!median', '!std_dev'];
var isCompatibleAgg = (0, _agg_utils.isCompatibleAggregation)(aggFilter);
var EMPTY_VALUE = 'EMPTY_VALUE';

function MetricAggParamEditor(_ref) {
  var agg = _ref.agg,
      value = _ref.value,
      showValidation = _ref.showValidation,
      setValue = _ref.setValue,
      setValidity = _ref.setValidity,
      setTouched = _ref.setTouched,
      metricAggs = _ref.metricAggs;

  var label = _i18n.i18n.translate('common.ui.aggTypes.metricLabel', {
    defaultMessage: 'Metric'
  });

  var isValid = !!value;
  (0, _react.useEffect)(function () {
    setValidity(isValid);
  }, [isValid]);
  (0, _react.useEffect)(function () {
    if (metricAggs && value && value !== 'custom') {
      // ensure that metricAgg is set to a valid agg
      var respAgg = metricAggs.filter(isCompatibleAgg).find(function (aggregation) {
        return aggregation.id === value;
      });

      if (!respAgg) {
        setValue();
      }
    }
  }, [metricAggs]);
  var options = metricAggs ? metricAggs.filter(function (respAgg) {
    return respAgg.type.name !== agg.type.name;
  }).map(function (respAgg) {
    return {
      text: _i18n.i18n.translate('common.ui.aggTypes.definiteMetricLabel', {
        defaultMessage: 'Metric: {safeMakeLabel}',
        values: {
          safeMakeLabel: (0, _agg_utils.safeMakeLabel)(respAgg)
        }
      }),
      value: respAgg.id,
      disabled: !isCompatibleAgg(respAgg)
    };
  }) : [];
  options.push({
    text: _i18n.i18n.translate('common.ui.aggTypes.customMetricLabel', {
      defaultMessage: 'Custom metric'
    }),
    value: 'custom',
    disabled: false
  });

  if (!value) {
    options.unshift({
      text: '',
      value: EMPTY_VALUE,
      disabled: false
    });
  }

  return _react.default.createElement(_eui.EuiFormRow, {
    label: label,
    fullWidth: true,
    isInvalid: showValidation ? !isValid : false,
    compressed: true
  }, _react.default.createElement(_eui.EuiSelect, {
    options: options,
    value: value || EMPTY_VALUE,
    onChange: function onChange(ev) {
      return setValue(ev.target.value);
    },
    fullWidth: true,
    compressed: true,
    isInvalid: showValidation ? !isValid : false,
    onBlur: setTouched,
    "data-test-subj": "visEditorSubAggMetric".concat(agg.id)
  }));
}