"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAnalyticsReporter = createAnalyticsReporter;
exports.trackUserAgent = exports.createUiStatsReporter = exports.getTelemetryReporter = exports.setTelemetryReporter = void 0;

var _analytics = require("@kbn/analytics");

var _system_api = require("ui/system_api");

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var telemetryReporter;

var setTelemetryReporter = function setTelemetryReporter(aTelemetryReporter) {
  telemetryReporter = aTelemetryReporter;
};

exports.setTelemetryReporter = setTelemetryReporter;

var getTelemetryReporter = function getTelemetryReporter() {
  return telemetryReporter;
};

exports.getTelemetryReporter = getTelemetryReporter;

var createUiStatsReporter = function createUiStatsReporter(appName) {
  return function (type, eventNames, count) {
    if (telemetryReporter) {
      return telemetryReporter.reportUiStats(appName, type, eventNames, count);
    }
  };
};

exports.createUiStatsReporter = createUiStatsReporter;

var trackUserAgent = function trackUserAgent(appName) {
  if (telemetryReporter) {
    return telemetryReporter.reportUserAgent(appName);
  }
};

exports.trackUserAgent = trackUserAgent;

function createAnalyticsReporter(config) {
  var localStorage = config.localStorage,
      debug = config.debug,
      kfetch = config.kfetch;
  return new _analytics.Reporter({
    debug: debug,
    storage: localStorage,
    http: function () {
      var _http = _asyncToGenerator(
      /*#__PURE__*/
      regeneratorRuntime.mark(function _callee(report) {
        var response;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return kfetch({
                  method: 'POST',
                  pathname: '/api/telemetry/report',
                  body: JSON.stringify(report),
                  headers: (0, _system_api.addSystemApiHeader)({})
                });

              case 2:
                response = _context.sent;

                if (!(response.status !== 'ok')) {
                  _context.next = 5;
                  break;
                }

                throw Error('Unable to store report.');

              case 5:
                return _context.abrupt("return", response);

              case 6:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function http(_x) {
        return _http.apply(this, arguments);
      }

      return http;
    }()
  });
}