"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryPlugin = void 0;

var _routes = require("./routes");

var _telemetry_collection = require("./telemetry_collection");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class TelemetryPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "currentKibanaVersion", void 0);

    this.currentKibanaVersion = initializerContext.env.packageInfo.version;
  }

  setup(core) {
    const currentKibanaVersion = this.currentKibanaVersion;
    (0, _telemetry_collection.registerCollection)();
    (0, _routes.registerRoutes)({
      core,
      currentKibanaVersion
    });
  }

}

exports.TelemetryPlugin = TelemetryPlugin;