"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverFieldSearch = DiscoverFieldSearch;

var _react = _interopRequireDefault(require("react"));

var _i18n = require("@kbn/i18n");

var _eui = require("@elastic/eui");

var _react2 = require("@kbn/i18n/react");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Component is Discover's side bar to  search of available fields
 * Additionally there's a button displayed that allows the user to show/hide more filter fields
 */
function DiscoverFieldSearch(_ref) {
  var showFilter = _ref.showFilter,
      _onChange = _ref.onChange,
      onShowFilter = _ref.onShowFilter,
      value = _ref.value,
      filtersActive = _ref.filtersActive;

  if (typeof value !== 'string') {
    // at initial rendering value is undefined (angular related), this catches the warning
    // should be removed once all is react
    return null;
  }

  var filterBtnAriaLabel = showFilter ? _i18n.i18n.translate('kbn.discover.fieldChooser.toggleFieldFilterButtonHideAriaLabel', {
    defaultMessage: 'Hide field filter settings'
  }) : _i18n.i18n.translate('kbn.discover.fieldChooser.toggleFieldFilterButtonShowAriaLabel', {
    defaultMessage: 'Show field filter settings'
  });

  var searchPlaceholder = _i18n.i18n.translate('kbn.discover.fieldChooser.searchPlaceHolder', {
    defaultMessage: 'Search field names'
  });

  return _react.default.createElement(_react.default.Fragment, null, _react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: 's'
  }, _react.default.createElement(_eui.EuiFlexItem, null, _react.default.createElement(_eui.EuiFieldSearch, {
    "aria-label": searchPlaceholder,
    "data-test-subj": "fieldFilterSearchInput",
    compressed: true,
    fullWidth: true,
    onChange: function onChange(event) {
      return _onChange('name', event.currentTarget.value);
    },
    placeholder: searchPlaceholder,
    value: value
  }))), _react.default.createElement(_eui.EuiFacetButton, {
    "aria-label": filterBtnAriaLabel,
    "data-test-subj": "toggleFieldFilterButton",
    className: "dscToggleFieldFilterButton",
    icon: _react.default.createElement(_eui.EuiIcon, {
      type: "filter"
    }),
    isSelected: filtersActive > 0,
    quantity: filtersActive,
    onClick: function onClick() {
      return onShowFilter();
    }
  }, _react.default.createElement(_react2.FormattedMessage, {
    id: "kbn.discover.fieldChooser.fieldFilterFacetButtonLabel",
    defaultMessage: "Filter by type"
  })));
}