"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDateFormat = createDateFormat;

var _lodash = require("lodash");

var _moment = _interopRequireDefault(require("moment"));

var _common = require("../../../../../../plugins/data/common/");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function createDateFormat() {
  var _class, _temp;

  return _temp = _class = class DateFormat extends _common.FieldFormat {
    constructor(params, getConfig) {
      super(params);

      _defineProperty(this, "getConfig", void 0);

      _defineProperty(this, "memoizedConverter", _lodash.noop);

      _defineProperty(this, "memoizedPattern", '');

      _defineProperty(this, "timeZone", '');

      _defineProperty(this, "textConvert", val => {
        // don't give away our ref to converter so
        // we can hot-swap when config changes
        const pattern = this.param('pattern');
        const timezone = this.param('timezone');
        const timezoneChanged = this.timeZone !== timezone;
        const datePatternChanged = this.memoizedPattern !== pattern;

        if (timezoneChanged || datePatternChanged) {
          this.timeZone = timezone;
          this.memoizedPattern = pattern;
          this.memoizedConverter = (0, _lodash.memoize)(function converter(value) {
            if (value === null || value === undefined) {
              return '-';
            }

            const date = (0, _moment.default)(value);

            if (date.isValid()) {
              return date.format(pattern);
            } else {
              return value;
            }
          });
        }

        return this.memoizedConverter(val);
      });

      this.getConfig = getConfig;
    }

    getParamDefaults() {
      return {
        pattern: this.getConfig('dateFormat'),
        timezone: this.getConfig('dateFormat:tz')
      };
    }

  }, _defineProperty(_class, "id", 'date'), _defineProperty(_class, "title", 'Date'), _defineProperty(_class, "fieldType", _common.KBN_FIELD_TYPES.DATE), _temp;
}