"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createColorFormat = createColorFormat;

var _lodash = require("lodash");

var _common = require("../../../../../../plugins/data/common/");

var _color_default = require("./color_default");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const convertTemplate = (0, _lodash.template)('<span style="<%- style %>"><%- val %></span>');

function createColorFormat() {
  class ColorFormat extends _common.FieldFormat {
    constructor(...args) {
      super(...args);

      _defineProperty(this, "htmlConvert", val => {
        const color = this.findColorRuleForVal(val);
        if (!color) return (0, _lodash.escape)((0, _common.asPrettyString)(val));
        let style = '';
        if (color.text) style += `color: ${color.text};`;
        if (color.background) style += `background-color: ${color.background};`;
        return convertTemplate({
          val,
          style
        });
      });
    }

    getParamDefaults() {
      return {
        fieldType: null,
        // populated by editor, see controller below
        colors: [(0, _lodash.cloneDeep)(_color_default.DEFAULT_COLOR)]
      };
    }

    findColorRuleForVal(val) {
      switch (this.param('fieldType')) {
        case 'string':
          return (0, _lodash.findLast)(this.param('colors'), colorParam => {
            return new RegExp(colorParam.regex).test(val);
          });

        case 'number':
          return (0, _lodash.findLast)(this.param('colors'), ({
            range
          }) => {
            if (!range) return;
            const [start, end] = range.split(':');
            return val >= Number(start) && val <= Number(end);
          });

        default:
          return null;
      }
    }

  }

  _defineProperty(ColorFormat, "id", 'color');

  _defineProperty(ColorFormat, "title", 'Color');

  _defineProperty(ColorFormat, "fieldType", [_common.KBN_FIELD_TYPES.NUMBER, _common.KBN_FIELD_TYPES.STRING]);

  return ColorFormat;
}