"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esaggs = void 0;

var _lodash = require("lodash");

var _i18n = require("@kbn/i18n");

var _agg_configs = require("ui/agg_types/agg_configs");

var _utilities = require("ui/visualize/loader/pipeline_helpers/utilities");

var _chrome = _interopRequireDefault(require("ui/chrome"));

var _search_source = require("../../../../ui/public/courier/search_source");

var _query_filter = require("../../../../ui/public/filter_manager/query_filter");

var _build_tabular_inspector_data = require("../../../../ui/public/inspector/build_tabular_inspector_data");

var _courier_inspector_utils = require("../../../../ui/public/courier/utils/courier_inspector_utils");

var _calculate_object_hash = require("../../../../ui/public/vis/lib/calculate_object_hash");

var _timefilter = require("../../../../ui/public/timefilter");

var _tabify = require("../../../../ui/public/agg_response/tabify/tabify");

var _legacy = require("../../../data/public/legacy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var name = 'esaggs';

var handleCourierRequest =
/*#__PURE__*/
function () {
  var _ref2 = _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee(_ref) {
    var searchSource, aggs, timeRange, query, filters, forceFetch, partialRows, metricsAtAllLevels, inspectorAdapters, queryFilter, abortSignal, timeFilterSearchSource, requestSearchSource, reqBody, queryHash, shouldQuery, request, response, resp, _iteratorNormalCompletion, _didIteratorError, _iteratorError, _iterator, _step, agg, parsedTimeRange, tabifyParams, tabifyCacheHash, shouldCalculateNewTabify;

    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            searchSource = _ref.searchSource, aggs = _ref.aggs, timeRange = _ref.timeRange, query = _ref.query, filters = _ref.filters, forceFetch = _ref.forceFetch, partialRows = _ref.partialRows, metricsAtAllLevels = _ref.metricsAtAllLevels, inspectorAdapters = _ref.inspectorAdapters, queryFilter = _ref.queryFilter, abortSignal = _ref.abortSignal;
            // Create a new search source that inherits the original search source
            // but has the appropriate timeRange applied via a filter.
            // This is a temporary solution until we properly pass down all required
            // information for the request to the request handler (https://github.com/elastic/kibana/issues/16641).
            // Using callParentStartHandlers: true we make sure, that the parent searchSource
            // onSearchRequestStart will be called properly even though we use an inherited
            // search source.
            timeFilterSearchSource = searchSource.createChild({
              callParentStartHandlers: true
            });
            requestSearchSource = timeFilterSearchSource.createChild({
              callParentStartHandlers: true
            });
            aggs.setTimeRange(timeRange); // For now we need to mirror the history of the passed search source, since
            // the request inspector wouldn't work otherwise.

            Object.defineProperty(requestSearchSource, 'history', {
              get: function get() {
                return searchSource.history;
              },
              set: function set(history) {
                return searchSource.history = history;
              }
            });
            requestSearchSource.setField('aggs', function () {
              return aggs.toDsl(metricsAtAllLevels);
            });
            requestSearchSource.onRequestStart(function (paramSearchSource, searchRequest) {
              return aggs.onSearchRequestStart(paramSearchSource, searchRequest);
            });

            if (timeRange) {
              timeFilterSearchSource.setField('filter', function () {
                return (0, _timefilter.getTime)(searchSource.getField('index'), timeRange);
              });
            }

            requestSearchSource.setField('filter', filters);
            requestSearchSource.setField('query', query);
            _context.next = 12;
            return requestSearchSource.getSearchRequestBody();

          case 12:
            reqBody = _context.sent;
            queryHash = (0, _calculate_object_hash.calculateObjectHash)(reqBody); // We only need to reexecute the query, if forceFetch was true or the hash of the request body has changed
            // since the last request

            shouldQuery = forceFetch || searchSource.lastQuery !== queryHash;

            if (!shouldQuery) {
              _context.next = 36;
              break;
            }

            inspectorAdapters.requests.reset();
            request = inspectorAdapters.requests.start(_i18n.i18n.translate('interpreter.functions.esaggs.inspector.dataRequest.title', {
              defaultMessage: 'Data'
            }), {
              description: _i18n.i18n.translate('interpreter.functions.esaggs.inspector.dataRequest.description', {
                defaultMessage: 'This request queries Elasticsearch to fetch the data for the visualization.'
              })
            });
            request.stats((0, _courier_inspector_utils.getRequestInspectorStats)(requestSearchSource));
            _context.prev = 19;

            // Abort any in-progress requests before fetching again
            if (abortSignal) {
              abortSignal.addEventListener('abort', function () {
                return requestSearchSource.cancelQueued();
              });
            }

            _context.next = 23;
            return requestSearchSource.fetch();

          case 23:
            response = _context.sent;
            searchSource.lastQuery = queryHash;
            request.stats((0, _courier_inspector_utils.getResponseInspectorStats)(searchSource, response)).ok({
              json: response
            });
            searchSource.rawResponse = response;
            _context.next = 33;
            break;

          case 29:
            _context.prev = 29;
            _context.t0 = _context["catch"](19);
            // Log any error during request to the inspector
            request.error({
              json: _context.t0
            });
            throw _context.t0;

          case 33:
            _context.prev = 33;
            // Add the request body no matter if things went fine or not
            requestSearchSource.getSearchRequestBody().then(function (req) {
              request.json(req);
            });
            return _context.finish(33);

          case 36:
            // Note that rawResponse is not deeply cloned here, so downstream applications using courier
            // must take care not to mutate it, or it could have unintended side effects, e.g. displaying
            // response data incorrectly in the inspector.
            resp = searchSource.rawResponse;
            _iteratorNormalCompletion = true;
            _didIteratorError = false;
            _iteratorError = undefined;
            _context.prev = 40;
            _iterator = aggs.aggs[Symbol.iterator]();

          case 42:
            if (_iteratorNormalCompletion = (_step = _iterator.next()).done) {
              _context.next = 51;
              break;
            }

            agg = _step.value;

            if (!(0, _lodash.has)(agg, 'type.postFlightRequest')) {
              _context.next = 48;
              break;
            }

            _context.next = 47;
            return agg.type.postFlightRequest(resp, aggs, agg, requestSearchSource, inspectorAdapters, abortSignal);

          case 47:
            resp = _context.sent;

          case 48:
            _iteratorNormalCompletion = true;
            _context.next = 42;
            break;

          case 51:
            _context.next = 57;
            break;

          case 53:
            _context.prev = 53;
            _context.t1 = _context["catch"](40);
            _didIteratorError = true;
            _iteratorError = _context.t1;

          case 57:
            _context.prev = 57;
            _context.prev = 58;

            if (!_iteratorNormalCompletion && _iterator.return != null) {
              _iterator.return();
            }

          case 60:
            _context.prev = 60;

            if (!_didIteratorError) {
              _context.next = 63;
              break;
            }

            throw _iteratorError;

          case 63:
            return _context.finish(60);

          case 64:
            return _context.finish(57);

          case 65:
            searchSource.finalResponse = resp;
            parsedTimeRange = timeRange ? (0, _timefilter.getTime)(aggs.indexPattern, timeRange) : null;
            tabifyParams = {
              metricsAtAllLevels: metricsAtAllLevels,
              partialRows: partialRows,
              timeRange: parsedTimeRange ? parsedTimeRange.range : undefined
            };
            tabifyCacheHash = (0, _calculate_object_hash.calculateObjectHash)(_objectSpread({
              tabifyAggs: aggs
            }, tabifyParams)); // We only need to reexecute tabify, if either we did a new request or some input params to tabify changed

            shouldCalculateNewTabify = shouldQuery || searchSource.lastTabifyHash !== tabifyCacheHash;

            if (shouldCalculateNewTabify) {
              searchSource.lastTabifyHash = tabifyCacheHash;
              searchSource.tabifiedResponse = (0, _tabify.tabifyAggResponse)(aggs, searchSource.finalResponse, tabifyParams);
            }

            inspectorAdapters.data.setTabularLoader(function () {
              return (0, _build_tabular_inspector_data.buildTabularInspectorData)(searchSource.tabifiedResponse, queryFilter);
            }, {
              returnsFormattedValues: true
            });
            return _context.abrupt("return", searchSource.tabifiedResponse);

          case 73:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[19, 29, 33, 36], [40, 53, 57, 65], [58,, 60, 64]]);
  }));

  return function handleCourierRequest(_x) {
    return _ref2.apply(this, arguments);
  };
}();

var esaggs = function esaggs() {
  return {
    name: name,
    type: 'kibana_datatable',
    context: {
      types: ['kibana_context', 'null']
    },
    help: _i18n.i18n.translate('interpreter.functions.esaggs.help', {
      defaultMessage: 'Run AggConfig aggregation'
    }),
    args: {
      index: {
        types: ['string'],
        help: ''
      },
      metricsAtAllLevels: {
        types: ['boolean'],
        default: false,
        help: ''
      },
      partialRows: {
        types: ['boolean'],
        default: false,
        help: ''
      },
      includeFormatHints: {
        types: ['boolean'],
        default: false,
        help: ''
      },
      aggConfigs: {
        types: ['string'],
        default: '""',
        help: ''
      }
    },
    fn: function () {
      var _fn = _asyncToGenerator(
      /*#__PURE__*/
      regeneratorRuntime.mark(function _callee2(context, args, _ref3) {
        var inspectorAdapters, abortSignal, $injector, Private, indexPatterns, SearchSourceClass, queryFilter, aggConfigsState, indexPattern, aggs, searchSource, response, table;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                inspectorAdapters = _ref3.inspectorAdapters, abortSignal = _ref3.abortSignal;
                _context2.next = 3;
                return _chrome.default.dangerouslyGetActiveInjector();

              case 3:
                $injector = _context2.sent;
                Private = $injector.get('Private');
                indexPatterns = _legacy.start.indexPatterns.indexPatterns;
                SearchSourceClass = Private(_search_source.SearchSourceProvider);
                queryFilter = Private(_query_filter.FilterBarQueryFilterProvider);
                aggConfigsState = JSON.parse(args.aggConfigs);
                _context2.next = 11;
                return indexPatterns.get(args.index);

              case 11:
                indexPattern = _context2.sent;
                aggs = new _agg_configs.AggConfigs(indexPattern, aggConfigsState); // we should move searchSource creation inside courier request handler

                searchSource = new SearchSourceClass();
                searchSource.setField('index', indexPattern);
                searchSource.setField('size', 0);
                _context2.next = 18;
                return handleCourierRequest({
                  searchSource: searchSource,
                  aggs: aggs,
                  timeRange: (0, _lodash.get)(context, 'timeRange', undefined),
                  query: (0, _lodash.get)(context, 'query', undefined),
                  filters: (0, _lodash.get)(context, 'filters', undefined),
                  forceFetch: true,
                  metricsAtAllLevels: args.metricsAtAllLevels,
                  partialRows: args.partialRows,
                  inspectorAdapters: inspectorAdapters,
                  queryFilter: queryFilter,
                  abortSignal: abortSignal
                });

              case 18:
                response = _context2.sent;
                table = {
                  type: 'kibana_datatable',
                  rows: response.rows,
                  columns: response.columns.map(function (column) {
                    var cleanedColumn = {
                      id: column.id,
                      name: column.name
                    };

                    if (args.includeFormatHints) {
                      cleanedColumn.formatHint = (0, _utilities.createFormat)(column.aggConfig);
                    }

                    return cleanedColumn;
                  })
                };
                return _context2.abrupt("return", table);

              case 21:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      function fn(_x2, _x3, _x4) {
        return _fn.apply(this, arguments);
      }

      return fn;
    }()
  };
};

exports.esaggs = esaggs;