"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Editor = void 0;

var _react = _interopRequireWildcard(require("react"));

var _eui = require("@elastic/eui");

var _i18n = require("@kbn/i18n");

var _jquery = _interopRequireDefault(require("jquery"));

var _context2 = require("../../../../context");

var _use_ui_ace_keyboard_mode = require("../use_ui_ace_keyboard_mode");

var _components = require("../../../../components");

var _console_menu_actions = require("../console_menu_actions");

var _keyboard_shortcuts = require("./keyboard_shortcuts");

var _apply_editor_settings = require("./apply_editor_settings");

var _input = require("../../../../../../../public/quarantined/src/input");

var _mappings = _interopRequireDefault(require("../../../../../../../public/quarantined/src/mappings"));

var _context3 = require("../../context");

var _subscribe_console_resize_checker = require("../subscribe_console_resize_checker");

var _load_remote_editor_state = require("./load_remote_editor_state");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var abs = {
  position: 'absolute',
  top: '0',
  left: '0',
  bottom: '0',
  right: '0'
};
var DEFAULT_INPUT_VALUE = "GET _search\n{\n  \"query\": {\n    \"match_all\": {}\n  }\n}";

function _Editor(_ref) {
  var _ref$previousStateLoc = _ref.previousStateLocation,
      previousStateLocation = _ref$previousStateLoc === void 0 ? 'stored' : _ref$previousStateLoc;

  var _useAppContext = (0, _context2.useAppContext)(),
      _useAppContext$servic = _useAppContext.services,
      history = _useAppContext$servic.history,
      notifications = _useAppContext$servic.notifications,
      ResizeChecker = _useAppContext.ResizeChecker,
      docLinkVersion = _useAppContext.docLinkVersion;

  var _useEditorReadContext = (0, _context3.useEditorReadContext)(),
      settings = _useEditorReadContext.settings;

  var dispatch = (0, _context3.useEditorActionContext)();
  var editorRef = (0, _react.useRef)(null);
  var actionsRef = (0, _react.useRef)(null);
  var editorInstanceRef = (0, _react.useRef)(null);

  var _useState = (0, _react.useState)(null),
      _useState2 = _slicedToArray(_useState, 2),
      textArea = _useState2[0],
      setTextArea = _useState2[1];

  (0, _use_ui_ace_keyboard_mode.useUIAceKeyboardMode)(textArea);

  var openDocumentation =
  /*#__PURE__*/
  function () {
    var _ref2 = _asyncToGenerator(
    /*#__PURE__*/
    regeneratorRuntime.mark(function _callee() {
      var documentation;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return (0, _console_menu_actions.getDocumentation)(editorInstanceRef.current, docLinkVersion);

            case 2:
              documentation = _context.sent;

              if (documentation) {
                _context.next = 5;
                break;
              }

              return _context.abrupt("return");

            case 5:
              window.open(documentation, '_blank');

            case 6:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function openDocumentation() {
      return _ref2.apply(this, arguments);
    };
  }();

  (0, _react.useEffect)(function () {
    var $editor = (0, _jquery.default)(editorRef.current);
    var $actions = (0, _jquery.default)(actionsRef.current);
    editorInstanceRef.current = (0, _input.initializeInput)($editor, $actions);

    if (previousStateLocation === 'stored') {
      var _ref3 = history.getSavedEditorState() || {
        content: DEFAULT_INPUT_VALUE
      },
          content = _ref3.content;

      editorInstanceRef.current.update(content);
    } else {
      (0, _load_remote_editor_state.loadRemoteState)({
        url: previousStateLocation,
        input: editorInstanceRef.current
      });
    }

    function setupAutosave() {
      var timer;
      var saveDelay = 500;
      return editorInstanceRef.current.getSession().on('change', function onChange() {
        if (timer) {
          clearTimeout(timer);
        }

        timer = window.setTimeout(saveCurrentState, saveDelay);
      });
    }

    function saveCurrentState() {
      try {
        var _content = editorInstanceRef.current.getValue();

        history.updateCurrentState(_content);
      } catch (e) {// Ignoring saving error
      }
    }

    dispatch({
      type: 'setInputEditor',
      value: editorInstanceRef.current
    });
    setTextArea(editorRef.current.querySelector('textarea'));

    _mappings.default.retrieveAutoCompleteInfo();

    var unsubscribeResizer = (0, _subscribe_console_resize_checker.subscribeResizeChecker)(ResizeChecker, editorRef.current, editorInstanceRef.current);
    var unsubscribeAutoSave = setupAutosave();
    return function () {
      unsubscribeResizer();
      unsubscribeAutoSave();

      _mappings.default.clearSubscriptions();
    };
  }, []);
  var sendCurrentRequestToES = (0, _react.useCallback)(function () {
    dispatch({
      type: 'sendRequestToEs',
      value: {
        isUsingTripleQuotes: settings.tripleQuotes,
        isPolling: settings.polling,
        callback: function callback(esPath, esMethod, esData) {
          return history.addToHistory(esPath, esMethod, esData);
        }
      }
    });
  }, [settings]);
  (0, _react.useEffect)(function () {
    (0, _apply_editor_settings.applyCurrentSettings)(editorInstanceRef.current, settings); // Preserve legacy focus behavior after settings have updated.

    editorInstanceRef.current.focus();
  }, [settings]);
  (0, _react.useEffect)(function () {
    (0, _keyboard_shortcuts.registerCommands)({
      input: editorInstanceRef.current,
      sendCurrentRequestToES: sendCurrentRequestToES,
      openDocumentation: openDocumentation
    });
  }, [sendCurrentRequestToES]);
  return _react.default.createElement("div", {
    style: abs,
    className: "conApp"
  }, _react.default.createElement("div", {
    className: "conApp__editor"
  }, _react.default.createElement("ul", {
    className: "conApp__autoComplete",
    id: "autocomplete"
  }), _react.default.createElement(_eui.EuiFlexGroup, {
    ref: actionsRef,
    className: "conApp__editorActions",
    id: "ConAppEditorActions",
    gutterSize: "none",
    responsive: false
  }, _react.default.createElement(_eui.EuiFlexItem, null, _react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('console.sendRequestButtonTooltip', {
      defaultMessage: 'click to send request'
    })
  }, _react.default.createElement("button", {
    onClick: sendCurrentRequestToES,
    "data-test-subj": "sendRequestButton",
    className: "conApp__editorActionButton conApp__editorActionButton--success"
  }, _react.default.createElement(_eui.EuiIcon, {
    type: "play"
  })))), _react.default.createElement(_eui.EuiFlexItem, null, _react.default.createElement(_components.ConsoleMenu, {
    getCurl: function getCurl(cb) {
      editorInstanceRef.current.getRequestsAsCURL(cb);
    },
    getDocumentation: function getDocumentation() {
      return (0, _console_menu_actions.getDocumentation)(editorInstanceRef.current, docLinkVersion);
    },
    autoIndent: function autoIndent(event) {
      (0, _console_menu_actions.autoIndent)(editorInstanceRef.current, event);
    },
    addNotification: function addNotification(_ref4) {
      var title = _ref4.title;
      return notifications.toasts.add({
        title: title
      });
    }
  }))), _react.default.createElement("div", {
    ref: editorRef,
    id: "ConAppEditor",
    className: "conApp__editorContent",
    "data-test-subj": "request-editor"
  })));
}

var Editor = _react.default.memo(_Editor);

exports.Editor = Editor;