## API Report File for "kibana"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { Breadcrumb } from '@elastic/eui';
import { IconType } from '@elastic/eui';
import { Observable } from 'rxjs';
import React from 'react';
import * as Rx from 'rxjs';
import { ShallowPromise } from '@kbn/utility-types';
import { EuiGlobalToastListToast as Toast } from '@elastic/eui';

// @public
export interface App extends AppBase {
    mount: (context: AppMountContext, params: AppMountParameters) => AppUnmount | Promise<AppUnmount>;
}

// @public (undocumented)
export interface AppBase {
    capabilities?: Partial<Capabilities>;
    euiIconType?: string;
    icon?: string;
    // (undocumented)
    id: string;
    order?: number;
    title: string;
    tooltip$?: Observable<string>;
}

// @public (undocumented)
export interface ApplicationSetup {
    register(app: App): void;
    registerMountContext<T extends keyof AppMountContext>(contextName: T, provider: IContextProvider<App['mount'], T>): void;
}

// @public (undocumented)
export interface ApplicationStart {
    capabilities: RecursiveReadonly<Capabilities>;
    getUrlForApp(appId: string, options?: {
        path?: string;
    }): string;
    navigateToApp(appId: string, options?: {
        path?: string;
        state?: any;
    }): void;
    registerMountContext<T extends keyof AppMountContext>(contextName: T, provider: IContextProvider<App['mount'], T>): void;
}

// @public
export interface AppMountContext {
    core: {
        application: Pick<ApplicationStart, 'capabilities' | 'navigateToApp'>;
        chrome: ChromeStart;
        docLinks: DocLinksStart;
        http: HttpStart;
        i18n: I18nStart;
        notifications: NotificationsStart;
        overlays: OverlayStart;
        uiSettings: UiSettingsClientContract;
        injectedMetadata: {
            getInjectedVar: (name: string, defaultValue?: any) => unknown;
        };
    };
}

// @public (undocumented)
export interface AppMountParameters {
    appBasePath: string;
    element: HTMLElement;
}

// @public
export type AppUnmount = () => void;

// @public
export interface Capabilities {
    [key: string]: Record<string, boolean | Record<string, boolean>>;
    catalogue: Record<string, boolean>;
    management: {
        [sectionId: string]: Record<string, boolean>;
    };
    navLinks: Record<string, boolean>;
}

// @public (undocumented)
export interface ChromeBadge {
    // (undocumented)
    iconType?: IconType;
    // (undocumented)
    text: string;
    // (undocumented)
    tooltip: string;
}

// @public (undocumented)
export interface ChromeBrand {
    // (undocumented)
    logo?: string;
    // (undocumented)
    smallLogo?: string;
}

// @public (undocumented)
export type ChromeBreadcrumb = Breadcrumb;

// @public (undocumented)
export type ChromeHelpExtension = (element: HTMLDivElement) => () => void;

// @public (undocumented)
export interface ChromeNavControl {
    // (undocumented)
    mount(targetDomElement: HTMLElement): () => void;
    // (undocumented)
    order?: number;
}

// @public
export interface ChromeNavControls {
    // @internal (undocumented)
    getLeft$(): Observable<ChromeNavControl[]>;
    // @internal (undocumented)
    getRight$(): Observable<ChromeNavControl[]>;
    registerLeft(navControl: ChromeNavControl): void;
    registerRight(navControl: ChromeNavControl): void;
}

// @public (undocumented)
export interface ChromeNavLink {
    // @deprecated
    readonly active?: boolean;
    readonly baseUrl: string;
    // @deprecated
    readonly disabled?: boolean;
    readonly euiIconType?: string;
    readonly hidden?: boolean;
    readonly icon?: string;
    readonly id: string;
    // @internal
    readonly legacy: boolean;
    // @deprecated
    readonly linkToLastSubUrl?: boolean;
    readonly order?: number;
    // @deprecated
    readonly subUrlBase?: string;
    readonly title: string;
    readonly tooltip?: string;
    // @deprecated
    readonly url?: string;
}

// @public
export interface ChromeNavLinks {
    enableForcedAppSwitcherNavigation(): void;
    get(id: string): ChromeNavLink | undefined;
    getAll(): Array<Readonly<ChromeNavLink>>;
    getForceAppSwitcherNavigation$(): Observable<boolean>;
    getNavLinks$(): Observable<Array<Readonly<ChromeNavLink>>>;
    has(id: string): boolean;
    showOnly(id: string): void;
    update(id: string, values: ChromeNavLinkUpdateableFields): ChromeNavLink | undefined;
}

// @public (undocumented)
export type ChromeNavLinkUpdateableFields = Partial<Pick<ChromeNavLink, 'active' | 'disabled' | 'hidden' | 'url' | 'subUrlBase'>>;

// @public
export interface ChromeRecentlyAccessed {
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: No member was found with name "basePath"
    add(link: string, label: string, id: string): void;
    get$(): Observable<ChromeRecentlyAccessedHistoryItem[]>;
    get(): ChromeRecentlyAccessedHistoryItem[];
}

// @public (undocumented)
export interface ChromeRecentlyAccessedHistoryItem {
    // (undocumented)
    id: string;
    // (undocumented)
    label: string;
    // (undocumented)
    link: string;
}

// @public
export interface ChromeStart {
    addApplicationClass(className: string): void;
    getApplicationClasses$(): Observable<string[]>;
    getBadge$(): Observable<ChromeBadge | undefined>;
    getBrand$(): Observable<ChromeBrand>;
    getBreadcrumbs$(): Observable<ChromeBreadcrumb[]>;
    getHelpExtension$(): Observable<ChromeHelpExtension | undefined>;
    getIsCollapsed$(): Observable<boolean>;
    getIsVisible$(): Observable<boolean>;
    navControls: ChromeNavControls;
    navLinks: ChromeNavLinks;
    recentlyAccessed: ChromeRecentlyAccessed;
    removeApplicationClass(className: string): void;
    setAppTitle(appTitle: string): void;
    setBadge(badge?: ChromeBadge): void;
    setBrand(brand: ChromeBrand): void;
    setBreadcrumbs(newBreadcrumbs: ChromeBreadcrumb[]): void;
    setHelpExtension(helpExtension?: ChromeHelpExtension): void;
    setIsCollapsed(isCollapsed: boolean): void;
    setIsVisible(isVisible: boolean): void;
}

// @public
export interface ContextSetup {
    createContextContainer<THandler extends HandlerFunction<any>>(): IContextContainer<THandler>;
}

// @internal (undocumented)
export interface CoreContext {
    // Warning: (ae-forgotten-export) The symbol "CoreId" needs to be exported by the entry point index.d.ts
    // 
    // (undocumented)
    coreId: CoreId;
    // (undocumented)
    env: {
        mode: Readonly<EnvironmentMode>;
        packageInfo: Readonly<PackageInfo>;
    };
}

// @public
export interface CoreSetup {
    // (undocumented)
    application: ApplicationSetup;
    // (undocumented)
    context: ContextSetup;
    // (undocumented)
    fatalErrors: FatalErrorsSetup;
    // (undocumented)
    http: HttpSetup;
    // @deprecated
    injectedMetadata: {
        getInjectedVar: (name: string, defaultValue?: any) => unknown;
    };
    // (undocumented)
    notifications: NotificationsSetup;
    // (undocumented)
    uiSettings: UiSettingsClientContract;
}

// @public
export interface CoreStart {
    // (undocumented)
    application: ApplicationStart;
    // (undocumented)
    chrome: ChromeStart;
    // (undocumented)
    docLinks: DocLinksStart;
    // (undocumented)
    http: HttpStart;
    // (undocumented)
    i18n: I18nStart;
    // @deprecated
    injectedMetadata: {
        getInjectedVar: (name: string, defaultValue?: any) => unknown;
    };
    // (undocumented)
    notifications: NotificationsStart;
    // (undocumented)
    overlays: OverlayStart;
    // (undocumented)
    savedObjects: SavedObjectsStart;
    // (undocumented)
    uiSettings: UiSettingsClientContract;
}

// @internal
export class CoreSystem {
    // Warning: (ae-forgotten-export) The symbol "Params" needs to be exported by the entry point index.d.ts
    constructor(params: Params);
    // (undocumented)
    setup(): Promise<{
        fatalErrors: FatalErrorsSetup;
    } | undefined>;
    // (undocumented)
    start(): Promise<void>;
    // (undocumented)
    stop(): void;
    }

// @public (undocumented)
export interface DocLinksStart {
    // (undocumented)
    readonly DOC_LINK_VERSION: string;
    // (undocumented)
    readonly ELASTIC_WEBSITE_URL: string;
    // (undocumented)
    readonly links: {
        readonly filebeat: {
            readonly base: string;
            readonly installation: string;
            readonly configuration: string;
            readonly elasticsearchOutput: string;
            readonly startup: string;
            readonly exportedFields: string;
        };
        readonly auditbeat: {
            readonly base: string;
        };
        readonly metricbeat: {
            readonly base: string;
        };
        readonly heartbeat: {
            readonly base: string;
        };
        readonly logstash: {
            readonly base: string;
        };
        readonly functionbeat: {
            readonly base: string;
        };
        readonly winlogbeat: {
            readonly base: string;
        };
        readonly aggs: {
            readonly date_histogram: string;
            readonly date_range: string;
            readonly filter: string;
            readonly filters: string;
            readonly geohash_grid: string;
            readonly histogram: string;
            readonly ip_range: string;
            readonly range: string;
            readonly significant_terms: string;
            readonly terms: string;
            readonly avg: string;
            readonly avg_bucket: string;
            readonly max_bucket: string;
            readonly min_bucket: string;
            readonly sum_bucket: string;
            readonly cardinality: string;
            readonly count: string;
            readonly cumulative_sum: string;
            readonly derivative: string;
            readonly geo_bounds: string;
            readonly geo_centroid: string;
            readonly max: string;
            readonly median: string;
            readonly min: string;
            readonly moving_avg: string;
            readonly percentile_ranks: string;
            readonly serial_diff: string;
            readonly std_dev: string;
            readonly sum: string;
            readonly top_hits: string;
        };
        readonly scriptedFields: {
            readonly scriptFields: string;
            readonly scriptAggs: string;
            readonly painless: string;
            readonly painlessApi: string;
            readonly painlessSyntax: string;
            readonly luceneExpressions: string;
        };
        readonly indexPatterns: {
            readonly loadingData: string;
            readonly introduction: string;
        };
        readonly kibana: string;
        readonly siem: string;
        readonly query: {
            readonly luceneQuerySyntax: string;
            readonly queryDsl: string;
            readonly kueryQuerySyntax: string;
        };
        readonly date: {
            readonly dateMath: string;
        };
    };
}

// @public (undocumented)
export interface EnvironmentMode {
    // (undocumented)
    dev: boolean;
    // (undocumented)
    name: 'development' | 'production';
    // (undocumented)
    prod: boolean;
}

// @public
export interface ErrorToastOptions {
    title: string;
    toastMessage?: string;
}

// @public
export interface FatalErrorInfo {
    // (undocumented)
    message: string;
    // (undocumented)
    stack: string | undefined;
}

// @public
export interface FatalErrorsSetup {
    add: (error: string | Error, source?: string) => never;
    get$: () => Rx.Observable<FatalErrorInfo>;
}

// @public
export type HandlerContextType<T extends HandlerFunction<any>> = T extends HandlerFunction<infer U> ? U : never;

// @public
export type HandlerFunction<T extends object> = (context: T, ...args: any[]) => any;

// @public
export type HandlerParameters<T extends HandlerFunction<any>> = T extends (context: any, ...args: infer U) => any ? U : never;

// @public (undocumented)
export type HttpBody = BodyInit | null | any;

// @public (undocumented)
export interface HttpErrorRequest {
    // (undocumented)
    error: Error;
    // (undocumented)
    request: Request;
}

// @public (undocumented)
export interface HttpErrorResponse {
    // (undocumented)
    body?: HttpBody;
    // (undocumented)
    error: Error | IHttpFetchError;
    // (undocumented)
    request?: Request;
    // (undocumented)
    response?: Response;
}

// @public
export interface HttpFetchOptions extends HttpRequestInit {
    headers?: HttpHeadersInit;
    prependBasePath?: boolean;
    query?: HttpFetchQuery;
}

// @public (undocumented)
export interface HttpFetchQuery {
    // (undocumented)
    [key: string]: string | number | boolean | undefined;
}

// @public
export type HttpHandler = (path: string, options?: HttpFetchOptions) => Promise<HttpBody>;

// @public (undocumented)
export interface HttpHeadersInit {
    // (undocumented)
    [name: string]: any;
}

// @public
export interface HttpInterceptor {
    request?(request: Request, controller: IHttpInterceptController): Promise<Request> | Request | void;
    requestError?(httpErrorRequest: HttpErrorRequest, controller: IHttpInterceptController): Promise<Request> | Request | void;
    response?(httpResponse: HttpResponse, controller: IHttpInterceptController): Promise<HttpResponse> | HttpResponse | void;
    responseError?(httpErrorResponse: HttpErrorResponse, controller: IHttpInterceptController): Promise<HttpResponse> | HttpResponse | void;
}

// @public
export interface HttpRequestInit {
    body?: BodyInit | null;
    cache?: RequestCache;
    credentials?: RequestCredentials;
    // (undocumented)
    headers?: HttpHeadersInit;
    integrity?: string;
    keepalive?: boolean;
    method?: string;
    mode?: RequestMode;
    redirect?: RequestRedirect;
    referrer?: string;
    referrerPolicy?: ReferrerPolicy;
    signal?: AbortSignal | null;
    window?: null;
}

// @public (undocumented)
export interface HttpResponse {
    // (undocumented)
    body?: HttpBody;
    // (undocumented)
    request?: Request;
    // (undocumented)
    response?: Response;
}

// @public (undocumented)
export interface HttpServiceBase {
    addLoadingCount(countSource$: Observable<number>): void;
    basePath: IBasePath;
    delete: HttpHandler;
    fetch: HttpHandler;
    get: HttpHandler;
    getLoadingCount$(): Observable<number>;
    head: HttpHandler;
    intercept(interceptor: HttpInterceptor): () => void;
    options: HttpHandler;
    patch: HttpHandler;
    post: HttpHandler;
    put: HttpHandler;
    removeAllInterceptors(): void;
    // @internal (undocumented)
    stop(): void;
}

// @public
export type HttpSetup = HttpServiceBase;

// @public
export type HttpStart = HttpServiceBase;

// @public
export interface I18nStart {
    Context: ({ children }: {
        children: React.ReactNode;
    }) => JSX.Element;
}

// @public
export interface IBasePath {
    get: () => string;
    prepend: (url: string) => string;
    remove: (url: string) => string;
}

// @public
export interface IContextContainer<THandler extends HandlerFunction<any>> {
    createHandler(pluginOpaqueId: PluginOpaqueId, handler: THandler): (...rest: HandlerParameters<THandler>) => ShallowPromise<ReturnType<THandler>>;
    registerContext<TContextName extends keyof HandlerContextType<THandler>>(pluginOpaqueId: PluginOpaqueId, contextName: TContextName, provider: IContextProvider<THandler, TContextName>): this;
}

// @public
export type IContextProvider<THandler extends HandlerFunction<any>, TContextName extends keyof HandlerContextType<THandler>> = (context: Partial<HandlerContextType<THandler>>, ...rest: HandlerParameters<THandler>) => Promise<HandlerContextType<THandler>[TContextName]> | HandlerContextType<THandler>[TContextName];

// @public (undocumented)
export interface IHttpFetchError extends Error {
    // (undocumented)
    readonly body?: any;
    // (undocumented)
    readonly request: Request;
    // (undocumented)
    readonly response?: Response;
}

// @public
export interface IHttpInterceptController {
    halt(): void;
    halted: boolean;
}

// @public
export type IToasts = Pick<ToastsApi, 'get$' | 'add' | 'remove' | 'addSuccess' | 'addWarning' | 'addDanger' | 'addError'>;

// @public @deprecated
export interface LegacyCoreSetup extends CoreSetup {
    // Warning: (ae-forgotten-export) The symbol "InjectedMetadataSetup" needs to be exported by the entry point index.d.ts
    // 
    // @deprecated (undocumented)
    injectedMetadata: InjectedMetadataSetup;
}

// @public @deprecated
export interface LegacyCoreStart extends CoreStart {
    // Warning: (ae-forgotten-export) The symbol "InjectedMetadataStart" needs to be exported by the entry point index.d.ts
    // 
    // @deprecated (undocumented)
    injectedMetadata: InjectedMetadataStart;
}

// @public (undocumented)
export interface LegacyNavLink {
    // (undocumented)
    euiIconType?: string;
    // (undocumented)
    icon?: string;
    // (undocumented)
    id: string;
    // (undocumented)
    order: number;
    // (undocumented)
    title: string;
    // (undocumented)
    url: string;
}

// @public (undocumented)
export interface NotificationsSetup {
    // (undocumented)
    toasts: ToastsSetup;
}

// @public (undocumented)
export interface NotificationsStart {
    // (undocumented)
    toasts: ToastsStart;
}

// @public
export type OverlayBannerMount = (element: HTMLElement) => OverlayBannerUnmount;

// @public (undocumented)
export interface OverlayBannersStart {
    add(mount: OverlayBannerMount, priority?: number): string;
    // Warning: (ae-forgotten-export) The symbol "OverlayBanner" needs to be exported by the entry point index.d.ts
    // 
    // @internal (undocumented)
    get$(): Observable<OverlayBanner[]>;
    // (undocumented)
    getComponent(): JSX.Element;
    remove(id: string): boolean;
    replace(id: string | undefined, mount: OverlayBannerMount, priority?: number): string;
}

// @public
export type OverlayBannerUnmount = () => void;

// @public
export interface OverlayRef {
    close(): Promise<void>;
    onClose: Promise<void>;
}

// @public (undocumented)
export interface OverlayStart {
    // (undocumented)
    banners: OverlayBannersStart;
    // (undocumented)
    openFlyout: (flyoutChildren: React.ReactNode, flyoutProps?: {
        closeButtonAriaLabel?: string;
        'data-test-subj'?: string;
    }) => OverlayRef;
    // (undocumented)
    openModal: (modalChildren: React.ReactNode, modalProps?: {
        className?: string;
        closeButtonAriaLabel?: string;
        'data-test-subj'?: string;
    }) => OverlayRef;
}

// @public (undocumented)
export interface PackageInfo {
    // (undocumented)
    branch: string;
    // (undocumented)
    buildNum: number;
    // (undocumented)
    buildSha: string;
    // (undocumented)
    dist: boolean;
    // (undocumented)
    version: string;
}

// @public
export interface Plugin<TSetup = void, TStart = void, TPluginsSetup extends object = object, TPluginsStart extends object = object> {
    // (undocumented)
    setup(core: CoreSetup, plugins: TPluginsSetup): TSetup | Promise<TSetup>;
    // (undocumented)
    start(core: CoreStart, plugins: TPluginsStart): TStart | Promise<TStart>;
    // (undocumented)
    stop?(): void;
}

// @public
export type PluginInitializer<TSetup, TStart, TPluginsSetup extends object = object, TPluginsStart extends object = object> = (core: PluginInitializerContext) => Plugin<TSetup, TStart, TPluginsSetup, TPluginsStart>;

// @public
export interface PluginInitializerContext {
    // (undocumented)
    readonly env: {
        mode: Readonly<EnvironmentMode>;
        packageInfo: Readonly<PackageInfo>;
    };
    readonly opaqueId: PluginOpaqueId;
}

// @public (undocumented)
export type PluginOpaqueId = symbol;

// Warning: (ae-forgotten-export) The symbol "RecursiveReadonlyArray" needs to be exported by the entry point index.d.ts
// 
// @public (undocumented)
export type RecursiveReadonly<T> = T extends (...args: any[]) => any ? T : T extends any[] ? RecursiveReadonlyArray<T[number]> : T extends object ? Readonly<{
    [K in keyof T]: RecursiveReadonly<T[K]>;
}> : T;

// @public (undocumented)
export interface SavedObject<T extends SavedObjectAttributes = any> {
    attributes: T;
    // (undocumented)
    error?: {
        message: string;
        statusCode: number;
    };
    id: string;
    migrationVersion?: SavedObjectsMigrationVersion;
    references: SavedObjectReference[];
    type: string;
    updated_at?: string;
    version?: string;
}

// @public
export type SavedObjectAttribute = SavedObjectAttributeSingle | SavedObjectAttributeSingle[];

// @public
export interface SavedObjectAttributes {
    // (undocumented)
    [key: string]: SavedObjectAttribute;
}

// @public
export type SavedObjectAttributeSingle = string | number | boolean | null | undefined | SavedObjectAttributes;

// @public
export interface SavedObjectReference {
    // (undocumented)
    id: string;
    // (undocumented)
    name: string;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export interface SavedObjectsBaseOptions {
    namespace?: string;
}

// @public (undocumented)
export interface SavedObjectsBatchResponse<T extends SavedObjectAttributes = SavedObjectAttributes> {
    // (undocumented)
    savedObjects: Array<SimpleSavedObject<T>>;
}

// @public (undocumented)
export interface SavedObjectsBulkCreateObject<T extends SavedObjectAttributes = SavedObjectAttributes> extends SavedObjectsCreateOptions {
    // (undocumented)
    attributes: T;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export interface SavedObjectsBulkCreateOptions {
    overwrite?: boolean;
}

// @public
export class SavedObjectsClient {
    // @internal
    constructor(http: HttpServiceBase);
    bulkCreate: (objects?: SavedObjectsBulkCreateObject<SavedObjectAttributes>[], options?: SavedObjectsBulkCreateOptions) => Promise<SavedObjectsBatchResponse<SavedObjectAttributes>>;
    bulkGet: (objects?: {
        id: string;
        type: string;
    }[]) => Promise<SavedObjectsBatchResponse<SavedObjectAttributes>>;
    create: <T extends SavedObjectAttributes>(type: string, attributes: T, options?: SavedObjectsCreateOptions) => Promise<SimpleSavedObject<T>>;
    delete: (type: string, id: string) => Promise<{}>;
    find: <T extends SavedObjectAttributes>(options: Pick<SavedObjectsFindOptions, "search" | "filter" | "type" | "searchFields" | "defaultSearchOperator" | "hasReference" | "sortField" | "page" | "perPage" | "fields">) => Promise<SavedObjectsFindResponsePublic<T>>;
    get: <T extends SavedObjectAttributes>(type: string, id: string) => Promise<SimpleSavedObject<T>>;
    update<T extends SavedObjectAttributes>(type: string, id: string, attributes: T, { version, migrationVersion, references }?: SavedObjectsUpdateOptions): Promise<SimpleSavedObject<T>>;
}

// @public
export type SavedObjectsClientContract = PublicMethodsOf<SavedObjectsClient>;

// @public (undocumented)
export interface SavedObjectsCreateOptions {
    id?: string;
    migrationVersion?: SavedObjectsMigrationVersion;
    overwrite?: boolean;
    // (undocumented)
    references?: SavedObjectReference[];
}

// @public (undocumented)
export interface SavedObjectsFindOptions extends SavedObjectsBaseOptions {
    // (undocumented)
    defaultSearchOperator?: 'AND' | 'OR';
    fields?: string[];
    // (undocumented)
    filter?: string;
    // (undocumented)
    hasReference?: {
        type: string;
        id: string;
    };
    // (undocumented)
    page?: number;
    // (undocumented)
    perPage?: number;
    search?: string;
    searchFields?: string[];
    // (undocumented)
    sortField?: string;
    // (undocumented)
    sortOrder?: string;
    // (undocumented)
    type: string | string[];
}

// @public
export interface SavedObjectsFindResponsePublic<T extends SavedObjectAttributes = SavedObjectAttributes> extends SavedObjectsBatchResponse<T> {
    // (undocumented)
    page: number;
    // (undocumented)
    perPage: number;
    // (undocumented)
    total: number;
}

// @public
export interface SavedObjectsMigrationVersion {
    // (undocumented)
    [pluginName: string]: string;
}

// @public (undocumented)
export interface SavedObjectsStart {
    // (undocumented)
    client: SavedObjectsClientContract;
}

// @public (undocumented)
export interface SavedObjectsUpdateOptions {
    migrationVersion?: SavedObjectsMigrationVersion;
    // (undocumented)
    references?: SavedObjectReference[];
    // (undocumented)
    version?: string;
}

// @public
export class SimpleSavedObject<T extends SavedObjectAttributes> {
    constructor(client: SavedObjectsClient, { id, type, version, attributes, error, references, migrationVersion }: SavedObject<T>);
    // (undocumented)
    attributes: T;
    // (undocumented)
    delete(): Promise<{}>;
    // (undocumented)
    error: SavedObject<T>['error'];
    // (undocumented)
    get(key: string): any;
    // (undocumented)
    has(key: string): boolean;
    // (undocumented)
    id: SavedObject<T>['id'];
    // (undocumented)
    migrationVersion: SavedObject<T>['migrationVersion'];
    // (undocumented)
    references: SavedObject<T>['references'];
    // (undocumented)
    save(): Promise<SimpleSavedObject<T>>;
    // (undocumented)
    set(key: string, value: any): T;
    // (undocumented)
    type: SavedObject<T>['type'];
    // (undocumented)
    _version?: SavedObject<T>['version'];
}

export { Toast }

// @public
export type ToastInput = string | ToastInputFields | Promise<ToastInputFields>;

// @public
export type ToastInputFields = Pick<Toast, Exclude<keyof Toast, 'id'>>;

// @public
export class ToastsApi implements IToasts {
    constructor(deps: {
        uiSettings: UiSettingsClientContract;
    });
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: Reexported declarations are not supported
    add(toastOrTitle: ToastInput): Toast;
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: Reexported declarations are not supported
    addDanger(toastOrTitle: ToastInput): Toast;
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: Reexported declarations are not supported
    addError(error: Error, options: ErrorToastOptions): Toast;
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: Reexported declarations are not supported
    addSuccess(toastOrTitle: ToastInput): Toast;
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: Reexported declarations are not supported
    addWarning(toastOrTitle: ToastInput): Toast;
    get$(): Rx.Observable<Toast[]>;
    // @internal (undocumented)
    registerOverlays(overlays: OverlayStart): void;
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: Reexported declarations are not supported
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: The package "kibana" does not have an export "ToastApi"
    remove(toast: Toast): void;
    }

// @public (undocumented)
export type ToastsSetup = IToasts;

// @public (undocumented)
export type ToastsStart = IToasts;

// @public (undocumented)
export class UiSettingsClient {
    // Warning: (ae-forgotten-export) The symbol "UiSettingsClientParams" needs to be exported by the entry point index.d.ts
    constructor(params: UiSettingsClientParams);
    get$(key: string, defaultOverride?: any): Rx.Observable<any>;
    get(key: string, defaultOverride?: any): any;
    getAll(): UiSettingsState;
    getSaved$(): Rx.Observable<{
        key: string;
        newValue: any;
        oldValue: any;
    }>;
    getUpdate$(): Rx.Observable<{
        key: string;
        newValue: any;
        oldValue: any;
    }>;
    getUpdateErrors$(): Rx.Observable<Error>;
    isCustom(key: string): boolean;
    isDeclared(key: string): boolean;
    isDefault(key: string): boolean;
    isOverridden(key: string): boolean;
    overrideLocalDefault(key: string, newDefault: any): void;
    remove(key: string): Promise<boolean>;
    set(key: string, val: any): Promise<boolean>;
    stop(): void;
    }

// @public (undocumented)
export type UiSettingsClientContract = PublicMethodsOf<UiSettingsClient>;

// @public (undocumented)
export interface UiSettingsState {
    // Warning: (ae-forgotten-export) The symbol "InjectedUiSettingsDefault" needs to be exported by the entry point index.d.ts
    // Warning: (ae-forgotten-export) The symbol "InjectedUiSettingsUser" needs to be exported by the entry point index.d.ts
    // 
    // (undocumented)
    [key: string]: InjectedUiSettingsDefault & InjectedUiSettingsUser;
}


```
