"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppContainer = void 0;

var _react = _interopRequireDefault(require("react"));

var _app_not_found_screen = require("./app_not_found_screen");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var AppContainer =
/*#__PURE__*/
function (_React$Component) {
  _inherits(AppContainer, _React$Component);

  function AppContainer() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, AppContainer);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(AppContainer)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_this), "containerDiv", _react.default.createRef());

    _defineProperty(_assertThisInitialized(_this), "unmountFunc", void 0);

    _defineProperty(_assertThisInitialized(_this), "state", {
      appNotFound: false
    });

    return _this;
  }

  _createClass(AppContainer, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.mountApp();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.unmountApp();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.match.params.appId !== this.props.match.params.appId) {
        this.unmountApp();
        this.mountApp();
      }
    }
  }, {
    key: "mountApp",
    value: function () {
      var _mountApp = _asyncToGenerator(
      /*#__PURE__*/
      regeneratorRuntime.mark(function _callee() {
        var _this$props, apps, legacyApps, match, basePath, currentAppId$, redirectTo, appId, mount, legacyApp;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _this$props = this.props, apps = _this$props.apps, legacyApps = _this$props.legacyApps, match = _this$props.match, basePath = _this$props.basePath, currentAppId$ = _this$props.currentAppId$, redirectTo = _this$props.redirectTo;
                appId = match.params.appId;
                mount = apps.get(appId);

                if (!mount) {
                  _context.next = 10;
                  break;
                }

                _context.next = 6;
                return mount({
                  appBasePath: basePath.prepend("/app/".concat(appId)),
                  element: this.containerDiv.current
                });

              case 6:
                this.unmountFunc = _context.sent;
                currentAppId$.next(appId);
                this.setState({
                  appNotFound: false
                });
                return _context.abrupt("return");

              case 10:
                legacyApp = findLegacyApp(appId, legacyApps);

                if (!legacyApp) {
                  _context.next = 16;
                  break;
                }

                this.unmountApp();
                redirectTo(basePath.prepend("/app/".concat(appId)));
                this.setState({
                  appNotFound: false
                });
                return _context.abrupt("return");

              case 16:
                this.setState({
                  appNotFound: true
                });

              case 17:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function mountApp() {
        return _mountApp.apply(this, arguments);
      }

      return mountApp;
    }()
  }, {
    key: "unmountApp",
    value: function () {
      var _unmountApp = _asyncToGenerator(
      /*#__PURE__*/
      regeneratorRuntime.mark(function _callee2() {
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                if (this.unmountFunc) {
                  this.unmountFunc();
                  this.unmountFunc = undefined;
                }

              case 1:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function unmountApp() {
        return _unmountApp.apply(this, arguments);
      }

      return unmountApp;
    }()
  }, {
    key: "render",
    value: function render() {
      return _react.default.createElement(_react.default.Fragment, null, this.state.appNotFound && _react.default.createElement(_app_not_found_screen.AppNotFound, null), _react.default.createElement("div", {
        key: this.props.match.params.appId,
        ref: this.containerDiv
      }));
    }
  }]);

  return AppContainer;
}(_react.default.Component);

exports.AppContainer = AppContainer;

function findLegacyApp(appId, apps) {
  var matchingApps = _toConsumableArray(apps.entries()).filter(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 1),
        id = _ref2[0];

    return id.split(':')[0] === appId;
  });

  return matchingApps.length ? matchingApps[0][1] : null;
}