/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.drools;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;
import org.keycloak.authorization.policy.provider.drools.DroolsPolicyProviderFactory;
import org.keycloak.representations.idm.authorization.RulePolicyRepresentation;
import org.keycloak.services.ErrorResponse;
import org.kie.api.runtime.KieContainer;

public class DroolsPolicyAdminResource
implements PolicyProviderAdminService {
    private final DroolsPolicyProviderFactory factory;

    public DroolsPolicyAdminResource(DroolsPolicyProviderFactory factory) {
        this.factory = factory;
    }

    @Path(value="/resolveModules")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveModules(RulePolicyRepresentation policy) {
        return Response.ok((Object)this.getContainer(policy).getKieBaseNames()).build();
    }

    @Path(value="/resolveSessions")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveSessions(RulePolicyRepresentation policy) {
        return Response.ok((Object)this.getContainer(policy).getKieSessionNamesInKieBase(policy.getModuleName())).build();
    }

    private KieContainer getContainer(RulePolicyRepresentation policy) {
        String groupId = policy.getArtifactGroupId();
        String artifactId = policy.getArtifactId();
        String version = policy.getArtifactVersion();
        try {
            return this.factory.getKieContainer(groupId, artifactId, version);
        }
        catch (RuntimeException re) {
            throw new WebApplicationException(ErrorResponse.error((String)("Unable to locate artifact " + groupId + ":" + artifactId + ":" + version), (Response.Status)Response.Status.BAD_REQUEST));
        }
    }
}

