/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptor;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptorFactory;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.microprofile.client.ExceptionMapping;
import org.jboss.resteasy.microprofile.client.InvocationContextImpl;
import org.jboss.resteasy.microprofile.client.RestClientProxy;
import org.jboss.resteasy.microprofile.client.async.AsyncInvocationInterceptorHandler;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderFillingException;

public class ProxyInvocationHandler
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getLogger(ProxyInvocationHandler.class);
    public static final Type[] NO_TYPES = new Type[0];
    private final Object target;
    private final Set<Object> providerInstances;
    private final Map<Method, List<InvocationContextImpl.InterceptorInvocation>> interceptorChains;
    private final ResteasyClient client;
    private final CreationalContext<?> creationalContext;
    private final AtomicBoolean closed;
    private final List<AsyncInvocationInterceptorFactory> asyncInterceptorFactories;

    public ProxyInvocationHandler(Class<?> restClientInterface, Object target, Set<Object> providerInstances, ResteasyClient client, List<AsyncInvocationInterceptorFactory> asyncInterceptorFactories) {
        this.target = target;
        this.providerInstances = providerInstances;
        this.client = client;
        this.asyncInterceptorFactories = asyncInterceptorFactories;
        this.closed = new AtomicBoolean();
        BeanManager beanManager = ProxyInvocationHandler.getBeanManager(restClientInterface);
        if (beanManager != null) {
            this.creationalContext = beanManager.createCreationalContext(null);
            this.interceptorChains = ProxyInvocationHandler.initInterceptorChains(beanManager, this.creationalContext, restClientInterface);
        } else {
            this.creationalContext = null;
            this.interceptorChains = Collections.emptyMap();
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        List<InvocationContextImpl.InterceptorInvocation> chain;
        if (RestClientProxy.class.equals(method.getDeclaringClass())) {
            return this.invokeRestClientProxyMethod(proxy, method, args);
        }
        if (method.getName().equals("close") && (args == null || args.length == 0)) {
            this.close();
            return null;
        }
        if (this.closed.get()) {
            throw new IllegalStateException("RestClientProxy is closed");
        }
        this.prepareAsyncInterceptors();
        boolean replacementNeeded = false;
        Object[] argsReplacement = args != null ? new Object[args.length] : null;
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (Object p : this.providerInstances) {
            if (!(p instanceof ParamConverterProvider)) continue;
            int index = 0;
            for (Object arg : args) {
                block26: {
                    block25: {
                        Type[] genericTypes;
                        if (parameterAnnotations[index].length <= 0) break block25;
                        ParamConverter converter = ((ParamConverterProvider)p).getConverter(arg.getClass(), null, parameterAnnotations[index]);
                        if (converter == null || (genericTypes = this.getGenericTypes(converter.getClass())).length != 1) break block26;
                        switch (genericTypes[0].getTypeName()) {
                            case "java.lang.String": {
                                ParamConverter stringConverter = converter;
                                argsReplacement[index] = stringConverter.toString((Object)((String)arg));
                                replacementNeeded = true;
                                break block26;
                            }
                            case "java.lang.Integer": {
                                ParamConverter intConverter = converter;
                                argsReplacement[index] = intConverter.toString((Object)((Integer)arg));
                                replacementNeeded = true;
                                break block26;
                            }
                            case "java.lang.Boolean": {
                                ParamConverter boolConverter = converter;
                                argsReplacement[index] = boolConverter.toString((Object)((Boolean)arg));
                                replacementNeeded = true;
                                break block26;
                            }
                        }
                        continue;
                    }
                    argsReplacement[index] = arg;
                }
                ++index;
            }
        }
        if (replacementNeeded) {
            args = argsReplacement;
        }
        if ((chain = this.interceptorChains.get(method)) != null) {
            return new InvocationContextImpl(this.target, method, args, chain).proceed();
        }
        try {
            return method.invoke(this.target, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ExceptionMapping.HandlerException) {
                ((ExceptionMapping.HandlerException)((Object)e.getCause())).mapException(method);
            }
            if (e.getCause() instanceof ResponseProcessingException) {
                ResponseProcessingException rpe = (ResponseProcessingException)e.getCause();
                Throwable cause = rpe.getCause();
                if (cause instanceof RuntimeException) {
                    throw cause;
                }
            } else {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof ProcessingException && targetException.getCause() instanceof ClientHeaderFillingException) {
                    throw targetException.getCause().getCause();
                }
                if (targetException instanceof RuntimeException) {
                    throw targetException;
                }
            }
            throw e;
        }
    }

    private void prepareAsyncInterceptors() {
        List<AsyncInvocationInterceptor> interceptors = this.asyncInterceptorFactories.stream().map(AsyncInvocationInterceptorFactory::newInterceptor).collect(Collectors.toList());
        interceptors.forEach(AsyncInvocationInterceptor::prepareContext);
        AsyncInvocationInterceptorHandler.register(interceptors);
    }

    private Object invokeRestClientProxyMethod(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "getClient": {
                return this.client;
            }
            case "close": {
                this.close();
                return null;
            }
        }
        throw new IllegalStateException("Unsupported RestClientProxy method: " + method);
    }

    private void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.creationalContext != null) {
                this.creationalContext.release();
            }
            this.client.close();
        }
    }

    private Type[] getGenericTypes(Class<?> aClass) {
        Type[] genericInterfaces = aClass.getGenericInterfaces();
        Type[] genericTypes = NO_TYPES;
        for (Type genericInterface : genericInterfaces) {
            if (!(genericInterface instanceof ParameterizedType)) continue;
            genericTypes = ((ParameterizedType)genericInterface).getActualTypeArguments();
        }
        return genericTypes;
    }

    private static List<Annotation> getBindings(Annotation[] annotations, BeanManager beanManager) {
        if (annotations.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Annotation> bindings = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            if (!beanManager.isInterceptorBinding(annotation.annotationType())) continue;
            bindings.add(annotation);
        }
        return bindings;
    }

    private static BeanManager getBeanManager(Class<?> restClientInterface) {
        try {
            CDI current = CDI.current();
            return current != null ? current.getBeanManager() : null;
        }
        catch (IllegalStateException e) {
            LOGGER.warnf("CDI container is not available - interceptor bindings declared on %s will be ignored", (Object)restClientInterface.getSimpleName());
            return null;
        }
    }

    private static Map<Method, List<InvocationContextImpl.InterceptorInvocation>> initInterceptorChains(BeanManager beanManager, CreationalContext<?> creationalContext, Class<?> restClientInterface) {
        HashMap chains = new HashMap();
        HashMap<Interceptor, Object> interceptorInstances = new HashMap<Interceptor, Object>();
        List<Annotation> classLevelBindings = ProxyInvocationHandler.getBindings(restClientInterface.getAnnotations(), beanManager);
        for (Method method : restClientInterface.getMethods()) {
            Annotation[] interceptorBindings;
            List interceptors;
            if (method.isDefault() || Modifier.isStatic(method.getModifiers())) continue;
            List<Annotation> methodLevelBindings = ProxyInvocationHandler.getBindings(method.getAnnotations(), beanManager);
            if (classLevelBindings.isEmpty() && methodLevelBindings.isEmpty() || (interceptors = beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, interceptorBindings = ProxyInvocationHandler.merge(methodLevelBindings, classLevelBindings))).isEmpty()) continue;
            ArrayList<InvocationContextImpl.InterceptorInvocation> chain = new ArrayList<InvocationContextImpl.InterceptorInvocation>();
            for (Interceptor interceptor : interceptors) {
                chain.add(new InvocationContextImpl.InterceptorInvocation(interceptor, interceptorInstances.computeIfAbsent(interceptor, i -> beanManager.getReference((Bean)i, (Type)i.getBeanClass(), creationalContext))));
            }
            chains.put(method, chain);
        }
        return chains.isEmpty() ? Collections.emptyMap() : chains;
    }

    private static Annotation[] merge(List<Annotation> methodLevelBindings, List<Annotation> classLevelBindings) {
        Set types = methodLevelBindings.stream().map(a -> a.annotationType()).collect(Collectors.toSet());
        ArrayList<Annotation> merged = new ArrayList<Annotation>(methodLevelBindings);
        for (Annotation annotation : classLevelBindings) {
            if (types.contains(annotation.annotationType())) continue;
            merged.add(annotation);
        }
        return merged.toArray(new Annotation[0]);
    }
}

