/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.data.attestation.statement.TPMAObject;
import com.webauthn4j.data.attestation.statement.TPMIAlgHash;
import com.webauthn4j.data.attestation.statement.TPMIAlgPublic;
import com.webauthn4j.data.attestation.statement.TPMUPublicId;
import com.webauthn4j.data.attestation.statement.TPMUPublicParms;
import com.webauthn4j.data.attestation.statement.TPMUtil;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Objects;

public class TPMTPublic
implements Serializable {
    private TPMIAlgPublic type;
    private TPMIAlgHash nameAlg;
    private TPMAObject objectAttributes;
    private byte[] authPolicy;
    private TPMUPublicParms parameters;
    private TPMUPublicId unique;

    public TPMTPublic(TPMIAlgPublic type, TPMIAlgHash nameAlg, TPMAObject objectAttributes, byte[] authPolicy, TPMUPublicParms parameters, TPMUPublicId unique) {
        this.type = type;
        this.nameAlg = nameAlg;
        this.objectAttributes = objectAttributes;
        this.authPolicy = authPolicy;
        this.parameters = parameters;
        this.unique = unique;
    }

    public TPMIAlgPublic getType() {
        return this.type;
    }

    public TPMIAlgHash getNameAlg() {
        return this.nameAlg;
    }

    public TPMAObject getObjectAttributes() {
        return this.objectAttributes;
    }

    public byte[] getAuthPolicy() {
        return ArrayUtil.clone((byte[])this.authPolicy);
    }

    public TPMUPublicParms getParameters() {
        return this.parameters;
    }

    public TPMUPublicId getUnique() {
        return this.unique;
    }

    public byte[] getBytes() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            int typeValue = this.type.getValue();
            stream.write(UnsignedNumberUtil.toBytes((int)typeValue));
            int nameAlgValue = this.getNameAlg().getValue();
            stream.write(UnsignedNumberUtil.toBytes((int)nameAlgValue));
            stream.write(this.getObjectAttributes().getBytes());
            TPMUtil.writeSizedArray(stream, this.getAuthPolicy());
            stream.write(this.getParameters().getBytes());
            stream.write(this.getUnique().getBytes());
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMTPublic that = (TPMTPublic)o;
        return this.type == that.type && this.nameAlg == that.nameAlg && Objects.equals(this.objectAttributes, that.objectAttributes) && Arrays.equals(this.authPolicy, that.authPolicy) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.unique, that.unique);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.type, this.nameAlg, this.objectAttributes, this.parameters, this.unique});
        result = 31 * result + Arrays.hashCode(this.authPolicy);
        return result;
    }
}

