/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

public class DefaultRoles {
    public static Set<RoleModel> getDefaultRoles(RealmModel realm) {
        HashSet<RoleModel> set = new HashSet<RoleModel>();
        for (String r : realm.getDefaultRoles()) {
            set.add(realm.getRole(r));
        }
        for (ClientModel application : realm.getClients()) {
            for (String r : application.getDefaultRoles()) {
                set.add(application.getRole(r));
            }
        }
        return set;
    }

    public static void addDefaultRoles(RealmModel realm, UserModel userModel) {
        for (RoleModel role : DefaultRoles.getDefaultRoles(realm)) {
            userModel.grantRole(role);
        }
    }
}

