/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.jca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class JDBCDriverNameProvider
implements DefaultCompleter.CandidatesProvider {
    public static final JDBCDriverNameProvider INSTANCE = new JDBCDriverNameProvider();

    @Override
    public Collection<String> getAllCandidates(CommandContext ctx) {
        ModelNode response;
        if (ctx.isDomainMode()) {
            return Collections.emptyList();
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            return Collections.emptyList();
        }
        ModelNode req = new ModelNode();
        req.get("operation").set("installed-drivers-list");
        ModelNode address = req.get("address");
        address.add("subsystem", "datasources");
        try {
            response = client.execute(req);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        if (!response.hasDefined("result")) {
            return Collections.emptyList();
        }
        List nodeList = response.get("result").asList();
        ArrayList<String> names = new ArrayList<String>(nodeList.size());
        for (ModelNode node : nodeList) {
            if (!node.has("driver-name")) continue;
            names.add(node.get("driver-name").asString());
        }
        return names;
    }
}

