/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.monitoring;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.ws.api.monitoring.Record;
import org.jboss.ws.api.monitoring.RecordFilter;

public class HostFilter
implements RecordFilter {
    private static final long serialVersionUID = -5935962601380315102L;
    private final List<String> hosts;
    private final boolean source;

    public HostFilter(String host, boolean source) {
        this.hosts = Collections.singletonList(host);
        this.source = source;
    }

    public HostFilter(Collection<String> hosts, boolean source) {
        this.hosts = Collections.unmodifiableList(new LinkedList<String>(hosts));
        this.source = source;
    }

    public boolean match(Record record) {
        for (String host : this.hosts) {
            if ((!this.source || !host.equalsIgnoreCase(record.getSourceHost())) && (this.source || !host.equalsIgnoreCase(record.getDestinationHost()))) continue;
            return true;
        }
        return false;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public boolean isSource() {
        return this.source;
    }

    public Object clone() throws CloneNotSupportedException {
        return new HostFilter(this.hosts, this.source);
    }
}

