/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom.output.support;

import org.jetbrains.kotlin.org.jdom.output.EscapeStrategy;
import org.jetbrains.kotlin.org.jdom.output.Format;

public final class FormatStack {
    private int capacity = 16;
    private int depth = 0;
    private final Format.TextMode defaultMode;
    private final String indent;
    private final String encoding;
    private final String lineSeparator;
    private final boolean omitDeclaration;
    private final boolean omitEncoding;
    private final boolean expandEmptyElements;
    private final boolean specifiedAttributesOnly;
    private final EscapeStrategy escapeStrategy;
    private String[] levelIndent = new String[this.capacity];
    private String[] levelEOL = new String[this.capacity];
    private String[] levelEOLIndent = new String[this.capacity];
    private String[] termEOLIndent = new String[this.capacity];
    private boolean[] ignoreTrAXEscapingPIs = new boolean[this.capacity];
    private Format.TextMode[] mode = new Format.TextMode[this.capacity];
    private boolean[] escapeOutput = new boolean[this.capacity];

    public FormatStack(Format format) {
        this.indent = format.getIndent();
        this.lineSeparator = format.getLineSeparator();
        this.encoding = format.getEncoding();
        this.omitDeclaration = format.getOmitDeclaration();
        this.omitEncoding = format.getOmitEncoding();
        this.expandEmptyElements = format.getExpandEmptyElements();
        this.escapeStrategy = format.getEscapeStrategy();
        this.defaultMode = format.getTextMode();
        this.specifiedAttributesOnly = format.isSpecifiedAttributesOnly();
        this.mode[this.depth] = format.getTextMode();
        if (this.mode[this.depth] == Format.TextMode.PRESERVE) {
            this.levelIndent[this.depth] = null;
            this.levelEOL[this.depth] = null;
            this.levelEOLIndent[this.depth] = null;
            this.termEOLIndent[this.depth] = null;
        } else {
            this.levelIndent[this.depth] = format.getIndent() == null ? null : "";
            this.levelEOL[this.depth] = format.getLineSeparator();
            this.levelEOLIndent[this.depth] = this.levelIndent[this.depth] == null ? null : this.levelEOL[this.depth];
            this.termEOLIndent[this.depth] = this.levelEOLIndent[this.depth];
        }
        this.ignoreTrAXEscapingPIs[this.depth] = format.getIgnoreTrAXEscapingPIs();
        this.escapeOutput[this.depth] = true;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public boolean isIgnoreTrAXEscapingPIs() {
        return this.ignoreTrAXEscapingPIs[this.depth];
    }

    public void setIgnoreTrAXEscapingPIs(boolean ignoreTrAXEscapingPIs) {
        this.ignoreTrAXEscapingPIs[this.depth] = ignoreTrAXEscapingPIs;
    }

    public void setEscapeOutput(boolean escape) {
        this.escapeOutput[this.depth] = escape;
    }
}

