/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.base.Objects;
import java.io.IOException;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.BuildIdentifierSerializer;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultLibraryBinaryIdentifier;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.util.Path;

public class ComponentIdentifierSerializer
extends AbstractSerializer<ComponentIdentifier> {
    private final BuildIdentifierSerializer buildIdentifierSerializer = new BuildIdentifierSerializer();

    public ComponentIdentifier read(Decoder decoder) throws IOException {
        byte id = decoder.readByte();
        if (Implementation.ROOT_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            String projectName = decoder.readString();
            return new DefaultProjectComponentIdentifier(buildIdentifier, Path.ROOT, Path.ROOT, projectName);
        }
        if (Implementation.ROOT_BUILD_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            Path projectPath = Path.path((String)decoder.readString());
            return new DefaultProjectComponentIdentifier(buildIdentifier, projectPath, projectPath, projectPath.getName());
        }
        if (Implementation.OTHER_BUILD_ROOT_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            Path identityPath = Path.path((String)decoder.readString());
            return new DefaultProjectComponentIdentifier(buildIdentifier, identityPath, Path.ROOT, identityPath.getName());
        }
        if (Implementation.OTHER_BUILD_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            Path identityPath = Path.path((String)decoder.readString());
            Path projectPath = Path.path((String)decoder.readString());
            return new DefaultProjectComponentIdentifier(buildIdentifier, identityPath, projectPath, identityPath.getName());
        }
        if (Implementation.MODULE.getId() == id) {
            return new DefaultModuleComponentIdentifier(DefaultModuleIdentifier.newId(decoder.readString(), decoder.readString()), decoder.readString());
        }
        if (Implementation.SNAPSHOT.getId() == id) {
            return new MavenUniqueSnapshotComponentIdentifier(DefaultModuleIdentifier.newId(decoder.readString(), decoder.readString()), decoder.readString(), decoder.readString());
        }
        if (Implementation.LIBRARY.getId() == id) {
            return new DefaultLibraryBinaryIdentifier(decoder.readString(), decoder.readString(), decoder.readString());
        }
        throw new IllegalArgumentException("Unable to find component identifier type with id: " + id);
    }

    public void write(Encoder encoder, ComponentIdentifier value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Provided component identifier may not be null");
        }
        Implementation implementation = this.resolveImplementation(value);
        encoder.writeByte(implementation.getId());
        if (implementation == Implementation.MODULE) {
            ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)value;
            encoder.writeString((CharSequence)moduleComponentIdentifier.getGroup());
            encoder.writeString((CharSequence)moduleComponentIdentifier.getModule());
            encoder.writeString((CharSequence)moduleComponentIdentifier.getVersion());
        } else if (implementation == Implementation.SNAPSHOT) {
            MavenUniqueSnapshotComponentIdentifier snapshotIdentifier = (MavenUniqueSnapshotComponentIdentifier)value;
            encoder.writeString((CharSequence)snapshotIdentifier.getGroup());
            encoder.writeString((CharSequence)snapshotIdentifier.getModule());
            encoder.writeString((CharSequence)snapshotIdentifier.getVersion());
            encoder.writeString((CharSequence)snapshotIdentifier.getTimestamp());
        } else if (implementation == Implementation.ROOT_PROJECT) {
            ProjectComponentIdentifier projectComponentIdentifier = (ProjectComponentIdentifier)value;
            BuildIdentifier build = projectComponentIdentifier.getBuild();
            this.buildIdentifierSerializer.write(encoder, build);
            encoder.writeString((CharSequence)projectComponentIdentifier.getProjectName());
        } else if (implementation == Implementation.ROOT_BUILD_PROJECT) {
            ProjectComponentIdentifier projectComponentIdentifier = (ProjectComponentIdentifier)value;
            BuildIdentifier build = projectComponentIdentifier.getBuild();
            this.buildIdentifierSerializer.write(encoder, build);
            encoder.writeString((CharSequence)projectComponentIdentifier.getProjectPath());
        } else if (implementation == Implementation.OTHER_BUILD_ROOT_PROJECT) {
            DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)value;
            BuildIdentifier build = projectComponentIdentifier.getBuild();
            this.buildIdentifierSerializer.write(encoder, build);
            encoder.writeString((CharSequence)projectComponentIdentifier.getIdentityPath().getPath());
        } else if (implementation == Implementation.OTHER_BUILD_PROJECT) {
            DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)value;
            BuildIdentifier build = projectComponentIdentifier.getBuild();
            this.buildIdentifierSerializer.write(encoder, build);
            encoder.writeString((CharSequence)projectComponentIdentifier.getIdentityPath().getPath());
            encoder.writeString((CharSequence)projectComponentIdentifier.getProjectPath());
        } else if (implementation == Implementation.LIBRARY) {
            LibraryBinaryIdentifier libraryIdentifier = (LibraryBinaryIdentifier)value;
            encoder.writeString((CharSequence)libraryIdentifier.getProjectPath());
            encoder.writeString((CharSequence)libraryIdentifier.getLibraryName());
            encoder.writeString((CharSequence)libraryIdentifier.getVariant());
        } else {
            throw new IllegalStateException("Unsupported implementation type: " + (Object)((Object)implementation));
        }
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ComponentIdentifierSerializer rhs = (ComponentIdentifierSerializer)((Object)obj);
        return Objects.equal((Object)((Object)this.buildIdentifierSerializer), (Object)((Object)rhs.buildIdentifierSerializer));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.buildIdentifierSerializer});
    }

    private Implementation resolveImplementation(ComponentIdentifier value) {
        if (value instanceof MavenUniqueSnapshotComponentIdentifier) {
            return Implementation.SNAPSHOT;
        }
        if (value instanceof ModuleComponentIdentifier) {
            return Implementation.MODULE;
        }
        if (value instanceof DefaultProjectComponentIdentifier) {
            DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)value;
            boolean isARootProject = projectComponentIdentifier.projectPath().equals((Object)Path.ROOT);
            if (projectComponentIdentifier.getIdentityPath().equals((Object)Path.ROOT) && isARootProject) {
                return Implementation.ROOT_PROJECT;
            }
            if (projectComponentIdentifier.getIdentityPath().equals((Object)projectComponentIdentifier.projectPath()) && projectComponentIdentifier.projectPath().getName().equals(projectComponentIdentifier.getProjectName())) {
                return Implementation.ROOT_BUILD_PROJECT;
            }
            if (isARootProject && projectComponentIdentifier.getProjectName().equals(projectComponentIdentifier.getIdentityPath().getName())) {
                return Implementation.OTHER_BUILD_ROOT_PROJECT;
            }
            return Implementation.OTHER_BUILD_PROJECT;
        }
        if (value instanceof LibraryBinaryIdentifier) {
            return Implementation.LIBRARY;
        }
        throw new IllegalArgumentException("Unsupported component identifier class: " + value.getClass());
    }

    private static enum Implementation {
        MODULE(1),
        ROOT_PROJECT(2),
        ROOT_BUILD_PROJECT(3),
        OTHER_BUILD_ROOT_PROJECT(4),
        OTHER_BUILD_PROJECT(5),
        LIBRARY(6),
        SNAPSHOT(7);

        private final byte id;

        private Implementation(int id) {
            this.id = (byte)id;
        }

        private byte getId() {
            return this.id;
        }
    }
}

