/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchResultPage;
import org.eclipse.wst.jsdt.internal.ui.search.SearchLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredJavaElementLabels;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class SortingLabelProvider
extends SearchLabelProvider {
    public static final int SHOW_ELEMENT_CONTAINER = 1;
    public static final int SHOW_CONTAINER_ELEMENT = 2;
    public static final int SHOW_PATH = 3;
    private static final long FLAGS_QUALIFIED = 36065220642538634L;
    private int fCurrentOrder = 1;

    public SortingLabelProvider(JavaSearchResultPage page) {
        super(page);
    }

    @Override
    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof IJavaScriptElement || element instanceof IResource) {
            image = super.getImage(element);
        }
        if (image != null) {
            return image;
        }
        return this.getParticipantImage(element);
    }

    @Override
    public final String getText(Object element) {
        String text;
        if (element instanceof IImportDeclaration) {
            element = ((IImportDeclaration)element).getParent().getParent();
        }
        if ((text = super.getText(element)).length() > 0) {
            String labelWithCount = this.getLabelWithCounts(element, text);
            if (this.fCurrentOrder == 1) {
                labelWithCount = String.valueOf(labelWithCount) + this.getPostQualification(element, text);
            }
            return labelWithCount;
        }
        return this.getParticipantText(element);
    }

    @Override
    public ColoredString getRichTextLabel(Object element) {
        ColoredString text;
        if (element instanceof IImportDeclaration) {
            element = ((IImportDeclaration)element).getParent().getParent();
        }
        if ((text = super.getRichTextLabel(element)).length() > 0) {
            ColoredString countLabel = this.getColoredLabelWithCounts(element, text);
            if (this.fCurrentOrder == 1) {
                countLabel.append(this.getPostQualification(element, text.getString()), ColoredJavaElementLabels.QUALIFIER_STYLE);
            }
            return countLabel;
        }
        return new ColoredString(this.getParticipantText(element));
    }

    private String getPostQualification(Object element, String text) {
        String textLabel = JavaScriptElementLabels.getTextLabel(element, 4471364126976L);
        int indexOf = textLabel.indexOf(JavaScriptElementLabels.CONCAT_STRING);
        if (indexOf != -1) {
            return textLabel.substring(indexOf);
        }
        return new String();
    }

    public void setOrder(int orderFlag) {
        this.fCurrentOrder = orderFlag;
        long flags = 0L;
        if (orderFlag == 1) {
            flags = 36421324767242L;
        } else if (orderFlag == 2) {
            flags = 36065220642538634L;
        } else if (orderFlag == 3) {
            flags = 36082812828583050L;
        }
        this.setTextFlags(flags);
    }
}

