/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.embedder.MavenRuntimeManager;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.wtp.MarkedException;

public abstract class AbstractDependencyConfigurator {
    public static final String ATTR_ID = "id";
    public static final String ATTR_PRIORITY = "priority";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CLASS = "class";
    private int priority;
    private String id;
    private String name;
    protected IMavenProjectRegistry projectManager;
    protected MavenRuntimeManager runtimeManager;
    protected IMavenMarkerManager markerManager;

    public void setProjectManager(IMavenProjectRegistry projectManager) {
        this.projectManager = projectManager;
    }

    public void setRuntimeManager(MavenRuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
    }

    public void setMarkerManager(IMavenMarkerManager markerManager) {
        this.markerManager = markerManager;
    }

    public abstract void configureDependency(MavenProject var1, IProject var2, MavenProject var3, IProject var4, IProgressMonitor var5) throws MarkedException;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.id = config.getAttribute(ATTR_ID);
        this.name = config.getAttribute(ATTR_NAME);
        String priorityString = config.getAttribute(ATTR_PRIORITY);
        try {
            this.priority = Integer.parseInt(priorityString);
        }
        catch (Exception ex) {
            this.priority = Integer.MAX_VALUE;
        }
    }

    protected void addNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature(natureId)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
            newNatures[0] = natureId;
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }

    public String toString() {
        return String.valueOf(this.id) + ":" + this.name + "(" + this.priority + ")";
    }

    public void init() {
    }
}

