/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterable;

import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class ChainIterable<E>
implements Iterable<E> {
    private final E first;
    private final Transformer<? super E, ? extends E> transformer;

    public ChainIterable(E first, Transformer<? super E, ? extends E> transformer) {
        if (transformer == null) {
            throw new NullPointerException();
        }
        this.first = first;
        this.transformer = transformer;
    }

    @Override
    public Iterator<E> iterator() {
        return IteratorTools.chainIterator(this.first, this.transformer);
    }

    public String toString() {
        return ListTools.arrayList(this).toString();
    }
}

