/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.impl;

import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;

public class LongConstant
extends Constant {
    private static final LongConstant ZERO = new LongConstant(0L);
    private long value;

    public static Constant fromValue(long value) {
        if (value == 0L) {
            return ZERO;
        }
        return new LongConstant(value);
    }

    private LongConstant(long value) {
        this.value = value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public char charValue() {
        return (char)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public String stringValue() {
        return String.valueOf(this.value);
    }

    @Override
    public String toString() {
        return "(long)" + this.value;
    }

    @Override
    public int typeID() {
        return 7;
    }
}

