/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.predicates.impl;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.predicates.BuilderPredicate;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.impl.PredicateImpl;

public class BuilderPredicateImpl
extends PredicateImpl
implements BuilderPredicate {
    protected static final String BUILDER_EDEFAULT = null;
    protected String builder = BUILDER_EDEFAULT;

    protected BuilderPredicateImpl() {
    }

    protected EClass eStaticClass() {
        return PredicatesPackage.Literals.BUILDER_PREDICATE;
    }

    public String getBuilder() {
        return this.builder;
    }

    public void setBuilder(String newBuilder) {
        String oldBuilder = this.builder;
        this.builder = newBuilder;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldBuilder, (Object)this.builder));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean matches(IResource resource) {
        if (resource == null) return false;
        String builder = this.getBuilder();
        if (builder == null) return false;
        IProject project = resource.getProject();
        try {
            ICommand[] iCommandArray = project.getDescription().getBuildSpec();
            int n = iCommandArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ICommand command = iCommandArray[n2];
                String name = command.getBuilderName();
                if (builder.equals(name)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getBuilder();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setBuilder((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setBuilder(BUILDER_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return BUILDER_EDEFAULT == null ? this.builder != null : !BUILDER_EDEFAULT.equals(this.builder);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (builder: ");
        result.append(this.builder);
        result.append(')');
        return result.toString();
    }
}

