/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.model.access.DBAPrivilegeType;

public enum PostgrePrivilegeType implements DBAPrivilegeType
{
    ALL(' ', false, Object.class),
    SELECT('r', true, PostgreTableBase.class, PostgreTableColumn.class),
    INSERT('a', true, PostgreTableReal.class, PostgreTableColumn.class),
    UPDATE('w', true, PostgreTableBase.class, PostgreTableColumn.class),
    DELETE('d', true, PostgreTableReal.class, PostgreTableColumn.class),
    TRUNCATE('D', true, PostgreTableReal.class),
    REFERENCES('x', true, PostgreTableReal.class, PostgreTableColumn.class),
    TRIGGER('t', true, PostgreTableReal.class),
    USAGE('U', true, PostgreSequence.class),
    EXECUTE('X', true, PostgreProcedure.class),
    UNKNOWN('\u0000', false, new Class[0]);

    private final Class<?>[] targetType;
    private final char code;
    private final boolean valid;

    private PostgrePrivilegeType(char code, boolean valid, Class<?> ... targetType) {
        this.code = code;
        this.valid = valid;
        this.targetType = targetType;
    }

    public char getCode() {
        return this.code;
    }

    public Class<?>[] getTargetType() {
        return this.targetType;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean supportsType(Class<?> objectType) {
        int i = 0;
        while (i < this.targetType.length) {
            if (this.targetType[i].isAssignableFrom(objectType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getName() {
        return this.name();
    }

    public static PostgrePrivilegeType fromString(String type) {
        try {
            return PostgrePrivilegeType.valueOf(type);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return UNKNOWN;
        }
    }

    public static PostgrePrivilegeType getByCode(char pCode) {
        PostgrePrivilegeType[] postgrePrivilegeTypeArray = PostgrePrivilegeType.values();
        int n = postgrePrivilegeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PostgrePrivilegeType pt = postgrePrivilegeTypeArray[n2];
            if (pt.getCode() == pCode) {
                return pt;
            }
            ++n2;
        }
        return UNKNOWN;
    }
}

