"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareEmojiReactionsController = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _emojiReactionsView = _interopRequireDefault(require("../views/emoji-reactions-view"));

var _addReaction = _interopRequireDefault(require("../mutations/add-reaction"));

var _removeReaction = _interopRequireDefault(require("../mutations/remove-reaction"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareEmojiReactionsController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "addReaction", async content => {
      try {
        await (0, _addReaction["default"])(this.props.relay.environment, this.props.reactable.id, content);
      } catch (err) {
        this.props.reportRelayError('Unable to add reaction emoji', err);
      }
    });

    _defineProperty(this, "removeReaction", async content => {
      try {
        await (0, _removeReaction["default"])(this.props.relay.environment, this.props.reactable.id, content);
      } catch (err) {
        this.props.reportRelayError('Unable to remove reaction emoji', err);
      }
    });
  }

  render() {
    return _react["default"].createElement(_emojiReactionsView["default"], _extends({
      addReaction: this.addReaction,
      removeReaction: this.removeReaction
    }, this.props));
  }

}

exports.BareEmojiReactionsController = BareEmojiReactionsController;

_defineProperty(BareEmojiReactionsController, "propTypes", {
  relay: _propTypes["default"].shape({
    environment: _propTypes["default"].object.isRequired
  }).isRequired,
  reactable: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  }).isRequired,
  // Atom environment
  tooltips: _propTypes["default"].object.isRequired,
  // Action methods
  reportRelayError: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareEmojiReactionsController, {
  reactable: function () {
    const node = require("./__generated__/emojiReactionsController_reactable.graphql");

    if (node.hash && node.hash !== "cfdd39cd7aa02bce0bdcd52bc0154223") {
      console.error("The definition of 'emojiReactionsController_reactable' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/emojiReactionsController_reactable.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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