"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _reporterProxy = require("../reporter-proxy");

var _propTypes2 = require("../prop-types");

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _keytarStrategy = require("../shared/keytar-strategy");

var _remoteController = _interopRequireDefault(require("../controllers/remote-controller"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _queryErrorView = _interopRequireDefault(require("../views/query-error-view"));

var _githubLoginView = _interopRequireDefault(require("../views/github-login-view"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RemoteContainer extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "fetchToken", loginModel => {
      return loginModel.getToken(this.props.endpoint.getLoginAccount());
    });

    _defineProperty(this, "renderWithToken", token => {
      if (token === null) {
        return _react["default"].createElement(_loadingView["default"], null);
      }

      if (token instanceof Error) {
        return _react["default"].createElement(_queryErrorView["default"], {
          error: token,
          retry: this.handleTokenRetry,
          login: this.handleLogin,
          logout: this.handleLogout
        });
      }

      if (token === _keytarStrategy.UNAUTHENTICATED) {
        return _react["default"].createElement(_githubLoginView["default"], {
          onLogin: this.handleLogin
        });
      }

      if (token === _keytarStrategy.INSUFFICIENT) {
        return _react["default"].createElement(_githubLoginView["default"], {
          onLogin: this.handleLogin
        }, _react["default"].createElement("p", null, "Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one."));
      }

      const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(this.props.endpoint, token);

      const query = _graphql || (_graphql = function () {
        const node = require("./__generated__/remoteContainerQuery.graphql");

        if (node.hash && node.hash !== "b83aa6c27c5d7e1c499badf2e6bfab6b") {
          console.error("The definition of 'remoteContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
        }

        return require("./__generated__/remoteContainerQuery.graphql");
      });

      const variables = {
        owner: this.props.remote.getOwner(),
        name: this.props.remote.getRepo()
      };
      return _react["default"].createElement(_reactRelay.QueryRenderer, {
        environment: environment,
        variables: variables,
        query: query,
        render: result => this.renderWithResult(result, token)
      });
    });

    _defineProperty(this, "handleLogin", token => {
      (0, _reporterProxy.incrementCounter)('github-login');
      this.props.loginModel.setToken(this.props.endpoint.getLoginAccount(), token);
    });

    _defineProperty(this, "handleLogout", () => {
      (0, _reporterProxy.incrementCounter)('github-logout');
      this.props.loginModel.removeToken(this.props.endpoint.getLoginAccount());
    });

    _defineProperty(this, "handleTokenRetry", () => this.props.loginModel.didUpdate());
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.loginModel,
      fetchData: this.fetchToken
    }, this.renderWithToken);
  }

  renderWithResult({
    error,
    props,
    retry
  }, token) {
    if (error) {
      return _react["default"].createElement(_queryErrorView["default"], {
        error: error,
        login: this.handleLogin,
        retry: retry,
        logout: this.handleLogout
      });
    }

    if (props === null) {
      return _react["default"].createElement(_loadingView["default"], null);
    }

    return _react["default"].createElement(_remoteController["default"], {
      endpoint: this.props.endpoint,
      token: token,
      repository: props.repository,
      remoteOperationObserver: this.props.remoteOperationObserver,
      workingDirectory: this.props.workingDirectory,
      workspace: this.props.workspace,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onPushBranch: this.props.onPushBranch
    });
  }

}

exports["default"] = RemoteContainer;

_defineProperty(RemoteContainer, "propTypes", {
  // Connection
  loginModel: _propTypes["default"].object.isRequired,
  endpoint: _propTypes2.EndpointPropType.isRequired,
  // Repository attributes
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  pushInProgress: _propTypes["default"].bool.isRequired,
  workingDirectory: _propTypes["default"].string,
  workspace: _propTypes["default"].object.isRequired,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes["default"].number,
  // Action methods
  onPushBranch: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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