/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries.ui;

import cc.arduino.contributions.DownloadableContributionVersionComparator;
import cc.arduino.contributions.VersionComparator;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.ContributedLibraryReleases;
import cc.arduino.contributions.libraries.ui.ContributedLibraryTableCellJPanel;
import cc.arduino.contributions.ui.InstallerTableCell;
import cc.arduino.utils.ReverseComparator;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.swing.JComboBox;
import javax.swing.JTable;
import processing.app.I18n;

public class ContributedLibraryTableCellEditor
extends InstallerTableCell {
    private ContributedLibraryReleases editorValue;
    private ContributedLibraryTableCellJPanel editorCell;

    @Override
    public Object getCellEditorValue() {
        return this.editorValue;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editorValue = (ContributedLibraryReleases)value;
        this.editorCell = new ContributedLibraryTableCellJPanel(table, value, true);
        this.editorCell.installButton.addActionListener(e -> this.onInstall(this.editorValue.getSelected(), this.editorValue.getInstalled()));
        this.editorCell.downgradeButton.addActionListener(e -> {
            JComboBox chooser = this.editorCell.downgradeChooser;
            ContributedLibrary lib = (ContributedLibrary)chooser.getSelectedItem();
            this.onInstall(lib, this.editorValue.getInstalled());
        });
        this.editorCell.versionToInstallChooser.addActionListener(e -> {
            this.editorValue.select((ContributedLibrary)this.editorCell.versionToInstallChooser.getSelectedItem());
            if (this.editorCell.versionToInstallChooser.getSelectedIndex() != 0) {
                InstallerTableCell.dropdownSelected(true);
            }
        });
        this.setEnabled(true);
        Optional mayInstalled = this.editorValue.getInstalled();
        List releases = this.editorValue.getReleases();
        LinkedList notInstalled = new LinkedList(releases);
        if (mayInstalled.isPresent()) {
            notInstalled.remove(this.editorValue.getInstalled().get());
        }
        Collections.sort(notInstalled, new ReverseComparator((Comparator)new DownloadableContributionVersionComparator()));
        this.editorCell.downgradeChooser.removeAllItems();
        this.editorCell.downgradeChooser.addItem(I18n.tr((String)"Select version"));
        LinkedList notInstalledPrevious = new LinkedList();
        LinkedList notInstalledNewer = new LinkedList();
        notInstalled.stream().forEach(input -> {
            if (!mayInstalled.isPresent() || VersionComparator.greaterThan((ContributedLibrary)((ContributedLibrary)mayInstalled.get()), (ContributedLibrary)input)) {
                notInstalledPrevious.add(input);
            } else {
                notInstalledNewer.add(input);
            }
        });
        notInstalledNewer.forEach(this.editorCell.downgradeChooser::addItem);
        notInstalledPrevious.forEach(this.editorCell.downgradeChooser::addItem);
        this.editorCell.downgradeChooser.setVisible(mayInstalled.isPresent() && (!notInstalledPrevious.isEmpty() || notInstalledNewer.size() > 1));
        this.editorCell.downgradeButton.setVisible(mayInstalled.isPresent() && (!notInstalledPrevious.isEmpty() || notInstalledNewer.size() > 1));
        this.editorCell.versionToInstallChooser.removeAllItems();
        notInstalled.forEach(this.editorCell.versionToInstallChooser::addItem);
        this.editorCell.versionToInstallChooser.setVisible(!mayInstalled.isPresent() && notInstalled.size() > 1);
        this.editorCell.setBackground(new Color(218, 227, 227));
        return this.editorCell;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.editorCell.setButtonsVisible(enabled);
    }

    @Override
    public void setStatus(String status) {
        this.editorCell.statusLabel.setText(status);
    }

    protected void onRemove(ContributedLibrary selected) {
    }

    protected void onInstall(ContributedLibrary selected, Optional<ContributedLibrary> mayInstalled) {
    }
}

