/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;

public class TextOutlineRenderer {
    private Image img;
    private Font font;
    private Color outlineColor;
    private final String text;

    public TextOutlineRenderer(Font f, String s) {
        this.font = f;
        this.outlineColor = Color.black;
        this.text = s;
    }

    public TextOutlineRenderer(Font f, String s, Color textOutline) {
        this(f, s);
        this.outlineColor = textOutline;
    }

    public int getWidth() {
        if (this.img == null) {
            return -1;
        }
        return this.img.getWidth(null);
    }

    public int getHeight() {
        if (this.img == null) {
            return -1;
        }
        return this.img.getHeight(null);
    }

    public Rectangle cutTo(Graphics2D g2, int x, int y) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout tl = new TextLayout(this.getText(), this.getFont(), frc);
        float sw = (float)tl.getBounds().getWidth();
        AffineTransform transform = new AffineTransform();
        transform.setToTranslation(x, y);
        Shape shape = tl.getOutline(transform);
        Rectangle r = shape.getBounds();
        g2.setColor(this.getTextOutline());
        g2.draw(shape);
        g2.setClip(shape);
        g2.drawImage(this.getImg(), r.x, r.y, r.width, r.height, null);
        return r;
    }

    public Image getImg() {
        return this.img;
    }

    public void setImg(Image img) {
        this.img = img;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getTextOutline() {
        return this.outlineColor;
    }

    public void setTextOutline(Color textOutline) {
        this.outlineColor = textOutline;
    }

    public String getText() {
        return this.text;
    }
}

