/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.swing.JOptionPane;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

class KeystorePasswordAttempter {
    private static final char[] DEFAULT_PASSWORD = "changeit".toCharArray();
    static final KeystorePasswordAttempter INSTANCE = new KeystorePasswordAttempter(new SavedPassword(KeystorePasswordAttempter.getTrustedCertsPassword()));
    private final List<SavedPassword> passes;
    private final Map<KeyStore, SavedPassword> sucesfullPerKeystore = new HashMap<KeyStore, SavedPassword>();

    private static char[] getTrustedCertsPassword() {
        return DEFAULT_PASSWORD;
    }

    private KeystorePasswordAttempter(SavedPassword ... initialPasswords) {
        this.passes = new ArrayList<SavedPassword>(initialPasswords.length);
        this.passes.addAll(Arrays.asList(initialPasswords));
    }

    Key unlockKeystore(KeystoreOperation operation) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException {
        SavedPassword sucessfullKey = this.sucesfullPerKeystore.get(operation.ks);
        Exception firstEx = null;
        String messages = "";
        ArrayList<SavedPassword> localPases = new ArrayList<SavedPassword>();
        if (sucessfullKey != null) {
            localPases.add(sucessfullKey);
        }
        localPases.addAll(this.passes);
        for (int i = 0; i < localPases.size(); ++i) {
            SavedPassword pass = (SavedPassword)localPases.get(i);
            try {
                Key result = operation.operateKeystore(pass.pass);
                this.sucesfullPerKeystore.put(operation.ks, pass);
                return result;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
                String s;
                if (firstEx == null) {
                    firstEx = ex;
                }
                messages = messages + "'" + ex.getMessage() + "' ";
                OutputController.getLogger().log(ex);
                if (i + 1 != localPases.size()) continue;
                String s1 = Translator.R("KSresultUntilNow", messages, operation.getId(), i + 1);
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, s1);
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("KSinvalidPassword"));
                if (JNLPRuntime.isHeadless()) {
                    OutputController.getLogger().printOutLn(s1 + "\n" + Translator.R("KSheadlesWarning"));
                    s = OutputController.getLogger().readLine();
                    if (s == null || s.trim().isEmpty()) {
                        this.finish(firstEx);
                    }
                    this.addPnewPassword(s, localPases);
                } else {
                    s = JOptionPane.showInputDialog(s1 + "\n" + Translator.R("KSnwPassHelp"));
                    if (s == null) {
                        this.finish(firstEx);
                    }
                    this.addPnewPassword(s, localPases);
                }
                messages = "";
                continue;
            }
        }
        return null;
    }

    private void addPnewPassword(String s, List<SavedPassword> localPases) {
        SavedPassword users = new SavedPassword(s.toCharArray());
        this.passes.add(users);
        localPases.add(users);
    }

    private void finish(Exception ex) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException {
        if (ex instanceof KeyStoreException) {
            throw (KeyStoreException)ex;
        }
        if (ex instanceof NoSuchAlgorithmException) {
            throw (NoSuchAlgorithmException)ex;
        }
        if (ex instanceof UnrecoverableKeyException) {
            throw (UnrecoverableKeyException)ex;
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        if (ex instanceof CertificateException) {
            throw (CertificateException)ex;
        }
        throw new RuntimeException("Unexpected exception", ex);
    }

    static abstract class KeystoreOperation {
        protected final KeyManagerFactory kmf;
        protected final KeyStore ks;
        protected final String alias;
        protected final Key key;
        protected final Certificate[] certChain;
        protected final File f;

        public KeystoreOperation(KeyStore ks, File f) {
            this(null, ks, null, null, null, f);
        }

        public KeystoreOperation(KeyStore ks, String alias, Key key, Certificate[] certChain) {
            this(null, ks, alias, key, certChain, null);
        }

        public KeystoreOperation(KeyStore ks, String alias, Key key, Certificate[] certChain, File f) {
            this(null, ks, alias, key, certChain, f);
        }

        public KeystoreOperation(KeyManagerFactory kmf, KeyStore ks) {
            this(kmf, ks, null, null, null, null);
        }

        public KeystoreOperation(KeyManagerFactory kmf, KeyStore ks, String alias, Key key, Certificate[] certChain, File f) {
            this.kmf = kmf;
            this.ks = ks;
            this.alias = alias;
            this.key = key;
            this.certChain = certChain;
            this.f = f;
        }

        abstract Key operateKeystore(char[] var1) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException;

        abstract String getId();
    }

    static class AllmightyPassword
    extends SavedPassword {
        public AllmightyPassword() {
            super(null);
        }
    }

    static class SavedPassword {
        private final char[] pass;

        public SavedPassword(char[] pass) {
            this.pass = pass;
        }
    }
}

