/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AMDGPU target                          *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 44;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AMDGPUInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AMDGPUInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr&) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static AMDGPUInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AMDGPUInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_isGFX6Bit = 13,
  Feature_isGFX6GFX7Bit = 2,
  Feature_isGFX6GFX7GFX10Bit = 5,
  Feature_isGFX7OnlyBit = 28,
  Feature_isGFX7GFX8GFX9Bit = 9,
  Feature_isGFX6GFX7GFX8GFX9Bit = 19,
  Feature_isGFX7PlusBit = 4,
  Feature_isGFX8PlusBit = 0,
  Feature_isGFX8OnlyBit = 6,
  Feature_isGFX9PlusBit = 7,
  Feature_isGFX10PlusBit = 1,
  Feature_HasFlatAddressSpaceBit = 11,
  Feature_HasFlatGlobalInstsBit = 12,
  Feature_HasUnpackedD16VMemBit = 30,
  Feature_HasPackedD16VMemBit = 31,
  Feature_D16PreservesUnusedBitsBit = 29,
  Feature_LDSRequiresM0InitBit = 42,
  Feature_NotLDSRequiresM0InitBit = 43,
  Feature_HasAddNoCarryInstsBit = 18,
  Feature_Has16BitInstsBit = 3,
  Feature_HasVOP3PInstsBit = 34,
  Feature_HasMadMixInstsBit = 24,
  Feature_HasScalarStoresBit = 10,
  Feature_has16BankLDSBit = 15,
  Feature_has32BankLDSBit = 14,
  Feature_HasFmaMixInstsBit = 25,
  Feature_HasDLInstsBit = 41,
  Feature_HasDot1InstsBit = 27,
  Feature_HasDot2InstsBit = 26,
  Feature_HasDot3InstsBit = 23,
  Feature_HasDot4InstsBit = 22,
  Feature_HasDot5InstsBit = 20,
  Feature_HasDot6InstsBit = 21,
  Feature_HasMAIInstsBit = 8,
  Feature_EnableLateCFGStructurizeBit = 16,
  Feature_FP16DenormalsBit = 36,
  Feature_FP32DenormalsBit = 38,
  Feature_FP64DenormalsBit = 40,
  Feature_NoFP16DenormalsBit = 35,
  Feature_NoFP32DenormalsBit = 37,
  Feature_NoFP64DenormalsBit = 39,
  Feature_UnsafeFPMathBit = 33,
  Feature_isWave32Bit = 32,
  Feature_isWave64Bit = 17,
};

PredicateBitset AMDGPUInstructionSelector::
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS)
    Features.set(Feature_isGFX6Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX6GFX7Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7OnlyBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX6GFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7PlusBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8PlusBit);
  if (Subtarget->getGeneration() ==AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX9PlusBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10PlusBit);
  if (Subtarget->hasFlatAddressSpace())
    Features.set(Feature_HasFlatAddressSpaceBit);
  if (Subtarget->hasFlatGlobalInsts())
    Features.set(Feature_HasFlatGlobalInstsBit);
  if (Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasUnpackedD16VMemBit);
  if (!Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasPackedD16VMemBit);
  if (Subtarget->d16PreservesUnusedBits())
    Features.set(Feature_D16PreservesUnusedBitsBit);
  if (Subtarget->ldsRequiresM0Init())
    Features.set(Feature_LDSRequiresM0InitBit);
  if (!Subtarget->ldsRequiresM0Init())
    Features.set(Feature_NotLDSRequiresM0InitBit);
  if (Subtarget->hasAddNoCarry())
    Features.set(Feature_HasAddNoCarryInstsBit);
  if (Subtarget->has16BitInsts())
    Features.set(Feature_Has16BitInstsBit);
  if (Subtarget->hasVOP3PInsts())
    Features.set(Feature_HasVOP3PInstsBit);
  if (Subtarget->hasMadMixInsts())
    Features.set(Feature_HasMadMixInstsBit);
  if (Subtarget->hasScalarStores())
    Features.set(Feature_HasScalarStoresBit);
  if (Subtarget->getLDSBankCount() == 16)
    Features.set(Feature_has16BankLDSBit);
  if (Subtarget->getLDSBankCount() == 32)
    Features.set(Feature_has32BankLDSBit);
  if (Subtarget->hasFmaMixInsts())
    Features.set(Feature_HasFmaMixInstsBit);
  if (Subtarget->hasDLInsts())
    Features.set(Feature_HasDLInstsBit);
  if (Subtarget->hasDot1Insts())
    Features.set(Feature_HasDot1InstsBit);
  if (Subtarget->hasDot2Insts())
    Features.set(Feature_HasDot2InstsBit);
  if (Subtarget->hasDot3Insts())
    Features.set(Feature_HasDot3InstsBit);
  if (Subtarget->hasDot4Insts())
    Features.set(Feature_HasDot4InstsBit);
  if (Subtarget->hasDot5Insts())
    Features.set(Feature_HasDot5InstsBit);
  if (Subtarget->hasDot6Insts())
    Features.set(Feature_HasDot6InstsBit);
  if (Subtarget->hasMAIInsts())
    Features.set(Feature_HasMAIInstsBit);
  if (EnableLateStructurizeCFG)
    Features.set(Feature_EnableLateCFGStructurizeBit);
  if (Subtarget->hasFP16Denormals())
    Features.set(Feature_FP16DenormalsBit);
  if (Subtarget->hasFP32Denormals())
    Features.set(Feature_FP32DenormalsBit);
  if (Subtarget->hasFP64Denormals())
    Features.set(Feature_FP64DenormalsBit);
  if (!Subtarget->hasFP16Denormals())
    Features.set(Feature_NoFP16DenormalsBit);
  if (!Subtarget->hasFP32Denormals())
    Features.set(Feature_NoFP32DenormalsBit);
  if (!Subtarget->hasFP64Denormals())
    Features.set(Feature_NoFP64DenormalsBit);
  if (TM.Options.UnsafeFPMath)
    Features.set(Feature_UnsafeFPMathBit);
  if (Subtarget->getWavefrontSize() == 32)
    Features.set(Feature_isWave32Bit);
  if (Subtarget->getWavefrontSize() == 64)
    Features.set(Feature_isWave64Bit);
  return Features;
}

PredicateBitset AMDGPUInstructionSelector::
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  return Features;
}

// LLT Objects.
enum {
  GILLT_p0s64,
  GILLT_p1s64,
  GILLT_p2s32,
  GILLT_p3s32,
  GILLT_p4s64,
  GILLT_p5s32,
  GILLT_p6s32,
  GILLT_s1,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v3s32,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v5s32,
  GILLT_v8s32,
  GILLT_v16s32,
  GILLT_v32s32,
};
const static size_t NumTypeObjects = 21;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 64),
  LLT::pointer(1, 64),
  LLT::pointer(2, 32),
  LLT::pointer(3, 32),
  LLT::pointer(4, 64),
  LLT::pointer(5, 32),
  LLT::pointer(6, 32),
  LLT::scalar(1),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(2, 16),
  LLT::vector(2, 32),
  LLT::vector(2, 64),
  LLT::vector(3, 32),
  LLT::vector(4, 16),
  LLT::vector(4, 32),
  LLT::vector(5, 32),
  LLT::vector(8, 32),
  LLT::vector(16, 32),
  LLT::vector(32, 32),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_Has16BitInsts,
  GIFBS_HasMAIInsts,
  GIFBS_has16BankLDS,
  GIFBS_has32BankLDS,
  GIFBS_isGFX10Plus,
  GIFBS_isGFX6,
  GIFBS_isGFX6GFX7GFX10,
  GIFBS_isGFX7GFX8GFX9,
  GIFBS_isGFX7Plus,
  GIFBS_isGFX8Plus,
  GIFBS_isWave64,
  GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
  GIFBS_HasScalarStores_isGFX8Plus,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_Has16BitInstsBit, },
  {Feature_HasMAIInstsBit, },
  {Feature_has16BankLDSBit, },
  {Feature_has32BankLDSBit, },
  {Feature_isGFX10PlusBit, },
  {Feature_isGFX6Bit, },
  {Feature_isGFX6GFX7GFX10Bit, },
  {Feature_isGFX7GFX8GFX9Bit, },
  {Feature_isGFX7PlusBit, },
  {Feature_isGFX8PlusBit, },
  {Feature_isWave64Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_HasScalarStoresBit, Feature_isGFX8PlusBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_NegSubInlineConst16 = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_NegSubInlineConst32,
  GIPFP_I64_Predicate_SIMM16bit,
  GIPFP_I64_Predicate_UIMM16bit,
  GIPFP_I64_Predicate_i64imm_32bit,
};
bool AMDGPUInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_NegSubInlineConst16: {
    
  return Imm < -16 && Imm >= -64;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_NegSubInlineConst32: {
    
  return Imm < -16 && Imm >= -64;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_SIMM16bit: {
    return isInt<16>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_UIMM16bit: {
    return isUInt<16>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_i64imm_32bit: {
    
  return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_MI_Predicate_smrd_load = GIPFP_MI_Invalid + 1,
};
bool AMDGPUInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  switch (PredicateID) {
  case GIPFP_MI_Predicate_smrd_load: {
    
    if (!MI.hasOneMemOperand())
      return false;
    if (!isInstrUniform(MI))
      return false;

    // FIXME: We should probably be caching this.
    SmallVector<GEPInfo, 4> AddrInfo;
    getAddrModeInfo(MI, MRI, AddrInfo);

    if (hasVgprParts(AddrInfo))
      return false;
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}

AMDGPUInstructionSelector::ComplexMatcherMemFn
AMDGPUInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// Custom renderers.
enum {
  GICR_Invalid,
};
AMDGPUInstructionSelector::CustomRendererFn
AMDGPUInstructionSelector::CustomRenderers[] = {
  nullptr, // GICP_Invalid
};

bool AMDGPUInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  // FIXME: This should be computed on a per-function basis rather than per-insn.
  AvailableFunctionFeatures = computeAvailableFunctionFeatures(&STI, &MF);
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *AMDGPUInstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/35, 163, /*)*//*default:*//*Label 32*/ 13083,
    /*TargetOpcode::G_ADD*//*Label 0*/ 133,
    /*TargetOpcode::G_SUB*//*Label 1*/ 428,
    /*TargetOpcode::G_MUL*//*Label 2*/ 490, 0, 0, 0, 0,
    /*TargetOpcode::G_AND*//*Label 3*/ 567,
    /*TargetOpcode::G_OR*//*Label 4*/ 653,
    /*TargetOpcode::G_XOR*//*Label 5*/ 2326, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 6*/ 2476, 0, 0,
    /*TargetOpcode::G_LOAD*//*Label 7*/ 4727, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FENCE*//*Label 8*/ 5746, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 9*/ 5789,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 10*/ 8622, 0, 0,
    /*TargetOpcode::G_CONSTANT*//*Label 11*/ 9155, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SHL*//*Label 12*/ 9208,
    /*TargetOpcode::G_LSHR*//*Label 13*/ 9417,
    /*TargetOpcode::G_ASHR*//*Label 14*/ 9626,
    /*TargetOpcode::G_ICMP*//*Label 15*/ 9835, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_UMULH*//*Label 16*/ 10720,
    /*TargetOpcode::G_SMULH*//*Label 17*/ 10749, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FPOW*//*Label 18*/ 10778, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FNEG*//*Label 19*/ 10849, 0, 0,
    /*TargetOpcode::G_FPTOSI*//*Label 20*/ 11695,
    /*TargetOpcode::G_FPTOUI*//*Label 21*/ 11742,
    /*TargetOpcode::G_SITOFP*//*Label 22*/ 11789,
    /*TargetOpcode::G_UITOFP*//*Label 23*/ 11990,
    /*TargetOpcode::G_FABS*//*Label 24*/ 12191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SMIN*//*Label 25*/ 12618,
    /*TargetOpcode::G_SMAX*//*Label 26*/ 12698,
    /*TargetOpcode::G_UMIN*//*Label 27*/ 12778,
    /*TargetOpcode::G_UMAX*//*Label 28*/ 12858,
    /*TargetOpcode::G_BR*//*Label 29*/ 12938, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_CTPOP*//*Label 30*/ 12963, 0,
    /*TargetOpcode::G_BITREVERSE*//*Label 31*/ 13042,
    // Label 0: @133
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 11, /*)*//*default:*//*Label 36*/ 427,
    /*GILLT_s16*//*Label 33*/ 142,
    /*GILLT_s32*//*Label 34*/ 316,
    /*GILLT_s64*//*Label 35*/ 402,
    // Label 33: @142
    GIM_Try, /*On fail goto*//*Label 37*/ 315,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_Try, /*On fail goto*//*Label 38*/ 204, // Rule ID 1105 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MAD_U16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1105,
        GIR_Done,
      // Label 38: @204
      GIM_Try, /*On fail goto*//*Label 39*/ 252, // Rule ID 1106 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_I16:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MAD_I16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1106,
        GIR_Done,
      // Label 39: @252
      GIM_Try, /*On fail goto*//*Label 40*/ 300, // Rule ID 2868 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MAD_U16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2868,
        GIR_Done,
      // Label 40: @300
      GIM_Try, /*On fail goto*//*Label 41*/ 314, // Rule ID 517 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_ADD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_ADD_U16_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 517,
        GIR_Done,
      // Label 41: @314
      GIM_Reject,
    // Label 37: @315
    GIM_Reject,
    // Label 34: @316
    GIM_Try, /*On fail goto*//*Label 42*/ 401,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_Try, /*On fail goto*//*Label 43*/ 365, // Rule ID 489 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CTPOP,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BCNT_U32_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 489,
        GIR_Done,
      // Label 43: @365
      GIM_Try, /*On fail goto*//*Label 44*/ 400, // Rule ID 2843 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CTPOP,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src1, (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0))  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BCNT_U32_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2843,
        GIR_Done,
      // Label 44: @400
      GIM_Reject,
    // Label 42: @401
    GIM_Reject,
    // Label 35: @402
    GIM_Try, /*On fail goto*//*Label 45*/ 426, // Rule ID 759 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)  =>  (S_ADD_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_ADD_U64_PSEUDO,
      GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 759,
      GIR_Done,
    // Label 45: @426
    GIM_Reject,
    // Label 36: @427
    GIM_Reject,
    // Label 1: @428
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 11, /*)*//*default:*//*Label 48*/ 489,
    /*GILLT_s16*//*Label 46*/ 437, 0,
    /*GILLT_s64*//*Label 47*/ 464,
    // Label 46: @437
    GIM_Try, /*On fail goto*//*Label 49*/ 463, // Rule ID 518 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (sub:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_SUB_U16_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 518,
      GIR_Done,
    // Label 49: @463
    GIM_Reject,
    // Label 47: @464
    GIM_Try, /*On fail goto*//*Label 50*/ 488, // Rule ID 760 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)  =>  (S_SUB_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_SUB_U64_PSEUDO,
      GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 760,
      GIR_Done,
    // Label 50: @488
    GIM_Reject,
    // Label 48: @489
    GIM_Reject,
    // Label 2: @490
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 10, /*)*//*default:*//*Label 53*/ 566,
    /*GILLT_s16*//*Label 51*/ 498,
    /*GILLT_s32*//*Label 52*/ 525,
    // Label 51: @498
    GIM_Try, /*On fail goto*//*Label 54*/ 524, // Rule ID 519 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MUL_LO_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MUL_LO_U16_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 519,
      GIR_Done,
    // Label 54: @524
    GIM_Reject,
    // Label 52: @525
    GIM_Try, /*On fail goto*//*Label 55*/ 565,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 56*/ 548, // Rule ID 44 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (S_MUL_I32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_MUL_I32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44,
        GIR_Done,
      // Label 56: @548
      GIM_Try, /*On fail goto*//*Label 57*/ 564, // Rule ID 538 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MUL_LO_U32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MUL_LO_U32,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 538,
        GIR_Done,
      // Label 57: @564
      GIM_Reject,
    // Label 55: @565
    GIM_Reject,
    // Label 53: @566
    GIM_Reject,
    // Label 3: @567
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 12, /*)*//*default:*//*Label 61*/ 652,
    /*GILLT_s16*//*Label 58*/ 577,
    /*GILLT_s32*//*Label 59*/ 602, 0,
    /*GILLT_v2s16*//*Label 60*/ 627,
    // Label 58: @577
    GIM_Try, /*On fail goto*//*Label 62*/ 601, // Rule ID 1077 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_AND_B32_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1077,
      GIR_Done,
    // Label 62: @601
    GIM_Reject,
    // Label 59: @602
    GIM_Try, /*On fail goto*//*Label 63*/ 626, // Rule ID 482 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_AND_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_AND_B32_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 482,
      GIR_Done,
    // Label 63: @626
    GIM_Reject,
    // Label 60: @627
    GIM_Try, /*On fail goto*//*Label 64*/ 651, // Rule ID 1080 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_AND_B32_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1080,
      GIR_Done,
    // Label 64: @651
    GIM_Reject,
    // Label 61: @652
    GIM_Reject,
    // Label 4: @653
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 12, /*)*//*default:*//*Label 68*/ 2325,
    /*GILLT_s16*//*Label 65*/ 663,
    /*GILLT_s32*//*Label 66*/ 688, 0,
    /*GILLT_v2s16*//*Label 67*/ 2300,
    // Label 65: @663
    GIM_Try, /*On fail goto*//*Label 69*/ 687, // Rule ID 1078 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_OR_B32_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1078,
      GIR_Done,
    // Label 69: @687
    GIM_Reject,
    // Label 66: @688
    GIM_Try, /*On fail goto*//*Label 70*/ 2299,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_Try, /*On fail goto*//*Label 71*/ 801, // Rule ID 4044 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4044,
        GIR_Done,
      // Label 71: @801
      GIM_Try, /*On fail goto*//*Label 72*/ 900, // Rule ID 4045 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4045,
        GIR_Done,
      // Label 72: @900
      GIM_Try, /*On fail goto*//*Label 73*/ 999, // Rule ID 4046 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4046,
        GIR_Done,
      // Label 73: @999
      GIM_Try, /*On fail goto*//*Label 74*/ 1098, // Rule ID 4047 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4047,
        GIR_Done,
      // Label 74: @1098
      GIM_Try, /*On fail goto*//*Label 75*/ 1197, // Rule ID 4040 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4040,
        GIR_Done,
      // Label 75: @1197
      GIM_Try, /*On fail goto*//*Label 76*/ 1296, // Rule ID 4041 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4041,
        GIR_Done,
      // Label 76: @1296
      GIM_Try, /*On fail goto*//*Label 77*/ 1395, // Rule ID 4042 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4042,
        GIR_Done,
      // Label 77: @1395
      GIM_Try, /*On fail goto*//*Label 78*/ 1494, // Rule ID 4043 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4043,
        GIR_Done,
      // Label 78: @1494
      GIM_Try, /*On fail goto*//*Label 79*/ 1593, // Rule ID 4034 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4034,
        GIR_Done,
      // Label 79: @1593
      GIM_Try, /*On fail goto*//*Label 80*/ 1692, // Rule ID 4035 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4035,
        GIR_Done,
      // Label 80: @1692
      GIM_Try, /*On fail goto*//*Label 81*/ 1791, // Rule ID 4038 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4038,
        GIR_Done,
      // Label 81: @1791
      GIM_Try, /*On fail goto*//*Label 82*/ 1890, // Rule ID 4039 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4039,
        GIR_Done,
      // Label 82: @1890
      GIM_Try, /*On fail goto*//*Label 83*/ 1989, // Rule ID 2617 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2617,
        GIR_Done,
      // Label 83: @1989
      GIM_Try, /*On fail goto*//*Label 84*/ 2088, // Rule ID 4033 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4033,
        GIR_Done,
      // Label 84: @2088
      GIM_Try, /*On fail goto*//*Label 85*/ 2187, // Rule ID 4036 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4036,
        GIR_Done,
      // Label 85: @2187
      GIM_Try, /*On fail goto*//*Label 86*/ 2286, // Rule ID 4037 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))  =>  (V_BFI_B32:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4037,
        GIR_Done,
      // Label 86: @2286
      GIM_Try, /*On fail goto*//*Label 87*/ 2298, // Rule ID 484 //
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_OR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_OR_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 484,
        GIR_Done,
      // Label 87: @2298
      GIM_Reject,
    // Label 70: @2299
    GIM_Reject,
    // Label 67: @2300
    GIM_Try, /*On fail goto*//*Label 88*/ 2324, // Rule ID 1081 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (or:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_OR_B32_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1081,
      GIR_Done,
    // Label 88: @2324
    GIM_Reject,
    // Label 68: @2325
    GIM_Reject,
    // Label 5: @2326
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 12, /*)*//*default:*//*Label 93*/ 2475,
    /*GILLT_s16*//*Label 89*/ 2336,
    /*GILLT_s32*//*Label 90*/ 2361,
    /*GILLT_s64*//*Label 91*/ 2415,
    /*GILLT_v2s16*//*Label 92*/ 2450,
    // Label 89: @2336
    GIM_Try, /*On fail goto*//*Label 94*/ 2360, // Rule ID 1079 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (xor:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_XOR_B32_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1079,
      GIR_Done,
    // Label 94: @2360
    GIM_Reject,
    // Label 90: @2361
    GIM_Try, /*On fail goto*//*Label 95*/ 2414,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 96*/ 2397, // Rule ID 0 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, -1:{ *:[i32] })  =>  (S_NOT_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NOT_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 0,
        GIR_Done,
      // Label 96: @2397
      GIM_Try, /*On fail goto*//*Label 97*/ 2413, // Rule ID 486 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_XOR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 486,
        GIR_Done,
      // Label 97: @2413
      GIM_Reject,
    // Label 95: @2414
    GIM_Reject,
    // Label 91: @2415
    GIM_Try, /*On fail goto*//*Label 98*/ 2449, // Rule ID 1 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
      // (xor:{ *:[i64] } i64:{ *:[i64] }:$src0, -1:{ *:[i64] })  =>  (S_NOT_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NOT_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1,
      GIR_Done,
    // Label 98: @2449
    GIM_Reject,
    // Label 92: @2450
    GIM_Try, /*On fail goto*//*Label 99*/ 2474, // Rule ID 1082 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_XOR_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_XOR_B32_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1082,
      GIR_Done,
    // Label 99: @2474
    GIM_Reject,
    // Label 93: @2475
    GIM_Reject,
    // Label 6: @2476
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 21, /*)*//*default:*//*Label 113*/ 4726,
    /*GILLT_s16*//*Label 100*/ 2495,
    /*GILLT_s32*//*Label 101*/ 2615,
    /*GILLT_s64*//*Label 102*/ 2872,
    /*GILLT_v2s16*//*Label 103*/ 3193,
    /*GILLT_v2s32*//*Label 104*/ 3386,
    /*GILLT_v2s64*//*Label 105*/ 3739,
    /*GILLT_v3s32*//*Label 106*/ 3900,
    /*GILLT_v4s16*//*Label 107*/ 3956,
    /*GILLT_v4s32*//*Label 108*/ 4277,
    /*GILLT_v5s32*//*Label 109*/ 4438,
    /*GILLT_v8s32*//*Label 110*/ 4494,
    /*GILLT_v16s32*//*Label 111*/ 4614,
    /*GILLT_v32s32*//*Label 112*/ 4670,
    // Label 100: @2495
    GIM_Try, /*On fail goto*//*Label 114*/ 2614,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 115*/ 2529, // Rule ID 2131 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (bitconvert:{ *:[i16] } VGPR_32:{ *:[f16] }:$src0)  =>  VGPR_32:{ *:[i16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VGPR_32*/12,
        // GIR_Coverage, 2131,
        GIR_Done,
      // Label 115: @2529
      GIM_Try, /*On fail goto*//*Label 116*/ 2557, // Rule ID 2132 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (bitconvert:{ *:[f16] } VGPR_32:{ *:[i16] }:$src0)  =>  VGPR_32:{ *:[f16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VGPR_32*/12,
        // GIR_Coverage, 2132,
        GIR_Done,
      // Label 116: @2557
      GIM_Try, /*On fail goto*//*Label 117*/ 2585, // Rule ID 2133 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        // (bitconvert:{ *:[i16] } SReg_32:{ *:[f16] }:$src0)  =>  SReg_32:{ *:[i16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
        // GIR_Coverage, 2133,
        GIR_Done,
      // Label 117: @2585
      GIM_Try, /*On fail goto*//*Label 118*/ 2613, // Rule ID 2134 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        // (bitconvert:{ *:[f16] } SReg_32:{ *:[i16] }:$src0)  =>  SReg_32:{ *:[f16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
        // GIR_Coverage, 2134,
        GIR_Done,
      // Label 118: @2613
      GIM_Reject,
    // Label 114: @2614
    GIM_Reject,
    // Label 101: @2615
    GIM_Try, /*On fail goto*//*Label 119*/ 2647, // Rule ID 2135 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (bitconvert:{ *:[i32] } VGPR_32:{ *:[f32] }:$src0)  =>  VGPR_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VGPR_32*/12,
      // GIR_Coverage, 2135,
      GIR_Done,
    // Label 119: @2647
    GIM_Try, /*On fail goto*//*Label 120*/ 2679, // Rule ID 2136 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (bitconvert:{ *:[f32] } VGPR_32:{ *:[i32] }:$src0)  =>  VGPR_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VGPR_32*/12,
      // GIR_Coverage, 2136,
      GIR_Done,
    // Label 120: @2679
    GIM_Try, /*On fail goto*//*Label 121*/ 2711, // Rule ID 2137 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 2137,
      GIR_Done,
    // Label 121: @2711
    GIM_Try, /*On fail goto*//*Label 122*/ 2743, // Rule ID 2138 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 2138,
      GIR_Done,
    // Label 122: @2743
    GIM_Try, /*On fail goto*//*Label 123*/ 2775, // Rule ID 2140 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 2140,
      GIR_Done,
    // Label 123: @2775
    GIM_Try, /*On fail goto*//*Label 124*/ 2807, // Rule ID 2142 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 2142,
      GIR_Done,
    // Label 124: @2807
    GIM_Try, /*On fail goto*//*Label 125*/ 2839, // Rule ID 2146 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 2146,
      GIR_Done,
    // Label 125: @2839
    GIM_Try, /*On fail goto*//*Label 126*/ 2871, // Rule ID 2148 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 2148,
      GIR_Done,
    // Label 126: @2871
    GIM_Reject,
    // Label 102: @2872
    GIM_Try, /*On fail goto*//*Label 127*/ 2904, // Rule ID 2149 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2149,
      GIR_Done,
    // Label 127: @2904
    GIM_Try, /*On fail goto*//*Label 128*/ 2936, // Rule ID 2150 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2150,
      GIR_Done,
    // Label 128: @2936
    GIM_Try, /*On fail goto*//*Label 129*/ 2968, // Rule ID 2153 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2153,
      GIR_Done,
    // Label 129: @2968
    GIM_Try, /*On fail goto*//*Label 130*/ 3000, // Rule ID 2155 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2155,
      GIR_Done,
    // Label 130: @3000
    GIM_Try, /*On fail goto*//*Label 131*/ 3032, // Rule ID 2157 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2157,
      GIR_Done,
    // Label 131: @3032
    GIM_Try, /*On fail goto*//*Label 132*/ 3064, // Rule ID 2159 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2159,
      GIR_Done,
    // Label 132: @3064
    GIM_Try, /*On fail goto*//*Label 133*/ 3096, // Rule ID 2174 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2174,
      GIR_Done,
    // Label 133: @3096
    GIM_Try, /*On fail goto*//*Label 134*/ 3128, // Rule ID 2175 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2175,
      GIR_Done,
    // Label 134: @3128
    GIM_Try, /*On fail goto*//*Label 135*/ 3160, // Rule ID 2178 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2178,
      GIR_Done,
    // Label 135: @3160
    GIM_Try, /*On fail goto*//*Label 136*/ 3192, // Rule ID 2179 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2179,
      GIR_Done,
    // Label 136: @3192
    GIM_Reject,
    // Label 103: @3193
    GIM_Try, /*On fail goto*//*Label 137*/ 3225, // Rule ID 2139 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 2139,
      GIR_Done,
    // Label 137: @3225
    GIM_Try, /*On fail goto*//*Label 138*/ 3257, // Rule ID 2141 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 2141,
      GIR_Done,
    // Label 138: @3257
    GIM_Try, /*On fail goto*//*Label 139*/ 3289, // Rule ID 2143 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 2143,
      GIR_Done,
    // Label 139: @3289
    GIM_Try, /*On fail goto*//*Label 140*/ 3321, // Rule ID 2144 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 2144,
      GIR_Done,
    // Label 140: @3321
    GIM_Try, /*On fail goto*//*Label 141*/ 3353, // Rule ID 2145 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 2145,
      GIR_Done,
    // Label 141: @3353
    GIM_Try, /*On fail goto*//*Label 142*/ 3385, // Rule ID 2147 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_32*/14,
      // GIR_Coverage, 2147,
      GIR_Done,
    // Label 142: @3385
    GIM_Reject,
    // Label 104: @3386
    GIM_Try, /*On fail goto*//*Label 143*/ 3418, // Rule ID 2151 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2151,
      GIR_Done,
    // Label 143: @3418
    GIM_Try, /*On fail goto*//*Label 144*/ 3450, // Rule ID 2152 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2152,
      GIR_Done,
    // Label 144: @3450
    GIM_Try, /*On fail goto*//*Label 145*/ 3482, // Rule ID 2154 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2154,
      GIR_Done,
    // Label 145: @3482
    GIM_Try, /*On fail goto*//*Label 146*/ 3514, // Rule ID 2156 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2156,
      GIR_Done,
    // Label 146: @3514
    GIM_Try, /*On fail goto*//*Label 147*/ 3546, // Rule ID 2158 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2158,
      GIR_Done,
    // Label 147: @3546
    GIM_Try, /*On fail goto*//*Label 148*/ 3578, // Rule ID 2160 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2160,
      GIR_Done,
    // Label 148: @3578
    GIM_Try, /*On fail goto*//*Label 149*/ 3610, // Rule ID 2163 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2163,
      GIR_Done,
    // Label 149: @3610
    GIM_Try, /*On fail goto*//*Label 150*/ 3642, // Rule ID 2165 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2165,
      GIR_Done,
    // Label 150: @3642
    GIM_Try, /*On fail goto*//*Label 151*/ 3674, // Rule ID 2166 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2166,
      GIR_Done,
    // Label 151: @3674
    GIM_Try, /*On fail goto*//*Label 152*/ 3706, // Rule ID 2168 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2168,
      GIR_Done,
    // Label 152: @3706
    GIM_Try, /*On fail goto*//*Label 153*/ 3738, // Rule ID 2170 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2170,
      GIR_Done,
    // Label 153: @3738
    GIM_Reject,
    // Label 105: @3739
    GIM_Try, /*On fail goto*//*Label 154*/ 3771, // Rule ID 2184 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v2i64] } SReg_128:{ *:[v4i32] }:$src0)  =>  SReg_128:{ *:[v2i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_128*/42,
      // GIR_Coverage, 2184,
      GIR_Done,
    // Label 154: @3771
    GIM_Try, /*On fail goto*//*Label 155*/ 3803, // Rule ID 2186 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 2186,
      GIR_Done,
    // Label 155: @3803
    GIM_Try, /*On fail goto*//*Label 156*/ 3835, // Rule ID 2187 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v4i32] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 2187,
      GIR_Done,
    // Label 156: @3835
    GIM_Try, /*On fail goto*//*Label 157*/ 3867, // Rule ID 2190 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2i64] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v2i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 2190,
      GIR_Done,
    // Label 157: @3867
    GIM_Try, /*On fail goto*//*Label 158*/ 3899, // Rule ID 2191 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v2i64] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 2191,
      GIR_Done,
    // Label 158: @3899
    GIM_Reject,
    // Label 106: @3900
    GIM_Try, /*On fail goto*//*Label 159*/ 3955,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SGPR_96RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SGPR_96RegClassID,
      GIM_Try, /*On fail goto*//*Label 160*/ 3934, // Rule ID 2182 //
        // (bitconvert:{ *:[v3i32] } SGPR_96:{ *:[v3f32] }:$src0)  =>  SGPR_96:{ *:[v3i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SGPR_96*/34,
        // GIR_Coverage, 2182,
        GIR_Done,
      // Label 160: @3934
      GIM_Try, /*On fail goto*//*Label 161*/ 3954, // Rule ID 2183 //
        // (bitconvert:{ *:[v3f32] } SGPR_96:{ *:[v3i32] }:$src0)  =>  SGPR_96:{ *:[v3f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SGPR_96*/34,
        // GIR_Coverage, 2183,
        GIR_Done,
      // Label 161: @3954
      GIM_Reject,
    // Label 159: @3955
    GIM_Reject,
    // Label 107: @3956
    GIM_Try, /*On fail goto*//*Label 162*/ 3988, // Rule ID 2161 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2161,
      GIR_Done,
    // Label 162: @3988
    GIM_Try, /*On fail goto*//*Label 163*/ 4020, // Rule ID 2162 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2162,
      GIR_Done,
    // Label 163: @4020
    GIM_Try, /*On fail goto*//*Label 164*/ 4052, // Rule ID 2164 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2164,
      GIR_Done,
    // Label 164: @4052
    GIM_Try, /*On fail goto*//*Label 165*/ 4084, // Rule ID 2167 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2167,
      GIR_Done,
    // Label 165: @4084
    GIM_Try, /*On fail goto*//*Label 166*/ 4116, // Rule ID 2169 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2169,
      GIR_Done,
    // Label 166: @4116
    GIM_Try, /*On fail goto*//*Label 167*/ 4148, // Rule ID 2171 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2171,
      GIR_Done,
    // Label 167: @4148
    GIM_Try, /*On fail goto*//*Label 168*/ 4180, // Rule ID 2172 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2172,
      GIR_Done,
    // Label 168: @4180
    GIM_Try, /*On fail goto*//*Label 169*/ 4212, // Rule ID 2173 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2173,
      GIR_Done,
    // Label 169: @4212
    GIM_Try, /*On fail goto*//*Label 170*/ 4244, // Rule ID 2176 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2176,
      GIR_Done,
    // Label 170: @4244
    GIM_Try, /*On fail goto*//*Label 171*/ 4276, // Rule ID 2177 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_64*/27,
      // GIR_Coverage, 2177,
      GIR_Done,
    // Label 171: @4276
    GIM_Reject,
    // Label 108: @4277
    GIM_Try, /*On fail goto*//*Label 172*/ 4309, // Rule ID 2180 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 2180,
      GIR_Done,
    // Label 172: @4309
    GIM_Try, /*On fail goto*//*Label 173*/ 4341, // Rule ID 2181 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v4i32] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 2181,
      GIR_Done,
    // Label 173: @4341
    GIM_Try, /*On fail goto*//*Label 174*/ 4373, // Rule ID 2185 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } SReg_128:{ *:[v2i64] }:$src0)  =>  SReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_128*/42,
      // GIR_Coverage, 2185,
      GIR_Done,
    // Label 174: @4373
    GIM_Try, /*On fail goto*//*Label 175*/ 4405, // Rule ID 2188 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 2188,
      GIR_Done,
    // Label 175: @4405
    GIM_Try, /*On fail goto*//*Label 176*/ 4437, // Rule ID 2189 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_128*/41,
      // GIR_Coverage, 2189,
      GIR_Done,
    // Label 176: @4437
    GIM_Reject,
    // Label 109: @4438
    GIM_Try, /*On fail goto*//*Label 177*/ 4493,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v5s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SGPR_160RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SGPR_160RegClassID,
      GIM_Try, /*On fail goto*//*Label 178*/ 4472, // Rule ID 2192 //
        // (bitconvert:{ *:[v5i32] } SGPR_160:{ *:[v5f32] }:$src0)  =>  SGPR_160:{ *:[v5i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SGPR_160*/52,
        // GIR_Coverage, 2192,
        GIR_Done,
      // Label 178: @4472
      GIM_Try, /*On fail goto*//*Label 179*/ 4492, // Rule ID 2193 //
        // (bitconvert:{ *:[v5f32] } SGPR_160:{ *:[v5i32] }:$src0)  =>  SGPR_160:{ *:[v5f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SGPR_160*/52,
        // GIR_Coverage, 2193,
        GIR_Done,
      // Label 179: @4492
      GIM_Reject,
    // Label 177: @4493
    GIM_Reject,
    // Label 110: @4494
    GIM_Try, /*On fail goto*//*Label 180*/ 4613,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 181*/ 4528, // Rule ID 2194 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_256RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_256RegClassID,
        // (bitconvert:{ *:[v8i32] } SReg_256:{ *:[v8f32] }:$src0)  =>  SReg_256:{ *:[v8i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_256*/62,
        // GIR_Coverage, 2194,
        GIR_Done,
      // Label 181: @4528
      GIM_Try, /*On fail goto*//*Label 182*/ 4556, // Rule ID 2195 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_256RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_256RegClassID,
        // (bitconvert:{ *:[v8f32] } SReg_256:{ *:[v8i32] }:$src0)  =>  SReg_256:{ *:[v8f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC SReg_256*/62,
        // GIR_Coverage, 2195,
        GIR_Done,
      // Label 182: @4556
      GIM_Try, /*On fail goto*//*Label 183*/ 4584, // Rule ID 2196 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
        // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_256*/61,
        // GIR_Coverage, 2196,
        GIR_Done,
      // Label 183: @4584
      GIM_Try, /*On fail goto*//*Label 184*/ 4612, // Rule ID 2197 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
        // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_256*/61,
        // GIR_Coverage, 2197,
        GIR_Done,
      // Label 184: @4612
      GIM_Reject,
    // Label 180: @4613
    GIM_Reject,
    // Label 111: @4614
    GIM_Try, /*On fail goto*//*Label 185*/ 4669,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_Try, /*On fail goto*//*Label 186*/ 4648, // Rule ID 2198 //
        // (bitconvert:{ *:[v16i32] } VReg_512:{ *:[v16f32] }:$src0)  =>  VReg_512:{ *:[v16i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_512*/75,
        // GIR_Coverage, 2198,
        GIR_Done,
      // Label 186: @4648
      GIM_Try, /*On fail goto*//*Label 187*/ 4668, // Rule ID 2199 //
        // (bitconvert:{ *:[v16f32] } VReg_512:{ *:[v16i32] }:$src0)  =>  VReg_512:{ *:[v16f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_512*/75,
        // GIR_Coverage, 2199,
        GIR_Done,
      // Label 187: @4668
      GIM_Reject,
    // Label 185: @4669
    GIM_Reject,
    // Label 112: @4670
    GIM_Try, /*On fail goto*//*Label 188*/ 4725,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v32s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_Try, /*On fail goto*//*Label 189*/ 4704, // Rule ID 2200 //
        // (bitconvert:{ *:[v32i32] } VReg_1024:{ *:[v32f32] }:$src0)  =>  VReg_1024:{ *:[v32i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_1024*/93,
        // GIR_Coverage, 2200,
        GIR_Done,
      // Label 189: @4704
      GIM_Try, /*On fail goto*//*Label 190*/ 4724, // Rule ID 2201 //
        // (bitconvert:{ *:[v32f32] } VReg_1024:{ *:[v32i32] }:$src0)  =>  VReg_1024:{ *:[v32f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC VReg_1024*/93,
        // GIR_Coverage, 2201,
        GIR_Done,
      // Label 190: @4724
      GIM_Reject,
    // Label 188: @4725
    GIM_Reject,
    // Label 113: @4726
    GIM_Reject,
    // Label 7: @4727
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/2, 20, /*)*//*default:*//*Label 205*/ 5745,
    /*GILLT_p2s32*//*Label 191*/ 4751,
    /*GILLT_p3s32*//*Label 192*/ 4805, 0,
    /*GILLT_p5s32*//*Label 193*/ 4859,
    /*GILLT_p6s32*//*Label 194*/ 4913,
    /*GILLT_s1*//*Label 195*/ 4967, 0,
    /*GILLT_s32*//*Label 196*/ 5021,
    /*GILLT_s64*//*Label 197*/ 5109,
    /*GILLT_v2s16*//*Label 198*/ 5197,
    /*GILLT_v2s32*//*Label 199*/ 5285,
    /*GILLT_v2s64*//*Label 200*/ 5373, 0,
    /*GILLT_v4s16*//*Label 201*/ 5461,
    /*GILLT_v4s32*//*Label 202*/ 5549, 0,
    /*GILLT_v8s32*//*Label 203*/ 5637,
    /*GILLT_v16s32*//*Label 204*/ 5691,
    // Label 191: @4751
    GIM_Try, /*On fail goto*//*Label 206*/ 4804, // Rule ID 1174 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1174,
      GIR_Done,
    // Label 206: @4804
    GIM_Reject,
    // Label 192: @4805
    GIM_Try, /*On fail goto*//*Label 207*/ 4858, // Rule ID 1178 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1178,
      GIR_Done,
    // Label 207: @4858
    GIM_Reject,
    // Label 193: @4859
    GIM_Try, /*On fail goto*//*Label 208*/ 4912, // Rule ID 1182 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1182,
      GIR_Done,
    // Label 208: @4912
    GIM_Reject,
    // Label 194: @4913
    GIM_Try, /*On fail goto*//*Label 209*/ 4966, // Rule ID 1186 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1186,
      GIR_Done,
    // Label 209: @4966
    GIM_Reject,
    // Label 195: @4967
    GIM_Try, /*On fail goto*//*Label 210*/ 5020, // Rule ID 1206 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      // (ld:{ *:[i1] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i1] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1206,
      GIR_Done,
    // Label 210: @5020
    GIM_Reject,
    // Label 196: @5021
    GIM_Try, /*On fail goto*//*Label 211*/ 5108,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 212*/ 5076, // Rule ID 1155 //
        // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1155,
        GIR_Done,
      // Label 212: @5076
      GIM_Try, /*On fail goto*//*Label 213*/ 5107, // Rule ID 1162 //
        // (ld:{ *:[f32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[f32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1162,
        GIR_Done,
      // Label 213: @5107
      GIM_Reject,
    // Label 211: @5108
    GIM_Reject,
    // Label 197: @5109
    GIM_Try, /*On fail goto*//*Label 214*/ 5196,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 215*/ 5164, // Rule ID 1194 //
        // (ld:{ *:[i64] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1194,
        GIR_Done,
      // Label 215: @5164
      GIM_Try, /*On fail goto*//*Label 216*/ 5195, // Rule ID 1202 //
        // (ld:{ *:[f64] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[f64] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1202,
        GIR_Done,
      // Label 216: @5195
      GIM_Reject,
    // Label 214: @5196
    GIM_Reject,
    // Label 198: @5197
    GIM_Try, /*On fail goto*//*Label 217*/ 5284,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 218*/ 5252, // Rule ID 1166 //
        // (ld:{ *:[v2i16] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[v2i16] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1166,
        GIR_Done,
      // Label 218: @5252
      GIM_Try, /*On fail goto*//*Label 219*/ 5283, // Rule ID 1170 //
        // (ld:{ *:[v2f16] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[v2f16] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1170,
        GIR_Done,
      // Label 219: @5283
      GIM_Reject,
    // Label 217: @5284
    GIM_Reject,
    // Label 199: @5285
    GIM_Try, /*On fail goto*//*Label 220*/ 5372,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 221*/ 5340, // Rule ID 1190 //
        // (ld:{ *:[v2i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[v2i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1190,
        GIR_Done,
      // Label 221: @5340
      GIM_Try, /*On fail goto*//*Label 222*/ 5371, // Rule ID 1198 //
        // (ld:{ *:[v2f32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[v2f32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1198,
        GIR_Done,
      // Label 222: @5371
      GIM_Reject,
    // Label 220: @5372
    GIM_Reject,
    // Label 200: @5373
    GIM_Try, /*On fail goto*//*Label 223*/ 5460,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 224*/ 5428, // Rule ID 1226 //
        // (ld:{ *:[v2i64] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX4_IMM:{ *:[v2i64] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX4_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1226,
        GIR_Done,
      // Label 224: @5428
      GIM_Try, /*On fail goto*//*Label 225*/ 5459, // Rule ID 1230 //
        // (ld:{ *:[v2f64] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX4_IMM:{ *:[v2f64] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX4_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1230,
        GIR_Done,
      // Label 225: @5459
      GIM_Reject,
    // Label 223: @5460
    GIM_Reject,
    // Label 201: @5461
    GIM_Try, /*On fail goto*//*Label 226*/ 5548,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 227*/ 5516, // Rule ID 1210 //
        // (ld:{ *:[v4i16] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[v4i16] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1210,
        GIR_Done,
      // Label 227: @5516
      GIM_Try, /*On fail goto*//*Label 228*/ 5547, // Rule ID 1214 //
        // (ld:{ *:[v4f16] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[v4f16] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1214,
        GIR_Done,
      // Label 228: @5547
      GIM_Reject,
    // Label 226: @5548
    GIM_Reject,
    // Label 202: @5549
    GIM_Try, /*On fail goto*//*Label 229*/ 5636,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 230*/ 5604, // Rule ID 1218 //
        // (ld:{ *:[v4i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX4_IMM:{ *:[v4i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX4_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1218,
        GIR_Done,
      // Label 230: @5604
      GIM_Try, /*On fail goto*//*Label 231*/ 5635, // Rule ID 1222 //
        // (ld:{ *:[v4f32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX4_IMM:{ *:[v4f32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX4_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1222,
        GIR_Done,
      // Label 231: @5635
      GIM_Reject,
    // Label 229: @5636
    GIM_Reject,
    // Label 203: @5637
    GIM_Try, /*On fail goto*//*Label 232*/ 5690, // Rule ID 1234 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_256RegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      // (ld:{ *:[v8i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX8_IMM:{ *:[v8i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX8_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1234,
      GIR_Done,
    // Label 232: @5690
    GIM_Reject,
    // Label 204: @5691
    GIM_Try, /*On fail goto*//*Label 233*/ 5744, // Rule ID 1238 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_512RegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      // (ld:{ *:[v16i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX16_IMM:{ *:[v16i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX16_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1238,
      GIR_Done,
    // Label 233: @5744
    GIM_Reject,
    // Label 205: @5745
    GIM_Reject,
    // Label 8: @5746
    GIM_Try, /*On fail goto*//*Label 234*/ 5788, // Rule ID 756 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
      // MIs[1] Operand 1
      // No operand predicates
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/1, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
      // MIs[2] Operand 1
      // No operand predicates
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/2,
      // (atomic_fence (imm:{ *:[i32] }):$ordering, (imm:{ *:[i32] }):$scope)  =>  (ATOMIC_FENCE (imm:{ *:[i32] }):$ordering, (imm:{ *:[i32] }):$scope)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::ATOMIC_FENCE,
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // ordering
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // scope
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 756,
      GIR_Done,
    // Label 234: @5788
    GIM_Reject,
    // Label 9: @5789
    GIM_Try, /*On fail goto*//*Label 235*/ 5873,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_Try, /*On fail goto*//*Label 236*/ 5820, // Rule ID 11 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_s_getpc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 1105:{ *:[iPTR] })  =>  (S_GETPC_B64:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_GETPC_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11,
        GIR_Done,
      // Label 236: @5820
      GIM_Try, /*On fail goto*//*Label 237*/ 5846, // Rule ID 761 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_groupstaticsize,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 558:{ *:[iPTR] })  =>  (GET_GROUPSTATICSIZE:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GET_GROUPSTATICSIZE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 761,
        GIR_Done,
      // Label 237: @5846
      GIM_Try, /*On fail goto*//*Label 238*/ 5872, // Rule ID 766 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_ps_live,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_1RegClassID,
        // (intrinsic_wo_chain:{ *:[i1] } 1068:{ *:[iPTR] })  =>  (SI_PS_LIVE:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SI_PS_LIVE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 766,
        GIR_Done,
      // Label 238: @5872
      GIM_Reject,
    // Label 235: @5873
    GIM_Try, /*On fail goto*//*Label 239*/ 5981,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 240*/ 5912, // Rule ID 7 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_sffbh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1122:{ *:[iPTR] }, i32:{ *:[i32] }:$src0)  =>  (S_FLBIT_I32:{ *:[i32] } i32:{ *:[i32] }:$src0)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_FLBIT_I32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7,
        GIR_Done,
      // Label 240: @5912
      GIM_Try, /*On fail goto*//*Label 241*/ 5946, // Rule ID 366 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_readfirstlane,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1092:{ *:[iPTR] }, i32:{ *:[i32] }:$src0)  =>  (V_READFIRSTLANE_B32:{ *:[i32] } i32:{ *:[i32] }:$src0)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_READFIRSTLANE_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 366,
        GIR_Done,
      // Label 241: @5946
      GIM_Try, /*On fail goto*//*Label 242*/ 5980, // Rule ID 410 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_sffbh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1122:{ *:[iPTR] }, i32:{ *:[i32] }:$src0)  =>  (V_FFBH_I32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_FFBH_I32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 410,
        GIR_Done,
      // Label 242: @5980
      GIM_Reject,
    // Label 239: @5981
    GIM_Try, /*On fail goto*//*Label 243*/ 6281,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 244*/ 6028, // Rule ID 487 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_readlane,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1093:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_READLANE_B32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_READLANE_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 487,
        GIR_Done,
      // Label 244: @6028
      GIM_Try, /*On fail goto*//*Label 245*/ 6070, // Rule ID 757 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_set_inactive,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1121:{ *:[iPTR] }, i32:{ *:[i32] }:$src, i32:{ *:[i32] }:$inactive)  =>  (V_SET_INACTIVE_B32:{ *:[i32] } i32:{ *:[i32] }:$src, i32:{ *:[i32] }:$inactive)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SET_INACTIVE_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // inactive
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 757,
        GIR_Done,
      // Label 245: @6070
      GIM_Try, /*On fail goto*//*Label 246*/ 6112, // Rule ID 758 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_set_inactive,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 1121:{ *:[iPTR] }, i64:{ *:[i64] }:$src, i64:{ *:[i64] }:$inactive)  =>  (V_SET_INACTIVE_B64:{ *:[i64] } i64:{ *:[i64] }:$src, i64:{ *:[i64] }:$inactive)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SET_INACTIVE_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // inactive
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 758,
        GIR_Done,
      // Label 246: @6112
      GIM_Try, /*On fail goto*//*Label 247*/ 6154, // Rule ID 490 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mbcnt_lo,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1038:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MBCNT_LO_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MBCNT_LO_U32_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 490,
        GIR_Done,
      // Label 247: @6154
      GIM_Try, /*On fail goto*//*Label 248*/ 6196, // Rule ID 491 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mbcnt_hi,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1037:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MBCNT_HI_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MBCNT_HI_U32_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 491,
        GIR_Done,
      // Label 248: @6196
      GIM_Try, /*On fail goto*//*Label 249*/ 6238, // Rule ID 500 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_cvt_pk_u16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 518:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_CVT_PK_U16_U32_e64:{ *:[v2i16] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CVT_PK_U16_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 500,
        GIR_Done,
      // Label 249: @6238
      GIM_Try, /*On fail goto*//*Label 250*/ 6280, // Rule ID 502 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_cvt_pk_i16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 517:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_CVT_PK_I16_I32_e64:{ *:[v2i16] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CVT_PK_I16_I32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 502,
        GIR_Done,
      // Label 250: @6280
      GIM_Reject,
    // Label 243: @6281
    GIM_Try, /*On fail goto*//*Label 251*/ 6858,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_Try, /*On fail goto*//*Label 252*/ 6336, // Rule ID 488 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_writelane,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1163:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$vdst_in)  =>  (V_WRITELANE_B32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$vdst_in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_WRITELANE_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vdst_in
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 488,
        GIR_Done,
      // Label 252: @6336
      GIM_Try, /*On fail goto*//*Label 253*/ 6389, // Rule ID 1121 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_sad_u8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1116:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U8:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SAD_U8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1121,
        GIR_Done,
      // Label 253: @6389
      GIM_Try, /*On fail goto*//*Label 254*/ 6442, // Rule ID 1122 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_sad_hi_u8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1114:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)  =>  (V_SAD_HI_U8:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SAD_HI_U8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1122,
        GIR_Done,
      // Label 254: @6442
      GIM_Try, /*On fail goto*//*Label 255*/ 6495, // Rule ID 1123 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_sad_u16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1115:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U16:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SAD_U16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1123,
        GIR_Done,
      // Label 255: @6495
      GIM_Try, /*On fail goto*//*Label 256*/ 6548, // Rule ID 1124 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_msad_u8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1063:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)  =>  (V_MSAD_U8:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MSAD_U8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1124,
        GIR_Done,
      // Label 256: @6548
      GIM_Try, /*On fail goto*//*Label 257*/ 6601, // Rule ID 1125 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mqsad_pk_u16_u8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 1061:{ *:[iPTR] }, i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1, i64:{ *:[i64] }:$src2)  =>  (V_MQSAD_PK_U16_U8:{ *:[i64] } i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1, i64:{ *:[i64] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MQSAD_PK_U16_U8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1125,
        GIR_Done,
      // Label 257: @6601
      GIM_Try, /*On fail goto*//*Label 258*/ 6654, // Rule ID 1126 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_qsad_pk_u16_u8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 1069:{ *:[iPTR] }, i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1, i64:{ *:[i64] }:$src2)  =>  (V_QSAD_PK_U16_U8:{ *:[i64] } i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1, i64:{ *:[i64] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_QSAD_PK_U16_U8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1126,
        GIR_Done,
      // Label 258: @6654
      GIM_Try, /*On fail goto*//*Label 259*/ 6707, // Rule ID 1127 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mqsad_u32_u8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1062:{ *:[iPTR] }, i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1, v4i32:{ *:[v4i32] }:$src2)  =>  (V_MQSAD_U32_U8:{ *:[v4i32] } i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1, v4i32:{ *:[v4i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MQSAD_U32_U8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1127,
        GIR_Done,
      // Label 259: @6707
      GIM_Try, /*On fail goto*//*Label 260*/ 6757, // Rule ID 530 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_lerp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 1034:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)  =>  (V_LERP_U8:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LERP_U8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 530,
        GIR_Done,
      // Label 260: @6757
      GIM_Try, /*On fail goto*//*Label 261*/ 6807, // Rule ID 548 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_alignbit,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 488:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)  =>  (V_ALIGNBIT_B32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ALIGNBIT_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 548,
        GIR_Done,
      // Label 261: @6807
      GIM_Try, /*On fail goto*//*Label 262*/ 6857, // Rule ID 549 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_alignbyte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 489:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)  =>  (V_ALIGNBYTE_B32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ALIGNBYTE_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 549,
        GIR_Done,
      // Label 262: @6857
      GIM_Reject,
    // Label 251: @6858
    GIM_Try, /*On fail goto*//*Label 263*/ 7077,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/6,
      GIM_Try, /*On fail goto*//*Label 264*/ 6938, // Rule ID 755 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_interp_mov,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        // MIs[0] attrchan
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // MIs[0] attr
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/5, /*RC*/AMDGPU::M0_CLASSRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[f32] } 1024:{ *:[iPTR] }, (imm:{ *:[i32] }):$vsrc, (timm:{ *:[i32] }):$attrchan, (timm:{ *:[i32] }):$attr, M0:{ *:[i32] })  =>  (V_INTERP_MOV_F32:{ *:[f32] } (imm:{ *:[i32] }):$vsrc, (timm:{ *:[i32] }):$attr, (timm:{ *:[i32] }):$attrchan)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddRegister, /*InsnID*/1, AMDGPU::M0, /*AddRegisterRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/5, // M0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_INTERP_MOV_F32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // vsrc
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // attr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // attrchan
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 755,
        GIR_Done,
      // Label 264: @6938
      GIM_Try, /*On fail goto*//*Label 265*/ 7007, // Rule ID 752 //
        GIM_CheckFeatures, GIFBS_has32BankLDS,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_interp_p1,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // MIs[0] attrchan
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // MIs[0] attr
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/5, /*RC*/AMDGPU::M0_CLASSRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 1025:{ *:[iPTR] }, f32:{ *:[f32] }:$vsrc, (timm:{ *:[i32] }):$attrchan, (timm:{ *:[i32] }):$attr, M0:{ *:[i32] })  =>  (V_INTERP_P1_F32:{ *:[f32] } f32:{ *:[f32] }:$vsrc, (timm:{ *:[i32] }):$attr, (timm:{ *:[i32] }):$attrchan)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddRegister, /*InsnID*/1, AMDGPU::M0, /*AddRegisterRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/5, // M0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_INTERP_P1_F32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vsrc
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // attr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // attrchan
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 752,
        GIR_Done,
      // Label 265: @7007
      GIM_Try, /*On fail goto*//*Label 266*/ 7076, // Rule ID 753 //
        GIM_CheckFeatures, GIFBS_has16BankLDS,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_interp_p1,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // MIs[0] attrchan
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // MIs[0] attr
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/5, /*RC*/AMDGPU::M0_CLASSRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 1025:{ *:[iPTR] }, f32:{ *:[f32] }:$vsrc, (timm:{ *:[i32] }):$attrchan, (timm:{ *:[i32] }):$attr, M0:{ *:[i32] })  =>  (V_INTERP_P1_F32_16bank:{ *:[f32] } f32:{ *:[f32] }:$vsrc, (timm:{ *:[i32] }):$attr, (timm:{ *:[i32] }):$attrchan)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddRegister, /*InsnID*/1, AMDGPU::M0, /*AddRegisterRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/5, // M0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_INTERP_P1_F32_16bank,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vsrc
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // attr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // attrchan
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 753,
        GIR_Done,
      // Label 266: @7076
      GIM_Reject,
    // Label 263: @7077
    GIM_Try, /*On fail goto*//*Label 267*/ 7155, // Rule ID 754 //
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/7,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_interp_p2,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // MIs[0] attrchan
      GIM_CheckIsImm, /*MI*/0, /*Op*/4,
      // MIs[0] attr
      GIM_CheckIsImm, /*MI*/0, /*Op*/5,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/6, /*RC*/AMDGPU::M0_CLASSRegClassID,
      // (intrinsic_wo_chain:{ *:[f32] } 1027:{ *:[iPTR] }, f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$vsrc, (timm:{ *:[i32] }):$attrchan, (timm:{ *:[i32] }):$attr, M0:{ *:[i32] })  =>  (V_INTERP_P2_F32:{ *:[f32] } f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$vsrc, (timm:{ *:[i32] }):$attr, (timm:{ *:[i32] }):$attrchan)
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddRegister, /*InsnID*/1, AMDGPU::M0, /*AddRegisterRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/6, // M0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_INTERP_P2_F32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vsrc
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // attr
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // attrchan
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 754,
      GIR_Done,
    // Label 267: @7155
    GIM_Try, /*On fail goto*//*Label 268*/ 8621,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/8,
      GIM_Try, /*On fail goto*//*Label 269*/ 7233, // Rule ID 608 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_4x4x1f32,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1051:{ *:[iPTR] }, f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v4f32:{ *:[v4f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_4X4X1F32:{ *:[v4f32] } f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v4f32:{ *:[v4f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_4X4X1F32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 608,
        GIR_Done,
      // Label 269: @7233
      GIM_Try, /*On fail goto*//*Label 270*/ 7306, // Rule ID 609 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_4x4x4f16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1053:{ *:[iPTR] }, v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_4X4X4F16:{ *:[v4f32] } v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_4X4X4F16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 609,
        GIR_Done,
      // Label 270: @7306
      GIM_Try, /*On fail goto*//*Label 271*/ 7379, // Rule ID 610 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_i32_4x4x4i8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1058:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v4i32:{ *:[v4i32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_I32_4X4X4I8:{ *:[v4i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v4i32:{ *:[v4i32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_I32_4X4X4I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 610,
        GIR_Done,
      // Label 271: @7379
      GIM_Try, /*On fail goto*//*Label 272*/ 7452, // Rule ID 611 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_4x4x2bf16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1052:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_4X4X2BF16:{ *:[v4f32] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_4X4X2BF16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 611,
        GIR_Done,
      // Label 272: @7452
      GIM_Try, /*On fail goto*//*Label 273*/ 7525, // Rule ID 612 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_16x16x1f32,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v16f32] } 1040:{ *:[iPTR] }, f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v16f32:{ *:[v16f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_16X16X1F32:{ *:[v16f32] } f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v16f32:{ *:[v16f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_16X16X1F32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 612,
        GIR_Done,
      // Label 273: @7525
      GIM_Try, /*On fail goto*//*Label 274*/ 7598, // Rule ID 613 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_16x16x4f32,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1043:{ *:[iPTR] }, f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v4f32:{ *:[v4f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_16X16X4F32:{ *:[v4f32] } f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v4f32:{ *:[v4f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_16X16X4F32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 613,
        GIR_Done,
      // Label 274: @7598
      GIM_Try, /*On fail goto*//*Label 275*/ 7671, // Rule ID 614 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_16x16x4f16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v16f32] } 1042:{ *:[iPTR] }, v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_16X16X4F16:{ *:[v16f32] } v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_16X16X4F16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 614,
        GIR_Done,
      // Label 275: @7671
      GIM_Try, /*On fail goto*//*Label 276*/ 7744, // Rule ID 615 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_16x16x16f16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1039:{ *:[iPTR] }, v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_16X16X16F16:{ *:[v4f32] } v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_16X16X16F16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 615,
        GIR_Done,
      // Label 276: @7744
      GIM_Try, /*On fail goto*//*Label 277*/ 7817, // Rule ID 616 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_i32_16x16x4i8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v16i32] } 1055:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v16i32:{ *:[v16i32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_I32_16X16X4I8:{ *:[v16i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v16i32:{ *:[v16i32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_I32_16X16X4I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 616,
        GIR_Done,
      // Label 277: @7817
      GIM_Try, /*On fail goto*//*Label 278*/ 7890, // Rule ID 617 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_i32_16x16x16i8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v4i32] } 1054:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v4i32:{ *:[v4i32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_I32_16X16X16I8:{ *:[v4i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v4i32:{ *:[v4i32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_I32_16X16X16I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 617,
        GIR_Done,
      // Label 278: @7890
      GIM_Try, /*On fail goto*//*Label 279*/ 7963, // Rule ID 618 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_16x16x2bf16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v16f32] } 1041:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_16X16X2BF16:{ *:[v16f32] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_16X16X2BF16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 618,
        GIR_Done,
      // Label 279: @7963
      GIM_Try, /*On fail goto*//*Label 280*/ 8036, // Rule ID 619 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_16x16x8bf16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_128RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v4f32] } 1044:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_16X16X8BF16:{ *:[v4f32] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v4f32:{ *:[v4f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_16X16X8BF16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 619,
        GIR_Done,
      // Label 280: @8036
      GIM_Try, /*On fail goto*//*Label 281*/ 8109, // Rule ID 620 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_32x32x1f32,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v32s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v32s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_1024RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v32f32] } 1045:{ *:[iPTR] }, f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v32f32:{ *:[v32f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_32X32X1F32:{ *:[v32f32] } f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v32f32:{ *:[v32f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_32X32X1F32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 620,
        GIR_Done,
      // Label 281: @8109
      GIM_Try, /*On fail goto*//*Label 282*/ 8182, // Rule ID 621 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_32x32x2f32,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v16f32] } 1047:{ *:[iPTR] }, f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v16f32:{ *:[v16f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_32X32X2F32:{ *:[v16f32] } f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1, v16f32:{ *:[v16f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_32X32X2F32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 621,
        GIR_Done,
      // Label 282: @8182
      GIM_Try, /*On fail goto*//*Label 283*/ 8255, // Rule ID 622 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_32x32x4f16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v32s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v32s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_1024RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v32f32] } 1049:{ *:[iPTR] }, v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v32f32:{ *:[v32f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_32X32X4F16:{ *:[v32f32] } v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v32f32:{ *:[v32f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_32X32X4F16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 622,
        GIR_Done,
      // Label 283: @8255
      GIM_Try, /*On fail goto*//*Label 284*/ 8328, // Rule ID 623 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_32x32x8f16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v16f32] } 1050:{ *:[iPTR] }, v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_32X32X8F16:{ *:[v16f32] } v4f16:{ *:[v4f16] }:$src0, v4f16:{ *:[v4f16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_32X32X8F16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 623,
        GIR_Done,
      // Label 284: @8328
      GIM_Try, /*On fail goto*//*Label 285*/ 8401, // Rule ID 624 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_i32_32x32x4i8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v32s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v32s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_1024RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v32i32] } 1056:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v32i32:{ *:[v32i32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_I32_32X32X4I8:{ *:[v32i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v32i32:{ *:[v32i32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_I32_32X32X4I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 624,
        GIR_Done,
      // Label 285: @8401
      GIM_Try, /*On fail goto*//*Label 286*/ 8474, // Rule ID 625 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_i32_32x32x8i8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v16i32] } 1057:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v16i32:{ *:[v16i32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_I32_32X32X8I8:{ *:[v16i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, v16i32:{ *:[v16i32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_I32_32X32X8I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 625,
        GIR_Done,
      // Label 286: @8474
      GIM_Try, /*On fail goto*//*Label 287*/ 8547, // Rule ID 626 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_32x32x2bf16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v32s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v32s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_1024RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v32f32] } 1046:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v32f32:{ *:[v32f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_32X32X2BF16:{ *:[v32f32] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v32f32:{ *:[v32f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_32X32X2BF16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 626,
        GIR_Done,
      // Label 287: @8547
      GIM_Try, /*On fail goto*//*Label 288*/ 8620, // Rule ID 627 //
        GIM_CheckFeatures, GIFBS_HasMAIInsts,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_mfma_f32_32x32x4bf16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AReg_512RegClassID,
        // MIs[0] cbsz
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // MIs[0] abid
        GIM_CheckIsImm, /*MI*/0, /*Op*/6,
        // MIs[0] blgp
        GIM_CheckIsImm, /*MI*/0, /*Op*/7,
        // (intrinsic_wo_chain:{ *:[v16f32] } 1048:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)  =>  (V_MFMA_F32_32X32X4BF16:{ *:[v16f32] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1, v16f32:{ *:[v16f32] }:$src2, (timm:{ *:[i32] }):$cbsz, (timm:{ *:[i32] }):$abid, (timm:{ *:[i32] }):$blgp)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MFMA_F32_32X32X4BF16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // src2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // cbsz
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/6, // abid
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/7, // blgp
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 627,
        GIR_Done,
      // Label 288: @8620
      GIM_Reject,
    // Label 268: @8621
    GIM_Reject,
    // Label 10: @8622
    GIM_Try, /*On fail goto*//*Label 289*/ 8636, // Rule ID 66 //
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_barrier,
      // (intrinsic_void 1097:{ *:[iPTR] })  =>  (S_BARRIER)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_BARRIER,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 66,
      GIR_Done,
    // Label 289: @8636
    GIM_Try, /*On fail goto*//*Label 290*/ 8654, // Rule ID 629 //
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_dcache_inv,
      // (intrinsic_void 1099:{ *:[iPTR] })  =>  (S_DCACHE_INV)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_DCACHE_INV,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 629,
      GIR_Done,
    // Label 290: @8654
    GIM_Try, /*On fail goto*//*Label 291*/ 8674, // Rule ID 630 //
      GIM_CheckFeatures, GIFBS_isGFX7GFX8GFX9,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_dcache_inv_vol,
      // (intrinsic_void 1100:{ *:[iPTR] })  =>  (S_DCACHE_INV_VOL)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_DCACHE_INV_VOL,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 630,
      GIR_Done,
    // Label 291: @8674
    GIM_Try, /*On fail goto*//*Label 292*/ 8694, // Rule ID 631 //
      GIM_CheckFeatures, GIFBS_HasScalarStores_isGFX8Plus,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_dcache_wb,
      // (intrinsic_void 1101:{ *:[iPTR] })  =>  (S_DCACHE_WB)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_DCACHE_WB,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 631,
      GIR_Done,
    // Label 292: @8694
    GIM_Try, /*On fail goto*//*Label 293*/ 8714, // Rule ID 632 //
      GIM_CheckFeatures, GIFBS_HasScalarStores_isGFX8Plus,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_dcache_wb_vol,
      // (intrinsic_void 1102:{ *:[iPTR] })  =>  (S_DCACHE_WB_VOL)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_DCACHE_WB_VOL,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 632,
      GIR_Done,
    // Label 293: @8714
    GIM_Try, /*On fail goto*//*Label 294*/ 8734, // Rule ID 747 //
      GIM_CheckFeatures, GIFBS_isGFX6,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_buffer_wbinvl1_sc,
      // (intrinsic_void 509:{ *:[iPTR] })  =>  (BUFFER_WBINVL1_SC)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_WBINVL1_SC,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 747,
      GIR_Done,
    // Label 294: @8734
    GIM_Try, /*On fail goto*//*Label 295*/ 8752, // Rule ID 748 //
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_buffer_wbinvl1,
      // (intrinsic_void 508:{ *:[iPTR] })  =>  (BUFFER_WBINVL1)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_WBINVL1,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 748,
      GIR_Done,
    // Label 295: @8752
    GIM_Try, /*On fail goto*//*Label 296*/ 8772, // Rule ID 749 //
      GIM_CheckFeatures, GIFBS_isGFX7Plus,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_buffer_wbinvl1_vol,
      // (intrinsic_void 510:{ *:[iPTR] })  =>  (BUFFER_WBINVL1_VOL)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_WBINVL1_VOL,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 749,
      GIR_Done,
    // Label 296: @8772
    GIM_Try, /*On fail goto*//*Label 297*/ 8790, // Rule ID 762 //
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_wave_barrier,
      // (intrinsic_void 1153:{ *:[iPTR] })  =>  (WAVE_BARRIER)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::WAVE_BARRIER,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 762,
      GIR_Done,
    // Label 297: @8790
    GIM_Try, /*On fail goto*//*Label 298*/ 8808, // Rule ID 767 //
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_unreachable,
      // (intrinsic_void 1151:{ *:[iPTR] })  =>  (SI_MASKED_UNREACHABLE)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SI_MASKED_UNREACHABLE,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 767,
      GIR_Done,
    // Label 298: @8808
    GIM_Try, /*On fail goto*//*Label 299*/ 9035,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_Try, /*On fail goto*//*Label 300*/ 8838, // Rule ID 67 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_waitcnt,
        // MIs[0] simm16
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 1113:{ *:[iPTR] }, (timm:{ *:[i32] }):$simm16)  =>  (S_WAITCNT (timm:{ *:[i32] }):$simm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_WAITCNT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // simm16
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 67,
        GIR_Done,
      // Label 300: @8838
      GIM_Try, /*On fail goto*//*Label 301*/ 8863, // Rule ID 68 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_sleep,
        // MIs[0] simm16
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 1112:{ *:[iPTR] }, (timm:{ *:[i32] }):$simm16)  =>  (S_SLEEP (timm:{ *:[i32] }):$simm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_SLEEP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // simm16
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 68,
        GIR_Done,
      // Label 301: @8863
      GIM_Try, /*On fail goto*//*Label 302*/ 8888, // Rule ID 71 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_incperflevel,
        // MIs[0] simm16
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 1107:{ *:[iPTR] }, (timm:{ *:[i32] }):$simm16)  =>  (S_INCPERFLEVEL (timm:{ *:[i32] }):$simm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_INCPERFLEVEL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // simm16
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 71,
        GIR_Done,
      // Label 302: @8888
      GIM_Try, /*On fail goto*//*Label 303*/ 8913, // Rule ID 72 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_decperflevel,
        // MIs[0] simm16
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 1103:{ *:[iPTR] }, (timm:{ *:[i32] }):$simm16)  =>  (S_DECPERFLEVEL (timm:{ *:[i32] }):$simm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_DECPERFLEVEL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // simm16
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 72,
        GIR_Done,
      // Label 303: @8913
      GIM_Try, /*On fail goto*//*Label 304*/ 8940, // Rule ID 768 //
        GIM_CheckFeatures, GIFBS_isWave64,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_init_exec,
        // MIs[0] src
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 1022:{ *:[iPTR] }, (timm:{ *:[i64] }):$src)  =>  (SI_INIT_EXEC (timm:{ *:[i64] }):$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SI_INIT_EXEC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 768,
        GIR_Done,
      // Label 304: @8940
      GIM_Try, /*On fail goto*//*Label 305*/ 8970, // Rule ID 628 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_s_memtime,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 1109:{ *:[iPTR] })  =>  (S_MEMTIME:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_MEMTIME,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 628,
        GIR_Done,
      // Label 305: @8970
      GIM_Try, /*On fail goto*//*Label 306*/ 9002, // Rule ID 633 //
        GIM_CheckFeatures, GIFBS_isGFX8Plus,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_s_memrealtime,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 1108:{ *:[iPTR] })  =>  (S_MEMREALTIME:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_MEMREALTIME,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 633,
        GIR_Done,
      // Label 306: @9002
      GIM_Try, /*On fail goto*//*Label 307*/ 9034, // Rule ID 634 //
        GIM_CheckFeatures, GIFBS_isGFX10Plus,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::amdgcn_s_get_waveid_in_workgroup,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 1104:{ *:[iPTR] })  =>  (S_GET_WAVEID_IN_WORKGROUP:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_GET_WAVEID_IN_WORKGROUP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 634,
        GIR_Done,
      // Label 307: @9034
      GIM_Reject,
    // Label 299: @9035
    GIM_Try, /*On fail goto*//*Label 308*/ 9154,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 309*/ 9080, // Rule ID 69 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_sendmsg,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] simm16
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::M0_CLASSRegClassID,
        // (intrinsic_void 1110:{ *:[iPTR] }, (timm:{ *:[i32] }):$simm16, M0:{ *:[i32] })  =>  (S_SENDMSG (timm:{ *:[i32] }):$simm16)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddRegister, /*InsnID*/1, AMDGPU::M0, /*AddRegisterRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // M0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_SENDMSG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // simm16
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 69,
        GIR_Done,
      // Label 309: @9080
      GIM_Try, /*On fail goto*//*Label 310*/ 9120, // Rule ID 70 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_s_sendmsghalt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] simm16
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::M0_CLASSRegClassID,
        // (intrinsic_void 1111:{ *:[iPTR] }, (timm:{ *:[i32] }):$simm16, M0:{ *:[i32] })  =>  (S_SENDMSGHALT (timm:{ *:[i32] }):$simm16)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddRegister, /*InsnID*/1, AMDGPU::M0, /*AddRegisterRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // M0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_SENDMSGHALT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // simm16
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 70,
        GIR_Done,
      // Label 310: @9120
      GIM_Try, /*On fail goto*//*Label 311*/ 9153, // Rule ID 769 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::amdgcn_init_exec_from_input,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[0] shift
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_void 1023:{ *:[iPTR] }, i32:{ *:[i32] }:$input, (timm:{ *:[i32] }):$shift)  =>  (SI_INIT_EXEC_FROM_INPUT i32:{ *:[i32] }:$input, (timm:{ *:[i32] }):$shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SI_INIT_EXEC_FROM_INPUT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // input
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // shift
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 769,
        GIR_Done,
      // Label 311: @9153
      GIM_Reject,
    // Label 308: @9154
    GIM_Reject,
    // Label 11: @9155
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 10, /*)*//*default:*//*Label 314*/ 9207,
    /*GILLT_s16*//*Label 312*/ 9163,
    /*GILLT_s32*//*Label 313*/ 9185,
    // Label 312: @9163
    GIM_Try, /*On fail goto*//*Label 315*/ 9184, // Rule ID 2633 //
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i16] }):$imm  =>  (S_MOV_B32:{ *:[i16] } (imm:{ *:[i16] }):$imm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_MOV_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2633,
      GIR_Done,
    // Label 315: @9184
    GIM_Reject,
    // Label 313: @9185
    GIM_Try, /*On fail goto*//*Label 316*/ 9206, // Rule ID 2234 //
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i32] }):$imm  =>  (S_MOV_B32:{ *:[i32] } (imm:{ *:[i32] }):$imm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_MOV_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2234,
      GIR_Done,
    // Label 316: @9206
    GIM_Reject,
    // Label 314: @9207
    GIM_Reject,
    // Label 12: @9208
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 11, /*)*//*default:*//*Label 320*/ 9416,
    /*GILLT_s16*//*Label 317*/ 9217,
    /*GILLT_s32*//*Label 318*/ 9254,
    /*GILLT_s64*//*Label 319*/ 9334,
    // Label 317: @9217
    GIM_Try, /*On fail goto*//*Label 321*/ 9253, // Rule ID 511 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (shl:{ *:[i16] } i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src0)  =>  (V_LSHLREV_B16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHLREV_B16_e64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 511,
      GIR_Done,
    // Label 321: @9253
    GIM_Reject,
    // Label 318: @9254
    GIM_Try, /*On fail goto*//*Label 322*/ 9333,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 323*/ 9288, // Rule ID 37 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        // (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)  =>  (S_LSHL_B32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_LSHL_B32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 37,
        GIR_Done,
      // Label 323: @9288
      GIM_Try, /*On fail goto*//*Label 324*/ 9314, // Rule ID 480 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (shl:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0)  =>  (V_LSHLREV_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHLREV_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 480,
        GIR_Done,
      // Label 324: @9314
      GIM_Try, /*On fail goto*//*Label 325*/ 9332, // Rule ID 508 //
        GIM_CheckFeatures, GIFBS_isGFX6GFX7GFX10,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (shl:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_LSHL_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_LSHL_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 508,
        GIR_Done,
      // Label 325: @9332
      GIM_Reject,
    // Label 322: @9333
    GIM_Reject,
    // Label 319: @9334
    GIM_Try, /*On fail goto*//*Label 326*/ 9415,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 327*/ 9368, // Rule ID 38 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        // (shl:{ *:[i64] } SSrc_b64:{ *:[i64] }:$src0, SSrc_b32:{ *:[i32] }:$src1)  =>  (S_LSHL_B64:{ *:[i64] }:{ *:[i1] } SSrc_b64:{ *:[i64] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_LSHL_B64,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 38,
        GIR_Done,
      // Label 327: @9368
      GIM_Try, /*On fail goto*//*Label 328*/ 9386, // Rule ID 566 //
        GIM_CheckFeatures, GIFBS_isGFX6GFX7GFX10,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        // (shl:{ *:[i64] } i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_LSHL_B64:{ *:[i64] } i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_LSHL_B64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 566,
        GIR_Done,
      // Label 328: @9386
      GIM_Try, /*On fail goto*//*Label 329*/ 9414, // Rule ID 569 //
        GIM_CheckFeatures, GIFBS_isGFX8Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        // (shl:{ *:[i64] } i64:{ *:[i64] }:$src1, i32:{ *:[i32] }:$src0)  =>  (V_LSHLREV_B64:{ *:[i64] } i32:{ *:[i32] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHLREV_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 569,
        GIR_Done,
      // Label 329: @9414
      GIM_Reject,
    // Label 326: @9415
    GIM_Reject,
    // Label 320: @9416
    GIM_Reject,
    // Label 13: @9417
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 11, /*)*//*default:*//*Label 333*/ 9625,
    /*GILLT_s16*//*Label 330*/ 9426,
    /*GILLT_s32*//*Label 331*/ 9463,
    /*GILLT_s64*//*Label 332*/ 9543,
    // Label 330: @9426
    GIM_Try, /*On fail goto*//*Label 334*/ 9462, // Rule ID 512 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (srl:{ *:[i16] } i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src0)  =>  (V_LSHRREV_B16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHRREV_B16_e64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 512,
      GIR_Done,
    // Label 334: @9462
    GIM_Reject,
    // Label 331: @9463
    GIM_Try, /*On fail goto*//*Label 335*/ 9542,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 336*/ 9497, // Rule ID 39 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        // (srl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)  =>  (S_LSHR_B32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_LSHR_B32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 39,
        GIR_Done,
      // Label 336: @9497
      GIM_Try, /*On fail goto*//*Label 337*/ 9523, // Rule ID 478 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0)  =>  (V_LSHRREV_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHRREV_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 478,
        GIR_Done,
      // Label 337: @9523
      GIM_Try, /*On fail goto*//*Label 338*/ 9541, // Rule ID 506 //
        GIM_CheckFeatures, GIFBS_isGFX6GFX7GFX10,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_LSHR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_LSHR_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 506,
        GIR_Done,
      // Label 338: @9541
      GIM_Reject,
    // Label 335: @9542
    GIM_Reject,
    // Label 332: @9543
    GIM_Try, /*On fail goto*//*Label 339*/ 9624,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 340*/ 9577, // Rule ID 40 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        // (srl:{ *:[i64] } SSrc_b64:{ *:[i64] }:$src0, SSrc_b32:{ *:[i32] }:$src1)  =>  (S_LSHR_B64:{ *:[i64] }:{ *:[i1] } SSrc_b64:{ *:[i64] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_LSHR_B64,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 40,
        GIR_Done,
      // Label 340: @9577
      GIM_Try, /*On fail goto*//*Label 341*/ 9595, // Rule ID 567 //
        GIM_CheckFeatures, GIFBS_isGFX6GFX7GFX10,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        // (srl:{ *:[i64] } i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_LSHR_B64:{ *:[i64] } i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_LSHR_B64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 567,
        GIR_Done,
      // Label 341: @9595
      GIM_Try, /*On fail goto*//*Label 342*/ 9623, // Rule ID 570 //
        GIM_CheckFeatures, GIFBS_isGFX8Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        // (srl:{ *:[i64] } i64:{ *:[i64] }:$src1, i32:{ *:[i32] }:$src0)  =>  (V_LSHRREV_B64:{ *:[i64] } i32:{ *:[i32] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHRREV_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 570,
        GIR_Done,
      // Label 342: @9623
      GIM_Reject,
    // Label 339: @9624
    GIM_Reject,
    // Label 333: @9625
    GIM_Reject,
    // Label 14: @9626
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 11, /*)*//*default:*//*Label 346*/ 9834,
    /*GILLT_s16*//*Label 343*/ 9635,
    /*GILLT_s32*//*Label 344*/ 9672,
    /*GILLT_s64*//*Label 345*/ 9752,
    // Label 343: @9635
    GIM_Try, /*On fail goto*//*Label 347*/ 9671, // Rule ID 513 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (sra:{ *:[i16] } i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src0)  =>  (V_ASHRREV_I16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ASHRREV_I16_e64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 513,
      GIR_Done,
    // Label 347: @9671
    GIM_Reject,
    // Label 344: @9672
    GIM_Try, /*On fail goto*//*Label 348*/ 9751,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 349*/ 9706, // Rule ID 41 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        // (sra:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)  =>  (S_ASHR_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_ASHR_I32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 41,
        GIR_Done,
      // Label 349: @9706
      GIM_Try, /*On fail goto*//*Label 350*/ 9732, // Rule ID 479 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0)  =>  (V_ASHRREV_I32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ASHRREV_I32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 479,
        GIR_Done,
      // Label 350: @9732
      GIM_Try, /*On fail goto*//*Label 351*/ 9750, // Rule ID 507 //
        GIM_CheckFeatures, GIFBS_isGFX6GFX7GFX10,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_ASHR_I32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_ASHR_I32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 507,
        GIR_Done,
      // Label 351: @9750
      GIM_Reject,
    // Label 348: @9751
    GIM_Reject,
    // Label 345: @9752
    GIM_Try, /*On fail goto*//*Label 352*/ 9833,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 353*/ 9786, // Rule ID 42 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        // (sra:{ *:[i64] } SSrc_b64:{ *:[i64] }:$src0, SSrc_b32:{ *:[i32] }:$src1)  =>  (S_ASHR_I64:{ *:[i64] }:{ *:[i1] } SSrc_b64:{ *:[i64] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_ASHR_I64,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 42,
        GIR_Done,
      // Label 353: @9786
      GIM_Try, /*On fail goto*//*Label 354*/ 9804, // Rule ID 568 //
        GIM_CheckFeatures, GIFBS_isGFX6GFX7GFX10,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        // (sra:{ *:[i64] } i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_ASHR_I64:{ *:[i64] } i64:{ *:[i64] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_ASHR_I64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 568,
        GIR_Done,
      // Label 354: @9804
      GIM_Try, /*On fail goto*//*Label 355*/ 9832, // Rule ID 571 //
        GIM_CheckFeatures, GIFBS_isGFX8Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        // (sra:{ *:[i64] } i64:{ *:[i64] }:$src1, i32:{ *:[i32] }:$src0)  =>  (V_ASHRREV_I64:{ *:[i64] } i32:{ *:[i32] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ASHRREV_I64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 571,
        GIR_Done,
      // Label 355: @9832
      GIM_Reject,
    // Label 352: @9833
    GIM_Reject,
    // Label 346: @9834
    GIM_Reject,
    // Label 15: @9835
    GIM_Try, /*On fail goto*//*Label 356*/ 10719,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s1,
      GIM_SwitchType, /*MI*/0, /*Op*/2, /*[*/8, 11, /*)*//*default:*//*Label 360*/ 10374,
      /*GILLT_s16*//*Label 357*/ 9850,
      /*GILLT_s32*//*Label 358*/ 10142,
      /*GILLT_s64*//*Label 359*/ 10258,
      // Label 357: @9850
      GIM_Try, /*On fail goto*//*Label 361*/ 10141,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_1RegClassID,
        GIM_Try, /*On fail goto*//*Label 362*/ 9888, // Rule ID 253 //
          GIM_CheckFeatures, GIFBS_Has16BitInsts,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SLT,
          // (setcc:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, SETLT:{ *:[Other] })  =>  (V_CMP_LT_I16_e64:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_LT_I16_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 253,
          GIR_Done,
        // Label 362: @9888
        GIM_Try, /*On fail goto*//*Label 363*/ 9916, // Rule ID 255 //
          GIM_CheckFeatures, GIFBS_Has16BitInsts,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SLE,
          // (setcc:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, SETLE:{ *:[Other] })  =>  (V_CMP_LE_I16_e64:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_LE_I16_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 255,
          GIR_Done,
        // Label 363: @9916
        GIM_Try, /*On fail goto*//*Label 364*/ 9944, // Rule ID 256 //
          GIM_CheckFeatures, GIFBS_Has16BitInsts,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SGT,
          // (setcc:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, SETGT:{ *:[Other] })  =>  (V_CMP_GT_I16_e64:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_GT_I16_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 256,
          GIR_Done,
        // Label 364: @9944
        GIM_Try, /*On fail goto*//*Label 365*/ 9972, // Rule ID 258 //
          GIM_CheckFeatures, GIFBS_Has16BitInsts,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SGE,
          // (setcc:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, SETGE:{ *:[Other] })  =>  (V_CMP_GE_I16_e64:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_GE_I16_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 258,
          GIR_Done,
        // Label 365: @9972
        GIM_Try, /*On fail goto*//*Label 366*/ 10000, // Rule ID 261 //
          GIM_CheckFeatures, GIFBS_Has16BitInsts,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_ULT,
          // (setcc:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, SETULT:{ *:[Other] })  =>  (V_CMP_LT_U16_e64:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_LT_U16_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 261,
          GIR_Done,
        // Label 366: @10000
        GIM_Try, /*On fail goto*//*Label 367*/ 10028, // Rule ID 262 //
          GIM_CheckFeatures, GIFBS_Has16BitInsts,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_EQ,
          // (setcc:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, SETEQ:{ *:[Other] })  =>  (V_CMP_EQ_U16_e64:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_EQ_U16_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 262,
          GIR_Done,
        // Label 367: @10028
        GIM_Try, /*On fail goto*//*Label 368*/ 10056, // Rule ID 264 //
          GIM_CheckFeatures, GIFBS_Has16BitInsts,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_ULE,
          // (setcc:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, SETULE:{ *:[Other] })  =>  (V_CMP_LE_U16_e64:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_LE_U16_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 264,
          GIR_Done,
        // Label 368: @10056
        GIM_Try, /*On fail goto*//*Label 369*/ 10084, // Rule ID 265 //
          GIM_CheckFeatures, GIFBS_Has16BitInsts,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_UGT,
          // (setcc:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, SETUGT:{ *:[Other] })  =>  (V_CMP_GT_U16_e64:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_GT_U16_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 265,
          GIR_Done,
        // Label 369: @10084
        GIM_Try, /*On fail goto*//*Label 370*/ 10112, // Rule ID 266 //
          GIM_CheckFeatures, GIFBS_Has16BitInsts,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_NE,
          // (setcc:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, SETNE:{ *:[Other] })  =>  (V_CMP_NE_U16_e64:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_NE_U16_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 266,
          GIR_Done,
        // Label 370: @10112
        GIM_Try, /*On fail goto*//*Label 371*/ 10140, // Rule ID 268 //
          GIM_CheckFeatures, GIFBS_Has16BitInsts,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_UGE,
          // (setcc:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, SETUGE:{ *:[Other] })  =>  (V_CMP_GE_U16_e64:{ *:[i1] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_GE_U16_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 268,
          GIR_Done,
        // Label 371: @10140
        GIM_Reject,
      // Label 361: @10141
      GIM_Reject,
      // Label 358: @10142
      GIM_Try, /*On fail goto*//*Label 372*/ 10257,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_1RegClassID,
        GIM_Try, /*On fail goto*//*Label 373*/ 10178, // Rule ID 287 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SLT,
          // (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETLT:{ *:[Other] })  =>  (V_CMP_LT_I32_e64:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_LT_I32_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 287,
          GIR_Done,
        // Label 373: @10178
        GIM_Try, /*On fail goto*//*Label 374*/ 10204, // Rule ID 289 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SLE,
          // (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETLE:{ *:[Other] })  =>  (V_CMP_LE_I32_e64:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_LE_I32_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 289,
          GIR_Done,
        // Label 374: @10204
        GIM_Try, /*On fail goto*//*Label 375*/ 10230, // Rule ID 290 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SGT,
          // (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETGT:{ *:[Other] })  =>  (V_CMP_GT_I32_e64:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_GT_I32_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 290,
          GIR_Done,
        // Label 375: @10230
        GIM_Try, /*On fail goto*//*Label 376*/ 10256, // Rule ID 292 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SGE,
          // (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETGE:{ *:[Other] })  =>  (V_CMP_GE_I32_e64:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_GE_I32_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 292,
          GIR_Done,
        // Label 376: @10256
        GIM_Reject,
      // Label 372: @10257
      GIM_Reject,
      // Label 359: @10258
      GIM_Try, /*On fail goto*//*Label 377*/ 10373,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_1RegClassID,
        GIM_Try, /*On fail goto*//*Label 378*/ 10294, // Rule ID 303 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SLT,
          // (setcc:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1, SETLT:{ *:[Other] })  =>  (V_CMP_LT_I64_e64:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_LT_I64_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 303,
          GIR_Done,
        // Label 378: @10294
        GIM_Try, /*On fail goto*//*Label 379*/ 10320, // Rule ID 305 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SLE,
          // (setcc:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1, SETLE:{ *:[Other] })  =>  (V_CMP_LE_I64_e64:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_LE_I64_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 305,
          GIR_Done,
        // Label 379: @10320
        GIM_Try, /*On fail goto*//*Label 380*/ 10346, // Rule ID 306 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SGT,
          // (setcc:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1, SETGT:{ *:[Other] })  =>  (V_CMP_GT_I64_e64:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_GT_I64_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 306,
          GIR_Done,
        // Label 380: @10346
        GIM_Try, /*On fail goto*//*Label 381*/ 10372, // Rule ID 308 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SGE,
          // (setcc:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1, SETGE:{ *:[Other] })  =>  (V_CMP_GE_I64_e64:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_GE_I64_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 308,
          GIR_Done,
        // Label 381: @10372
        GIM_Reject,
      // Label 377: @10373
      GIM_Reject,
      // Label 360: @10374
      GIM_SwitchType, /*MI*/0, /*Op*/2, /*[*/9, 11, /*)*//*default:*//*Label 384*/ 10718,
      /*GILLT_s32*//*Label 382*/ 10382,
      /*GILLT_s64*//*Label 383*/ 10550,
      // Label 382: @10382
      GIM_Try, /*On fail goto*//*Label 385*/ 10549,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_1RegClassID,
        GIM_Try, /*On fail goto*//*Label 386*/ 10418, // Rule ID 319 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_ULT,
          // (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETULT:{ *:[Other] })  =>  (V_CMP_LT_U32_e64:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_LT_U32_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 319,
          GIR_Done,
        // Label 386: @10418
        GIM_Try, /*On fail goto*//*Label 387*/ 10444, // Rule ID 320 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_EQ,
          // (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETEQ:{ *:[Other] })  =>  (V_CMP_EQ_U32_e64:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_EQ_U32_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 320,
          GIR_Done,
        // Label 387: @10444
        GIM_Try, /*On fail goto*//*Label 388*/ 10470, // Rule ID 322 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_ULE,
          // (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETULE:{ *:[Other] })  =>  (V_CMP_LE_U32_e64:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_LE_U32_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 322,
          GIR_Done,
        // Label 388: @10470
        GIM_Try, /*On fail goto*//*Label 389*/ 10496, // Rule ID 323 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_UGT,
          // (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETUGT:{ *:[Other] })  =>  (V_CMP_GT_U32_e64:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_GT_U32_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 323,
          GIR_Done,
        // Label 389: @10496
        GIM_Try, /*On fail goto*//*Label 390*/ 10522, // Rule ID 324 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_NE,
          // (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETNE:{ *:[Other] })  =>  (V_CMP_NE_U32_e64:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_NE_U32_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 324,
          GIR_Done,
        // Label 390: @10522
        GIM_Try, /*On fail goto*//*Label 391*/ 10548, // Rule ID 326 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_UGE,
          // (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETUGE:{ *:[Other] })  =>  (V_CMP_GE_U32_e64:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_GE_U32_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 326,
          GIR_Done,
        // Label 391: @10548
        GIM_Reject,
      // Label 385: @10549
      GIM_Reject,
      // Label 383: @10550
      GIM_Try, /*On fail goto*//*Label 392*/ 10717,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_1RegClassID,
        GIM_Try, /*On fail goto*//*Label 393*/ 10586, // Rule ID 337 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_ULT,
          // (setcc:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1, SETULT:{ *:[Other] })  =>  (V_CMP_LT_U64_e64:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_LT_U64_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 337,
          GIR_Done,
        // Label 393: @10586
        GIM_Try, /*On fail goto*//*Label 394*/ 10612, // Rule ID 338 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_EQ,
          // (setcc:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1, SETEQ:{ *:[Other] })  =>  (V_CMP_EQ_U64_e64:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_EQ_U64_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 338,
          GIR_Done,
        // Label 394: @10612
        GIM_Try, /*On fail goto*//*Label 395*/ 10638, // Rule ID 340 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_ULE,
          // (setcc:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1, SETULE:{ *:[Other] })  =>  (V_CMP_LE_U64_e64:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_LE_U64_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 340,
          GIR_Done,
        // Label 395: @10638
        GIM_Try, /*On fail goto*//*Label 396*/ 10664, // Rule ID 341 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_UGT,
          // (setcc:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1, SETUGT:{ *:[Other] })  =>  (V_CMP_GT_U64_e64:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_GT_U64_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 341,
          GIR_Done,
        // Label 396: @10664
        GIM_Try, /*On fail goto*//*Label 397*/ 10690, // Rule ID 342 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_NE,
          // (setcc:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1, SETNE:{ *:[Other] })  =>  (V_CMP_NE_U64_e64:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_NE_U64_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 342,
          GIR_Done,
        // Label 397: @10690
        GIM_Try, /*On fail goto*//*Label 398*/ 10716, // Rule ID 344 //
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_UGE,
          // (setcc:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1, SETUGE:{ *:[Other] })  =>  (V_CMP_GE_U64_e64:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CMP_GE_U64_e64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // src1
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 344,
          GIR_Done,
        // Label 398: @10716
        GIM_Reject,
      // Label 392: @10717
      GIM_Reject,
      // Label 384: @10718
      GIM_Reject,
    // Label 356: @10719
    GIM_Reject,
    // Label 16: @10720
    GIM_Try, /*On fail goto*//*Label 399*/ 10748, // Rule ID 539 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (mulhu:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MUL_HI_U32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MUL_HI_U32,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 539,
      GIR_Done,
    // Label 399: @10748
    GIM_Reject,
    // Label 17: @10749
    GIM_Try, /*On fail goto*//*Label 400*/ 10777, // Rule ID 540 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (mulhs:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MUL_HI_I32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MUL_HI_I32,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 540,
      GIR_Done,
    // Label 400: @10777
    GIM_Reject,
    // Label 18: @10778
    GIM_Try, /*On fail goto*//*Label 401*/ 10848, // Rule ID 2245 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (fpow:{ *:[f32] } f32:{ *:[f32] }:$src0, f32:{ *:[f32] }:$src1)  =>  (V_EXP_F32_e32:{ *:[f32] } (V_MUL_LEGACY_F32_e32:{ *:[i16] } f32:{ *:[f32] }:$src1, (V_LOG_F32_e32:{ *:[i16] } f32:{ *:[f32] }:$src0)))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_LOG_F32_e32,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_MUL_LEGACY_F32_e32,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // src1
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_EXP_F32_e32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2245,
      GIR_Done,
    // Label 401: @10848
    GIM_Reject,
    // Label 19: @10849
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 12, /*)*//*default:*//*Label 406*/ 11694,
    /*GILLT_s16*//*Label 402*/ 10859,
    /*GILLT_s32*//*Label 403*/ 11073,
    /*GILLT_s64*//*Label 404*/ 11229,
    /*GILLT_v2s16*//*Label 405*/ 11480,
    // Label 402: @10859
    GIM_Try, /*On fail goto*//*Label 407*/ 11072,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 408*/ 10923, // Rule ID 2212 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FABS,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f16] } (fabs:{ *:[f16] } SReg_32:{ *:[f16] }:$src))  =>  (S_OR_B32:{ *:[f16] }:{ *:[i1] } SReg_32:{ *:[f16] }:$src, (S_MOV_B32:{ *:[i1] } 32768:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/32768,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_OR_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2212,
        GIR_Done,
      // Label 408: @10923
      GIM_Try, /*On fail goto*//*Label 409*/ 10981, // Rule ID 2213 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FABS,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f16] } (fabs:{ *:[f16] } VGPR_32:{ *:[f16] }:$src))  =>  (V_OR_B32_e32:{ *:[f16] } (S_MOV_B32:{ *:[i16] } 32768:{ *:[i32] }), VGPR_32:{ *:[f16] }:$src)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/32768,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_OR_B32_e32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2213,
        GIR_Done,
      // Label 409: @10981
      GIM_Try, /*On fail goto*//*Label 410*/ 11026, // Rule ID 2209 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        // (fneg:{ *:[f16] } SReg_32:{ *:[f16] }:$src)  =>  (S_XOR_B32:{ *:[f16] }:{ *:[i1] } SReg_32:{ *:[f16] }:$src, (S_MOV_B32:{ *:[i1] } 32768:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/32768,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_XOR_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2209,
        GIR_Done,
      // Label 410: @11026
      GIM_Try, /*On fail goto*//*Label 411*/ 11071, // Rule ID 2210 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (fneg:{ *:[f16] } VGPR_32:{ *:[f16] }:$src)  =>  (V_XOR_B32_e32:{ *:[f16] } (S_MOV_B32:{ *:[i16] } 32768:{ *:[i32] }), VGPR_32:{ *:[f16] }:$src)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/32768,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XOR_B32_e32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2210,
        GIR_Done,
      // Label 411: @11071
      GIM_Reject,
    // Label 407: @11072
    GIM_Reject,
    // Label 403: @11073
    GIM_Try, /*On fail goto*//*Label 412*/ 11228,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 413*/ 11137, // Rule ID 2206 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FABS,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f32] } (fabs:{ *:[f32] } SReg_32:{ *:[f32] }:$src))  =>  (S_OR_B32:{ *:[f32] }:{ *:[i1] } SReg_32:{ *:[f32] }:$src, (S_MOV_B32:{ *:[i1] } 2147483648:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/2147483648,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_OR_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2206,
        GIR_Done,
      // Label 413: @11137
      GIM_Try, /*On fail goto*//*Label 414*/ 11182, // Rule ID 2208 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        // (fneg:{ *:[f32] } SReg_32:{ *:[f32] }:$src)  =>  (S_XOR_B32:{ *:[f32] }:{ *:[i1] } SReg_32:{ *:[f32] }:$src, (S_MOV_B32:{ *:[i1] } 2147483648:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/2147483648,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_XOR_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2208,
        GIR_Done,
      // Label 414: @11182
      GIM_Try, /*On fail goto*//*Label 415*/ 11227, // Rule ID 2219 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (fneg:{ *:[f32] } VGPR_32:{ *:[f32] }:$src)  =>  (V_XOR_B32_e32:{ *:[f32] } (S_MOV_B32:{ *:[i16] } 2147483648:{ *:[i32] }), VGPR_32:{ *:[f32] }:$src)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/2147483648,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XOR_B32_e32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2219,
        GIR_Done,
      // Label 415: @11227
      GIM_Reject,
    // Label 412: @11228
    GIM_Reject,
    // Label 404: @11229
    GIM_Try, /*On fail goto*//*Label 416*/ 11479,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 417*/ 11365, // Rule ID 2226 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FABS,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f64] } (fabs:{ *:[f64] } VReg_64:{ *:[f64] }:$src))  =>  (REG_SEQUENCE:{ *:[f64] } VReg_64:{ *:[i32] }, (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[f64] }:$src, sub0:{ *:[i32] }), sub0:{ *:[i32] }, (V_OR_B32_e32:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[f64] }:$src, sub1:{ *:[i32] }), (V_MOV_B32_e32:{ *:[i16] } 2147483648:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/AMDGPU::V_MOV_B32_e32,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/2147483648,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/2, // src
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, /*RC VGPR_32*/12,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, /*RC VReg_64*/27,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_OR_B32_e32,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/1, // src
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC VGPR_32*/12,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC VReg_64*/27,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/1,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/2,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2226,
        GIR_Done,
      // Label 417: @11365
      GIM_Try, /*On fail goto*//*Label 418*/ 11478, // Rule ID 2225 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
        // (fneg:{ *:[f64] } VReg_64:{ *:[f64] }:$src)  =>  (REG_SEQUENCE:{ *:[f64] } VReg_64:{ *:[i32] }, (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[f64] }:$src, sub0:{ *:[i32] }), sub0:{ *:[i32] }, (V_XOR_B32_e32:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[f64] }:$src, sub1:{ *:[i32] }), (V_MOV_B32_e32:{ *:[i32] } 2147483648:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/AMDGPU::V_MOV_B32_e32,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/2147483648,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/2, // src
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, /*RC VGPR_32*/12,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, /*RC VReg_64*/27,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e32,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/1, // src
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC VGPR_32*/12,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC VReg_64*/27,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/1,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/2,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2225,
        GIR_Done,
      // Label 418: @11478
      GIM_Reject,
    // Label 416: @11479
    GIM_Reject,
    // Label 405: @11480
    GIM_Try, /*On fail goto*//*Label 419*/ 11693,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_Try, /*On fail goto*//*Label 420*/ 11544, // Rule ID 2217 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FABS,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[v2f16] } (fabs:{ *:[v2f16] } SReg_32:{ *:[v2f16] }:$src))  =>  (S_OR_B32:{ *:[v2f16] }:{ *:[i1] } SReg_32:{ *:[v2f16] }:$src, (S_MOV_B32:{ *:[i1] } 2147516416:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/2147516416,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_OR_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2217,
        GIR_Done,
      // Label 420: @11544
      GIM_Try, /*On fail goto*//*Label 421*/ 11602, // Rule ID 2223 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FABS,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[v2f16] } (fabs:{ *:[v2f16] } VGPR_32:{ *:[v2f16] }:$src))  =>  (V_OR_B32_e32:{ *:[v2f16] } (S_MOV_B32:{ *:[i16] } 2147516416:{ *:[i32] }), VGPR_32:{ *:[v2f16] }:$src)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/2147516416,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_OR_B32_e32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2223,
        GIR_Done,
      // Label 421: @11602
      GIM_Try, /*On fail goto*//*Label 422*/ 11647, // Rule ID 2214 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        // (fneg:{ *:[v2f16] } SReg_32:{ *:[v2f16] }:$src)  =>  (S_XOR_B32:{ *:[v2f16] }:{ *:[i1] } SReg_32:{ *:[v2f16] }:$src, (S_MOV_B32:{ *:[i1] } 2147516416:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/2147516416,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_XOR_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2214,
        GIR_Done,
      // Label 422: @11647
      GIM_Try, /*On fail goto*//*Label 423*/ 11692, // Rule ID 2221 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (fneg:{ *:[v2f16] } VGPR_32:{ *:[v2f16] }:$src)  =>  (V_XOR_B32_e32:{ *:[v2f16] } (S_MOV_B32:{ *:[i16] } 2147516416:{ *:[i32] }), VGPR_32:{ *:[v2f16] }:$src)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/2147516416,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XOR_B32_e32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2221,
        GIR_Done,
      // Label 423: @11692
      GIM_Reject,
    // Label 419: @11693
    GIM_Reject,
    // Label 406: @11694
    GIM_Reject,
    // Label 20: @11695
    GIM_Try, /*On fail goto*//*Label 424*/ 11741, // Rule ID 2112 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (fp_to_sint:{ *:[i32] } f16:{ *:[f16] }:$src)  =>  (V_CVT_I32_F32_e32:{ *:[i32] } (V_CVT_F32_F16_e32:{ *:[i16] } VSrc_b32:{ *:[f16] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_CVT_F32_F16_e32,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CVT_I32_F32_e32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2112,
      GIR_Done,
    // Label 424: @11741
    GIM_Reject,
    // Label 21: @11742
    GIM_Try, /*On fail goto*//*Label 425*/ 11788, // Rule ID 2113 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (fp_to_uint:{ *:[i32] } f16:{ *:[f16] }:$src)  =>  (V_CVT_U32_F32_e32:{ *:[i32] } (V_CVT_F32_F16_e32:{ *:[i16] } VSrc_b32:{ *:[f16] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_CVT_F32_F16_e32,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CVT_U32_F32_e32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2113,
      GIR_Done,
    // Label 425: @11788
    GIM_Reject,
    // Label 22: @11789
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 11, /*)*//*default:*//*Label 429*/ 11989,
    /*GILLT_s16*//*Label 426*/ 11798,
    /*GILLT_s32*//*Label 427*/ 11895,
    /*GILLT_s64*//*Label 428*/ 11934,
    // Label 426: @11798
    GIM_Try, /*On fail goto*//*Label 430*/ 11840, // Rule ID 2114 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (sint_to_fp:{ *:[f16] } i32:{ *:[i32] }:$src)  =>  (V_CVT_F16_F32_e32:{ *:[f16] } (V_CVT_F32_I32_e32:{ *:[i16] } VSrc_b32:{ *:[i32] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_CVT_F32_I32_e32,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CVT_F16_F32_e32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2114,
      GIR_Done,
    // Label 430: @11840
    GIM_Try, /*On fail goto*//*Label 431*/ 11894, // Rule ID 2304 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (sint_to_fp:{ *:[f16] } i1:{ *:[i1] }:$src)  =>  (V_CVT_F16_F32_e32:{ *:[f16] } (V_CNDMASK_B32_e64:{ *:[i16] } 0:{ *:[i32] }, 0:{ *:[i32] }, 0:{ *:[i32] }, 3212836864:{ *:[i32] }, SSrc_i1:{ *:[i1] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_CNDMASK_B32_e64,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/1, /*Imm*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/3212836864,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CVT_F16_F32_e32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2304,
      GIR_Done,
    // Label 431: @11894
    GIM_Reject,
    // Label 427: @11895
    GIM_Try, /*On fail goto*//*Label 432*/ 11933, // Rule ID 2306 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (sint_to_fp:{ *:[f32] } i1:{ *:[i1] }:$src)  =>  (V_CNDMASK_B32_e64:{ *:[f32] } 0:{ *:[i32] }, 0:{ *:[i32] }, 0:{ *:[i32] }, 3212836864:{ *:[i32] }, SSrc_i1:{ *:[i1] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CNDMASK_B32_e64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3212836864,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2306,
      GIR_Done,
    // Label 432: @11933
    GIM_Reject,
    // Label 428: @11934
    GIM_Try, /*On fail goto*//*Label 433*/ 11988, // Rule ID 2308 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      // (sint_to_fp:{ *:[f64] } i1:{ *:[i1] }:$src)  =>  (V_CVT_F64_I32_e32:{ *:[f64] } (V_CNDMASK_B32_e64:{ *:[i16] } 0:{ *:[i32] }, 0:{ *:[i32] }, 0:{ *:[i32] }, -1:{ *:[i32] }, SSrc_i1:{ *:[i1] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_CNDMASK_B32_e64,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/1, /*Imm*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/-1,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CVT_F64_I32_e32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2308,
      GIR_Done,
    // Label 433: @11988
    GIM_Reject,
    // Label 429: @11989
    GIM_Reject,
    // Label 23: @11990
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 11, /*)*//*default:*//*Label 437*/ 12190,
    /*GILLT_s16*//*Label 434*/ 11999,
    /*GILLT_s32*//*Label 435*/ 12096,
    /*GILLT_s64*//*Label 436*/ 12135,
    // Label 434: @11999
    GIM_Try, /*On fail goto*//*Label 438*/ 12041, // Rule ID 2115 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (uint_to_fp:{ *:[f16] } i32:{ *:[i32] }:$src)  =>  (V_CVT_F16_F32_e32:{ *:[f16] } (V_CVT_F32_U32_e32:{ *:[i16] } VSrc_b32:{ *:[i32] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_CVT_F32_U32_e32,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CVT_F16_F32_e32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2115,
      GIR_Done,
    // Label 438: @12041
    GIM_Try, /*On fail goto*//*Label 439*/ 12095, // Rule ID 2305 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (uint_to_fp:{ *:[f16] } i1:{ *:[i1] }:$src)  =>  (V_CVT_F16_F32_e32:{ *:[f16] } (V_CNDMASK_B32_e64:{ *:[i16] } 0:{ *:[i32] }, 0:{ *:[i32] }, 0:{ *:[i32] }, 1065353216:{ *:[i32] }, SSrc_i1:{ *:[i1] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_CNDMASK_B32_e64,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/1, /*Imm*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/1065353216,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CVT_F16_F32_e32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2305,
      GIR_Done,
    // Label 439: @12095
    GIM_Reject,
    // Label 435: @12096
    GIM_Try, /*On fail goto*//*Label 440*/ 12134, // Rule ID 2307 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (uint_to_fp:{ *:[f32] } i1:{ *:[i1] }:$src)  =>  (V_CNDMASK_B32_e64:{ *:[f32] } 0:{ *:[i32] }, 0:{ *:[i32] }, 0:{ *:[i32] }, 1065353216:{ *:[i32] }, SSrc_i1:{ *:[i1] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CNDMASK_B32_e64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/1065353216,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2307,
      GIR_Done,
    // Label 440: @12134
    GIM_Reject,
    // Label 436: @12135
    GIM_Try, /*On fail goto*//*Label 441*/ 12189, // Rule ID 2309 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      // (uint_to_fp:{ *:[f64] } i1:{ *:[i1] }:$src)  =>  (V_CVT_F64_U32_e32:{ *:[f64] } (V_CNDMASK_B32_e64:{ *:[i16] } 0:{ *:[i32] }, 0:{ *:[i32] }, 0:{ *:[i32] }, 1:{ *:[i32] }, SSrc_i1:{ *:[i1] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_CNDMASK_B32_e64,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/1, /*Imm*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/1,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_CVT_F64_U32_e32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2309,
      GIR_Done,
    // Label 441: @12189
    GIM_Reject,
    // Label 437: @12190
    GIM_Reject,
    // Label 24: @12191
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 12, /*)*//*default:*//*Label 446*/ 12617,
    /*GILLT_s16*//*Label 442*/ 12201,
    /*GILLT_s32*//*Label 443*/ 12299,
    /*GILLT_s64*//*Label 444*/ 12397,
    /*GILLT_v2s16*//*Label 445*/ 12519,
    // Label 442: @12201
    GIM_Try, /*On fail goto*//*Label 447*/ 12298,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 448*/ 12252, // Rule ID 2211 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        // (fabs:{ *:[f16] } SReg_32:{ *:[f16] }:$src)  =>  (S_AND_B32:{ *:[f16] }:{ *:[i1] } SReg_32:{ *:[f16] }:$src, (S_MOV_B32:{ *:[i1] } 32767:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/32767,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_AND_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2211,
        GIR_Done,
      // Label 448: @12252
      GIM_Try, /*On fail goto*//*Label 449*/ 12297, // Rule ID 2220 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (fabs:{ *:[f16] } VGPR_32:{ *:[f16] }:$src)  =>  (V_AND_B32_e32:{ *:[f16] } (S_MOV_B32:{ *:[i16] } 32767:{ *:[i32] }), VGPR_32:{ *:[f16] }:$src)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/32767,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_AND_B32_e32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2220,
        GIR_Done,
      // Label 449: @12297
      GIM_Reject,
    // Label 447: @12298
    GIM_Reject,
    // Label 443: @12299
    GIM_Try, /*On fail goto*//*Label 450*/ 12396,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 451*/ 12350, // Rule ID 2207 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        // (fabs:{ *:[f32] } SReg_32:{ *:[f32] }:$src)  =>  (S_AND_B32:{ *:[f32] }:{ *:[i1] } SReg_32:{ *:[f32] }:$src, (S_MOV_B32:{ *:[i1] } 2147483647:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/2147483647,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_AND_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2207,
        GIR_Done,
      // Label 451: @12350
      GIM_Try, /*On fail goto*//*Label 452*/ 12395, // Rule ID 2218 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (fabs:{ *:[f32] } VGPR_32:{ *:[f32] }:$src)  =>  (V_AND_B32_e32:{ *:[f32] } (S_MOV_B32:{ *:[i16] } 2147483647:{ *:[i32] }), VGPR_32:{ *:[f32] }:$src)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/2147483647,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_AND_B32_e32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2218,
        GIR_Done,
      // Label 452: @12395
      GIM_Reject,
    // Label 450: @12396
    GIM_Reject,
    // Label 444: @12397
    GIM_Try, /*On fail goto*//*Label 453*/ 12518, // Rule ID 2224 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (fabs:{ *:[f64] } VReg_64:{ *:[f64] }:$src)  =>  (REG_SEQUENCE:{ *:[f64] } VReg_64:{ *:[i32] }, (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[f64] }:$src, sub0:{ *:[i32] }), sub0:{ *:[i32] }, (V_AND_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[f64] }:$src, sub1:{ *:[i32] }), (V_MOV_B32_e32:{ *:[i16] } 2147483647:{ *:[i32] })), sub1:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/AMDGPU::V_MOV_B32_e32,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/4, /*Imm*/2147483647,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/2, // src
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, /*RC VGPR_32*/12,
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, /*RC VReg_64*/27,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_AND_B32_e64,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC VGPR_32*/12,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC VReg_64*/27,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/1,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/2,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2224,
      GIR_Done,
    // Label 453: @12518
    GIM_Reject,
    // Label 445: @12519
    GIM_Try, /*On fail goto*//*Label 454*/ 12616,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_Try, /*On fail goto*//*Label 455*/ 12570, // Rule ID 2215 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        // (fabs:{ *:[v2f16] } SReg_32:{ *:[v2f16] }:$src)  =>  (S_AND_B32:{ *:[v2f16] }:{ *:[i1] } SReg_32:{ *:[v2f16] }:$src, (S_MOV_B32:{ *:[i1] } 2147450879:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/2147450879,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_AND_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2215,
        GIR_Done,
      // Label 455: @12570
      GIM_Try, /*On fail goto*//*Label 456*/ 12615, // Rule ID 2222 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (fabs:{ *:[v2f16] } VGPR_32:{ *:[v2f16] }:$src)  =>  (V_AND_B32_e32:{ *:[v2f16] } (S_MOV_B32:{ *:[i16] } 2147450879:{ *:[i32] }), VGPR_32:{ *:[v2f16] }:$src)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/2147450879,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_AND_B32_e32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2222,
        GIR_Done,
      // Label 456: @12615
      GIM_Reject,
    // Label 454: @12616
    GIM_Reject,
    // Label 446: @12617
    GIM_Reject,
    // Label 25: @12618
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 10, /*)*//*default:*//*Label 459*/ 12697,
    /*GILLT_s16*//*Label 457*/ 12626,
    /*GILLT_s32*//*Label 458*/ 12653,
    // Label 457: @12626
    GIM_Try, /*On fail goto*//*Label 460*/ 12652, // Rule ID 527 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (smin:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MIN_I16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MIN_I16_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 527,
      GIR_Done,
    // Label 460: @12652
    GIM_Reject,
    // Label 458: @12653
    GIM_Try, /*On fail goto*//*Label 461*/ 12696,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 462*/ 12679, // Rule ID 17 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (smin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (S_MIN_I32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_MIN_I32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 17,
        GIR_Done,
      // Label 462: @12679
      GIM_Try, /*On fail goto*//*Label 463*/ 12695, // Rule ID 471 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (smin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MIN_I32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MIN_I32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 471,
        GIR_Done,
      // Label 463: @12695
      GIM_Reject,
    // Label 461: @12696
    GIM_Reject,
    // Label 459: @12697
    GIM_Reject,
    // Label 26: @12698
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 10, /*)*//*default:*//*Label 466*/ 12777,
    /*GILLT_s16*//*Label 464*/ 12706,
    /*GILLT_s32*//*Label 465*/ 12733,
    // Label 464: @12706
    GIM_Try, /*On fail goto*//*Label 467*/ 12732, // Rule ID 525 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (smax:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MAX_I16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MAX_I16_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 525,
      GIR_Done,
    // Label 467: @12732
    GIM_Reject,
    // Label 465: @12733
    GIM_Try, /*On fail goto*//*Label 468*/ 12776,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 469*/ 12759, // Rule ID 19 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (smax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (S_MAX_I32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_MAX_I32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 19,
        GIR_Done,
      // Label 469: @12759
      GIM_Try, /*On fail goto*//*Label 470*/ 12775, // Rule ID 473 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (smax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MAX_I32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MAX_I32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 473,
        GIR_Done,
      // Label 470: @12775
      GIM_Reject,
    // Label 468: @12776
    GIM_Reject,
    // Label 466: @12777
    GIM_Reject,
    // Label 27: @12778
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 10, /*)*//*default:*//*Label 473*/ 12857,
    /*GILLT_s16*//*Label 471*/ 12786,
    /*GILLT_s32*//*Label 472*/ 12813,
    // Label 471: @12786
    GIM_Try, /*On fail goto*//*Label 474*/ 12812, // Rule ID 526 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (umin:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MIN_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MIN_U16_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 526,
      GIR_Done,
    // Label 474: @12812
    GIM_Reject,
    // Label 472: @12813
    GIM_Try, /*On fail goto*//*Label 475*/ 12856,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 476*/ 12839, // Rule ID 18 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (S_MIN_U32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_MIN_U32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 18,
        GIR_Done,
      // Label 476: @12839
      GIM_Try, /*On fail goto*//*Label 477*/ 12855, // Rule ID 475 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MIN_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MIN_U32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 475,
        GIR_Done,
      // Label 477: @12855
      GIM_Reject,
    // Label 475: @12856
    GIM_Reject,
    // Label 473: @12857
    GIM_Reject,
    // Label 28: @12858
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 10, /*)*//*default:*//*Label 480*/ 12937,
    /*GILLT_s16*//*Label 478*/ 12866,
    /*GILLT_s32*//*Label 479*/ 12893,
    // Label 478: @12866
    GIM_Try, /*On fail goto*//*Label 481*/ 12892, // Rule ID 524 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (umax:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MAX_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MAX_U16_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 524,
      GIR_Done,
    // Label 481: @12892
    GIM_Reject,
    // Label 479: @12893
    GIM_Try, /*On fail goto*//*Label 482*/ 12936,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 483*/ 12919, // Rule ID 20 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (S_MAX_U32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_MAX_U32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 20,
        GIR_Done,
      // Label 483: @12919
      GIM_Try, /*On fail goto*//*Label 484*/ 12935, // Rule ID 477 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_MAX_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MAX_U32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 477,
        GIR_Done,
      // Label 484: @12935
      GIM_Reject,
    // Label 482: @12936
    GIM_Reject,
    // Label 480: @12937
    GIM_Reject,
    // Label 29: @12938
    GIM_Try, /*On fail goto*//*Label 485*/ 12962,
      GIM_CheckIsMBB, /*MI*/0, /*Op*/0,
      GIM_Try, /*On fail goto*//*Label 486*/ 12952, // Rule ID 64 //
        // (br (bb:{ *:[Other] }):$simm16)  =>  (S_BRANCH (bb:{ *:[Other] }):$simm16)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_BRANCH,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64,
        GIR_Done,
      // Label 486: @12952
      GIM_Try, /*On fail goto*//*Label 487*/ 12961, // Rule ID 65 //
        // (br (bb:{ *:[Other] }):$simm16)  =>  (S_BRANCH_pad_s_nop (bb:{ *:[Other] }):$simm16)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_BRANCH_pad_s_nop,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65,
        GIR_Done,
      // Label 487: @12961
      GIM_Reject,
    // Label 485: @12962
    GIM_Reject,
    // Label 30: @12963
    GIM_Try, /*On fail goto*//*Label 488*/ 13041,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_SwitchType, /*MI*/0, /*Op*/1, /*[*/9, 11, /*)*//*default:*//*Label 491*/ 13011,
      /*GILLT_s32*//*Label 489*/ 12977,
      /*GILLT_s64*//*Label 490*/ 12994,
      // Label 489: @12977
      GIM_Try, /*On fail goto*//*Label 492*/ 12993, // Rule ID 3 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0)  =>  (S_BCNT1_I32_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_BCNT1_I32_B32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3,
        GIR_Done,
      // Label 492: @12993
      GIM_Reject,
      // Label 490: @12994
      GIM_Try, /*On fail goto*//*Label 493*/ 13010, // Rule ID 4 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (ctpop:{ *:[i32] } i64:{ *:[i64] }:$src0)  =>  (S_BCNT1_I32_B64:{ *:[i32] }:{ *:[i1] } i64:{ *:[i64] }:$src0)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_BCNT1_I32_B64,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4,
        GIR_Done,
      // Label 493: @13010
      GIM_Reject,
      // Label 491: @13011
      GIM_Try, /*On fail goto*//*Label 494*/ 13040, // Rule ID 2125 //
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$popcnt, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BCNT_U32_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // popcnt
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2125,
        GIR_Done,
      // Label 494: @13040
      GIM_Reject,
    // Label 488: @13041
    GIM_Reject,
    // Label 31: @13042
    GIM_Try, /*On fail goto*//*Label 495*/ 13082,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 496*/ 13065, // Rule ID 2 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (bitreverse:{ *:[i32] } i32:{ *:[i32] }:$src0)  =>  (S_BREV_B32:{ *:[i32] } i32:{ *:[i32] }:$src0)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_BREV_B32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2,
        GIR_Done,
      // Label 496: @13065
      GIM_Try, /*On fail goto*//*Label 497*/ 13081, // Rule ID 408 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (bitreverse:{ *:[i32] } i32:{ *:[i32] }:$src0)  =>  (V_BFREV_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_BFREV_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 408,
        GIR_Done,
      // Label 497: @13081
      GIM_Reject,
    // Label 495: @13082
    GIM_Reject,
    // Label 32: @13083
    GIM_Reject,
    };
  return MatchTable0;
}
#endif // ifdef GET_GLOBALISEL_IMPL
#ifdef GET_GLOBALISEL_PREDICATES_DECL
PredicateBitset AvailableModuleFeatures;
mutable PredicateBitset AvailableFunctionFeatures;
PredicateBitset getAvailableFeatures() const {
  return AvailableModuleFeatures | AvailableFunctionFeatures;
}
PredicateBitset
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const;
PredicateBitset
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget,
                                 const MachineFunction *MF) const;
#endif // ifdef GET_GLOBALISEL_PREDICATES_DECL
#ifdef GET_GLOBALISEL_PREDICATES_INIT
AvailableModuleFeatures(computeAvailableModuleFeatures(&STI)),
AvailableFunctionFeatures()
#endif // ifdef GET_GLOBALISEL_PREDICATES_INIT
