/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.namespace;

import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;

public final class NameSpaceHelper {
    private NameSpaceHelper() {
    }

    public static DependencyDescriptor toSystem(DependencyDescriptor dependencyDescriptor, Namespace namespace) {
        return DefaultDependencyDescriptor.transformInstance(dependencyDescriptor, namespace);
    }

    public static DependencyDescriptor transform(DependencyDescriptor dependencyDescriptor, NamespaceTransformer namespaceTransformer, boolean bl) {
        return DefaultDependencyDescriptor.transformInstance(dependencyDescriptor, namespaceTransformer, bl);
    }

    public static ModuleDescriptor toSystem(ModuleDescriptor moduleDescriptor, Namespace namespace) {
        return DefaultModuleDescriptor.transformInstance(moduleDescriptor, namespace);
    }

    public static ResolvedModuleRevision toSystem(ResolvedModuleRevision resolvedModuleRevision, Namespace namespace) {
        if (namespace.getToSystemTransformer().isIdentity()) {
            return resolvedModuleRevision;
        }
        ModuleDescriptor moduleDescriptor = NameSpaceHelper.toSystem(resolvedModuleRevision.getDescriptor(), namespace);
        if (moduleDescriptor.equals(resolvedModuleRevision.getDescriptor())) {
            return resolvedModuleRevision;
        }
        return new ResolvedModuleRevision(resolvedModuleRevision.getResolver(), resolvedModuleRevision.getArtifactResolver(), moduleDescriptor, NameSpaceHelper.transform(resolvedModuleRevision.getReport(), namespace.getToSystemTransformer()), resolvedModuleRevision.isForce());
    }

    public static Artifact transform(Artifact artifact, NamespaceTransformer namespaceTransformer) {
        if (namespaceTransformer.isIdentity()) {
            return artifact;
        }
        ModuleRevisionId moduleRevisionId = namespaceTransformer.transform(artifact.getModuleRevisionId());
        if (artifact.getModuleRevisionId().equals(moduleRevisionId)) {
            return artifact;
        }
        return new DefaultArtifact(moduleRevisionId, artifact.getPublicationDate(), artifact.getName(), artifact.getType(), artifact.getExt(), artifact.getUrl(), artifact.getQualifiedExtraAttributes());
    }

    public static MetadataArtifactDownloadReport transform(MetadataArtifactDownloadReport metadataArtifactDownloadReport, NamespaceTransformer namespaceTransformer) {
        if (namespaceTransformer.isIdentity()) {
            return metadataArtifactDownloadReport;
        }
        MetadataArtifactDownloadReport metadataArtifactDownloadReport2 = new MetadataArtifactDownloadReport(NameSpaceHelper.transform(metadataArtifactDownloadReport.getArtifact(), namespaceTransformer));
        metadataArtifactDownloadReport2.setSearched(metadataArtifactDownloadReport.isSearched());
        metadataArtifactDownloadReport2.setDownloadStatus(metadataArtifactDownloadReport.getDownloadStatus());
        metadataArtifactDownloadReport2.setDownloadDetails(metadataArtifactDownloadReport.getDownloadDetails());
        metadataArtifactDownloadReport2.setArtifactOrigin(metadataArtifactDownloadReport.getArtifactOrigin());
        metadataArtifactDownloadReport2.setDownloadTimeMillis(metadataArtifactDownloadReport.getDownloadTimeMillis());
        metadataArtifactDownloadReport2.setOriginalLocalFile(metadataArtifactDownloadReport.getOriginalLocalFile());
        metadataArtifactDownloadReport2.setLocalFile(metadataArtifactDownloadReport.getLocalFile());
        metadataArtifactDownloadReport2.setSize(metadataArtifactDownloadReport.getSize());
        return metadataArtifactDownloadReport2;
    }

    public static ArtifactId transform(ArtifactId artifactId, NamespaceTransformer namespaceTransformer) {
        if (namespaceTransformer.isIdentity()) {
            return artifactId;
        }
        ModuleId moduleId = NameSpaceHelper.transform(artifactId.getModuleId(), namespaceTransformer);
        if (moduleId.equals(artifactId.getModuleId())) {
            return artifactId;
        }
        return new ArtifactId(moduleId, artifactId.getName(), artifactId.getType(), artifactId.getExt());
    }

    public static ModuleId transform(ModuleId moduleId, NamespaceTransformer namespaceTransformer) {
        if (namespaceTransformer.isIdentity()) {
            return moduleId;
        }
        return namespaceTransformer.transform(new ModuleRevisionId(moduleId, "")).getModuleId();
    }

    public static String transformOrganisation(String string, NamespaceTransformer namespaceTransformer) {
        return NameSpaceHelper.transform(new ModuleId(string, ""), namespaceTransformer).getOrganisation();
    }
}

