S2 = Manifold(2, 'S^2', structure='topological')
U = S2.open_subset('U'); V = S2.open_subset('V'); S2.declare_union(U,V)
c_xy = U.chart('x y'); x, y = c_xy[:]
c_uv = V.chart('u v'); u, v = c_uv[:]
xy_to_uv = c_xy.transition_map(c_uv, (x/(x**2+y**2), y/(x**2+y**2)),
                  intersection_name='W', restrictions1= x**2+y**2!=0,
                  restrictions2= u**2+v**2!=0)
uv_to_xy = xy_to_uv.inverse()
c_uvW = c_uv.restrict(U.intersection(V))
gu1 = c_uvW.plot(c_xy, fixed_coords={u: 1}, max_range=20, plot_points=300)
gv1 = c_uvW.plot(c_xy, fixed_coords={v: 1}, max_range=20, plot_points=300,
                 color='green')
sphinx_plot(gu1+gv1)