/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class XToggleLineBreakpointActionHandler
extends DebuggerActionHandler {
    private final boolean myTemporary;

    public XToggleLineBreakpointActionHandler(boolean temporary) {
        this.myTemporary = temporary;
    }

    @Override
    public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
        Editor editor;
        if (project == null) {
            XToggleLineBreakpointActionHandler.$$$reportNull$$$0(0);
        }
        if ((editor = (Editor)event.getData(CommonDataKeys.EDITOR)) == null || DiffUtil.isDiffEditor(editor)) {
            return false;
        }
        XLineBreakpointType[] breakpointTypes = XDebuggerUtil.getInstance().getLineBreakpointTypes();
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        for (XSourcePosition position : XDebuggerUtilImpl.getAllCaretsPositions(project, event.getDataContext())) {
            for (XLineBreakpointType breakpointType : breakpointTypes) {
                int line2;
                VirtualFile file2 = position.getFile();
                if (!breakpointType.canPutAt(file2, line2 = position.getLine(), project) && breakpointManager.findBreakpointAtLine(breakpointType, file2, line2) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void perform(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            XToggleLineBreakpointActionHandler.$$$reportNull$$$0(1);
        }
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        HashSet<Integer> processedLines = new HashSet<Integer>();
        for (XSourcePosition position : XDebuggerUtilImpl.getAllCaretsPositions(project, event.getDataContext())) {
            if (!processedLines.add(position.getLine())) continue;
            XBreakpointUtil.toggleLineBreakpoint(project, position, editor, this.myTemporary, true, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/xdebugger/impl/actions/handlers/XToggleLineBreakpointActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

