/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class HintHint {
    private Component myOriginalComponent;
    private Point myOriginalPoint;
    private boolean myAwtTooltip = false;
    private Balloon.Position myPreferredPosition = Balloon.Position.below;
    private boolean myContentActive = true;
    private boolean myQuickHint = false;
    private boolean myMayCenterTooltip = false;
    private Color myTextFg;
    private Color myTextBg;
    private Color myBorderColor;
    private Border myComponentBorder = null;
    private Insets myBorderInsets;
    private Font myFont;
    private int myCalloutShift;
    private boolean myExplicitClose;
    private int myPositionChangeX;
    private int myPositionChangeY;
    private boolean myShowImmediately = false;
    private boolean myAnimationEnabled;
    private boolean myRequestFocus;

    public HintHint() {
    }

    public HintHint(MouseEvent e) {
        this(e.getComponent(), e.getPoint());
    }

    public HintHint(Editor editor, Point point) {
        this(editor.getContentComponent(), point);
    }

    public HintHint(Component originalComponent, Point originalPoint) {
        this.myOriginalComponent = originalComponent;
        this.myOriginalPoint = originalPoint;
    }

    public HintHint setAwtTooltip(boolean awtTooltip) {
        this.myAwtTooltip = awtTooltip;
        return this;
    }

    public HintHint setMayCenterPosition(boolean mayCenter) {
        this.myMayCenterTooltip = mayCenter;
        return this;
    }

    public boolean isMayCenterTooltip() {
        return this.myMayCenterTooltip;
    }

    public HintHint setPreferredPosition(Balloon.Position position) {
        this.myPreferredPosition = position;
        return this;
    }

    public boolean isAwtTooltip() {
        return this.myAwtTooltip;
    }

    public Component getOriginalComponent() {
        return this.myOriginalComponent;
    }

    public Point getOriginalPoint() {
        return this.myOriginalPoint;
    }

    public RelativePoint getTargetPoint() {
        return new RelativePoint(this.getOriginalComponent(), this.getOriginalPoint());
    }

    public Border getComponentBorder() {
        return this.myComponentBorder;
    }

    public void setComponentBorder(@Nullable Border border) {
        this.myComponentBorder = border;
    }

    public Balloon.Position getPreferredPosition() {
        return this.myPreferredPosition;
    }

    public Color getTextForeground() {
        return this.myTextFg != null ? this.myTextFg : this.getTooltipManager().getTextForeground(this.myAwtTooltip);
    }

    public Color getTextBackground() {
        return this.myTextBg != null ? this.myTextBg : this.getTooltipManager().getTextBackground(this.myAwtTooltip);
    }

    public Color getLinkForeground() {
        return this.getTooltipManager().getLinkForeground(this.myAwtTooltip);
    }

    public boolean isOwnBorderAllowed() {
        return this.getTooltipManager().isOwnBorderAllowed(this.myAwtTooltip);
    }

    public Color getBorderColor() {
        return this.myBorderColor != null ? this.myBorderColor : this.getTooltipManager().getBorderColor(this.myAwtTooltip);
    }

    public Insets getBorderInsets() {
        return this.myBorderInsets;
    }

    public boolean isOpaqueAllowed() {
        return this.getTooltipManager().isOpaqueAllowed(this.myAwtTooltip);
    }

    public Font getTextFont() {
        return this.myFont != null ? this.myFont : this.getTooltipManager().getTextFont(this.myAwtTooltip);
    }

    public String getUlImg() {
        return this.getTooltipManager().getUlImg(this.myAwtTooltip);
    }

    public boolean isContentActive() {
        return this.myContentActive;
    }

    public boolean isExplicitClose() {
        return this.myExplicitClose;
    }

    public HintHint setContentActive(boolean active) {
        this.myContentActive = active;
        return this;
    }

    public HintHint setHighlighterType(boolean highlighter) {
        this.myQuickHint = highlighter;
        return this;
    }

    public boolean isHighlighterType() {
        return this.myQuickHint;
    }

    private IdeTooltipManager getTooltipManager() {
        return IdeTooltipManager.getInstance();
    }

    public void initStyle(Component c2, boolean includeChildren) {
        if (includeChildren) {
            for (Component component : UIUtil.uiTraverser((Component)c2)) {
                this.doInit(component);
            }
        } else {
            this.doInit(c2);
        }
    }

    private void doInit(Component c2) {
        c2.setForeground(this.getTextForeground());
        c2.setBackground(this.getTextBackground());
        c2.setFont(this.getTextFont());
        if (c2 instanceof JComponent) {
            JComponent jc = (JComponent)c2;
            jc.setOpaque(this.isOpaqueAllowed());
            jc.setBorder(this.isOwnBorderAllowed() ? BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(0, 5, 0, 5)) : null);
        }
    }

    public void initStyleFrom(JComponent component) {
        this.setTextFg(component.getForeground()).setTextBg(component.getBackground()).setFont(component.getFont());
        this.myTextFg = component.getForeground();
        this.myTextBg = component.getBackground();
        this.myFont = component.getFont();
    }

    public HintHint setTextFg(Color textFg) {
        this.myTextFg = textFg;
        return this;
    }

    public HintHint setTextBg(Color textBg) {
        this.myTextBg = textBg;
        return this;
    }

    public HintHint setFont(Font font) {
        this.myFont = font;
        return this;
    }

    public HintHint setBorderColor(Color borderColor) {
        this.myBorderColor = borderColor;
        return this;
    }

    public HintHint setBorderInsets(Insets insets) {
        this.myBorderInsets = insets;
        return this;
    }

    public int getCalloutShift() {
        return this.myCalloutShift;
    }

    public HintHint setCalloutShift(int calloutShift) {
        this.myCalloutShift = calloutShift;
        return this;
    }

    public HintHint setExplicitClose(boolean explicitClose) {
        this.myExplicitClose = explicitClose;
        return this;
    }

    public HintHint setPositionChangeShift(int x, int y) {
        this.myPositionChangeX = x;
        this.myPositionChangeY = y;
        return this;
    }

    public int getPositionChangeX() {
        return this.myPositionChangeX;
    }

    public int getPositionChangeY() {
        return this.myPositionChangeY;
    }

    public boolean isShowImmediately() {
        return this.myShowImmediately;
    }

    public HintHint setShowImmediately(boolean showImmediately) {
        this.myShowImmediately = showImmediately;
        return this;
    }

    public boolean isAnimationEnabled() {
        return this.myAnimationEnabled;
    }

    public HintHint setAnimationEnabled(boolean enabled) {
        this.myAnimationEnabled = enabled;
        return this;
    }

    public boolean isRequestFocus() {
        return this.myRequestFocus;
    }

    public HintHint setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
        return this;
    }
}

