/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceForwardForm;
import com.intellij.slicer.SliceHandler;
import com.intellij.slicer.SliceManager;
import java.util.List;
import javax.swing.JComponent;

public class SliceForwardHandler
extends SliceHandler {
    public SliceForwardHandler() {
        super(false);
    }

    @Override
    public SliceAnalysisParams askForParams(PsiElement element, boolean dataFlowToThis, SliceManager.StoredSettingsBean storedSettingsBean, String dialogTitle) {
        AnalysisScope analysisScope = new AnalysisScope(element.getContainingFile());
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        Project myProject = element.getProject();
        final SliceForwardForm form = new SliceForwardForm();
        form.init(storedSettingsBean.showDereferences);
        AnalysisUIOptions analysisUIOptions = new AnalysisUIOptions();
        analysisUIOptions.loadState(storedSettingsBean.analysisUIOptions);
        List<ModelScopeItem> items = BaseAnalysisActionDialog.standardItems(myProject, analysisScope, module, element);
        BaseAnalysisActionDialog dialog2 = new BaseAnalysisActionDialog(dialogTitle, "Analyze scope", myProject, items, analysisUIOptions, true){

            @Override
            protected JComponent getAdditionalActionSettings(Project project) {
                return form.getComponent();
            }
        };
        if (!dialog2.showAndGet()) {
            return null;
        }
        storedSettingsBean.analysisUIOptions.loadState(analysisUIOptions);
        storedSettingsBean.showDereferences = form.isToShowDerefs();
        AnalysisScope scope = dialog2.getScope(analysisUIOptions, analysisScope, myProject, module);
        SliceAnalysisParams params = new SliceAnalysisParams();
        params.scope = scope;
        params.dataFlowToThis = dataFlowToThis;
        params.showInstanceDereferences = form.isToShowDerefs();
        return params;
    }
}

