/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.http;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.impl.http.LocalFileFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class JumpFromRemoteFileToLocalAction
extends AnAction {
    private final HttpVirtualFile myFile;
    private final Project myProject;

    JumpFromRemoteFileToLocalAction(HttpVirtualFile file2, Project project) {
        super("Find Local File", "", AllIcons.General.AutoscrollToSource);
        this.myFile = file2;
        this.myProject = project;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            JumpFromRemoteFileToLocalAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(this.myFile.getFileInfo().getState() == RemoteFileState.DOWNLOADED);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Collection<VirtualFile> files2;
        if (e == null) {
            JumpFromRemoteFileToLocalAction.$$$reportNull$$$0(1);
        }
        if ((files2 = JumpFromRemoteFileToLocalAction.findLocalFiles(this.myProject, Urls.newFromVirtualFile((VirtualFile)this.myFile), this.myFile.getName())).isEmpty()) {
            Messages.showErrorDialog((Project)this.myProject, (String)("Cannot find local file for '" + this.myFile.getUrl() + "'"), (String)CommonBundle.getErrorTitle());
            return;
        }
        if (files2.size() == 1) {
            JumpFromRemoteFileToLocalAction.navigateToFile(this.myProject, (VirtualFile)ContainerUtil.getFirstItem(files2, null));
        } else {
            JBPopupFactory.getInstance().createPopupChooserBuilder(new ArrayList<VirtualFile>(files2)).setRenderer((ListCellRenderer)new ColoredListCellRenderer<VirtualFile>(){

                protected void customizeCellRenderer(@NotNull JList<? extends VirtualFile> list2, VirtualFile value, int index, boolean selected2, boolean hasFocus) {
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    FileAppearanceService.getInstance().forVirtualFile(value).customize((SimpleColoredComponent)this);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/fileEditor/impl/http/JumpFromRemoteFileToLocalAction$1", "customizeCellRenderer"));
                }
            }).setTitle("Select Target File").setMovable(true).setItemsChosenCallback(selectedValues -> {
                for (VirtualFile value : selectedValues) {
                    JumpFromRemoteFileToLocalAction.navigateToFile(this.myProject, value);
                }
            }).createPopup().showUnderneathOf(e.getInputEvent().getComponent());
        }
    }

    private static Collection<VirtualFile> findLocalFiles(Project project, Url url, String fileName2) {
        for (LocalFileFinder finder : (LocalFileFinder[])LocalFileFinder.EP_NAME.getExtensions()) {
            VirtualFile file2 = finder.findLocalFile(url, project);
            if (file2 == null) continue;
            return Collections.singletonList(file2);
        }
        return FilenameIndex.getVirtualFilesByName(project, fileName2, GlobalSearchScope.allScope((Project)project));
    }

    private static void navigateToFile(Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            JumpFromRemoteFileToLocalAction.$$$reportNull$$$0(2);
        }
        PsiNavigationSupport.getInstance().createNavigatable(project, file2, -1).navigate(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileEditor/impl/http/JumpFromRemoteFileToLocalAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateToFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

