/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.navigator;

import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/diagnostic/hprof/navigator/RootReason;", "", "description", "", "(Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "toString", "Companion", "intellij.platform.ide.impl"})
public final class RootReason {
    @NotNull
    private final String description;
    @NotNull
    private static final RootReason rootUnknown;
    @NotNull
    private static final RootReason rootGlobalJNI;
    @NotNull
    private static final RootReason rootLocalJNI;
    @NotNull
    private static final RootReason rootJavaFrame;
    @NotNull
    private static final RootReason rootNativeStack;
    @NotNull
    private static final RootReason rootStickyClass;
    @NotNull
    private static final RootReason rootThreadBlock;
    @NotNull
    private static final RootReason rootThreadObject;
    @NotNull
    private static final RootReason rootMonitorUsed;
    public static final Companion Companion;

    @NotNull
    public String toString() {
        return this.description;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    private RootReason(String description) {
        this.description = description;
    }

    static {
        Companion = new Companion(null);
        rootUnknown = new RootReason("Unknown");
        rootGlobalJNI = new RootReason("Global JNI");
        rootLocalJNI = new RootReason("Local JNI");
        rootJavaFrame = new RootReason("Java Frame");
        rootNativeStack = new RootReason("Native stack");
        rootStickyClass = new RootReason("Sticky class");
        rootThreadBlock = new RootReason("Thread block");
        rootThreadObject = new RootReason("Thread object");
        rootMonitorUsed = new RootReason("Monitor used");
    }

    public /* synthetic */ RootReason(String description, DefaultConstructorMarker $constructor_marker) {
        this(description);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006 "}, d2={"Lcom/intellij/diagnostic/hprof/navigator/RootReason$Companion;", "", "()V", "rootGlobalJNI", "Lcom/intellij/diagnostic/hprof/navigator/RootReason;", "getRootGlobalJNI", "()Lcom/intellij/diagnostic/hprof/navigator/RootReason;", "rootJavaFrame", "getRootJavaFrame", "rootLocalJNI", "getRootLocalJNI", "rootMonitorUsed", "getRootMonitorUsed", "rootNativeStack", "getRootNativeStack", "rootStickyClass", "getRootStickyClass", "rootThreadBlock", "getRootThreadBlock", "rootThreadObject", "getRootThreadObject", "rootUnknown", "getRootUnknown", "createClassDefinitionReason", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "createConstantReferenceReason", "constantNumber", "", "createStaticFieldReferenceReason", "staticFieldName", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final RootReason createConstantReferenceReason(@NotNull ClassDefinition classDefinition, int constantNumber) {
            Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
            return new RootReason("Class constant: " + classDefinition.getName() + ".#" + constantNumber, null);
        }

        @NotNull
        public final RootReason createStaticFieldReferenceReason(@NotNull ClassDefinition classDefinition, @NotNull String staticFieldName) {
            Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
            Intrinsics.checkParameterIsNotNull((Object)staticFieldName, (String)"staticFieldName");
            return new RootReason("Static field: " + classDefinition.getName() + '.' + staticFieldName, null);
        }

        @NotNull
        public final RootReason createClassDefinitionReason(@NotNull ClassDefinition classDefinition) {
            Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
            return new RootReason("Class definition: " + classDefinition.getName(), null);
        }

        @NotNull
        public final RootReason getRootUnknown() {
            return rootUnknown;
        }

        @NotNull
        public final RootReason getRootGlobalJNI() {
            return rootGlobalJNI;
        }

        @NotNull
        public final RootReason getRootLocalJNI() {
            return rootLocalJNI;
        }

        @NotNull
        public final RootReason getRootJavaFrame() {
            return rootJavaFrame;
        }

        @NotNull
        public final RootReason getRootNativeStack() {
            return rootNativeStack;
        }

        @NotNull
        public final RootReason getRootStickyClass() {
            return rootStickyClass;
        }

        @NotNull
        public final RootReason getRootThreadBlock() {
            return rootThreadBlock;
        }

        @NotNull
        public final RootReason getRootThreadObject() {
            return rootThreadObject;
        }

        @NotNull
        public final RootReason getRootMonitorUsed() {
            return rootMonitorUsed;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

